import { Routes, RouterModule } from "@angular/router";
import { AuthGuard } from "../../../core/auth/auth.gurad";
import { NgModule } from "@angular/core";
import { ConstantURLs } from "../../../shared/models/constants/constant-URL";
import { MasterDataDynamiMainComponent } from "./master-data-dynami-main/master-data-dynami-main.component";
import { WebFormListComponent } from "../../../shared/components/web-form/web-form-list/web-form-list.component";
import { DynamicFormCardComponent } from "./dynamic-form-card/dynamic-form-card.component";
import { WebFormListMasterDataComponent } from "../../../shared/components/web-form/web-form-list-master-data/web-form-list-master-data.component";
import { GeographicalLocationHierarchyComponent } from "./geographical-location-hierarchy/geographical-location-hierarchy/geographical-location-hierarchy.component";
import { CompanyDetailsListComponent } from "../../../echo/properties/company-details/company-details-list/company-details-list.component";

const masterDataDynamicRouting: Routes = [
  {
    path: "",
    canActivate: [AuthGuard],
    component: MasterDataDynamiMainComponent,
    children: [
      {
        path: '',
        component: DynamicFormCardComponent
      },
      {
        path:  ConstantURLs.geoLocationURL,
        component: GeographicalLocationHierarchyComponent
      },
      {
        path: ConstantURLs.companyDetailsURL,
        canActivate: [AuthGuard],
        component: CompanyDetailsListComponent
      },
      {
        path: ':id',   //: dynamic parameter here
        component: WebFormListMasterDataComponent
      },
    ]
  },
  {
    path: "*",
    canActivate: [AuthGuard],
    redirectTo: "/" + ConstantURLs.dataDefinitionURL + "/" + ConstantURLs.masterURL, pathMatch: "full"
  }
];
@NgModule({
  imports: [RouterModule.forChild(masterDataDynamicRouting)],
  exports: [RouterModule]
})
export class MasterDataDynamicRoutingModule {
}
