import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { TranslateModule } from "@ngx-translate/core";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { NgSelectModule } from "@ng-select/ng-select";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { DragDropModule } from "@angular/cdk/drag-drop";
import { MatPaginatorModule } from "@angular/material/paginator";
import { AngularMultiSelectModule } from "angular2-multiselect-dropdown";
import { MasterDataDynamicRoutingModule } from "./master-data-dynamic-routing.module";
import { SharedModule } from "../../../shared/shared.module";
import { MasterDataDynamiMainComponent } from "./master-data-dynami-main/master-data-dynami-main.component";
import { DynamicFormCardComponent } from "./dynamic-form-card/dynamic-form-card.component";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";
import { GeographicalLocationHierarchyComponent } from "./geographical-location-hierarchy/geographical-location-hierarchy/geographical-location-hierarchy.component";
import { MatIconModule } from "@angular/material/icon";
import { MatButtonModule } from "@angular/material/button";
import { MatTreeModule } from "@angular/material/tree";
import { CustAppBannersEntryComponent } from "../../../echo/properties/cust-app-banners-entry/cust-app-banners-entry.component";
import { NotificationManagementEntryComponent } from "../../customer-app-properties/notification-management/notification-management-entry/notification-management-entry.component";
import { CustAppSettingsEntryComponent } from "../../../echo/properties/cust-app-settings-entry/cust-app-settings-entry.component";
import { CompanyDetailsListComponent } from "../../../echo/properties/company-details/company-details-list/company-details-list.component";
import { CompanyDetailsEntryComponent } from "../../../echo/properties/company-details/company-details-entry/company-details-entry.component";

@NgModule({
  declarations: [MasterDataDynamiMainComponent,
     DynamicFormCardComponent,GeographicalLocationHierarchyComponent,CustAppBannersEntryComponent,
     NotificationManagementEntryComponent,CustAppSettingsEntryComponent,
     CompanyDetailsListComponent, CompanyDetailsEntryComponent

     ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    SharedModule,
    TranslateModule.forChild(),
    NgbModule,
    NgSelectModule,
    NgMultiSelectDropDownModule,
    DragDropModule,
    MatPaginatorModule,
    AngularMultiSelectModule,
    MasterDataDynamicRoutingModule,
    NgOptionHighlightModule,
    MatIconModule,
    MatTreeModule,
    MatButtonModule,
  ],
  exports: [],
})
export class MasterDataDynamicModule {}
