import { Component, OnDestroy, OnInit } from '@angular/core';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { CoreSession } from '../../../core/core.session';
import { ShepherdService } from 'angular-shepherd';
import {  TourService } from '../../../shared/shepherd-config/shepherd-config';
import { Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { NavBarService } from '../../../core/sidebar/sidebar.service';
import { ComponentVisitService } from '../../../shared/shepherd-config/trackTour.service';
import { Subscription } from 'rxjs';

@Component({
  selector: 'app-master-data-home',
  templateUrl: './master-data-home.component.html',
  styleUrls: ['./master-data-home.component.css']
})
export class MasterDataHomeComponent implements OnInit ,OnDestroy {

  masterDataModules: any[];
  constructor(private sessionDataProvider: SessionDataProvider,
    public coreSession: CoreSession,
    private router:Router
  , private  shepherdService: ShepherdService,
private translateService :TranslateService,
private navService : NavBarService,
private tourService: TourService,
private componentVisitService: ComponentVisitService) { }
private tourSubscription: Subscription;

  ngOnDestroy(): void {
    if (this.tourStartTimeout) {

      clearTimeout(this.tourStartTimeout);
    }
    if(this.shepherdService.tourObject)
      this.shepherdService.cancel()

    this.navService.tourStatus = false;
    this.componentVisitService.markComponentVisited('master-home');

    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }

  }
  private tourStartTimeout: any;
  ngAfterViewInit() {
  this.startTour(false)
  }
  startTour(forceTour?:boolean){

    if(!forceTour)
    if (this.tourService.isTourCompletedForComponent('master-home')) {
      // Tour already completed for this component
      return;
    }


    this.tourStartTimeout = setTimeout(() => {
      if(this.tourService.isFirstTour()||forceTour){

        const elementSelectors = this.masterDataModules.map((_, i) => `#column-${i}`);
        const titles = this.masterDataModules.map(item => this.getTitle(item.menuId));
        const texts = this.masterDataModules.map(item => this.getText(item.menuId));

        const steps = this.tourService.generateSteps(
          elementSelectors,
          titles,
          texts,
          true
        );
      this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
      this.shepherdService.modal = true;
      this.shepherdService.addSteps(steps);
      this.shepherdService.start();
    }
    }, this.tourService.isFirstTour()||forceTour?1000:2500);
  }

  private getTitle(menuId: string): string {
    switch (menuId) {
      case '100-010':
        return 'Desc_Advance_Settings';
      case '100-001':
        return 'Desc_User_Definition';
      case '100-006':
        return 'Desc_Prices_And_Offers';
      case '100-003':
        return 'Desc_Customers';
      case '100-004':
        return 'Desc_Products';
      default:
        return '';
    }
  }

  private getText(menuId: string): string {
    switch (menuId) {
      case '100-010':
        return 'Desc_content_Advance-settings';
      case '100-001':
        return 'Desc_content_Users';
      case '100-006':
        return 'Desc_content_Prices-Offers';
      case '100-003':
        return 'Desc_content_Customers';
      case '100-004':
        return 'Desc_content_Products';
      default:
        return '';
    }
  }



  ngOnInit() {
    this.tourSubscription = this.tourService.startTourMain$.subscribe(() => {
      this.startTour(true);
    });

    this.coreSession.SetTitle('Master Data');
    this.prepareMasterDataModules();
  }

  prepareMasterDataModules() {
    this.masterDataModules = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable.filter(x => x.menuId != undefined && x.parentMenuId === '100' && x.isParentMenu)) {
      if (menu.menuId === '100-010') { // master data
        let index = this.sessionDataProvider.allMenusAvailable.findIndex(x => x.parentMenuId === menu.menuId);
        if (index >= 0) { // check if master data has childs dynamic menues
          let masterDataMenu = {
            title: menu.menuName,
            image: menu.icon,
            link: menu.url,
            menuId: menu.menuId
          };
          this.masterDataModules.push(masterDataMenu);
        }
      } else {
        let index = this.sessionDataProvider.allMenusAvailable.findIndex(x => x.parentMenuId === menu.menuId);

        let masterDataMenu = {
          title: menu.menuName,
          image: menu.icon,
          link: menu.url + '/' + this.sessionDataProvider.allMenusAvailable[index].url,
          menuId: menu.menuId
        };
        this.masterDataModules.push(masterDataMenu);
      }
    }
    // this.masterDataModules =  [
    //   {
    //     title: 'Desc_Item_Managment',
    //     image: 'https://image.flaticon.com/icons/svg/679/679720.svg',
    //     link: ConstantURLs.ItemManagmentURL,
    //   },
    //   {
    //     title: 'Desc_Employee_Management',
    //     image: 'https://image.flaticon.com/icons/svg/944/944034.svg',
    //     link: ConstantURLs.employeeManagmentURL,
    //   },
    //   {
    //     title: 'Desc_Warehouse_Managment',
    //     image:'https://image.flaticon.com/icons/svg/407/407877.svg',
    //     link: ConstantURLs.WarehouseManagmentURL,
    //   },
    //   {
    //     title: 'Desc_Customer_Managment',
    //     image:'https://image.flaticon.com/icons/svg/1528/1528669.svg',
    //     link: ConstantURLs.customerManagmentURL,

    //   },
    //   {
    //     title: 'Desc_Machine_Managment',
    //     image:'https://image.flaticon.com/icons/svg/181/181291.svg',
    //     link: ConstantURLs.machineManagmentURL,
    //   },
    //   {
    //     title: 'Extended Properties',
    //     image:'https://image.flaticon.com/icons/svg/1157/1157044.svg',
    //     link: ConstantURLs.extendedPropertiesURL,
    //   },
    //   {
    //     title: 'Desc_Customer',
    //     image:'https://image.flaticon.com/icons/svg/1545/1545289.svg',
    //     link: ConstantURLs.customerURL,
    //   }
    // ]
  }
}
