import { NgModule } from "@angular/core";
import { RouterModule, Routes } from "@angular/router";
import { ConstantURLs } from "../../shared/models/constants/constant-URL";
import { MasterDataHomeComponent } from "./master-data-home/master-data-home.component";
import { AuthGuard } from "../../core/auth/auth.gurad";



const MasterDataRouting: Routes = [
  {
    path: "",
    canActivate: [AuthGuard],
    component: MasterDataHomeComponent
  },
  // dynamicFormURL
  {
    path: ConstantURLs.dynamicFormMainURL,
    loadChildren: () => import('./survey-managment/survey.managment.module').then(m => m.SurveyManagmentModule)
  },
  // Products
  {
    path: ConstantURLs.productUrl,
    loadChildren: () => import('./item-managment/items-managment.module').then(m => m.ItemsManagmentModule)
  },
  // staffURL
  {
    path: ConstantURLs.staffURL,
    loadChildren: () => import('./employee-managment/employee.module').then(m => m.EmployeeModule)
  },

  // customers
  {
    path: ConstantURLs.customerURL,
    loadChildren: () => import('./customers/customer.module').then(m => m.CustomerModule)
  },
  // priceAndOfferURL
  {
    path: ConstantURLs.priceAndOfferURL,
    loadChildren: () => import('./prices-and-offers-management/prices-and-offers.module').then(m => m.PricesAndOffersModule)
  },
   // masterDataURL
   {
    path: ConstantURLs.masterURL,
    loadChildren: () => import('./master-data-dynamic-main/master-data-dynamic.module').then(m => m.MasterDataDynamicModule)
  },
];

@NgModule({
  imports: [RouterModule.forChild(MasterDataRouting)],
  exports: [RouterModule]
})
export class MasterDataRoutingModule { }
