import { HttpErrorResponse } from '@angular/common/http';
import { Component, EventEmitter, Input, OnInit, Output, ViewChild } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { Observable } from 'rxjs/Rx';
import { CoreSession } from '../../../../../core/core.session';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { SelectCustomersComponent } from '../../../../../shared/components/customers/select-customers/select-customers.component';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { CustomerGroupModel } from '../../../../../shared/models/customer/customer.group.model';
import { IDateTimePickerProperties } from '../../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../../../shared/models/dateTimeModel/date-time.model';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { DiscountValueTypes } from '../../../../../shared/models/enums/discount-value-types.enum';
import { MultiSelectionOperation, RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { CustomerService } from '../../../../../shared/services/data-definition/customer/customers.service';
import { DiscountService } from '../../../../../shared/services/data-definition/prices-and-offers/discount.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { HeaderDiscountTypes } from '../../../../../shared/models/enums/HeaderDiscount-type-enum';
import { HeaderDiscountService } from '../../../../../shared/services/data-definition/prices-and-offers/header-discount.service';
import { CommonButtonStyles } from '../../../../../shared/models/enums/common-button-styles.enum';

@Component({
  selector: 'app-header-discount-entry',
  templateUrl: './header-discount-entry.component.html',
  styleUrls: ['./header-discount-entry.component.css']
})
export class HeaderDiscountEntryComponent implements OnInit {
// #region [Declaration]

@Input() events: Observable<void>;
@Input() selectedDiscountObj: any = {};
@Input() isViewMode = false;
@Input() isEditMode = false;
@Input() isAddMode = false;
@ViewChild("selectCustomerDialog", { static: true }) selectCustomerDialog: SelectCustomersComponent;
saveBtnSubscription: any;
@Output() onSaveCompleted = new EventEmitter();
headerDiscountDataForm: FormGroup = new FormGroup({});
navLinks: any[];
navBarSelectedIndex: number = 0;
isAllCustomersChecked: boolean = false;

maxIndex: number = 0;

appliedOnLevelId: number;
appliedOnLevelName: string;

fromToDateProperties: IDateTimePickerProperties = {
  label: 'Desc_Date',
  formControlName: 'fromToDate',
  isCalendarOnly: true,
  isRange: true,
  labelHidden: true,
};
addedCustomersList: any[] = [];
copyOfAddedCustomers: any[] = [];
customersDataSource: SharedTableResult = {
  totalItems: 0,
  data: [],
};

dataSource: SharedTableResult = {
  totalItems: 0,
  data: []
};

showSelectCustomersDialog = false;
customersSharedTabel: ITableProperties = {
  pageSize: 50,
  showPaginator: true,
  showSearch: true,
  isOnline: false,
  showSearchBtn: false,
  isMultiSelection: true,
  showNewBtn: true,
  showEditButton: false,
  newBtnCaption: 'Desc_Add',
  rowOperations:[],
  multiSelectionOperations:[
    {
      operation: MultiSelectionOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e',
      style: CommonButtonStyles.Negative.valueOf()
    }
  ],
  columns: [
    { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
    { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' }
  ]
};
//groups
groups: CustomerGroupModel[] = [];
channels: any[] = [];
allGroupsList: CustomerGroupModel[] = [];
allChannelsList: any[] = [];
dropdownSettings = {
  singleSelection: false,
  idField: 'groupId',
  textField: 'groupCodeName',
  selectAllText: '',
  unSelectAllText: '',
  position: 'top',
  allowSearchFilter: true,
  searchPlaceholderText: '',
  itemsShowLimit: 2
};
dropdownChannelSettings = {
  singleSelection: false,
  idField: 'channelSubChannelIds',
  textField: 'channelSubChannelDescriptions',
  selectAllText: '',
  unSelectAllText: '',
  position: 'top',
  allowSearchFilter: true,
  searchPlaceholderText: '',
  itemsShowLimit: 2,
};
//end groups

selectedOrganizationId = null;
selectedSalesMode = null;
selectedHeaderDiscountType = null;
forceCustomerOrganizationSelection = false;
forceOrganizationFilterForCustomersGroups = false;

organizationIdsString: string = null;
// #endregion

// #region [Constructor & Initialization]
constructor(private translateService: TranslateService,
  private coreSession: CoreSession,
  private headerdiscountService : HeaderDiscountService,
  private sessionData: SessionDataProvider,
  private customerService: CustomerService) { }

ngOnInit() {
  this.dropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
  this.dropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
  this.dropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

  this.dropdownChannelSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
  this.dropdownChannelSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
  this.dropdownChannelSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

  this.forceCustomerOrganizationSelection = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceCustomerOrganizationSelection).toLowerCase() === "true"
  this.forceOrganizationFilterForCustomersGroups = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true"
  this.subscribeSaveClick();
  this.initForm();
  this.populateGroupsList();
  this.populateChannelsSubChannelsList();
  this.prepareNavigation();
  this.navLinks[0].isActive = true;
  this.customersSharedTabel.rowOperations.push({
    operation: RowOperation.delete,
    title: 'Desc_Delete',
    icon: 'fa-solid fa-trash',
    color: '#f1685e',
  });

  if(this.isViewMode) {
    this.headerDiscountDataForm.disable();
    this.customersSharedTabel.showNewBtn = false;
    this.customersSharedTabel.rowOperations = [];
    this.customersSharedTabel.multiSelectionOperations = [];
    this.customersSharedTabel.isMultiSelection = false;
  }

  if (this.isEditMode || this.isViewMode) {
    this.populateDiscountData();
  }

  if (this.isEditMode || this.isViewMode) {
    let today = new Date();
    if (today.getTime() <= new Date(this.selectedDiscountObj.startDate).getTime()) {
      this.fromToDateProperties.min = new Date(today);
    } else {
      this.fromToDateProperties.min = new Date(this.selectedDiscountObj.startDate);
    }
  }
  else {
    this.fromToDateProperties.min = new Date();
  }
}
initForm() {
  this.headerDiscountDataForm = new FormGroup({
    typeId : new FormControl(HeaderDiscountTypes.NormalHeader),
    saleModeId : new FormControl(null, Validators.required),
    headerDiscountId: new FormControl({ value: null, disabled: true }),
    discountTypeId: new FormControl(null, Validators.required),
    organizationId: new FormControl(null, Validators.required),
    fromToDate: new FormControl([], Validators.required),
    value: new FormControl(null, Validators.required),
    groupsControl: new FormControl([]),
    channelControl: new FormControl(),
    allCustomers: new FormControl(false),
  }
  );
}
ngOnDestroy() {
  this.saveBtnSubscription.unsubscribe();
}
//#endregion

//#region [Form Getters]
get HeaderDiscountTypeIdControl() {
  return this.headerDiscountDataForm.get('typeId');
}
get SalesModeControl() {
  return this.headerDiscountDataForm.get('saleModeId');
}
get discountTypeIdControl() {
  return this.headerDiscountDataForm.get('discountTypeId');
}
get HeaderDiscountValueControl() {
  return this.headerDiscountDataForm.get('value');
}
get discountOrganizationControl() {
  return this.headerDiscountDataForm.get('organizationId');
}
get discountFromToDateControl() {
  return this.headerDiscountDataForm.get('fromToDate');
}
get discountGroupsControl() {
  return this.headerDiscountDataForm.get('groupsControl');
}
get discountChannelControl() {
  return this.headerDiscountDataForm.get('channelControl');
}
get discountAllCustomersControl() {
  return this.headerDiscountDataForm.get('allCustomers');
}

//#endregion

fillFormInEditMode() {
  this.HeaderDiscountTypeIdControl.setValue(this.selectedDiscountObj.typeId);
  this.SalesModeControl.setValue(this.selectedDiscountObj.saleModeId);
  this.discountTypeIdControl.setValue(this.selectedDiscountObj.discountTypeId);
  this.HeaderDiscountValueControl.setValue(this.selectedDiscountObj.value);
  this.discountOrganizationControl.setValue(this.selectedDiscountObj.organizationId);
  this.discountFromToDateControl.setValue([new Date(String(this.selectedDiscountObj.startDate)), new Date(String(this.selectedDiscountObj.endDate))]);
  this.discountChannelControl.setValue(this.selectedDiscountObj.appliedChannels);
  this.discountGroupsControl.setValue(this.selectedDiscountObj.appliedGroups);
  this.discountAllCustomersControl.setValue(this.selectedDiscountObj.allCustomers);
  console.log(this.selectedDiscountObj.startDate);
  console.log(new Date(String(this.selectedDiscountObj.startDate)));
}

fillCustomersList() {
  this.customersDataSource = {
    totalItems: this.addedCustomersList.length,
    data: this.addedCustomersList
  };
}
fillDiscountObj() {
  if (this.isAddMode) {
    this.selectedDiscountObj = {};
    this.selectedDiscountObj.headerDiscountId = -1;
  }
  this.selectedDiscountObj.typeId = this.HeaderDiscountTypeIdControl.value;
  this.selectedDiscountObj.saleModeId = this.SalesModeControl.value;
  this.selectedDiscountObj.discountTypeId = this.discountTypeIdControl.value;
  this.selectedDiscountObj.value = +this.HeaderDiscountValueControl.value;
  this.selectedDiscountObj.organizationId = this.headerDiscountDataForm.value.organizationId;
  this.selectedDiscountObj.dateModelRange = [];
  if(this.discountFromToDateControl.value && this.discountFromToDateControl.value.length == 2){
    this.selectedDiscountObj.dateModelRange.push(this.coreSession.getDateTimeModel(this.discountFromToDateControl.value[0]));
    this.selectedDiscountObj.dateModelRange.push(this.coreSession.getDateTimeModel(this.discountFromToDateControl.value[1]));
  }


  this.selectedDiscountObj.appliedGroups = this.discountGroupsControl.value ? this.discountGroupsControl.value : [];
  this.selectedDiscountObj.appliedChannels = this.discountChannelControl.value ? this.discountChannelControl.value : [];
  this.selectedDiscountObj.appliedCustomers = this.addedCustomersList ? this.addedCustomersList : [];
  this.selectedDiscountObj.allCustomers = this.discountAllCustomersControl.value === null ? false : this.discountAllCustomersControl.value;
}

populateDiscountData() {
  this.coreSession.ModalLoading.Show();
  this.selectedHeaderDiscountType = this.selectedDiscountObj.typeId;
  this.selectedSalesMode = this.selectedDiscountObj.saleModeId;
  this.selectedOrganizationId = this.selectedDiscountObj.organizationId;

  this.headerdiscountService.getHeaderDiscountData(this.selectedDiscountObj.headerDiscountId).subscribe(
    (response: ResponseModel) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0){
          this.selectedDiscountObj.appliedChannels = response.data.appliedChannels;
          this.selectedDiscountObj.appliedGroups = response.data.appliedGroups;
          this.selectedDiscountObj.appliedCustomers = !response.data.appliedCustomers ? [] : response.data.appliedCustomers;
          this.addedCustomersList = this.selectedDiscountObj.appliedCustomers;

      this.fillCustomersList();
      this.fillFormInEditMode();

      if (this.forceOrganizationFilterForCustomerGroups()) {
        this.populateGroupsList();
      }
      this.onAllCustomersChange();
      } else {
        this.dataSource = {
          totalItems: 0,
          data: []
        };
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },(error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
}
onDeleteAppliedCustomer(deletedOutlet: any) {
  var index = this.addedCustomersList.findIndex(x => x.customerId === deletedOutlet.customerId && x.outletId === deletedOutlet.outletId);
  if (index >= 0) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.addedCustomersList.splice(index, 1);
          this.fillCustomersList();
        }
      });
  }
}
prepareNavigation() {
  this.navLinks = [
    {
      label: 'Desc_Header_Discount_Definition',
      index: 0,
      isActive: false,
      hidden: false,
      disable: false
    },
    {
      label: 'Desc_Applied_To_Cap',
      index: 1,
      isActive: false,
      hidden: false,
      disable: false
    }
  ];
}
populateGroupsList() {
  this.allGroupsList = [];
  let organizationId = this.discountOrganizationControl ? this.discountOrganizationControl.value : "";
  this.customerService.getAllCustomerGroups(organizationId).subscribe(result => {
    this.allGroupsList = result.data;
  });
}
populateChannelsSubChannelsList() {
  this.customerService.GetAllCustomerChannels(null).subscribe(result => {
    this.allChannelsList = result;
  });
}
subscribeSaveClick() {
  this.saveBtnSubscription = this.events.subscribe(() => {
    this.onSaveClicked();
  });
}
onSaveClicked() {
  this.coreSession.markFormGroupTouched(this.headerDiscountDataForm as FormGroup);
  this.fillDiscountObj();
  if (this.headerDiscountDataForm.invalid) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
    return;
  }
  if (!this.isAllCustomersChecked && ((this.headerDiscountDataForm.value.groupsControl == null || (this.headerDiscountDataForm.value.groupsControl != null && this.headerDiscountDataForm.value.groupsControl.length == 0)) && (this.headerDiscountDataForm.value.channelControl == null || (this.headerDiscountDataForm.value.channelControl != null && this.headerDiscountDataForm.value.channelControl.length == 0))
    && (!this.addedCustomersList || this.addedCustomersList.length == 0) )) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgApplyDiscountToCustomer));
      return;
  }
  if (this.selectedDiscountObj.discountTypeId == DiscountValueTypes.Percentage.valueOf() && this.selectedDiscountObj.value > 100) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgValidValuePercentageDiscount));
    return;
  }
  this.coreSession.ModalLoading.Show();
  console.log(this.selectedDiscountObj);
  this.headerdiscountService.saveHeaderDiscount(this.selectedDiscountObj, this.isEditMode).subscribe(
    response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
        this.onSaveCompleted.emit();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
    (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
  );
}
closeSelectCustomersDialog() {
  this.showSelectCustomersDialog = false;
  if (this.isEditMode) {
    this.coreSession.SetTitle('Edit Discount');
  } else {
    this.coreSession.SetTitle('Add Discount');
  }
}
afterAddingSelectedCustomers(selectedCustomers) {
  // remove is check property
  selectedCustomers.forEach(x => {
    x.isChecked = false;
  });
  this.addedCustomersList = selectedCustomers;
  this.fillCustomersList();
  this.closeSelectCustomersDialog();
}
onCreationDateSelected(date: any[]) {

}
onChangeOrganizationId(organization) {
  var mustClearAssigmentData = false;
  if (this.forceCustomerOrganizationSelection && (
    (this.addedCustomersList && this.addedCustomersList.length > 0) ||
    (this.discountGroupsControl.value != null && this.discountGroupsControl.value.length > 0) ||
    (this.discountChannelControl.value != null && this.discountChannelControl.value.length > 0)
  )) {
    mustClearAssigmentData = true;
  }

  var mustClearGroupDetails = this.forceOrganizationFilterForCustomersGroups != null;
  if (mustClearAssigmentData) {
    // set old selected value
    this.discountOrganizationControl.setValue(this.selectedOrganizationId);
    var msg = ConstantMessages.MsgClearInsertedDetailsWarning;
    if (mustClearAssigmentData && !mustClearGroupDetails) {
      ConstantMessages.MsgChangeOrganizationRemoveApplyData;
    }
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(msg), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.selectedOrganizationId = organization ? organization.organizationId : null;
          this.discountOrganizationControl.setValue(this.selectedOrganizationId);
          if (mustClearAssigmentData) {
            this.discountGroupsControl.setValue([]);
            this.discountChannelControl.setValue([]);
            this.addedCustomersList = [];
            this.fillCustomersList();
          }
        }
      });
  } else {
    this.selectedOrganizationId = organization ? organization.organizationId : null;
  }
}
ChangeDataView(index: number) {
  if (index > 0) {
    this.discountOrganizationControl.markAsTouched();
    if (this.discountOrganizationControl.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
  }
  this.navLinks.forEach(a => a.isActive = false);
  this.navBarSelectedIndex = index;
  this.navLinks[index].isActive = true;
}
onRowOperationForCustomers(event: any) {
  switch (event.operation) {
    case RowOperation.delete:
      var list = [];
      list.push(event.object);
      this.onDeleteAppliedCustomer(list);
      break;
  }
}
onMultiSelectionOperationForCustomers(event: any) {
  switch (event.operation) {
    case MultiSelectionOperation.delete: {
      this.onDeleteSelectedAddedCustomers(event.object);
      break;
    }
  }
}
onDeleteSelectedAddedCustomers(selectedCustomersList) {
  this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
    (res: DialogResult) => {
      if (res === DialogResult.Yes) {
        selectedCustomersList.forEach(customer => {
          var index = this.addedCustomersList.findIndex(x => x.customerId === customer.customerId && x.outletId === customer.outletId);
          if (index >= 0) {
            this.addedCustomersList.splice(index, 1);
          }
        });
      }
      this.fillCustomersList();
    });
}
openSelectCustomersDialog() {
    this.copyOfAddedCustomers = null;
    this.copyOfAddedCustomers = cloneDeep(this.addedCustomersList);
    this.showSelectCustomersDialog = true;
    this.selectCustomerDialog.showDialog(this.discountOrganizationControl.value).then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedCustomers(result)
        } else {
          this.closeSelectCustomersDialog();
        }
      });
}
onAllCustomersChange() {
  console.log(this.discountAllCustomersControl.value);
  this.isAllCustomersChecked = this.discountAllCustomersControl.value;
  if (this.isAllCustomersChecked) {
    this.navLinks[1].disable = true;
  }
  else {
    this.navLinks[1].disable = false;
  }
}
forceOrganizationFilterForCustomerGroups() {
  return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true"
}

}
