import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { Subject } from 'rxjs';
import { CoreSession } from '../../../../../core/core.session';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { IDateTimePickerProperties } from '../../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../../../shared/models/dateTimeModel/date-time.model';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { MultiSelectionOperation, RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { GeneralFilter } from '../../../../../shared/models/general/generalFilter.model';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import * as cloneDeep from 'lodash/cloneDeep';
import { HeaderDiscountService } from '../../../../../shared/services/data-definition/prices-and-offers/header-discount.service';

@Component({
  selector: 'app-header-discount-list',
  templateUrl: './header-discount-list.component.html',
  styleUrls: ['./header-discount-list.component.css']
})
export class HeaderDiscountListComponent implements OnInit {

   //#region [Declaration]
   tableData: ITableProperties = {
     pageSize: 25,
     showPaginator: true,
     showSearch: true,
     isOnline: true,
     showSearchBtn: true,
     showNewBtn: true,
     isMultiSelection: false,
     rowOperations: [],
     multiSelectionOperations: [

     ],
     columns: [
       {
         title: 'Desc_Header_Discount_Type',
         key: 'typeIdName',
         isSortable: true,
         width: '20%'
       },
       {
         title: 'Desc_Discount_Type',
         key: 'discountType',
         isSortable: true,
         width: '15%'
       },
       {
         title: 'Desc_Value',
         key: 'value',
         isSortable: true,
         width: '10%'
       },
       {
         title: 'Desc_Vendor',
         key: 'organizationName',
         isSortable: true,
         width: '15%'
       },
       {
         title: 'Desc_Start_Date',
         key: 'startDate',
         isSortable: true,
         isExpiryDate: true,
         width: '15%'
       },
       {
         title: 'Desc_End_Date',
         key: 'endDate',
         isSortable: true,
         isExpiryDate: true,
         width: '15%'
       },
       {
        title: 'Desc_Sales_Mode',
        key: 'salesModeName',
        isSortable: true,
        width: '10%'
      }
     ]
   };
   modalReference: any;
   dataSource: SharedTableResult = {
     totalItems: 0,
     data: []
   };
   generalFilter: GeneralFilter = {
     customListFilter: {
       searchFilter: '',
       page: 0,
       pageSize: 25
     },
     discountTypeId:-1,
     organizationId: -1,
     groupId: -1,
     customerId: -1,
     outletId: -1,
     saleModeId: -1,
     typeId : -1,
     allCustomers : false,
     dateModel: null,
     toDate: null
   };
   saveSubject: Subject<void> = new Subject<void>();
   showSlider = false;
   isEditMode = false;
   isViewMode = false;
   isAddMode = false;
   selectedDiscount: any = {};

   discountFilterForm: FormGroup;
   isFilterOpend: boolean = false;

   toDate: DateTimeModel = null;
   fromDate: DateTimeModel = null;

   fromDateProperties: IDateTimePickerProperties = {
     label: 'Desc_Start_Date',
     formControlName: 'fromDate',
     isCalendarOnly: true,
     labelHidden: false,
   };

   toDateProperties: IDateTimePickerProperties = {
     label: 'Desc_End_Date',
     formControlName: 'toDate',
     isCalendarOnly: true,
     labelHidden: false,
   };
   //#endregion

   //#region [Constructor & Initialization]
   constructor(
     public coreSession: CoreSession,
     private translateService: TranslateService,
     private headerDiscountService : HeaderDiscountService
     ) { }

   ngOnInit() {
     this.coreSession.SetTitle('HeaderDiscounts');
     this.tableData.showNewBtn = this.coreSession.checkActivitiesAvailability(ConstantURLs.HeaderDiscountURL, MenuActions.Add);
     this.initForm();
     this.checkActionAvailability();
     this.populateHeaderDiscounts();
   }

   initForm() {
     this.discountFilterForm = new FormGroup({
       discountTypeId : new FormControl(),
       typeId : new FormControl(),
       saleModeId : new FormControl(),
       organizationId: new FormControl(),
       customerGroupId: new FormControl(),
       customerId: new FormControl(),
       outletId: new FormControl(),
       fromDate: new FormControl(null),
       toDate: new FormControl(null),
       allCustomers : new FormControl(false)
     });
   }
   //#endregion

   //#region [Methods]
   populateHeaderDiscounts() {
     this.coreSession.ModalLoading.Show();
     this.headerDiscountService.getHeaderDiscounts(this.generalFilter).subscribe(
       (response: ResponseModel) => {
         this.coreSession.ModalLoading.Hide();
         if (response.status != null && response.status >= 0) {
           this.dataSource = {
             totalItems: response.data.totalItems,
             data: response.data.data
           };
         } else {
           this.dataSource = {
             totalItems: 0,
             data: []
           };
           this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),response.message);
         }
       }, (error: HttpErrorResponse) => {
         this.coreSession.ModalLoading.Hide();
         this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
       });
   }

   deleteHeaderDiscount(headerdiscountId: number) {
    this.coreSession.ModalLoading.Show();
     this.headerDiscountService.deleteHeaderDiscount(headerdiscountId)
       .subscribe(
         (response: ResponseModel) => {
           this.coreSession.ModalLoading.Hide();
           if (response.status != null && response.status >= 0) {
             this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
             this.populateHeaderDiscounts();
           } else {
             this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
           }
         },
         (error: HttpErrorResponse) => {
           this.coreSession.ModalLoading.Hide();
           this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
         }
       );
   }
   checkActionAvailability() {
     if (this.coreSession.checkActivitiesAvailability(ConstantURLs.HeaderDiscountURL, MenuActions.Delete)) {
       this.tableData.rowOperations.push(
         {
           operation: RowOperation.delete,
           title: 'Desc_Delete',
           icon: 'fa-solid fa-trash',
           color: '#f1685e'
         });
     }
     if (this.coreSession.checkActivitiesAvailability(ConstantURLs.HeaderDiscountURL, MenuActions.Edit)) {

         this.tableData.rowOperations.push({
           operation: RowOperation.edit,
           title: "Desc_Edit",
           icon: "fa-regular fa-pen-to-square",
           color: "#12344d"
         });
     }
     if (this.coreSession.checkActivitiesAvailability(ConstantURLs.HeaderDiscountURL, MenuActions.View)) {
      this.tableData.rowOperations.push(
        {
          operation: RowOperation.View,
          title: 'Desc_View',
          icon: "fa-regular fa-eye",
          color: '#12344d',
        });
    }
   }

   //#endregion

   //#region [Filter events]
   applySerachFilterOnFind() {
     this.generalFilter.customListFilter.page = 0;
     this.generalFilter.customListFilter.pageSize = this.tableData.pageSize;
     this.generalFilter.dateModel = this.fromDate == null ? null : this.fromDate;
     this.generalFilter.toDate = this.toDate == null ? null : this.toDate;
     this.generalFilter.typeId = this.discountFilterForm.get('typeId').value == null ? -1 : this.discountFilterForm.get('typeId').value,
     this.generalFilter.discountTypeId = this.discountFilterForm.get('discountTypeId').value == null ? -1 : this.discountFilterForm.get('discountTypeId').value,
     this.generalFilter.saleModeId = this.discountFilterForm.get('saleModeId').value == null ? -1 : this.discountFilterForm.get('saleModeId').value,
     this.generalFilter.organizationId = this.discountFilterForm.get('organizationId').value == null ? -1 : this.discountFilterForm.get('organizationId').value,
     this.generalFilter.groupId = this.discountFilterForm.get('customerGroupId').value == null ? -1 : this.discountFilterForm.get('customerGroupId').value,
     this.generalFilter.customerId = this.discountFilterForm.get('customerId').value == null ? -1 : this.discountFilterForm.get('customerId').value,
     this.generalFilter.outletId = this.discountFilterForm.get('outletId').value == null ? -1 : this.discountFilterForm.get('outletId').value,
     this.generalFilter.allCustomers = this.discountFilterForm.get('allCustomers').value == null ? false : this.discountFilterForm.get('allCustomers').value;
     this.populateHeaderDiscounts();
   }
   onReset() {
     this.fromDate = null;
     this.toDate = null;
     this.discountFilterForm.reset();
     this.discountFilterForm.get('allCustomers').setValue(false);
   }

   onToDateSelected(date: any) {
     this.toDate = null;
     this.toDate = date;
   }
   onFromDateSelected(date: any) {
     this.fromDate = null;
     this.fromDate = date;
   }
   //#endregion

   //#region [Slider events]
   closeSlider() {
     this.showSlider = false;
     this.isViewMode = false;
     this.isEditMode = false;
     this.isAddMode  = false;
   }
   onSaveClick() {
     this.saveSubject.next();
   }
   onDiscountSaved() {
     this.closeSlider();
     this.populateHeaderDiscounts();
   }
   //#endregion

   //#region [Shared table events]
   onRowClicked(event: any) {
     switch (event.operation) {
       case RowOperation.delete:
         (event.object);
         if (this.coreSession.checkActivitiesAvailability(ConstantURLs.HeaderDiscountURL, MenuActions.Delete)) {
           this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
             .then(
               (result: DialogResult) => {
                 if (result === DialogResult.Yes) {
                   this.deleteHeaderDiscount(event.object.headerDiscountId);
                 }
               }
             );
         }
         break;
       case RowOperation.edit:
         if (this.coreSession.checkActivitiesAvailability(ConstantURLs.HeaderDiscountURL, MenuActions.Edit)) {
           this.isEditMode = true;
           this.selectedDiscount = cloneDeep(event.object);
           this.showSlider = true;
         }
         break;
       case RowOperation.View:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.HeaderDiscountURL, MenuActions.View)) {
            this.isViewMode = true;
            this.selectedDiscount = cloneDeep(event.object);
            this.showSlider = true;
        }
         break;
     }
   }
   onMultiSelectionOperation(event: any) {
     switch (event.operation) {

       case MultiSelectionOperation.delete:
         break;
     }
   }
   onTableFilterChanged(query: any) {
     ('onTableFilterChanged');
     (query);

     this.generalFilter.customListFilter = query;
     this.populateHeaderDiscounts();
   }
   onNewBtnClicked() {
     this.isAddMode = true;
     this.isEditMode = false;
     this.isViewMode = false;
     this.selectedDiscount = undefined;
     this.showSlider = true;
   }
   //#endregion
   openFilter() {
     this.isFilterOpend = !this.isFilterOpend;
     this.onReset();
   }

   openEditScreen() {
    this.showSlider = true;
  }


}
