import { Component, OnInit, Input, Output, EventEmitter, ViewChild } from '@angular/core';
import { Observable, Subject } from 'rxjs/Rx';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { IDateTimePickerProperties } from '../../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../../../shared/models/dateTimeModel/date-time.model';
import { ITextInput } from '../../../../../shared/models/shared-table/custom-list.interface';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { CoreSession } from '../../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { PricesAndOffersService } from '../../prices-and-offers.service';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { DiscountFOC } from '../../../../../shared/models/enums/discount-foc.enum';
import { ItemService } from '../../../../../shared/services/data-definition/product/item.service';
import { SelectCustomersComponent } from '../../../../../shared/components/customers/select-customers/select-customers.component';
import { CustomerGroupModel } from '../../../../../shared/models/customer/customer.group.model';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { CustomerService } from '../../../../../shared/services/data-definition/customer/customers.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { HttpErrorResponse } from '@angular/common/http';
import { EmailFileModel } from '../../../../../shared/models/email/email.model';
import { saveAs } from "file-saver";
import { ApprovalCycleOperations } from '../../../../../shared/models/enums/approval-cycle-operations-enum';
import { OfferAppliedOptions } from '../../../../../shared/models/enums/offer-applied-options.enum';
import { PackGroupService } from '../../../../../shared/services/data-definition/product/pack-group.service';
import { DiscountService } from '../../../../../shared/services/data-definition/prices-and-offers/discount.service';
import { DiscountAppliedOn } from '../../../../../shared/models/enums/discount-applied-on.enum';
import { DiscountTypes } from '../../../../../shared/models/enums/discount-types.enum';
import { DiscountValueTypes } from '../../../../../shared/models/enums/discount-value-types.enum';
import { Router } from '@angular/router';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../../shared/shepherd-config/trackTour.service';
@Component({
  selector: 'app-discount-definition-entry',
  templateUrl: './discount-definition-entry.component.html',
  styleUrls: ['./discount-definition-entry.component.css']
})
export class DiscountDefinitionEntryComponent implements OnInit {

  // #region [Declaration]

  @Input() events: Observable<void>;
  @Input() selectedDiscountObj: any = {};
  @Input() isEditMode = false;
  @Input() isCloneMode = false;
  @Input() isAddMode = false;
  @ViewChild("selectCustomerDialog", { static: true }) selectCustomerDialog: SelectCustomersComponent;
  saveBtnSubscription: any;
  @Output() onSaveCompleted = new EventEmitter();
  discountDataForm: FormGroup = new FormGroup({});
  discountNameOtherLanguages: any[] = [];
  typeId: number;
  navLinks: any[];
  navBarSelectedIndex: number = 0;
  applyOnDivisionLevel: boolean = false;
  applyOnAllItems: boolean = false;
  isAllCustomersChecked: boolean = false;
  isTypeLoading: boolean = false;
  typesList: any[] = [];
  salesOrderTypeList: any[] = [];
  isSalesOrderTypeLoading: boolean = false;

  maxIndex: number = 0;
  isDiscountTypeLoading: boolean = false;
  discountTypesDataSource: any[];

  isPackGroupLoading: boolean = false;
  packGroups: any[] = [];

  appliedOnLevelId: number;
  appliedOnLevelName: string;

  isAppliedOnLoading: boolean = false;
  appliedOnList: any[] = [];
  selectedPackId = null;

  attachedFiles: EmailFileModel[] = [];
  deletedFiles: string[] = [];
  fromToDate: DateTimeModel[] = [];
  fromToDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Date',
    formControlName: 'fromToDate',
    isCalendarOnly: true,
    isRange: true,
    labelHidden: true,
  };
  discountNameInput: ITextInput = {
    formControlName: "discountName",
    placeHolder: "Desc_Discount_Name",
    label: "Desc_Discount_Name"
  };
  formData: FormData = new FormData();
  addedCustomersList: any[] = [];
  copyOfAddedCustomers: any[] = [];
  customersDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };
  showSelectCustomersDialog = false;
  customersSharedTabel: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showNewBtn: true,
    showEditButton: false,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' }
    ]
  };
  //groups
  groups: CustomerGroupModel[] = [];
  channels: any[] = [];
  allGroupsList: CustomerGroupModel[] = [];
  allChannelsList: any[] = [];
  dropdownSettings = {
    singleSelection: false,
    idField: 'groupId',
    textField: 'groupCodeName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 2
  };
  dropdownChannelSettings = {
    singleSelection: false,
    idField: 'channelSubChannelIds',
    textField: 'channelSubChannelDescriptions',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 2
  };
  allSDCsList: any[] = []; // Sales Distribution Channels
  sdcDropdownSetting = {
    singleSelection: false,
    idField: 'sdcId',
    textField: 'sdcCodeName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 2
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  //end groups

  selectedOrganizationId = null;
  ForceCustomerOrganizationSelection = false;

  appliedOptionsList: any[] = [];
  appliedOptionsDropdownSettings = {
    singleSelection: false,
    idField: 'optionId',
    textField: 'optionName',
    selectAllText: '',
    unSelectAllText: '',
    allowSearchFilter: false,
    itemsShowLimit: 2,
  };
  ForceOrganizationFilterForPackGroups = false;
  direction: any;
  enableSalesDistributionChannel: boolean = false;
  organizationIdsString: string = null;
  // #endregion

  // #region [Constructor & Initialization]
  constructor(private translateService: TranslateService,
    private coreSession: CoreSession,
    private pricesAndOffersService: PricesAndOffersService,
    private discountService: DiscountService,
    private sessionData: SessionDataProvider,
    private customerService: CustomerService,
    private packGroupService: PackGroupService,
  private router :Router,private shepherdService :ShepherdService,
  private tourService: TourService,
private componentVisitService: ComponentVisitService
) { }

    ngAfterViewInit() {
      var elementSelectors = ['#descount-def','#descount-date',
      '#Type-def','#descount-Type','#descount-Value','#Apply_In_Options'
      ,'#vendor-def','#Range-def','#Apply_All_Items','#Apply_All_Customers'
    ,'#appliedOnLevelId','#Attachment']
        // this.startTour(elementSelectors,'MainData')
       }
       private tourStartTimeout: any;
       showItemSharedTable = false
       startTour(elementSelectors,type){
        this.tourStartTimeout=    setTimeout((data=>{

          if(!this.tourService.isFirstTour()){
            if(type=='ApplyToData'){
              this.showItemSharedTable = true
            }
          }
          else{
            if (this.tourService.isTourCompletedForComponent('discount-entry')) {
              if(type=='ApplyToData'){
                this.showItemSharedTable = true
              }
              return;
            }
            const titles = [];
          const texts = [];
          for (let index = 0; index < elementSelectors.length; index++) {
            const { title, text } = this.getTitleAndText(index,type);
            titles.push(title);
            texts.push(text);
          }
            const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
            this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
            this.shepherdService.modal = true;
            this.shepherdService.addSteps(steps);
            this.shepherdService.start();

            this.shepherdService.tourObject.on('complete', () => {
             if(type=='ApplyToData'){
               this.showItemSharedTable = true
             }
         });
         this.shepherdService.tourObject.on('cancel', () => {
           if(type=='ApplyToData'){
             this.showItemSharedTable = true
           }
       });
          }
         }),1000)
       }
       getTitleAndText(index: number,type): { title: string, text: string } {
        let title = '';
        let text = '';

        if (type == 'MainData') {
          switch (index) {
            case 0:
              title = "Add Image";
              text = "Here you can upload image from device.";
              break;
            case 1:
              title = "Item Definition";
              text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
              break;
            case 2:
              title = "Brand and Description";
              text = "You can select brand and define a new description.";
              break;
            case 3:
              title = "Inactive Toggle";
              text = "These buttons make the item as inactive and the customer can't show it.";
              break;
            case 4:
              title = "Is New Toggle";
              text = "Make this item as new to show in new section.";
              break;
            case 5:
              title = "Is New Toggle";
              text = "Make this item as new to show in new section.";
              break;
            default:
              title = `Step ${index + 1}`;
              text = `Content in default at bottom.`;
          }
        } else if (type === 'Item') {
          switch (index) {
            case 0:
              title = "New Pack";
              text = 'Here you can define your items and pack for it.';
              break;
            case 1:
              title = "Add Image";
              text = "Here you can upload image from device.";
              break;
            case 2:
              title = "Item Definition";
              text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
              break;
            case 3:
              title = "Brand and Description";
              text = "You can select brand and define a new description.";
              break;
            case 4:
              title = "Inactive Toggle";
              text = "These buttons make the item as inactive and the customer can't show it.";
              break;
            case 5:
              title = "Is New Toggle";
              text = "Make this item as new to show in new section.";
              break;
            default:
              title = `Step ${index + 1}`;
              text = `Content in default at bottom.`;
          }
        }
        else if (type == 'ApplyToData') {
          switch (index) {
            case 0:
              title = "New Pack";
              text = 'Here you can define your items and pack for it.';
              break;
            case 1:
              title = "Add Image";
              text = "Here you can upload image from device.";
              break;
            case 2:
              title = "Item Definition";
              text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
              break;
            case 3:
              title = "Brand and Description";
              text = "You can select brand and define a new description.";
              break;
            case 4:
              title = "Inactive Toggle";
              text = "These buttons make the item as inactive and the customer can't show it.";
              break;
            case 5:
              title = "Is New Toggle";
              text = "Make this item as new to show in new section.";
              break;
            default:
              title = `Step ${index + 1}`;
              text = `Content in default at bottom.`;
          }
        }else if (type === 'Attachment') {
          switch (index) {
            case 0:
              title = "New Pack";
              text = 'Here you can define your items and pack for it.';
              break;
            case 1:
              title = "Add Image";
              text = "Here you can upload image from device.";
              break;
            case 2:
              title = "Item Definition";
              text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
              break;
            case 3:
              title = "Brand and Description";
              text = "You can select brand and define a new description.";
              break;
            case 4:
              title = "Inactive Toggle";
              text = "These buttons make the item as inactive and the customer can't show it.";
              break;
            case 5:
              title = "Is New Toggle";
              text = "Make this item as new to show in new section.";
              break;
            default:
              title = `Step ${index + 1}`;
              text = `Content in default at bottom.`;
          }
        }else if (type === 'Contact') {
          switch (index) {
            case 0:
              title = "New Pack";
              text = 'Here you can define your items and pack for it.';
              break;
            case 1:
              title = "Add Image";
              text = "Here you can upload image from device.";
              break;
            case 2:
              title = "Item Definition";
              text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
              break;
            case 3:
              title = "Brand and Description";
              text = "You can select brand and define a new description.";
              break;
            case 4:
              title = "Inactive Toggle";
              text = "These buttons make the item as inactive and the customer can't show it.";
              break;
            case 5:
              title = "Is New Toggle";
              text = "Make this item as new to show in new section.";
              break;
            default:
              title = `Step ${index + 1}`;
              text = `Content in default at bottom.`;
          }
        }
        return { title, text };
      }
  ngOnInit() {
    this.dropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.dropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.dropdownChannelSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropdownChannelSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.dropdownChannelSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.sdcDropdownSetting.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.sdcDropdownSetting.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.sdcDropdownSetting.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.appliedOptionsDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.appliedOptionsDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);

    this.ForceCustomerOrganizationSelection = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceCustomerOrganizationSelection).toLowerCase() === "true"
    this.ForceOrganizationFilterForPackGroups = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForPackGroups).toLowerCase() === "true"
    this.enableSalesDistributionChannel = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSalesDistributionChannel).toLowerCase() === "true"
    if(this.enableSalesDistributionChannel) {
      this.dropdownChannelSettings.itemsShowLimit = 1;
      this.sdcDropdownSetting.itemsShowLimit = 1;
      this.dropdownSettings.itemsShowLimit = 1;
    }
    this.direction = this.coreSession.isRTL;
    this.subscribeSaveClick();
    this.initForm();
    this.populateGroupsList();
    this.populateChannelsSubChannelsList();
    if (this.enableSalesDistributionChannel) this.fillSDCsList();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
    this.customersSharedTabel.rowOperations.push({
      operation: RowOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e',
    });
    this.fillTypesList();
    this.fillAppliedOptionsList();
    this.fillDiscountTypes();
    this.fillSalesOrderTypes();
    if (!this.ForceOrganizationFilterForPackGroups) {
      this.fillPackGroups();
    }
    this.fillAppliedOnList();
    if ((this.isEditMode || this.isCloneMode) && this.selectedDiscountObj && this.selectedDiscountObj.discountId > 0) {
      this.populateDiscountData();
    }
    this.dataSource = {
      totalItems: 0,
      data: []
    };
    if (this.isEditMode || this.isCloneMode) {
      let today = new Date();
      if (today.getTime() <= new Date(this.selectedDiscountObj.startDate).getTime()) {
        this.fromToDateProperties.min = new Date(today);
      } else {
        this.fromToDateProperties.min = new Date(this.selectedDiscountObj.startDate);
      }
    }
    else {
      this.fromToDateProperties.min = new Date();
      if (!this.discountIsRangeControl.value) {
        this.discountFromValueControl.disable({ onlySelf: true, emitEvent: false });
        this.discountFromValueControl.setValue(null);
        this.discountFromValueControl.updateValueAndValidity();
        this.discountToValueControl.disable({ onlySelf: true, emitEvent: false });
        this.discountToValueControl.setValue(null);
        this.discountToValueControl.updateValueAndValidity();

      }
    }
  }
  initForm() {
    // this code is to set multi select value in (view mode, edit mode, clone mode)
    var optionsList = [];
    if (!this.isAddMode && this.selectedDiscountObj) {
      if (this.selectedDiscountObj.offerAppliedOptions.includes(OfferAppliedOptions.Sonic.valueOf().toString())) {
        optionsList.push({ optionId: OfferAppliedOptions.Sonic.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Sonic_App_Caption) });
      }
      if (this.selectedDiscountObj.offerAppliedOptions.includes(OfferAppliedOptions.NearExpiry.valueOf().toString())) {
        optionsList.push({ optionId: OfferAppliedOptions.NearExpiry.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Near_Expiry_Operation_Caption) });
      }
    }
    this.discountDataForm = new FormGroup({
      discountId: new FormControl({ value: null, disabled: true }),
      discountCode: new FormControl(null, Validators.required),
      discountName: new FormControl(null, Validators.required),
      typeId: new FormControl(null, Validators.required),
      discountTypeId: new FormControl(null, Validators.required),
      offerAppliedOptions: new FormControl(optionsList, Validators.required),
      organizationId: new FormControl(null),
      fromToDate: new FormControl([], Validators.required),
      amount: new FormControl(null, Validators.required),
      divisionId: new FormControl({ value: null, disabled: true }),
      packGroupId: new FormControl({ value: null, disabled: true }),
      packId: new FormControl(null),
      groupsControl: new FormControl([]),
      channelControl: new FormControl(),
      sdcsList: new FormControl([]),
      allItems: new FormControl(false),
      appliedOnLevelId: new FormControl(DiscountAppliedOn.Pack),
      allCustomers: new FormControl(false),
      isRange: new FormControl(false),
      fromValue: new FormControl(null),
      toValue: new FormControl(null),
      salesOrderTypeId: new FormControl(null),
      priority: new FormControl(null),
    }
    );
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('discount-entry');
  }
  //#endregion

  // #region [Methods]
  isDivisionLevel() {
    return this.applyOnDivisionLevel = this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true";
  }
  fillPackGroups() {
    var filter = {
      getGroupsHavingSamePackQuantity: false,
      selectedOraganizationIds: this.selectedOrganizationId ? this.selectedOrganizationId.toString() : ''
    }
    this.packGroupService.getPackGroups(filter).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.packGroups = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  fillTypesList() {
    this.isTypeLoading = true;
    this.typesList = [];
    this.typesList.push({ typeId: DiscountFOC.Discount.valueOf(), typeName: this.translateService.instant(ConstantMessages.Desc_Discount) });
    this.typesList.push({ typeId: DiscountFOC.FOC.valueOf(), typeName: this.translateService.instant(ConstantMessages.Desc_FOC) });
    this.typesList.push({ typeId: DiscountTypes.PriceDiscount.valueOf(), typeName: this.translateService.instant(ConstantMessages.Desc_Price_Discount) });
    this.isTypeLoading = false;
  }
  fillAppliedOptionsList() {
    this.appliedOptionsList.push({ optionId: OfferAppliedOptions.Sonic.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Sonic_App_Caption) });
    this.appliedOptionsList.push({ optionId: OfferAppliedOptions.NearExpiry.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Near_Expiry_Operation_Caption) });
  }
  fillDiscountTypes() {
    this.discountService.getDiscountTypes().subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.discountTypesDataSource = response.data;
          (this.discountTypesDataSource);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  fillSalesOrderTypes() {
    this.discountService.getSalesOrderTypes().subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.salesOrderTypeList = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  //#region [Form Getters]
  get discountCodeControl() {
    return this.discountDataForm.get('discountCode');
  }
  get discountNameControl() {
    return this.discountDataForm.get('discountName');
  }
  get typeIdControl() {
    return this.discountDataForm.get('typeId');
  }
  get discountTypeIdControl() {
    return this.discountDataForm.get('discountTypeId');
  }
  get discountAmountControl() {
    return this.discountDataForm.get('amount');
  }
  get discountOrganizationControl() {
    return this.discountDataForm.get('organizationId');
  }
  get discountFromToDateControl() {
    return this.discountDataForm.get('fromToDate');
  }
  get discountDivisionIdControl() {
    return this.discountDataForm.get('divisionId');
  }
  get discountPackGroupIdControl() {
    return this.discountDataForm.get('packGroupId');
  }
  get discountPackIdControl() {
    return this.discountDataForm.get('packId');
  }
  get discountAllItemsControl() {
    return this.discountDataForm.get('allItems');
  }
  get discountAppliedOnLevelIdControl() {
    return this.discountDataForm.get('appliedOnLevelId');
  }
  get discountGroupsControl() {
    return this.discountDataForm.get('groupsControl');
  }
  get discountChannelControl() {
    return this.discountDataForm.get('channelControl');
  }
  get discountAllCustomersControl() {
    return this.discountDataForm.get('allCustomers');
  }
  get discountOfferAppliedOptionsControl() {
    return this.discountDataForm.get('offerAppliedOptions');
  }
  get discountIsRangeControl() {
    return this.discountDataForm.get('isRange');
  }
  get discountFromValueControl() {
    return this.discountDataForm.get('fromValue');
  }
  get discountToValueControl() {
    return this.discountDataForm.get('toValue');
  }
  get salesOrderTypeIdControl() {
    return this.discountDataForm.get('salesOrderTypeId');
  }
  get priorityControl() {
    return this.discountDataForm.get('priority');
  }

  //#endregion

  fillFormInEditMode() {
    this.discountCodeControl.setValue(this.selectedDiscountObj.discountCode);
    this.discountNameControl.setValue(this.selectedDiscountObj.discountName);
    this.typeIdControl.setValue(this.selectedDiscountObj.typeId);
    this.discountTypeIdControl.setValue(this.selectedDiscountObj.discountTypeId);
    this.discountAmountControl.setValue(this.selectedDiscountObj.amount);
    this.discountOrganizationControl.setValue(this.selectedDiscountObj.organizationId);
    this.discountFromToDateControl.setValue([this.selectedDiscountObj.startDate, this.selectedDiscountObj.endDate]);
    this.discountDivisionIdControl.setValue(this.selectedDiscountObj.divisionId === -1 ? null : this.selectedDiscountObj.divisionId);
    this.discountPackGroupIdControl.setValue(this.selectedDiscountObj.packGroupId === -1 ? null : this.selectedDiscountObj.packGroupId);
    this.discountPackIdControl.setValue(this.selectedDiscountObj.packId === -1 ? null : this.selectedDiscountObj.packId);
    this.discountAppliedOnLevelIdControl.setValue(this.selectedDiscountObj.appliedOnId === DiscountAppliedOn.AllItems ? null : this.selectedDiscountObj.appliedOnId);
    this.discountAllItemsControl.setValue(this.selectedDiscountObj.appliedOnId == DiscountAppliedOn.AllItems);
    this.discountGroupsControl.setValue(this.selectedDiscountObj.appliedGroups);
    this.discountChannelControl.setValue(this.selectedDiscountObj.appliedChannels);
    this.discountAllCustomersControl.setValue(this.selectedDiscountObj.allCustomers);
    this.discountIsRangeControl.setValue(this.selectedDiscountObj.isRange);
    this.discountFromValueControl.setValue(this.selectedDiscountObj.fromValue);
    this.discountToValueControl.setValue(this.selectedDiscountObj.toValue);
    this.salesOrderTypeIdControl.setValue(this.selectedDiscountObj.salesOrderTypeId == -1 ? null : this.selectedDiscountObj.salesOrderTypeId);
    this.priorityControl.setValue(this.selectedDiscountObj.priority == 0 ? null : this.selectedDiscountObj.priority);
    this.sdcsControl.setValue(this.selectedDiscountObj.sdcsList ? this.selectedDiscountObj.sdcsList : []);
    // disable
    this.discountDivisionIdControl.disable();
    this.discountPackIdControl.disable();
    this.discountPackIdControl.disable();
    if (this.discountAllItemsControl.value) {
      this.applyOnAllItems = true;
      this.discountAppliedOnLevelIdControl.disable();
    }

    if (this.discountAppliedOnLevelIdControl.value === DiscountAppliedOn.Division) {
      this.discountDivisionIdControl.enable();
    }
    if (this.discountAppliedOnLevelIdControl.value === DiscountAppliedOn.PackGroup) {
      this.discountPackGroupIdControl.enable();
    }
    if (this.discountAppliedOnLevelIdControl.value === DiscountAppliedOn.Pack) {
      this.discountPackIdControl.enable();
    }
    if (!this.discountIsRangeControl.value) {
      this.discountFromValueControl.disable({ onlySelf: true, emitEvent: false });
      this.discountFromValueControl.setValue(null);
      this.discountFromValueControl.updateValueAndValidity();
      this.discountToValueControl.disable({ onlySelf: true, emitEvent: false });
      this.discountToValueControl.setValue(null);
      this.discountToValueControl.updateValueAndValidity();

    }
  }
  fillCustomersList() {
    this.customersDataSource = {
      totalItems: this.addedCustomersList.length,
      data: this.addedCustomersList
    };
  }
  fillDiscountObj() {

    if (!this.isEditMode) {
      this.selectedDiscountObj = {};
      this.selectedDiscountObj.discountId = -1;
    }
    this.selectedDiscountObj.discountName = this.discountNameControl.value;
    this.selectedDiscountObj.discountCode = this.discountCodeControl.value;
    this.selectedDiscountObj.typeId = this.typeIdControl.value;
    this.selectedDiscountObj.discountTypeId = this.discountTypeIdControl.value;
    this.selectedDiscountObj.amount = +this.discountAmountControl.value;
    this.selectedDiscountObj.organizationId = -1//this.discountDataForm.value.organizationId;
    this.selectedDiscountObj.allItems = this.discountAllItemsControl.value === null ? false : this.discountAllItemsControl.value;
    if (this.selectedDiscountObj.allItems)
      this.selectedDiscountObj.appliedOnId = DiscountAppliedOn.AllItems.valueOf();
    else
      this.selectedDiscountObj.appliedOnId = +(this.discountAppliedOnLevelIdControl.value == null ? -1 : this.discountAppliedOnLevelIdControl.value);
    this.selectedDiscountObj.divisionId = this.discountDivisionIdControl.value == null ? -1 : this.discountDivisionIdControl.value;
    this.selectedDiscountObj.packGroupId = this.discountPackGroupIdControl.value == null ? -1 : this.discountPackGroupIdControl.value;
    this.selectedDiscountObj.packId = this.discountPackIdControl.value == null ? -1 : this.discountPackIdControl.value
    let descriptions = [];
    if (this.discountNameOtherLanguages) {
      descriptions = this.discountNameOtherLanguages;
      let index = descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
      if (index == -1) {
        descriptions.push({
          languageId: this.coreSession.selectedLanguageId,
          description: this.discountNameControl.value
        });
      } else {
        descriptions[index].description = this.discountNameControl.value
      }
    }
    this.selectedDiscountObj.discountDescriptionLanguages = descriptions;
    if (this.fromToDate && this.fromToDate.length == 2) {
      this.selectedDiscountObj.startDateModel = this.fromToDate[0];
      this.selectedDiscountObj.endDateModel = this.fromToDate[1];
    }
    this.selectedDiscountObj.startDate = null;
    this.selectedDiscountObj.endDate = null;
    this.selectedDiscountObj.appliedGroups = this.discountGroupsControl.value ? this.discountGroupsControl.value : [];
    this.selectedDiscountObj.appliedChannels = this.discountChannelControl.value ? this.discountChannelControl.value : [];
    this.selectedDiscountObj.appliedCustomers = this.addedCustomersList ? this.addedCustomersList : [];
    this.selectedDiscountObj.sdcsList = this.sdcsControl.value ? this.sdcsControl.value : [];
    this.selectedDiscountObj.allCustomers = this.discountAllCustomersControl.value === null ? false : this.discountAllCustomersControl.value;
    this.selectedDiscountObj.salesOrderTypeId = this.salesOrderTypeIdControl.value == null ? -1 : this.salesOrderTypeIdControl.value;
    this.selectedDiscountObj.priority = this.priorityControl.value == null ? -1 : +this.priorityControl.value;
    // Save offerAppliedOptions as comma separated string
    this.selectedDiscountObj.offerAppliedOptions = '';
    if (this.discountOfferAppliedOptionsControl.value && this.discountOfferAppliedOptionsControl.value.length > 0) {
      var optionIdsList = this.discountOfferAppliedOptionsControl.value.map(({ optionId }) => optionId);
      if (optionIdsList && optionIdsList.length > 0) {
        var optionString = optionIdsList.join(',');
        this.selectedDiscountObj.offerAppliedOptions = optionString;
      }
    }

    this.selectedDiscountObj.deletedFiles = this.deletedFiles;
    this.selectedDiscountObj.isRange = this.discountIsRangeControl.value == null ? false : this.discountIsRangeControl.value;
    this.selectedDiscountObj.fromValue = +this.discountFromValueControl.value == null ? -1 : +this.discountFromValueControl.value;
    this.selectedDiscountObj.toValue = +this.discountToValueControl.value == null ? -1 : +this.discountToValueControl.value;

    this.formData = new FormData();
    for (let file of this.attachedFiles) {
      if (file.file)
        this.formData.append("attachedFiles", file.file, file.name);
    }
    // for (let filename of this.deletedFiles) {
    //   this.formData.append("deletedFiles", file.file, file.name);
    // }
    this.formData.append('discountString', JSON.stringify(this.selectedDiscountObj));
  }

  populateDiscountData() {
    this.selectedOrganizationId = this.selectedDiscountObj.organizationId;
    this.fromToDate = [this.selectedDiscountObj.startDateModel, this.selectedDiscountObj.endDateModel];
    let filter = {
      discountId: this.selectedDiscountObj.discountId,
      isClone: this.isCloneMode
    }
    this.discountService.getDiscountData(filter).subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {
          this.discountNameOtherLanguages = response.data.languageDescriptions;
          this.selectedDiscountObj.discountDescriptionLanguages = response.data.languageDescriptions;
          if (this.selectedDiscountObj.discountDescriptionLanguages) {
            let index = this.selectedDiscountObj.discountDescriptionLanguages.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
            if (index >= 0) {
              this.selectedDiscountObj.discountName = this.selectedDiscountObj.discountDescriptionLanguages[index].description;
            }
          }
          if (this.isCloneMode) {
            this.selectedDiscountObj.discountCode = this.translateService.instant(ConstantMessages.Desc_Copied_From) + ' ' + this.selectedDiscountObj.discountCode;
          }
          this.selectedDiscountObj.sdcsList = response.data.sdcsList ? response.data.sdcsList : [];
          this.selectedDiscountObj.appliedChannels = response.data.appliedChannels;
          this.selectedDiscountObj.appliedGroups = response.data.appliedGroups;
          this.selectedDiscountObj.appliedCustomers = !response.data.appliedCustomers ? [] : response.data.appliedCustomers;
          this.addedCustomersList = this.selectedDiscountObj.appliedCustomers;
          this.selectedDiscountObj.attachedFiles = response.data.attachedFiles;
          if (this.selectedDiscountObj.attachedFiles && this.selectedDiscountObj.attachedFiles.length > 0) {
            for (let fileName of this.selectedDiscountObj.attachedFiles) {
              let file = new EmailFileModel();
              var currentPath = document.getElementsByTagName("base")[0].href + 'Resources/attachements/discounts/' + filter.discountId + '/' + fileName;
              let name = currentPath.substr(currentPath.lastIndexOf('/') + 1);
              file.name = name;
              let dotes = name && (name.length > 20) ? '..' : '';
              file.shortName = name.substring(0, 20) + dotes;
              let imgExtensions = ['png', 'jpg', 'jpeg', 'gif']
              file.isImage = imgExtensions.includes(name.split('.').pop()) ? true : false;
              file.path = file.isImage ? currentPath : this.coreSession.getDefaultPathAttachments();
              file.pathFile = file.name;
              this.attachedFiles.push(file);
            }
          }
          this.fillCustomersList();
          this.fillFormInEditMode();
          if (this.ForceOrganizationFilterForPackGroups) {
            this.fillPackGroups();
          }
          if (this.forceOrganizationFilterForCustomerGroups()) {
            this.populateGroupsList();
          }
          if (this.enableSalesDistributionChannel) this.fillSDCsList();

          this.onAllCustomersChange();
          this.onTypeChanged();
        } else {
          this.dataSource = {
            totalItems: 0,
            data: []
          };
          this.discountNameOtherLanguages = [];
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  onDeleteAppliedCustomer(deletedOutlet: any) {
    var index = this.addedCustomersList.findIndex(x => x.customerId === deletedOutlet.customerId && x.outletId === deletedOutlet.outletId);
    if (index >= 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.addedCustomersList.splice(index, 1);
            this.fillCustomersList();
          }
        });
    }
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Discount_Definition',
        index: 0,
        isActive: false,
        hidden: false,
        disable: false
      },
      {
        label: 'Desc_Applied_To_Cap',
        index: 1,
        isActive: false,
        hidden: false,
        disable: false
      }
    ];
  }
  populateGroupsList() {
    this.allGroupsList = [];
    let organizationId = this.discountOrganizationControl ? this.discountOrganizationControl.value : "";
    this.customerService.getAllCustomerGroups(organizationId).subscribe(result => {
      this.allGroupsList = result.data;
    });
  }
  populateChannelsSubChannelsList() {
    this.customerService.GetAllCustomerChannels(null).subscribe(result => {
      this.allChannelsList = result;


    });
  }
  fillSDCsList() {
    this.getSelectedOrganizationIdsAsString();
    this.allSDCsList = [];
    if(this.organizationIdsString != null) {
      var filter = {
        organizationIds: this.organizationIdsString
      };
      this.customerService.getAllSalesDistributionChannels(filter).subscribe(result => {
        this.allSDCsList = result && result.data ? result.data : [];
      });
    }
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  onSaveClicked() {
    if (this.discountDataForm.invalid) {
      this.coreSession.markFormGroupTouched(this.discountDataForm as FormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    this.fillDiscountObj();
    if (this.selectedDiscountObj.isRange) {
      if (this.selectedDiscountObj.fromValue > this.selectedDiscountObj.amount || this.selectedDiscountObj.toValue < this.selectedDiscountObj.amount) {
        let errorMsg = this.translateService.instant(ConstantMessages.MsgValueNotBetweenFromAndToDiscounts);
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), errorMsg);
        return false;
      }
    }
    if (!this.applyOnAllItems && (this.selectedDiscountObj.packGroupId == -1 && this.selectedDiscountObj.packId == -1 && ((this.isDivisionLevel() && this.selectedDiscountObj.divisionId == -1) || !this.isDivisionLevel()))) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgApplyDiscountOnItem));
      return;
    }
    if (!this.isAllCustomersChecked && ((this.discountDataForm.value.groupsControl == null || (this.discountDataForm.value.groupsControl != null && this.discountDataForm.value.groupsControl.length == 0)) && (this.discountDataForm.value.channelControl == null || (this.discountDataForm.value.channelControl != null && this.discountDataForm.value.channelControl.length == 0))
      && (!this.addedCustomersList || this.addedCustomersList.length == 0) )) {
        if(!this.enableSalesDistributionChannel ||
          (this.enableSalesDistributionChannel && (!this.sdcsControl.value || this.sdcsControl.value.length == 0))) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgApplyDiscountToCustomer));
            return;
          }
    }
    if (this.selectedDiscountObj.discountTypeId == DiscountValueTypes.Percentage.valueOf() && this.selectedDiscountObj.amount > 100) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgValidValuePercentageDiscount));
      return;
    }
    this.discountService.saveDiscount(this.formData, this.isEditMode).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
          this.onSaveCompleted.emit();
          if (this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("2")) {
            this.sendEmail(response.data.discountId, response.data.status);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  closeSelectCustomersDialog() {
    this.showSelectCustomersDialog = false;
    if (this.isCloneMode) {
      this.coreSession.SetTitle('Clone Discount');
    } else if (this.isEditMode) {
      this.coreSession.SetTitle('Edit Discount');
    } else {
      this.coreSession.SetTitle('Add Discount');
    }
  }
  afterAddingSelectedCustomers(selectedCustomers) {
    this.addedCustomersList = selectedCustomers;
    this.fillCustomersList();
    this.closeSelectCustomersDialog();
  }
  fillAppliedOnList() {
    this.isAppliedOnLoading = true;
    this.appliedOnList = [];

    this.appliedOnList.push({
      appliedOnLevelId: DiscountAppliedOn.Division.valueOf(),
      appliedOnLevelName: this.translateService.instant(ConstantMessages.Desc_Division),
    });

    this.appliedOnList.push({
      appliedOnLevelId: DiscountAppliedOn.PackGroup.valueOf(),
      appliedOnLevelName: this.translateService.instant(ConstantMessages.Desc_Pack_Groups),
    });
    this.appliedOnList.push({
      appliedOnLevelId: DiscountAppliedOn.Pack.valueOf(),
      appliedOnLevelName: this.translateService.instant(ConstantMessages.Desc_Item),
    });

    this.isAppliedOnLoading = false;
  }

  getAppliedOnLabelDescription() {
    let name = '';
    if (this.isDivisionLevel() && this.discountAppliedOnLevelIdControl.value == DiscountAppliedOn.Division.valueOf())
      name = 'Desc_Division';
    else if (this.discountAppliedOnLevelIdControl.value == DiscountAppliedOn.PackGroup.valueOf())
      name = 'Desc_Pack_Groups';
    else if (this.discountAppliedOnLevelIdControl.value == DiscountAppliedOn.Pack.valueOf())
      name = 'Desc_Item';
    return name;
  }
  // #endregion

  // #region [Discount definition tab events]
  onNameOtherLanguagesTextSubmitted(event) {
    this.discountNameOtherLanguages = event;
  }
  onTypeChanged() {
    if (this.typeIdControl.value == DiscountTypes.PriceDiscount.valueOf()) {
      this.salesOrderTypeIdControl.setValidators(Validators.required);
      this.salesOrderTypeIdControl.updateValueAndValidity();
      this.priorityControl.setValidators(Validators.required);
      this.priorityControl.updateValueAndValidity();
    }
    if (this.typeIdControl.value == DiscountFOC.FOC.valueOf() || this.typeIdControl.value == DiscountTypes.PriceDiscount.valueOf()) {
      this.discountTypeIdControl.setValue(DiscountValueTypes.Percentage);
      this.discountTypeIdControl.disable();
    }
    else {
      this.discountTypeIdControl.enable();
    }
  }
  onCreationDateSelected(date: any[]) {
    if (date)
      this.fromToDate = date;
  }
  onAllItemChange() {
    this.applyOnAllItems = this.discountAllItemsControl.value;
    if (this.applyOnAllItems) {
      this.discountAppliedOnLevelIdControl.setValue(null);
      this.discountDivisionIdControl.setValue(null);
      this.discountPackGroupIdControl.setValue(null);
      this.discountPackIdControl.setValue(null);
      this.discountDivisionIdControl.disable();
      this.discountPackGroupIdControl.disable();
      this.discountPackIdControl.disable();
      this.discountAppliedOnLevelIdControl.disable();
    }
    else {
      this.discountAppliedOnLevelIdControl.enable();
      this.discountAppliedOnLevelIdControl.setValue(DiscountAppliedOn.Pack);
      this.discountPackIdControl.enable();
    }
  }
  onAllCustomersChange() {
    this.isAllCustomersChecked = this.discountAllCustomersControl.value;
    if (this.isAllCustomersChecked) {
      this.navLinks[1].disable = true;
    }
    else {
      this.navLinks[1].disable = false;
    }
  }
  onChangeLanguage(language: number) {
    (language);
  }
  onChangeAppliedOn(appliedOn: number) {
    if (appliedOn == DiscountAppliedOn.Division.valueOf()) {
      this.discountPackGroupIdControl.setValue(null);
      this.discountPackGroupIdControl.disable();
      this.discountPackIdControl.setValue(null);
      this.discountPackIdControl.disable();
      this.discountDivisionIdControl.enable();
    }
    if (appliedOn == DiscountAppliedOn.PackGroup.valueOf()) {
      this.discountDivisionIdControl.setValue(null);
      this.discountDivisionIdControl.disable();
      this.discountPackIdControl.setValue(null);
      this.discountPackIdControl.disable();
      this.discountPackGroupIdControl.enable();
    }
    if (appliedOn == DiscountAppliedOn.Pack.valueOf()) {
      this.discountDivisionIdControl.setValue(null);
      this.discountDivisionIdControl.disable();
      this.discountPackGroupIdControl.setValue(null);
      this.discountPackGroupIdControl.disable();
      this.discountPackIdControl.enable();
    }
  }

  // #endregion

  // #region [Applied to tab events]

  onChangeOrganizationId(organization) {
    var mustClearAssigmentData = false;
    if (this.ForceCustomerOrganizationSelection && (
      (this.addedCustomersList && this.addedCustomersList.length > 0) ||
      (this.discountGroupsControl.value != null && this.discountGroupsControl.value.length > 0) ||
      (this.discountChannelControl.value != null && this.discountChannelControl.value.length > 0)
    )) {
      mustClearAssigmentData = true;
    }

    var mustClearSDCData = this.enableSalesDistributionChannel && this.sdcsControl.value != null && this.sdcsControl.value.length > 0;
    var mustClearGroupDetails = this.ForceOrganizationFilterForPackGroups && this.discountPackGroupIdControl.value != null;
    if (mustClearAssigmentData || mustClearGroupDetails || mustClearSDCData) {
      // set old selected value
      this.discountOrganizationControl.setValue(this.selectedOrganizationId);
      var msg = ConstantMessages.MsgClearInsertedDetailsWarning;
      if (mustClearAssigmentData && !mustClearGroupDetails) {
        ConstantMessages.MsgChangeOrganizationRemoveApplyData;
      }
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(msg), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.selectedOrganizationId = organization ? organization.organizationId : null;
            this.discountOrganizationControl.setValue(this.selectedOrganizationId);

            if (this.ForceOrganizationFilterForPackGroups) {
              // refill groups according to selected organization
              this.packGroups = [];
              this.fillPackGroups();
            }
            if (mustClearAssigmentData) {
              this.discountGroupsControl.setValue([]);
              this.discountChannelControl.setValue([]);
              this.addedCustomersList = [];
              this.fillCustomersList();
            }
            if (mustClearGroupDetails) {
              this.discountPackGroupIdControl.setValue(null);
            }

            if (this.forceOrganizationFilterForCustomerGroups()) {
              this.populateGroupsList();
            }
            if(this.enableSalesDistributionChannel) {
              this.sdcsControl.setValue([]);
              this.fillSDCsList();
            }

          }
        });
    } else {
      this.selectedOrganizationId = organization ? organization.organizationId : null;
      if (this.ForceOrganizationFilterForPackGroups) {
        // refill groups according to selected organization
        this.packGroups = [];
        this.fillPackGroups();
      }
      if(this.enableSalesDistributionChannel) {
        this.fillSDCsList();
      }
    }

    if (this.forceOrganizationFilterForCustomerGroups()) {
      this.populateGroupsList();
    }
  }
  ChangeDataView(index: number) {

    if (index > 0) {
      this.discountOrganizationControl.markAsTouched();
      if (this.discountOrganizationControl.invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
    }
    this.showItemSharedTable = false
    this.navLinks.forEach(a => a.isActive = false);
    this.navBarSelectedIndex = index;
    this.navLinks[index].isActive = true;
    // switch(index){
    //   case 0 :
    //     var elementSelectors = ['#descount-def','#descount-date',
    //     '#Type-def','#descount-Type','#descount-Value','#Apply_In_Options'
    //     ,'#vendor-def','#Range-def','#Apply_All_Items','#Apply_All_Customers'
    //   ,'#appliedOnLevelId','#Attachment']// Target each column by its unique ID
    //     this.startTour(elementSelectors,'MainData')
    //   break
    //     case 1 :
    //       elementSelectors = ['#group-def'] // Target each column by its unique ID
    //       this.startTour(elementSelectors,'ApplyToData')
    //     break


//}



  }
  onRowOperationForCustomers(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.onDeleteAppliedCustomer(event.object);
        break;
    }
  }
  openSelectCustomersDialog() {
    this.copyOfAddedCustomers = null;
    this.copyOfAddedCustomers = cloneDeep(this.addedCustomersList);
    this.showSelectCustomersDialog = true;
    this.selectCustomerDialog.showDialog(this.discountOrganizationControl.value).then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedCustomers(result)
        } else {
          this.closeSelectCustomersDialog();
        }
      });
  }
  onChangeRangeFlag() {
    this.discountDataForm.get('fromValue').reset();
    this.discountDataForm.get('toValue').reset();

    if (this.discountDataForm.get('isRange').value) {
      this.discountDataForm.get('fromValue').setValidators([Validators.required, Validators.min(1)]);
      this.discountDataForm.get('fromValue').updateValueAndValidity();

      this.discountDataForm.get('toValue').setValidators([Validators.required]);
      this.discountDataForm.get('toValue').updateValueAndValidity();

      this.discountDataForm.get('fromValue').enable({ onlySelf: true, emitEvent: false });
      this.discountDataForm.get('toValue').enable({ onlySelf: true, emitEvent: false });
      if (this.selectedDiscountObj.fromValue != -1) {
        this.discountDataForm.get('fromValue').setValue(this.selectedDiscountObj.fromValue);
      }
      if (this.selectedDiscountObj.toValue != -1) {
        this.discountDataForm.get('toValue').setValue(this.selectedDiscountObj.toValue);
      }

    } else {
      this.discountDataForm.get('fromValue').setValidators(Validators.nullValidator);
      this.discountDataForm.get('fromValue').disable({ onlySelf: true, emitEvent: false });
      this.discountDataForm.get('fromValue').updateValueAndValidity();

      this.discountDataForm.get('toValue').setValidators(Validators.nullValidator);
      this.discountDataForm.get('toValue').disable({ onlySelf: true, emitEvent: false });
      this.discountDataForm.get('toValue').updateValueAndValidity();
    }
  }
  //#endregion
  onUploadFiles(file) {
    if (file) {
      let files = file.srcElement.files;
      if (files.length > 0) {
        for (let index = 0; index < files.length; index++) {
          if (files[index].size > 10000000) //10 MB
          {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorLargeSize));
          }
          else {
            let fileObject = new EmailFileModel();
            let reader = new FileReader();
            fileObject.file = files[index];
            fileObject.name = files[index].name;
            let dotes = files[index].name && (files[index].name.length > 20) ? '..' : '';
            fileObject.shortName = files[index].name.substring(0, 20) + dotes;
            fileObject.index = this.maxIndex;
            fileObject.isImage = files[index].type.includes('image') ? true : false;
            reader.onload = (event: ProgressEvent) => {
              if (fileObject.isImage) {
                fileObject.path = (<FileReader>event.target).result;
              } else {
                fileObject.path = this.coreSession.getDefaultPathAttachments();
              }
              fileObject.pathFile = fileObject.name;
            };
            reader.readAsDataURL(file.target.files[index]);
            this.maxIndex++;
            this.attachedFiles.push(fileObject);
          }
        }
      }
    }
  }
  onDeleteFile(file) {
    this.deletedFiles.push(file.name);
    this.attachedFiles.splice(this.attachedFiles.indexOf(file), 1);
  }
  downloadFile(fileName, isEditMode: boolean) {
    //file type extension
    if (isEditMode) {
      let checkFileType = fileName.split('.').pop();
      var fileType;
      if (checkFileType == "txt") {
        fileType = "text/plain";
      }
      if (checkFileType == "pdf") {
        fileType = "application/pdf";
      }
      if (checkFileType == "doc") {
        fileType = "application/vnd.ms-word";
      }
      if (checkFileType == "docx") {
        fileType = "application/vnd.ms-word";
      }
      if (checkFileType == "xls") {
        fileType = "application/vnd.ms-excel";
      }
      if (checkFileType == "png") {
        fileType = "image/png";
      }
      if (checkFileType == "jpg") {
        fileType = "image/jpeg";
      }
      if (checkFileType == "jpeg") {
        fileType = "image/jpeg";
      }
      if (checkFileType == "gif") {
        fileType = "image/gif";
      }
      if (checkFileType == "csv") {
        fileType = "text/csv";
      }


      let discountId = '';
      if (this.selectedDiscountObj != undefined)
        discountId = this.selectedDiscountObj.discountId;

      this.pricesAndOffersService
        .DownloadFile(discountId, fileName, fileType, ApprovalCycleOperations.Discounts.valueOf())
        .subscribe(
          success => {
            saveAs(success, fileName);
          },
          err => {
            alert("Server error while downloading file.");
          }
        );
    }
  }
  sendEmail(discountId, currentStatusId) {
    this.pricesAndOffersService.sendOperationEmail(discountId, currentStatusId, ApprovalCycleOperations.Discounts.valueOf(), this.selectedDiscountObj.discountCode, false).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.EmailCaption));
      } else {
        if (response.message != this.translateService.instant(ConstantMessages.Desc_No_Email_Template_Found_For_Document_Type))
          this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  forceOrganizationFilterForCustomerGroups() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true"
  }

  getSelectedOrganizationIdsAsString() {
    this.organizationIdsString = this.discountOrganizationControl.value && this.discountOrganizationControl.value > 0 ?
      this.discountOrganizationControl.value + "" : null;
  }

  get sdcsControl() {
    return this.discountDataForm.get('sdcsList');
  }
}
