import { Component, OnInit, ViewChild } from '@angular/core';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { GeneralFilter } from '../../../../../shared/models/general/generalFilter.model';
import { Subject } from 'rxjs';
import { TranslateService } from '@ngx-translate/core';
import { PricesAndOffersService } from '../../prices-and-offers.service';
import { CoreSession } from '../../../../../core/core.session';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { RowOperation, MultiSelectionOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import * as cloneDeep from 'lodash/cloneDeep';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { IDateTimePickerProperties } from '../../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../../../shared/models/dateTimeModel/date-time.model';
import { ItemService } from '../../../../../shared/services/data-definition/product/item.service';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { ApprovalCycleOperations } from '../../../../../shared/models/enums/approval-cycle-operations-enum';
import { PackGroupService } from '../../../../../shared/services/data-definition/product/pack-group.service';
import { DiscountService } from '../../../../../shared/services/data-definition/prices-and-offers/discount.service';
import { NavBarService } from '../../../../../core/sidebar/sidebar.service';
import { SharedDialogComponent } from '../../../../../shared/components/shared-dialog/shared-dialog.component';

@Component({
  selector: 'app-discount-definition-list',
  templateUrl: './discount-definition-list.component.html',
  styleUrls: ['./discount-definition-list.component.css']
})
export class DiscountDefinitionListComponent implements OnInit {

  //#region [Declaration]
  increaseFilterBodyWidth: boolean = true;
  showStatusColumn = false;
  @ViewChild('DivisionEntryDialog', { static: true }) DivisionEntryDialog: SharedDialogComponent;

  tableData: ITableProperties = {
    pageSize: 25,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: true,
    showNewBtn: true,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [

    ],
    columns: [
      {
        title: 'Desc_Name',
        key: 'discountName',
        isSortable: true,
        width: '10%'
      },
      {
        title: 'Desc_Code',
        key: 'discountCode',
        isSortable: true,
        width: '10%'
      },
      {
        title: 'Desc_Type',
        key: 'typeName',
        isSortable: true,
        width: '10%'
      },
      {
        title: 'Desc_Value',
        key: 'amountString',
        isSortable: true,
        width: '10%'
      },
      {
        title: 'Desc_Start_Date',
        key: 'startDate',
        isSortable: true,
        isExpiryDate: true,
        width: '15%'
      },
      {
        title: 'Desc_End_Date',
        key: 'endDate',
        isSortable: true,
        isExpiryDate: true,
        width: '15%'
      },
      {
        title: 'Desc_Applied_on',
        key: 'appliedOn',
        isSortable: true,
        width: '30%'
      },
    ]
  };
  modalReference: any;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  generalFilter: GeneralFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: 25
    },

    organizationId: -1,
    divisionId: -1,
    groupId: -1,
    customerId: -1,
    outletId: -1,
    packGroupId: -1,
    packId: -1,
    includeInactive: false,
    dateModel: null,
    toDate: null
  };
  applyOnDivisionLevel: boolean = false;
  saveSubject: Subject<void> = new Subject<void>();
  showSlider = false;
  isEditMode = false;
  isCloneMode = false;
  isAddMode = false;
  selectedDiscount: any = {};

  discountFilterForm: FormGroup;
  isFilterOpend: boolean = false;

  isPackGroupLoading: boolean = false;
  packGroups: any[] = [];

  toDate: DateTimeModel = null;
  fromDate: DateTimeModel = null;

  fromDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Start_Date',
    formControlName: 'fromDate',
    isCalendarOnly: true,
    labelHidden: false,
  };

  toDateProperties: IDateTimePickerProperties = {
    label: 'Desc_End_Date',
    formControlName: 'toDate',
    isCalendarOnly: true,
    labelHidden: false,
  };
  //#endregion

  //#region [Constructor & Initialization]
  constructor(public coreSession: CoreSession,
    private translateService: TranslateService,
    private pricesAndOffersService: PricesAndOffersService,
    private discountService: DiscountService,
    private sessionData: SessionDataProvider,
    private packGroupService: PackGroupService,
    private navService:NavBarService
  ) { }

  showSharedTable:boolean =false
  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus;
    });
    this.showSharedTable = this.navService.tourStatus;

    this.coreSession.SetTitle('Discounts');
    this.tableData.showNewBtn = this.coreSession.checkActivitiesAvailability(ConstantURLs.discountsURL, MenuActions.Add);
    this.showStatusColumn = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("2");
    if (this.showStatusColumn)
      this.tableData.columns.push({ title: 'Desc_Status', key: 'discountStatusName', isSortable: true, width: '10%'  });
    this.initForm();
    this.addDeleteAction();
    this.addCloneAction();
    this.addApproveAction();
    this.populateDiscounts();
    this.fillPackGroups();
  }

  initForm() {
    this.discountFilterForm = new FormGroup({
      organizationId: new FormControl(),
      divisionId: new FormControl(),
      customerGroupId: new FormControl(),
      customerId: new FormControl(),
      outletId: new FormControl(),
      packGroupId: new FormControl(),
      packId: new FormControl(),
      fromDate: new FormControl(null),
      toDate: new FormControl(null),
      includeInactive: new FormControl(false)
    });
  }
  //#endregion

  openDivisionEntryDialog() {
    this.DivisionEntryDialog.Show(true).then((res) => { });
  }

  //#region [Methods]
  isDivisionLevel() {
    return this.applyOnDivisionLevel = this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true";
  }
  fillPackGroups() {
    this.coreSession.ModalLoading.Show();
    var filter = {
      getGroupsHavingSamePackQuantity : false,
      selectedOraganizationIds : ''
    }
    this.packGroupService.getPackGroups(filter).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.packGroups = response.data;
          (this.dataSource);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  populateDiscounts() {
    this.coreSession.ModalLoading.Show();
    this.discountService.getDiscounts(this.generalFilter).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        (response);

        if (response.status != null && response.status >= 0) {
          this.dataSource = {
            totalItems: response.data.totalItems,
            data: response.data.data
          };
          console.log(this.dataSource.data);
        } else {
          this.dataSource = {
            totalItems: 0,
            data: []
          };
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  deleteDiscount(discountId: number) {
    this.discountService.deleteDiscount(discountId)
      .subscribe(
        (response: ResponseModel) => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
            this.populateDiscounts();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
  }
  addDeleteAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.discountsURL, MenuActions.Delete)) {
      this.tableData.rowOperations.push(
        {
          operation: RowOperation.delete,
          title: 'Desc_Delete',
          icon: 'fa-solid fa-trash',
          color: '#f1685e'
        });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.discountsURL, MenuActions.Edit)) {

      // this.tableData.rowOperations.push({
      //   operation: RowOperation.Activate,
      //   title: "Desc_Reactivate",
      //   icon: "fa fa-toggle-on",
      //   color: '#02b875',
      //   showWhenKeyValueTrue: true,
      //   showHideOptionPerLine: true,
      //   controlKeyName: 'inactive'
      // });

      this.tableData.rowOperations.push(
        {
          operation: RowOperation.Deactivate,
          title: 'Desc_Deactivate',
          icon: 'fa-solid fa-ban',
          color: '#f1685e',
          showWhenKeyValueFalse: true,
          showHideOptionPerLine: true,
          controlKeyName: 'inactive'
        });

        this.tableData.rowOperations.push({
          operation: RowOperation.edit,
          title: "Desc_Edit",
          icon: "fa-regular fa-pen-to-square",
          color: "#12344d"
        });
    }
  }
  addApproveAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.discountsURL, MenuActions.Approve)) {
      this.tableData.rowOperations.push(
        {
          operation: RowOperation.approve,
          title: 'Desc_Order_Approve',
          icon: "fa-solid fa-check",
          color: "#02b875",
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: 'isPending'
        });
    }
  }
  addCloneAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.discountsURL, MenuActions.Add)) {
      this.tableData.rowOperations.push(
        {
          operation: RowOperation.Clone,
          title: 'Desc_Clone',
          icon: 'fa fa-clone',
          color: '#12344d',
        });
    }
  }
  updateDiscountActiveStatus(discount: any, isActive) {
    var msg = '';
    if (isActive) {
      msg = ConstantMessages.MsgReactivateConfirmation;
    } else {
      msg = ConstantMessages.MsgDeactivateConfirmation;
    }
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(msg), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.coreSession.ModalLoading.Show();
          var filter = {
            discountId: discount.discountId,
            isActive: isActive
          }
          this.discountService.updateDiscountActiveStatus(filter).subscribe(response => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
              this.populateDiscounts();
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
            }
          },
            (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            });
        }
      });
  }
  IsValidToApprove(discount) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.ApproveConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.coreSession.ModalLoading.Show();
          this.pricesAndOffersService.isValidToApprove(discount.status, ApprovalCycleOperations.Discounts.valueOf()).subscribe(response => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              if (response.data) {
                // valid to approve
                this.approveDiscount(discount.discountId,discount.discountCode,discount.status);
              }
              else {
                this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgNotValidToApprove));

              }
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
            }
          },
            (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            }
          );
        }
      });
  }
  approveDiscount(discountId,discountCode,currentStatusId) {
    this.pricesAndOffersService.approveOperation(discountId ,currentStatusId, ApprovalCycleOperations.Discounts.valueOf()).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.SuccessCaption));
        this.populateDiscounts();
        if (response.data.newStatus != -1)
          this.sendEmail(discountId,discountCode,currentStatusId);
      } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  sendEmail(discountId,discountCode,currentStatusId) {
    this.pricesAndOffersService.sendOperationEmail(discountId ,currentStatusId, ApprovalCycleOperations.Discounts.valueOf(),discountCode,true).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.EmailCaption));
        this.populateDiscounts();
      } else {
        if (response.message != this.translateService.instant(ConstantMessages.Desc_No_Email_Template_Found_For_Document_Type))
          this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  //#endregion

  //#region [Filter events]
  ApplySerachFilterOnFind() {
    this.generalFilter.customListFilter.page = 0;
    this.generalFilter.customListFilter.pageSize = this.tableData.pageSize;

    this.generalFilter.dateModel = this.fromDate == null ? null : this.fromDate;
    this.generalFilter.toDate = this.toDate == null ? null : this.toDate;
    this.generalFilter.divisionId = this.discountFilterForm.get('divisionId').value == null ? -1 : this.discountFilterForm.get('divisionId').value,
      this.generalFilter.organizationId = this.discountFilterForm.get('organizationId').value == null ? -1 : this.discountFilterForm.get('organizationId').value,
      this.generalFilter.groupId = this.discountFilterForm.get('customerGroupId').value == null ? -1 : this.discountFilterForm.get('customerGroupId').value,
      this.generalFilter.customerId = this.discountFilterForm.get('customerId').value == null ? -1 : this.discountFilterForm.get('customerId').value,
      this.generalFilter.outletId = this.discountFilterForm.get('outletId').value == null ? -1 : this.discountFilterForm.get('outletId').value,
      this.generalFilter.packGroupId = this.discountFilterForm.get('packGroupId').value == null ? -1 : this.discountFilterForm.get('packGroupId').value,
      this.generalFilter.packId = this.discountFilterForm.get('packId').value == null ? -1 : this.discountFilterForm.get('packId').value,
      this.generalFilter.includeInactive = this.discountFilterForm.get('includeInactive').value == null ? false : this.discountFilterForm.get('includeInactive').value;
    this.populateDiscounts();
  }
  onReset() {
    this.fromDate = null;
    this.toDate = null;
    this.discountFilterForm.reset();
    this.discountFilterForm.get('includeInactive').setValue(false);
  }

  onToDateSelected(date: any) {
    this.fromDate = null;
    this.fromDate = date;
  }
  onFromDateSelected(date: any) {
    this.toDate = null;
    this.toDate = date;
  }
  //#endregion

  //#region [Slider events]
  closeSlider() {
    this.showSlider = false;
    this.isCloneMode = false;
    this.isEditMode = false;
    this.isAddMode = false;
    this.showSharedTable = true
    this.DivisionEntryDialog.Close()
  }
  onSaveClick() {
    this.saveSubject.next();
  }
  onDiscountSaved() {
    this.closeSlider();
    this.populateDiscounts();
    this.showSharedTable =true
  }
  //#endregion

  //#region [Shared table events]
  onRowClicked(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        (event.object);
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.discountsURL, MenuActions.Delete)) {
          this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
            .then(
              (result: DialogResult) => {
                if (result === DialogResult.Yes) {
                  this.deleteDiscount(event.object.discountId);
                }
              }
            );
        }
        break;
      case RowOperation.Deactivate:
        this.updateDiscountActiveStatus(event.object, false);
        break;
      case RowOperation.Activate:
        this.updateDiscountActiveStatus(event.object, true);
        break;
      case RowOperation.edit:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.discountsURL, MenuActions.Edit)) {
          this.isEditMode = true;
          this.selectedDiscount = cloneDeep(event.object);
          this.showSlider = true;
          this.openDivisionEntryDialog()
        }
        break;
      case RowOperation.Clone:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.discountsURL, MenuActions.Add)) {
          this.isCloneMode = true;
          this.selectedDiscount = cloneDeep(event.object);
          this.showSlider = true;
          this.openDivisionEntryDialog()
        }
        break;
        case RowOperation.approve: {
          this.IsValidToApprove(event.object);
          break;
        }
    }
  }
  onMultiSelectionOperation(event: any) {
    switch (event.operation) {

      case MultiSelectionOperation.delete:
        break;
    }
  }
  onTableFilterChanged(query: any) {
    ('onTableFilterChanged');
    (query);

    this.generalFilter.customListFilter = query;
    this.populateDiscounts();
  }
  onNewBtnClicked() {
    this.isAddMode = true;
    this.isEditMode = false;
    this.isCloneMode = false;
    this.selectedDiscount = undefined;
    this.showSlider = true;
    this.showSharedTable = false
    this.openDivisionEntryDialog()
  }
  //#endregion
  openFilter() {
    this.isFilterOpend = !this.isFilterOpend;
    this.onReset();
  }
}
