import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit, ViewChild } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { NgbModal, NgbModalOptions } from '@ng-bootstrap/ng-bootstrap';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../../core/core.session';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { LoyaltyModes } from '../../../../../shared/models/enums/loyalty-modes-enum';
import { PromotionService } from '../../../../../shared/services/data-definition/prices-and-offers/promotion.service';

@Component({
  selector: 'app-loyalty-programs-modes-dialog',
  templateUrl: './loyalty-programs-modes-dialog.component.html',
  styleUrls: ['./loyalty-programs-modes-dialog.component.css']
})
export class LoyaltyProgramsModesDialogComponent implements OnInit {

  @ViewChild('loyaltyModesDialog', { static: true }) loyaltyModesDialog: any;
  loading: boolean = false;
  OkResult: DialogResult = DialogResult.Ok;
  CancelResult: DialogResult = DialogResult.Cancel;
  loyaltyModesForm: FormGroup;
  loyaltyModeslist: any[] = [];

  ngbModalOptions: NgbModalOptions = {
    backdrop: 'static',
    keyboard: false
  };
  constructor(private modalService: NgbModal,
    private translateService: TranslateService) { }

  ngOnInit() {
    this.loyaltyModesForm = new FormGroup({
      selectloyaltyMode: new FormControl(null, Validators.required),
    });
    this.fillLoyaltyModes();
  }

  fillLoyaltyModes() {
    this.loyaltyModeslist.push({ 'promotionModeId': LoyaltyModes.LoyaltyPromotion.valueOf(), 'description': this.translateService.instant(ConstantMessages.DescLoyaltyPromotion) });
    this.loyaltyModeslist.push({ 'promotionModeId': LoyaltyModes.PointsLoyaltyPromotion.valueOf(), 'description': this.translateService.instant(ConstantMessages.DescLoyaltyPointsPromotion) });
  }

  public showDialog() {
    this.loyaltyModesForm.get('selectloyaltyMode').setValue(LoyaltyModes.LoyaltyPromotion);
    return this.modalService.open(this.loyaltyModesDialog, { centered: true, backdrop: 'static' }).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          return this.loyaltyModesForm.get('selectloyaltyMode').value;
        }
        if (result === DialogResult.Cancel) {
          return -1;
        }
        else {
          return -1;
        }
      });
  }

}
