import { Component, OnInit, Input, Output, EventEmitter, ViewChild } from '@angular/core';
import { Observable, Subscription } from 'rxjs/Rx';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { IDateTimePickerProperties } from '../../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../../../shared/models/dateTimeModel/date-time.model';
import { ITextInput } from '../../../../../shared/models/shared-table/custom-list.interface';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { CoreSession } from '../../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { PricesAndOffersService } from '../../prices-and-offers.service';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
// import { HttpErrorResponse } from '@angular/common/http/src/response';
import { DataActions } from '../../../../../shared/models/enums/data-actions.enum';
import * as cloneDeep from 'lodash/cloneDeep';
import { SelectCustomersComponent } from '../../../../../shared/components/customers/select-customers/select-customers.component';
import { CustomerGroupModel } from '../../../../../shared/models/customer/customer.group.model';
import { CustomerService } from '../../../../../shared/services/data-definition/customer/customers.service';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { PriceListTypes } from '../../../../../shared/models/enums/price-list-types.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ItemService } from '../../../../../shared/services/data-definition/product/item.service';
import { FormBuilder } from '@angular/forms';
import { SharedDialogComponent } from '../../../../../shared/components/shared-dialog/shared-dialog.component';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { ImportDataTypes } from '../../../../../shared/models/import/ImportDataTypes';
import { ImportDialogComponent } from '../../../../../shared/components/import-dialog/import-dialog.component';
import { RSA_NO_PADDING } from 'constants';
import { PackGroupService } from '../../../../../shared/services/data-definition/product/pack-group.service';
import { PriceService } from '../../../../../shared/services/data-definition/prices-and-offers/price.service';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { ShepherdService } from 'angular-shepherd';
import { Router } from '@angular/router';
import { TourService } from '../../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../../shared/shepherd-config/trackTour.service';
@Component({
  selector: 'app-price-definition-entry',
  templateUrl: './price-definition-entry.component.html',
  styleUrls: ['./price-definition-entry.component.css']
})
export class PriceDefinitionEntryComponent implements OnInit {

  saveBtnSubscription: any;
  @Output() onSaveCompleted = new EventEmitter();
  @Input() events: Observable<void>;
  @Input() selectedPriceListObj: any = {};
  @Input() selectedPriceListObjDialog: any = {};

  @Input() isEditMode = false;
  @Input() isDeleteMode = false;
  @Input() isViewMode = false;
  @Input() isViewOriginalMode = false;
  isDefaultPrice = false;
  overwrite: boolean = false;
  isSharedRow: boolean = false;
  isFromPackGroup: boolean = false;
  showForm: FormGroup;
  showMinMaxPrice: boolean = false;
  isApplyTaxTypesInPrices: boolean = false;
  applyNetPrice: boolean = false;
  addTaxForItem: boolean = false;
  showSelectCustomersDialog: boolean = false;
  taxChangeTempByItem: any[] = [];
  taxChangeTempByPackGroup: any[] = [];

  mutilItemShow = false
  showButtonIsDefault = true
  showAppliedSharedTable = false
  @ViewChild("taxTypeEntry", { static: true }) taxTypeDialog: SharedDialogComponent;
  @ViewChild("ConflectCustomerEntry", { static: true }) ConflectCustomerEntry: SharedDialogComponent;

  @ViewChild("selectCustomerDialog", { static: true }) selectCustomerDialog: SelectCustomersComponent;
  priceLisDataForm: FormGroup = new FormGroup({});
  @Output() clearSelectEvent = new EventEmitter<void>();

  priceListNameOtherLanguages: any[] = [];
  oldPriceListObj: any = {};
  oldAddedItems: any[] = [];
  oldAddedCustomers: any[] = [];
  oldAddedChannels: any[] = [];
  oldAddedGroups: any[] = [];
  oldAddedSDCS: any[] = [];
  currentTaxTypeSelectedToPackGroup: any[] = [];
  deletedItems = [];
  selectedPriceListType: PriceListTypes = PriceListTypes.General;
  selectedPriceListTypeName: string = '';
  selectedOrganization: any = {};
  addedItemList: any[] = [];
  addedCustomersList: any[] = [];
  allCustomersList: any[] = [];
  copyOfAddedCustomers: any[] = [];
  fromToDate: DateTimeModel[] = [];
  allTaxTypes: any[] = [];

  totalTax: number = 0;

  fromToDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Date_From_To',
    formControlName: 'fromToDate',
    isCalendarOnly: true,
    isRange: true,
    labelHidden: false,
  };

  itemsDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  itemsDataSourceTemp: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  priceListNameInput: ITextInput = {
    formControlName: "priceListName",
    placeHolder: "Desc_Price_List_Name",
    label: "Desc_Price_List_Name",
    isRequierd: true
  };


  customersDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };

  taxTypesDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };


  customersSharedTabel: ITableProperties = {
    pageSize: 25,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showEditButton: false,
    showNewBtn: true,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' }
    ]
  };

  taxTypesSharedTabel: ITableProperties = {
    pageSize: 5,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    multiSelectionOperations: [],
    rowOperations: [],
    columns: [
      {
        title: 'Desc_Tax_Type',
        key: 'taxTypeName',
        isSortable: false,
        width: '45%'
      },
      {
        title: 'Desc_Tax',
        key: 'tax',
        isSortable: false,
        width: '45%',
        isEditable: !this.isViewMode,
        numberOfDigits: true
      }//!this.isViewMode
      , {
        title: '',
        key: 'isPlusValue',
        isSortable: false,
        width: '10%',
        isPlusMinusValue: true
      }
    ]
  };
  //groups
  groups: CustomerGroupModel[] = [];
  channels: any[] = [];
  allGroupsList: CustomerGroupModel[] = [];
  allChannelsList: any[] = [];
  sdcs: any[] = [];
  dropdownSettings = {
    singleSelection: false,
    idField: 'groupId',
    textField: 'groupCodeName',
    selectAllText: 'Select All',
    unSelectAllText: 'UnSelect All',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 1
  };

  dropdownChannelSettings = {
    singleSelection: false,
    idField: 'channelSubChannelIds',
    textField: 'channelSubChannelDescriptions',
    selectAllText: 'Select All',
    unSelectAllText: 'UnSelect All',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 1
  };
  //end groups
  navLinks: any[];
  navBarSelectedIndex: number = 0;
  selectedDivisionId = -1;
  selectedCategoryId = -1;
  selectedCurrency: any = {};
  itemDefinitionObj: any = {};
  selectedItemFromLazyLoading: any;
  selectedItemFromDataSource: any;
  selectedPackGroup: any;

  itemTableData: ITableProperties = {
    pageSize: 5,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: true,
    isMultiSelection: false,
    showNewBtn: true,
    newBtnCaption: 'Desc_Import',
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Item',
        key: 'itemCodeName',
        isSortable: false,
        width: '20%'
      },
      {
        title: 'Desc_UOM',
        key: 'uom',
        isSortable: false,
        width: '20%',
      },
     {
        title: 'Desc_Qty_Range',
        key: 'quantityRangeId',
        isSortable: false,
        isEditable: true,
        isNgSelect: true,
        width: '20%'
      },
      {
        title: 'Desc_Price',
        key: 'price',
        isSortable: false,
        width: '20%',
        isEditable: !this.isViewMode,

      }, {
        title: 'Desc_Tax',
        key: 'tax',
        isSortable: false,
        width: '20%',
        isEditable: !this.isViewMode,
        numberOfDigits: true,
      }

    ]
  };
  sdcDropdownSetting = {
    singleSelection: false,
    idField: 'sdcId',
    textField: 'sdcCodeName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 2
  };
  ForceCustomerOrganizationSelection = null;
  ApplyCurrencyPerOrg = null;
  selectedPacks: any[];
  refreshData = false;
  showAddNew = false;
  quantityRange: FormGroup = new FormGroup({});
  qtyRangeList: any[] = [];
  ngSelectDropdownSettings: any = {
    bindLabel: 'range',
    bindValue: 'quantityRangeId',
  };
  oldValueQtyRange: any;
  @ViewChild('quantityRangeDialog', { static: true }) quantityRangeDialog: NgbModal;
  dataType: ImportDataTypes = ImportDataTypes.ItemsPricesWithQtyRange;
  @ViewChild("import") import: ImportDialogComponent;
  tempItemList = [];

  showStockStatusCombo: boolean = false;
  showSalesOrderTypeCombo: boolean = false;
  allowSelectSalesOrderType: boolean = false;
  allowSelectStockStatusType: boolean = false;
  enableSalesDistributionChannel: boolean = false;
  allSDCsList:any[]=[];
  constructor(private translateService: TranslateService,
    private coreSession: CoreSession,
    private pricesAndOffersService: PricesAndOffersService,
    private priceService: PriceService,
    private customerService: CustomerService,
    private sessionData: SessionDataProvider,
    private itemService: ItemService,
    private modalService: NgbModal,
    private packGroupService: PackGroupService,
  private router :Router,
private shepherdService:ShepherdService,
private tourService: TourService,
private componentVisitService: ComponentVisitService) {
  }
  ngAfterViewInit() {
   var elementSelectors = ['#price-def',
    '#date-def','#isDefaultToggle',
  ] // Target each column by its unique ID
    this.startTour(elementSelectors,'MainData',false)
    }
    private tourStartTimeout: any;
 showItemSharedTable = false
    startTour(elementSelectors,type,forceTour?: boolean){
      this.tourStartTimeout=  setTimeout((data=>{
        if(!this.tourService.isFirstTour()){
          if(type=='ApplyToData'){
            this.showAppliedSharedTable = true
          }
          if(type=='Item'){
            this.showItemSharedTable = true
          }
        }

        (!forceTour)
       if (this.tourService.isTourCompletedForComponent('price-entry')) {
            if(type=='ApplyToData'){
              this.showAppliedSharedTable = true
            }
            if(type=='Item'){
              this.showItemSharedTable = true
            }
                    return;
          }

          if(this.tourService.isFirstTour()||forceTour){

            const titles = [];
            const texts = [];
            for (let index = 0; index < elementSelectors.length; index++) {
            const { title, text } = this.getTitleAndText(index,type);
            titles.push(title);
            texts.push(text);
          }
          const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
          this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
          this.shepherdService.modal = true;
          this.shepherdService.addSteps(steps);
          this.shepherdService.start();
          this.shepherdService.tourObject.on('complete', () => {
            if(type=='ApplyToData'){
              this.showAppliedSharedTable = true
            }
            if(type=='Item'){
              this.showItemSharedTable = true
            }
        });
        this.shepherdService.tourObject.on('cancel', () => {
          if(type=='ApplyToData'){
            this.showAppliedSharedTable = true
          }
          if(type=='Item'){
            this.showItemSharedTable = true
          }
      });
    }
      }),1000)
    }
      getTitleAndText(index: number,type): { title: string, text: string } {
      let title = '';
      let text = '';

      if (type == 'MainData') {
        switch (index) {
          case 0:
            title = "Desc_Price_List";
            text = "Desc_Enter_Name_of_Price_List";
            break;
          case 1:
            title = "Desc_Date";
            text = "Desc_Select_Available_Date_for_Price_List";
            break;
          case 2:
            title = "Desc_isDefaultPriceList";
            text = "Desc_isDefaultPriceList";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      } else if (type === 'Item') {
        switch (index) {
          case 0:
            title = "Desc_Division";
            text = 'Desc_Select_Division_to_Filter_Items';
            break;
          case 1:
            title = "Desc_Category";
            text = "Desc_Select_Category_to_Filter_Items";
            break;
          case 2:
            title = "Desc_Items";
            text = 'Desc_Select_Multi_Item_to_Add_to_List';
            break;
          case 3:
            title = "Desc_Qty_Range";
            text = "Desc_Select_Quantity_Range_for_Item";
            break;
          case 4:
            title = "Desc_Add";
            text = "Desc_Add_Button";
            break;

          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      }
      else if (type == 'ApplyToData') {
        switch (index) {
          case 0:
            title = "New Pack";
            text = 'Here you can define your items and pack for it.';
            break;
          case 1:
            title = "Add Image";
            text = "Here you can upload image from device.";
            break;
          case 2:
            title = "Item Definition";
            text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
            break;
          case 3:
            title = "Brand and Description";
            text = "You can select brand and define a new description.";
            break;
          case 4:
            title = "Inactive Toggle";
            text = "These buttons make the item as inactive and the customer can't show it.";
            break;
          case 5:
            title = "Is New Toggle";
            text = "Make this item as new to show in new section.";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      }else if (type === 'Attachment') {
        switch (index) {
          case 0:
            title = "New Pack";
            text = 'Here you can define your items and pack for it.';
            break;
          case 1:
            title = "Add Image";
            text = "Here you can upload image from device.";
            break;
          case 2:
            title = "Item Definition";
            text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
            break;
          case 3:
            title = "Brand and Description";
            text = "You can select brand and define a new description.";
            break;
          case 4:
            title = "Inactive Toggle";
            text = "These buttons make the item as inactive and the customer can't show it.";
            break;
          case 5:
            title = "Is New Toggle";
            text = "Make this item as new to show in new section.";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      }else if (type === 'Contact') {
        switch (index) {
          case 0:
            title = "New Pack";
            text = 'Here you can define your items and pack for it.';
            break;
          case 1:
            title = "Add Image";
            text = "Here you can upload image from device.";
            break;
          case 2:
            title = "Item Definition";
            text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
            break;
          case 3:
            title = "Brand and Description";
            text = "You can select brand and define a new description.";
            break;
          case 4:
            title = "Inactive Toggle";
            text = "These buttons make the item as inactive and the customer can't show it.";
            break;
          case 5:
            title = "Is New Toggle";
            text = "Make this item as new to show in new section.";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      }
      return { title, text };
    }
    tourSubscription:Subscription
  ngOnInit() {

    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
      var elementSelectors

         var index = this.navLinks.findIndex(a => a.isActive ==true);
         switch(index){
          case 0 :
     elementSelectors = ['#price-def',
            '#date-def','#isDefaultToggle',
          ] // Target each column by its unique ID
            this.startTour(elementSelectors,'MainData',true)
          break
          case 1 :
            elementSelectors = ['#division-def','#category-def','#item-def'
             ,'#quantity-Range-def','#Add-item-def'
            ] // Target each column by its unique ID
         this.startTour(elementSelectors,'Item',true)
    break
    case 2 :
      // elementSelectors = ['#group-def'] // Target each column by its unique ID
      // this.startTour(elementSelectors,'ApplyToData',true)
    break
    }

       });
    this.showAddNew = this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Add);
    this.dropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.dropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.dropdownChannelSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropdownChannelSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.dropdownChannelSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.sdcDropdownSetting.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.sdcDropdownSetting.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.sdcDropdownSetting.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    if(this.enableSalesDistributionChannel) {
      this.dropdownChannelSettings.itemsShowLimit = 1;
      this.sdcDropdownSetting.itemsShowLimit = 1;
      this.dropdownSettings.itemsShowLimit = 1;
    }
    this.ForceCustomerOrganizationSelection = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceCustomerOrganizationSelection).toLowerCase() === "true"
    this.ApplyCurrencyPerOrg = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyCurrencyPerOrganization).toLowerCase() === "true"

    this.isApplyTaxTypesInPrices = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyTaxTypesInPrices).toLowerCase() === "true";

    this.allowSelectStockStatusType = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSelectStockStatusType).toLowerCase() === "true";
    this.allowSelectSalesOrderType = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSelectSalesOrderType).toLowerCase() === "true";
    this.enableSalesDistributionChannel = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSalesDistributionChannel).toLowerCase() === "true"

    this.fillQuantityRangeList(-1);
    this.subscribeSaveClick();
    this.initShowForm();
    this.initForm();
    this.populateGroupsList();
    this.populateChannelsSubChannelsList();
    this.populatePackGroupList();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;

    if (!this.isViewMode) {

      // this.itemTableData.rowOperations.push({
      //   operation: RowOperation.addQtyRange,
      //   title: "Desc_Qty_Range",
      //   icon: "fa fa-plus",
      //   color: "#66bb6d"
      // });

      this.itemTableData.rowOperations.push(
        {
          operation: RowOperation.delete,
          title: 'Desc_Delete',
          icon: 'fa-solid fa-trash',
          color: '#f1685e'
        });
      this.customersSharedTabel.rowOperations.push({
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
      });

    }
    if (this.isViewMode)
      this.customersSharedTabel.showNewBtn = false;
    if ((this.isEditMode || this.isViewMode || this.isViewOriginalMode) && this.selectedPriceListObj && this.selectedPriceListObj.priceListId > 0) {
      if(this.selectedPriceListObj.priceListTypeId == PriceListTypes.General.valueOf()) {
        if(this.allowSelectSalesOrderType) this.showSalesOrderTypeCombo = true;
        if(this.allowSelectStockStatusType) this.showStockStatusCombo = true;
      }
      if (this.isViewOriginalMode && !this.isEditMode) {
        this.populatePriceListOriginalHeader();
        this.populatePriceListOriginalData();
        this.populatePriceListOriginalAppliedTo();
      } else {
        this.populatePriceListHeader();
        this.populatePriceListData();
        this.populatePriceListAppliedTo();

      }
    } else {
      if(this.enableSalesDistributionChannel) {
        this.fillSDCsList();
      }
      this.itemsDataSource = {
        totalItems: 0,
        data: []
      };
      this.populatePriceListAllCustomerAppliedTo();
    }
    this.populateGroupsList();
    if (this.isViewMode)
      this.itemTableData.showNewBtn = false;



  }
  setItemDefinitionColumns() {
    this.applyNetPrice = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyNetPrice).toLowerCase() === "true";
    if (this.selectedPriceListType === PriceListTypes.CostPrice) {
      this.navLinks[2].hidden = true;
      this.applyNetPrice = false;
    }
    else {
      this.navLinks[2].hidden = false;
    }
    if (this.selectedPriceListType === PriceListTypes.Retail || this.selectedPriceListType === PriceListTypes.CostPrice.valueOf()) {
      this.showMinMaxPrice = false;
    } else {
      this.showMinMaxPrice = false //this.sessionData.getConfigurationValue(ConstantConfigurations.EnableMinMaxPriceInPriceList).toLowerCase() === "true";
    }
    let colWidth = 10;
    let currWidth = 20;
    if (!this.showMinMaxPrice) {
      colWidth = 20;
    }
    if (this.selectedPriceListType === PriceListTypes.CostPrice) {
      colWidth = colWidth * 2;
    }
    this.itemTableData.columns = [
      {
        title: 'Desc_Item',
        key: 'itemCodeName',
        isSortable: false,
        width: '30%'
      }, {
        title: 'Desc_Qty_Range',
        key: 'quantityRangeId',
        isSortable: false,
        isEditable: true,
        isNgSelect: true,
        width: '20%'
      }, {
        title: 'Desc_Price',
        key: 'price',
        isSortable: false,
        width: colWidth + '%',
        isEditable: !this.isViewMode,
        numberOfDigits: true
      }
    ]

    if (this.priceLisDataForm.get('priceListTypeId').value == 5 || this.priceLisDataForm.get('priceListTypeId').value == 3) {
      this.itemTableData.columns = [
        {
          title: 'Desc_Item',
          key: 'itemCodeName',
          isSortable: false,
          width: '30%'
        }, {
          title: 'Desc_Price',
          key: 'price',
          isSortable: false,
          width: colWidth + '%',
          isEditable: !this.isViewMode,
          numberOfDigits: true
        }
      ]
    } else {
      this.itemTableData.columns = [
        {
          title: 'Desc_Item',
          key: 'itemCodeName',
          isSortable: false,
          width: '30%'
        }, {
          title: 'Desc_Qty_Range',
          key: 'quantityRangeId',
          isSortable: false,
          isEditable: true,
          isNgSelect: true,
          width: '20%'
        }, {
          title: 'Desc_Price',
          key: 'price',
          isSortable: false,
          width: colWidth + '%',
          isEditable: !this.isViewMode,
          numberOfDigits: true
        }
      ]
    }

    // if (this.showMinMaxPrice) {
    //   this.itemTableData.columns.push({
    //     title: 'Desc_Min_Price',
    //     key: 'minPrice',
    //     isSortable: false,
    //     width: '15%',
    //     isEditable: !this.isViewMode,
    //     numberOfDigits: true
    //   },
    //     {
    //       title: 'Desc_Max_Price',
    //       key: 'maxPrice',
    //       isSortable: false,
    //       width: '15%',
    //       isEditable: !this.isViewMode,
    //       numberOfDigits: true
    //     });
    // }
    if (this.selectedPriceListType !== PriceListTypes.CostPrice && !this.isApplyTaxTypesInPrices) {
      this.itemTableData.columns.push({
        title: 'Desc_Tax',
        key: 'tax',
        isSortable: false,
        width: colWidth + '%',
        isEditable: !this.isViewMode,
        numberOfDigits: true
      });

    }

    if (this.selectedPriceListType !== PriceListTypes.CostPrice && this.isApplyTaxTypesInPrices) {
      if (this.selectedPriceListType == PriceListTypes.Retail) {
        this.itemTableData.columns.push({
          title: 'Desc_Tax',
          key: 'tax',
          isSortable: false,
          width: colWidth + '%',
          isEditable: !this.isViewMode,
          numberOfDigits: true
        });
      } else {
        this.itemTableData.columns.push({
          title: 'Desc_Tax',
          key: 'tax',
          isSortable: false,
          width: colWidth + '%',
          numberOfDigits: true
        });
      }
    }

    if (this.applyNetPrice) {
      currWidth = 10;
      this.itemTableData.columns.push({
        title: 'Desc_Net_Price',
        key: 'netPrice',
        isSortable: false,
        width: '10%',
        isEditable: !this.isViewMode,
        numberOfDigits: true
      });
    }


    if (this.isApplyTaxTypesInPrices && this.selectedPriceListType != PriceListTypes.CostPrice.valueOf() && this.selectedPriceListType != PriceListTypes.Retail.valueOf()) {
      let index = this.itemTableData.rowOperations.findIndex(x => x.operation == RowOperation.add);
      if (index < 0) {
        this.itemTableData.rowOperations.push({
          operation: RowOperation.add,
          title: "Desc_Taxes",
          icon: "fa fa-plus",
          color: "#66bb6d"
        });
      }

    } else {
      let index = this.itemTableData.rowOperations.findIndex(x => x.operation == RowOperation.add);
      if (index > -1) {
        this.itemTableData.rowOperations.splice(index, 1);
      }
    }

  }
  populatePriceListData(priceListID?) {
    this.fromToDate = priceListID?[]:[this.selectedPriceListObj.startDateModel, this.selectedPriceListObj.endDateModel];
    // this.priceLisDataForm.get("fromToDate").setValue(this.fromToDate);
    this.priceService.getPriceListData(priceListID?priceListID:this.selectedPriceListObj.priceListId).subscribe(
      (response: ResponseModel) => {

        if (response.status != null && response.status >= 0) {

          if (response.data.priceListItems && response.data.priceListItems.length) {
            response.data.priceListItems.forEach(element => {
              element.oldQuantityRangeId = element.quantityRangeId;
            });
          }
          this.addedItemList = response.data.priceListItems;
          this.tempItemList = response.data.priceListItems;
          this.fillItemsList();
          this.priceListNameOtherLanguages = response.data.languageDescriptions;

          priceListID?this.selectedPriceListObjDialog.priceListDescriptionLanguages = response.data.languageDescriptions:this.selectedPriceListObj.priceListDescriptionLanguages = response.data.languageDescriptions;
          priceListID?this.selectedPriceListType=this.selectedPriceListObjDialog.priceListTypeId:this.selectedPriceListType = this.selectedPriceListObj.priceListTypeId;
          priceListID?this.selectedPriceListTypeName=this.selectedPriceListObjDialog.priceListTypeName:this.selectedPriceListTypeName = this.selectedPriceListObj.priceListTypeName;
          this.setItemDefinitionColumns();
          this.oldPriceListObj = cloneDeep(this.selectedPriceListObj);
          this.oldAddedItems = cloneDeep(this.addedItemList);
          this.fillFormInEditMode(priceListID);
          if (this.selectedPriceListType == PriceListTypes.Retail.valueOf() || priceListID?this.selectedPriceListObjDialog==PriceListTypes.CostPrice.valueOf():this.selectedPriceListType == PriceListTypes.CostPrice.valueOf()) {
            this.priceLisDataForm.get('priceListTypeId').setValidators(null);
            this.priceLisDataForm.get('priceListTypeId').updateValueAndValidity();
          } else {
            // this.priceLisDataForm.get('priceListTypeId').setValidators(Validators.required);
            // this.priceLisDataForm.get('priceListTypeId').updateValueAndValidity();
          }

        } else {
          this.itemsDataSource = {
            totalItems: 0,
            data: []
          };
          this.priceListNameOtherLanguages = [];
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  populatePriceListOriginalHeader() {
    this.priceService.getPriceListHeader(this.selectedPriceListObj.priceListId).subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {
          this.selectedPriceListObj = response.data;
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  populatePriceListHeader(priceListID?) {
    this.priceService.getPriceListHeader(priceListID?priceListID:this.selectedPriceListObj.priceListId).subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {
          priceListID?this.selectedPriceListObjDialog = response.data:this.selectedPriceListObj = response.data;
          this.fromToDate = priceListID?[this.selectedPriceListObjDialog.startDateModel, this.selectedPriceListObjDialog.endDateModel]:[this.selectedPriceListObj.startDateModel, this.selectedPriceListObj.endDateModel];

        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  populatePriceListOriginalData() {
    this.fromToDate = [this.selectedPriceListObj.startDateModel, this.selectedPriceListObj.endDateModel];
    // this.priceLisDataForm.get("fromToDate").setValue(this.fromToDate);
    this.priceService.getPriceListOriginalData(this.selectedPriceListObj.priceListId).subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {
          if (response.data.priceListItems && response.data.priceListItems.length) {
            response.data.priceListItems.forEach(element => {
              element.oldQuantityRangeId = element.quantityRangeId;
            });
          }
          this.addedItemList = response.data.priceListItems;
          this.fillItemsList();
          this.priceListNameOtherLanguages = response.data.languageDescriptions;
          this.selectedPriceListObj.priceListDescriptionLanguages = response.data.languageDescriptions;
          this.selectedPriceListType = this.selectedPriceListObj.priceListTypeId;
          this.selectedPriceListTypeName = this.selectedPriceListObj.priceListTypeName;
          this.setItemDefinitionColumns();
          this.oldPriceListObj = cloneDeep(this.selectedPriceListObj);
          this.oldAddedItems = cloneDeep(this.addedItemList);
          this.populateGroupsList();

        } else {
          this.itemsDataSource = {
            totalItems: 0,
            data: []
          };
          this.priceListNameOtherLanguages = [];
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  populatePriceListAppliedTo(priceListID?) {
    this.priceService.getPriceListAppliedLists(priceListID?priceListID:this.selectedPriceListObj.priceListId).subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {
          this.channels = response.data.appliedChannels;
          this.groups = response.data.appliedGroups;
          this.addedCustomersList = response.data.appliedCustomers;
          this.sdcs = response.data.appliedSDCs;
          this.fillCustomersList();
          priceListID?this.selectedPriceListObjDialog.appliedChannels= response.data.appliedChannels:this.selectedPriceListObj.appliedChannels = response.data.appliedChannels;
          priceListID?this.selectedPriceListObjDialog.appliedGroups= response.data.appliedGroups:this.selectedPriceListObj.appliedGroups = response.data.appliedGroups;
          priceListID?this.selectedPriceListObjDialog.appliedCustomers=response.data.appliedCustomers:this.selectedPriceListObj.appliedCustomers = response.data.appliedCustomers;
          priceListID?this.selectedPriceListObjDialog.appliedSDCs=response.data.appliedSDCs:this.selectedPriceListObj.appliedSDCs = response.data.appliedSDCs;
          this.oldAddedCustomers = cloneDeep(this.addedCustomersList);
          this.oldAddedGroups = cloneDeep(this.groups);
          this.oldAddedChannels = cloneDeep(this.channels);
          this.oldAddedSDCS = cloneDeep(this.sdcs);
          this.populatePriceListAllCustomerAppliedTo();

          this.selectedPriceListObjDialog.priceListId?this.showConflectCustomerEntryDialog():""

        } else {
          this.channels = [];
          this.groups = [];
          this.customersDataSource = {
            totalItems: 0,
            data: []
          };
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  populatePriceListOriginalAppliedTo() {

    this.priceService.getPriceListOriginalAppliedLists(this.selectedPriceListObj.priceListId).subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {

          this.channels = response.data.appliedChannels;
          this.groups = response.data.appliedGroups;
          this.addedCustomersList = response.data.appliedCustomers;
          this.sdcs = response.data.appliedSDCs;
          this.fillCustomersList();
          this.selectedPriceListObj.appliedChannels = response.data.appliedChannels;
          this.selectedPriceListObj.appliedGroups = response.data.appliedGroups;
          this.selectedPriceListObj.appliedCustomers = response.data.appliedCustomers;
          this.selectedPriceListObj.appliedSDCs = response.data.appliedSDCs;
          this.oldAddedCustomers = cloneDeep(this.addedCustomersList);
          this.oldAddedGroups = cloneDeep(this.groups);
          this.oldAddedChannels = cloneDeep(this.channels);
          this.oldAddedSDCS = cloneDeep(this.sdcs);

          this.populatePriceListAllCustomerAppliedTo();

        } else {
          this.channels = [];
          this.groups = [];
          this.customersDataSource = {
            totalItems: 0,
            data: []
          };
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  appliedCustomerExceclude:any[]=[]
  populatePriceListAllCustomerAppliedTo() {
    this.priceService.getPriceListOriginalAppliedLists(-1).subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {
          this.allCustomersList = response.data.appliedCustomers;
          if(this.isEditMode){
         this.addedCustomersList.forEach(customer=>{
           this.appliedCustomerExceclude.push(customer)
         })
            this.addedCustomersList.forEach((customerAdded)=>{
              this.allCustomersList = this.allCustomersList.filter(customer=>customer.customerId!=customerAdded.customerId)
            })
          }
          //this.oldAddedCustomers = cloneDeep(this.addedCustomersList);


        } else {
          this.channels = [];
          this.groups = [];
          this.customersDataSource = {
            totalItems: 0,
            data: []
          };
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  initForm() {

    this.priceLisDataForm = new FormGroup({
      priceListId: new FormControl({ value: null, disabled: true }),
      priceListCode: new FormControl({ value: null, disabled: this.isViewMode }, Validators.required),
      priceListName: new FormControl({ value: null, disabled: this.isViewMode }, Validators.required),
      priority: new FormControl({ value: 1, disabled: this.isViewMode }),
      priceListTypeId: new FormControl({ value: PriceListTypes.General.valueOf(), disabled: this.isViewMode }),
      organizationId: new FormControl({ value: this.coreSession.CurrentOperator.organizationId, disabled: this.isViewMode }, Validators.required),
      fromToDate: new FormControl({ value: [], disabled: this.isViewMode }, Validators.required),
      // fromToDate: new FormControl({value:[this.fromToDate[0].date,this.fromToDate[1].date], disabled: this.isEditMode && !this.editAvailable}, Validators.required),
      groupsControl: new FormControl([]),
      channelControl: new FormControl(),
      sdcsList: new FormControl([]),
      currencyId: new FormControl(null),
      packId: new FormControl(),
      divisionId: new FormControl(),
      itemCategoryId: new FormControl(),
      packGroupId: new FormControl(null),
      price: new FormControl(0),
      tax: new FormControl(0),
      minPrice: new FormControl(0),
      maxPrice: new FormControl(0),
      quantityRangeId: new FormControl(null),
      stockStatusId: new FormControl({ value: null, disabled: this.isViewMode }),
      salesOrderTypeId: new FormControl({ value: null, disabled: this.isViewMode }),
      isDefault : new  FormControl({ value: false, disabled: this.isViewMode }),
    });

    this.quantityRange = new FormGroup({
      rangeStart: new FormControl(null, Validators.required),
      rangeEnd: new FormControl(null, Validators.required),
    })
    if(!this.isEditMode && !this.isViewMode)
    this.mutilItemShow = true

    var isShowButtonIsDefault = this.selectedPriceListObj?this.selectedPriceListObj.priceListId?true:false:false
    if(isShowButtonIsDefault && !this.isEditMode || this.isViewMode)
      this.showButtonIsDefault = false
    else{
      this.showButtonIsDefault = true
    }


  }
  fillFormInEditMode(priceListID?) {
    this.selectedPriceListObjDialog?.priceListId?
       this.priceLisDataForm = new FormGroup({
      priceListId: new FormControl({ value: this.selectedPriceListObjDialog.priceListId, disabled: true }),
      priceListCode: new FormControl({ value: this.selectedPriceListObjDialog.priceListCode, disabled: this.isViewMode }, Validators.required),
      priceListName: new FormControl({ value: this.selectedPriceListObjDialog.priceListName, disabled: this.isViewMode }, Validators.required),
      priority: new FormControl({ value: this.selectedPriceListObjDialog.priority, disabled: this.isViewMode }, Validators.required),
      priceListTypeId: new FormControl({ value: PriceListTypes.General.valueOf(), disabled: this.isViewMode }, Validators.required),
      organizationId: new FormControl({ value: this.coreSession.CurrentOperator.organizationId, disabled: this.isViewMode }, Validators.required),
      fromToDate: new FormControl({ value: [this.fromToDate[0].date, this.fromToDate[1].date], disabled: this.isViewMode }, Validators.required),
      groupsControl: new FormControl(this.selectedPriceListObjDialog.appliedGroups),
      channelControl: new FormControl(this.selectedPriceListObjDialog.appliedChannels),
      sdcsList: new FormControl(this.selectedPriceListObjDialog.appliedSDCs),
      currencyId: new FormControl(null),
      packId: new FormControl(),
      divisionId: new FormControl(),
      itemCategoryId: new FormControl(),
      price: new FormControl(0),
      tax: new FormControl(0),
      minPrice: new FormControl(0),
      maxPrice: new FormControl(0),
      packGroupId: new FormControl(null),
      quantityRangeId: new FormControl(null),
      isDefault : new  FormControl(this.selectedPriceListObjDialog.isDefault==1?true:false),
      stockStatusId: new FormControl(this.selectedPriceListObjDialog.stockStatusId > 0 ? this.selectedPriceListObj.stockStatusId : null),
      salesOrderTypeId: new FormControl(this.selectedPriceListObjDialog.salesOrderTypeId > 0 ? this.selectedPriceListObj.salesOrderTypeId : null),
    }):
    this.priceLisDataForm = new FormGroup({
      priceListId: new FormControl({ value: this.selectedPriceListObj.priceListId, disabled: true }),
      priceListCode: new FormControl({ value: this.selectedPriceListObj.priceListCode, disabled: this.isViewMode }, Validators.required),
      priceListName: new FormControl({ value: this.selectedPriceListObj.priceListName, disabled: this.isViewMode }, Validators.required),
      priority: new FormControl({ value: this.selectedPriceListObj.priority, disabled: this.isViewMode }, Validators.required),
      priceListTypeId: new FormControl({ value: PriceListTypes.General.valueOf(), disabled: this.isViewMode }, Validators.required),
      organizationId: new FormControl({ value: this.coreSession.CurrentOperator.organizationId, disabled: this.isViewMode }, Validators.required),
      fromToDate: new FormControl({ value: [this.fromToDate[0].date, this.fromToDate[1].date], disabled: this.isViewMode }, Validators.required),
      groupsControl: new FormControl(this.selectedPriceListObj.appliedGroups),
      channelControl: new FormControl(this.selectedPriceListObj.appliedChannels),
      sdcsList: new FormControl(this.selectedPriceListObj.appliedSDCs),
      currencyId: new FormControl(null),
      packId: new FormControl(),
      divisionId: new FormControl(),
      itemCategoryId: new FormControl(),
      price: new FormControl(0),
      tax: new FormControl(0),
      minPrice: new FormControl(0),
      maxPrice: new FormControl(0),
      packGroupId: new FormControl(null),
      quantityRangeId: new FormControl(null),
      isDefault : new  FormControl(this.selectedPriceListObj.isDefault==1?true:false),
      stockStatusId: new FormControl(this.selectedPriceListObj.stockStatusId > 0 ? this.selectedPriceListObj.stockStatusId : null),
      salesOrderTypeId: new FormControl(this.selectedPriceListObj.salesOrderTypeId > 0 ? this.selectedPriceListObj.salesOrderTypeId : null),
    })

    this.selectedOrganization.organizationId = this.selectedPriceListObjDialog.priceListId?this.selectedPriceListObjDialog.organizationId:this.selectedPriceListObj.organizationId;
    if (this.forceOrganizationFilterForCustomerGroups())
      this.populateGroupsList();

    if(this.enableSalesDistributionChannel) {
      this.fillSDCsList();
    }
    var ismutilItemShow = priceListID?true:false
        if(ismutilItemShow){
          this.mutilItemShow = false;
        }
  else{
    this.mutilItemShow = true;
  }
    this.isDefaultPrice = this.selectedPriceListObjDialog.priceListId?this.selectedPriceListObjDialog.isDefault:this.selectedPriceListObj.isDefault;
    if(this.isDefaultPrice)
      this.navLinks[2].hidden = true;
  }

  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Price_Definition',
        index: 0,
        isActive: false,
        hidden: false
      },
      {
        label: 'Desc_Items',
        index: 1,
        isActive: false,
        hidden: false
      },
      {
        label: 'Desc_Applied_To_Cap',
        index: 2,
        isActive: false,
        hidden: false
      }
    ];
  }

  populateGroupsList() {

    this.allGroupsList = [];
    let organizationId = this.organizationControl ? this.organizationControl.value : "";
    this.customerService.getAllCustomerGroups(organizationId).subscribe(result => {
      this.allGroupsList = result.data;
    });
  }
  populateChannelsSubChannelsList() {
    this.customerService.GetAllCustomerChannels(null).subscribe(result => {
      this.allChannelsList = result;
    });
  }
  packGroupsList: any[] = [];
  populatePackGroupList() {
    var filter = {
      getGroupsHavingSamePackQuantity: false,
      selectedOraganizationIds: ''
    }
    this.packGroupService.getPackGroups(filter).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.packGroupsList = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  fillSDCsList(setCheckedValue: boolean = false) {

    var previousControlValue = [];
    if (setCheckedValue) {
      previousControlValue = this.sdcsControl && this.sdcsControl.value ? this.sdcsControl.value : [];
    }
    this.allSDCsList = [];
    let organizationIdsString = this.organizationControl.value ? this.organizationControl.value + "" : null;
    if(organizationIdsString != null) {
      var filter = {
        organizationIds: organizationIdsString
      }
      this.customerService.getAllSalesDistributionChannels(filter).subscribe(result => {
        this.allSDCsList = result && result.data ? result.data : [];

        if(setCheckedValue) {
          var temp = cloneDeep(this.allSDCsList);
          this.allSDCsList = [];
          this.allSDCsList = temp;
          this.sdcsControl.setValue(previousControlValue.filter(sdc => this.allSDCsList.map(s => s.sdcId).includes(sdc.sdcId) ));
        }
      });
    }
  }
  onNameOtherLanguagesTextSubmitted(event) {
    this.priceListNameOtherLanguages = event;
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events?.subscribe(() => {
      this.onSaveClicked();
    });
  }
  ngOnDestroy() {
    this.saveBtnSubscription?.unsubscribe();
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }


    this.componentVisitService.markComponentVisited('price-entry');
    this.mutilItemShow =false
  }
  isCustomerConflect=false;
  onSaveClicked() {

    if (this.priceLisDataForm.invalid) {
      this.coreSession.markFormGroupTouched(this.priceLisDataForm as FormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      this.ChangeDataView(0);
      return;
    }
    if (!this.validateItems()) return;


    if(this.isDefaultPrice && this.itemsDataSource.data.length ==0 || this.itemsDataSource.data.length ==0){
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_Add_Items_For_Price_List));
      return;
    }
    // if(this.customersDataSource.data.length==0 && !this.isDefaultPrice){
    //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_Add_Customers_For_Price_List));
    //   return;
    // }


    this.isCustomerConflect =false
    if(this.isEditMode){
      this.appliedCustomerExceclude.forEach(customerExceclude=>{
        var index =  this.allCustomersList.findIndex(customer=>customer.customerId==customerExceclude.customerId)
        if(index>-1)
          this.allCustomersList.splice(index,1)
      })
    }


    for (let i = 0; i < this.addedCustomersList.length; i++) {
      const selectCustomer = this.addedCustomersList[i];
      const isConflectCustomerIndex = this.allCustomersList.findIndex(customer => customer.customerId === selectCustomer.customerId);
      if (isConflectCustomerIndex > -1) {
        this.isCustomerConflect =true
        this.openSelectCustomersDialog(true)
        break;
      }
    }

    if(!this.isCustomerConflect){
      this.fillPriceListObj();
      this.priceService.savePriceList(this.selectedPriceListObj, this.isEditMode).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          if (response.data != null && response.data == 7) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgRefreshData));
          } else {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);

            this.priceService.deleteCustomerAppliedInPriceList(this.approvedAppliedCustomerDelete).subscribe((res:any)=>{
              if(res)
              this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),this.translateService.instant(res));//

          })

            if(this.selectedPriceListObj.isDefault==true)
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(this.selectedPriceListObj.priceListName+" "+this.selectedPriceListObj.priceListCode + " "+ this.translateService.instant(ConstantMessages.Desc_isDefaultPriceList) ));//


          this.onSaveCompleted.emit(this.selectedPriceListObj);
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
    (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
  );

}
}
  removeCustomerapplied(event:any){
  var index = this.addedCustomersList.findIndex(customer=>customer.customerId ==event.object.customerId)
  if(index >-1)
    this.addedCustomersList.splice(index,0)
  }
  validateItems() {
    let item = null;
    this.fillItemsList();

    // if (this.showMinMaxPrice) {
    //   item = this.itemsDataSource.data.find(element => +element.price < +element.minPrice || +element.price > +element.maxPrice || element.price == 0);

    //   if (item != null) {
    //     let errorMsg = item.itemCodeName + ':' + this.translateService.instant(ConstantMessages.MsgPriceNotBetweenMinAndMaxPrices);
    //     this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), errorMsg);
    //     return false;
    //   }
    // }

    if (this.selectedPriceListType != PriceListTypes.Retail.valueOf() && this.selectedPriceListType != PriceListTypes.CostPrice.valueOf()) {
      let index = this.itemsDataSource.data.findIndex((e) => !e.quantityRangeId || e.quantityRangeId == null);

      if (index > -1) {
        let errorMsg = this.itemsDataSource.data[index].itemCodeName + ':' + this.translateService.instant(ConstantMessages.MsgSelectQuantityRange);
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), errorMsg);
        return false;
      }
    }

    let isPriceZero = this.itemsDataSource.data.find(element => element.price <= 0);
    if (isPriceZero != null) {
      let errorMsg = isPriceZero.itemCodeName + ':' + this.translateService.instant(ConstantMessages.InvalidZeroPrice);
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), errorMsg);
      return false;

    }

    item = this.itemsDataSource.data.find(x => x.tax > 100);
    if (item != null) {
      let errorMsg = item.itemCodeName + ':' + this.translateService.instant(ConstantMessages.DescTaxNotMoreThan100);
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), errorMsg);
      return false;
    }
    return true;
  }

  validatePackGroupItemsList() {

    // if (this.showMinMaxPrice) {
    //   var price = this.priceLisDataForm.get('price').value;
    //   var minPrice = this.priceLisDataForm.get('minPrice').value;
    //   var maxPrice = this.priceLisDataForm.get('maxPrice').value;
    //   if (+price < +minPrice || +price > +maxPrice) {
    //     let errorMsg = this.selectedPackGroup.packGroupCode + ':' + this.translateService.instant(ConstantMessages.MsgPriceNotBetweenMinAndMaxPrices);
    //     this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), errorMsg);
    //     return false;
    //   }
    // }
    return true;
  }
  onTypeChanged(type: any) {
    this.selectedPriceListType = type && type != undefined ? type.priceListTypeId : -1;
    this.selectedPriceListTypeName = type && type != undefined ?  type.priceListTypeName : '';
    this.resetStockStatusData();
    this.resetSalesOrderTypeData();
    this.showStockStatusCombo = false;
    this.showSalesOrderTypeCombo = false;
    if (this.selectedPriceListType == PriceListTypes.Retail.valueOf() || this.selectedPriceListType == PriceListTypes.CostPrice.valueOf()) {
      this.priceLisDataForm.get('priceListTypeId').setValidators(null);
      this.priceLisDataForm.get('priceListTypeId').updateValueAndValidity();
    } else {
      this.priceLisDataForm.get('priceListTypeId').setValidators(Validators.required);
      this.priceLisDataForm.get('priceListTypeId').updateValueAndValidity();
    }
    if(this.selectedPriceListType === PriceListTypes.General.valueOf()) {
      if(this.allowSelectSalesOrderType) this.showSalesOrderTypeCombo = true;
      if(this.allowSelectStockStatusType) this.showStockStatusCombo = true;
    }
    this.setItemDefinitionColumns();

  }

  resetStockStatusData() {
    this.priceLisDataForm.get('stockStatusId').setValue(null);
  }
  resetSalesOrderTypeData() {
    this.priceLisDataForm.get('salesOrderTypeId').setValue(null);
  }

  onItemSelected(itemObj: any) {

    this.selectedItemFromLazyLoading = itemObj;
  }

  selectedMultiItems : any[]= []
  onItemsSelected(selectedItems:any) {

    this.selectedMultiItems = selectedItems;
  }

  onRowClicked(event: any) {
    this.selectedItemFromDataSource = event.object;

    switch (event.operation) {
      case RowOperation.delete:
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              if (event.object.priceDefinitionId > 0) {
                this.deletedItems.push(event.object);
              }
              let index = this.addedItemList.findIndex(a => a.packId === event.object.packId && a.quantityRangeId ==event.object.quantityRangeId );

              this.addedItemList.splice(index, 1);
              this.fillItemsList();
            }
          });

        break;
      case RowOperation.rowClick:

        break;

      case RowOperation.add:
        this.addTaxForItem = true;
        this.addTaxPerItem(this.selectedItemFromDataSource);
        break;
      case RowOperation.addQtyRange:
        this.addTaxForItem = true;
        this.showQtyRangeModal();
        break;
    }
  }

  addTaxPerItem(item: any) {
    if (item.taxTypes && item.taxTypes != null && item.taxTypes.length > 0) {
      this.totalTax = this.calculateTotalTax(item.taxTypes);
      this.getTypesDataSource(item.taxTypes);
      this.showTaxTypeDialog();
    } else {
      this.getDefaultTypesDataSource();
      this.showTaxTypeDialog();
    }
    this.taxChangeTempByItem = JSON.parse(JSON.stringify(this.taxTypesDataSource.data));
  }

  onEditItemPriceDefinition(event: any) {//check this
    if (this.isEditMode) {
      if (event.object.priceDefinitionId > 0) {
        event.object.dataAction = DataActions.Edit;
      }
    }

    this.onQuantityRangeChanged(event);
  }
  onCreationDateSelected(date: any[]) {
    if (date)
      this.fromToDate = date;
  }
  ChangeDataView(index: number) {

    // if (this.priceLisDataForm.invalid) {
    //   this.coreSession.markFormGroupTouched(this.priceLisDataForm as FormGroup);
    //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));

    //   return;
    // }
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }

    else if (!this.organizationControl.value || this.organizationControl.invalid) {
      this.organizationControl.markAsTouched();
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.SelectOrganization));
      return;
    }
    if (index > 0) {
      this.organizationControl.markAsTouched();
      if (this.organizationControl.invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
    }
    if (this.addedCustomersList && this.addedCustomersList.length != this.customersDataSource.data.length) {
      this.fillCustomersList();
    }
    this.showAppliedSharedTable= false
    this.showItemSharedTable = false
    this.navLinks.forEach(a => a.isActive = false);
    if(this.priceLisDataForm.invalid && index > 0){
      this.priceLisDataForm.markAllAsTouched()
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      this.navBarSelectedIndex = 0;
      this.navLinks[0].isActive = true;
      return;
    }
    else if((this.isDefaultPrice && this.itemsDataSource.data.length ==0 || this.itemsDataSource.data.length ==0) && (index !=1 )){
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_Add_Items_For_Price_List));
      this.navBarSelectedIndex = 1;
      this.navLinks[1].isActive = true;
      return;
    }
    this.navBarSelectedIndex = index;
    this.navLinks[index].isActive = true;
    var elementSelectors
    switch(index){
      case 0 :
 elementSelectors = ['#price-def',
        '#date-def','#isDefaultToggle'
      ] // Target each column by its unique ID
        this.startTour(elementSelectors,'MainData')
      break
      case 1 :
        elementSelectors = ['#division-def','#category-def','#item-def'
          ,'#quantity-Range-def','#Add-item-def'
        ] // Target each column by its unique ID
     this.startTour(elementSelectors,'Item')
break
case 2 :
  // elementSelectors = ['#group-def'] // Target each column by its unique ID
  // this.startTour(elementSelectors,'ApplyToData')
break
}

  }
  get groupsControl() {
    return this.priceLisDataForm.get('groupsControl');
  }
  get channelsControl() {
    return this.priceLisDataForm.get('channelControl');
  }
  get organizationControl() {
    return this.priceLisDataForm.get('organizationId');
  }
  get sdcsControl() {
    return this.priceLisDataForm.get('sdcsList');
  }
  onOrganizationSelected(org: any) {
    if ((this.ForceCustomerOrganizationSelection || this.forceOrganizationFilterForCustomerGroups()) &&
      (this.addedCustomersList && this.addedCustomersList.length > 0) ||
      (this.groupsControl.value && this.groupsControl.value.length > 0) ||
      (this.channelsControl.value && this.channelsControl.value.length > 0) ||
      (this.enableSalesDistributionChannel && this.sdcsControl.value && this.sdcsControl.value.length > 0)) {
      this.organizationControl.setValue(this.selectedOrganization ? this.selectedOrganization.organizationId : null);
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgChangeOrganizationRemoveApplyData), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.selectedOrganization = org;
            this.organizationControl.setValue(this.selectedOrganization ? this.selectedOrganization.organizationId : null);
            this.groupsControl.setValue([]);
            this.channelsControl.setValue([]);
            this.sdcsControl.setValue([]);
            this.addedCustomersList = [];
            this.fillCustomersList();
            if (this.forceOrganizationFilterForCustomerGroups()) {
              this.populateGroupsList();
            }
            if(this.enableSalesDistributionChannel) {
              this.fillSDCsList();
            }
          } else {
            this.organizationControl.setValue(this.selectedOrganization.organizationId);
          }
        });
    } else {
      this.selectedOrganization = org;
      if(this.enableSalesDistributionChannel)
        this.fillSDCsList();
    }

    if (this.forceOrganizationFilterForCustomerGroups()) {
      this.populateGroupsList();
    }
  }

  onhideAppliedCustomer(){

    var isDefault = this.priceLisDataForm.get('isDefault').value
    if(isDefault){
      this.navLinks[2].hidden = false;
      this.isDefaultPrice = false
    }
  else{
    this.navLinks[2].hidden = true;
    this.isDefaultPrice = true
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_Applied_Customer_Data_Cleared));

  }


  }
  addItemToPriceList(fromItemForm: boolean) {
    if (fromItemForm && this.isApplyTaxTypesInPrices) {
      this.getDefaultTypesDataSource();
      this.totalTax = 0;
      this.priceLisDataForm.get('tax').setValue(0);
    }
    // if (this.addedItemList && this.addedItemList.length > 0) {
    //   let index = -1;
    //   this.selectedMultiItems.forEach(item=>{
    //     if (this.selectedPriceListType == PriceListTypes.Retail.valueOf() || this.selectedPriceListType == PriceListTypes.CostPrice.valueOf()) {
    //       index = this.addedItemList.findIndex(a => a.packId === item.packId );
    //     } else {
    //       index = this.addedItemList.findIndex(a => a.packId === item.packId
    //         && a.quantityRangeId == this.priceLisDataForm.get('quantityRangeId').value);
    //     }

    //     if (index >= 0 && !this.overwrite && !this.isFromPackGroup) {
    //       this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgItemAlreadyAdded));
    //       if (this.itemsDataSource.data.length > 1) {
    //         let tempObject = this.itemsDataSource.data[index];
    //         this.itemsDataSource.data[index] = this.itemsDataSource.data[0];
    //         this.itemsDataSource.data[0] = tempObject;
    //         this.refreshData = this.refreshData == true ? false : true;
    //       }
    //       return;
    //     } if (index >= 0 && !this.overwrite && this.isFromPackGroup) {

    //       return;
    //     } else if (index >= 0 && this.overwrite) {
    //       this.addedItemList.find(a => a.packId === item.packId ).price = +this.priceLisDataForm.get('price').value;
    //       this.addedItemList.find(a => a.packId === item.packId ).tax = +this.priceLisDataForm.get('tax').value;
    //       this.addedItemList.find(a => a.packId === item.packId ).minPrice = +this.priceLisDataForm.get('minPrice').value;
    //       this.addedItemList.find(a => a.packId === item.packId ).maxPrice = +this.priceLisDataForm.get('maxPrice').value;
    //       if (this.isEditMode || this.isDeleteMode) {
    //         this.addedItemList.find(a => a.packId === item.packId ).dataAction = DataActions.Edit;
    //       }

    //       this.fillItemsList();
    //       return;
    //     }
    //   })

    // }
    this.prepareItemDefinitionObj();

    this.fillItemsList();
    this.selectedMultiItems = [];
    this.clearSelectEvent.emit();
    this.priceLisDataForm.get('packId').setValue(null);
    if(this.qtyRangeList && this.qtyRangeList.length > 0)
    {
      this.priceLisDataForm.get('quantityRangeId').setValue(this.qtyRangeList[0].quantityRangeId)
    }
  }




  fillCustomersList() {
    this.customersDataSource = {
      totalItems: this.addedCustomersList.length,
      data: this.addedCustomersList
    };

  }
  fillItemsList() {
    this.itemsDataSource = {
      totalItems: this.addedItemList.length,
      data: this.addedItemList
    };
    this.itemsDataSourceTemp = {
      totalItems: this.addedItemList.length,
      data: this.addedItemList
    };

  }
  onRowOperationForCustomers(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.onDeleteAppliedCustomer(event.object);
        break;
    }
  }
  approvedAppliedCustomerDelete:any[] = []
  openSelectCustomersDialog(isConflectCustomer: boolean = false) {

    if(isConflectCustomer){
      var ConflectCustomersList =[]
      this.addedCustomersList.forEach(selectCustomer => {
        const ConflictCustomer = this.allCustomersList.find(customer => customer.customerId === selectCustomer.customerId);
        if (ConflictCustomer)
          ConflectCustomersList.push(ConflictCustomer);
      });
      this.copyOfAddedCustomers = null;

      this.copyOfAddedCustomers = ConflectCustomersList;

      this.selectCustomerDialog.showDialog(this.organizationControl.value,[]).then(
        (result:any) => {

          if (result != -1) {
            if(isConflectCustomer){
              this.copyOfAddedCustomers = [];
              if(result.rejectCustomer.length > 0)
                result.rejectCustomer.forEach(rejectCustomer => {

              var index =  this.addedCustomersList.findIndex(customer=>customer.customerId==rejectCustomer.customerId)
              if(index>-1)
                this.addedCustomersList.splice(index,1)
            });
            this.approvedAppliedCustomerDelete = cloneDeep(result.approvCustomer);
              if(result.approvCustomer.length>0)
                result.approvCustomer.forEach(approvCustomer => {

                  var index =  this.allCustomersList.findIndex(customer=>customer.customerId==approvCustomer.customerId)
                  if(index>-1)
                    this.allCustomersList.splice(index,1)
                });

              this.onSaveClicked()
          }

              else{

                this.afterAddingSelectedCustomers(result)
            }
          } else {
            this.copyOfAddedCustomers = []
            this.isCustomerConflect = false
            this.closeSelectCustomersDialog();
          }
        });

    }else{
      this.copyOfAddedCustomers = null;
      this.copyOfAddedCustomers = cloneDeep(this.addedCustomersList);
      this.showSelectCustomersDialog = true;
      this.selectCustomerDialog.showDialog(this.organizationControl.value).then(
        (result) => {
          if (result != -1) {
            this.afterAddingSelectedCustomers(result)
          } else {
            this.closeSelectCustomersDialog();
          }
        });
    }

  }
  showSlider:boolean = false
  viewCustomerConflect(customerConflect:any){

this.populatePriceListHeader(customerConflect.priceListID);
        this.populatePriceListData(customerConflect.priceListID);
        this.populatePriceListAppliedTo(customerConflect.priceListID);
  }
  closeSlider() {
    this.isViewMode = false;
    this.showSlider = false;}

  closeSelectCustomersDialog() {
    this.showSelectCustomersDialog = false;
    if (this.isEditMode) {
      this.coreSession.SetTitle('Edit Price');
    } else {
      this.coreSession.SetTitle('Add Price');
    }
  }
  afterAddingSelectedCustomers(selectedCustomers) {
    this.addedCustomersList = selectedCustomers;
    this.fillCustomersList();
    this.closeSelectCustomersDialog();
  }
  onDeleteAppliedCustomer(deletedOutlet: any) {
    var index = this.addedCustomersList.findIndex(x => x.customerId === deletedOutlet.customerId && x.outletId === deletedOutlet.outletId);
    if (index >= 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.addedCustomersList.splice(index, 1);
            this.fillCustomersList();
          }
        });
    }
  }
  fillPriceListObj() {
    if (!this.isEditMode && !this.isDeleteMode) {
      this.selectedPriceListObj = {};
      this.selectedPriceListObj.priceListId = -1;
    }
    if (!this.isDeleteMode) {
      this.selectedPriceListObj.priceListName = this.priceLisDataForm.value.priceListName;
      this.selectedPriceListObj.priceListCode = this.priceLisDataForm.value.priceListCode;
      this.selectedPriceListObj.organizationId = +this.priceLisDataForm.value.organizationId;
      this.selectedPriceListObj.organizationName = this.selectedOrganization.organizationName;
      this.selectedPriceListObj.priceListTypeId = +this.priceLisDataForm.value.priceListTypeId;
      this.selectedPriceListObj.priceListType = this.selectedPriceListTypeName;
      this.selectedPriceListObj.priority = +this.priceLisDataForm.value.priority;
      this.selectedPriceListObj.isDefault= this.priceLisDataForm.value.isDefault;
      this.selectedPriceListObj.salesOrderTypeId = this.priceLisDataForm.value.salesOrderTypeId ? this.priceLisDataForm.value.salesOrderTypeId : -1;
      this.selectedPriceListObj.stockStatusId = this.priceLisDataForm.value.stockStatusId ? this.priceLisDataForm.value.stockStatusId : -1;
      let descriptions = [];
      if (this.priceListNameOtherLanguages) {
        descriptions = this.priceListNameOtherLanguages;
        let index = descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
        if (index == -1) {
          descriptions.push({
            languageId: this.coreSession.selectedLanguageId,
            description: this.priceLisDataForm.get('priceListName').value
          });
        } else {
          descriptions[index].description = this.priceLisDataForm.get('priceListName').value;
        }
      }

      this.selectedPriceListObj.priceListDescriptionLanguages = descriptions;
      if (this.fromToDate && this.fromToDate.length == 2) {
        this.selectedPriceListObj.startDateModel = this.fromToDate[0];
        this.selectedPriceListObj.endDateModel = this.fromToDate[1];
      }
      this.selectedPriceListObj.startDate = null;
      this.selectedPriceListObj.endDate = null;
      // this.selectedPriceListObj.priceListItems=this.itemsDataSource.data;
      this.selectedPriceListObj.priceListItems = this.itemsDataSourceTemp.data;
      this.selectedPriceListObj.priceListItems.forEach(element => {
        element.price = +element.price;
        element.tax = +element.tax;
        element.minPrice = +element.minPrice;
        element.maxPrice = +element.maxPrice;
        element.netPrice = +element.netPrice;

        element.taxTypes = element.taxTypes;
        if (element.priceDefinitionId != -1) {
          element.dataAction = DataActions.Edit;
        } else {
          element.dataAction = DataActions.Add;
        }
      });
      if (this.isApplyTaxTypesInPrices) {
        this.getDefaultTypesDataSource();
      }
      this.selectedPriceListObj.deletedPriceListItems = this.deletedItems;
      this.selectedPriceListObj.appliedGroups = this.priceLisDataForm.value.groupsControl;
      this.selectedPriceListObj.appliedChannels = this.priceLisDataForm.value.channelControl;
      // this.selectedPriceListObj.appliedCustomers = this.customersDataSource.data;
      if(!this.isDefaultPrice)
      this.selectedPriceListObj.appliedCustomers = this.addedCustomersList; // this.customersDataSource.data;
    else
    this.selectedPriceListObj.appliedCustomers = []

      this.selectedPriceListObj.appliedSDCs = this.priceLisDataForm.value.sdcsList;
      this.fillPriceDefinitionAuditInNew();
      if (this.isEditMode || this.isDeleteMode) {
        this.fillAuditDataInEdit();
        this.fillPriceDefinitionAuditInEdit();
        this.fillNewlyAddedAppliedTo();
      }
      else {

        this.fillAuditDataInNew();
      }
    }


  }
  fillNewlyAddedAppliedTo() {
    if (!this.selectedPriceListObj.newlyAddedCustomers) this.selectedPriceListObj.newlyAddedCustomers = [];
    this.selectedPriceListObj.appliedCustomers.forEach(element => {
      if (this.oldAddedCustomers.findIndex(a => a.customerId === element.customerId && a.outletId === element.outletId) == -1) {
        this.selectedPriceListObj.newlyAddedCustomers.push(element);
      }
    });
    if (!this.selectedPriceListObj.newlyAddedGroups) this.selectedPriceListObj.newlyAddedGroups = [];
    this.selectedPriceListObj.appliedGroups.forEach(element => {
      if (this.oldAddedGroups.findIndex(a => a.groupId === element.groupId) == -1) {
        this.selectedPriceListObj.newlyAddedGroups.push(element);
      }
    });
    if (!this.selectedPriceListObj.newlyAddedChannels) this.selectedPriceListObj.newlyAddedChannels = [];
    this.selectedPriceListObj.appliedChannels.forEach(element => {
      if (this.oldAddedChannels.findIndex(a => a.channelSubChannelIds === element.channelSubChannelIds) == -1) {
        this.selectedPriceListObj.newlyAddedChannels.push(element);
      }
    });
    if(this.enableSalesDistributionChannel) {
      if (!this.selectedPriceListObj.newlyAddedSDCs) this.selectedPriceListObj.newlyAddedSDCs = [];
      this.selectedPriceListObj.appliedSDCs.forEach(element => {
        if (this.oldAddedSDCS.findIndex(a => a.sdcId === element.sdcId) == -1) {
          this.selectedPriceListObj.newlyAddedSDCs.push(element);
        }
      });
    }
  }
  fillPriceDefinitionAuditInNew() {

    var addedList = this.selectedPriceListObj.priceListItems.filter(a => a.dataAction === DataActions.Add);
    if (addedList && addedList.length > 0) {
      addedList.forEach(element => {
        var auditList = [];
        auditList.push({
          auditId: -1,
          fieldNumber: 1,
          fieldName: 'Item',
          oldValue: '',
          newValue: element.itemName + ''
        });
        auditList.push({
          auditId: -1,
          fieldNumber: 2,
          fieldName: 'Item Code',
          oldValue: '',
          newValue: element.itemCode + ''
        });
        auditList.push({
          auditId: -1,
          fieldNumber: 3,
          fieldName: 'UOM',
          oldValue: '',
          newValue: element.uom + ''
        });
        auditList.push({
          auditId: -1,
          fieldNumber: 4,
          fieldName: 'Price',
          oldValue: '',
          newValue: element.price + ''
        });
        auditList.push({
          auditId: -1,
          fieldNumber: 5,
          fieldName: 'Tax',
          oldValue: '',
          newValue: element.tax + ''
        });
        auditList.push({
          auditId: -1,
          fieldNumber: 8,
          fieldName: 'Currency',
          oldValue: '',
          newValue: ''
        });
        auditList.push({
          auditId: -1,
          fieldNumber: 10,
          fieldName: 'MaxPrice',
          oldValue: '',
          newValue: element.maxPrice + ''
        });
        auditList.push({
          auditId: -1,
          fieldNumber: 11,
          fieldName: 'MinPrice',
          oldValue: '',
          newValue: element.minPrice + ''
        });
        if (this.applyNetPrice) {
          auditList.push({
            auditId: -1,
            fieldNumber: 9,
            fieldName: 'Net Price',
            oldValue: '',
            newValue: element.netPrice + ''
          });
        }

        element.priceDefinitionAuditDetails = auditList;
      });
    }
  }
  fillPriceDefinitionAuditInEdit() {
    var editedList = this.selectedPriceListObj.priceListItems.filter(a => a.dataAction === DataActions.Edit);
    if (editedList && editedList.length > 0) {

      editedList.forEach(element => {
        var auditList = [];
        var oldValue = this.oldAddedItems.find(x => +x.priceDefinitionId === +element.priceDefinitionId);
        if (oldValue) {
          if (oldValue.price !== element.price) {
            auditList.push({
              auditId: -1,
              fieldNumber: 4,
              fieldName: 'Price',
              oldValue: oldValue.price + '',
              newValue: element.price + ''
            });

          }
          if (oldValue.tax !== element.tax) {
            auditList.push({
              auditId: -1,
              fieldNumber: 5,
              fieldName: 'Tax',
              oldValue: oldValue.tax + '',
              newValue: element.tax + ''
            });

          }
          if (oldValue.maxPrice !== element.maxPrice) {
            auditList.push({
              auditId: -1,
              fieldNumber: 10,
              fieldName: 'MaxPrice',
              oldValue: oldValue.maxPrice + '',
              newValue: element.maxPrice + ''
            });
          }
          if (oldValue.minPrice !== element.minPrice) {
            auditList.push({
              auditId: -1,
              fieldNumber: 11,
              fieldName: 'MinPrice',
              oldValue: oldValue.minPrice + '',
              newValue: element.minPrice + ''
            });
          }

          if (oldValue.currencyId !== element.currencyId) {
            auditList.push({
              auditId: -1,
              fieldNumber: 8,
              fieldName: 'Currency',
              oldValue:  '',
              newValue:  ''
            });

          }
          if (this.applyNetPrice && oldValue.netPrice !== element.netPrice) {
            auditList.push({
              auditId: -1,
              fieldNumber: 9,
              fieldName: 'Net Price',
              oldValue: oldValue.netPrice + '',
              newValue: element.netPrice + ''
            });
          }
          element.priceDefinitionAuditDetails = auditList;
          oldValue = null;
        }
      });

    }
  }
  fillAuditDataInNew() {
    var auditList = [];

    auditList.push({
      auditId: -1,
      fieldNumber: 1,
      fieldName: 'Description',
      oldValue: '',
      newValue: this.selectedPriceListObj.priceListName
    });
    auditList.push({
      auditId: -1,
      fieldNumber: 2,
      fieldName: 'Code',
      oldValue: '',
      newValue: this.selectedPriceListObj.priceListCode
    });
    auditList.push({
      auditId: -1,
      fieldNumber: 3,
      fieldName: 'Priority',
      oldValue: '',
      newValue: this.selectedPriceListObj.priority + ''
    });
    auditList.push({
      auditId: -1,
      fieldNumber: 4,
      fieldName: 'Start Date',
      oldValue: '',
      newValue: this.selectedPriceListObj.startDateModel.date + ''
    });
    auditList.push({
      auditId: -1,
      fieldNumber: 5,
      fieldName: 'End Date',
      oldValue: '',
      newValue: this.selectedPriceListObj.endDateModel.date + ''
    });
    auditList.push({
      auditId: -1,
      fieldNumber: 6,
      fieldName: 'Price List Type',
      oldValue: '',
      newValue: this.selectedPriceListObj.priceListType
    });
    auditList.push({
      auditId: -1,
      fieldNumber: 8,
      fieldName: 'Organization',
      oldValue: '',
      newValue: ""//this.selectedPriceListObj.organizationName
    });

    this.selectedPriceListObj.priceListAuditDetails = auditList;
  }
  fillAuditDataInEdit() {
    var auditList = [];
    if (this.selectedPriceListObj.priceListName !== this.oldPriceListObj.priceListName) {
      auditList.push({
        auditId: -1,
        fieldNumber: 1,
        fieldName: 'Description',
        oldValue: this.oldPriceListObj.priceListName,
        newValue: this.selectedPriceListObj.priceListName
      });
    }
    if (this.selectedPriceListObj.priceListCode !== this.oldPriceListObj.priceListCode) {
      auditList.push({
        auditId: -1,
        fieldNumber: 2,
        fieldName: 'Code',
        oldValue: this.oldPriceListObj.priceListCode,
        newValue: this.selectedPriceListObj.priceListCode
      });
    }
    if (this.selectedPriceListObj.priority !== this.oldPriceListObj.priority) {
      auditList.push({
        auditId: -1,
        fieldNumber: 3,
        fieldName: 'Priority',
        oldValue: this.oldPriceListObj.priority + '',
        newValue: this.selectedPriceListObj.priority + ''
      });
    }
    if (this.selectedPriceListObj.startDateModel.date !== this.oldPriceListObj.startDateModel.date) {
      auditList.push({
        auditId: -1,
        fieldNumber: 4,
        fieldName: 'Start Date',
        oldValue: this.oldPriceListObj.startDateModel.date,
        newValue: this.selectedPriceListObj.startDateModel.date
      });
    }
    if (this.selectedPriceListObj.endDateModel.date !== this.oldPriceListObj.endDateModel.date) {
      auditList.push({
        auditId: -1,
        fieldNumber: 5,
        fieldName: 'End Date',
        oldValue: this.oldPriceListObj.endDateModel.date,
        newValue: this.selectedPriceListObj.endDateModel.date
      });
    }
    if (this.selectedPriceListObj.priceListTypeId !== this.oldPriceListObj.priceListTypeId) {
      auditList.push({
        auditId: -1,
        fieldNumber: 6,
        fieldName: 'Price List Type',
        oldValue: this.oldPriceListObj.priceListType,
        newValue: this.selectedPriceListObj.priceListType
      });
    }
    if (this.selectedPriceListObj.organizationId !== this.oldPriceListObj.organizationId) {
      auditList.push({
        auditId: -1,
        fieldNumber: 8,
        fieldName: 'Organization',
        oldValue: this.oldPriceListObj.organizationName,
        newValue: this.selectedPriceListObj.organizationName
      });
    }
    this.selectedPriceListObj.priceListAuditDetails = auditList;
  }
  prepareItemDefinitionObj() {
    this.selectedMultiItems.forEach(item=>{
      let index = this.addedItemList.findIndex(selectedItem => item.packId === selectedItem.packId && selectedItem.quantityRangeId == this.priceLisDataForm.get('quantityRangeId').value);
      if (index >= 0 && !this.overwrite) {
        var itemCodeName= item.itemCodeName && item.itemCodeName != '' ? item.itemCodeName : item.itemName + ' (' + item.uom + ')';
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), itemCodeName + " " + this.translateService.instant(ConstantMessages.MsgItemAlreadyAdded))
      }
      else{
        let itemSelected = {
          itemId: +item.itemId,
          packId: +item.packId,
          itemName: item.itemName,
          itemCode: item.itemCode,
          itemCodeName: item.itemCodeName && item.itemCodeName != '' ? item.itemCodeName : item.itemName + ' (' + item.uom + ')',
          uom: item.uom,
          price: this.priceLisDataForm.get('price').value ? this.priceLisDataForm.get('price').value : 0,
          tax: this.priceLisDataForm.get('tax').value ? this.priceLisDataForm.get('tax').value : 0,
          maxPrice: this.priceLisDataForm.get('maxPrice').value ? this.priceLisDataForm.get('maxPrice').value : 0,
          minPrice: this.priceLisDataForm.get('minPrice').value ? this.priceLisDataForm.get('minPrice').value : 0,
          netPrice: 0,
          currencyId: -1,
          currencyCodeName: "",
          quantityRangeId: this.priceLisDataForm.get('quantityRangeId').value != null ? this.priceLisDataForm.get('quantityRangeId').value : 1,
          oldQuantityRangeId: this.priceLisDataForm.get('quantityRangeId').value != null ? this.priceLisDataForm.get('quantityRangeId').value : 1,
          priceListId: +(this.selectedPriceListObj ? this.selectedPriceListObj.priceListId : -1),
          priceDefinitionId: -1,
          taxTypes:[],
          dataAction: DataActions.Add
        };

        if (this.taxTypesDataSource.data && this.taxTypesDataSource.data.length != 0) {
          itemSelected.taxTypes = this.taxTypesDataSource.data;
        }
          this.addedItemList.unshift(itemSelected);
        }
      }

    )
    }


  onDivisionSelected(division: any) {
    if (division)
      this.selectedDivisionId = +division.divisionId;
    else
      this.selectedDivisionId = -1;

    // this.priceLisDataForm.get('packId').setValue(null);
    this.selectedItemFromLazyLoading = {};
    this.selectedItemFromLazyLoading.packId = -1;
    // this.priceLisDataForm.get('packId').setValue(null);
  }
  onCategorySelected(category: any) {
    if (category)
      this.selectedCategoryId = +category.itemCategoryId;
    else
      this.selectedCategoryId = -1;

    // this.priceLisDataForm.get('packId').setValue(null);
    this.selectedItemFromLazyLoading = {};
    this.selectedItemFromLazyLoading.packId = -1;
    // this.priceLisDataForm.get('packId').setValue(null);
  }
  onSelectedCurrency(currency: any) {
    this.selectedCurrency = currency;
  }

  initShowForm() {
    this.showForm = new FormGroup({
      ShowButtonControl: new FormControl(false),
      packGroupId: new FormControl(),
    })
  }
  onChangeByPackGroupToggele() {
    if (this.isApplyTaxTypesInPrices) {
      this.getDefaultTypesDataSource();
      this.currentTaxTypeSelectedToPackGroup = this.taxTypesDataSource.data;
      this.totalTax = 0;
    }
    this.priceLisDataForm.get('tax').setValue(0);
    this.addTaxForItem = false;
  }

  onSelectPackGroupChange(event: any) {
    this.selectedPackGroup = event;
  }


  addTaxToPackGroup() {
    this.addTaxForItem = false;
    if (this.currentTaxTypeSelectedToPackGroup.length == 0 || this.currentTaxTypeSelectedToPackGroup.filter(x => x.tax != 0).length == 0) {
      this.totalTax = 0;
      this.priceLisDataForm.get('tax').setValue(this.totalTax);
      this.getDefaultTypesDataSource();
      this.currentTaxTypeSelectedToPackGroup = this.taxTypesDataSource.data;
    } else {
      this.getTypesDataSource(this.currentTaxTypeSelectedToPackGroup);
    }

    this.showTaxTypeDialog();
  }
  showTaxTypeDialog() {
    this.taxTypeDialog.Show(true).then(
      (res) => {
      }
    );
  }
  showConflectCustomerEntryDialog() {
    this.ConflectCustomerEntry.Show(true).then(
      (res) => {
      }
    );
  }


  onTaxTypeDialogResult(event: any) {
    if (this.totalTax < 0) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgInvalidTax));
      return;
    }
    if (this.showForm.get("ShowButtonControl").value == true && !this.addTaxForItem) {
      this.priceLisDataForm.get('tax').setValue(this.totalTax);
      this.currentTaxTypeSelectedToPackGroup = this.taxTypesDataSource.data;
      this.taxChangeTempByPackGroup = JSON.parse(JSON.stringify(this.taxTypesDataSource.data));
      this.taxTypeDialog.Close();
    } else {
      this.itemsDataSource.data.find(x => x.itemId == this.selectedItemFromDataSource.itemId && x.packId == this.selectedItemFromDataSource.packId).tax = this.totalTax;
      this.itemsDataSource.data.find(x => x.itemId == this.selectedItemFromDataSource.itemId && x.packId == this.selectedItemFromDataSource.packId).taxTypes = this.taxTypesDataSource.data;
      this.totalTax = 0;
      this.getDefaultTypesDataSource();
      this.taxTypeDialog.Close();
    }
    this.addTaxForItem = false;

  }

  onCancleDialog(event: any) {

    if (this.showForm.get("ShowButtonControl").value == true && !this.addTaxForItem) {
      this.getTypesDataSource(this.taxChangeTempByPackGroup);
      this.currentTaxTypeSelectedToPackGroup = this.taxTypesDataSource.data;
    } else {
      this.itemsDataSource.data.find(x => x.itemId == this.selectedItemFromDataSource.itemId && x.packId == this.selectedItemFromDataSource.packId).taxTypes = this.taxChangeTempByItem;
    }
    this.addTaxForItem = false;
  }
  onCancleAppliedCustomerDialog(event: any){
    this.showButtonIsDefault = true
  }



  getDefaultTypesDataSource() {
    this.taxTypesDataSource = {
      data: [],
      totalItems: 0
    }
    this.totalTax = 0;
    this.pricesAndOffersService.getTaxTypes().subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {
          this.taxTypesDataSource = {
            data: response.data,
            totalItems: response.data.length
          }
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }


  getTypesDataSource(list: any) {
    this.taxTypesDataSource = {
      data: [],
      totalItems: 0
    }
    this.taxTypesDataSource = {
      data: list,
      totalItems: list.length
    }
  }

  onpPlusMinusBtnClicked(event: any) {
    if (this.taxTypesDataSource.data && this.taxTypesDataSource.data.length > 0) {
      if (this.taxTypesDataSource.data.find(x => x.taxTypeId == event.object.taxTypeId).tax == 0) {
        return;
      }
      this.taxTypesDataSource.data.find(x => x.taxTypeId == event.object.taxTypeId).isPlusValue = !this.taxTypesDataSource.data.find(x => x.taxTypeId == event.object.taxTypeId).isPlusValue;

      this.taxTypesDataSource.data.find(x => x.taxTypeId == event.object.taxTypeId).tax = this.taxTypesDataSource.data.find(x => x.taxTypeId == event.object.taxTypeId).tax * -1;

      this.totalTax = this.calculateTotalTax(this.taxTypesDataSource.data);
    }
  }

  onTaxTypeChange(event: any) {
    if (event.object.tax == null || event.object.tax >= 0) {
      event.object.isPlusValue = true;
    }
    this.taxTypesDataSource.data.find(x => x.taxTypeId == event.object.taxTypeId).tax = +event.object.tax;
    this.totalTax = this.calculateTotalTax(this.taxTypesDataSource.data);
  }

  calculateTotalTax(list: any) {
    let sum: number = 0;
    list.forEach(element => {
      sum += element.tax;
    });
    if (!sum) {
      return 0;
    }
    return sum;
  }

  applySerachFilterOnFind() {
    this.itemsDataSource = this.itemsDataSourceTemp;
    if (this.selectedPacks != null && this.selectedPacks.length > 0) {
      let dataItems = this.itemsDataSource.data.filter(x => this.selectedPacks.includes(x.packId));
      this.itemsDataSource = { data: dataItems, totalItems: dataItems.length };
    } else {
      this.itemsDataSource = this.itemsDataSourceTemp;
    }

  }

  onReset() {
    this.showForm.get('packGroupId').setValue(null);
    this.selectedPacks = [];
  }

  onchangePackGrop(event: any) {
    if (event != undefined) {
      this.selectedPacks = [];
      event.packs.forEach(element => {
        this.selectedPacks.push(element.packId);
      });
    } else {
      this.selectedPacks = [];
    }
  }

  //#region  [Quantity Range]
  fillQuantityRangeList(selectedRangeId: number) {
    this.qtyRangeList = [];
    this.pricesAndOffersService.getQuantityRangeList().subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.qtyRangeList = response.data;
          if (this.qtyRangeList && this.qtyRangeList.length > 0) {
            if (selectedRangeId > 0) {
              this.priceLisDataForm.get('quantityRangeId').setValue(selectedRangeId);
            } else {
              this.priceLisDataForm.get('quantityRangeId').setValue(this.qtyRangeList[0].quantityRangeId)
            }
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  showQtyRangeModal() {
    this.quantityRange.reset();
    return this.modalService.open(this.quantityRangeDialog, { centered: true, size: 'md', scrollable: false }).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          return this.quantityRangeDialog;
        } else {
          return -1;
        }
      });
  }

  saveQuantityRange(modal: any) {

    let rangeStart = Number(this.quantityRange.get('rangeStart').value);
    let rangeEnd = Number(this.quantityRange.get('rangeEnd').value);
    if (this.quantityRange.valid) {
      if (rangeEnd <= rangeStart) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption)
          , this.translateService.instant(ConstantMessages.MsgEndRangelargerStartRange));
      } else {
        let quantityRange = {
          rangeStart: rangeStart,
          rangeEnd: rangeEnd
        }
        this.priceService.insertQuantityRange(quantityRange).subscribe(response => {
          if (response.status != null && response.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
              this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));

            this.fillQuantityRangeList(response.data);
            this.quantityRange.reset();
            modal.close();

            if (this.selectedItemFromDataSource != undefined) {
              let rowIndex = this.itemsDataSource.data.findIndex(x => x.packId == this.selectedItemFromDataSource.packId
                );
              if (rowIndex >= 0) {
                this.itemsDataSource.data[rowIndex].quantityRangeId = response.data;
              }
            }
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
          (error: HttpErrorResponse) => {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
          }
        );
      }
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption)
        , this.translateService.instant(ConstantMessages.MsgFillMandatory));
    }
  }

  onQuantityRangeChanged(event: any) {
    if (event) {
      let oldValue = event.object.oldQuantityRangeId;
      let newValue = event.object.quantityRangeId;

      if (this.selectedPriceListType != PriceListTypes.Retail.valueOf() && this.selectedPriceListType != PriceListTypes.CostPrice.valueOf()) {
        this.itemsDataSource.data[event.rowIndex].quantityRangeId = oldValue;
        let rowIndex = this.itemsDataSource.data.findIndex(x => x.packId == event.object.packId && x.quantityRangeId == newValue);
        if (rowIndex >= 0) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgCannotchangeQtyRange));
        } else {
          this.itemsDataSource.data[event.rowIndex].quantityRangeId = newValue;
          this.itemsDataSource.data[event.rowIndex].oldQuantityRangeId = newValue;
        }
      }
      this.fillItemsList()
      //this.refreshData = this.refreshData == true ? false : true;
    }
  }

  setOldValueForQuantityRange(event: any) {
    if (event) {
      this.oldValueQtyRange = event[0].quantityRangeId;
    }
  }


  //#endregion

  //#region Import Items From Excel Sheet

  afterImportItems(event: any) {
    if (event && event.itemsList.length > 0) {
      if (this.addedItemList && this.addedItemList.length > 0) {
        let itemsList: any = this.addedItemList.filter(x => x.priceDefinitionId > 0 && x.priceListId > 0);
        if (itemsList && itemsList.length > 0) {
          this.selectedPriceListObj.DeletedPriceListItems = (this.selectedPriceListObj.DeletedPriceListItems ? this.selectedPriceListObj.DeletedPriceListItems : []).concat(itemsList);
        }
      }
      this.fillQuantityRangeList(-1);
      this.addedItemList = event.itemsList;
      this.fillItemsList();
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption)
        , this.translateService.instant(ConstantMessages.MsgNoItemsFound));
    }
  }

  checkConatinsItems() {

    if (this.addedItemList && this.addedItemList.length > 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (result: DialogResult) => {
          if (result === DialogResult.Yes) {

            this.showImportDialog();
          }
        });

    } else {
      this.showImportDialog();
    }
  }

  showImportDialog() {

    if (this.selectedPriceListType == PriceListTypes.CostPrice || this.selectedPriceListType == PriceListTypes.Retail) {
      this.dataType = ImportDataTypes.ItemsPricesWithoutQtyRange;
    } else {
      this.dataType = ImportDataTypes.ItemsPricesWithQtyRange;
    }
    this.import.showDialog(this.dataType).then((res) => {
      if (res == -1) {
        return false;
      } else if (res == 1) {
      }
    });
  }
  onImportBtnClicked() {
    this.checkConatinsItems();
  }



  //#endregion

  forceOrganizationFilterForCustomerGroups() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true"
  }
}
