import { Component, OnInit, ViewChild } from '@angular/core';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { CoreSession } from '../../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { RowOperation, MultiSelectionOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { GeneralFilter } from '../../../../../shared/models/general/generalFilter.model';
import { PricesAndOffersService } from '../../prices-and-offers.service';
import { MainFilterComponent } from '../../../../../shared/components/filters/main-filter/main-filter.component';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { Subject } from 'rxjs';
import * as cloneDeep from 'lodash/cloneDeep';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { FormControl, FormGroup } from '@angular/forms';
import { DateTimeModel } from '../../../../../shared/models/dateTimeModel/date-time.model';
import { IDateTimePickerProperties } from '../../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { ApprovalCycleOperations } from '../../../../../shared/models/enums/approval-cycle-operations-enum';
import { NgbModal, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { PriceService } from '../../../../../shared/services/data-definition/prices-and-offers/price.service';
import { NavBarService } from '../../../../../core/sidebar/sidebar.service';
import { SharedDialogComponent } from '../../../../../shared/components/shared-dialog/shared-dialog.component';

@Component({
  selector: 'app-price-definition-list',
  templateUrl: './price-definition-list.component.html',
  styleUrls: ['./price-definition-list.component.css']
})
export class PriceDefinitionListComponent implements OnInit {
  //#region [DECLARATIONS]
  showStatusColumn = false;
  @ViewChild('PriceEntryDialog', { static: true }) PriceEntryDialog: SharedDialogComponent;

  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: true,
    showNewBtn: false,
    isMultiSelection: false,
    rowOperations: [

    ],
    multiSelectionOperations: [

    ],
    columns: [
      {
        title: 'Desc_Price_List_ID',
        key: 'priceListId',
        isSortable: true,
        width: '10%'
      },
      {
        title: 'Desc_Price_List_Code',
        key: 'priceListCode',
        isSortable: true,
        width: '15%'
      },
      {
        title: 'Desc_Vendor',
        key: 'organizationCodeName',
        isSortable: true,
        width: '10%'
      },
      {
        title: 'Desc_Price_List_Name',
        key: 'priceListName',
        isSortable: true,
        width: '15%'
      },
      {
        title: 'Desc_Price_List_Type',
        key: 'priceListType',
        isSortable: true,
        width: '15%'
      },
      {
        title: 'Desc_Start_Date',
        key: 'startDate',
        isSortable: true,
        isExpiryDate: true,
        width: '10%'
      },
      {
        title: 'Desc_End_Date',
        key: 'endDate',
        isSortable: true,
        isExpiryDate: true,
        width: '10%'
      }
    ]
  };

  showEditDeleteApprove:boolean =  true;
  modalReference: any;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  query: GeneralFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },

    customerId: -1,
    outletId: -1
  };
  isValidToAffect:any= false;

  //#endregion

  //#region [VIEW CHILD]
  @ViewChild('filter', { static: true }) mainFilter: MainFilterComponent;

  //#endregion
  saveSubject: Subject<void> = new Subject<void>();
  showSlider = false;
  isEditMode = false;
  isViewMode = false;
  isDeleteMode = false;
  isViewOriginalMode = false;
  isCreationMode = false;
  isViewPendingMode = false;
  selectedPriceList: any = {};
  modalRef: NgbModalRef;
  constructor(public coreSession: CoreSession,
    private translateService: TranslateService,
    private pricesAndOffersService: PricesAndOffersService,
    private priceService: PriceService,
    private sessionData: SessionDataProvider,
    private modalService: NgbModal,
    private navService:NavBarService
  ) {

  }
  @ViewChild('priceNoteDialog', { static: true }) priceNoteDialog: any;
  rejectNote = null;

  priceFilterForm: FormGroup;

  toDate: DateTimeModel = null;
  fromDate: DateTimeModel = null;

  fromDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Start_Date',
    formControlName: 'fromDate',
    isCalendarOnly: true,
    labelHidden: false,
  };

  toDateProperties: IDateTimePickerProperties = {
    label: 'Desc_End_Date',
    formControlName: 'toDate',
    isCalendarOnly: true,
    labelHidden: false,
  };
  priceFilter: any = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    organizationId: -1,
    priceListTypeId: -1,
    dateModel: null,
    toDate: null,
    customerId: -1,
    outletId: -1
  };

  selectedCustomerId = -1;
  selectedOutletId = -1;
  onChangeCustomer(customer) {
    if (customer) {
      this.selectedCustomerId = customer.customerId;

    }
    else {
      this.selectedCustomerId = -1;
      this.selectedOutletId = -1;
    }
  }
  onChangeOutlet(outlet) {
    if (outlet) {
      this.selectedOutletId = outlet.outletId;
    } else {
      this.selectedOutletId = -1;
    }
  }

  openPriceEntryDialog() {
    this.PriceEntryDialog.Show(true).then((res) => { });
  }

  saveString: string = 'Desc_Save';

  showSharedTable:boolean = false
  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus;
    });
    this.showSharedTable = this.navService.tourStatus;

    this.showStatusColumn = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4");

    if(this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4")){
      this.getCurrentOperationStatus();
    }
    else if( !this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4") && this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Add) ){
      this.tableData.showNewBtn = true;
      this.addActions();
    }
    else{
      this.tableData.showNewBtn = false;
      this.addActions();
    }

    if (this.showStatusColumn)
      this.tableData.columns.push({ title: 'Desc_Status', key: 'priceStatusName', isSortable: true, width: '30%'  });
    this.initFilterForm();
    this.populatePriceLists();
    this.coreSession.SetTitle('Prices List');

    this.tableData.showNewBtn = this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Add);
  }

  addActions()
  {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Edit)) {

      if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Approve)&& this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4") && this.sessionData.getConfigurationValue(ConstantConfigurations.ForcePreviousLevelApproval).toLowerCase() === "false" ){
        this.tableData.rowOperations.push(
          {
            operation: RowOperation.edit,
            title: "Desc_Edit",
            icon: "fa-regular fa-pen-to-square",
            color: "#12344d"
          });
      }else{
        if(this.showEditDeleteApprove){
          this.tableData.rowOperations.push(
            {
              operation: RowOperation.edit,
              title: "Desc_Edit",
              icon: "fa-regular fa-pen-to-square",
              color: "#12344d",
              showWhenKeyValueTrue: true,
              showHideOptionPerLine: true,
              controlKeyName: 'showEdit'
            });
        }

      }

    }


    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Approve)&& this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4") && this.sessionData.getConfigurationValue(ConstantConfigurations.ForcePreviousLevelApproval).toLowerCase() === "true" && this.showEditDeleteApprove) {

      this.tableData.rowOperations.push({
          operation: RowOperation.approve,
          title: 'Desc_Order_Approve',
          icon: "fa-solid fa-check",
          color: "#02b875",
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: 'showApprove'
      });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Approve)&& this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4") && this.sessionData.getConfigurationValue(ConstantConfigurations.ForcePreviousLevelApproval).toLowerCase() === "false" && this.showEditDeleteApprove){
      this.tableData.rowOperations.push({
            operation: RowOperation.approve,
            title: 'Desc_Order_Approve',
            icon: "fa-solid fa-check",
            color: "#02b875",
            showWhenKeyValueTrue: true,
            showHideOptionPerLine: true,
            controlKeyName: 'isPending'
        });
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Approve) && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4") && this.sessionData.getConfigurationValue(ConstantConfigurations.ForcePreviousLevelApproval).toLowerCase() === "true" && this.showEditDeleteApprove) {
      this.tableData.rowOperations.push({
          operation: RowOperation.approve,
          title: 'Desc_Send_Request',
          icon: "fa-solid fa-check",
          color: "#02b875",
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: 'showRequest'
      });
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.View)) {
      this.tableData.rowOperations.push(
        {
          operation: RowOperation.View,
          title: "Desc_View",
          icon: "fa-regular fa-eye",
          color: "#12344d"
        });
    }

    // if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.View) ) {
    //   this.tableData.rowOperations.push(
    //     {
    //       operation: RowOperation.Configure,
    //       title: "Desc_View_Original",
    //       icon: "fa fa-copy",
    //       color: "#12344d",
    //       showWhenKeyValueTrue: true,
    //       showHideOptionPerLine: true,
    //       controlKeyName: 'showViewOriginal'
    //     });
    // }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Delete)
    && this.showEditDeleteApprove) {
      this.tableData.rowOperations.push(
        {
          operation: RowOperation.delete,
          title: 'Desc_Delete',
          icon: 'fa-solid fa-trash',
          color: '#f1685e',
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: 'showDelete'
        });
    }
  }

  getCurrentOperationStatus(){
    this.pricesAndOffersService.getCurrentOperationStatus(ApprovalCycleOperations.Price.valueOf()).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        (response);
        if(response.data == 0){
          this.tableData.showNewBtn = false;
          this.showEditDeleteApprove = false;
        }else{
          this.tableData.showNewBtn = true;
          this.showEditDeleteApprove = true;
        }
        this.addActions();

      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  populatePriceLists() {
    this.priceFilter.organizationId = this.priceFilterForm.get('organizationId').value == null ? -1 : this.priceFilterForm.get('organizationId').value;
    this.priceFilter.priceListTypeId = this.priceFilterForm.get('priceListTypeId').value == null ? -1 : this.priceFilterForm.get('priceListTypeId').value;
    this.priceFilter.customListFilter = this.query.customListFilter;
    this.priceFilter.dateModel = this.fromDate == null ? null : this.fromDate;
    this.priceFilter.toDate = this.toDate == null ? null : this.toDate;
    this.priceFilter.customerId= this.selectedCustomerId,
    this.priceFilter.outletId=   this.selectedOutletId
    this.coreSession.ModalLoading.Show();
    this.priceService.getPriceLists(this.priceFilter).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        (response);
        if (response.status != null && response.status >= 0) {

          this.dataSource = response.data;
       var defaultPrice =   this.dataSource.data.find(pricList=>pricList.isDefault==true);
       if(defaultPrice)
       defaultPrice.selected = true;
        } else {
          this.dataSource = {
            totalItems: 0,
            data: []
          };
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
        this.selectedCustomerId= -1
        this.selectedOutletId = -1;
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  //#region [SHARED TABLE EVENTS]
  onRowClicked(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.DeletePrice(event.object);
        break;
      case RowOperation.approve:
        this.ApprovePrice(event.object);
        // this.IsValidToApprove(event.object);
        break;
      case RowOperation.edit:
        this.EditPrice(event.object);
        break;
      case RowOperation.View:
        if(this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.View)){
          this.isViewMode = true;
          this.selectedPriceList = cloneDeep(event.object);
          this.showSlider = true;
          this.openPriceEntryDialog()
        }
        break;

        case RowOperation.Configure:
          if(this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.View)){
            this.isViewMode = true;
            this.selectedPriceList = cloneDeep(event.object);
            this.showSlider = true;
            this.isViewOriginalMode = true;

          }
          break;
    }
  }
  ApprovePrice(price: any){
    if(this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4") &&  this.sessionData.getConfigurationValue(ConstantConfigurations.ForcePreviousLevelApproval).toLowerCase() === 'true'){
      if(price.isCreationLevel) {
        this.IsValidToApprove(price);

      } else{
        if(price.isDeleted){
          this.isDeleteMode = true;
          this.isViewMode = true;
        }else {
          this.isEditMode = true;
        }

        this.saveString = 'Desc_Save_And_Approve';
        this.selectedPriceList = cloneDeep(price);
        this.showSlider = true;
      }
    }else{
      this.IsValidToApprove(price);
    }

  }

  EditPrice(price: any){
    if(this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4") &&  this.sessionData.getConfigurationValue(ConstantConfigurations.ForcePreviousLevelApproval).toLowerCase() === 'true'){
      this.coreSession.ModalLoading.Show();
      this.pricesAndOffersService.isValidToAffect(price.status, ApprovalCycleOperations.Price.valueOf()).subscribe(response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if(response.data){
            this.selectedPriceList = cloneDeep(price);
            this.isEditMode = true;
            this.showSlider = true;
            this.saveString = 'Desc_Save';
            this.openPriceEntryDialog()


          }else{
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), ConstantMessages.MsgNotValidToEdit);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    }else{
      this.isEditMode = true;
      this.selectedPriceList = cloneDeep(price);
      this.showSlider = true;
      this.openPriceEntryDialog()
    }

  }

  DeletePrice(price: any){
    if(this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4") &&  this.sessionData.getConfigurationValue(ConstantConfigurations.ForcePreviousLevelApproval).toLowerCase() === 'true'){
      this.coreSession.ModalLoading.Show();
      this.pricesAndOffersService.isValidToAffect(price.status, ApprovalCycleOperations.Price.valueOf()).subscribe(response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if(response.data){
            if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Delete)) {
              this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
                .then(
                  (result: DialogResult) => {
                    if (result === DialogResult.Yes) {
                      this.rejectNote = '';
                      this.modalRef = this.modalService.open(this.priceNoteDialog, {
                        centered: true,
                        size: "md"
                      });
                      this.modalRef.result.then(
                        result => {
                          this.deletePriceList(price);
                        },
                        resaon => {
                          return DialogResult.None;
                        });


                    }
                  }
                );
            }
          }else{
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), ConstantMessages.MsgNotValidToDelete);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    }else{
      if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.Delete)) {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
          .then(
            (result: DialogResult) => {
              if (result === DialogResult.Yes) {

                this.deletePriceList(price);
              }
            }
          );
      }
    }

  }

  getDeletedPriceNote(){
    if(this.rejectNote && this.rejectNote != '' && this.rejectNote.trim() && this.rejectNote.trim() != ''){
      this.modalRef.close();
    }else{
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
    }
  }

  IsValidToApprove(price) {
    this.coreSession.ModalLoading.Show();
    this.pricesAndOffersService.isValidToApprove(price.status, ApprovalCycleOperations.Price.valueOf()).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if (response.data) {
          // valid to approve
          this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.ApproveConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
            (res: DialogResult) => {
              if (res === DialogResult.Yes) {
                this.approvePrice(price.priceListId, price.priceListCode, price.status);
              }
            });
        }
        else {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgNotValidToApprove));

        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  approvePrice(priceId, priceCode,currentStatusId) {
    this.pricesAndOffersService.approveOperation(priceId ,currentStatusId, ApprovalCycleOperations.Price.valueOf()).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {

          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          this.populatePriceLists();
          this.sendEmail(priceId,priceCode,currentStatusId);


      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  sendEmail(priceId,priceCode,currentStatusId) {
    this.pricesAndOffersService.sendOperationEmail(priceId ,currentStatusId, ApprovalCycleOperations.Price.valueOf(),priceCode,true).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if(response.data != 7)
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.EmailCaption));
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onMultiSelectionOperation(event: any) {
    switch (event.operation) {

      case MultiSelectionOperation.delete:
        break;
    }
  }
  deletePriceList(price:any) {
    this.priceService.deletePriceList(price)
      .subscribe(
        (response: ResponseModel) => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            if (response.data != null && response.data == 7){
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
            }else{
              this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
              this.populatePriceLists();
            }

          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
  }
  onPriceListSaved(priceList: any) {
    this.closeSlider();
    this.populatePriceLists();
    if(!priceList.isCreationLevel && priceList.status != -1 && this.saveString == 'Desc_Save_And_Approve'){
      this.sendEmail(priceList.priceListId,priceList.priceListCode, priceList.status);
    }
    this.showSharedTable = true
  }
  closeSlider() {
    this.isEditMode = false;
    this.isViewMode = false;
    this.isViewPendingMode = false;
    this.showSlider = false;
    this.isViewOriginalMode = false;
    this.isDeleteMode = false;
    this.showSharedTable = true
    this.PriceEntryDialog.Close()
  }
  onSaveClick() {
    this.saveSubject.next();
  }
  openFilter() {
    this.mainFilter.Show().then(result => {
    });
  }
  onFindButtonClicked(result) {
    this.query.customListFilter.page = 0;
    //  this.query.customerId = result.customerId;
    this.populatePriceLists();
  }
  onTableFilterChanged(query: any) {

    this.query.customListFilter = query;
    this.populatePriceLists();
  }
  onNewBtnClicked() {
    this.isEditMode = false;
    this.isViewMode = false;
    this.isViewPendingMode = false;
    this.selectedPriceList = undefined;
    this.showSlider = true;
    this.showSharedTable = false
    this.openPriceEntryDialog()
  }

  ApplySerachFilterOnFind(){
    this.priceFilter.customListFilter.page = 0;
    this.populatePriceLists();
  }

  onReset(){
    this.fromDate = null;
    this.toDate = null;
    this.priceFilterForm.reset();
  }
  onToDateSelected(date: any) {
    this.fromDate = null;
    this.fromDate = date;
  }
  onFromDateSelected(date: any) {
    this.toDate = null;
    this.toDate = date;
  }

  initFilterForm() {
    this.priceFilterForm = new FormGroup({
      organizationId: new FormControl(),
      fromDate: new FormControl(null),
      toDate: new FormControl(null),
      priceListTypeId: new FormControl(),
      customerId: new FormControl(
        { value: null, disabled: false },
      ),
      outletId: new FormControl(
        { value: null, disabled: false },
      ),
    })
  }
  //#endregion
}
