import { Component, OnDestroy, OnInit } from '@angular/core';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { CoreSession } from '../../../../core/core.session';
import { ActivatedRoute, Router, NavigationEnd } from '@angular/router';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { NavigationData } from '../../../../shared/models/navigation-data/navigation-data.model';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../shared/shepherd-config/trackTour.service';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-prices-and-offers-home',
  templateUrl: './prices-and-offers-home.component.html',
  styleUrls: ['./prices-and-offers-home.component.css']
})
export class PricesAndOffersHomeComponent implements OnInit, OnDestroy {
  navLinks: any[];
  hideTabs : boolean = false;
  moduleId: number ;
  indexCounter: number = -1;
  constructor(private route: ActivatedRoute ,
    private router: Router,
    private sessionDataProvider: SessionDataProvider,
    private navService:NavBarService,
    private  shepherdService :ShepherdService,
    private tourService :TourService,
    private componentVisitService: ComponentVisitService
  ) {
      //  router.events.subscribe(val => {
      //   if (val instanceof NavigationEnd) {
      //     if (val.url.includes(ConstantURLs.customerAddURL)
      //     || val.url.includes(ConstantURLs.customerEditURL)) {
      //       this.hideTabs = true;
      //     } else {
      //       this.hideTabs = false;
      //     }
      //   }
      // });
     }
     private tourStartTimeout: any;

     private endTour =false
  ngAfterViewInit() {
    this.startTour()
  }
  startTour(forceTour?){
    this.tourStartTimeout=  setTimeout((()=>{

      if(!this.tourService.isFirstTour()){
          this.endTour = true;
          this.navService.endtour.next();
      }

        if (this.tourService.isTourCompletedForComponent('price-and-offer-main')) {
          this.endTour = true;
          this.navService.endtour.next();
                  return;
        }

        if(this.tourService.isFirstTour() || forceTour){

          const elementSelectors = this.navLinks.map((_, i) => `#column-${i}`);
          const title = ['Desc_Price','Desc_Discount','Desc_Promotion'];
          const text = ['Desc_Manage_Price_For_Items_And_Customers',
                        'Desc_Manage_Discount_For_Items_And_Customers',
                        'Desc_Manage_Promotion_For_Items_And_Customers'];// Target each column by its unique ID
          const steps = this.tourService.generateSteps(elementSelectors,title,text);
          this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
          this.shepherdService.modal = true;
          this.shepherdService.addSteps(steps);
          this.shepherdService.start();
          this.shepherdService.tourObject.on('complete', () => {
            this.endTour=true;
            this.navService.endtour.next();
          });
        this.shepherdService.tourObject.on('cancel', () => {
          this.endTour=true;
          this.navService.endtour.next();
        });


      }
      }),1000)
  }
  private tourSubscription: Subscription;

  ngOnInit() {
    this.prepareNavigation();
    var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
    if (index == -1) index = 0;
    this.navLinks[index].isActive = true;
    this.setNavigation(this.navLinks[index]);

    this.tourSubscription = this.tourService.startTourMain$.subscribe(() => {
      this.startTour(true);
    });
  }
  prepareNavigation(){
    this.navLinks = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable) {
      if (menu.menuId.includes('100-006-')) {
        this.indexCounter = this.indexCounter + 1
        let newName = {
          label: menu.menuName,
          link: menu.url,
          isActive: false,
          index: this.indexCounter
        };
        this.navLinks.push(newName);
      }
    }
  }
  ngOnDestroy() {
    this.navService.setNavigation([]);
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.navService.tourStatus = false
    this.componentVisitService.markComponentVisited('price-and-offer-main');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }

  }
  onChangeSeletedTab(tab) {
    this.setNavigation(tab);
  }
  setNavigation(tab) {
    if(this.endTour)
      this.navService.endtour.next();

    let navigationList: NavigationData[] = [];
    navigationList.push(
      {
        Name: 'Desc_Your_ECHO',
        URL: ConstantURLs.dataDefinitionURL
      },
      {
        Name: 'Desc_Prices_And_Offers',
        URL: undefined
      },
      {
        Name: tab.label,
        URL: undefined
      }
    );
    this.navService.setNavigation(navigationList);
  }
}
