import { Routes, RouterModule } from "@angular/router";
import { AuthGuard } from "../../../core/auth/auth.gurad";
import { NgModule } from "@angular/core";
import { ConstantURLs } from "../../../shared/models/constants/constant-URL";
import { PriceDefinitionListComponent } from "./price-definition/price-definition-list/price-definition-list.component";
import { DiscountDefinitionListComponent } from "./discount-definition/discount-definition-list/discount-definition-list.component";
import { PromotionListComponent } from './promotions/promotion-list/promotion-list.component';
import { PricesAndOffersHomeComponent } from './prices-and-offers-home/prices-and-offers-home.component';
import { HeaderDiscountListComponent } from './Header-Discount-Definition/header-discount-list/header-discount-list.component';
import { PricesPendingListComponent } from "./prices-pending/prices-pending-list/prices-pending-list.component";
const PricesAndOffersRouting: Routes = [
  {
    path: "",
    canActivate: [AuthGuard],
    component: PricesAndOffersHomeComponent,
    children: [
      { path: '', canActivate: [AuthGuard], redirectTo: ConstantURLs.pricesURL, pathMatch: 'full' },
      {
        path: ConstantURLs.pricesURL,
        canActivate: [AuthGuard],
        component: PriceDefinitionListComponent
      },
      {
        path: ConstantURLs.pricesPendingURL,
        canActivate: [AuthGuard],
        component: PricesPendingListComponent
      },
      {
        path: ConstantURLs.discountsURL,
        canActivate: [AuthGuard],
        component: DiscountDefinitionListComponent
      },
      {
        path: ConstantURLs.promotionsURL,
        canActivate: [AuthGuard],
        component: PromotionListComponent
      },

      {
        path: ConstantURLs.HeaderDiscountURL,
        canActivate: [AuthGuard],
        component: HeaderDiscountListComponent
      },
    ]
  }

];
@NgModule({
  imports: [RouterModule.forChild(PricesAndOffersRouting)],
  exports: [RouterModule]
})
export class PricesAndOffersRoutingModule {
}
