import { NgModule } from "@angular/core";
import { PriceDefinitionEntryComponent } from "./price-definition/price-definition-entry/price-definition-entry.component";
import { PriceDefinitionListComponent } from "./price-definition/price-definition-list/price-definition-list.component";
import { PricesAndOffersHomeComponent } from "./prices-and-offers-home/prices-and-offers-home.component";
import { PricesAndOffersRoutingModule } from "./prices-and-offers-routing.module";
import { SharedModule } from "../../../shared/shared.module";
import { TranslateModule } from "@ngx-translate/core";
import { FormsModule, ReactiveFormsModule } from "@angular/forms";
import { DiscountDefinitionEntryComponent } from "./discount-definition/discount-definition-entry/discount-definition-entry.component";
import { DiscountDefinitionListComponent } from "./discount-definition/discount-definition-list/discount-definition-list.component";
import { CommonModule } from "@angular/common";
import { NgSelectModule } from "@ng-select/ng-select";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { MatCardModule } from "@angular/material/card";
import { PromotionListComponent } from "./promotions/promotion-list/promotion-list.component";
import { PromotionEntryComponent } from "./promotions/promotion-entry/promotion-entry.component";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";
import { SurveyManagmentModule } from "../survey-managment/survey.managment.module";
import { HeaderDiscountEntryComponent } from './Header-Discount-Definition/header-discount-entry/header-discount-entry.component';
import { HeaderDiscountListComponent } from './Header-Discount-Definition/header-discount-list/header-discount-list.component';
import { LoyaltyProgramsModesDialogComponent } from "./loyalty-programs/loyalty-programs-modes-dialog/loyalty-programs-modes-dialog.component";
import { PricesPendingListComponent } from './prices-pending/prices-pending-list/prices-pending-list.component';
@NgModule({
  declarations: [
    PricesAndOffersHomeComponent,
    PriceDefinitionListComponent,
    PriceDefinitionEntryComponent,
    DiscountDefinitionEntryComponent,
    DiscountDefinitionListComponent,
    PromotionListComponent,
    PromotionEntryComponent,

    LoyaltyProgramsModesDialogComponent,
    HeaderDiscountEntryComponent,
    HeaderDiscountListComponent,
    PricesPendingListComponent,

  ],
  imports: [
    NgSelectModule,
    CommonModule,
    PricesAndOffersRoutingModule,
    SharedModule,
    FormsModule,
    ReactiveFormsModule,
    NgMultiSelectDropDownModule,
    TranslateModule.forChild(),
    MatCardModule,
    NgOptionHighlightModule,
    SurveyManagmentModule
  ],
  exports: [],
})
export class PricesAndOffersModule { }
