import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Inject, Injectable } from "@angular/core";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../../shared/models/api-models/api-models";
import { Observable } from 'rxjs';
import { ConstantMessages } from "../../../shared/models/constants/constant-message";

@Injectable({
  providedIn: 'root'
})
export class PricesAndOffersService {
  httpOptions;
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string,
    private coreSession: CoreSession) {
    this.url = baseUrl + 'PricesAndOffers';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json'
      })
    };
  }

  getTaxTypes() {
    const urlValue: string = this.url + '/GetTaxTypes';
    return this.http.post<ResponseModel>(urlValue, null).map(response => {
      return response;
    });
  }

  //#region[promotions]

  isValidToApprove(status: number, operationTypeId, id: number = -1) {
    const urlValue: string = this.url + '/IsValidToConfirm';
    return this.http.post<ResponseModel>(urlValue, { Status: status, OperationTypeId: operationTypeId, Id: -1, IsApprove: false, OperationCode: "", id: id }).map(response => {
      return response;
    });
  }

  isValidToAffect(status: number, operationTypeId) {
    const urlValue: string = this.url + '/IsValidToAffect';
    return this.http.post<ResponseModel>(urlValue, { Status: status, OperationTypeId: operationTypeId, Id: -1, IsApprove: false, OperationCode: "" }).map(response => {
      return response;
    });
  }

  isValidToEditFoc(contract: any) {
    const urlValue = this.url + "/IsValidToEditFoc";
    return this.http.post<ResponseModel>(urlValue, contract).map(response => {
      return response;
    });
  }
  getCurrentOperationStatus(operationId: number) {
    const urlValue: string = this.url + '/GetCurrentOperationStatus';
    return this.http.post<ResponseModel>(urlValue, operationId).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }


  approveOperation(Id, currentStatusId, operationTypeId) {
    const urlValue: string = this.url + '/ApproveOperation';
    return this.http.post<ResponseModel>(urlValue, { Status: currentStatusId, OperationTypeId: operationTypeId, Id: Id, IsApprove: false, OperationCode: "" }).map(response => {
      return response;
    });
  }
  sendOperationEmail(Id, currentStatusId, operationTypeId, operationCode, isApprove) {
    const urlValue: string = this.url + '/sendOperationEmail';
    return this.http.post<ResponseModel>(urlValue, { Status: currentStatusId, OperationTypeId: operationTypeId, Id: Id, IsApprove: isApprove, OperationCode: operationCode }).map(response => {
      return response;
    });
  }

  DownloadFile(Id: string, fileName: string, fileType: string, operationType: number): Observable<any> {
    let fileExtension = fileType;
    const urlValue =
      this.url +
      "/DownloadFile?Id=" +
      Id +
      "&fileName=" +
      fileName +
      "&operationType=" +
      operationType;

    return this.http.post(urlValue, "", { responseType: "blob" }).map(res => {
      var blob = new Blob([res], { type: fileExtension });
      return blob;
    });
  }


  getQuantityRangeList() {
    const urlValue: string = this.url + '/GetQuantityRangeList';
    return this.http.post<ResponseModel>(urlValue, null).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }


  sendNotification(promotion: any) {
    const urlValue = this.url + "/SendNotification";
    return this.http.post<ResponseModel>(urlValue, promotion).map(response => {
      return response;
    });
  }
}
//#endregion
