import { Component, OnInit, ViewChild } from '@angular/core';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { CoreSession } from '../../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { RowOperation, MultiSelectionOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { GeneralFilter } from '../../../../../shared/models/general/generalFilter.model';
import { PricesAndOffersService } from '../../prices-and-offers.service';
import { MainFilterComponent } from '../../../../../shared/components/filters/main-filter/main-filter.component';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { Subject } from 'rxjs';
import * as cloneDeep from 'lodash/cloneDeep';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { DateTimeModel } from '../../../../../shared/models/dateTimeModel/date-time.model';
import { IDateTimePickerProperties } from '../../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { ApprovalCycleOperations } from '../../../../../shared/models/enums/approval-cycle-operations-enum';
import { NgbModal, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { PriceService } from '../../../../../shared/services/data-definition/prices-and-offers/price.service';
import { NavBarService } from '../../../../../core/sidebar/sidebar.service';
import { SharedDialogComponent } from '../../../../../shared/components/shared-dialog/shared-dialog.component';
import { ITextInput } from '../../../../../shared/models/shared-table/custom-list.interface';
import { debug } from 'console';
import { CustomerOutletContactModel, CustomerOutletModel } from '../../../../../shared/models/customer/outlet.model';
import { CustomerService } from '../../../../../shared/services/data-definition/customer/customers.service';

@Component({
  selector: 'app-prices-pending-list',
  templateUrl: './prices-pending-list.component.html',
  styleUrls: ['./prices-pending-list.component.css']
})
export class PricesPendingListComponent implements OnInit {

 //#region [DECLARATIONS]

 outletObj: CustomerOutletModel = new CustomerOutletModel();
 showStatusColumn = false;
 contactNameOldDescription: any[] = [];
 contactAddressOldDescription: any[] = [];
 @ViewChild('PriceEntryDialog', { static: true }) PriceEntryDialog: SharedDialogComponent;
 customerOutletContactModel: CustomerOutletContactModel;
 @ViewChild('ReasonEntryDialog', { static: true }) ReasonEntryDialog: SharedDialogComponent;

 @ViewChild('ContactEntryDialog', { static: true }) ContactEntryDialog: SharedDialogComponent;

 outletForm: FormGroup;
 contactId: number = -1;
 contactNameInput: ITextInput = {
  formControlName: 'contactName',
  placeHolder: 'Desc_Contact_Name',
  label: 'Desc_Contact_Name',
  isRequierd: false
};
contactsTableProperties: ITableProperties = {
  pageSize: this.coreSession.pageSize,
  showPaginator: true,
  showSearch: true,
  isOnline: false,
  isMultiSelection: false,
  rowOperations: [
    {
      operation: RowOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e'
    }, {
      operation: RowOperation.edit,
      title: "Desc_Edit",
      icon: "fa-regular fa-pen-to-square",
      color: "#12344d"
    }
  ],
  multiSelectionOperations: [],
  columns: [
    {
      title: 'Desc_Contact_Name',
      key: 'contactName',
      isSortable: true,

    },
    // {
    //   title: 'Desc_Address',
    //   key: 'address',
    //   isSortable: true,
    //   width: '14%'
    // },
    // {
    //   title: 'Desc_Mobile',
    //   key: 'mobile',
    //   isSortable: true,
    //   width: '14%'
    // },
    {
      title: 'Desc_Phone',
      key: 'phone',
      isSortable: true,

    },
    // {
    //   title: 'Desc_Fax',
    //   key: 'fax',
    //   isSortable: true,
    //   width: '14%'
    // },
    {
      title: 'Desc_Email',
      key: 'email',
      isSortable: true,

    }
    // ,
    // {
    //   title: 'Desc_Street',
    //   key: 'streetName',
    //   isSortable: true,
    //   width: '10%'
    // }
  ]
};
contacts_dataSource: SharedTableResult = {
  totalItems: 0,
  data: []
};

contactsDataSourceArray: CustomerOutletContactModel[] = [];

 customerForm : FormGroup
 customerNameInput: ITextInput = {
  formControlName: "customerName",
  placeHolder: "Desc_Customer_Name",
  label: "Desc_Customer_Name",
  isRequierd: true,
};
 tableData: ITableProperties = {
   pageSize: this.coreSession.pageSize,
   showPaginator: true,
   showSearch: true,
   isOnline: true,
   showSearchBtn: true,
   showNewBtn: false,
   isMultiSelection: false,
   rowOperations: [

   ],
   multiSelectionOperations: [

   ],
   columns: [
     {
       title: 'Desc_Customer_Name',
       key: 'customerCodeName',
       isSortable: false,
       width: '10%'
     },
     {
       title: 'Desc_Outlet_Name',
       key: 'outletCodeName',
       isSortable: false,
       width: '15%'
     },
     {
       title: 'Desc_Vendor',
       key: 'organizationCodeName',
       isSortable: false,
       width: '10%'
     },
     {
      title: 'Desc_Update_By',
      key: 'employeeName',
      isSortable: false,
      width: '15%'
    },
     {
       title: 'Desc_Request_Date',
       key: 'requestDate',
       isSortable: true,
       isExpiryDate: true,
       width: '10%'
     },
     {
       title: 'Desc_Status',
       key: 'statusDescription',
       isSortable: false,
       width: '15%'
     }
     ,
     {
       title: 'Desc_Reason',
       key: 'reason',
       isSortable: false,
       width: '15%'
     },
   ]
 };

 showEditDeleteApprove:boolean =  true;
 modalReference: any;
 dataSource: SharedTableResult = {
   totalItems: 0,
   data: []
 };

 query: GeneralFilter = {
   customListFilter: {
     searchFilter: '',
     page: 0,
     pageSize: this.coreSession.pageSize
   },

   customerId: -1,
   outletId: -1
 };
 isValidToAffect:any= false;

 //#endregion

 //#region [VIEW CHILD]
 @ViewChild('filter', { static: true }) mainFilter: MainFilterComponent;

 //#endregion
 saveSubject: Subject<void> = new Subject<void>();
 showSlider = false;
 isEditMode = false;
 isViewMode = false;
 isDeleteMode = false;
 isViewOriginalMode = false;
 isCreationMode = false;
 isViewPendingMode = false;
 selectedPriceList: any = {};
 selectedCustomerPriceList: any = {};
 selectedPendingPriceList: any = {};

 modalRef: NgbModalRef;
 constructor(public coreSession: CoreSession,
   private translateService: TranslateService,
   private pricesAndOffersService: PricesAndOffersService,
   private priceService: PriceService,
   private sessionData: SessionDataProvider,
   private modalService: NgbModal,
   private navService:NavBarService,
   private customerService : CustomerService
 ) {

 }
 @ViewChild('priceNoteDialog', { static: true }) priceNoteDialog: any;
 rejectNote = null;

 priceFilterForm: FormGroup;

 toDate: DateTimeModel = null;
 fromDate: DateTimeModel = null;

 fromDateProperties: IDateTimePickerProperties = {
   label: 'Desc_Start_Date',
   formControlName: 'fromDate',
   isCalendarOnly: true,
   labelHidden: false,
 };


 toDateProperties: IDateTimePickerProperties = {
   label: 'Desc_Request_Date',
   formControlName: 'toDate',
   isCalendarOnly: true,
   labelHidden: false,
 };
 priceFilter: any = {
   customListFilter: {
     searchFilter: '',
     page: 0,
     pageSize: this.coreSession.pageSize
   },
   organizationId: -1,
   priceListTypeId: -1,
   dateModel: null,
   toDate: null,
   customerId: -1,
   outletId: -1
 };

 selectedCustomerId = -1;
 selectedOutletId = -1;

 saveString: string = 'Desc_Save';

 showSharedTable:boolean = false

 isTouched = false;
 PriceListDate: any[];

 PriceListDateLoading = false;
  selectedPriceListId:any = {} ;

 onChangeCustomer(customer) {
   if (customer) {
     this.selectedCustomerId = customer.customerId;

   }
   else {
     this.selectedCustomerId = -1;
     this.selectedOutletId = -1;
   }
 }
 onChangeOutlet(outlet) {
   if (outlet) {
     this.selectedOutletId = outlet.outletId;
   } else {
     this.selectedOutletId = -1;
   }
 }

 openPriceEntryDialog() {
   this.PriceEntryDialog.Show(true).then((res) => { });
 }

 openReasonEntryDialog() {
  this.ReasonEntryDialog.Show(true).then((res) => { });
}
openOutletContactDialog(){
  this.ContactEntryDialog.Show(true).then((res) => { });
}
contactAddBtnDesc: string = '';

clearContactData() {
  this.resetContactFields();

  this.selectedContactIndex = -1;
}

addContactData() {
  this.outletForm.get('contactData').get('contactName').setValidators([Validators.required]);
  this.outletForm.get('contactData').get('contactName').updateValueAndValidity();
  this.fillContactsObject();
  if ( (this.customerOutletContactModel.email !== ''
    || this.customerOutletContactModel.mobile !== 0
    || this.customerOutletContactModel.phone !== 0
    || this.customerOutletContactModel.fax !== 0)) {
    this.checkCustomerDataOnline(this.customerOutletContactModel);
  } else {
    this.checkIsContactValid(this.customerOutletContactModel);
  }
}

checkCustomerDataOnline(selectedContact: CustomerOutletContactModel) {

  this.customerService.checkIfContactDataExists(selectedContact).subscribe(response => {

    if (response.message && response.message !== '' && response.status == -1) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
    } else {
      this.checkIsContactValid(selectedContact);
    }
  }, (error: HttpErrorResponse) => {
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
  });
}

checkIsContactValid(addedContact: CustomerOutletContactModel) {
  let mobileIndex = this.contactsDataSourceArray.findIndex(x => x.mobile !== 0 && x.mobile === addedContact.mobile);
  let faxIndex = this.contactsDataSourceArray.findIndex(x => x.fax !== 0 && x.fax === addedContact.fax);
  let phoneIndex = this.contactsDataSourceArray.findIndex(x => x.phone !== 0 && x.phone === addedContact.phone);
  let emailIndex = this.contactsDataSourceArray.findIndex(x => x.email != '' && x.email === addedContact.email);
  if (addedContact.mobile === 0 && addedContact.fax === 0 && addedContact.phone === 0 && addedContact.email === '') {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillAtLeastOneOfContactFields));
    return false;
  } else if (mobileIndex != -1 && mobileIndex !== this.selectedContactIndex) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedMobileNumberAlreadyExists));
    return false;
  } else if (faxIndex != -1 && faxIndex !== this.selectedContactIndex) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedFaxNumberAlreadyExists));
    return false;
  } else if (phoneIndex != -1 && phoneIndex !== this.selectedContactIndex) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedPhoneNumberAlreadyExists));
    return false;
  } else if (emailIndex != -1 && emailIndex !== this.selectedContactIndex) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedEmailAlreadyExists));
    return false;
  } else if (this.outletForm.get('contactData').invalid) {
    this.setContactDataMarkedAsTouched();
    if (!this.outletForm.get('contactData').get('contactName') || this.outletForm.get('contactData').get('contactName').value === '') {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return false;
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgInsertValidEmail));
      return false;
    }
  } else {
    this.customerOutletContactModel.streetName = this.outletForm.get('contactData').get('streetName').value != null ? this.outletForm.get('contactData').get('streetName').value : '';
    if (this.selectedContactIndex >= 0) {
      this.contactsDataSourceArray[this.selectedContactIndex] = addedContact;
      this.selectedContactIndex = -1;
    } else {
      this.contactsDataSourceArray.push(addedContact);
    }
    this.contacts_dataSource = {
      data: this.contactsDataSourceArray,
      totalItems: this.contactsDataSourceArray.length
    }
    this.resetContactFields();
    return true;
  }
}

setContactDataMarkedAsTouched() {
  this.outletForm.get('contactData').get('email').markAsTouched();
  this.outletForm.get('contactData').get('contactName').markAsTouched();
}
resetContactFields() {
  this.outletForm.get('contactData').get('contactId').reset('');
  this.outletForm.get('contactData').get('contactName').reset('');
  this.outletForm.get('contactData').get('address').reset();
  this.outletForm.get('contactData').get('email').reset('');
  this.outletForm.get('contactData').get('fax').reset('');
  this.outletForm.get('contactData').get('mobile').reset('');
  this.outletForm.get('contactData').get('phone').reset('');
  this.outletForm.get('contactData').get('street').reset('');
  this.outletForm.get('contactData').get('streetName').reset('');
  this.outletForm.get('contactData').get('addressDescriptionLanguages').reset([]);
  this.outletForm.get('contactData').get('contactDescriptionLanguages').reset([]);

  this.contactAddBtnDesc = 'Desc_Add';
}
 onPriceListIDSelected(selectedPriceList: any) {
  if(selectedPriceList)
    this.selectedCustomerPriceList.priceListID = selectedPriceList.priceListId
  else{
    this.selectedCustomerPriceList.priceListID  = -1
  }
}

OrderStatusTypeId:number =  -1;
onOrderTypeStatusSelected(salesOrderStatusTypeId: any) {
  debugger
  if (salesOrderStatusTypeId != -1)
    this.OrderStatusTypeId = salesOrderStatusTypeId;
  else {
    this.OrderStatusTypeId = -1;
  }
}

onOtherContactNameLanguagesTextSubmitted(event) {
  this.outletForm.get('contactData').get('contactDescriptionLanguages').setValue(event);
}

InitOutletForm() {
  this.outletForm = new FormGroup({
    contactData: new FormGroup({
      contactId: new FormControl(null),
      contactName: new FormControl(''),
      mobile: new FormControl(null),
      phone: new FormControl(null),
      fax: new FormControl(null),
      street: new FormControl(null),
      streetName: new FormControl(null),
      address: new FormControl(null),
      address2: new FormControl(null),
      email: new FormControl('', [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
      contactDescriptionLanguages: new FormControl([]),
      addressDescriptionLanguages: new FormControl([]),
      address2DescriptionLanguages: new FormControl([]),
      languageId: new FormControl(null)
    }),
  });
}
selectedContactIndex: number = -1;

fillContactsObject() {
  this.customerOutletContactModel = new CustomerOutletContactModel();
  if (this.selectedContactIndex < 0) {
    this.contactId = +this.contactId + 1;
  } else {
    this.contactId = this.contactsDataSourceArray[this.selectedContactIndex].contactId;
  }
  this.outletForm.get('contactData').get('contactId').setValue(this.contactId);
  this.customerOutletContactModel.contactId = this.outletForm.get('contactData').get('contactId').value;
  this.customerOutletContactModel.contactName = this.outletForm.get('contactData').get('contactName').value;
  this.customerOutletContactModel.address = this.outletForm.get('contactData').get('address').value === '' || this.outletForm.get('contactData').get('address').value == null ? '' : this.outletForm.get('contactData').get('address').value;
  this.customerOutletContactModel.email = this.outletForm.get('contactData').get('email').value;
  this.customerOutletContactModel.fax = (this.outletForm.get('contactData').get('fax').value === '' || this.outletForm.get('contactData').get('fax').value == null ? 0 : this.outletForm.get('contactData').get('fax').value);
  this.customerOutletContactModel.mobile = (this.outletForm.get('contactData').get('mobile').value === '' || this.outletForm.get('contactData').get('mobile').value == null ? 0 : this.outletForm.get('contactData').get('mobile').value);
  this.customerOutletContactModel.phone = (this.outletForm.get('contactData').get('phone').value === '' || this.outletForm.get('contactData').get('phone').value == null ? 0 : this.outletForm.get('contactData').get('phone').value);
  this.customerOutletContactModel.street = this.outletForm.get('contactData').get('street').value === '' || this.outletForm.get('contactData').get('street').value == null ? 0 : this.outletForm.get('contactData').get('street').value;
  this.customerOutletContactModel.addressDescriptionsLanguages = this.outletForm.get('contactData').get('addressDescriptionLanguages').value;
  this.customerOutletContactModel.contactDescriptionsLanguages = this.outletForm.get('contactData').get('contactDescriptionLanguages').value;

  let contactDescriptions = [];
  if (this.customerOutletContactModel.contactDescriptionsLanguages != null) {
    contactDescriptions = this.customerOutletContactModel.contactDescriptionsLanguages;
    let index = contactDescriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
    if (index == -1) {
      contactDescriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.customerOutletContactModel.contactName
      });
      if (contactDescriptions.length === 1) {
        if (this.coreSession.selectedLanguageId === 1) {
          contactDescriptions.push({
            languageId: 2,
            description: ''
          });
        } else {
          contactDescriptions.push({
            languageId: 1,
            description: ''
          });
        }
      }

    } else {
      contactDescriptions[index].description = this.customerOutletContactModel.contactName;
    }
  }

  let addressDescriptions = [];
  if (this.customerOutletContactModel.addressDescriptionsLanguages != null) {
    addressDescriptions = this.customerOutletContactModel.addressDescriptionsLanguages;
    let index = addressDescriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
    if (index == -1) {
      addressDescriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: (!this.customerOutletContactModel.address ? '' : this.customerOutletContactModel.address)
      });
      if (addressDescriptions.length === 1) {
        if (this.coreSession.selectedLanguageId === 1) {
          addressDescriptions.push({
            languageId: 2,
            description: ''
          });
        } else {
          addressDescriptions.push({
            languageId: 1,
            description: ''
          });
        }
      }
    } else {
      addressDescriptions[index].description = this.customerOutletContactModel.address;
    }
  }
}
FillOutletObjData() {
  if (this.contactsDataSourceArray && this.contactsDataSourceArray.length > 0) {
    this.selectedCustomerPriceList.customerOutletContacts = this.contactsDataSourceArray;
  }
  this.insertCustomerPriceList();
}
 ngOnInit() {

  this.InitOutletForm()
   this.navService.endtour.subscribe(() => {
     // Call the onTourEnd() function or perform any action
     this.navService.tourStatus = true;
     this.showSharedTable = this.navService.tourStatus;
   });
   this.showSharedTable = this.navService.tourStatus;

   this.showStatusColumn = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("4");

   this.contactAddBtnDesc = 'Desc_Add';

     this.addActions();



   this.initFilterForm();
   this.populatePendingPriceLists();
   this.coreSession.SetTitle('Pending Prices List');

   this.customerForm = new FormGroup({
    customerName: new FormControl(
      { value: "", disabled: this.isViewMode },
      Validators.required
    ),
   })

 }

 addActions()
 {
  if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesPendingURL, MenuActions.Reject) ){
    this.tableData.rowOperations.push({
      operation: RowOperation.reject,
      title: "Desc_Reject",
      icon: "fa-solid fa-xmark",
      color: "#f1685e",
      showWhenKeyValueTrue: true,
    showHideOptionPerLine: true,
    controlKeyName: 'isPending'
  });
}

        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesPendingURL, MenuActions.Approve) ) {
    this.tableData.rowOperations.push({
      operation: RowOperation.approve,
      title: 'Desc_Approved',
      icon: "fa-solid fa-check",
      color: "#02b875",
      showWhenKeyValueTrue: true,
      showHideOptionPerLine: true,
      controlKeyName: 'isPending'
  });

  this.tableData.rowOperations.push({
    operation: RowOperation.Activate,
    title: 'Desc_Roll_Back',
    icon: "fa-solid fa-toggle-on",
    color: "#02b875",
    showWhenKeyValueTrue: true,
    showHideOptionPerLine: true,
    controlKeyName: 'isRejected'
});
        }

 }


 populatePriceLists() {
  this.priceFilter.organizationId = this.priceFilterForm.get('organizationId').value == null ? -1 : this.priceFilterForm.get('organizationId').value;
  this.priceFilter.priceListTypeId = this.priceFilterForm.get('priceListTypeId').value == null ? -1 : this.priceFilterForm.get('priceListTypeId').value;
  this.priceFilter.customListFilter = this.query.customListFilter;
  this.priceFilter.dateModel = this.fromDate == null ? null : this.fromDate;
  this.priceFilter.toDate = this.toDate == null ? null : this.toDate;
  this.priceFilter.customerId= this.selectedCustomerId,
  this.priceFilter.outletId=   this.selectedOutletId
  this.PriceListDateLoading = true
  this.coreSession.ModalLoading.Show();
  this.priceService.getPriceLists(this.priceFilter).subscribe(
    (response: ResponseModel) => {
      this.coreSession.ModalLoading.Hide();
      (response);
      if (response.status != null && response.status >= 0) {
        this.PriceListDate = response.data.data;
        this.PriceListDate = this.PriceListDate.filter(priceList=>priceList.isDefault==false)
        this.openPriceEntryDialog()


      }
      this.selectedPriceListId= null;
      this.PriceListDateLoading = false
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
}
 populatePendingPriceLists() {
   this.priceFilter.organizationId = this.priceFilterForm.get('organizationId').value == null ? -1 : this.priceFilterForm.get('organizationId').value;
   this.priceFilter.priceListTypeId = this.priceFilterForm.get('priceListTypeId').value == null ? -1 : this.priceFilterForm.get('priceListTypeId').value;
   this.priceFilter.customListFilter = this.query.customListFilter;
   this.priceFilter.dateModel = this.fromDate == null ? null : this.fromDate;
   this.priceFilter.toDate = this.toDate == null ? null : this.toDate;
   this.priceFilter.customerId= this.selectedCustomerId,
   this.priceFilter.outletId=   this.selectedOutletId
   this.priceFilter.typeId=this.OrderStatusTypeId
   this.coreSession.ModalLoading.Show();
   this.priceService.getPendingPriceLists(this.priceFilter).subscribe(
     (response: ResponseModel) => {
       this.coreSession.ModalLoading.Hide();
       (response);
       if (response.status != null && response.status >= 0) {
         this.dataSource = response.data;
      var defaultPrice =   this.dataSource.data.find(pricList=>pricList.isDefault==true);
      if(defaultPrice)
      defaultPrice.selected = true;
       } else {
         this.dataSource = {
           totalItems: 0,
           data: []
         };
         this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
       }
       this.selectedCustomerId= -1
       this.selectedOutletId = -1;
     }, (error: HttpErrorResponse) => {
       this.coreSession.ModalLoading.Hide();
       this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
     });
 }

 onRowClicked_contacts(event: any) {
  switch (event.operation) {
    case RowOperation.delete:
      this.deleteSelectContact(event.object);
      break;
    case RowOperation.edit:
      this.editSelectedContact(event.object);
      break;
  }
}
  editSelectedContact(selectedContact: CustomerOutletContactModel) {
    this.selectedContactIndex = this.contactsDataSourceArray.indexOf(selectedContact);
    this.outletForm.get('contactData').get('contactId').setValue(selectedContact.contactId);
    this.outletForm.get('contactData').get('contactName').setValue(selectedContact.contactName);
    this.outletForm.get('contactData').get('address').setValue(selectedContact.address);
    this.outletForm.get('contactData').get('email').setValue(selectedContact.email);
    this.outletForm.get('contactData').get('fax').setValue((selectedContact.fax === 0) ? '' : selectedContact.fax);
    this.outletForm.get('contactData').get('mobile').setValue((selectedContact.mobile === 0) ? '' : selectedContact.mobile);
    this.outletForm.get('contactData').get('phone').setValue((selectedContact.phone === 0) ? '' : selectedContact.phone);
    this.outletForm.get('contactData').get('street').setValue(selectedContact.street);
    this.outletForm.get('contactData').get('streetName').setValue(selectedContact.streetName);
    this.outletForm.get('contactData').get('addressDescriptionLanguages').setValue(selectedContact.addressDescriptionsLanguages);
    this.outletForm.get('contactData').get('contactDescriptionLanguages').setValue(selectedContact.contactDescriptionsLanguages);

    this.contactNameOldDescription = selectedContact.contactDescriptionsLanguages;
    this.contactAddressOldDescription = selectedContact.addressDescriptionsLanguages;
    this.contactAddBtnDesc = 'Desc_Edit';
  }
deleteSelectContact(selectedContact: CustomerOutletContactModel) {

  let index = -1;
  index = this.contactsDataSourceArray.findIndex(x => x.contactId === selectedContact.contactId);

  if (index != -1) {
    this.contactsDataSourceArray.splice(index, 1);
    this.contacts_dataSource = {
      data: this.contactsDataSourceArray,
      totalItems: this.contactsDataSourceArray.length
    }
  }
}
 //#region [SHARED TABLE EVENTS]
 ReasonNote:string = null ;
 onRowClicked(event: any) {
  this.selectedPendingPriceList = event.object ;
   switch (event.operation) {
     case RowOperation.reject:
      this.selectedPendingPriceList.statusId = 8;
      this.openReasonEntryDialog()
       break;
     case RowOperation.approve:
      this.approvePendinPriceList()
      //  this.ApprovePrice(event.object);
       // this.IsValidToApprove(event.object);
       break;
     case RowOperation.Activate:
      this.approvePendinPriceList();
       break;
     case RowOperation.View:
       if(this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.View)){
         this.isViewMode = true;
         this.selectedPriceList = cloneDeep(event.object);
         this.showSlider = true;
         this.openPriceEntryDialog()
       }
       break;

       case RowOperation.Configure:
         if(this.coreSession.checkActivitiesAvailability(ConstantURLs.pricesURL, MenuActions.View)){
           this.isViewMode = true;
           this.selectedPriceList = cloneDeep(event.object);
           this.showSlider = true;
           this.isViewOriginalMode = true;

         }
         break;
   }
 }

 approvePendinPriceList(){
  var PriceListObject = this.selectedPendingPriceList
  var customerPrice = {
    customerId : PriceListObject.customerId,
    customerName : "",
    outletId : PriceListObject.outletId,
    priceListID :-1,
    descriptionLanguages : [],
    customerOutletContacts:[]
  }
  this.selectedCustomerPriceList = customerPrice;
  this.populatePriceLists();
 }





 onMultiSelectionOperation(event: any) {
   switch (event.operation) {

     case MultiSelectionOperation.delete:
       break;
   }
 }

 onOtherLanguagesTextSubmitted(event) {
  this.selectedCustomerPriceList.descriptionLanguages[0] = event[0];
}
 UpdatePendingPriceList(){
  this.priceService.UpdatePendingPriceList(this.selectedPendingPriceList)
  .subscribe(
    (response: ResponseModel) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
          this.populatePendingPriceLists();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
      this.selectedPendingPriceList = null;
    },
    (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
  );
 }
 insertCustomerPriceList(){
  this.priceService.InsertCustomerPriceList(this.selectedCustomerPriceList)
  .subscribe(
    (response: ResponseModel) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
          this.selectedPendingPriceList.statusId = 2;
          this.PriceEntryDialog.Close()
          this.ContactEntryDialog.Close()
          this.UpdatePendingPriceList()

      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
    (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
  );
 }


 closeSlider() {
   this.isEditMode = false;
   this.isViewMode = false;
   this.isViewPendingMode = false;
   this.showSlider = false;
   this.isViewOriginalMode = false;
   this.isDeleteMode = false;
   this.showSharedTable = true
   this.PriceEntryDialog.Close()
   this.isTouched = false
 }
 closeReasonDialog(){
  this.ReasonEntryDialog.Close()
 }

 closeOutletDialog(){
  this.ContactEntryDialog.Close()
 }

 onSaveReasonClick(){
  debugger
  if(this.ReasonNote!= null && this.ReasonNote!=""){
    this.selectedPendingPriceList.reason = this.ReasonNote ;
    this.UpdatePendingPriceList();
    this.ReasonEntryDialog.Close()

  }
    else{
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
  }
 }
 onSaveOutletContactClick(){


  this.FillOutletObjData()

 }
 onSaveClick() {
  this.isTouched = false

  if(this.selectedCustomerPriceList.priceListID != -1 && this.customerForm.valid ){
    var customerlanguage = this.customerForm.get("customerName").value;
    this.selectedCustomerPriceList.customerName = customerlanguage;
    var customerDescriptionlanguage = {
      languageId: this.coreSession.selectedLanguageId,
      description: customerlanguage,
    }

    this.selectedCustomerPriceList.descriptionLanguages.push(customerDescriptionlanguage)
    this.openOutletContactDialog()
    //
  }
  else{
    if(this.selectedCustomerPriceList.priceListID == -1)
    this.isTouched = true

    this.customerForm.markAllAsTouched();

    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
  }
 }
 openFilter() {
   this.mainFilter.Show().then(result => {
   });
 }
 onFindButtonClicked(result) {
   this.query.customListFilter.page = 0;
   //  this.query.customerId = result.customerId;
   this.populatePendingPriceLists();
 }
 onTableFilterChanged(query: any) {

   this.query.customListFilter = query;
   this.populatePendingPriceLists();
 }
 onNewBtnClicked() {
   this.isEditMode = false;
   this.isViewMode = false;
   this.isViewPendingMode = false;
   this.selectedPriceList = undefined;
   this.showSlider = true;
   this.showSharedTable = false
   this.openPriceEntryDialog()
 }

 ApplySerachFilterOnFind(){
   this.priceFilter.customListFilter.page = 0;
   this.populatePendingPriceLists();
 }

 onReset(){
   this.fromDate = null;
   this.toDate = null;
   this.priceFilterForm.reset();
 }
 onToDateSelected(date: any) {
   this.fromDate = null;
   this.fromDate = date;
 }
 onFromDateSelected(date: any) {
   this.toDate = null;
   this.toDate = date;
 }

 initFilterForm() {
   this.priceFilterForm = new FormGroup({
     organizationId: new FormControl(),
     fromDate: new FormControl(null),
     toDate: new FormControl(null),
     priceListTypeId: new FormControl(),
     customerId: new FormControl(
       { value: null, disabled: false },
     ),
     outletId: new FormControl(
       { value: null, disabled: false },
     ),
   })
 }
 //#endregion
}
