import { SurveyService } from './../../../survey-managment/survey.service';
import { Component, OnInit, Input, Output, OnDestroy, EventEmitter, ViewChild, ChangeDetectorRef } from '@angular/core';
import { FormGroup, FormControl, Validators, FormArray } from '@angular/forms';
import { ITextInput } from '../../../../../shared/models/shared-table/custom-list.interface';
import { CoreSession } from '../../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { MasterDataService } from '../../../master-data.service';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { Observable, Observer } from 'rxjs';
import { PromotionTypes } from "../../../../../shared/models/enums/promotion-types.enum";
import { HttpErrorResponse, HttpClient } from '@angular/common/http';
import { DateTimeModel } from '../../../../../shared/models/dateTimeModel/date-time.model';
import { IDateTimePickerProperties } from '../../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { PromotionInputDetailTypes } from '../../../../../shared/models/enums/promotion-input-detail-types.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { PackGroupFilter } from '../../../../../shared/components/filters/pack-group-filter/pack-group-filter-interface';
import { PackTypeFilter } from '../../../../../shared/components/filters/pack-type-filter/pack-type-filter-interface';
import { PromotionOptionTypes } from '../../../../../shared/models/enums/promotion-option-type.enum';
import { PromotionOutputDetailTypes } from '../../../../../shared/models/enums/promotion-output-detail-types.enum';
import { FillPackGroupItemsQuantityComponent } from '../../../../../shared/components/promotion/fill-pack-group-items-quantity/fill-pack-group-items-quantity.component';
import { NgbModal, NgbModalConfig } from '@ng-bootstrap/ng-bootstrap';
import { CustomerGroupModel } from '../../../../../shared/models/customer/customer.group.model';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { MultiSelectionOperation, RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import * as cloneDeep from 'lodash/cloneDeep';
import { CustomerService } from '../../../../../shared/services/data-definition/customer/customers.service';
import { SelectCustomersComponent } from '../../../../../shared/components/customers/select-customers/select-customers.component';
import { PricesAndOffersService } from '../../prices-and-offers.service';
import { PromotionLevel } from '../../../../../shared/models/enums/promotion-level.enum';
import { ItemService } from '../../../../../shared/services/data-definition/product/item.service';
import { GeneralFilter } from '../../../../../shared/models/general/generalFilter.model';
import { CalculationService } from '../../../../../shared/services/calculations.service';
import { CommonButtonStyles } from '../../../../../shared/models/enums/common-button-styles.enum';
import { WebApplication } from '../../../../../shared/models/enums/web-application.enum';
import { ImageFileModel } from '../../../../../shared/models/image/image-file.model';
import { map } from 'rxjs/operators';
import { EmailFileModel } from '../../../../../shared/models/email/email.model';
import { SettingsService } from '../../../../admin-settings/settings.service';
import { saveAs } from "file-saver";
import { ApprovalCycleOperations } from '../../../../../shared/models/enums/approval-cycle-operations-enum';
import { OfferAppliedOptions } from '../../../../../shared/models/enums/offer-applied-options.enum';
import { AchievementTypeValues } from '../../../../../shared/models/enums/achievements/achievement-type-values.enum';
import { AchievementValues } from '../../../../../shared/models/enums/achievements/achievement-values.enum';
import { TargetModes } from '../../../../../shared/models/enums/target-modes.enum';
import { Subject } from "rxjs";
import { EchoNotifications } from '../../../../../echo/models/echoNotifications.model';
import { PackGroupService } from '../../../../../shared/services/data-definition/product/pack-group.service';
import { PromotionService } from '../../../../../shared/services/data-definition/prices-and-offers/promotion.service';
import { LoyaltyModes } from '../../../../../shared/models/enums/loyalty-modes-enum';
import { LoyaltyProgramsService } from '../../../../../shared/services/data-definition/prices-and-offers/loyalty-programs.service';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { DiscountService } from '../../../../../shared/services/data-definition/prices-and-offers/discount.service';
import { SalesModes } from "../../../../../shared/models/enums/sales.modes.enum";
import { ImportDataTypes } from '../../../../../shared/models/import/ImportDataTypes';
import { ImportDialogComponent } from '../../../../../shared/components/import-dialog/import-dialog.component';
import { SharedDialogComponent } from '../../../../../shared/components/shared-dialog/shared-dialog.component';
import { CustomerSelectionLevel } from '../../../../../shared/models/enums/customer-selection-level.enum';
import { Router } from '@angular/router';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../../shared/shepherd-config/trackTour.service';
@Component({
  selector: 'app-promotion-entry',
  templateUrl: './promotion-entry.component.html',
  styleUrls: ['./promotion-entry.component.css']
})
export class PromotionEntryComponent implements OnInit, OnDestroy {

  @ViewChild('selectCustomerDialog', { static: true }) selectCustomerDialog: SelectCustomersComponent;
  @ViewChild('excludeCustomersDialog', { static: true }) excludeCustomersDialog: SelectCustomersComponent;
  @ViewChild("fillPackGroupItems", { static: true }) fillPackGroupItems: FillPackGroupItemsQuantityComponent;
  @ViewChild('templateEntry', { static: true }) templateEntry: SharedDialogComponent;
  @ViewChild("import") import: ImportDialogComponent;
  @Input() isBundle: boolean = false;
  @Input() isLoyaltyPromotion: boolean = false;
  @Input() promotionModeId: number = -1;
  @Input() saveEvent: Observable<void>;
  @Input() isEditMode: boolean = false;
  @Input() isCloneMode: boolean = false;
  @Input() isViewMode: boolean = false;
  @Input() promotionObject: any = {};
  @Input() isEditTargetPromotion: boolean = false;
  @Input() achievementCustomerList: any[] = [];
  @Input() isPromotionApprovalCycle: boolean = false;
  echoNotificationsObj: EchoNotifications;
  forceEqualityInPromotionPackGroup: boolean = false;
  restrictPromotionTypes: boolean = false;
  ConsiderStockStatusInOrderFlow: boolean = false;
  freeQuantityToggle : boolean;
  appliedTodataType: ImportDataTypes = ImportDataTypes.CustomerOutletPromotion;
  excludeCustomerdataType: ImportDataTypes = ImportDataTypes.ExcludeCustomerOutletPromotion;
  @Output() onAddingPromotionEvent = new EventEmitter();
  saveBtnSubscription: any;
  direction: any;
  importedRecordsCount: string = '';
  notImportedRecordsCount: string = '';
  otherPromotionLanguages: any[] = [];
  promotionNameInput: ITextInput = {
    formControlName: 'promotionName',
    placeHolder: 'Desc_Description',
    label: 'Desc_Description'
  };

  organizationsList: any[] = [];
  organizationDropdownSettings = {
    singleSelection: false,
    idField: 'organizationId',
    textField: 'organizationCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 3,
  };

  allCustomerGroupsList: CustomerGroupModel[] = [];
  allCustomersList: any[] = [];
  groupsDropdownSettings = {
    singleSelection: false,
    idField: 'groupId',
    textField: 'groupCodeName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 2
  };

  allChannelsList: any[] = [];
  channelsDropdownSetting = {
    singleSelection: false,
    idField: 'channelSubChannelIds',
    textField: 'channelSubChannelDescriptions',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 2
  };
  allSDCsList: any[] = []; // Sales Distribution Channels
  sdcDropdownSetting = {
    singleSelection: false,
    idField: 'sdcId',
    textField: 'sdcCodeName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 1
  };

  // Apply to customers
  addedCustomersList: any[] = [];
  copyOfAddedCustomers: any[] = [];
  customersSharedTabel: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: true,
    showNewBtn: true,
    // showImport: true,
    // importBtnCaption: 'Desc_Import',
    showEditButton: false,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
      }],
    multiSelectionOperations: [
      {
        operation: MultiSelectionOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
        style: CommonButtonStyles.Negative.valueOf()
      }],
    columns: [
      { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' },
    ]
  };
  customersDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };

  // Exluded Customers
  excludedCustomersList: any[] = [];
  copyOfExcludeCustomers: any[] = [];
  excludeCustomersSharedTabel: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: true,
    showNewBtn: true,
    showImport: true,
    importBtnCaption: 'Desc_Import',
    newBtnCaption: 'Desc_Add',
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
      }],
    multiSelectionOperations: [
      {
        operation: MultiSelectionOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
        style: CommonButtonStyles.Negative.valueOf()
      }],
    columns: [
      { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' },
    ]
  };
  excludeCustomersDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };

  promotionId: number = -1;
  promotionType = null;
  promotionEntryForm: FormGroup;
  navLinks: any[];
  promotionTypesList: any[] = [];
  inputDetailsTypesList: any[] = [];
  outputDetailsTypesList: any[] = [];
  achievementTypesList: any[] = [];
  salesOrderTypeList: any[] = [];
  invalidCustomers: any[] = [];
  invalidExcludeCustomers: any[] = [];
  invalidGroups: any[] = [];
  invalidChannels: any[] = [];
  isSalesOrderTypeLoading = false;
  customerCodeNames: string = '';
  fromToDate: DateTimeModel[] = [];
  fromToDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Date',
    formControlName: 'fromToDate',
    isCalendarOnly: true,
    isRange: true,
    labelHidden: true,
  };
  detailsFromToDate: DateTimeModel[] = [];
  detailsFromToDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Date',
    formControlName: 'dateRange',
    isCalendarOnly: true,
    isRange: true,
    labelHidden: true,
  };

  showDefinitionData: boolean = false;
  showDetailsData: boolean = false;
  showApplyToData: boolean = false;
  showExcludeCustomersData: boolean = false;

  inputPackGroupFilter: PackGroupFilter = {
    currentFormControlName: 'inputSelectedValueId',
    getGroupsHavingSamePackQuantity: true
  }
  outputPackGroupFilter: PackGroupFilter = {
    currentFormControlName: 'outputSelectedValueId',
    getGroupsHavingSamePackQuantity: true
  }
  packTypeFilter: PackTypeFilter = {
    currentFormControlName: 'inputSelectedValueId'
  }
  currentSelectedDetailForm: FormGroup;
  ControlTransactionOnDivisionLevel = false;
  currenctPackGroupDetails: any = {
    oldPackGroupDetails: [],
    packGroupId: -1
  };

  stepSelectionList: any[] = [];
  stepInputSelectedObject = {};

  stepOutputSelectionList: any[] = [];
  stepOutputSelectedObject = {};


  numberOfStockDigitsFormat: number = 0;
  numberOfDigitsFormat: number = 0;
  restrictApprovalCycleToOrganizationLevelString: string = '';
  showAutoRangeFillScreen = false;
  autoRangeInputValueStart = 0;
  autoRangeInputValueEnd = 0;
  autoRangeOutputValue = 0;

  allItemsList: any = [];
  allItemsLevelList: any = [];
  allPackGroupsList: any = [];
  allPackTypList: any = [];
  maxDetailId: number = 0;
  maxOptionId: number = 0;

  pointValidityPeriodTypesList: any = [];

  ForceCustomerOrganizationSelection = null;
  organizationIdsString: any = null;

  attahcedImages: ImageFileModel[] = [];
  attachedFiles: EmailFileModel[] = [];
  deletedFiles: string[] = [];
  formData: FormData = new FormData();
  promotionReasonList: any[] = [];
  AllowCustomerAppLogin = false;

  maxIndex: number = 0;

  appliedOptionsList: any[] = [];
  appliedOptionsDropdownSettings = {
    singleSelection: false,
    idField: 'optionId',
    textField: 'optionName',
    selectAllText: '',
    unSelectAllText: '',
    allowSearchFilter: false,
    itemsShowLimit: 3,
  };
  salesOrderTypeDropDownSettings = {
    singleSelection: false,
    idField: 'salesOrderTypeId',
    textField: 'salesOrderTypeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 1,
  };
  emp
  applyOnCustomerAppOnly = false;
  ForceOrganizationFilterForPackGroups = false;
  ApplyCurrencyPerOrg = false;
  packGroupDialogMode: any = {
    preRequisiteQty: 1,
    benefitDiscountPercentage: 2,
    benefitFixedPrice: 3,
    preRequisiteDifferentQtyOverGroupFromSalesOrderType: 4
  }
  sessionTitle = 'Promotion';
  promotionAchievementId = -1;
  promotionAchievementTypeId = -1;
  promotionLevel: PromotionLevel = PromotionLevel.OutletLevel;
  selectedTargetInputTypeId: PromotionInputDetailTypes = null;
  selectedTargetInputSelectionId = null;
  selectedTargetOutputSelectionId = null;
  targetModesList: any[] = [];
  isRelatedToTarget = false;
  isRestrictPromotionType = false;
  ShowEnableSelection = false;
  resetLastInvRem = true;
  targetModeId = -1;
  invImportedCount = 0;
  surveysList: any[] = [];
  showSurveyScreen = false;
  saveSurveySubject: Subject<void> = new Subject<void>();
  promotionSequenceLevel: number = 0;
  promotionSequenceLevelsList: any[] = [];
  isValidToSave = true;
  showRestrictUpperLimit: boolean = false;
  showAddNew: boolean = false;
  customersToExclude: any[];

  salesModesList: any[] = [];
  salesModeDropDownSettings = {
    singleSelection: false,
    idField: 'salesModeId',
    textField: 'salesModeDescription',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 3,
  };
  excelDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  excelTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    isOnline: false,
    showSearch: false,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Code_Name', key: 'codeName', isSortable: false, width: '30%' },
      { title: 'Desc_Message', key: 'message', isSortable: false, width: '70%' },
    ]
  };

  enableSalesDistributionChannel: boolean = false;
  showNoOfInvoices: boolean = false;
  showSalesOrderInPackGroup: boolean = false;

  @ViewChild("NoSalesPeriodDialog", { static: true }) NoSalesPeriodDialog: NgbModal;
  noSalesPeriodForm :any;
  noSalesPeriodProperties: IDateTimePickerProperties = {
    label: 'Desc_Date',
    formControlName: 'fromToDate',
    isCalendarOnly: true,
    isRange: true,
    labelHidden: true,
  };
  disableNoSalesPeriodPicker = false;

  constructor(
    private modalService: NgbModal,
    public coreSession: CoreSession,
    private translateService: TranslateService,
    private masterDataService: MasterDataService,
    private sessionData: SessionDataProvider,
    private config: NgbModalConfig,
    private customerService: CustomerService,
    private pricesAndOffersService: PricesAndOffersService,
    private promotionService: PromotionService,
    private itemService: ItemService,
    private surveyService: SurveyService,
    private settingsService: SettingsService,
    private calculationService: CalculationService,
    private packGroupService: PackGroupService,
    private http: HttpClient,
    private loyaltyProgramsService: LoyaltyProgramsService,
    private discountService: DiscountService,
    private router :Router,
    private shepherdService:ShepherdService,
    private tourService: TourService,
    private cdr: ChangeDetectorRef,
    private componentVisitService: ComponentVisitService
  ) {

  }
  ngAfterViewInit() {
    setTimeout((data=>{
      var elementSelectors  = ['#desc-def','#code-def',
      '#Promotion-Type-def','#Apply_In_Options','#Adate-def',
      '#vendor-def', '#Sequence-def', '#Sales_Modes','#Apply_All_Customers',
      '#InactivePromotion','#image','#attachment'
    ]// Target each column by its unique ID
     this.startTour(elementSelectors,'MainData')

    }),3000)

     }

     private tourStartTimeout: any;

     startTour(elementSelectors,type){

      this.tourStartTimeout=  setTimeout((data=>{
        if(!this.tourService.isFirstTour()){
          if(type=='ApplyToData'){
            this.showAppliedSharedTable = true
          }
        }
        else{
          if (this.tourService.isTourCompletedForComponent('promotion-main')) {
            if(type=='ApplyToData'){
              this.showAppliedSharedTable = true
            }
                    return;
          }
        const titles = [];
          const texts = [];
          for (let index = 0; index < elementSelectors.length; index++) {

            const { title, text } = this.getTitleAndText(index,type);
            titles.push(title);
            texts.push(text);
          }
         const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
         this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
         this.shepherdService.modal = true;
         this.shepherdService.addSteps(steps);
         this.shepherdService.start();

         this.shepherdService.tourObject.on('complete', () => {
          if(type=='ApplyToData'){
            this.showAppliedSharedTable = true
          }

      });
      this.shepherdService.tourObject.on('cancel', () => {
        if(type=='ApplyToData'){
          this.showAppliedSharedTable = true
        }
    });}
    this.cdr.detectChanges();

       }),1000)
     }

     getTitleAndText(index: number, type): { title: string, text: string } {
      let title = '';
      let text = '';

      if (type == 'MainData') {
        switch (index) {
          case 0:
            title = "Add Image";
            text = "Here you can upload image from device.";
            break;
          case 1:
            title = "Item Definition";
            text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
            break;
          case 2:
            title = "Brand and Description";
            text = "You can select brand and define a new description.";
            break;
          case 3:
            title = "Inactive Toggle";
            text = "These buttons make the item as inactive and the customer can't show it.";
            break;
          case 4:
            title = "Is New Toggle";
            text = "Make this item as new to show in new section.";
            break;
          case 5:
            title = "Is New Toggle";
            text = "Make this item as new to show in new section.";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      } else if (type === 'Detail-promo') {
        switch (index) {
          case 0:
            title = "New Pack";
            text = 'Here you can define your items and pack for it.';
            break;
          case 1:
            title = "Add Image";
            text = "Here you can upload image from device.";
            break;
          case 2:
            title = "Item Definition";
            text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
            break;
          case 3:
            title = "Brand and Description";
            text = "You can select brand and define a new description.";
            break;
          case 4:
            title = "Inactive Toggle";
            text = "These buttons make the item as inactive and the customer can't show it.";
            break;
          case 5:
            title = "Is New Toggle";
            text = "Make this item as new to show in new section.";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      } else if (type == 'ApplyToData') {
        switch (index) {
          case 0:
            title = "New Pack";
            text = 'Here you can define your items and pack for it.';
            break;
          case 1:
            title = "Add Image";
            text = "Here you can upload image from device.";
            break;
          case 2:
            title = "Item Definition";
            text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
            break;
          case 3:
            title = "Brand and Description";
            text = "You can select brand and define a new description.";
            break;
          case 4:
            title = "Inactive Toggle";
            text = "These buttons make the item as inactive and the customer can't show it.";
            break;
          case 5:
            title = "Is New Toggle";
            text = "Make this item as new to show in new section.";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      } else if (type === 'Attachment') {
        switch (index) {
          case 0:
            title = "New Pack";
            text = 'Here you can define your items and pack for it.';
            break;
          case 1:
            title = "Add Image";
            text = "Here you can upload image from device.";
            break;
          case 2:
            title = "Item Definition";
            text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
            break;
          case 3:
            title = "Brand and Description";
            text = "You can select brand and define a new description.";
            break;
          case 4:
            title = "Inactive Toggle";
            text = "These buttons make the item as inactive and the customer can't show it.";
            break;
          case 5:
            title = "Is New Toggle";
            text = "Make this item as new to show in new section.";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      } else if (type === 'Contact') {
        switch (index) {
          case 0:
            title = "New Pack";
            text = 'Here you can define your items and pack for it.';
            break;
          case 1:
            title = "Add Image";
            text = "Here you can upload image from device.";
            break;
          case 2:
            title = "Item Definition";
            text = `Define your item with name and code.<br> <span style="color: red;">The fields marked with a red star (*) are required.</span>`;
            break;
          case 3:
            title = "Brand and Description";
            text = "You can select brand and define a new description.";
            break;
          case 4:
            title = "Inactive Toggle";
            text = "These buttons make the item as inactive and the customer can't show it.";
            break;
          case 5:
            title = "Is New Toggle";
            text = "Make this item as new to show in new section.";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in default at bottom.`;
        }
      } else {
        title = `Step ${index + 1}`;
        text = `Content in default at bottom.`;
      }

      return { title, text };
    }

  ngOnInit() {
    if (this.isBundle) {
      this.sessionTitle = "Bundle";
    }
    if (this.isLoyaltyPromotion) {
      this.sessionTitle = "Loyalty Programs";
    }
    this.restrictPromotionTypes = this.sessionData.getConfigurationValue(ConstantConfigurations.RestrictPromotionTypes).toLowerCase() === "true";
    this.showAddNew = this.coreSession.checkActivitiesAvailability(ConstantURLs.dynamicFormsURL, MenuActions.Add);
    this.forceEqualityInPromotionPackGroup = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceEqualityInPromotionPackGroup).toLowerCase() === "true";
    this.numberOfStockDigitsFormat = +this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfStockDigits);
    this.numberOfDigitsFormat = +this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfDigits);
    this.promotionSequenceLevel = +this.sessionData.getConfigurationValue(ConstantConfigurations.PromotionSequenceLevels);
    this.ForceCustomerOrganizationSelection = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceCustomerOrganizationSelection).toLowerCase() === "true"
    this.AllowCustomerAppLogin = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowCustomerAppLogin).toLowerCase() === "true";
    this.ForceOrganizationFilterForPackGroups = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForPackGroups).toLowerCase() === "true";
    this.ApplyCurrencyPerOrg = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyCurrencyPerOrganization).toLowerCase() === "true";
    this.restrictApprovalCycleToOrganizationLevelString = this.sessionData.getConfigurationValue(ConstantConfigurations.RestrictApprovalCycleToOrganizationLevel);
    this.ConsiderStockStatusInOrderFlow = this.sessionData.getConfigurationValue(ConstantConfigurations.ConsiderStockStatusInOrderFlow).toLowerCase() === "true";

    this.direction = this.coreSession.isRTL;
    this.salesOrderTypeDropDownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.salesOrderTypeDropDownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.salesOrderTypeDropDownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    // customize default values of modals used by this component tree
    this.config.backdrop = true;
    this.config.keyboard = true;

    this.ControlTransactionOnDivisionLevel = this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true";
    this.enableSalesDistributionChannel = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSalesDistributionChannel).toLowerCase() === "true"

    if (this.isViewMode) {
      this.coreSession.SetTitle('View ' + this.sessionTitle);
    }
    else if (this.isCloneMode) {
      this.coreSession.SetTitle('Clone ' + this.sessionTitle);
      this.promotionId = -1;
    } else if (this.isEditMode) {
      this.coreSession.SetTitle('Edit ' + this.sessionTitle);
      this.promotionId = this.promotionObject.promotionId;
    } else {
      this.coreSession.SetTitle('Add ' + this.sessionTitle);
      this.promotionObject = {
        promotionId: -1,
        isNew: true,
        promotionName: null,
        promotionCode: null,
        bundleLimit: null,
        promotionType: null,
        promotionReasonId: null,
        organizationId: null,
        organizationsList: [],
        fromToDate: null,
        inactive: false,
        applyBundleView: false,
        showInCustomerApp: true,
        isRepeated: false,
        originalRepeatCount: null,
        minValue: null,
        promotionLevel: PromotionLevel.OutletLevel,
        assignToAllCustomers: false,
        sequence: 1,
        groupsList: [],
        channelsList: [],
        customersList: [],
        excludedCustomersList: [],
        promotionInputs: [],
        promotionOutputs: [],
        descriptionLanguages: [],
        offerAppliedOptions: '',
        targetInputTypeId: null,
        targetInputSelectionId: null,
        targetOutputSelectionId: null,
        achievementId: null,
        achievementTypeId: null,
        isStartedTargetPromotion: false,
        relatedToTarget: false,
        oldRelatedToTarget : false,
        resetLastInvRem: true,
        targetMode: -1,
        surveyId: -1,
        appliedAfterPeriod: false,
        allowOring: false,
        oldAllowOring: false,
        maxLimit: null,
        isProductDiscount: false,
        oldIsProductDiscount: false,
        isRestrictUpperLimit: false,
        isLoyaltyPromotion: this.isLoyaltyPromotion,
        promotionModeId: this.promotionModeId,
        loyalityWidth: null,
        salesOrderTypeId: null,
        noOfInvoices: null
      };
    }
    this.subscribeSaveClick();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
    this.showDefinitionData = true;
    this.fillOrganizations();
    this.fillPromotionReasonList();
    this.fillGroupsList();
    this.fillChannelsSubChannelsList();
    if (this.enableSalesDistributionChannel) this.fillSDCsList();
    this.fillPromotionTypes();
    this.fillAchievementTypesForTargetPromotions();
    this.populateAllItemsList();
    this.populateAllItemsLevelList();
    this.populatePackTypesList();
    this.fillAppliedOptionsList();
    this.fillTargetModes();
    this.fillPromotionSequenceLevels();
    this.fillSalesOrderTypes();
    this.fillSalesModes();

    if (this.isLoyaltyPoints()) {
      this.fillValidityPeriodTypesList();
    }
    if (!this.ForceOrganizationFilterForPackGroups) {
      this.populateAllPackGroupsList();
    }
    this.fillSurveysList();
    this.organizationDropdownSettings.singleSelection = this.ApplyCurrencyPerOrg || this.restrictApprovalCycleToOrganizationLevel(ApprovalCycleOperations.Promotions.valueOf());
    this.organizationDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.organizationDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.organizationDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.channelsDropdownSetting.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.channelsDropdownSetting.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.channelsDropdownSetting.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.groupsDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.groupsDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.groupsDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.appliedOptionsDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.appliedOptionsDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);

    this.salesModeDropDownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.salesModeDropDownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.salesModeDropDownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.sdcDropdownSetting.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.sdcDropdownSetting.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.sdcDropdownSetting.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    if (this.enableSalesDistributionChannel) {
      this.channelsDropdownSetting.itemsShowLimit = 1;
      this.sdcDropdownSetting.itemsShowLimit = 1;
      this.groupsDropdownSettings.itemsShowLimit = 1;
    }
    this.initMainForm();
    this.fillSalesModeForNewPromotion();
    // this.initAutoRangesForm();
    this.promotionType = this.promotionObject.promotionType;  // null if new otherwise it cash saved promotio type
    this.fillInputDetailsTypesList();
    this.fillOutputDetailsTypesList();
    if (this.isViewMode || (this.promotionObject.isStartedTargetPromotion && this.isEditMode) || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle)) {
      this.customersSharedTabel.rowOperations = [];
      this.customersSharedTabel.multiSelectionOperations = [];
      this.customersSharedTabel.isMultiSelection = false;
      this.customersSharedTabel.showNewBtn = false;
      this.customersSharedTabel.showImport = false;
    } if (this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle)) {
      this.excludeCustomersSharedTabel.showNewBtn = false;
      this.excludeCustomersSharedTabel.showImport = false;
      this.excludeCustomersSharedTabel.rowOperations = [];
      this.excludeCustomersSharedTabel.multiSelectionOperations = [];
      this.excludeCustomersSharedTabel.isMultiSelection = false;
    }
    if (this.isEditMode || this.isCloneMode) {
      this.promotionObject.oldAllowOring = this.promotionObject.allowOring;
      this.promotionObject.oldIsProductDiscount = this.isProductDiscountControl.value;
      this.promotionObject.oldRelatedToTarget = this.promotionObject.relatedToTarget;
      const output = this.promotionObject.promotionOutputs[0].promotionOptionDetails[0];
      if(output.outputOptionDetailTypeId === PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems ||
        output.outputOptionDetailTypeId === PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems){
      this.freeQuantityToggle = true;
      this.disableOutputFormInFreeQuantityForAutoRange();
      this.fillOutputDetailsTypesList();
      this.fillInputDetailsTypesList();
      }
    }
    if (this.isEditMode || this.isCloneMode || this.isViewMode) {
      if (!this.ConsiderStockStatusInOrderFlow || ((this.ConsiderStockStatusInOrderFlow && (this.promotionType != PromotionTypes.FixedValues && this.promotionType != PromotionTypes.RangeValues && this.promotionType != PromotionTypes.StepsValues)))) {
        this.fillPromotionDataForEdit();
      }
    } else {
      // Add Mode
      if (this.isBundle) {
        this.promotionType = PromotionTypes.FixedValues;
        this.promotionTypeControl.setValue(PromotionTypes.FixedValues);
        this.promotionTypeControl.disable({ onlySelf: true, emitEvent: false });
        this.pushNewInputForm();
        this.pushNewOutputForm();
      }
    }
    if ((this.isEditMode || this.isCloneMode)) {
      this.getSelectedOrganizationIdsAsString(null);
      if (this.forceOrganizationFilterForCustomerGroups()) {
        this.fillGroupsList();
      }
      if (this.enableSalesDistributionChannel)
        this.fillSDCsList();
    }
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
    this.config.backdrop = true;
    this.config.keyboard = true;
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('promotion-main');
  }


  //#region [Images]
  onDeleteImage(imageIndex) {
    this.attahcedImages.splice(imageIndex, 1);
  }
  onDeleteFile(file) {
    this.deletedFiles.push(file.name);
    this.attachedFiles.splice(this.attachedFiles.indexOf(file), 1);
  }
  onUploadPromotionImages(event) {
    if (event) {
      let files = event.srcElement.files;
      if (files && files.length > 0) {
        for (let index = 0; index < files.length; index++) {
          let imageFile = new ImageFileModel();
          imageFile.file = files[index];
          imageFile.name = files[index].name;
          const reader = new FileReader();
          reader.onload = (event: ProgressEvent) => {
            imageFile.path = (<FileReader>event.target).result;
          };
          reader.readAsDataURL(event.target.files[index]);
          this.attahcedImages.push(imageFile);
        }
      }
    }
  }
  onUploadFiles(file) {
    if (file) {
      let files = file.srcElement.files;
      if (files.length > 0) {
        for (let index = 0; index < files.length; index++) {
          if (files[index].size > 10000000) //10 MB
          {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorLargeSize));
          }
          else {
            let fileObject = new EmailFileModel();
            let reader = new FileReader();
            fileObject.file = files[index];
            fileObject.name = files[index].name;
            let dotes = files[index].name && (files[index].name.length > 20) ? '..' : '';
            fileObject.shortName = files[index].name.substring(0, 20) + dotes;
            fileObject.index = this.maxIndex;
            fileObject.isImage = files[index].type.includes('image') ? true : false;
            reader.onload = (event: ProgressEvent) => {
              if (fileObject.isImage) {
                fileObject.path = (<FileReader>event.target).result;
              } else {
                fileObject.path = this.coreSession.getDefaultPathAttachments();
              }
              fileObject.pathFile = fileObject.name;
            };
            reader.readAsDataURL(file.target.files[index]);
            this.maxIndex++;
            this.attachedFiles.push(fileObject);
          }
        }
      }
    }
  }
  getImage(url, imageName) {
    return this.http
      .get(url, {
        responseType: "blob"
      })
      .pipe(
        map(response => {
          return new File([response], imageName);
        })
      );
  }
  //#enedregion
  getFile(url) {
    return this.http
      .get(url, {
        responseType: "blob"
      })
      .pipe(
        map(response => {
          return new Blob([response], {
            type: "application/*"
          });
        })
      );
  }

  populateAllItemsList() {
    let itemFilter: GeneralFilter = {
      customListFilter: {
        searchFilter: '',
        page: 0,
        pageSize: 0 // to get all items from DB
      },
      divisionId: -1,
      itemCategoryId: -1,
      packId: -1,
      izLazyLodingCombo: true
    };
    this.itemService.getAllItemsLazyLoading(itemFilter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data) {
          this.allItemsList = response.data.data;
        }
      }
    });
  }
  populateAllItemsLevelList() {
    let itemFilter = {
      ItemCategoryId: -1,
      divisionId: -1,
      brandId: -1,
      modelId: -1,
      itemId: -1,
      showUpperLimitOnly: false,
      excludeCompetitorItem: true,
      IsLazyLodingCombo: true,
      selectItemId: -1,
      customListFilter: {
        searchFilter: '',
        page: 0,
        pageSize: 1000000
      },
      excludedItemIdsList: []
    };
    this.itemService.getItemsListSharedTable(itemFilter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data) {
          this.allItemsLevelList = response.data.data;
        }
      }
    });
  }

  fillValidityPeriodTypesList() {
    this.pointValidityPeriodTypesList.push({ 'typeId': 1, 'typeName': this.translateService.instant(ConstantMessages.Desc_Day) });
    this.pointValidityPeriodTypesList.push({ 'typeId': 2, 'typeName': this.translateService.instant(ConstantMessages.Desc_Week) });
    this.pointValidityPeriodTypesList.push({ 'typeId': 3, 'typeName': this.translateService.instant(ConstantMessages.Desc_Month) });
    this.pointValidityPeriodTypesList.push({ 'typeId': 4, 'typeName': this.translateService.instant(ConstantMessages.Desc_Year) });
  }
  populateAllPackGroupsList(clearExcludedPGsFromOrg: boolean = false) {
    var filter = {
      getGroupsHavingSamePackQuantity: this.forceEqualityInPromotionPackGroup,
      selectedOraganizationIds: this.organizationIdsString
    }
    this.packGroupService.getPackGroups(filter).subscribe(result => {
      this.allPackGroupsList = result.data;
      if (clearExcludedPGsFromOrg) {
        var availablePackGroupIds: number[] = this.allPackGroupsList.map(pg => pg.packGroupId);
        this.clearInputAndOutputDetailPackGroupOrgData(availablePackGroupIds);
      }
    });
  }
  populatePackTypesList() {
    this.itemService.getPackType().subscribe(result => {
      this.allPackTypList = result.data;
    });
  }
  fillAppliedOptionsList() {
    this.appliedOptionsList.push({ optionId: OfferAppliedOptions.Sonic.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Sonic_App_Caption) });
    this.appliedOptionsList.push({ optionId: OfferAppliedOptions.NearExpiry.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Near_Expiry_Operation_Caption) });
    // No bundles until now in echo
    if (!this.isBundle) {
      this.appliedOptionsList.push({ optionId: OfferAppliedOptions.CustomerApp.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Customer_App_Caption) });
    }
  }
  fillPromotionDataForEdit() {
    this.promotionLevel = this.promotionObject.promotionLevel;
    this.reflectPromotionLevelOnImportType(this.promotionLevel);
    this.changeCustomerUIColumns();
    this.promotionAchievementId = this.promotionObject.achievementId;
    this.promotionAchievementTypeId = this.promotionObject.achievementTypeId;
    this.selectedTargetInputTypeId = this.promotionObject.targetInputTypeId;
    this.selectedTargetInputSelectionId = this.promotionObject.targetInputSelectionId;
    this.selectedTargetOutputSelectionId = this.promotionObject.targetOutputSelectionId;
    if (this.promotionType === PromotionTypes.TargetPromotion || this.promotionType === PromotionTypes.DynamicTargetPromotion) {
      this.targetInputTypeControl.setValidators(Validators.required);
      if (this.selectedTargetInputTypeId === PromotionInputDetailTypes.DynamicTargetSummationOverGroup) {
        this.targetInputSelectionControl.setValidators(Validators.required)
        this.targetOutputSelectionControl.setValidators(Validators.required)
      }
    }
    this.targetInputTypeControl.updateValueAndValidity();
    this.targetInputSelectionControl.updateValueAndValidity();
    this.targetOutputSelectionControl.updateValueAndValidity();

    var optionsList = [];
    if (this.promotionObject.offerAppliedOptions.includes(OfferAppliedOptions.Sonic.valueOf().toString())) {
      optionsList.push({ optionId: OfferAppliedOptions.Sonic.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Sonic_App_Caption) });
    }
    if (this.promotionObject.offerAppliedOptions.includes(OfferAppliedOptions.CustomerApp.valueOf().toString())) {
      optionsList.push({ optionId: OfferAppliedOptions.CustomerApp.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Customer_App_Caption) });
    }
    if (this.promotionObject.offerAppliedOptions.includes(OfferAppliedOptions.NearExpiry.valueOf().toString())) {
      optionsList.push({ optionId: OfferAppliedOptions.NearExpiry.valueOf(), optionName: this.translateService.instant(ConstantMessages.Desc_Near_Expiry_Operation_Caption) });
    }
    if (optionsList && optionsList.length === 1 && optionsList[0].optionId === OfferAppliedOptions.CustomerApp.valueOf()) {
      this.applyOnCustomerAppOnly = true;
      // Re-fill output types according to selected applied option
      this.fillOutputDetailsTypesList();
    }
    this.offerAppliedOptionsControl.setValue(optionsList);

    // Fill images
    var imagesNames = this.promotionObject.imageList;
    if (imagesNames && imagesNames.length > 0) {
      for (let imageName of imagesNames) {
        var currentPath = document.getElementsByTagName("base")[0].href + "Resources/promotions-img/" + this.promotionObject.promotionId + "/" + imageName + "?random=" + new Date().getTime();
        let imageFile = new ImageFileModel();
        imageFile.name = imageName;
        imageFile.path = currentPath;
        this.getImage(currentPath, imageName).subscribe(response => imageFile.file = response);
        this.attahcedImages.push(imageFile);
      }
    }
    // this.attachedFiles = this.promotionObject.attachedFiles;
    var filesNames = this.promotionObject.attachedFiles;
    if (filesNames && filesNames.length > 0) {
      for (let fileName of filesNames) {
        //Resources\attachements\promotions
        var currentPath = document.getElementsByTagName("base")[0].href + "Resources/Attachements/promotions/" + this.promotionObject.promotionId + "/" + fileName;
        let file = new EmailFileModel();
        let name = currentPath.substr(currentPath.lastIndexOf('/') + 1);
        file.name = name;
        let dotes = name && (name.length > 20) ? '..' : '';
        file.shortName = name.substring(0, 20) + dotes;
        let imgExtensions = ['png', 'jpg', 'jpeg', 'gif']
        file.isImage = imgExtensions.includes(name.split('.').pop()) ? true : false;
        file.path = file.isImage ? currentPath : this.coreSession.getDefaultPathAttachments();
        file.pathFile = file.name;
        this.getFile(currentPath).subscribe(response => file.file = response);
        this.attachedFiles.push(file);
      }
    }

    this.getSelectedOrganizationIdsAsString(null);
    if (this.ForceOrganizationFilterForPackGroups) {
      this.populateAllPackGroupsList();
    }
    if (this.promotionType === PromotionTypes.StepsValues) {
      this.fillStepDefinitionInEditMode();
    }
    this.fillFormInputsInEditMode();
    this.fillFormOutputsInEditMode();

    this.manageShowNoOfInvoicesControl();
    if (this.showNoOfInvoices && this.promotionObject.showNoOfInvoices) {
      this.noOfInvoicesControl.setValue(this.promotionObject.noOfInvoices);
    }

    this.fillTargetModes();
    this.otherPromotionLanguages = this.promotionObject.descriptionLanguages;
    this.addedCustomersList = this.promotionObject.customersList;
    this.excludedCustomersList = this.promotionObject.excludedCustomersList;
    this.fillCustomersList();
    this.fillExcludedCustomersList();
    if (this.promotionObject.assignToAllCustomers) {
      this.navLinks[2].disable = true;
    }
    else {
      this.promotionEntryForm.get('groupsList').setValue(this.promotionObject.groupsList);
      this.promotionEntryForm.get('channelsList').setValue(this.promotionObject.channelsList);
      this.promotionEntryForm.get('sdcsList').setValue(this.promotionObject.sdcsList);
    }
    // disable if View Mode
    if (this.isViewMode || this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) {
      this.promotionTypeControl.disable({ onlySelf: true, emitEvent: false });
      this.organizationsListControl.disable({ onlySelf: true, emitEvent: false });
      this.offerAppliedOptionsControl.disable({ onlySelf: true, emitEvent: false });
      this.promotionEntryForm.get('groupsList').disable({ onlySelf: false, emitEvent: false });
      this.promotionEntryForm.get('channelsList').disable({ onlySelf: false, emitEvent: true });
      this.promotionEntryForm.disable({ onlySelf: true, emitEvent: false });
      this.disableNoSalesPeriodPicker = true;
    }
    if (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) {
      this.promotionEntryForm.get('headerDataFrom').get('promotionName').enable();
      this.promotionEntryForm.get('headerDataFrom').get('inactive').enable();
      this.disableNoSalesPeriodPicker = true;
    }
    else if ((this.promotionObject.isStartedTargetPromotion && this.isEditMode) || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle)) {
      this.targetInputTypeControl.disable();
      this.targetInputSelectionControl.disable();
      this.targetOutputSelectionControl.disable();
      this.promotionTypeControl.disable();
      this.promotionLevelControl.disable();
      this.fromToDateControl.disable();
      this.promotionEntryForm.get('inputs').disable();
      this.promotionEntryForm.get('outputs').disable();
      this.isRelatedToTargetControl.disable();
      this.resetLastInvRemControl.disable();
      this.targetModeControl.disable();
      this.seqenceControl.disable();
      this.appliedAfterPeriodControl.disable();
      this.allowOringControl.disable();
      this.maxLimitControl.disable();
      this.isProductDiscountControl.disable();
      this.isRestrictUpperLimitControl.disable();
      this.disableNoSalesPeriodPicker = true;
    }
  }
  fillFormInputsInEditMode() {
    this.promotionObject.promotionInputs.forEach(inputObject => {
      let inputForm = new FormGroup({
        details: new FormArray([], Validators.required)
      });
      inputObject.promotionOptionDetails.forEach(detailObject => {
        var isNoSalesInCertainPeriod = detailObject.promotionOptionDetailTypeId == PromotionInputDetailTypes.ItemWithNoSalesInCertainPeriodRestrictedToInvoicesCount || detailObject.promotionOptionDetailTypeId == PromotionInputDetailTypes.GroupWithNoSalesInCertainPeriodRestrictedToInvoicesCount;

        let detailForm = new FormGroup({
          inputDetailTypeId: new FormControl(detailObject.promotionOptionDetailTypeId, Validators.required),

          achievementId: new FormControl(detailObject.achievementId == -1 ? null : detailObject.achievementId, this.promotionType === PromotionTypes.TargetPromotion || this.promotionType === PromotionTypes.DynamicTargetPromotion ? Validators.required : Validators.nullValidator),
          achievementTypeId: new FormControl({ value: detailObject.achievementTypeId == -1 ? null : detailObject.achievementTypeId, disabled: detailObject.promotionOptionDetailTypeId != PromotionInputDetailTypes.CustomerMonthlyAchievement }, this.promotionType === PromotionTypes.TargetPromotion || this.promotionType === PromotionTypes.DynamicTargetPromotion ? Validators.required : Validators.nullValidator),

          inputSelectedValueId: new FormControl({ value: null, disabled: this.promotionType === PromotionTypes.StepsValues || detailObject.promotionOptionDetailTypeId === PromotionInputDetailTypes.DynamicTargetSummationOverGroup }, Validators.nullValidator),
          inputValue: new FormControl(detailObject.value == -1 ? null : detailObject.value, detailObject.promotionOptionDetailTypeId != PromotionInputDetailTypes.GroupDifferntQuantity && detailObject.promotionOptionDetailTypeId != PromotionInputDetailTypes.Survey && detailObject.promotionOptionDetailTypeId != PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel && !isNoSalesInCertainPeriod ? [Validators.required, Validators.min(0.0000001)] : Validators.nullValidator),
          inputValueRange: new FormControl(null),
          packGroupDetails: new FormControl(detailObject.packGroupDetails, detailObject.promotionOptionDetailTypeId === PromotionInputDetailTypes.GroupDifferntQuantity || detailObject.promotionOptionDetailTypeId === PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel ? Validators.required : Validators.nullValidator),
          inputSalesOrderTypeId: new FormControl(null),
          dateRange: new FormControl(isNoSalesInCertainPeriod ? [new Date(String(detailObject.fromDate)), new Date(String(detailObject.toDate))] : [], isNoSalesInCertainPeriod ? Validators.required : Validators.nullValidator),
        });
        var selectedValueId = null;
        if (!this.isInvoiceInput(detailForm)) {
          if (this.isItemLevelInput(detailForm)) {
            selectedValueId = detailObject.itemId;
          } else if (this.isItemInput(detailForm)) {
            selectedValueId = detailObject.packId;
          } else if (this.isPackGroupInput(detailForm)) {
            selectedValueId = detailObject.packGroupId;
          } else if (this.isPackTypeInput(detailForm)) {
            selectedValueId = detailObject.packTypeId;
          } else if (this.isDivisionInput(detailForm)) {
            selectedValueId = detailObject.divisionId;
          } else if (this.isSurveyInput(detailForm)) {
            if (!this.isCloneMode)
              selectedValueId = this.promotionObject.surveyId;
          }
          detailForm.get('inputSelectedValueId').setValue(selectedValueId);
          detailForm.get('inputSelectedValueId').setValidators(Validators.required);
          detailForm.get('inputSelectedValueId').updateValueAndValidity();
        }

        // set input value end for range type
        if (this.promotionType === PromotionTypes.RangeValues) {
          var rangeWidth = detailObject.range;
          var inputValueRange = 0;
          if (rangeWidth > 0) {
            inputValueRange = detailObject.value + rangeWidth;
            if (this.isStockDigitInput(detailForm)) {
              inputValueRange = this.calculationService.getNumberOnStockDigitFormat(inputValueRange);
            } else {
              inputValueRange = this.calculationService.getNumberOnDigitFormat(inputValueRange);
            }
            detailForm.get('inputValueRange').setValue(inputValueRange);
          }
        }
        if ((this.promotionType === PromotionTypes.FixedValues || this.promotionType === PromotionTypes.RangeValues || this.promotionType === PromotionTypes.StepsValues) && this.ConsiderStockStatusInOrderFlow) {
          if (this.isSalesOrderInput(detailForm)) {
            var salesTypesList = [];
            detailForm.get('inputSalesOrderTypeId').setValidators(Validators.required);
            detailForm.get('inputSalesOrderTypeId').updateValueAndValidity();
            this.salesOrderTypeList.forEach(x => {
              if (detailObject.salesOrderTypeId.includes(x.salesOrderTypeId.toString())) {
                salesTypesList.push({ salesOrderTypeId: x.salesOrderTypeId, salesOrderTypeName: x.salesOrderTypeName });
              }
            })
          }
          else {
            detailForm.get('inputSalesOrderTypeId').setValidators(Validators.nullValidator);
            detailForm.get('inputSalesOrderTypeId').updateValueAndValidity();
          }
          // Re-fill output types according to selected applied option
          detailForm.get('inputSalesOrderTypeId').setValue(salesTypesList);
        }

        (<FormArray>inputForm.get('details')).push(detailForm);
      });
      // disable if View Mode
      if (this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle)) {
        inputForm.disable();
      }
      (<FormArray>this.promotionEntryForm.get('inputs')).push(inputForm);
    });
  }
  initMainForm() {
    var isRepeateDataRequired = (this.isEditMode || this.isCloneMode || this.isViewMode) && this.promotionObject.isRepeated;
    var isBundleLimitRequired = (this.isEditMode || this.isCloneMode || this.isViewMode) && this.promotionObject.bundleLimit != null && this.promotionObject.bundleLimit > 0;
    var isRelatedToTargetRequired = (this.isEditMode || this.isCloneMode || this.isViewMode) && this.promotionObject.relatedToTarget;
    this.isRestrictPromotionType = !this.promotionObject.relatedToTarget && this.restrictPromotionTypes && (this.isEditMode || this.isCloneMode || this.isViewMode) && (this.promotionObject.promotionType === PromotionTypes.RangeValues || this.promotionObject.promotionType === PromotionTypes.StepsValues);
    this.ShowEnableSelection = this.isRestrictPromotionType && this.promotionObject.isProductDiscount;
    this.isRelatedToTarget = isRelatedToTargetRequired;
    this.showRestrictUpperLimit = this.promotionObject.promotionType === PromotionTypes.RangeValues && this.promotionObject.relatedToTarget ? true : false;
    if (this.isRelatedToTarget)
      this.targetModeId = this.promotionObject.targetMode;
    this.resetLastInvRem = this.promotionObject.resetLastInvRem;
    this.promotionEntryForm = new FormGroup({
      'headerDataFrom': new FormGroup({
        promotionName: new FormControl(this.promotionObject.promotionName, Validators.required),
        promotionCode: new FormControl(this.promotionObject.promotionCode, Validators.required),
        promotionType: new FormControl({ value: this.promotionObject.promotionType, disabled: (this.isEditMode || this.isCloneMode || this.isViewMode) }, Validators.required),
        offerAppliedOptions: new FormControl({ value: [], disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }, !this.isBundle ? Validators.required : Validators.nullValidator),
        promotionReasonId: new FormControl({ value: this.promotionObject.promotionReasonId === -1 ? null : this.promotionObject.promotionReasonId, disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }),
        fromToDate: new FormControl((this.isEditMode || this.isCloneMode) ? [this.promotionObject.startDate, this.promotionObject.endDate] : [], Validators.required),
        inactive: new FormControl({ value: this.promotionObject.inactive, disabled: this.isViewMode }, Validators.required),
        applyBundleView: new FormControl({ value: this.promotionObject.applyBundleView, disabled: this.isViewMode }, Validators.required),
        isRepeated: new FormControl(this.promotionObject.isRepeated),
        originalRepeatCount: new FormControl({ value: this.promotionObject.originalRepeatCount, disabled: !isRepeateDataRequired || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }, isRepeateDataRequired ? [Validators.required, Validators.min(1)] : Validators.nullValidator),
        minValue: new FormControl({ value: this.promotionObject.minValue, disabled: !isRepeateDataRequired || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }, isRepeateDataRequired ? Validators.required : Validators.nullValidator),
        checkBundleLimit: new FormControl(isBundleLimitRequired ? true : false),
        bundleLimit: new FormControl({ value: this.promotionObject.bundleLimit, disabled: !isBundleLimitRequired }, isBundleLimitRequired ? [Validators.required, Validators.min(1)] : Validators.nullValidator),
        promotionLevel: new FormControl({ value: this.promotionObject.promotionLevel, disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }, Validators.required),
        assignToAllCustomers: new FormControl(this.promotionObject.assignToAllCustomers),
        sequence: new FormControl({ value: this.promotionObject.sequence < 1 ? 1 : this.promotionObject.sequence, disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }),
        organizationsList: new FormControl({ value: this.promotionObject.organizationsList, disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }),
        isRelatedToTarget: new FormControl(this.promotionObject.relatedToTarget),
        resetLastInvRem: new FormControl(this.promotionObject.resetLastInvRem),
        targetMode: new FormControl({ value: this.promotionObject.targetMode, disabled: !isRelatedToTargetRequired || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }, isRelatedToTargetRequired ? Validators.required : Validators.nullValidator),
        appliedAfterPeriod: new FormControl(this.promotionObject.appliedAfterPeriod),
        allowOring: new FormControl(this.promotionObject.allowOring),
        maxLimit: new FormControl(this.promotionObject.maxLimit),
        isProductDiscount: new FormControl(this.promotionObject.isProductDiscount),
        isRestrictUpperLimit: new FormControl(this.promotionObject.isRestrictUpperLimit),
        loyaltyWidth: new FormControl(this.promotionObject.loyalityWidth, this.isLoyaltyPromotion && this.promotionModeId == LoyaltyModes.LoyaltyPromotion ? Validators.required : null),
        salesModes: new FormControl(this.getSalesModesListFromString(this.promotionObject && this.promotionObject.salesMode ? this.promotionObject.salesMode : ""), Validators.required),
        noOfInvoices: new FormControl(this.promotionObject.noOfInvoices)
        // showInCustomerApp: new FormControl({value:this.promotionObject.showInCustomerApp, disabled: this.isViewMode}),
      }),
      'stepEntryForm': new FormGroup({
        inputDetailTypeId: new FormControl(null),
        inputSelectedValueId: new FormControl(null),
        outputDetailTypeId: new FormControl(null),
        outputSelectedValueId: new FormControl(null),
        inputSalesOrderTypeId: new FormControl(null),
      }),
      'autoRangesForm': new FormGroup({
        inputDetailTypeId: new FormControl(null),
        inputSelectedValueId: new FormControl(null),
        inputValue: new FormControl(null),
        inputValueRange: new FormControl(null),
        inputRangeWidth: new FormControl(null),
        inputSalesOrderTypeId: new FormControl(null),

        outputDetailTypeId: new FormControl(null),
        outputSelectedValueId: new FormControl(null),
        outputValue: new FormControl(null),
        outputIncrementBy: new FormControl(null),
        outputValidityWidth: new FormControl(null),
        outputSalesOrderTypeId: new FormControl(null),
        incrementDecrementOutputStartValue: new FormControl(1),
      }),
      targetInputTypeId: new FormControl({ value: this.promotionObject.targetInputTypeId === -1 ? null : this.promotionObject.targetInputTypeId, disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }),
      targetInputSelectionId: new FormControl({ value: this.promotionObject.targetInputSelectionId === -1 ? null : this.promotionObject.targetInputSelectionId, disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }),
      targetOutputSelectionId: new FormControl({ value: this.promotionObject.targetOutputSelectionId === -1 ? null : this.promotionObject.targetOutputSelectionId, disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }),
      // will set these controls value after get promotion data in edit mode
      groupsList: new FormControl({ value: [], disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }),
      channelsList: new FormControl({ value: [], disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }),
      sdcsList: new FormControl({ value: [], disabled: this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle) }),
      inputs: new FormArray([], Validators.required),
      outputs: new FormArray([], Validators.required),
    });
  }
  showAppliedSharedTable =false
  showExcludeCustomersSharedTable = false
  showEntrySection(selectedIndex: number) {
    this.showAppliedSharedTable = false
    this.showExcludeCustomersSharedTable = false

    if (!this.isViewMode) {
      if (selectedIndex > 0) {
        if (this.promotionTypeControl.invalid || this.organizationControl.invalid) {
          this.promotionTypeControl.markAsTouched();
          this.organizationControl.markAsTouched();
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
          return;
        }
      }
      if (selectedIndex === 0) {
        if ((this.getInputsForms().length > 1) ||
          (this.getOutputsForms().length > 1) ||
          (this.promotionEntryForm.get('inputs').valid && this.promotionEntryForm.get('outputs').valid)) {
          this.promotionEntryForm.get('headerDataFrom').get('promotionType').disable({ onlySelf: true, emitEvent: false });
        } else {
          if (!this.isBundle && !(this.promotionObject.isStartedTargetPromotion && this.isEditMode)) {
            this.promotionEntryForm.get('headerDataFrom').get('promotionType').enable({ onlySelf: true, emitEvent: false });
          }
        }
      }
    }
    this.clearSelection();
    var elementSelectors
    if (selectedIndex == 0) {
      this.showDefinitionData = true;
      this.manageShowNoOfInvoicesControl();
       elementSelectors = ['#desc-def','#code-def',
      '#Promotion-Type-def','#Apply_In_Options','#Adate-def',
      '#vendor-def', '#Sequence-def', '#Sales_Modes','#Apply_All_Customers',
      '#InactivePromotion','#image','#attachment'
    ] // Target each column by its unique ID// Target each column by its unique ID
    this.startTour(elementSelectors,'MainData')

    } else if (selectedIndex == 1) {
      this.showDetailsData = true;
      elementSelectors = ['#FreeQuantity','#Prerequisites','#Benefits','#Add_Detail'
      ,'#Add_Option','#Add_Detail-benefit','#Add_Option-benefit'
    ] // Target each column by its unique ID
    this.startTour(elementSelectors,'Detail-promo')

    }
    else if (selectedIndex == 2) {
      this.showApplyToData = true;
      elementSelectors = ['#group-def'] // Target each column by its unique ID
      this.startTour(elementSelectors,'ApplyToData')
    }
    else if (selectedIndex == 3) {
      this.showExcludeCustomersData = true;
      this.showExcludeCustomersSharedTable= true


    }
    this.navLinks[selectedIndex].isActive = true;

}
  isMultiDetailsForm(index) {
    // this method used for ranges to select card height
    if (this.promotionTypeControl.value === PromotionTypes.RangeValues
      && this.getInputsForms().length >= index + 1 && this.getOutputsForms().length >= index + 1
      && (this.getInputFormDetails(this.getInputsForms()[index]).length > 1 || this.getOutputFormDetails(this.getOutputsForms()[index]).length > 1)) {
      return true;
    } else {
      return false
    }
  }
  manageShowNoOfInvoicesControl() {
    this.showNoOfInvoices = false;
    if (this.getInputsForms() && this.getInputsForms().length > 0) {
      for (var intputForm of this.getInputsForms()) {
        for (var detailInputForm of this.getInputFormDetails(intputForm)) {
          if (this.isNoSalesInCertainPeriodTypes(detailInputForm)) {
            this.showNoOfInvoices = true;
            break;
          }
        }
      }
      if (this.showNoOfInvoices) {
        this.noOfInvoicesControl.setValidators(Validators.required);
      } else {
        this.noOfInvoicesControl.setValidators(Validators.nullValidator);
        this.noOfInvoicesControl.reset();
      }
      this.noOfInvoicesControl.updateValueAndValidity();
      this.noOfInvoicesControl.markAllAsTouched();
    }
  }
  get noOfInvoicesControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('noOfInvoices');
  }
  get promotionTypeControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('promotionType');
  }
  get organizationsListControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('organizationsList');
  }
  get promotionLevelControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('promotionLevel');
  }
  get offerAppliedOptionsControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('offerAppliedOptions');
  }
  get fromToDateControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('fromToDate');
  }
  get isRelatedToTargetControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('isRelatedToTarget');
  }
  get appliedAfterPeriodControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('appliedAfterPeriod');
  }
  get allowOringControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('allowOring');
  }
  get maxLimitControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('maxLimit');
  }
  get isProductDiscountControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('isProductDiscount');
  }
  get resetLastInvRemControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('resetLastInvRem');
  }
  get targetModeControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('targetMode');
  }
  get seqenceControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('sequence');
  }
  get isRestrictUpperLimitControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('isRestrictUpperLimit');
  }
  get salesModesControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('salesModes');
  }
  onChangePromotionType(selectedType) {
    if (this.promotionType && this.promotionType == PromotionTypes.TargetPromotion) {
      this.fromToDateControl.setValue([]);
      this.fromToDate = [];
    }
    this.promotionType = selectedType ? selectedType.promotionType : null;
    if(this.restrictPromotionTypes && (this.promotionType == PromotionTypes.StepsValues || this.promotionType == PromotionTypes.RangeValues)){
      this.isRestrictPromotionType = true;
      this.promotionEntryForm.get('headerDataFrom').get('targetMode').reset();
    }else{
      this.isRestrictPromotionType = false;
      this.resetAllowOring();
      this.resetIsProductDiscount();
    }

    (<FormArray>this.promotionEntryForm.get('inputs')).clear();
    (<FormArray>this.promotionEntryForm.get('outputs')).clear();

    // Remove Validators from step form
    this.promotionEntryForm.get('stepEntryForm').reset();
    (<any>Object).values((this.promotionEntryForm.get('stepEntryForm') as FormGroup).controls).forEach(control => {
      control.setValidators(null);
      control.updateValueAndValidity();
      control.enable({ onlySelf: true, emitEvent: false });
    });

    // Remove Validators from autoRangesForm form
    this.onCloseAutoRangesFill();

    // Reset Related To Target flag
    this.promotionEntryForm.get('headerDataFrom').get('isRelatedToTarget').setValue(false);
    this.resetLastInvRemControl.setValue(true);
    this.resetRelatedToTargetData();
    this.fillTargetModes();
    // Re-fill input/output types according to selected promotion type
    this.fillInputDetailsTypesList();
    this.fillOutputDetailsTypesList();

    // Reset Repeat flag
    this.promotionEntryForm.get('headerDataFrom').get('isRepeated').setValue(false);
    this.onChangeRepeatFlag();

    // Set targetInputTypeId as non mandatory
    this.selectedTargetInputTypeId = null;
    this.selectedTargetInputSelectionId = null;
    this.selectedTargetOutputSelectionId = null;

    this.promotionEntryForm.get('targetInputTypeId').reset();
    this.promotionEntryForm.get('targetInputSelectionId').reset();
    this.promotionEntryForm.get('targetOutputSelectionId').reset();

    this.promotionEntryForm.get('targetInputTypeId').setValidators(Validators.nullValidator);
    this.promotionEntryForm.get('targetInputSelectionId').setValidators(Validators.nullValidator);
    this.promotionEntryForm.get('targetOutputSelectionId').setValidators(Validators.nullValidator);
    if (this.promotionType === PromotionTypes.FixedValues || this.promotionType == PromotionTypes.SurveyPromotion) {
      this.pushNewInputForm();
      this.pushNewOutputForm();
    } else if (this.promotionType === PromotionTypes.StepsValues) {
      if (this.isLoyaltyPoints()) {
        this.promotionEntryForm.get('stepEntryForm').get('outputDetailTypeId').setValue(PromotionOutputDetailTypes.CustomerPoints.valueOf());
      }
      (<any>Object).values((this.promotionEntryForm.get('stepEntryForm') as FormGroup).controls).forEach(control => {
        control.setValidators(Validators.required);
        control.updateValueAndValidity();
      });
      if (this.isSalesOrderInput(this.promotionEntryForm.get('stepEntryForm'))) {
        this.promotionEntryForm.get('stepEntryForm').get('inputSalesOrderTypeId').setValidators(Validators.required);
        this.promotionEntryForm.get('stepEntryForm').get('inputSalesOrderTypeId').updateValueAndValidity();
      } else {
        this.promotionEntryForm.get('stepEntryForm').get('inputSalesOrderTypeId').setValidators(Validators.nullValidator);
        this.promotionEntryForm.get('stepEntryForm').get('inputSalesOrderTypeId').updateValueAndValidity();
      }
      if (this.targetModeId != 1 && this.targetModeId !== 2 && this.targetModeId !== 3) {
        this.stepOutputSelectionControl.setValidators(Validators.nullValidator);
        this.stepOutputSelectionControl.updateValueAndValidity();
      }
    } else if (this.promotionType === PromotionTypes.RangeValues) {
      this.pushNewInputForm();
      this.pushNewOutputForm();
    }
    else if (this.promotionType === PromotionTypes.TargetPromotion || this.promotionType === PromotionTypes.DynamicTargetPromotion) {
      if (this.promotionType === PromotionTypes.TargetPromotion) {
        // Reset date
        this.fromToDateControl.setValue([]);
        this.fromToDate = [];
      }
      // remove all customers selection for target promotions
      this.promotionEntryForm.get('headerDataFrom').get('assignToAllCustomers').setValue(false);
      this.onAllCustomersChange();
      this.targetInputTypeControl.setValidators(Validators.required);
      this.pushNewTargetPromotion()
    }
  }
  clearSelection() {
    this.showDefinitionData = false;
    this.showDetailsData = false;
    this.showApplyToData = false;
    this.showExcludeCustomersData = false;
    this.navLinks.forEach(a => a.isActive = false);
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Definition',
        index: 0,
        isActive: false
      },
      {
        label: 'Desc_Details_Tap',
        index: 1,
        isActive: false
      },
      {
        label: 'Desc_Applied_To_Cap',
        index: 2,
        isActive: false
      },
      {
        label: 'Desc_Exclude_Customers',
        index: 3,
        isActive: false
      }
    ];
  }
  fillPromotionReasonList() {
    this.promotionService.getPromotionReasonList().subscribe(result => {
      this.promotionReasonList = result;
    });
  }
  fillOrganizations() {
    this.masterDataService.getOrganizationList().subscribe(result => {
      this.organizationsList = result;
    });
  }

  fillGroupsList(setCheckedValue: boolean = false) {
    var previousControlValue = [];
    if (setCheckedValue) { // to refresh data on multi-select drop down on UI.
      previousControlValue = this.groupsControl && this.groupsControl.value ? this.groupsControl.value : [];
    }
    this.allCustomerGroupsList = [];
    if (this.forceOrganizationFilterForCustomerGroups()) {
      if (this.organizationIdsString != null) {
        this.customerService.getAllCustomerGroups(this.organizationIdsString).subscribe(result => {
          this.allCustomerGroupsList = result.data;
          if (setCheckedValue) { // to refresh data on multi-select dropdown on UI.
            var temp = cloneDeep(this.allCustomerGroupsList);
            this.allCustomerGroupsList = [];
            this.allCustomerGroupsList = temp;
            this.groupsControl.setValue(previousControlValue.filter(group => this.allCustomerGroupsList.map(x => x.groupId).includes(group.groupId)));
          }
        });
      }
    } else {
      this.customerService.getAllCustomerGroups(this.organizationIdsString).subscribe(result => {
        this.allCustomerGroupsList = result.data;
      });
    }
  }
  fillChannelsSubChannelsList() {
    this.customerService.GetAllCustomerChannels(null).subscribe(result => {
      this.allChannelsList = result;
    });
  }
  fillSDCsList(setCheckedValue: boolean = false) {
    var previousControlValue = [];
    if (setCheckedValue) {
      previousControlValue = this.sdcsControl && this.sdcsControl.value ? this.sdcsControl.value : [];
    }
    this.allSDCsList = [];
    if (this.organizationIdsString != null) {
      var filter = {
        organizationIds: this.organizationIdsString
      }
      this.customerService.getAllSalesDistributionChannels(filter).subscribe(result => {
        this.allSDCsList = result && result.data ? result.data : [];

        if (setCheckedValue) {
          var temp = cloneDeep(this.allSDCsList);
          this.allSDCsList = [];
          this.allSDCsList = temp;
          this.sdcsControl.setValue(previousControlValue.filter(sdc => this.allSDCsList.map(s => s.sdcId).includes(sdc.sdcId)));
        }
      });
    }
  }
  fillAchievementTypesForTargetPromotions() {
    this.achievementTypesList = [];
    this.promotionService.getAchievementTypesForTargetPromotions().subscribe(result => {
      this.achievementTypesList = result;
    });
  }
  fillPromotionTypes() {
    this.promotionTypesList = [];
    if (this.isLoyaltyPromotion) {
      this.promotionTypesList.push(
        { 'promotionType': PromotionTypes.FixedValues, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Fixed_Promotion_Type) },
        { 'promotionType': PromotionTypes.RangeValues, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Ranges_Promotion_Type) },
      );
      if (this.promotionModeId == LoyaltyModes.PointsLoyaltyPromotion) {
        this.promotionTypesList.push(
          { 'promotionType': PromotionTypes.StepsValues, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Steps_Promotion_Type) },
        );
      }
    } else {
      this.promotionTypesList.push(
        { 'promotionType': PromotionTypes.FixedValues, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Fixed_Promotion_Type) },
        { 'promotionType': PromotionTypes.RangeValues, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Ranges_Promotion_Type) },
        { 'promotionType': PromotionTypes.StepsValues, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Steps_Promotion_Type) },
        { 'promotionType': PromotionTypes.TargetPromotion, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Monthly_Target_Promotion_Type) },
        { 'promotionType': PromotionTypes.DynamicTargetPromotion, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Dynamic_Target_Promotion_Type) },
        { 'promotionType': PromotionTypes.SurveyPromotion, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Survey_Promotion_Type) }
      );
    }
  }
  fillPromotionSequenceLevels() {
    this.promotionSequenceLevelsList = [];
    for (let i = 1; i <= this.promotionSequenceLevel; i++) {
      this.promotionSequenceLevelsList.push(
        { 'name': i.toString(), 'id': i }
      );
    }
  }
  fillSalesModeForNewPromotion() {
    if (!this.isEditMode && !this.isViewMode && (!this.promotionObject || this.promotionObject.promotionId === -1)) {
      this.salesModesControl.setValue(this.salesModesList);
    }
  }
  getSalesModesListFromString(salesModesString: string): any[] {
    if (salesModesString) {
      let salesModesIdList = [];
      salesModesString.split(',').forEach(str => {
        salesModesIdList.push(parseInt(str));
      });
      return this.salesModesList.filter(salesMode => salesModesIdList.includes(salesMode.salesModeId));
    } else {
      return [];
    }
  }
  fillSalesModes() {
    this.salesModesList = [
      {
        salesModeId: SalesModes.CashSales.valueOf(),
        salesModeDescription: this.translateService.instant('Desc_Cash')
      },
      {
        salesModeId: SalesModes.CreditSales.valueOf(),
        salesModeDescription: this.translateService.instant('Desc_Credit')
      }
    ];
  }
  fillPromotionObject() {
    var isNew = !this.isEditMode;
    if (isNew) {
      this.promotionId = -1;
      this.promotionObject.promotionId = -1;
    }
    this.promotionObject.isNew = isNew;
    this.promotionObject.isBundle = this.isBundle;
    this.promotionObject.promotionName = this.promotionEntryForm.get('headerDataFrom').get('promotionName').value;
    this.promotionObject.promotionCode = this.promotionEntryForm.get('headerDataFrom').get('promotionCode').value;
    this.promotionObject.bundleLimit = this.promotionEntryForm.get('headerDataFrom').get('bundleLimit').value ? +this.promotionEntryForm.get('headerDataFrom').get('bundleLimit').value : 0;
    this.promotionObject.promotionType = this.promotionType;
    this.promotionObject.promotionReasonId = this.promotionEntryForm.get('headerDataFrom').get('promotionReasonId').value ? this.promotionEntryForm.get('headerDataFrom').get('promotionReasonId').value : -1;
    this.promotionObject.sequence = this.promotionEntryForm.get('headerDataFrom').get('sequence').value ? this.promotionEntryForm.get('headerDataFrom').get('sequence').value : 1;
    this.promotionObject.inactive = this.promotionEntryForm.get('headerDataFrom').get('inactive').value ? this.promotionEntryForm.get('headerDataFrom').get('inactive').value : false;
    this.promotionObject.applyBundleView = this.promotionEntryForm.get('headerDataFrom').get('applyBundleView').value ? this.promotionEntryForm.get('headerDataFrom').get('applyBundleView').value : false;
    // this.promotionObject.showInCustomerApp = this.promotionEntryForm.get('headerDataFrom').get('showInCustomerApp').value ? this.promotionEntryForm.get('headerDataFrom').get('showInCustomerApp').value : false;
    this.promotionObject.isRepeated = this.promotionEntryForm.get('headerDataFrom').get('isRepeated').value ? this.promotionEntryForm.get('headerDataFrom').get('isRepeated').value : false;
    this.promotionObject.originalRepeatCount = this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').value ? +this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').value : 0;
    this.promotionObject.minValue = this.promotionEntryForm.get('headerDataFrom').get('minValue').value ? +this.promotionEntryForm.get('headerDataFrom').get('minValue').value : 0;
    this.promotionObject.deletedFiles = this.deletedFiles;
    this.promotionObject.loyalityWidth = this.promotionEntryForm.get('headerDataFrom').get('loyaltyWidth').value == null ? -1 : this.promotionEntryForm.get('headerDataFrom').get('loyaltyWidth').value;
    this.promotionObject.isLoyaltyPromotion = this.isLoyaltyPromotion;
    this.promotionObject.promotionModeId = this.promotionModeId;

    this.promotionObject.relatedToTarget = this.promotionEntryForm.get('headerDataFrom').get('isRelatedToTarget').value ? this.promotionEntryForm.get('headerDataFrom').get('isRelatedToTarget').value : false;
    this.promotionObject.resetLastInvRem = this.resetLastInvRemControl ? this.resetLastInvRemControl.value : true;
    this.promotionObject.targetMode = this.promotionEntryForm.get('headerDataFrom').get('targetMode').value ? this.promotionEntryForm.get('headerDataFrom').get('targetMode').value : -1;
    this.promotionObject.appliedAfterPeriod = this.appliedAfterPeriodControl.value ? this.appliedAfterPeriodControl.value : false;
    this.promotionObject.allowOring = this.allowOringControl.value ? this.allowOringControl.value : false;
    this.promotionObject.maxLimit = this.maxLimitControl.value ? +this.maxLimitControl.value : 0;
    this.promotionObject.isProductDiscount = this.isProductDiscountControl.value ? this.isProductDiscountControl.value : false;
    this.promotionObject.isRestrictUpperLimit = this.isRestrictUpperLimitControl.value ? this.isRestrictUpperLimitControl.value : false;
    this.promotionObject.targetInputTypeId = this.promotionEntryForm.get('targetInputTypeId').value ? this.promotionEntryForm.get('targetInputTypeId').value : -1;
    this.promotionObject.targetInputSelectionId = this.promotionEntryForm.get('targetInputSelectionId').value ? this.promotionEntryForm.get('targetInputSelectionId').value : -1;
    this.promotionObject.targetOutputSelectionId = this.promotionEntryForm.get('targetOutputSelectionId').value ? this.promotionEntryForm.get('targetOutputSelectionId').value : -1;
    this.promotionObject.salesMode = this.salesModesControl.value ? this.salesModesControl.value.map(salesMode => salesMode.salesModeId).join(',') : "";
    if (this.promotionObject.promotionType == PromotionTypes.FixedValues || (this.promotionObject.promotionType == PromotionTypes.RangeValues && !this.isRelatedToTarget) || (this.promotionObject.promotionType == PromotionTypes.StepsValues && !this.isRelatedToTarget)) {
      this.promotionObject.promotionLevel = PromotionLevel.OutletLevel;
    } else {
      this.promotionObject.promotionLevel = this.promotionEntryForm.get('headerDataFrom').get('promotionLevel').value;
    }
    this.promotionObject.noOfInvoices = this.noOfInvoicesControl.value ? +this.noOfInvoicesControl.value : 0;

    this.promotionObject.organizationsList = [];
    this.promotionObject.organizationId = -1;
    if (this.promotionEntryForm.get('headerDataFrom').get('organizationsList').value) {
      this.promotionObject.organizationsList = this.promotionEntryForm.get('headerDataFrom').get('organizationsList').value;
      if (this.promotionEntryForm.get('headerDataFrom').get('organizationsList').value.length === 1 && (!this.promotionObject.hiddenOrganizations || this.promotionObject.hiddenOrganizations.length === 0)) {
        this.promotionObject.organizationId = this.promotionEntryForm.get('headerDataFrom').get('organizationsList').value[0].organizationId;
      }
    }

    if (this.fromToDate && this.fromToDate.length == 2) {
      this.promotionObject.startDateModel = this.fromToDate[0];
      this.promotionObject.endDateModel = this.fromToDate[1];
    }
    this.promotionObject.excludedCustomersList = this.excludedCustomersList ? this.excludedCustomersList : [];
    this.promotionObject.assignToAllCustomers = this.promotionEntryForm.get('headerDataFrom').get('assignToAllCustomers').value ? this.promotionEntryForm.get('headerDataFrom').get('assignToAllCustomers').value : false;
    if (this.promotionObject.assignToAllCustomers) {
      this.promotionObject.customersList = [];
      this.promotionObject.channelsList = [];
      this.promotionObject.groupsList = [];
      this.promotionObject.sdcsList = [];
    } else {
      this.promotionObject.customersList = this.addedCustomersList ? this.addedCustomersList : [];
      this.promotionObject.channelsList = this.promotionEntryForm.get('channelsList').value ? this.promotionEntryForm.get('channelsList').value : [];
      this.promotionObject.groupsList = this.promotionEntryForm.get('groupsList').value ? this.promotionEntryForm.get('groupsList').value : [];
      this.promotionObject.sdcsList = this.promotionEntryForm.get('sdcsList').value ? this.promotionEntryForm.get('sdcsList').value : [];
    }

    this.promotionObject.promotionInputs = this.preparePromotionInputsListToSave();
    this.promotionObject.promotionOutputs = this.preparePromotionOutputsListToSave();

    this.promotionObject.achievementId = this.promotionAchievementId;
    this.promotionObject.achievementTypeId = this.promotionAchievementTypeId;

    if (this.isBundle) {
      this.promotionObject.offerAppliedOptions = OfferAppliedOptions.Sonic.valueOf() + '';
    } else {
      // Save offerAppliedOptions as comma separated string
      this.promotionObject.offerAppliedOptions = '';
      this.promotionObject.showInCustomerApp = false;
      if (this.offerAppliedOptionsControl.value && this.offerAppliedOptionsControl.value.length > 0) {
        var optionIdsList = this.offerAppliedOptionsControl.value.map(({ optionId }) => optionId);
        if (optionIdsList && optionIdsList.length > 0) {
          var optionString = optionIdsList.join(',');
          this.promotionObject.offerAppliedOptions = optionString;
          if (this.promotionObject.offerAppliedOptions.includes(OfferAppliedOptions.CustomerApp.valueOf().toString())) {
            this.promotionObject.showInCustomerApp = true;
          }
        }
      }
    }
    let descriptions = this.otherPromotionLanguages;
    let oldValue = descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId);
    if (oldValue >= 0) descriptions.splice(oldValue, 1);
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.promotionEntryForm.get('headerDataFrom').get('promotionName').value
      });
    }
    this.promotionObject.descriptionLanguages = descriptions;
    if (this.promotionType == PromotionTypes.SurveyPromotion && this.getInputsForms().length > 0) {
      this.promotionObject.surveyId = this.getInputFormDetails(this.getInputsForms()[0])[0].get('inputSelectedValueId').value;
    }
  }
  onAllCustomersChange() {
    var assignToAllCustomers = this.promotionEntryForm.get('headerDataFrom').get('assignToAllCustomers').value;
    if (assignToAllCustomers) {
      this.addedCustomersList = [];
      this.fillCustomersList();
      this.promotionEntryForm.get('groupsList').setValue([]);
      this.promotionEntryForm.get('channelsList').setValue([]);
      this.navLinks[2].disable = true;
    }
    else {
      this.navLinks[2].disable = false;
    }
  }
  onOtherLanguagesTextSubmitted(event) {
    this.otherPromotionLanguages = event;
  }
  onChangePromotionDate(date: any[]) {
    if (date)
      this.fromToDate = date;
  }
  onChangeRepeatFlag() {
    this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').reset();
    this.promotionEntryForm.get('headerDataFrom').get('minValue').reset();

    if (this.promotionEntryForm.get('headerDataFrom').get('isRepeated').value) {
      this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').setValidators([Validators.required, Validators.min(1)]);
      this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').updateValueAndValidity();

      this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').enable({ onlySelf: true, emitEvent: false });
      this.promotionEntryForm.get('headerDataFrom').get('minValue').enable({ onlySelf: true, emitEvent: false });
      this.promotionEntryForm.get('headerDataFrom').get('minValue').setValue(0);
    } else {
      this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').setValidators(Validators.nullValidator);
      this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').disable({ onlySelf: true, emitEvent: false });
      this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').updateValueAndValidity();

      this.promotionEntryForm.get('headerDataFrom').get('minValue').disable({ onlySelf: true, emitEvent: false });
      this.promotionEntryForm.get('headerDataFrom').get('originalRepeatCount').updateValueAndValidity();
    }
  }
  resetRelatedToTargetData() {
    this.promotionEntryForm.get('headerDataFrom').get('targetMode').reset();
    this.resetMaxLimit();
    this.resetRestrictUpperLimit();
    this.resetIsProductDiscount();
    this.resetAllowOring();
    this.ShowEnableSelection = this.promotionEntryForm.get('headerDataFrom').get('isRelatedToTarget').value;
    if (this.promotionEntryForm.get('headerDataFrom').get('isRelatedToTarget').value) {
      this.isRelatedToTarget = true;
      this.promotionEntryForm.get('headerDataFrom').get('targetMode').setValidators(Validators.required);
      this.promotionEntryForm.get('headerDataFrom').get('targetMode').enable({ onlySelf: true, emitEvent: false });
      this.promotionEntryForm.get('headerDataFrom').get('targetMode').updateValueAndValidity();
      this.promotionEntryForm.get('headerDataFrom').get('targetMode').setValue(1);
      this.onChangeTargetMode(this.targetModesList[0]);
      this.isRestrictPromotionType = false;
    } else {
      this.isRelatedToTarget = false;
      this.targetModeId = -1;
      this.promotionEntryForm.get('headerDataFrom').get('targetMode').setValidators(Validators.nullValidator);
      this.promotionEntryForm.get('headerDataFrom').get('targetMode').disable({ onlySelf: true, emitEvent: false });
      this.promotionEntryForm.get('headerDataFrom').get('targetMode').updateValueAndValidity();
      if(this.restrictPromotionTypes && (this.promotionType == PromotionTypes.StepsValues || this.promotionType == PromotionTypes.RangeValues)){
        this.isRestrictPromotionType = true;
      }
    }
    this.fillInputDetailsTypesList();
  }

  onChangeRelatedToTargetFlag() {
    this.resetRelatedToTargetData();
    if (this.promotionType == PromotionTypes.RangeValues) {
      this.clearAllRanges();
      if (this.isRelatedToTarget) this.showRestrictUpperLimit = true;
    }
    else if (this.promotionType == PromotionTypes.StepsValues)
      this.clearStepDefinition();
    this.fillOutputDetailsTypesList();
  }
  onChangeResetLastInvRemFlag() {
    if (!this.resetLastInvRemControl.value) {
      this.onChangeResetLastInvRem();
    }
    else {
      this.resetLastInvRem = true;
      this.fillOutputDetailsTypesList();
    }
  }
  onChangeTargetMode(targetMode) {
    var selectedValue = targetMode ? targetMode.modeId : null;
    this.promotionEntryForm.get('headerDataFrom').get('targetMode').setValue(this.targetModeId);

    if ((this.promotionType == 2 && this.getInputsForms().length > 1) || (this.promotionType == 3 && this.getInputsForms().length >= 1)) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.targetModeId = selectedValue;
            this.targetModeControl.setValue(selectedValue);
            this.targetModeControl.updateValueAndValidity();
            this.resetAppliedAfterPeriod();
            this.resetAllowOring();
            if (this.promotionType == PromotionTypes.RangeValues)
              this.clearAllRanges();
            else if (this.promotionType == PromotionTypes.StepsValues) {
              if (this.targetModeId != 1 && this.targetModeId !== 2 && this.targetModeId !== 3) {
                this.stepOutputSelectionControl.setValidators(Validators.nullValidator);
                this.stepOutputSelectionControl.updateValueAndValidity();
              }
              this.clearStepDefinition();
            }
          }
        });
    }
    else {
      this.targetModeId = targetMode.modeId;
      this.targetModeControl.setValue(selectedValue);
      this.resetAppliedAfterPeriod();
        this.resetAllowOring();
      if (this.promotionType == PromotionTypes.RangeValues)
        this.clearAllRanges();
      else if (this.promotionType == PromotionTypes.StepsValues) {
        if (this.targetModeId != 1 && this.targetModeId !== 2 && this.targetModeId !== 3) {
          this.stepOutputSelectionControl.setValidators(Validators.nullValidator);
          this.stepOutputSelectionControl.updateValueAndValidity();
        }
        this.clearStepDefinition();
      }
    }
  }
  onChangeResetLastInvRem() {
    var selectedValue = this.resetLastInvRemControl.value;
    this.resetLastInvRemControl.setValue(this.resetLastInvRem);
    if (this.promotionType == 3 && this.getInputsForms().length >= 1) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
        (res: DialogResult) => {
          if (res == DialogResult.Yes) {
            this.resetLastInvRem = selectedValue;
            this.resetLastInvRemControl.setValue(selectedValue);
            this.resetLastInvRemControl.updateValueAndValidity();
            this.clearStepDefinition();
            this.fillOutputDetailsTypesList();
          }
        });
    }
    else {
      this.resetLastInvRem = selectedValue;
      this.resetLastInvRemControl.setValue(selectedValue);
      this.fillOutputDetailsTypesList();
    }
  }
  resetAppliedAfterPeriod() {
    this.appliedAfterPeriodControl.setValue(false);
  }
  resetAllowOring() {
    this.allowOringControl.setValue(false);
  }
  resetMaxLimit() {
    this.maxLimitControl.reset();
  }
  resetIsProductDiscount() {
    this.isProductDiscountControl.setValue(false);
    this.fillOutputDetailsTypesList();
  }
  resetRestrictUpperLimit() {
    this.showRestrictUpperLimit = false;
    this.isRestrictUpperLimitControl.setValue(false);
  }
  onChangeIsRestrictUpperLimit() {
    this.isRestrictUpperLimitControl.markAsTouched();
    // this.previousUpperLimitValue = this.isRestrictUpperLimitControl.value;
    if (this.promotionTypeControl.value === PromotionTypes.RangeValues && this.isRelatedToTarget) {
      if (this.getOutputsForms().length > 0 && this.getOutputDetailTypeControl(this.getOutputFormDetails(this.getOutputsForms()[0])[0]).value) {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              // this.isProductDiscountControl.setValue(newValue);
              this.changeIsRestrictUpperLimit();
            } else {
              this.isRestrictUpperLimitControl.setValue(!this.isRestrictUpperLimitControl.value);
            }
          });
      } else {
        this.changeIsRestrictUpperLimit();
      }
    }
  }
  changeIsRestrictUpperLimit() {
    this.fillOutputDetailsTypesList();
    this.fillInputDetailsTypesList();
    if (this.promotionTypeControl.value === PromotionTypes.RangeValues) {
      this.clearAllRanges();
    }
  }
  onChangeIsProductDiscount() {
    // if any output defined then ask user to confirm clear data
    if ((this.promotionTypeControl.value === PromotionTypes.StepsValues && this.stepOutputTypeControl.value)
      || (this.getOutputsForms().length > 0 && this.getOutputDetailTypeControl(this.getOutputFormDetails(this.getOutputsForms()[0])[0]).value)) {
      var newValue = this.isProductDiscountControl.value;
      this.isProductDiscountControl.setValue(!newValue);
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.isProductDiscountControl.setValue(newValue);
            this.changeIsProducDiscount();
          }
        });
    } else {
      this.changeIsProducDiscount();
    }
  }
  changeIsProducDiscount() {
    this.fillOutputDetailsTypesList();
    this.fillInputDetailsTypesList();
    if (this.promotionTypeControl.value === PromotionTypes.StepsValues) {
      this.clearStepDefinition();
    } else if (this.promotionTypeControl.value === PromotionTypes.RangeValues) {
      this.clearAllRanges();
    }
    if (this.isRestrictPromotionType && !this.isRelatedToTarget) {
      this.ShowEnableSelection = this.isProductDiscountControl.value;
      this.resetAllowOring();
    }
  }
  onChangePromotionLevel() {
    var currentSelectedValue = this.promotionLevelControl.value;
    this.promotionLevelControl.setValue(this.promotionLevel);

    if ((this.addedCustomersList && this.addedCustomersList.length > 0) ||
      (this.excludedCustomersList && this.excludedCustomersList.length > 0) ||
      (this.groupsControl.value && this.groupsControl.value.length > 0) ||
      (this.channelsControl.value && this.channelsControl.value.length > 0)) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.MsgChangePromotionLevelRemoveApplyData)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.groupsControl.setValue([]);
            this.channelsControl.setValue([]);
            this.addedCustomersList = [];
            this.fillCustomersList();
            this.excludedCustomersList = [];
            this.fillExcludedCustomersList();
            this.promotionLevelControl.setValue(currentSelectedValue);
            this.promotionLevel = currentSelectedValue;
            this.changeCustomerUIColumns();
            this.reflectPromotionLevelOnImportType(this.promotionLevel);
          }
        });
    } else {
      this.promotionLevelControl.setValue(currentSelectedValue);
      this.promotionLevel = currentSelectedValue;
      this.changeCustomerUIColumns();
      this.reflectPromotionLevelOnImportType(this.promotionLevel);
    }
  }
  reflectPromotionLevelOnImportType(promotionLevel: number) {
    if (promotionLevel === PromotionLevel.CustomerLevel.valueOf()) {
      this.appliedTodataType = ImportDataTypes.CustomerPromotion;
      this.excludeCustomerdataType = ImportDataTypes.ExcludeCustomerPromotion;
    } else {
      this.appliedTodataType = ImportDataTypes.CustomerOutletPromotion;
      this.excludeCustomerdataType = ImportDataTypes.ExcludeCustomerOutletPromotion;
    }
  }
  changeCustomerUIColumns() {
    if (this.promotionLevel === PromotionLevel.CustomerLevel) {
      this.customersSharedTabel.columns = [
        { title: 'Desc_Customer_Code', key: 'customerCode', isSortable: true, width: '50%' },
        { title: 'Desc_Customer_Name', key: 'customerName', isSortable: true, width: '50%' }
      ];
      this.excludeCustomersSharedTabel.columns = [
        { title: 'Desc_Customer_Code', key: 'customerCode', isSortable: true, width: '50%' },
        { title: 'Desc_Customer_Name', key: 'customerName', isSortable: true, width: '50%' }
      ];
    } else {
      this.customersSharedTabel.columns = [
        { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
        { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' }
      ];
      this.excludeCustomersSharedTabel.columns = [
        { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
        { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' }
      ];
    }
  }
  onChangeBundleLimitFlag() {
    this.promotionEntryForm.get('headerDataFrom').get('bundleLimit').reset();
    if (this.promotionEntryForm.get('headerDataFrom').get('checkBundleLimit').value) {
      this.promotionEntryForm.get('headerDataFrom').get('bundleLimit').setValidators([Validators.required, Validators.min(1)]);
      this.promotionEntryForm.get('headerDataFrom').get('bundleLimit').enable({ onlySelf: true, emitEvent: false });
    } else {
      this.promotionEntryForm.get('headerDataFrom').get('bundleLimit').setValidators(Validators.nullValidator);
      this.promotionEntryForm.get('headerDataFrom').get('bundleLimit').disable({ onlySelf: true, emitEvent: false });
    }
    this.promotionEntryForm.get('headerDataFrom').get('bundleLimit').updateValueAndValidity();
  }
  get groupsControl() {
    return this.promotionEntryForm.get('groupsList');
  }
  get channelsControl() {
    return this.promotionEntryForm.get('channelsList');
  }
  get sdcsControl() {
    return this.promotionEntryForm.get('sdcsList');
  }
  get organizationControl() {
    return this.promotionEntryForm.get('headerDataFrom').get('organizationsList');
  }
  get targetInputTypeControl() {
    return this.promotionEntryForm.get('targetInputTypeId');
  }
  get targetInputSelectionControl() {
    return this.promotionEntryForm.get('targetInputSelectionId');
  }
  get targetOutputSelectionControl() {
    return this.promotionEntryForm.get('targetOutputSelectionId');
  }
  onChangeOrganizationSelection(isSelect: boolean, isDeSelect: boolean, isSelectAll: boolean, isDeSelectAll: boolean, event: any) {

    let removeSelection = isDeSelect || isDeSelectAll || (isSelect && this.organizationDropdownSettings.singleSelection);
    if (removeSelection && (this.ForceCustomerOrganizationSelection || this.forceOrganizationFilterForCustomerGroups()) &&
      ((this.addedCustomersList && this.addedCustomersList.length > 0) ||
        (this.excludedCustomersList && this.excludedCustomersList.length > 0) ||
        (this.groupsControl.value && this.groupsControl.value.length > 0) ||
        (this.channelsControl.value && this.channelsControl.value.length > 0))
    ) {
      if (isDeSelectAll || isSelect || (isDeSelect && this.organizationDropdownSettings.singleSelection)) {
        this.clearAllAppliedToData();
      } else {
        // isDeSelect with !singleSelection [there may be other orgs selected] -> remove data for cleared org(s) only.
        this.clearAppliedToOrganizationRelatedData();
      }
    }

    if (this.ForceOrganizationFilterForPackGroups) {
      var clearAllPackGroupOrgData = isDeSelectAll || ((isSelect || isDeSelect) && this.organizationDropdownSettings.singleSelection);
      var clearSpecificOrgData = isDeSelect && !this.organizationDropdownSettings.singleSelection;

      this.allPackGroupsList = [];
      let organizations = isSelectAll ? event : isDeSelectAll ? -1 : event;
      this.getSelectedOrganizationIdsAsString(organizations);
      this.populateAllPackGroupsList(clearSpecificOrgData);

      var isAnyPackGroupInputDefined = false;
      var isAnyPackGroupOutputDefined = false;

      for (var intputForm of this.getInputsForms()) {
        for (var detailInputForm of this.getInputFormDetails(intputForm)) {
          if (this.isPackGroupInput(detailInputForm)) {
            isAnyPackGroupInputDefined = true;
            break;
          }
        }
      }
      for (var outputForm of this.getOutputsForms()) {
        for (var detailOutputForm of this.getOutputFormDetails(outputForm)) {
          if (this.isPackGroupOutput(detailOutputForm)) {
            isAnyPackGroupOutputDefined = true;
            break;
          }
        }
      }
      if (isAnyPackGroupInputDefined || isAnyPackGroupOutputDefined) {
        if (clearAllPackGroupOrgData) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgClearInsertedDetailsWarning));
          this.clearAllInputsAndOutputs();
        }
      }
    }

    if (this.forceOrganizationFilterForCustomerGroups()) {

      let organizations = isSelectAll ? event : isDeSelectAll ? -1 : event;
      this.getSelectedOrganizationIdsAsString(organizations);
      this.fillGroupsList(true);
    }
    if (this.enableSalesDistributionChannel) {
      let organizations = isSelectAll ? event : isDeSelectAll ? -1 : event;
      this.getSelectedOrganizationIdsAsString(organizations);
      this.fillSDCsList(true);
    }
  }

  clearAllAppliedToData() {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgChangeOrganizationRemoveApplyData));
    this.groupsControl.setValue([]);
    this.channelsControl.setValue([]);
    this.sdcsControl.setValue([]);
    this.addedCustomersList = [];
    this.fillCustomersList();
    this.excludedCustomersList = [];
    this.fillExcludedCustomersList();
  }

  clearAppliedToOrganizationRelatedData() { // delete customer data for certain organization(s).
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgChangeOrganizationRemoveApplyDataForOrg));
    var allAddedCustomers = [];
    var allExcludedCustomers = [];
    var selectedOrganizationIds: any[] = this.organizationControl && this.organizationControl.value ? this.organizationControl.value.map(org => org.organizationId) : [];
    selectedOrganizationIds.forEach(organizationId => {
      // 1 - for applied to customers:
      var appliedToCustomers = this.addedCustomersList.filter(customer =>
        customer.organizationIdsList.includes(organizationId) // customer included in selected organizations.
        && allAddedCustomers.findIndex(addedCust => addedCust.customerId === customer.customerId && addedCust.outletId === customer.outletId) === -1 // customer not already added to [applied to] customers
      );
      allAddedCustomers = allAddedCustomers.concat(appliedToCustomers);

      // 2 - for excluded customers:
      var promoExclusionCustomers = this.excludedCustomersList.filter(cust =>
        cust.organizationIdsList.includes(organizationId) // customer included in selected organizations.
        && allExcludedCustomers.findIndex(excCus => excCus.customerId == cust.customerId && excCus.outletId === cust.outletId) === -1 // customer not already added to [excluded] customers
      );
      allExcludedCustomers = allExcludedCustomers.concat(promoExclusionCustomers);
    });

    this.addedCustomersList = allAddedCustomers;
    this.fillCustomersList();
    this.excludedCustomersList = allExcludedCustomers;
    this.fillExcludedCustomersList();
  }

  clearInputAndOutputDetailPackGroupOrgData(availablePackGroupIds: number[]) {
    if (this.promotionType == PromotionTypes.DynamicTargetPromotion) {
      // check if selected target input / output packgroups are still available [within selected organization access]
      this.selectedTargetOutputSelectionId = availablePackGroupIds.includes(this.selectedTargetOutputSelectionId) ? this.selectedTargetOutputSelectionId : null;
      this.selectedTargetInputSelectionId = availablePackGroupIds.includes(this.selectedTargetInputSelectionId) ? this.selectedTargetInputSelectionId : null;
      this.promotionEntryForm.get('targetOutputSelectionId').setValue(this.selectedTargetOutputSelectionId);
      this.promotionEntryForm.get('targetInputSelectionId').setValue(this.selectedTargetInputSelectionId);
    }
    var clearAllData = (
      this.promotionType === PromotionTypes.DynamicTargetPromotion ||
      this.promotionType === PromotionTypes.StepsValues ||
      (this.promotionType === PromotionTypes.RangeValues && (this.isRelatedToTarget || this.isRestrictPromotionType))
    );
    var isThereAnyAffectedInputDetail = false;
    var isThereAnyAffectedOutputDetail = false;

    var showMessage: boolean = false;
    for (var intputForm of this.getInputsForms()) {
      for (var detailInputForm of this.getInputFormDetails(intputForm).filter(inputDetail => this.isPackGroupInput(inputDetail))) {
        if (!availablePackGroupIds.includes(this.getInputDetailSelectionIdControl(detailInputForm).value)) {
          if (!clearAllData) {
            this.getInputDetailSelectionIdControl(detailInputForm).setValue(null);
            showMessage = true;
          } else {
            isThereAnyAffectedInputDetail = true;
            break;
          }
        }
      }
      if (isThereAnyAffectedInputDetail) break;
    }
    for (var outputForm of this.getOutputsForms()) {
      for (var detailOutputForm of this.getOutputFormDetails(outputForm).filter(outputDetail => this.isPackGroupOutput(outputDetail))) {
        if (!availablePackGroupIds.includes(this.getOutputDetailSelectionIdControl(detailOutputForm).value)) {
          if (!clearAllData || (!isThereAnyAffectedInputDetail && this.promotionType == PromotionTypes.StepsValues && (!this.isRelatedToTarget || this.targetModeControl.value === 2))) {
            this.getOutputDetailSelectionIdControl(detailOutputForm).setValue(null);
            showMessage = true;
          } else {
            isThereAnyAffectedOutputDetail = true;
            break;
          }
        }
      }
      if (isThereAnyAffectedOutputDetail) break;
    }
    if (isThereAnyAffectedOutputDetail || isThereAnyAffectedInputDetail) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgClearInsertedDetailsWarning));
      this.clearAllInputsAndOutputs();
    } else if (showMessage) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgClearInsertedDetailsWarningForOrg));
    }
  }

  // onChangeOrganizationSelection(removeSelection, isSelectAll: boolean, isDeSelectAll: boolean, event: any) {

  //   if (removeSelection && (this.ForceCustomerOrganizationSelection || this.forceOrganizationFilterForCustomerGroups()) &&
  //     ((this.addedCustomersList && this.addedCustomersList.length > 0) ||
  //       (this.excludedCustomersList && this.excludedCustomersList.length > 0) ||
  //       (this.groupsControl.value && this.groupsControl.value.length > 0) ||
  //       (this.channelsControl.value && this.channelsControl.value.length > 0))) {

  //     this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgChangeOrganizationRemoveApplyData));
  //     this.groupsControl.setValue([]);
  //     this.channelsControl.setValue([]);
  //     this.addedCustomersList = [];
  //     this.fillCustomersList();
  //     this.excludedCustomersList = [];
  //     this.fillExcludedCustomersList();
  //   }

  //   if (this.ForceOrganizationFilterForPackGroups) {
  //     this.getSelectedOrganizationIdsAsString(null);
  //     this.allPackGroupsList = [];
  //     this.populateAllPackGroupsList();

  //     var isAnyPackGroupInputDefined = false;
  //     var isAnyPackGroupOutputDefined = false;

  //     for (var intputForm of this.getInputsForms()) {
  //       for (var detailInputForm of this.getInputFormDetails(intputForm)) {
  //         if (this.isPackGroupInput(detailInputForm)) {
  //           isAnyPackGroupInputDefined = true;
  //           break;
  //         }
  //       }
  //     }
  //     for (var outputForm of this.getOutputsForms()) {
  //       for (var detailOutputForm of this.getOutputFormDetails(outputForm)) {
  //         if (this.isPackGroupOutput(detailOutputForm)) {
  //           isAnyPackGroupOutputDefined = true;
  //           break;
  //         }
  //       }
  //     }
  //     if (isAnyPackGroupInputDefined || isAnyPackGroupOutputDefined) {
  //       this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgClearInsertedDetailsWarning));
  //       this.clearAllInputsAndOutputs();
  //     }
  //   }

  //   if (this.forceOrganizationFilterForCustomerGroups()) {

  //     let organizations = isSelectAll ? event : isDeSelectAll ? -1 : event;
  //     this.getSelectedOrganizationIdsAsString(organizations);
  //     this.fillGroupsList();
  //   }
  // }
  onSelectDeSelectAllOfferAppliedOnOptions() {
    // check if one of the defined outputs need user selection then clear all details, if user apply this promotion to only customer app
    this.applyOnCustomerAppOnly = false;
    // Re-fill output types according to selected applied option
    this.fillOutputDetailsTypesList();
  }
  onChangeOfferAppliedOnOptions() {
    // check if one of the defined outputs need user selection then clear all details, if user apply this promotion to only customer app
    this.applyOnCustomerAppOnly = false;
    var isAnySelectionBenefitDefined = false;
    var options = this.offerAppliedOptionsControl.value;
    if (options && options.length === 1 && options[0].optionId === OfferAppliedOptions.CustomerApp.valueOf()) {
      this.applyOnCustomerAppOnly = true;
    }
    if (this.applyOnCustomerAppOnly) {
      for (var outputForm of this.getOutputsForms()) {
        for (var detailForm of this.getOutputFormDetails(outputForm)) {
          if (this.isOutputNeedsUserSelection(detailForm)) {
            isAnySelectionBenefitDefined = true;
            break;
          }
        }
      }
      if (isAnySelectionBenefitDefined && this.applyOnCustomerAppOnly) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgClearInsertedDetailsWarning));
        this.clearAllInputsAndOutputs();
      }
    }
    // Re-fill output types according to selected applied option
    this.fillOutputDetailsTypesList();
  }
  clearAllInputsAndOutputs() {
    if (this.promotionType === PromotionTypes.FixedValues || this.promotionType == PromotionTypes.SurveyPromotion) {
      this.clearFixedPromotionDetails()
    } else if (this.promotionType === PromotionTypes.StepsValues) {
      this.clearStepDefinition();
    } else if (this.promotionType === PromotionTypes.RangeValues) {
      this.clearAllRanges();
    } else if (this.promotionType === PromotionTypes.TargetPromotion || this.promotionType === PromotionTypes.DynamicTargetPromotion) {
      this.clearTargetPromotionDetails();
    }
  }
  clearFixedPromotionDetails() {
    (<FormArray>this.promotionEntryForm.get('inputs')).clear();
    (<FormArray>this.promotionEntryForm.get('outputs')).clear();
    this.pushNewInputForm();
    this.pushNewOutputForm();
  }
  getSelectedOrganizationIdsAsString(organizationIds: any) {
    let organizationsList = organizationIds != null ? organizationIds :  this.coreSession.CurrentOperator.organizationId;
    this.organizationIdsString = null;
    if(organizationsList && !organizationsList.length){
      this.organizationIdsString=organizationsList.toString()
    }
    if (organizationsList && organizationsList.length > 0) {
      this.organizationIdsString = organizationsList.map(({ organizationId }) => organizationId).join(',');
    }
  }
  onAddEditPromotion() {
    this.isValidToSave = true;
    this.manageShowNoOfInvoicesControl();
    this.coreSession.markFormGroupTouched(this.promotionEntryForm);
    if (this.promotionEntryForm.invalid) {
      if (this.promotionEntryForm.get('headerDataFrom').invalid) {
        this.isValidToSave = false;
        this.showEntrySection(0);
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      } else if (this.getInputsForms().length === 0 || this.getOutputsForms().length === 0) {
        this.isValidToSave = false;
        this.showEntrySection(1);
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillPromotionDetails));
        return;
      }
      else if (this.promotionEntryForm.get('inputs').invalid || this.promotionEntryForm.get('outputs').invalid) {
        this.isValidToSave = false;
        this.showEntrySection(1);
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillPromotionDetailsCorrectly));
        return;
      }
    }

    // Validate Step Promotion values
    // If it's not the first step then must validate current step value to not exceed prevoius step value for input and outputs
    // Each step have excactly one detail
    if (this.promotionTypeControl.value === PromotionTypes.StepsValues) {
      var previousTypeId = -1;
      var currentTypeId = -1;
      var prevoiusValue = 0;
      var currentValue = 0;
      var inputIndex = 2; // starting from second step
      // Inputs
      if (this.getInputsForms().length > 1) {
        for (let index = 1; index < this.getInputsForms().length; index++) {
          currentValue = +this.getInputFormDetails(this.getInputsForms()[index])[0].get('inputValue').value;
          prevoiusValue = +this.getInputFormDetails(this.getInputsForms()[index - 1])[0].get('inputValue').value;
          currentTypeId = +this.getInputFormDetails(this.getInputsForms()[index])[0].get('inputSelectedValueId').value;
          previousTypeId = +this.getInputFormDetails(this.getInputsForms()[index - 1])[0].get('inputSelectedValueId').value;
          if (currentValue >= prevoiusValue && currentTypeId == previousTypeId) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.captionStep) + ' (' + inputIndex + ') : ' + this.translateService.instant(ConstantMessages.MsgStepPromotionValueValidation));
            this.isValidToSave = false;
            return;
          }
          inputIndex += 1;
        }
      }
      // Outputs
      var outputIndex = 2; // starting from second step
      if (this.getOutputsForms().length > 1) {
        for (let index = 1; index < this.getOutputsForms().length; index++) {
          currentValue = +this.getOutputFormDetails(this.getOutputsForms()[index])[0].get('outputValue').value;
          prevoiusValue = +this.getOutputFormDetails(this.getOutputsForms()[index - 1])[0].get('outputValue').value;
          currentTypeId = +this.getOutputFormDetails(this.getOutputsForms()[index])[0].get('outputSelectedValueId').value;
          previousTypeId = +this.getOutputFormDetails(this.getOutputsForms()[index - 1])[0].get('outputSelectedValueId').value;
          if (currentValue >= prevoiusValue && currentTypeId == previousTypeId) {
            this.isValidToSave = false;
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.captionStep) + ' (' + outputIndex + ') : ' + this.translateService.instant(ConstantMessages.MsgStepPromotionValueValidation));
            return;
          }
          outputIndex += 1;
        }
      }
    }

    // Validate Range promotion values
    var inputIndex = 0;
    var fromValue = 0;
    var toValue = 0;
    var prevoiusToValue = 0;
    var prevoiusFromValue = 0;

    if (this.promotionTypeControl.value === PromotionTypes.RangeValues) {
      for (let inputForm of this.getInputsForms()) {
        for (let detailForm of this.getInputFormDetails(inputForm)) {
          fromValue = +detailForm.get('inputValue').value;
          toValue = detailForm.get('inputValueRange').value;
          if (toValue && toValue != null && +toValue > 0) {
            if (fromValue >= toValue) {
              this.isValidToSave = false;
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.captionRange) + ' (' + +(inputIndex + 1) + ') : ' + this.translateService.instant(ConstantMessages.MsgStartShouldLessThanEnd));
              return;
            }
          }
          if (inputIndex > 0 && this.isRelatedToTarget && this.getInputsForms().length > 1) {
            prevoiusFromValue = +this.getInputFormDetails(this.getInputsForms()[inputIndex - 1])[0].get('inputValue').value;
            prevoiusToValue = this.getInputFormDetails(this.getInputsForms()[inputIndex - 1])[0].get('inputValueRange').value;

            if (prevoiusToValue && prevoiusToValue != null && +prevoiusToValue > 0) {
              if (fromValue <= prevoiusToValue) {
                this.isValidToSave = false;
                this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.captionRange) + ' (' + +(inputIndex + 1) + ') : ' + this.translateService.instant(ConstantMessages.MsgRangePromotionValueValidation));
                return;
              }
            } else if (fromValue <= prevoiusFromValue) {
              this.isValidToSave = false;
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.captionRange) + ' (' + +(inputIndex + 1) + ') : ' + this.translateService.instant(ConstantMessages.MsgRangePromotionValueValidation));
              return;
            }
          }
        }
        inputIndex += 1;
      }
    }

    // Validate target Promotion values
    // If it's not the first option then must validate current option value to be greater than prevoius step value for inputs
    // Each option have excactly one detail
    if (this.promotionTypeControl.value === PromotionTypes.TargetPromotion || this.promotionTypeControl.value === PromotionTypes.DynamicTargetPromotion) {
      var prevoiusValue = 0;
      var currentValue = 0;
      var inputIndex = 2; // starting from second step
      // Inputs
      if (this.getInputsForms().length > 1) {
        for (let index = 1; index < this.getInputsForms().length; index++) {
          currentValue = +this.getInputFormDetails(this.getInputsForms()[index])[0].get('inputValue').value;
          prevoiusValue = +this.getInputFormDetails(this.getInputsForms()[index - 1])[0].get('inputValue').value;
          if (currentValue <= prevoiusValue) {
            this.isValidToSave = false;
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.captionOption) + ' (' + inputIndex + ') : ' + this.translateService.instant(ConstantMessages.MsgTargetOptionPromotionValueValidation));
            return;
          }
          inputIndex += 1;
        }
      }
    }

    //Validate Assign to customers if sonic is picked
    // remove assign to customer for promotions.
    // if (this.isBundle || (!this.isBundle && this.offerAppliedOptionsControl.value[0].optionId === OfferAppliedOptions.Sonic.valueOf())) {
    //   if (!this.promotionEntryForm.get('headerDataFrom').get('assignToAllCustomers').value) {
    //     if ((!this.addedCustomersList || this.addedCustomersList.length === 0) &&
    //       (!this.promotionEntryForm.get('groupsList').value || this.promotionEntryForm.get('groupsList').value.length === 0) &&
    //       (!this.promotionEntryForm.get('channelsList').value || this.promotionEntryForm.get('channelsList').value.length === 0)) {

    //       if (!this.enableSalesDistributionChannel ||
    //         (this.enableSalesDistributionChannel && (!this.promotionEntryForm.get('sdcsList').value || this.promotionEntryForm.get('sdcsList').value.length == 0))
    //       ) {
    //         this.showEntrySection(2);
    //         this.isValidToSave = false;
    //         this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgApplyPromotionsToCustomers))
    //         return;
    //       }
    //     }
    //   }
    // }
  }

  PromotionSaved() {
    // Validate Unique Code
    let codeFilter = {
      tableName: 'Promotion',
      columnName: 'PromotionCode',
      insertedValue: this.promotionEntryForm.get('headerDataFrom').get('promotionCode').value,
      excludedString: ' And promotionId != ' + this.promotionId + ' And Promotion.IsDeleted = 0',
    }
    this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (!response.data) {
          this.showEntrySection(0);
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
        }
        else {
          this.fillPromotionObject();
          // Fill Images
          this.formData = new FormData();
          for (let file of this.attahcedImages) {
            this.formData.append('imagesList', file.file, file.name);
          }
          for (let file of this.attachedFiles) {
            if (file.file)
              this.formData.append("attachedFiles", file.file, file.name);
          }
          this.formData.append('promotionString', JSON.stringify(this.promotionObject));
          this.savePromotionToDB();
        }
      }
      else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  savePromotionToDB() {
    if (this.isLoyaltyPromotion) {

      this.loyaltyProgramsService.saveLoyalty(this.formData, this.isEditMode).subscribe(response => {
        this.onSavePromotionSuccess(response);
      },
        (error: HttpErrorResponse) => {
          this.onSavePromotionError(error);
        });
    } else {
      this.promotionService.savePromotion(this.formData, this.isEditMode).subscribe(response => {
        this.onSavePromotionSuccess(response);
      },
        (error: HttpErrorResponse) => {
          this.onSavePromotionError(error);
        });
    }

  }

  onSavePromotionSuccess(response) {
    if (response.status != null && response.status >= 0) {
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
      if(this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("1")){
        if(response.data.status== -1){
          this.showNotificationConfiramtionMsg(response.data.status, response.data.offerAppliedOptions);
        }else{
          this.onAddingPromotionEvent.emit();
        }
      }else{
        this.showNotificationConfiramtionMsg(response.data.status, response.data.offerAppliedOptions);
      }
      if (!this.isBundle && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("1")) {
        this.sendEmail(response.data.promotionId, response.data.status);
      }
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }
  showNotificationConfiramtionMsg(status,offerAppliedOptions) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgPromotionNotification), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          if (offerAppliedOptions.includes(OfferAppliedOptions.Sonic.valueOf().toString()) || offerAppliedOptions.includes(OfferAppliedOptions.NearExpiry.valueOf().toString()))
          this.promotionObject.sendNotificationToFO = true;
        if (offerAppliedOptions.includes(OfferAppliedOptions.CustomerApp.valueOf().toString()))
          this.promotionObject.sendNotification = true;
        }
        else {
          this.promotionObject.sendNotification = false;
          this.promotionObject.sendNotificationToFO = false;
        }
        if (this.promotionObject.sendNotification || this.promotionObject.sendNotificationToFO) {
          if(this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("1")){
            if(status == -1)
              this.sendNotification();
          }else{
              this.sendNotification();
          }
        }
        this.onAddingPromotionEvent.emit();
      });
  }
  sendNotification() {
        this.pricesAndOffersService.sendNotification(this.promotionObject).subscribe(response => {
          if (response.status != null && response.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly), response.message);
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.NotificationFailedCaption), response.message);
          }
        },
          (error: HttpErrorResponse) => {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.EmailFailedCaption));
          }
        );
      }
  onSavePromotionError(error) {
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));

  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.onAddEditPromotion();
      if (this.isValidToSave) {
          this.PromotionSaved();
        }
    });
  }
  //#region [Customers]
  fillCustomersList() {
    this.customersDataSource = {
      totalItems: this.addedCustomersList.length,
      data: this.addedCustomersList
    };
  }
  sendEmail(promotionId, currentStatusId) {
    this.pricesAndOffersService.sendOperationEmail(promotionId, currentStatusId, ApprovalCycleOperations.Promotions.valueOf(), this.promotionObject.promotionCode, false).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.EmailCaption));
      } else {
        if (response.message != this.translateService.instant(ConstantMessages.Desc_No_Email_Template_Found_For_Document_Type))
          this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onRowOperationForCustomers(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        var list = [];
        list.push(event.object);
        this.onDeleteSelectedAddedCustomers(list);
        break;
    }
  }
  onMultiSelectionOperationForCustomers(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        this.onDeleteSelectedAddedCustomers(event.object);
        break;
      }
    }
  }
  onDeleteSelectedAddedCustomers(selectedCustomersList) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          selectedCustomersList.forEach(customer => {
            var index = this.addedCustomersList.findIndex(x => x.customerId === customer.customerId && x.outletId === customer.outletId);
            if (index >= 0) {
              this.addedCustomersList.splice(index, 1);
            }
          });
        }
        this.fillCustomersList();
      });
  }
  openSelectCustomersDialog() {
    this.getSelectedOrganizationIdsAsString(null);
    this.customersToExclude = null;
    this.customersToExclude = cloneDeep(this.excludedCustomersList);
    this.copyOfAddedCustomers = null;
    this.copyOfAddedCustomers = cloneDeep(this.addedCustomersList);
    this.selectCustomerDialog.showDialog(this.organizationIdsString, this.customersToExclude).then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedCustomers(result)
        } else {
          this.closeSelectCustomersDialog();
        }
      });
  }
  closeSelectCustomersDialog() {
    if (this.isCloneMode) {
      this.coreSession.SetTitle('Clone Promotion');
    } else if (this.isEditMode) {
      this.coreSession.SetTitle('Edit Promotion');
    } else {
      this.coreSession.SetTitle('Add Promotion');
    }
  }
  afterAddingSelectedCustomers(selectedCustomers) {
    // remove is check property
    selectedCustomers.forEach(x => {
      x.isChecked = false;
    });
    this.addedCustomersList = selectedCustomers;
    this.fillCustomersList();
    this.closeSelectCustomersDialog();
  }
  //#endregion

  //#region [Exclude Customers]
  fillExcludedCustomersList() {
    this.excludeCustomersDataSource = {
      totalItems: this.excludedCustomersList.length,
      data: this.excludedCustomersList
    };
  }
  onRowOperationForExcludeCustomers(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        var list = [];
        list.push(event.object);
        this.onDeleteSelectedExcludedCustomers(list);
        break;
    }
  }
  onMultiSelectionOperationForExcludeCustomers(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        this.onDeleteSelectedExcludedCustomers(event.object);
        break;
      }
    }
  }
  onDeleteSelectedExcludedCustomers(selectedExcludedCustomersList) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          selectedExcludedCustomersList.forEach(customer => {
            var index = this.excludedCustomersList.findIndex(x => x.customerId === customer.customerId && x.outletId === customer.outletId);
            if (index >= 0) {
              this.excludedCustomersList.splice(index, 1);
            }
          });
        }
        this.fillExcludedCustomersList();
      });
  }
  openExcludeCustomersDialog() {
    this.getSelectedOrganizationIdsAsString(null);
    this.customersToExclude = [];
    if (!this.isEditTargetPromotion)
      this.customersToExclude = cloneDeep(this.addedCustomersList);
    this.copyOfExcludeCustomers = null;
    this.copyOfExcludeCustomers = cloneDeep(this.excludedCustomersList);
    this.excludeCustomersDialog.showDialog(this.organizationIdsString, this.customersToExclude).then(
      (result) => {
        if (result != -1) {
          this.afterSaveExcludeCustomersDialog(result)
        } else {
          this.closeExcludeCustomersDialog();
        }
      });
  }
  closeExcludeCustomersDialog() {
    this.excludeCustomersDialog.closeSelectCustomerDialog();
    if (this.isCloneMode) {
      this.coreSession.SetTitle('Clone Promotion');
    } else if (this.isEditMode) {
      this.coreSession.SetTitle('Edit Promotion');
    } else {
      this.coreSession.SetTitle('Add Promotion');
    }
  }
  afterSaveExcludeCustomersDialog(excludedCustomers) {
    // remove is check property
    excludedCustomers.forEach(x => {
      x.isChecked = false;
    });
    this.excludedCustomersList = excludedCustomers;
    this.fillExcludedCustomersList();
    this.closeExcludeCustomersDialog();
  }
  //#endregion

  //#region [Inputs]
  clearAllInputsFixedPromotion() {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          (<FormArray>this.promotionEntryForm.get('inputs')).clear();
          // push new input form by default
          this.pushNewInputForm();
        }
      });
  }
  preparePromotionInputsListToSave() {
    this.maxDetailId = 1;
    this.maxOptionId = 1;
    var refOutputIndex = this.getInputsForms().length + 1;
    var inputsList = [];

    this.getInputsForms().forEach(inputForm => {
      let inputObject = {
        promotionOptionId: this.maxOptionId,
        referenceOptionId: this.promotionType === PromotionTypes.FixedValues ? -1 : refOutputIndex,
        promotionOptionTypeId: PromotionOptionTypes.Input,
        promotionOptionDetails: [],
        isSelected: false,
      }
      inputObject.promotionOptionDetails = this.prepareInputDetailsListToSave(inputForm, inputObject);
      inputsList.push(inputObject);
      this.maxOptionId += 1;
      refOutputIndex += 1;
    });
    return inputsList;
  }
  prepareInputDetailsListToSave(inputForm, inputObject) {
    let detailsList = [];
    this.getInputFormDetails(inputForm).forEach(detailForm => {
      let detailObject = {
        promotionOptionDetailId: this.maxDetailId,
        inputOptionDetailTypeId: this.getInputDetailTypeControl(detailForm).value,
        promotionOptionDetailTypeId: this.getInputDetailTypeControl(detailForm).value,
        achievementTypeId: this.getInputDetailAchievementTypeControl(detailForm).value ? this.getInputDetailAchievementTypeControl(detailForm).value : -1,
        achievementId: this.getInputDetailAchievementIdControl(detailForm).value ? this.getInputDetailAchievementIdControl(detailForm).value : -1,
        promotionOptionId: inputObject.promotionOptionId,
        referenceOptionId: inputObject.referenceOptionId,
        promotionOptionTypeId: inputObject.promotionOptionTypeId,
        promotionId: this.promotionId,
        value: detailForm.get('inputValue').value ? +detailForm.get('inputValue').value : -1,
        range: -1, // in DB range column will save as NULL for all promotion types except for range type it will save with (zero or more)
        packGroupDetails: [],
        divisionId: -1,
        packId: -1,
        packGroupId: -1,
        packTypeId: -1,
        salesOrderTypeId: '',
        itemId: -1,
        dateRange: []
      }
      this.promotionAchievementId = detailObject.achievementId;
      this.promotionAchievementTypeId = detailObject.achievementTypeId;

      var selectedValueId = detailForm.get('inputSelectedValueId').value;
      if (this.getInputDetailTypeControl(detailForm).value == PromotionInputDetailTypes.SummationOverGroupOnTypeLevel.valueOf() || this.getInputDetailTypeControl(detailForm).value == PromotionInputDetailTypes.InvoiceAmountOnPackGroupOnTypeLevel.valueOf()) {
        if (detailForm.get('inputSalesOrderTypeId').value && detailForm.get('inputSalesOrderTypeId').value.length > 0) {
          var selectedSalesOrderTypeId = detailForm.get('inputSalesOrderTypeId').value.map(({ salesOrderTypeId }) => salesOrderTypeId);
          if (selectedSalesOrderTypeId && selectedSalesOrderTypeId.length > 0) {
            selectedSalesOrderTypeId = selectedSalesOrderTypeId.join(',');
          }
        }
      } else {
        selectedSalesOrderTypeId = ''
      }
      if (this.isItemLevelInput(detailForm)) {
        detailObject.itemId = selectedValueId;
      } else if (this.isItemInput(detailForm)) {
        detailObject.packId = selectedValueId;
      } else if (this.isPackGroupInput(detailForm)) {
        detailObject.packGroupId = selectedValueId;
        if (detailObject.inputOptionDetailTypeId === PromotionInputDetailTypes.GroupDifferntQuantity || detailObject.inputOptionDetailTypeId === PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel) {
          detailObject.packGroupDetails = detailForm.value.packGroupDetails;
        } if (this.isSalesOrderInput(detailForm)) {
          detailObject.salesOrderTypeId = selectedSalesOrderTypeId;
        }
      } else if (this.isDivisionInput(detailForm)) {
        detailObject.divisionId = selectedValueId;
      } else if (this.isPackTypeInput(detailForm)) {
        detailObject.packTypeId = selectedValueId;
      } else if (this.isSurveyInput(detailForm)) {
        //detailObject.surveyId =  selectedValueId;
      }
      if (this.isNoSalesInCertainPeriodTypes(detailForm)) {
        detailObject.dateRange.push(this.coreSession.getDateTimeModel(detailForm.value.dateRange[0]));
        detailObject.dateRange.push(this.coreSession.getDateTimeModel(detailForm.value.dateRange[1]));
      }

      if (this.promotionType === PromotionTypes.RangeValues) {
        var rangeWidth = 0;
        var inputValueEnd = detailForm.get('inputValueRange').value ? +detailForm.get('inputValueRange').value : 0;
        if (inputValueEnd > 0) {
          rangeWidth = inputValueEnd - detailObject.value;
          if (this.isStockDigitInput(detailForm)) {
            rangeWidth = this.calculationService.getNumberOnStockDigitFormat(rangeWidth);
          } else {
            rangeWidth = this.calculationService.getNumberOnDigitFormat(rangeWidth);
          }
        }
        detailObject.range = rangeWidth;
      }
      detailsList.push(detailObject);
      this.maxDetailId += 1;
    });
    return detailsList;
  }
  fillInputDetailsTypesList() {
    this.inputDetailsTypesList = [];
    if(this.freeQuantityToggle){
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.ItemQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Quantity_Input_Type) });
    } else if (this.isBundle) {
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.GroupDifferntQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Differnt_Quantity_Input_Type) });
    } else if (this.isLoyaltyPromotion) {
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.InvoiceValue, 'typeName': this.translateService.instant(ConstantMessages.Desc_Invoice_Value_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.ItemQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Quantity_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.GroupEqualQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Equal_Quantity_Input_Type) });

      if ((this.promotionType === PromotionTypes.FixedValues && this.promotionModeId == LoyaltyModes.PointsLoyaltyPromotion.valueOf()) || this.promotionType === PromotionTypes.RangeValues || this.promotionType === PromotionTypes.StepsValues) {
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.ItemAmount, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Value_Input_Type) });
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.InvoiceAmountOnPackGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Invoice_Value_Over_Group_Input_Type) });
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.UOMOverAllItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Certain_Pack_Type_Input_Type) })
        if (this.ControlTransactionOnDivisionLevel) {
          this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.ItemQuantityFromDivision, 'typeName': this.translateService.instant(ConstantMessages.Desc_Items_Over_Division_Input_Type) });
        }
      }
      if (this.promotionType === PromotionTypes.FixedValues) {
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.GroupDifferntQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Differnt_Quantity_Input_Type) });
      }

      if (this.promotionType === PromotionTypes.FixedValues || this.promotionType === PromotionTypes.RangeValues) {
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.CertainNumberOfItemsOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Number_Of_Different_Group_Items_Input_Type) });
      }

    } else if (this.promotionType === PromotionTypes.TargetPromotion) {
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.CustomerMonthlyAchievement, 'typeName': this.translateService.instant(ConstantMessages.Desc_Customer_Monthly_Achievement_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.CustomerMonthlyWholesalesContracts, 'typeName': this.translateService.instant(ConstantMessages.Desc_Customer_Monthly_Whole_Sales_Contracts_Input_Type) });
    } else if (this.promotionType === PromotionTypes.DynamicTargetPromotion) {
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.DynamicTargetSalesAmount, 'typeName': this.translateService.instant(ConstantMessages.Desc_Dynamic_Target_Sales_Amount_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.DynamicTargetSummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Dynamic_Target_Summation_Over_Group_Input_Type) });
    } else if (this.promotionType === PromotionTypes.SurveyPromotion) {
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.Survey, 'typeName': this.translateService.instant(ConstantMessages.Desc_Survey) });
    } else if (this.promotionType === PromotionTypes.RangeValues && this.isRelatedToTarget && this.isRestrictUpperLimitControl.value) {
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Input_Type) });
    } else if (this.isRestrictPromotionType && !this.isRelatedToTarget) {
      if(this.isProductDiscountControl.value){
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Input_Type) });
      } else {
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.InvoiceValue, 'typeName': this.translateService.instant(ConstantMessages.Desc_Invoice_Value_Input_Type) });
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Input_Type) });
      }
    }
    else {
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.InvoiceValue, 'typeName': this.translateService.instant(ConstantMessages.Desc_Invoice_Value_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.ItemAmount, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Value_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.ItemQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Quantity_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.UOMOverAllItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Certain_Pack_Type_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.InvoiceAmountOnPackGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Invoice_Value_Over_Group_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Input_Type) });
      this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.CertainNumberOfItemsOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Number_Of_Different_Group_Items_Input_Type) });

      if (!this.promotionType || this.promotionType === PromotionTypes.FixedValues) {
        // this types available for fixed promotions only
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.GroupEqualQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Equal_Quantity_Input_Type) });
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.GroupDifferntQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Differnt_Quantity_Input_Type) });
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.ItemWithNoSalesInCertainPeriodRestrictedToInvoicesCount, 'typeName': this.translateService.instant(ConstantMessages.Desc_No_Item_Sales_Period_Input_Type) });
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.GroupWithNoSalesInCertainPeriodRestrictedToInvoicesCount, 'typeName': this.translateService.instant(ConstantMessages.Desc_No_Group_Sales_Period_Input_Type) });
      }
      if (this.promotionType === PromotionTypes.FixedValues && this.ConsiderStockStatusInOrderFlow) {
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Differnt_Quantity_Input_Type_From_Sales_Order_Type) });
      }
      if ((this.promotionType === PromotionTypes.FixedValues || this.promotionType === PromotionTypes.RangeValues || this.promotionType === PromotionTypes.StepsValues) && this.ConsiderStockStatusInOrderFlow) {
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.SummationOverGroupOnTypeLevel, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Input_Type_From_Sales_Order_Type) });
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.InvoiceAmountOnPackGroupOnTypeLevel, 'typeName': this.translateService.instant(ConstantMessages.Desc_Invoice_Value_Over_Group_Input_Type_From_Sales_Order_Type) });
      }
      if (this.ControlTransactionOnDivisionLevel) {
        this.inputDetailsTypesList.push({ 'typeId': PromotionInputDetailTypes.ItemQuantityFromDivision, 'typeName': this.translateService.instant(ConstantMessages.Desc_Items_Over_Division_Input_Type) });
      }
    }
  }
  fillSalesOrderTypes() {
    this.discountService.getSalesOrderTypes().subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.salesOrderTypeList = response.data;
          if (this.isEditMode || this.isCloneMode || this.isViewMode) {
            if ((this.promotionType === PromotionTypes.FixedValues || this.promotionType === PromotionTypes.RangeValues || this.promotionType === PromotionTypes.StepsValues) && this.ConsiderStockStatusInOrderFlow) {
              this.fillPromotionDataForEdit();
            }
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getInputDetailSelectionIdControl(detailForm) {
    return detailForm.get('inputSelectedValueId');
  }
  getInputDetailTypeControl(detailForm) {
    return detailForm.get('inputDetailTypeId');
  }
  getInputDetailAchievementTypeControl(detailForm) {
    return detailForm.get('achievementTypeId');
  }
  getInputDetailAchievementIdControl(detailForm) {
    return detailForm.get('achievementId');
  }
  isStockDigitInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.ItemQuantity || detailTypeValue === PromotionInputDetailTypes.UOMOverAllItems
      || detailTypeValue === PromotionInputDetailTypes.SummationOverGroup || detailTypeValue === PromotionInputDetailTypes.SummationOverGroupOnTypeLevel || detailTypeValue === PromotionInputDetailTypes.GroupEqualQuantity
      || detailTypeValue === PromotionInputDetailTypes.CertainNumberOfItemsOverGroup || detailTypeValue === PromotionInputDetailTypes.ItemQuantityFromDivision)) {
      return true;
    }
    else {
      return false;
    }
  }
  isDigitInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.InvoiceValue || detailTypeValue === PromotionInputDetailTypes.ItemAmount
      || detailTypeValue === PromotionInputDetailTypes.InvoiceAmountOnPackGroup || detailTypeValue === PromotionInputDetailTypes.InvoiceAmountOnPackGroupOnTypeLevel)) {
      return true;
    }
    else {
      return false;
    }
  }
  isPackGroupInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.InvoiceAmountOnPackGroup || detailTypeValue === PromotionInputDetailTypes.SummationOverGroup || detailTypeValue === PromotionInputDetailTypes.SummationOverGroupOnTypeLevel
      || detailTypeValue === PromotionInputDetailTypes.GroupEqualQuantity || detailTypeValue === PromotionInputDetailTypes.GroupDifferntQuantity
      || detailTypeValue === PromotionInputDetailTypes.CertainNumberOfItemsOverGroup
      || detailTypeValue === PromotionInputDetailTypes.DynamicTargetSummationOverGroup
      || (detailTypeValue === PromotionInputDetailTypes.CustomerMonthlyAchievement && this.getInputDetailAchievementTypeControl(detailForm).value === AchievementTypeValues.SoldQuantityForPackGroup)
      || detailTypeValue === PromotionInputDetailTypes.InvoiceAmountOnPackGroupOnTypeLevel
      || detailTypeValue === PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel
      || detailTypeValue === PromotionInputDetailTypes.GroupWithNoSalesInCertainPeriodRestrictedToInvoicesCount)) {
      return true;
    }
    else {
      return false;
    }
  }
  isDivisionInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (this.ControlTransactionOnDivisionLevel && detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.ItemQuantityFromDivision || detailTypeValue === PromotionInputDetailTypes.InvoiceAmountFromDivision)) {
      return true;
    }
    else {
      return false;
    }
  }
  isSurveyInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.Survey)) {
      return true;
    }
    else {
      return false;
    }
  }
  isPackTypeInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && detailTypeValue === PromotionInputDetailTypes.UOMOverAllItems) {
      return true;
    }
    else {
      return false;
    }
  }
  isSalesOrderInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (this.ConsiderStockStatusInOrderFlow && detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.SummationOverGroupOnTypeLevel
      || detailTypeValue === PromotionInputDetailTypes.InvoiceAmountOnPackGroupOnTypeLevel)) {
      return true;
    }
    else {
      return false;
    }
  }
  isItemInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.ItemQuantity || detailTypeValue === PromotionInputDetailTypes.ItemAmount)) {
      return true;
    }
    else {
      return false;
    }
  }
  isItemLevelInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.ItemWithNoSalesInCertainPeriodRestrictedToInvoicesCount)) {
      return true;
    }
    else {
      return false;
    }
  }
  isInvoiceInput(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (
      detailTypeValue === PromotionInputDetailTypes.InvoiceValue
      || detailTypeValue === PromotionInputDetailTypes.CustomerMonthlyWholesalesContracts
      || detailTypeValue === PromotionInputDetailTypes.DynamicTargetSalesAmount
      || (detailTypeValue === PromotionInputDetailTypes.CustomerMonthlyAchievement && this.getInputDetailAchievementTypeControl(detailForm).value === AchievementTypeValues.SalesAmount))) {
      return true;
    }
    else {
      return false;
    }
  }
  isDefineGroupItemsQty(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.GroupDifferntQuantity || detailTypeValue === PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel)) {
      return true;
    }
    else {
      return false;
    }
  }
  isNoSalesInCertainPeriodTypes(detailForm) {
    var detailTypeValue = this.getInputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionInputDetailTypes.ItemWithNoSalesInCertainPeriodRestrictedToInvoicesCount || detailTypeValue === PromotionInputDetailTypes.GroupWithNoSalesInCertainPeriodRestrictedToInvoicesCount)) {
      return true;
    }
    else {
      return false;
    }
  }
  isPackGroupInputAchievementType(detailForm) {
    var achievementTypeValue = this.getInputDetailAchievementTypeControl(detailForm).value;
    if (achievementTypeValue && achievementTypeValue === AchievementTypeValues.SoldQuantityForPackGroup) {
      return true;
    }
    else {
      return false;
    }
  }
  onChangeDetaiDateRange(detailForm, date: any[]) {

  }
  closePackGroupDetailDialog() {
    this.coreSession.SetTitle('Promotion Entry');
  }
  definePackGroupQtyClick(detailForm) {
    this.coreSession.markFormGroupTouched(detailForm);
    if (detailForm && !detailForm.get('inputSelectedValueId').invalid) {
      this.currentSelectedDetailForm = detailForm;
      var packGroupId = this.getInputDetailSelectionIdControl(detailForm).value;
      if (packGroupId) {
        var detailsList = detailForm.get('packGroupDetails').value;
        this.currenctPackGroupDetails = {
          oldPackGroupDetails: detailsList,
          packGroupId: packGroupId
        };
        if (detailForm.get('inputDetailTypeId').value != 25) {
          this.fillPackGroupItems.showDialog(this.packGroupDialogMode.preRequisiteQty).then(result => {
            this.closePackGroupDetailDialog();
            if (result !== 0) {
            }
          });
        } else {
          this.fillPackGroupItems.showDialog(this.packGroupDialogMode.preRequisiteDifferentQtyOverGroupFromSalesOrderType).then(result => {
            this.closePackGroupDetailDialog();
            if (result !== 0) {
            }
          });
        }

      } else {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
  }
  definePackGroupDiscountAndPrice(detailForm) {
    this.coreSession.markFormGroupTouched(detailForm);
    if (detailForm && !detailForm.get('outputSelectedValueId').invalid) {
      this.currentSelectedDetailForm = detailForm;
      var packGroupId = this.getOutputDetailSelectionIdControl(detailForm).value;
      if (packGroupId) {
        var detailsList = detailForm.get('packGroupDetails').value;
        this.currenctPackGroupDetails = {
          oldPackGroupDetails: detailsList,
          packGroupId: packGroupId
        };
        var type = this.packGroupDialogMode.benefitDiscountPercentage;
        var detailTypeValue = this.getOutputDetailTypeControl(detailForm).value;
        if (detailTypeValue) {
          if (detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForGroupItems || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel) {
            type = this.packGroupDialogMode.benefitDiscountPercentage;
          } else if (detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverGroup || detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel) {
            type = this.packGroupDialogMode.benefitFixedPrice;
          }
          this.fillPackGroupItems.showDialog(type).then(result => {
            this.closePackGroupDetailDialog();
            if (result !== 0) {
            }
          });
        }
      } else {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
  }
  afterFillPackGroupDetailsQuantities(packGroupDetails) {
    if (this.currentSelectedDetailForm && packGroupDetails) {
      this.currentSelectedDetailForm.get('packGroupDetails').setValue(packGroupDetails);
    }
    this.currentSelectedDetailForm = null;
  }
  onChangeInputDetailType(detail,inputIndex) {
    // reset filled selection and values
    this.showSalesOrderInPackGroup = false;
    detail.get('inputValue').reset();
    detail.get('inputValueRange').reset();
    detail.get('inputSelectedValueId').reset();
    detail.get('packGroupDetails').setValue([]);
    detail.get('packGroupDetails').setValidators(Validators.nullValidator);
    detail.get('packGroupDetails').updateValueAndValidity();

    detail.get('dateRange').setValue([]);
    detail.get('dateRange').setValidators(Validators.nullValidator);
    detail.get('dateRange').updateValueAndValidity();

    if (this.isNoSalesInCertainPeriodTypes(detail)) {
      // set value as not required
      detail.get('inputValue').setValidators(Validators.nullValidator);
      detail.get('inputValue').updateValueAndValidity();

      detail.get('dateRange').setValidators(Validators.required);
      detail.get('dateRange').updateValueAndValidity();
    }
    else if (this.isDefineGroupItemsQty(detail)) {
      // set value as not required
      detail.get('inputValue').setValidators(Validators.nullValidator);
      detail.get('inputValue').updateValueAndValidity();

      detail.get('packGroupDetails').setValidators(Validators.required);
      detail.get('packGroupDetails').updateValueAndValidity();
    } else {
      // set value as required
      detail.get('inputValue').setValidators([Validators.required, Validators.min(0.0000001)]);
      detail.get('inputValue').updateValueAndValidity();
    }

    if (this.isInvoiceInput(detail)) {
      detail.get('inputSelectedValueId').setValidators(Validators.nullValidator);
      detail.get('inputSelectedValueId').updateValueAndValidity();
      // set selection as not required
    } else {
      // set selection as required
      detail.get('inputSelectedValueId').setValidators(Validators.required);
      detail.get('inputSelectedValueId').updateValueAndValidity();
    }

    if (this.isSalesOrderInput(detail)) {
      detail.get('inputSalesOrderTypeId').reset();
      detail.get('inputSalesOrderTypeId').setValidators(Validators.required);
      detail.get('inputSalesOrderTypeId').updateValueAndValidity();
      this.showSalesOrderInPackGroup = true;
    } else {
      detail.get('inputSalesOrderTypeId').setValidators(Validators.nullValidator);
      detail.get('inputSalesOrderTypeId').updateValueAndValidity();
    }
    if(this.freeQuantityToggle){
        var inputValueForFreeQuantity = this.getInputFormDetails(this.getInputsForms()[inputIndex])[0].get('inputDetailTypeId').value;
        if (inputValueForFreeQuantity === PromotionInputDetailTypes.ItemQuantity) {
          this.getOutputFormDetails(this.getOutputsForms()[inputIndex])[0].get('outputDetailTypeId').setValue(PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems);
        }
        else if (inputValueForFreeQuantity === PromotionInputDetailTypes.SummationOverGroup) {
          this.getOutputFormDetails(this.getOutputsForms()[inputIndex])[0].get('outputDetailTypeId').setValue(PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems);
        }
        else if (inputValueForFreeQuantity === null){
          this.getOutputFormDetails(this.getOutputsForms()[inputIndex])[0].get('outputDetailTypeId').reset();
        }
       let outputFormDetails = this.getOutputFormDetails(this.getOutputsForms()[inputIndex]);
       const detail = outputFormDetails[0];
       this.onChangeOutputDetailType(detail);
    }
    if(this.promotionTypeControl.value === PromotionTypes.RangeValues &&
      this.isRelatedToTargetControl.value &&
      this.isRestrictUpperLimitControl.value &&
      this.getInputsForms().length === 1 &&
      this.getOutputsForms().length === 1){
        const detail = this.getOutputFormDetails(this.getOutputsForms()[0])[0];
        detail.get('outputDetailTypeId').reset();
        this.onChangeOutputDetailType(detail);
    }
  }
  onChangeInputDetailSelection(detail,inputIndex) {
    // reset filled values and group details
    detail.get('inputValue').reset();
    detail.get('inputValueRange').reset();
    detail.get('packGroupDetails').setValue([]);
    detail.get('dateRange').setValue([]);

    if(this.freeQuantityToggle) {
        var inputSelectedValueForFreeQuantity = this.getInputFormDetails(this.getInputsForms()[inputIndex])[0].get('inputSelectedValueId').value;
        this.getOutputFormDetails(this.getOutputsForms()[inputIndex])[0].get('outputSelectedValueId').setValue(inputSelectedValueForFreeQuantity);
        let outputFormDetails = this.getOutputFormDetails(this.getOutputsForms()[inputIndex]);
        const detail = outputFormDetails[0];
        this.onChangeOutputDetailSelection(detail);
    }
    if (this.isBundle) {
      // set output selected pack group to be same as input selected pack group
      for (let index = 0; index < this.getOutputsForms().length; index++) {
        this.getOutputFormDetails(this.getOutputsForms()[index])[0].get('outputSelectedValueId').setValue(detail.get('inputSelectedValueId').value);
        this.getOutputFormDetails(this.getOutputsForms()[index])[0].get('outputSelectedValueId').updateValueAndValidity();
      }
    }

    if (this.promotionTypeControl.value === PromotionTypes.RangeValues &&
      this.isRelatedToTargetControl.value &&
      this.isRestrictUpperLimitControl.value &&
      this.getInputsForms().length === 1 &&
      this.getOutputsForms().length === 1) {
      const detail = this.getOutputFormDetails(this.getOutputsForms()[0])[0];
      detail.get('outputDetailTypeId').reset();
      this.onChangeOutputDetailType(detail);
    }
  }
  onChangeTargetPromotionInputType(selectedTarget) {
    // var selectedValue = this.promotionEntryForm.get('targetInputTypeId').value;
    var selectedValue = selectedTarget ? selectedTarget.typeId : null;
    this.promotionEntryForm.get('targetInputTypeId').setValue(this.selectedTargetInputTypeId);


    if (this.getInputsForms().length > 1) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.selectedTargetInputTypeId = selectedValue;
            this.targetInputTypeControl.setValue(selectedValue);

            this.targetInputSelectionControl.setValue(null);
            this.targetInputSelectionControl.setValidators(Validators.nullValidator)
            this.targetOutputSelectionControl.setValue(null);
            this.targetOutputSelectionControl.setValidators(Validators.nullValidator)
            if (this.selectedTargetInputTypeId === PromotionInputDetailTypes.DynamicTargetSummationOverGroup) {
              this.targetInputSelectionControl.setValidators(Validators.required)
              this.targetOutputSelectionControl.setValidators(Validators.required)
            }
            this.targetInputTypeControl.updateValueAndValidity();
            this.targetInputSelectionControl.updateValueAndValidity();
            this.targetInputSelectionControl.markAsTouched();
            this.targetOutputSelectionControl.updateValueAndValidity();
            this.targetOutputSelectionControl.markAsTouched();

            this.clearAllInputsAndOutputs();
          }
        });
    }
    else {
      this.selectedTargetInputTypeId = selectedValue;
      this.targetInputTypeControl.setValue(selectedValue);

      this.targetInputSelectionControl.setValue(null);
      this.targetInputSelectionControl.setValidators(Validators.nullValidator)
      this.targetOutputSelectionControl.setValue(null);
      this.targetOutputSelectionControl.setValidators(Validators.nullValidator)
      if (this.selectedTargetInputTypeId === PromotionInputDetailTypes.DynamicTargetSummationOverGroup) {
        this.targetInputSelectionControl.setValidators(Validators.required)
        this.targetOutputSelectionControl.setValidators(Validators.required)
      }
      this.targetInputSelectionControl.updateValueAndValidity();
      this.targetInputSelectionControl.markAsTouched();
      this.targetOutputSelectionControl.updateValueAndValidity();
      this.targetOutputSelectionControl.markAsTouched();

      this.clearAllInputsAndOutputs();
    }
  }
  onChangeTargetPromotionInputSelection() {
    var selectedPackGroupId = this.promotionEntryForm.get('targetInputSelectionId').value;
    this.promotionEntryForm.get('targetInputSelectionId').setValue(this.selectedTargetInputSelectionId);

    // when change to null msg to clear data
    if (!selectedPackGroupId) {
      // confirmation to clear filled data
      if (this.getInputsForms().length >= 0) {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              this.selectedTargetInputSelectionId = selectedPackGroupId;
              this.promotionEntryForm.get('targetInputSelectionId').setValue(selectedPackGroupId);
              this.clearAllInputsAndOutputs();
            }
          });
      }
    } else {
      if (this.getInputsForms().length === 0) {
        // push new input and output
        this.selectedTargetInputSelectionId = selectedPackGroupId;
        this.promotionEntryForm.get('targetInputSelectionId').setValue(selectedPackGroupId);
        this.pushNewTargetPromotion();
      } else if (this.getInputsForms().length === 1) {
        // Replace without confirmation
        this.selectedTargetInputSelectionId = selectedPackGroupId;
        this.promotionEntryForm.get('targetInputSelectionId').setValue(selectedPackGroupId);
        this.replaceTargetInputPackGroupSelection();
      } if (this.getInputsForms().length > 1) {
        // Replace with confirmation
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledPackGroupConfirmation), DialogMode.YesNo).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              this.selectedTargetInputSelectionId = selectedPackGroupId;
              this.promotionEntryForm.get('targetInputSelectionId').setValue(selectedPackGroupId);
              this.replaceTargetInputPackGroupSelection();
            }
          });
      }
    }
  }
  replaceTargetInputPackGroupSelection() {
    for (let index = 0; index < this.getInputsForms().length; index++) {
      this.getInputFormDetails(this.getInputsForms()[index])[0].get('inputSelectedValueId').setValue(this.selectedTargetInputSelectionId);
    }
  }
  onChangeTargetPromotionOutputSelection() {
    var selectedPackGroupId = this.promotionEntryForm.get('targetOutputSelectionId').value;
    this.promotionEntryForm.get('targetOutputSelectionId').setValue(this.selectedTargetOutputSelectionId);

    // when change to null msg to clear data
    if (!selectedPackGroupId) {
      // confirmation to clear filled data
      if (this.getOutputsForms().length >= 0) {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              this.selectedTargetOutputSelectionId = selectedPackGroupId;
              this.promotionEntryForm.get('targetOutputSelectionId').setValue(selectedPackGroupId);
              this.clearAllInputsAndOutputs();
            }
          });
      }
    } else {
      if (this.getOutputsForms().length === 0) {
        // push new input and output
        this.selectedTargetOutputSelectionId = selectedPackGroupId;
        this.promotionEntryForm.get('targetOutputSelectionId').setValue(selectedPackGroupId);
        this.pushNewTargetPromotion();
      } else if (this.getOutputsForms().length === 1) {
        // Replace without confirmation
        this.selectedTargetOutputSelectionId = selectedPackGroupId;
        this.promotionEntryForm.get('targetOutputSelectionId').setValue(selectedPackGroupId);
        this.replaceTargetOutputPackGroupSelection();
      } if (this.getOutputsForms().length > 1) {
        // Replace with confirmation
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledPackGroupConfirmation), DialogMode.YesNo).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              this.selectedTargetOutputSelectionId = selectedPackGroupId;
              this.promotionEntryForm.get('targetOutputSelectionId').setValue(selectedPackGroupId);
              this.replaceTargetOutputPackGroupSelection();
            }
          });
      }
    }
  }
  replaceTargetOutputPackGroupSelection() {
    for (let index = 0; index < this.getOutputsForms().length; index++) {
      this.getOutputFormDetails(this.getOutputsForms()[index])[0].get('outputSelectedValueId').setValue(this.selectedTargetOutputSelectionId);
    }
  }
  onChangeTargetInputAchievementType(inputOptionIndex, detail) {
    detail.get('achievementId').reset();
    detail.get('inputSelectedValueId').reset();
    detail.get('inputSelectedValueId').setValidators(Validators.nullValidator);
    detail.get('inputValue').reset();

    var outputDetailForm = this.getOutputFormDetails(this.getOutputsForms()[inputOptionIndex])[0] as FormGroup;

    outputDetailForm.get('outputDetailTypeId').reset();
    outputDetailForm.get('outputSelectedValueId').reset();
    outputDetailForm.get('outputSelectedValueId').setValidators(Validators.nullValidator);
    outputDetailForm.get('outputValue').reset();

    if (this.getInputDetailAchievementTypeControl(detail).value) {
      if (this.promotionType === PromotionTypes.TargetPromotion) {
        if (this.getInputDetailTypeControl(detail).value == PromotionInputDetailTypes.CustomerMonthlyAchievement) {
          if (this.getInputDetailAchievementTypeControl(detail).value == AchievementTypeValues.SalesAmount) {
            detail.get('achievementId').setValue(AchievementValues.MonthlySalesAmount);
            this.getOutputDetailTypeControl(outputDetailForm).setValue(PromotionOutputDetailTypes.RetailContractDiscount);
          }
          else if (this.getInputDetailAchievementTypeControl(detail).value == AchievementTypeValues.SoldQuantityForPackGroup) {
            detail.get('achievementId').setValue(AchievementValues.Monthlysoldquantityfrompackgroup);
            this.getOutputDetailTypeControl(outputDetailForm).setValue(PromotionOutputDetailTypes.OpenSteps);
          }
        }
      }

      // set pack group selection as mandatory for input
      if (this.isPackGroupInputAchievementType(detail)) {
        detail.get('inputSelectedValueId').setValidators(Validators.required);
      }
      detail.get('inputSelectedValueId').updateValueAndValidity();

      // set pack group selection as mandatory for output
      if (this.isPackGroupOutput(outputDetailForm)) {
        outputDetailForm.get('outputSelectedValueId').setValidators(Validators.required);
      }
      outputDetailForm.get('outputSelectedValueId').updateValueAndValidity();

      // set max discount per 100%
      if (this.isDiscountPercentageOutput(outputDetailForm)) {
        outputDetailForm.get('outputValue').setValidators([Validators.required, Validators.min(0.0000001), Validators.max(100)]);
      } else {
        outputDetailForm.get('outputValue').setValidators([Validators.required, Validators.min(0.0000001)]);
      }
      outputDetailForm.get('outputValue').updateValueAndValidity();
    }
  }

  getInputsForms() {
    return (<FormArray>this.promotionEntryForm.get('inputs')).controls;
  }
  pushNewInputForm() {
    // Push input and one empty detail by default
    let newInputForm = new FormGroup({
      details: new FormArray([], Validators.required)
    });
    this.pushNewInputDetail(newInputForm);
    (<FormArray>this.promotionEntryForm.get('inputs')).push(newInputForm);
  }
  removeInputForm(inputIndex) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          (<FormArray>this.promotionEntryForm.get('inputs')).removeAt(inputIndex);
        }
      });
  }
  getInputFormDetails(inputForm) {
    return (<FormArray>inputForm.get('details')).controls;
  }
  pushNewInputDetail(inputForm) {
    if (this.promotionTypeControl.value === PromotionTypes.RangeValues) {
      if (this.showAutoRangeFillScreen) {
        // input type, selection,values will depending on auto range definition, but user can change them
        var isSelectionRequired = false;
        var isSelectionSalesOrder = false;
        if (!this.isInvoiceInput(this.promotionEntryForm.get('autoRangesForm'))) {
          isSelectionRequired = true;
        }
        var isAccumulativeRange = false;
        if (this.isRelatedToTarget && (this.targetModeId == 1 || this.targetModeId == 2 || this.targetModeId == 3)) {
          isAccumulativeRange = true;
        }
        if (this.isSalesOrderInput(this.promotionEntryForm.get('autoRangesForm'))) {
          isSelectionSalesOrder = true;
        }

        (<FormArray>inputForm.get('details')).push(
          new FormGroup({
            inputDetailTypeId: new FormControl({ value: this.autoRangeInputTypeControl.value, disabled: isAccumulativeRange }, Validators.required),
            achievementTypeId: new FormControl(null),
            achievementId: new FormControl(null),
            inputSelectedValueId: new FormControl({ value: this.autoRangeInputSelectionControl.value, disabled: isAccumulativeRange }, isSelectionRequired ? Validators.required : null),
            inputValue: new FormControl(this.autoRangeInputValueStart, [Validators.required, Validators.min(0.0000001)]),
            inputValueRange: new FormControl(this.autoRangeInputValueEnd),
            packGroupDetails: new FormControl([]),
            inputSalesOrderTypeId: new FormControl(this.autoRangeSalesOrderTypeControl.value, isSelectionSalesOrder ? Validators.required : Validators.nullValidator),
            dateRange: new FormControl([]),
          })
        );
      }
      else {
        var isAccumulativeRange = false;
        var isRequired = false;
        if (this.isRelatedToTarget && (this.targetModeId == 1 || this.targetModeId == 2 || this.targetModeId == 3) && this.getInputsForms().length >= 1) {
          isAccumulativeRange = true;
          var selectedInputTypeId = this.getInputFormDetails(this.getInputsForms()[0])[0].get('inputDetailTypeId').value;
          var selectedInputValueId = null;
          if (!this.isInvoiceInput(this.getInputFormDetails(this.getInputsForms()[0])[0])) {
            isRequired = true;
            selectedInputValueId = this.getInputFormDetails(this.getInputsForms()[0])[0].get('inputSelectedValueId').value;
          }
        }
        (<FormArray>inputForm.get('details')).push(
          new FormGroup({
            inputDetailTypeId: new FormControl({ value: isAccumulativeRange ? selectedInputTypeId : null, disabled: isAccumulativeRange }, Validators.required),
            achievementTypeId: new FormControl(null),
            achievementId: new FormControl(null),
            inputSelectedValueId: new FormControl({ value: isAccumulativeRange ? selectedInputValueId : null, disabled: isAccumulativeRange }, isRequired ? Validators.required : null),
            inputValue: new FormControl(null, [Validators.required, Validators.min(0.0000001)]),
            inputValueRange: new FormControl(null),
            packGroupDetails: new FormControl([]),
            inputSalesOrderTypeId: new FormControl(null),
            dateRange: new FormControl([]),
          })
        );
      }
    } else if (this.promotionTypeControl.value === PromotionTypes.StepsValues) {
      // input type and selection will be same as main step definition and user can't change them
      var isSelectionRequired = false;
      var isSelectionSalesOrderRequired = false;
      if (!this.isInvoiceInput(this.mainStepEntryFormGroup)) {
        isSelectionRequired = true;
      }
      if (this.isSalesOrderInput(this.mainStepEntryFormGroup)) {
        isSelectionSalesOrderRequired = true;
      }
      (<FormArray>inputForm.get('details')).push(
        new FormGroup({
          inputDetailTypeId: new FormControl(this.stepInputTypeControl.value, Validators.required),
          achievementTypeId: new FormControl(null),
          achievementId: new FormControl(null),
          inputSelectedValueId: new FormControl({ value: this.stepInputSelectionControl.value, disabled: true }, isSelectionRequired ? Validators.required : null),
          inputValue: new FormControl(null, [Validators.required, Validators.min(0.0000001)]),
          inputValueRange: new FormControl(null),
          packGroupDetails: new FormControl([]),
          inputSalesOrderTypeId: new FormControl({ value: this.stepInputSalesOrderTypeControl.value, disabled: true }, isSelectionSalesOrderRequired ? Validators.required : null),
          dateRange: new FormControl([]),
        })
      );
    } else if (this.promotionTypeControl.value === PromotionTypes.FixedValues) {
      (<FormArray>inputForm.get('details')).push(
        new FormGroup({
          // By default set bundle pre-requisite to define different group qty
          inputDetailTypeId: new FormControl(this.isBundle ? PromotionInputDetailTypes.GroupDifferntQuantity : null, Validators.required),
          achievementTypeId: new FormControl(null),
          achievementId: new FormControl(null),
          inputSelectedValueId: new FormControl(null, Validators.required),
          inputValue: new FormControl(null, this.isBundle ? Validators.nullValidator : [Validators.required, Validators.min(0.0000001)]),
          inputValueRange: new FormControl(null),
          packGroupDetails: new FormControl([], this.isBundle ? Validators.required : Validators.nullValidator),
          inputSalesOrderTypeId: new FormControl(null),
          dateRange: new FormControl([]),
        })
      );
    } else if (this.promotionTypeControl.value === PromotionTypes.TargetPromotion) {
      var isWholesales = this.targetInputTypeControl.value === PromotionInputDetailTypes.CustomerMonthlyWholesalesContracts;
      (<FormArray>inputForm.get('details')).push(
        new FormGroup({
          inputDetailTypeId: new FormControl({ value: this.targetInputTypeControl.value, disabled: true }, Validators.required),
          achievementTypeId: new FormControl({ value: isWholesales ? AchievementTypeValues.SalesAmount : null, disabled: isWholesales }, Validators.required),
          achievementId: new FormControl(isWholesales ? AchievementValues.MonthlySalesAmount : null, Validators.required),
          inputSelectedValueId: new FormControl(null),
          inputValue: new FormControl(null, [Validators.required, Validators.min(0.0000001)]),
          inputValueRange: new FormControl(null),
          packGroupDetails: new FormControl([]),
          dateRange: new FormControl([]),
        })
      );
    } else if (this.promotionTypeControl.value === PromotionTypes.DynamicTargetPromotion) {
      var selectionId = null;
      var isPackGroupType = this.targetInputTypeControl.value === PromotionInputDetailTypes.DynamicTargetSummationOverGroup;
      if (isPackGroupType) {
        selectionId = this.targetInputSelectionControl.value;
      }

      (<FormArray>inputForm.get('details')).push(
        new FormGroup({
          inputDetailTypeId: new FormControl({ value: this.targetInputTypeControl.value, disabled: true }, Validators.required),
          achievementTypeId: new FormControl({ value: isPackGroupType ? AchievementTypeValues.SoldQuantityForPackGroup : AchievementTypeValues.SalesAmount, disabled: true }, Validators.required),
          achievementId: new FormControl(isPackGroupType ? AchievementValues.DynamicSalesPerPackGroupPerCustomer : AchievementValues.DynamicSalesAmountPerCustomer, Validators.required),
          inputSelectedValueId: new FormControl({ value: selectionId, disabled: true }, isPackGroupType ? Validators.required : Validators.nullValidator),
          inputValue: new FormControl(null, [Validators.required, Validators.min(0.0000001)]),
          inputValueRange: new FormControl(null),
          packGroupDetails: new FormControl([]),
          dateRange: new FormControl([]),
        })
      );
    } else if (this.promotionTypeControl.value === PromotionTypes.SurveyPromotion) {
      (<FormArray>inputForm.get('details')).push(
        new FormGroup({
          inputDetailTypeId: new FormControl(PromotionInputDetailTypes.Survey.valueOf(), Validators.required),
          achievementTypeId: new FormControl(null),
          achievementId: new FormControl(null),
          inputSelectedValueId: new FormControl(null, Validators.required),
          inputValue: new FormControl(null, Validators.nullValidator),
          inputValueRange: new FormControl(null),
          packGroupDetails: new FormControl([], Validators.nullValidator),
          dateRange: new FormControl([]),
        })
      );
    }
  }
  removeInputDetailForm(inputForm, detailIndex) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          (<FormArray>inputForm.get('details')).removeAt(detailIndex);
        }
      });
  }
  // #endregion

  //#region [Outputs]
  clearAllOutputsFixedPromotion() {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          (<FormArray>this.promotionEntryForm.get('outputs')).clear();
          this.pushNewOutputForm();
        }
      });
  }
  fillFormOutputsInEditMode() {
    this.promotionObject.promotionOutputs.forEach(outputObject => {
      let outputForm = new FormGroup({
        details: new FormArray([], Validators.required)
      });
      outputObject.promotionOptionDetails.forEach(detailObject => {
        let detailForm = new FormGroup({
          outputDetailTypeId: new FormControl({ value: detailObject.promotionOptionDetailTypeId, disabled: this.promotionType === PromotionTypes.TargetPromotion || this.promotionType === PromotionTypes.DynamicTargetPromotion || this.freeQuantityToggle }, Validators.required),
          outputSelectedValueId: new FormControl({value: null, disabled: this.freeQuantityToggle }),
          outputValue: new FormControl(detailObject.value, this.isBundle ? Validators.nullValidator : [Validators.required, Validators.min(0.0000001)]),
          packGroupDetails: new FormControl(detailObject.packGroupDetails, this.isBundle ? Validators.required : Validators.nullValidator),
          outputValidityWidth: new FormControl(detailObject.pointsValidityPeriodWidth, this.isLoyaltyPoints() ? Validators.required : Validators.nullValidator),
          outputSalesOrderTypeId: new FormControl(null),
        });
        var selectedValueId = null;
        var isRequired = false;
        if (this.isLoyaltyPoints()) {
          selectedValueId = detailObject.pointsValidityPeriodTypeId;
        }
        else if (this.isItemOutput(detailForm)) {
          selectedValueId = detailObject.packId;
          isRequired = true;
        } else if (this.isPackGroupOutput(detailForm)) {
          selectedValueId = detailObject.packGroupId;
          isRequired = true
        } else if (this.isOptionalItemOutput(detailForm)) {
          selectedValueId = detailObject.packId > 0 ? detailObject.packId : null;
        }
        if ((this.promotionType === PromotionTypes.FixedValues || this.promotionType === PromotionTypes.RangeValues || this.promotionType === PromotionTypes.StepsValues) && this.ConsiderStockStatusInOrderFlow) {
          if (this.isSalesOrderOutput(detailForm)) {
            detailForm.get('outputSalesOrderTypeId').setValidators(Validators.required);
            detailForm.get('outputSalesOrderTypeId').updateValueAndValidity();
            var salesTypesList = [];
            this.salesOrderTypeList.forEach(x => {
              if (detailObject.salesOrderTypeId.includes(x.salesOrderTypeId.toString())) {
                salesTypesList.push({ salesOrderTypeId: x.salesOrderTypeId, salesOrderTypeName: x.salesOrderTypeName });
              }
            })
          } else {
            detailForm.get('outputSalesOrderTypeId').setValidators(Validators.nullValidator);
            detailForm.get('outputSalesOrderTypeId').updateValueAndValidity();
          }
          // Re-fill output types according to selected applied option
        }
        detailForm.get('outputSalesOrderTypeId').setValue(salesTypesList);
        detailForm.get('outputSelectedValueId').setValue(selectedValueId);
        if (isRequired) {
          detailForm.get('outputSelectedValueId').setValidators(Validators.required);
          detailForm.get('outputSelectedValueId').updateValueAndValidity();
        }
        if (this.isBundle) {
          detailForm.get('outputSelectedValueId').disable();
          detailForm.get('outputValue').setValue(null);
        }
        else {
          if (this.promotionType == PromotionTypes.SurveyPromotion) {
            detailForm.get('outputValue').setValue('-1');
            detailForm.get('outputValue').setValidators(Validators.nullValidator);
            detailForm.get('outputValue').updateValueAndValidity();
          }
          else {
            if (this.isDiscountPercentageOutput(detailForm)) {
              detailForm.get('outputValue').setValidators([Validators.required, Validators.min(0.0000001), Validators.max(100)]);
              detailForm.get('outputValue').updateValueAndValidity();
            } else {
              detailForm.get('outputValue').setValidators([Validators.required, Validators.min(0.0000001)]);
              detailForm.get('outputValue').updateValueAndValidity();
            }
          }
        }
        if (this.promotionType == PromotionTypes.StepsValues && this.targetModeId == 1) {
          detailForm.get('outputSelectedValueId').disable();
        }
        (<FormArray>outputForm.get('details')).push(detailForm);
      });
      // disable if View Mode
      if (this.isViewMode || (this.isEditMode && this.promotionObject.status == -1 && this.isPromotionApprovalCycle)) {
        outputForm.disable();
      }
      (<FormArray>this.promotionEntryForm.get('outputs')).push(outputForm);
    });
  }
  preparePromotionOutputsListToSave() {
    var outputsList = [];
    var refInputIndex = 1;
    this.getOutputsForms().forEach(outputForm => {
      let outputObject = {
        promotionOptionId: this.maxOptionId,
        referenceOptionId: this.promotionType === PromotionTypes.FixedValues ? -1 : refInputIndex,
        promotionOptionTypeId: PromotionOptionTypes.Output,
        promotionOptionDetails: [],
        isSelected: false,
      }
      outputObject.promotionOptionDetails = this.prepareOutputDetailsListToSave(outputForm, outputObject);
      outputsList.push(outputObject);
      this.maxOptionId += 1;
      refInputIndex += 1;
    });
    return outputsList;
  }
  prepareOutputDetailsListToSave(outputForm, outputObject) {
    let detailsList = [];
    this.getOutputFormDetails(outputForm).forEach(detailForm => {
      let detailObject = {
        promotionOptionDetailId: this.maxDetailId,
        outputOptionDetailTypeId: this.getOutputDetailTypeControl(detailForm).value,
        promotionOptionDetailTypeId: this.getOutputDetailTypeControl(detailForm).value,
        promotionOptionId: outputObject.promotionOptionId,
        referenceOptionId: outputObject.referenceOptionId,
        promotionOptionTypeId: outputObject.promotionOptionTypeId,
        promotionId: this.promotionId,
        value: detailForm.get('outputValue').value ? +detailForm.get('outputValue').value : -1,
        packGroupDetails: [],
        range: -1,
        packId: -1,
        packGroupId: -1,
        pointsValidityPeriodTypeId: -1,
        pointsValidityPeriodWidth: detailForm.get('outputValidityWidth') && detailForm.get('outputValidityWidth').value ? +detailForm.get('outputValidityWidth').value : -1,
        salesOrderTypeId: ''
      }

      var selectedValueId = detailForm.get('outputSelectedValueId').value;
      if (this.getOutputDetailTypeControl(detailForm).value == PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel.valueOf() || this.getOutputDetailTypeControl(detailForm).value == PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel.valueOf()
        || this.getOutputDetailTypeControl(detailForm).value == PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel.valueOf()) {
        if (detailForm.get('outputSalesOrderTypeId').value && detailForm.get('outputSalesOrderTypeId').value.length > 0) {
          var selectedSalesOrderTypeId = detailForm.get('outputSalesOrderTypeId').value.map(({ salesOrderTypeId }) => salesOrderTypeId);
          if (selectedSalesOrderTypeId && selectedSalesOrderTypeId.length > 0) {
            selectedSalesOrderTypeId = selectedSalesOrderTypeId.join(',');
          }
        }
      } else {
        selectedSalesOrderTypeId = ''
      }
      if (this.isSalesOrderOutput(detailForm)) {
        detailObject.salesOrderTypeId = selectedSalesOrderTypeId;
      }
      if (this.isLoyaltyPoints()) {
        detailObject.pointsValidityPeriodTypeId = selectedValueId;
      }
      else if (this.isItemOutput(detailForm) || this.isOptionalItemOutput(detailForm)) {
        detailObject.packId = selectedValueId ? selectedValueId : -1;
      } else if (this.isPackGroupOutput(detailForm)) {
        detailObject.packGroupId = selectedValueId;
        if (this.isBundle) {
          detailObject.packGroupDetails = detailForm.get('packGroupDetails').value;
        }
      }
      detailsList.push(detailObject);
      this.maxDetailId += 1;
    });
    return detailsList;
  }
  fillOutputDetailsTypesList() {
    this.outputDetailsTypesList = [];
    if(this.freeQuantityToggle){
      if ((this.promotionType === PromotionTypes.FixedValues || this.promotionType === PromotionTypes.RangeValues)){
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Free_Item_Quantity_Based_On_Percentage_Of_Certain_Sold_Items_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Free_Pack_Group_Quantity_Based_On_Percentage_Of_Certain_Sold_Pack_Group_Items_Type) });
      }
    } else if (this.isLoyaltyPromotion) {
      if (this.promotionModeId == LoyaltyModes.LoyaltyPromotion.valueOf()) {
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.ItemQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Quantity_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.GroupEqualQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Equal_Quantity_Output_Type) });
      } else if (this.promotionModeId == LoyaltyModes.PointsLoyaltyPromotion.valueOf() && this.promotionType == PromotionTypes.StepsValues) {
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.CustomerPoints, 'typeName': this.translateService.instant(ConstantMessages.Desc_Customer_Points_Type) });
      }
    } else if (this.isBundle) {
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForGroupItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Discount_Percentage_Output_Type) }); // foreach item in group
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.FixedPriceOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Fixed_Price_Over_Group_Output_Type) }); // foreach item in group
    } else if (!this.isRestrictPromotionType && this.isProductDiscountControl.value && !(this.promotionType === PromotionTypes.RangeValues && this.isRestrictUpperLimitControl.value)) {
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.ItemQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Quantity_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount, 'typeName': this.translateService.instant(ConstantMessages.Desc_Disc_Percentage_Or_Qty_Over_Group_Output_Type) });
    } else if (this.promotionType === PromotionTypes.TargetPromotion) {
      //this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountAmountOverTransaction, 'typeName': this.translateService.instant(ConstantMessages.Desc_Discount_Amount_Over_Transaction_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.RetailContractDiscount, 'typeName': this.translateService.instant(ConstantMessages.Desc_Retail_Contract_Discount_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.OpenSteps, 'typeName': this.translateService.instant(ConstantMessages.Desc_Open_Steps_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.WholesalesContractsDiscount, 'typeName': this.translateService.instant(ConstantMessages.Desc_Whole_Sales_Contracts_Discount_Output_Type) });
    } else if (this.promotionType === PromotionTypes.DynamicTargetPromotion) {
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DynamicTargetDiscount, 'typeName': this.translateService.instant(ConstantMessages.Desc_Dynamic_Target_Discount_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DynamicTargetSummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Dynamic_Target_Summation_Over_Group_Output_Type) });
      //this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountAmountOverTransaction, 'typeName': this.translateService.instant(ConstantMessages.Desc_Discount_Amount_Over_Transaction_Output_Type) });
    } else if ((this.promotionType == PromotionTypes.RangeValues || this.promotionType == PromotionTypes.StepsValues) && this.isRelatedToTarget) {
      if (!this.resetLastInvRem && this.promotionType == PromotionTypes.StepsValues) {
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.ItemQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Quantity_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Output_Type) });
      } else if (this.promotionType == PromotionTypes.RangeValues && (this.isRestrictPromotionType && this.isRelatedToTarget) && this.isRestrictUpperLimitControl.value) {
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForGroupItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Discount_Percentage_Output_Type) }); // foreach item in group
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount, 'typeName': this.translateService.instant(ConstantMessages.Desc_Disc_Percentage_Or_Qty_Over_Group_Output_Type) });
      }
      else {
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.ItemQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Quantity_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForItem, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Discount_Percentage_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.AllItemDiscountPercentage, 'typeName': this.translateService.instant(ConstantMessages.Desc_All_Items_Discount_Percentage_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForGroupItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Discount_Percentage_Output_Type) }); // foreach item in group
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount, 'typeName': this.translateService.instant(ConstantMessages.Desc_Disc_Percentage_Or_Qty_Over_Group_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountAmountOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Discount_Amount_Over_Group_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountAmountOverTransaction, 'typeName': this.translateService.instant(ConstantMessages.Desc_Discount_Amount_Over_Transaction_Output_Type) });
      }
    } else if (this.isRestrictPromotionType) {
     if(this.isProductDiscountControl.value){
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Output_Type)});
     } else {
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.AllItemDiscountPercentage, 'typeName': this.translateService.instant(ConstantMessages.Desc_All_Items_Discount_Percentage_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForGroupItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Discount_Percentage_Output_Type) });
     }
    } else if (this.promotionType == PromotionTypes.SurveyPromotion) {
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForItem, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Discount_Percentage_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountAmountOverTransaction, 'typeName': this.translateService.instant(ConstantMessages.Desc_Discount_Amount_Over_Transaction_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.AllItemDiscountPercentage, 'typeName': this.translateService.instant(ConstantMessages.Desc_All_Items_Discount_Percentage_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForGroupItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Discount_Percentage_Output_Type) }); // foreach item in group
    }
    else {
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.ItemQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Quantity_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountAmountForItem, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Discount_Amount_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForItem, 'typeName': this.translateService.instant(ConstantMessages.Desc_Item_Discount_Percentage_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.AllItemDiscountAmount, 'typeName': this.translateService.instant(ConstantMessages.Desc_All_Items_Discount_Amount_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountAmountOverTransaction, 'typeName': this.translateService.instant(ConstantMessages.Desc_Discount_Amount_Over_Transaction_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.AllItemDiscountPercentage, 'typeName': this.translateService.instant(ConstantMessages.Desc_All_Items_Discount_Percentage_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.GroupEqualQuantity, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Equal_Quantity_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountAmountForGroupItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Discount_Amount_Output_Type) }); // foreach item in group
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForGroupItems, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Discount_Percentage_Output_Type) }); // foreach item in group
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountAmountOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Discount_Amount_Over_Group_Output_Type) });


      if (this.promotionType != PromotionTypes.StepsValues) {
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.FixedPriceOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Fixed_Price_Over_Group_Output_Type) }); // foreach item in group
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.FixedPriceOverItem, 'typeName': this.translateService.instant(ConstantMessages.Desc_Fixed_Price_Over_Item_Output_Type) });
        this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.FixedPriceOverAllItem, 'typeName': this.translateService.instant(ConstantMessages.Desc_Fixed_Price_Over_All_Item_Output_Type) });
      }
      // this line committed after handle selection in echo
      // if (this.coreSession.cachedGeneralData.webApplication === WebApplication.Sonic && !this.applyOnCustomerAppOnly) {
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.FreeItemsWithCertainValue, 'typeName': this.translateService.instant(ConstantMessages.Desc_Free_Items_Value_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.SummationOverGroup, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Output_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage, 'typeName': this.translateService.instant(ConstantMessages.Desc_Free_Group_Items_Value_On_Invoice_Percentage_Output_Type) });
      // }
    }
    if ((this.promotionType === PromotionTypes.FixedValues || this.promotionType === PromotionTypes.RangeValues || this.promotionType === PromotionTypes.StepsValues) && this.ConsiderStockStatusInOrderFlow) {
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel, 'typeName': this.translateService.instant(ConstantMessages.Desc_Summation_Over_Group_Output_Type_From_Sales_Order_Type) });
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel, 'typeName': this.translateService.instant(ConstantMessages.Desc_Group_Discount_Percentage_Output_Type_From_Sales_Order_Type) });
    }
    if ((this.promotionType === PromotionTypes.FixedValues || this.promotionType === PromotionTypes.RangeValues) && this.ConsiderStockStatusInOrderFlow) {
      this.outputDetailsTypesList.push({ 'typeId': PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel, 'typeName': this.translateService.instant(ConstantMessages.Desc_Fixed_Price_Over_Group_Output_Type_From_Sales_Order_Type) });
    }
  }
  onChangeFreeQuantityBasedPercentage() {
    (<FormArray>this.promotionEntryForm.get('inputs')).clear();
    (<FormArray>this.promotionEntryForm.get('outputs')).clear();
    if(this.promotionType === PromotionTypes.FixedValues){
      this.pushNewInputForm();
      this.pushNewOutputForm();
    }
    if(this.promotionType === PromotionTypes.RangeValues){
      this.pushNewRangeOption();
    }
    this.onClearAutoRangesDefinitionData();
    this.fillInputDetailsTypesList();
    this.fillOutputDetailsTypesList();
    if (this.freeQuantityToggle) {
      this.disableOutputFormInFreeQuantityForAutoRange();
    } else {
      this.enableOutputFormInFreeQuantityForAutoRange();
    }
  }
  disableOutputFormInFreeQuantityForAutoRange(){
    this.autoRangeOutputTypeControl.disable();
    this.autoRangeOutputSelectionControl.disable();
  }
  enableOutputFormInFreeQuantityForAutoRange(){
    this.autoRangeOutputTypeControl.enable();
    this.autoRangeOutputSelectionControl.enable();
  }
  fillTargetModes() {
    this.targetModesList = [];
    this.targetModesList.push({ 'modeId': TargetModes.Accumulative, 'modeName': this.translateService.instant(ConstantMessages.Desc_Accumulative) });
    this.targetModesList.push({ 'modeId': TargetModes.LastInvoice, 'modeName': this.translateService.instant(ConstantMessages.Desc_Last_Invoice) });
    if (this.promotionType == PromotionTypes.RangeValues)
      this.targetModesList.push({ 'modeId': TargetModes.LastInvoiceAccumulative, 'modeName': this.translateService.instant(ConstantMessages.Desc_Last_Invoice_Accumulative) });
  }
  fillSurveysList() {
    let promotionId = -1;
    if (this.isEditMode || this.isViewMode) {
      promotionId = this.promotionObject.promotionId;
    }
    this.surveyService.GetLinkedToPromotionSurveys(promotionId).subscribe(result => {
      this.surveysList = result.data;
    });
  }

  getOutputDetailTypeControl(detailForm) {
    return detailForm.get('outputDetailTypeId');
  }
  getOutputDetailSelectionIdControl(detailForm) {
    return detailForm.get('outputSelectedValueId');
  }
  isStockDigitOutput(detailForm) {
    var detailTypeValue = this.getOutputDetailTypeControl(detailForm).value;
    if (detailTypeValue &&
      (detailTypeValue === PromotionOutputDetailTypes.ItemQuantity
      || detailTypeValue === PromotionOutputDetailTypes.SummationOverGroup || detailTypeValue === PromotionOutputDetailTypes.GroupEqualQuantity
      || detailTypeValue === PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel
      || detailTypeValue === PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems
      || detailTypeValue === PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems)) {
      return true;
    }
    else {
      return false;
    }
  }
  isDigitOutput(detailForm) {
    var detailTypeValue = this.getOutputDetailTypeControl(detailForm).value;
    if (detailTypeValue &&
      (detailTypeValue === PromotionOutputDetailTypes.DiscountAmountForItem || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForItem
        || detailTypeValue === PromotionOutputDetailTypes.AllItemDiscountAmount || detailTypeValue === PromotionOutputDetailTypes.AllItemDiscountPercentage
        || detailTypeValue === PromotionOutputDetailTypes.DiscountAmountOverTransaction
        || detailTypeValue === PromotionOutputDetailTypes.DiscountAmountForGroupItems || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForGroupItems || detailTypeValue === PromotionOutputDetailTypes.DiscountAmountOverGroup
        || detailTypeValue === PromotionOutputDetailTypes.FreeItemsWithCertainValue || detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverGroup
        || detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverAllItem || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount
        || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel || detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel
        || detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverItem || detailTypeValue === PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage)) {
      return true;
    }
    else {
      return false;
    }
  }
  isPackGroupOutput(detailForm) {
    var detailTypeValue = this.getOutputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionOutputDetailTypes.SummationOverGroup || detailTypeValue === PromotionOutputDetailTypes.GroupEqualQuantity
      || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForGroupItems || detailTypeValue === PromotionOutputDetailTypes.DiscountAmountForGroupItems || detailTypeValue === PromotionOutputDetailTypes.DiscountAmountOverGroup
      || detailTypeValue === PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems
      || detailTypeValue === PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage || detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverGroup
      || detailTypeValue === PromotionOutputDetailTypes.OpenSteps || detailTypeValue === PromotionOutputDetailTypes.DynamicTargetSummationOverGroup
      || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount || detailTypeValue === PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel
      || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel || detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel)) {
        return true;
    }
    else {
      return false;
    }
  }
  isItemOutput(detailForm) {
    var detailTypeValue = this.getOutputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionOutputDetailTypes.ItemQuantity || detailTypeValue === PromotionOutputDetailTypes.DiscountAmountForItem || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForItem ||
      detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverItem || detailTypeValue === PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems)) {
      return true;
    }
    else {
      return false;
    }
  }
  isOptionalItemOutput(detailForm) {
    var detailTypeValue = this.getOutputDetailTypeControl(detailForm).value;
    if (detailTypeValue && detailTypeValue === PromotionOutputDetailTypes.FreeItemsWithCertainValue) {
      return true;
    }
    else {
      return false;
    }
  }
  isSalesOrderOutput(detailForm) {
    var detailTypeValue = this.getOutputDetailTypeControl(detailForm).value;
    if (this.ConsiderStockStatusInOrderFlow && detailTypeValue && (detailTypeValue === PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel
      || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel
      || detailTypeValue === PromotionOutputDetailTypes.FixedPriceOverGroupOnTypeLevel)) {
      return true;
    }
    else {
      return false;
    }
  }
  isLoyaltyPoints() {
    if (this.isLoyaltyPromotion && this.promotionModeId == LoyaltyModes.PointsLoyaltyPromotion.valueOf()) {
      return true;
    }
    return false;
  }
  isDiscountPercentageOutput(detailForm) {
    var detailTypeValue = this.getOutputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForItem || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForGroupItems || detailTypeValue === PromotionOutputDetailTypes.AllItemDiscountPercentage
      || detailTypeValue === PromotionOutputDetailTypes.RetailContractDiscount || detailTypeValue === PromotionOutputDetailTypes.WholesalesContractsDiscount || detailTypeValue === PromotionOutputDetailTypes.DynamicTargetDiscount
      || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageForGroupItemsOnTypeLevel)) {
      return true;
    }
    else {
      return false;
    }
  }
  isOutputNeedsUserSelection(detailForm) {
    var detailTypeValue = this.getOutputDetailTypeControl(detailForm).value;
    if (detailTypeValue && (detailTypeValue === PromotionOutputDetailTypes.SummationOverGroup || detailTypeValue === PromotionOutputDetailTypes.FreeItemsWithCertainValue || detailTypeValue === PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage || detailTypeValue === PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount)) {
      return true;
    }
    else {
      return false;
    }
  }
  onChangeOutputDetailType(detail) {
    // reset filled selection and value
    detail.get('outputValue').reset();
    detail.get('packGroupDetails').setValue([]);

    // selected pack group must not change for bundle
    if (!this.isBundle) {
      detail.get('outputSelectedValueId').reset();
      if (this.promotionType == PromotionTypes.SurveyPromotion) {
        detail.get('outputValue').setValue('-1');
        detail.get('outputValue').setValidators(Validators.nullValidator);
        detail.get('outputValue').updateValueAndValidity();
      }
      else {
        if (this.isDiscountPercentageOutput(detail)) {
          detail.get('outputValue').setValidators([Validators.required, Validators.min(0.0000001), Validators.max(100)]);
          detail.get('outputValue').updateValueAndValidity();
        } else {
          detail.get('outputValue').setValidators([Validators.required, Validators.min(0.0000001)]);
          detail.get('outputValue').updateValueAndValidity();
        }
      }
    }
    if (this.isItemOutput(detail) || this.isPackGroupOutput(detail)) {
      // set selection as required
      detail.get('outputSelectedValueId').setValidators(Validators.required);
      detail.get('outputSelectedValueId').updateValueAndValidity();
      if (this.promotionTypeControl.value === PromotionTypes.RangeValues &&
        this.isRelatedToTargetControl.value &&
        this.isRestrictUpperLimitControl.value &&
        this.getInputsForms().length === 1 &&
        this.getOutputsForms().length === 1 &&
        this.isPackGroupOutput(detail) &&
        this.isPackGroupInput(this.getInputFormDetails(this.getInputsForms()[0])[0])) {
        detail.get('outputSelectedValueId').disable();
        detail.get('outputSelectedValueId').setValue(this.getInputFormDetails(this.getInputsForms()[0])[0].get('inputSelectedValueId').value);
      }
    } else {
      // set selection as not required
      detail.get('outputSelectedValueId').setValidators(Validators.nullValidator);
      detail.get('outputSelectedValueId').updateValueAndValidity();
    }

    if (this.isSalesOrderOutput(detail)) {
      detail.get('outputSalesOrderTypeId').reset();
      detail.get('outputSalesOrderTypeId').setValidators(Validators.required);
      detail.get('outputSalesOrderTypeId').updateValueAndValidity();
    } else {
      detail.get('outputSalesOrderTypeId').setValidators(Validators.nullValidator);
      detail.get('outputSalesOrderTypeId').updateValueAndValidity();
    }
  }
  onChangeOutputDetailSelection(detail) {
    // reset filled value
    detail.get('outputValue').reset();
    if (this.isLoyaltyPoints()) {
      detail.get('outputValidityWidth').reset();
    }
    if (this.promotionType == PromotionTypes.SurveyPromotion) {
      detail.get('outputValue').setValue('-1');
      detail.get('outputValue').setValidators(Validators.nullValidator);
      detail.get('outputValue').updateValueAndValidity();
    }
  }
  getOutputsForms() {
    return (<FormArray>this.promotionEntryForm.get('outputs')).controls;
  }
  getOutputFormDetails(outputForm) {
    return (<FormArray>outputForm.get('details')).controls;
  }
  pushNewOutputForm() {
    // add new output with new detail by default
    let newOutputForm = new FormGroup({
      details: new FormArray([], Validators.required)
    });
    this.pushNewOutputDetailForm(newOutputForm);
    (<FormArray>this.promotionEntryForm.get('outputs')).push(newOutputForm);
  }
  removeOutputForm(outputIndex) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          (<FormArray>this.promotionEntryForm.get('outputs')).removeAt(outputIndex);
        }
      });
  }
  pushNewOutputDetailForm(outputForm) {
    if (this.promotionTypeControl.value === PromotionTypes.RangeValues) {
      if (this.showAutoRangeFillScreen) {
        // fill details from auto range and user can change them
        var isSelectionRequired = false;
        var isDiscountPercentageType = false;
        if (this.isItemOutput(this.promotionEntryForm.get('autoRangesForm')) || this.isPackGroupOutput(this.promotionEntryForm.get('autoRangesForm')) || this.isLoyaltyPoints()) {
          isSelectionRequired = true;
        }

        if (this.isDiscountPercentageOutput(this.promotionEntryForm.get('autoRangesForm'))) {
          isDiscountPercentageType = true;
        }

        var isAccumulativeRange = false;
        if (this.isRelatedToTarget && (this.targetModeId == 1 || this.targetModeId == 2 || this.targetModeId == 3)) {
          isAccumulativeRange = true;
        }
        (<FormArray>outputForm.get('details')).push(
          new FormGroup({
            outputDetailTypeId: new FormControl({ value: this.autoRangeOutputTypeControl.value, disabled: isAccumulativeRange || this.freeQuantityToggle }, Validators.required),
            outputSelectedValueId: new FormControl({ value: this.autoRangeOutputSelectionControl.value, disabled: isAccumulativeRange || this.freeQuantityToggle }, isSelectionRequired ? Validators.required : null),
            outputValue: new FormControl(this.autoRangeOutputValue, isDiscountPercentageType ? [Validators.required, Validators.min(0.000001), Validators.max(100)] : [Validators.required, Validators.min(0.0000001)]),
            outputValidityWidth: new FormControl(this.autoRangeOutputValidityWidthControl.value, this.isLoyaltyPoints() ? Validators.required : Validators.nullValidator),
            packGroupDetails: new FormControl([]),
            outputSalesOrderTypeId: new FormControl({ value: this.autoRangeOutputSalesOrderTypeControl.value, disabled: isAccumulativeRange }, Validators.nullValidator),
          })
        );
      }
      else {
        var isAccumulativeRange = false;
        var isSelectionRequired = false;
        var isDiscountPercentageType = false;
        if (this.isRelatedToTarget && (this.targetModeId == 1 || this.targetModeId == 2 || this.targetModeId == 3) && this.getOutputsForms().length >= 1) {
          isAccumulativeRange = true;
          var selectedOutputTypeId = this.getOutputFormDetails(this.getOutputsForms()[0])[0].get('outputDetailTypeId').value;
          var selectedOutputValueId = null;
          if (this.isItemOutput(this.getOutputFormDetails(this.getOutputsForms()[0])[0]) || this.isPackGroupOutput(this.getOutputFormDetails(this.getOutputsForms()[0])[0])) {
            isSelectionRequired = true;
            selectedOutputValueId = this.getOutputFormDetails(this.getOutputsForms()[0])[0].get('outputSelectedValueId').value;
          }
          if (this.isOptionalItemOutput(this.getOutputFormDetails(this.getOutputsForms()[0])[0])) {
            selectedOutputValueId = this.getOutputFormDetails(this.getOutputsForms()[0])[0].get('outputSelectedValueId').value;
          }
          if (this.isDiscountPercentageOutput(this.getOutputFormDetails(this.getOutputsForms()[0])[0])) {
            isDiscountPercentageType = true;
          }
        }
        if (this.isLoyaltyPoints()) {
          isSelectionRequired = true;
        }
        var isSalesOrderRequired = false;
        if (this.isRelatedToTarget && this.getOutputsForms().length >0 && this.isSalesOrderOutput(this.getOutputFormDetails(this.getOutputsForms()[0])[0])) {
          isSalesOrderRequired = true;
        }
        // add empty details
        (<FormArray>outputForm.get('details')).push(
          new FormGroup({
            outputDetailTypeId: new FormControl({ value: isAccumulativeRange ? selectedOutputTypeId : this.isLoyaltyPoints() ? PromotionOutputDetailTypes.CustomerPoints.valueOf() : null, disabled: isAccumulativeRange || this.freeQuantityToggle}, Validators.required),
            outputSelectedValueId: new FormControl({ value: isAccumulativeRange ? selectedOutputValueId : null, disabled: isAccumulativeRange || this.freeQuantityToggle }, isSelectionRequired ? Validators.required : null),
            outputValue: new FormControl(null, isDiscountPercentageType ? [Validators.required, Validators.min(0.000001), Validators.max(100)] : [Validators.required, Validators.min(0.0000001)]),
            outputValidityWidth: new FormControl(null, this.isLoyaltyPoints() ? Validators.required : Validators.nullValidator),
            packGroupDetails: new FormControl([]),
            outputSalesOrderTypeId: new FormControl(null,  isSalesOrderRequired ? Validators.required : Validators.nullValidator),
          })
        );
      }
    }
    else if (this.promotionTypeControl.value === PromotionTypes.StepsValues) {
      // output type will filled from step definition and user can't change it
      var isSelectionRequired = false;
      var isSelectionSalesOrderRequired = false;
      if (this.isSalesOrderOutput(this.mainStepEntryFormGroup)) {
        isSelectionSalesOrderRequired = true;
      }
      var isDiscountPercentageType = false;
      if (this.isItemOutput(this.mainStepEntryFormGroup) || this.isPackGroupOutput(this.mainStepEntryFormGroup) || this.isLoyaltyPoints()) {
        isSelectionRequired = true;
      }
      if (this.isDiscountPercentageOutput(this.mainStepEntryFormGroup)) {
        isDiscountPercentageType = true;
      }
      (<FormArray>outputForm.get('details')).push(
        new FormGroup({
          outputDetailTypeId: new FormControl(this.stepOutputTypeControl.value, Validators.required),
          // outputSelectedValueId: new FormControl({ value: (this.targetModeId == 1 || this.targetModeId == 2 || this.targetModeId == 3) ? this.stepOutputSelectionControl.value : null, disabled: (this.targetModeId == 1 || this.targetModeId == 2 || this.targetModeId == 3) }, isSelectionRequired ? Validators.required : null),
          outputSelectedValueId: new FormControl({ value: this.targetModeId == 1 ? this.stepOutputSelectionControl.value : null, disabled: this.targetModeId == 1 }, isSelectionRequired ? Validators.required : null),
          // outputSelectedValueId: new FormControl(null, Validators.nullValidator),
          outputValue: new FormControl(null, isDiscountPercentageType ? [Validators.required, Validators.min(0.000001), Validators.max(100)] : [Validators.required, Validators.min(0.0000001)]),
          outputValidityWidth: new FormControl(null, this.isLoyaltyPoints() ? Validators.required : Validators.nullValidator),
          packGroupDetails: new FormControl([]),
          outputSalesOrderTypeId: new FormControl(null, isSelectionSalesOrderRequired ? Validators.required : Validators.nullValidator)
        })
      );
    } else if (this.promotionTypeControl.value === PromotionTypes.FixedValues) {
      (<FormArray>outputForm.get('details')).push(
        new FormGroup({
          // disable pack group selection for bundles
          outputDetailTypeId: new FormControl({ value: this.isLoyaltyPoints() ? PromotionOutputDetailTypes.CustomerPoints.valueOf() : null, disabled: this.freeQuantityToggle },Validators.required),
          outputSelectedValueId: new FormControl({ value: null, disabled: this.isBundle || this.freeQuantityToggle }, Validators.required),
          outputValue: new FormControl(null, this.isBundle ? Validators.nullValidator : [Validators.required, Validators.min(0.0000001)]),
          outputValidityWidth: new FormControl(null, this.isLoyaltyPoints() ? Validators.required : Validators.nullValidator),
          packGroupDetails: new FormControl([], this.isBundle ? Validators.required : Validators.nullValidator),
          outputSalesOrderTypeId: new FormControl(null, Validators.nullValidator),
        })
      );
    } else if (this.promotionTypeControl.value === PromotionTypes.TargetPromotion) {
      var iswholeSales = this.targetInputTypeControl.value === PromotionInputDetailTypes.CustomerMonthlyWholesalesContracts;
      (<FormArray>outputForm.get('details')).push(
        new FormGroup({
          outputDetailTypeId: new FormControl({ value: iswholeSales ? PromotionOutputDetailTypes.WholesalesContractsDiscount : null, disabled: true }, Validators.required),
          outputSelectedValueId: new FormControl(null),
          outputValue: new FormControl(null, iswholeSales ? [Validators.required, Validators.min(0.0000001), Validators.max(100)] : [Validators.required, Validators.min(0.0000001)]),
          packGroupDetails: new FormControl([])
        })
      );
    } else if (this.promotionTypeControl.value === PromotionTypes.DynamicTargetPromotion) {
      var isPackGroupType = this.targetInputTypeControl.value === PromotionInputDetailTypes.DynamicTargetSummationOverGroup;
      (<FormArray>outputForm.get('details')).push(
        new FormGroup({
          outputDetailTypeId: new FormControl({ value: isPackGroupType ? PromotionOutputDetailTypes.DynamicTargetSummationOverGroup : PromotionOutputDetailTypes.DynamicTargetDiscount, disabled: true }, Validators.required),
          outputSelectedValueId: new FormControl({ value: isPackGroupType ? this.selectedTargetOutputSelectionId : null, disabled: isPackGroupType }, isPackGroupType ? Validators.required : Validators.nullValidator),
          outputValue: new FormControl(null, isPackGroupType ? ([Validators.required, Validators.min(0.0000001)]) : ([Validators.required, Validators.min(0.0000001), Validators.max(100)])),
          packGroupDetails: new FormControl([])
        })
      );
    } else if (this.promotionTypeControl.value === PromotionTypes.SurveyPromotion) {
      (<FormArray>outputForm.get('details')).push(
        new FormGroup({
          outputDetailTypeId: new FormControl(null, Validators.required),
          outputSelectedValueId: new FormControl(null, Validators.required),
          outputValue: new FormControl(-1, Validators.nullValidator),
          packGroupDetails: new FormControl([], Validators.nullValidator)
        })
      );
    }
  }
  removeOutputDetailForm(outputForm, detailIndex) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          (<FormArray>outputForm.get('details')).removeAt(detailIndex);
        }
      });
  }
  // #endregion

  //#region[Steps]

  fillStepDefinitionInEditMode() {
    this.stepInputSelectedObject = {};
    this.stepSelectionList = [];
    this.stepOutputSelectedObject = {};
    this.stepOutputSelectionList = [];
    if (this.promotionObject.promotionInputs && this.promotionObject.promotionInputs.length > 0) {
      // set input type
      this.stepInputTypeControl.setValue(this.promotionObject.promotionInputs[0].promotionOptionDetails[0].inputOptionDetailTypeId);

      this.stepInputTypeControl.setValidators(Validators.required);
      this.stepInputTypeControl.updateValueAndValidity();

      this.stepInputSelectionControl.setValidators(Validators.required);
      this.stepInputSelectionControl.updateValueAndValidity();

      this.stepOutputTypeControl.setValidators(Validators.required);
      this.stepOutputTypeControl.updateValueAndValidity();

      if (this.targetModeId == 1) {
        this.stepOutputSelectionControl.setValidators(Validators.required);
        this.stepOutputSelectionControl.updateValueAndValidity();
      }
      if (this.isSalesOrderInput(this.promotionEntryForm.get('stepEntryForm'))) {
        // set selection as not required
        this.stepInputSalesOrderTypeControl.setValidators(Validators.required);
        this.stepInputSalesOrderTypeControl.updateValueAndValidity();
      }
      if (this.isInvoiceInput(this.promotionEntryForm.get('stepEntryForm'))) {
        // set selection as not required
        this.stepInputSelectionControl.setValidators(Validators.nullValidator);
        this.stepInputSelectionControl.updateValueAndValidity();
      } else {
        var selectedValueId = null;
        var selectedSalesOrder = null;
        if (this.isItemLevelInput(this.promotionEntryForm.get('stepEntryForm'))) {
          selectedValueId = this.promotionObject.promotionInputs[0].promotionOptionDetails[0].itemId;
        } else if (this.isItemInput(this.promotionEntryForm.get('stepEntryForm'))) {
          selectedValueId = this.promotionObject.promotionInputs[0].promotionOptionDetails[0].packId;
        } else if (this.isPackGroupInput(this.promotionEntryForm.get('stepEntryForm'))) {
          selectedValueId = this.promotionObject.promotionInputs[0].promotionOptionDetails[0].packGroupId;
        } else if (this.isPackTypeInput(this.promotionEntryForm.get('stepEntryForm'))) {
          selectedValueId = this.promotionObject.promotionInputs[0].promotionOptionDetails[0].packTypeId;
        } else if (this.isDivisionInput(this.promotionEntryForm.get('stepEntryForm'))) {
          selectedValueId = this.promotionObject.promotionInputs[0].promotionOptionDetails[0].divisionId;
        }
        this.stepInputSelectionControl.setValue(selectedValueId);
        // this list is used as disabled data source, so the description of selected value cashed in back-end and viewd in the list
        this.stepInputSelectedObject = {
          selectionId: selectedValueId,
          description: this.promotionObject.stepInputSelectionDescription
        };
        if (this.isSalesOrderInput(this.promotionEntryForm.get('stepEntryForm'))) {
          var salesTypesList = [];
          selectedSalesOrder = this.promotionObject.promotionInputs[0].promotionOptionDetails[0].salesOrderTypeId;
          this.promotionEntryForm.get('stepEntryForm').get('inputSalesOrderTypeId').setValidators(Validators.required);
          this.promotionEntryForm.get('stepEntryForm').get('inputSalesOrderTypeId').updateValueAndValidity();
          this.salesOrderTypeList.forEach(x => {
            if (selectedSalesOrder.includes(x.salesOrderTypeId.toString())) {
              salesTypesList.push({ salesOrderTypeId: x.salesOrderTypeId, salesOrderTypeName: x.salesOrderTypeName });
            }
          })
        }
        this.stepInputSalesOrderTypeControl.setValue(salesTypesList);
        this.stepSelectionList.push(this.stepInputSelectedObject)
      }
    }
    if (this.promotionObject.promotionOutputs && this.promotionObject.promotionOutputs.length > 0) {
      this.stepOutputTypeControl.setValue(this.promotionObject.promotionOutputs[0].promotionOptionDetails[0].outputOptionDetailTypeId);
      if (this.targetModeId == 1) {
        var selectedOutputValueId = null;
        if (this.isItemOutput(this.promotionEntryForm.get('stepEntryForm')) || this.isOptionalItemOutput(this.promotionEntryForm.get('stepEntryForm'))) {
          selectedOutputValueId = this.promotionObject.promotionOutputs[0].promotionOptionDetails[0].packId;
        } else if (this.isPackGroupOutput(this.promotionEntryForm.get('stepEntryForm'))) {
          selectedOutputValueId = this.promotionObject.promotionOutputs[0].promotionOptionDetails[0].packGroupId;
        }
        this.stepOutputSelectionControl.setValue(selectedOutputValueId);
        // this list is used as disabled data source, so the description of selected value cashed in back-end and viewd in the list
        this.stepOutputSelectedObject = {
          selectionId: selectedOutputValueId,
          description: this.promotionObject.stepOutputSelectionDescription
        };
        this.stepOutputSelectionList.push(this.stepOutputSelectedObject)
      }
    }
    if (this.promotionObject.promotionInputs && this.promotionObject.promotionInputs.length > 0) {
      // disable step definition after filling it
      this.stepInputTypeControl.disable({ onlySelf: true, emitEvent: false });
      this.stepInputSelectionControl.disable({ onlySelf: true, emitEvent: false });
      this.stepInputSalesOrderTypeControl.disable({ onlySelf: true, emitEvent: false });
      this.stepOutputTypeControl.disable({ onlySelf: true, emitEvent: false });
      if (this.targetModeId == 1) {
        this.stepOutputSelectionControl.disable({ onlySelf: true, emitEvent: false });
        this.stepOutputSelectionControl.updateValueAndValidity();
      }
    }
  }
  onChangeStepInputDetailType(detail) {
    this.stepInputSelectedObject = {};
    // reset filled selection
    detail.get('inputSelectedValueId').reset();
    if (this.isInvoiceInput(detail)) {
      // set selection as not required
      detail.get('inputSelectedValueId').setValidators(Validators.nullValidator);
      detail.get('inputSelectedValueId').updateValueAndValidity();
    } else {
      // set selection as required
      detail.get('inputSelectedValueId').setValidators(Validators.required);
      detail.get('inputSelectedValueId').updateValueAndValidity();
    }
  }
  onChangeStepInputItem(item) {
    this.stepInputSelectedObject = {};
    this.stepInputSelectedObject = {
      selectionId: item.packId,
      description: item.itemCodeName
    };
  }
  onChangeStepInputPackGroup(group) {
    this.stepInputSelectedObject = {};
    this.stepInputSelectedObject = {
      selectionId: group.packGroupId,
      description: group.packGroupCodeName
    };
  }
  onChangeStepInputDivision(division) {
    this.stepInputSelectedObject = {};
    this.stepInputSelectedObject = {
      selectionId: division.divisionId,
      description: division.divisionCodeName
    };
  }
  onChangeStepInputUOM(UOM) {
    this.stepInputSelectedObject = {};
    this.stepInputSelectedObject = {
      selectionId: UOM.packTypeId,
      description: UOM.packTypeName
    };
  }
  onChangeStepInputSalesOrderType(salesOrderType) {
    this.stepInputSelectedObject = {};
    this.stepInputSelectedObject = {
      selectionId: salesOrderType.salesOrderTypeId,
      description: salesOrderType.salesOrderTypeName
    };
  }
  onChangeStepOutputDetailType(detail) {
    this.stepOutputSelectedObject = {};
    // reset filled selection
    detail.get('outputSelectedValueId').reset();
    detail.get('outputSelectedValueId').setValidators(Validators.nullValidator);
    if (this.isRelatedToTarget && this.isItemOutput(detail) || this.isPackGroupOutput(detail)) {
      // set selection as required
      if (this.targetModeId == 1)
        detail.get('outputSelectedValueId').setValidators(Validators.required);
    }
    detail.get('outputSelectedValueId').updateValueAndValidity();
  }
  onChangeStepOutputItem(item) {
    this.stepOutputSelectedObject = {};
    this.stepOutputSelectedObject = {
      selectionId: item.packId,
      description: item.itemCodeName
    };
  }
  onChangeStepOutputPackGroup(group) {
    this.stepOutputSelectedObject = {};
    this.stepOutputSelectedObject = {
      selectionId: group.packGroupId,
      description: group.packGroupCodeName
    };
  }
  get mainStepEntryFormGroup() {
    return this.promotionEntryForm.get('stepEntryForm');
  }
  get stepInputTypeControl() {
    return this.promotionEntryForm.get('stepEntryForm').get('inputDetailTypeId');
  }
  get stepInputSelectionControl() {
    return this.promotionEntryForm.get('stepEntryForm').get('inputSelectedValueId');
  }
  get stepInputSalesOrderTypeControl() {
    return this.promotionEntryForm.get('stepEntryForm').get('inputSalesOrderTypeId');
  }
  get stepOutputTypeControl() {
    return this.promotionEntryForm.get('stepEntryForm').get('outputDetailTypeId');
  }
  get stepOutputSelectionControl() {
    return this.promotionEntryForm.get('stepEntryForm').get('outputSelectedValueId');
  }
  get stepOutputSalesOrderTypeControl() {
    return this.promotionEntryForm.get('stepEntryForm').get('outputSalesOrderTypeId');
  }

  pushNewStep() {
    this.coreSession.markFormGroupTouched(this.promotionEntryForm);

    // Validate step defintion before adding first step
    if (this.promotionEntryForm.get('stepEntryForm').invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    if (this.getInputsForms().length === 0) {
      // fill disables list with selected according to selected object
      this.stepSelectionList = [];
      this.stepSelectionList.push(this.stepInputSelectedObject)
    }
    if (this.getInputsForms().length > 0) {
      // all steps must be valid before adding new one
      if (this.promotionEntryForm.get('inputs').invalid || this.promotionEntryForm.get('outputs').invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillPromotionDetailsCorrectly));
        return;
      }
    }
    if (this.targetModeId == 1 && this.getOutputsForms().length === 0) {
      // fill disables list with selected according to selected object
      this.stepOutputSelectionList = [];
      this.stepOutputSelectionList.push(this.stepOutputSelectedObject)
    }
    if (this.getOutputsForms().length > 0) {
      // all steps must be valid before adding new one
      if (this.promotionEntryForm.get('inputs').invalid || this.promotionEntryForm.get('outputs').invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillPromotionDetailsCorrectly));
        return;
      }
    }

    // push one step -> must adding one input and one output
    this.pushNewInputForm();
    this.pushNewOutputForm();

    // after adding first step set main step as disable to prevent change step type
    if (this.getInputsForms().length === 1) {
      this.stepInputTypeControl.disable({ onlySelf: true, emitEvent: false });
      this.stepInputSelectionControl.disable({ onlySelf: true, emitEvent: false });
      this.stepInputSalesOrderTypeControl.disable({ onlySelf: true, emitEvent: false });
      this.stepOutputTypeControl.disable({ onlySelf: true, emitEvent: false });
      if (this.targetModeId == 1) {
        this.stepOutputSelectionControl.disable({ onlySelf: true, emitEvent: false });
        this.stepOutputSelectionControl.updateValueAndValidity();
      }
    }
  }
  removeStep(index) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          (<FormArray>this.promotionEntryForm.get('inputs')).removeAt(index);
          (<FormArray>this.promotionEntryForm.get('outputs')).removeAt(index);
          if (this.getInputsForms().length === 0) {
            this.stepInputTypeControl.enable({ onlySelf: true, emitEvent: false });
            this.stepInputSelectionControl.enable({ onlySelf: true, emitEvent: false });
            this.stepInputSalesOrderTypeControl.enable({ onlySelf: true, emitEvent: false });
            this.stepOutputTypeControl.enable({ onlySelf: true, emitEvent: false });
            if (this.targetModeId == 1) {
              this.stepOutputSelectionControl.enable({ onlySelf: true, emitEvent: false });
              this.stepOutputSelectionControl.updateValueAndValidity();
            }
          }
        }
      });
  }
  onClearStepDefinitionData() {
    if (this.getInputsForms().length > 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearStepDefinitionConfimation), DialogMode.YesNo).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.clearStepDefinition();
          }
        });
    } else {
      this.clearStepDefinition();
    }
  }
  clearStepDefinition() {
    (<FormArray>this.promotionEntryForm.get('inputs')).clear();
    (<FormArray>this.promotionEntryForm.get('outputs')).clear();

    this.stepInputTypeControl.enable({ onlySelf: true, emitEvent: false });
    this.stepInputSelectionControl.enable({ onlySelf: true, emitEvent: false });
    this.stepInputSalesOrderTypeControl.enable({ onlySelf: true, emitEvent: false });
    this.stepOutputTypeControl.enable({ onlySelf: true, emitEvent: false });
    if (this.targetModeId == 1)
      this.stepOutputSelectionControl.enable({ onlySelf: true, emitEvent: false });
    this.stepInputTypeControl.reset();
    this.stepInputSelectionControl.reset();
    this.stepInputSalesOrderTypeControl.reset();
    this.stepOutputTypeControl.reset();
    if (this.targetModeId == 1)
      this.stepOutputSelectionControl.reset();
  }
  //#endregion

  //#region[Ranges]
  get autoRangeInputTypeControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('inputDetailTypeId');
  }
  get autoRangeInputSelectionControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('inputSelectedValueId');
  }
  get autoRangeInputValueControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('inputValue');
  }
  get autoRangeInputValueRangeControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('inputValueRange');
  }
  get autoRangeInputRangeWidthControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('inputRangeWidth');
  }
  get autoRangeSalesOrderTypeControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('inputSalesOrderTypeId');
  }
  get autoRangeOutputTypeControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('outputDetailTypeId');
  }
  get autoRangeOutputSelectionControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('outputSelectedValueId');
  }
  get autoRangeOutputValueControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('outputValue');
  }
  get autoRangeOutputIncrementByControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('outputIncrementBy');
  }
  get autoRangeOutputValidityWidthControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('outputValidityWidth');
  }
  get autoRangeOutputSalesOrderTypeControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('outputSalesOrderTypeId');
  }
  get autoRangesIncrementDecrementControl() {
    return this.promotionEntryForm.get('autoRangesForm').get('incrementDecrementOutputStartValue');
  }
  get autoRangeFromGroup() {
    return this.promotionEntryForm.get('autoRangesForm');
  }
  onClearAllRangesClick() {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.clearAllRanges();
        }
      });
  }
  clearAllRanges() {
    if (this.showAutoRangeFillScreen) {
      this.onCloseAutoRangesFill();
    }
    (<FormArray>this.promotionEntryForm.get('inputs')).clear();
    (<FormArray>this.promotionEntryForm.get('outputs')).clear();
    this.pushNewRangeOption();
  }
  onChangeAutoRangeInputDetailType() {
    // salwa
    // reset filled selection and values
    this.autoRangeInputValueControl.reset();
    this.autoRangeInputValueRangeControl.reset();
    this.autoRangeInputRangeWidthControl.reset();
    this.autoRangeInputSelectionControl.reset();
    this.autoRangeSalesOrderTypeControl.reset();

    this.autoRangeInputValueControl.setValidators([Validators.required, Validators.min(0.0000001)]);
    this.autoRangeInputValueControl.updateValueAndValidity();
    this.autoRangeInputValueRangeControl.setValidators([Validators.required, Validators.min(0.0000001)]);
    this.autoRangeInputValueRangeControl.updateValueAndValidity();
    this.autoRangeInputRangeWidthControl.setValidators([Validators.required, Validators.min(0.0000001)]);
    this.autoRangeInputRangeWidthControl.updateValueAndValidity();
    this.autoRangeOutputTypeControl.reset();
    this.autoRangeOutputSelectionControl.reset();

    if(this.freeQuantityToggle){
      if (this.autoRangeInputTypeControl.value === PromotionInputDetailTypes.ItemQuantity) {
        this.autoRangeOutputTypeControl.setValue(PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems.valueOf());
      }
      else if (this.autoRangeInputTypeControl.value === PromotionInputDetailTypes.SummationOverGroup) {
        this.autoRangeOutputTypeControl.setValue(PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems.valueOf());
      }
      this.onChangeAutoRangeOutputDetailType();
    }

    if (this.autoRangeInputTypeControl.value == PromotionInputDetailTypes.SummationOverGroupOnTypeLevel.valueOf() || this.autoRangeInputTypeControl.value == PromotionInputDetailTypes.InvoiceAmountOnPackGroupOnTypeLevel.valueOf()) {
      this.autoRangeSalesOrderTypeControl.setValidators(Validators.required);
      this.autoRangeSalesOrderTypeControl.updateValueAndValidity();
    } else {
      this.autoRangeSalesOrderTypeControl.setValidators(Validators.nullValidator);
      this.autoRangeSalesOrderTypeControl.updateValueAndValidity();
    }


    if (this.isInvoiceInput(this.autoRangeFromGroup)) {
      // set selection as not required
      this.autoRangeInputSelectionControl.setValidators(Validators.nullValidator);
      this.autoRangeInputSelectionControl.updateValueAndValidity();
    } else {
      // set selection as required
      this.autoRangeInputSelectionControl.setValidators(Validators.required);
      this.autoRangeInputSelectionControl.updateValueAndValidity();
    }
  }
  onChangeAutoRangeInputDetailSelection(detail) {
    this.autoRangeInputValueControl.reset();
    this.autoRangeInputValueRangeControl.reset();
    this.autoRangeInputRangeWidthControl.reset();
    this.autoRangeSalesOrderTypeControl.reset();
    if(this.freeQuantityToggle){
      this.autoRangeOutputSelectionControl.setValue(this.autoRangeInputSelectionControl.value);
      this.onChangeAutoRangeOutputDetailSelection();
    }
    if(this.promotionTypeControl.value === PromotionTypes.RangeValues &&
      this.isRelatedToTargetControl.value &&
      this.isRestrictUpperLimitControl.value){
        this.autoRangeOutputTypeControl.reset();
        this.onChangeAutoRangeOutputDetailType();
    }
  }
  onChangeAutoRangeOutputDetailType() {
    this.autoRangeOutputValueControl.reset();
    this.autoRangeOutputSelectionControl.reset();
    this.autoRangeOutputIncrementByControl.reset();

    if (this.isDiscountPercentageOutput(this.autoRangeFromGroup)) {
      this.autoRangeOutputValueControl.setValidators([Validators.required, Validators.min(0.0000001), Validators.max(100)]);
      this.autoRangeOutputValueControl.updateValueAndValidity();
      this.autoRangeOutputIncrementByControl.setValidators([Validators.required, Validators.min(0.0000001), Validators.max(100)]);
      this.autoRangeOutputIncrementByControl.updateValueAndValidity();
    } else {
      this.autoRangeOutputValueControl.setValidators([Validators.required, Validators.min(0.0000001)]);
      this.autoRangeOutputValueControl.updateValueAndValidity();
      this.autoRangeOutputIncrementByControl.setValidators([Validators.required, Validators.min(0.0000001)]);
      this.autoRangeOutputIncrementByControl.updateValueAndValidity();
    }
    if (this.isItemOutput(this.autoRangeFromGroup) || this.isPackGroupOutput(this.autoRangeFromGroup)) {
      // set selection as required
      this.autoRangeOutputSelectionControl.setValidators(Validators.required);
      this.autoRangeOutputSelectionControl.updateValueAndValidity();
      if (this.promotionTypeControl.value === PromotionTypes.RangeValues &&
        this.isRelatedToTargetControl.value &&
        this.isRestrictUpperLimitControl.value &&
        this.isPackGroupOutput(this.autoRangeFromGroup) &&
        this.isPackGroupInput(this.autoRangeFromGroup)) {
          this.autoRangeOutputSelectionControl.disable();
          this.autoRangeOutputSelectionControl.setValue(this.autoRangeInputSelectionControl.value);
      }
    } else {
      // set selection as not required
      this.autoRangeOutputSelectionControl.setValidators(Validators.nullValidator);
      this.autoRangeOutputSelectionControl.updateValueAndValidity();
    }
    if (this.isSalesOrderOutput(this.autoRangeFromGroup)) {
      // set selection as required
      this.autoRangeOutputSalesOrderTypeControl.setValidators(Validators.required);
      this.autoRangeOutputSalesOrderTypeControl.updateValueAndValidity();
    } else {
      // set selection as not required
      this.autoRangeOutputSalesOrderTypeControl.setValidators(Validators.nullValidator);
      this.autoRangeOutputSalesOrderTypeControl.updateValueAndValidity();
    }
  }
  onChangeAutoRangeOutputDetailSelection() {
    // reset filled value
    this.autoRangeOutputValueControl.reset();
    this.autoRangeOutputIncrementByControl.reset();
    this.autoRangeOutputSalesOrderTypeControl.reset();
  }
  openAutoRanges() {
    this.promotionEntryForm.get('autoRangesForm').reset();
    (<any>Object).values((this.promotionEntryForm.get('autoRangesForm') as FormGroup).controls).forEach(control => {
      if (control == this.autoRangeOutputValidityWidthControl) {
        if (this.isLoyaltyPoints()) {
          control.setValidators(Validators.required);
          this.autoRangeOutputTypeControl.setValue(PromotionOutputDetailTypes.CustomerPoints.valueOf());
        } else {
          control.setValidators(Validators.nullValidator);
        }
        control.updateValueAndValidity();

      } else {
        control.setValidators(Validators.required);
        control.updateValueAndValidity();
      }
    });
    this.autoRangesIncrementDecrementControl.setValue(1);
    this.showAutoRangeFillScreen = true;
  }
  repeatDigits(text: string, padChar: string, size: number): string {
    return (String(padChar).repeat(size) + text).substr((size * -1), size);
  }
  onSaveAutoRange() {
    this.autoRangeInputValueStart = 0;
    this.autoRangeInputValueEnd = 0;
    this.autoRangeOutputValue = 0;

   this.coreSession.markFormGroupTouched(this.promotionEntryForm.get('autoRangesForm') as FormGroup);
    if (this.promotionEntryForm.get('autoRangesForm').invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }

    var inputStartValue = +this.autoRangeInputValueControl.value;
    var inputEndValue = +this.autoRangeInputValueRangeControl.value;
    var rangeWidth = +this.autoRangeInputRangeWidthControl.value;

    var outputStartValue = +this.autoRangeOutputValueControl.value;
    var outputIncrementedByValue = +this.autoRangeOutputIncrementByControl.value;

    // Validate values (From-To)
    if (inputStartValue >= inputEndValue) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgStartShouldLessThanEnd));
      return;
    }

    // Validate Range
    var rangeLength = (inputEndValue - inputStartValue) + 1;
    if (rangeLength % rangeWidth != 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgInvalidPromotionRange));
      return;
    }

    // Validate Discount Percentage for all options
    var optionsCount = rangeLength / rangeWidth;
    if (this.isDiscountPercentageOutput(this.promotionEntryForm.get('autoRangesForm'))) {
      var discountValueForLastOption = ((optionsCount - 1) * outputIncrementedByValue) + outputStartValue;
      if (discountValueForLastOption > 100) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgInvalidDiscountPercentage_Rang));
        return;
      }
    }

    // Validate change in value in case of decrement
    if (this.autoRangesIncrementDecrementControl.value == 2) {
      let outputEndValue = outputStartValue - (outputIncrementedByValue * (optionsCount - 1));
      if (outputEndValue <= 0) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgInvalidChangeValuePerRange));
        return;
      }
      outputIncrementedByValue = outputIncrementedByValue * -1;
    }

    // Generate options from auto range
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgApplyAutoRangeConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.generatePromotionOptionsFromAutoRange(inputStartValue, rangeWidth, outputStartValue, outputIncrementedByValue, optionsCount);
        }
      });
  }
  generatePromotionOptionsFromAutoRange(inputStartValue, rangeWidth, outputStartValue, outputIncrementedByValue, optionsCount) {
    (<FormArray>this.promotionEntryForm.get('inputs')).clear();
    (<FormArray>this.promotionEntryForm.get('outputs')).clear();

    // get upper value by adding : 0.99 or 0.999 .. according to digit / stock digits format
    var upperLimitString = '0.'.concat(this.repeatDigits('', '9', this.isStockDigitInput(this.autoRangeFromGroup) ? this.numberOfStockDigitsFormat : this.numberOfDigitsFormat));
    var upperLimitValue = +upperLimitString;

    this.autoRangeInputValueStart = inputStartValue;
    this.autoRangeInputValueEnd = this.autoRangeInputValueStart + rangeWidth - 1 + upperLimitValue;
    this.autoRangeOutputValue = outputStartValue;

    if (this.isStockDigitInput(this.autoRangeFromGroup)) {
      this.autoRangeInputValueEnd = this.calculationService.getNumberOnStockDigitFormat(this.autoRangeInputValueEnd);
    } else {
      this.autoRangeInputValueEnd = this.calculationService.getNumberOnDigitFormat(this.autoRangeInputValueEnd);
    }

    for (let index = 1; index <= optionsCount; index++) {
      // push one input and one output
      this.pushNewInputForm();
      this.pushNewOutputForm();

      //increase values to next range
      this.autoRangeInputValueStart += rangeWidth;
      this.autoRangeInputValueEnd += rangeWidth;
      this.autoRangeOutputValue += outputIncrementedByValue;

      // Round values
      if (this.isStockDigitInput(this.autoRangeFromGroup)) {
        this.autoRangeInputValueStart = this.calculationService.getNumberOnStockDigitFormat(this.autoRangeInputValueStart);
        this.autoRangeInputValueEnd = this.calculationService.getNumberOnStockDigitFormat(this.autoRangeInputValueEnd);
        this.autoRangeOutputValue = this.calculationService.getNumberOnStockDigitFormat(this.autoRangeOutputValue);
      } else {
        this.autoRangeInputValueStart = this.calculationService.getNumberOnDigitFormat(this.autoRangeInputValueStart);
        this.autoRangeInputValueEnd = this.calculationService.getNumberOnDigitFormat(this.autoRangeInputValueEnd);
        this.autoRangeOutputValue = this.calculationService.getNumberOnDigitFormat(this.autoRangeOutputValue);
      }
    }
    this.onCloseAutoRangesFill();
  }
  onCloseAutoRangesFill() {
    this.autoRangeInputValueStart = 0;
    this.autoRangeInputValueEnd = 0;
    this.autoRangeOutputValue = 0;
    this.promotionEntryForm.get('autoRangesForm').reset();
    this.showAutoRangeFillScreen = false;
    (<any>Object).values((this.promotionEntryForm.get('autoRangesForm') as FormGroup).controls).forEach(control => {
      control.setValidators(null);
      control.updateValueAndValidity();
    });
  }
  onClearAutoRangesDefinitionData() {
    this.promotionEntryForm.get('autoRangesForm').reset();
  }
  pushNewRangeOption() {
    // push new input and new output
    if (this.isRelatedToTarget && (this.targetModeId == 1 || this.targetModeId == 2 || this.targetModeId == 3) && this.getInputsForms().length > 0) {
      // all options must be valid before adding new one
      if (this.promotionEntryForm.get('inputs').invalid || this.promotionEntryForm.get('outputs').invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillPromotionDetailsCorrectly));
        return;
      }
    }
    this.pushNewInputForm();
    this.pushNewOutputForm();
    if (this.isRelatedToTarget && (this.targetModeId == 1 || this.targetModeId == 2 || this.targetModeId == 3) && this.getInputsForms().length > 1 && !this.getInputsForms()[0].invalid) {
      this.getInputFormDetails(this.getInputsForms()[0])[0].get('inputDetailTypeId').disable();
      this.getInputFormDetails(this.getInputsForms()[0])[0].get('inputSelectedValueId').disable();
    }
    if (this.isRelatedToTarget && (this.targetModeId == 1 || this.targetModeId == 2 || this.targetModeId == 3) && this.getOutputsForms().length > 1 && !this.getOutputsForms()[0].invalid) {
      this.getOutputFormDetails(this.getOutputsForms()[0])[0].get('outputDetailTypeId').disable();
      if (this.targetModeId == 1)
        this.getOutputFormDetails(this.getOutputsForms()[0])[0].get('outputSelectedValueId').disable();
    }
}
  removeRangeOption(index) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          // remove input and output
          (<FormArray>this.promotionEntryForm.get('inputs')).removeAt(index);
          (<FormArray>this.promotionEntryForm.get('outputs')).removeAt(index);
        }
      });
  }

  //#endregion

  //#region [Targets Promotion]
  clearTargetPromotionDetailsClick() {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.clearTargetPromotionDetails();
        }
      });
  }
  clearTargetPromotionDetails() {
    (<FormArray>this.promotionEntryForm.get('inputs')).clear();
    (<FormArray>this.promotionEntryForm.get('outputs')).clear();
    this.pushNewTargetPromotion();
  }
  pushNewTargetPromotion() {
    var isValidToFillTargets = false;
    if (this.targetInputTypeControl.valid && this.targetInputTypeControl.value && this.targetOutputSelectionControl.valid) {
      if (this.promotionType === PromotionTypes.TargetPromotion) {
        isValidToFillTargets = true;
      } else {
        if (this.targetInputTypeControl.value === PromotionInputDetailTypes.DynamicTargetSalesAmount) {
          isValidToFillTargets = true;
        }
        if (this.targetInputTypeControl.value === PromotionInputDetailTypes.DynamicTargetSummationOverGroup && this.targetInputSelectionControl.value && this.targetOutputSelectionControl.value) {
          isValidToFillTargets = true;
        }
      }
      if (isValidToFillTargets) {
        this.pushNewInputForm();
        this.pushNewOutputForm();
      }
    }
  }
  pushNewTargetOption() {
    this.coreSession.markFormGroupTouched(this.promotionEntryForm);
    if (this.getInputsForms().length > 0) {
      // all options must be valid before adding new one
      if (this.promotionEntryForm.get('inputs').invalid || this.promotionEntryForm.get('outputs').invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillPromotionDetailsCorrectly));
        return;
      }
    }
    this.pushNewInputForm();
    this.pushNewOutputForm();
  }
  removeTargetOption(index) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          (<FormArray>this.promotionEntryForm.get('inputs')).removeAt(index);
          (<FormArray>this.promotionEntryForm.get('outputs')).removeAt(index);
        }
      });
  }
  //#endregion

  downloadFile(fileName, isEditMode: boolean) {
    //file type extension
    if (isEditMode) {
      let checkFileType = fileName.split('.').pop();
      var fileType;
      if (checkFileType == "txt") {
        fileType = "text/plain";
      }
      if (checkFileType == "pdf") {
        fileType = "application/pdf";
      }
      if (checkFileType == "doc") {
        fileType = "application/vnd.ms-word";
      }
      if (checkFileType == "docx") {
        fileType = "application/vnd.ms-word";
      }
      if (checkFileType == "xls") {
        fileType = "application/vnd.ms-excel";
      }
      if (checkFileType == "png") {
        fileType = "image/png";
      }
      if (checkFileType == "jpg") {
        fileType = "image/jpeg";
      }
      if (checkFileType == "jpeg") {
        fileType = "image/jpeg";
      }
      if (checkFileType == "gif") {
        fileType = "image/gif";
      }
      if (checkFileType == "csv") {
        fileType = "text/csv";
      }

      let promotionId = '';
      if (this.promotionObject != undefined)
        promotionId = this.promotionObject.promotionId

      this.pricesAndOffersService
        .DownloadFile(promotionId, fileName, fileType, ApprovalCycleOperations.Promotions.valueOf())
        .subscribe(
          success => {
            saveAs(success, fileName);
          },
          err => {
            alert("Server error while downloading file.");
          }
        );
    }
  }


  //#region [Survey]
  afterSaveSurvey(surveyId) {
    if (this.getInputsForms().length > 0) {
      this.getInputFormDetails(this.getInputsForms()[0])[0].get('inputSelectedValueId').setValue(surveyId);
    }
    this.fillSurveysList();
    this.onCloseSurveyClicked();
  }
  showSurveyScreenSlider() {
    this.showSurveyScreen = true;
    this.coreSession.hideEmployeeEntrySliderFooter = true;
  }
  onSaveSurveyClicked() {
    this.saveSurveySubject.next();
  }
  onCloseSurveyClicked() {
    this.showSurveyScreen = false;
  }
  //#endregion
  showImportDialog() {
    if (this.showApplyToData) {
      this.import.showDialog(this.appliedTodataType).then((res) => {
        if (res == -1) {
          return false;
        } else if (res == 1) {
        }
      });
    }
    if (this.showExcludeCustomersData) {
      this.import.showDialog(this.excludeCustomerdataType).then((res) => {
        if (res == -1) {
          return false;
        } else if (res == 1) {
        }
      });
    }
    this.selectCustomerDialog.populateCustomers();
  }
  onImportBtnClicked() {
    this.resetImportCustomersData();
    this.resetImportExcludeCustomerData();
    this.checkConatinsCustomers();
  }
  clearPromotionAppliedToData() {
    this.addedCustomersList = [];
    this.fillCustomersList();
    this.groupsControl.setValue([]);
    if (this.promotionEntryForm.get('channelsList') != null && this.promotionEntryForm.get('channelsList') != undefined) this.promotionEntryForm.get('channelsList').setValue([]);
  }
  clearPromotionExcludeData() {
    this.excludedCustomersList = [];
    this.fillExcludedCustomersList();
  }
  showImportSuccessMsg(isAppliedToData: boolean): boolean {
    if (isAppliedToData) {
      return (
        (this.addedCustomersList && this.addedCustomersList.length > 0) ||
        (this.groupsControl.value && this.groupsControl.value.length > 0) ||
        (this.promotionEntryForm.get('channelsList') && this.promotionEntryForm.get('channelsList').value && this.promotionEntryForm.get('channelsList').value.length > 0)
      );
    } else {
      return this.excludedCustomersList && this.excludedCustomersList.length > 0;
    }
  }
  validateImportedCustomersData(itemsList: any[]) {
    var promotionLevel = -1;
    this.invalidCustomers = [];
    var allCustomers = itemsList.filter(x => x.customerId >= 0);
    if (this.promotionType == PromotionTypes.DynamicTargetPromotion || this.promotionType == PromotionTypes.TargetPromotion || (this.isRelatedToTarget && (this.promotionType == PromotionTypes.StepsValues || this.promotionType == PromotionTypes.RangeValues))) {
      if (this.promotionLevelControl.value == PromotionLevel.CustomerLevel.valueOf()) {
        var addedCustomers = itemsList.filter(x => x.customerId >= 0 && x.outletId == -1);
        promotionLevel = PromotionLevel.CustomerLevel.valueOf();
      } else {
        promotionLevel = PromotionLevel.OutletLevel.valueOf();
        var addedCustomers = itemsList.filter(x => x.customerId >= 0 && x.outletId >= 0);
      }
    } else {
      promotionLevel = PromotionLevel.OutletLevel.valueOf();
      var addedCustomers = itemsList.filter(x => x.customerId >= 0 && x.outletId >= 0);
    }

    if (addedCustomers && addedCustomers.length > 0) {
      this.addedCustomersList = addedCustomers;
      if (this.ForceCustomerOrganizationSelection) {
        var promotionOrganizationIds = this.organizationControl.value ? this.organizationControl.value.map(org => org.organizationId) : [];
        this.addedCustomersList = this.addedCustomersList.filter(customer => customer.customerId > 0 && customer.inactive === 0 &&
          customer.organizationIdsList.some(id => promotionOrganizationIds.includes(id)) &&
          !this.excludedCustomersList.find(c => c.customerId === customer.customerId && c.outletId === customer.outletId));

        var outOfOrgAccessCustomers = addedCustomers.filter(customer => customer.customerId > 0 &&
          (!customer.organizationIdsList || customer.organizationIdsList.length == 0 || !customer.organizationIdsList.some(id => promotionOrganizationIds.includes(id))) &&
          (!customer.message || customer.message.trim() === ""));

        outOfOrgAccessCustomers.forEach(x => {
          x.codeName = promotionLevel === PromotionLevel.CustomerLevel.valueOf() ? x.customerCodeName : x.outletCodeName
          x.message = this.translateService.instant("Desc_Customer_Is_Out_Of_Promotion_Org_Access")
        });
        this.invalidCustomers = this.invalidCustomers.concat(outOfOrgAccessCustomers);
      } else {
        // if promotion is customer level, addedCustomersList is already filtered on outletId === -1.
        // if promotion is outlet level, addedCustomersList is already filtered on outlets >= 0.
        // get valid customers.
        this.addedCustomersList = this.addedCustomersList.filter(customer => customer.customerId > 0 && customer.inactive === 0);
      }

      var nonExistentCustomers = addedCustomers.filter(customer => customer.customerId === 0);
      nonExistentCustomers.forEach(x => {
        x.codeName = x.customerCodeName
        x.message = this.translateService.instant("Desc_Invalid_Customers")
      });
      this.invalidCustomers = this.invalidCustomers.concat(nonExistentCustomers);

      var inactiveCustomers = addedCustomers.filter(customer => customer.inactive === 1 && customer.customerId > 0 && (!customer.message || customer.message.trim() === ""));
      inactiveCustomers.forEach(x => {
        x.codeName = promotionLevel === PromotionLevel.CustomerLevel.valueOf() ? x.customerCodeName : x.outletCodeName
        x.message = this.translateService.instant("Desc_Inactive_Customer")
      });
      this.invalidCustomers = this.invalidCustomers.concat(inactiveCustomers);

      this.fillCustomersList();
    }

    var invalidLevelCustomers = allCustomers.filter(cust =>
      !addedCustomers.find(c => c.customerId === cust.customerId && c.outletId === cust.outletId)
    );
    invalidLevelCustomers.forEach(x => {
      x.codeName = promotionLevel === PromotionLevel.CustomerLevel.valueOf() ? x.outletCodeName : x.customerCodeName
      x.message = this.translateService.instant("Desc_Invalid_Customer_Level")
    });
    this.invalidCustomers = this.invalidCustomers.concat(invalidLevelCustomers);


    var previouslyExcludedCustomers = allCustomers.filter(customer => this.excludedCustomersList.find(c => c.customerId === customer.customerId && c.outletId === customer.outletId) && (!customer.message || customer.message.trim() === ""));
    previouslyExcludedCustomers.forEach(x => {
      x.codeName = promotionLevel === PromotionLevel.CustomerLevel.valueOf() ? x.customerCodeName : x.outletCodeName
      x.message = this.translateService.instant("Desc_Customer_Is_Excluded_From_Promotion")
    });
    this.invalidCustomers = this.invalidCustomers.concat(previouslyExcludedCustomers);
  }

  validateImportedGroupsData(itemsList: any[]) {
    this.invalidGroups = [];
    var addedGroups = itemsList.filter(x => x.groupId >= 0);
    if (addedGroups && addedGroups.length > 0) {
      this.groupsControl.setValue(addedGroups.filter(group => this.allCustomerGroupsList.map(x => x.groupId).includes(group.groupId)));
      if (this.forceOrganizationFilterForCustomerGroups()) {
        var outOfOrgAccessGroups = addedGroups.filter(group => group.groupId > 0 && !this.allCustomerGroupsList.map(x => x.groupId).includes(group.groupId));
        outOfOrgAccessGroups.forEach(x => {
          x.codeName = x.groupCodeName
          x.message = this.translateService.instant("Desc_Group_Is_Out_Of_Promotion_Org_Access")
        });
        this.invalidGroups = this.invalidGroups.concat(outOfOrgAccessGroups);
      }

      var invalidGroups = addedGroups.filter(group => group.groupId === 0);
      invalidGroups.forEach(x => {
        x.codeName = x.groupCodeName
        x.message = this.translateService.instant("Desc_Invalid_Groups")
      });
      this.invalidGroups = this.invalidGroups.concat(invalidGroups);
    }
  }

  valdiateImportedChannelsData(itemsList: any[]) {
    var addedChannels = itemsList.filter(x => x.channelId >= 0)
    if (addedChannels && addedChannels.length > 0) {
      this.invalidChannels = addedChannels.filter(channel => !this.allChannelsList.map(x => x.channelSubChannelIds).includes(channel.channelSubChannelIds));
      this.invalidChannels.forEach(x => {
        x.codeName = x.channelSubChannelDescriptions
        x.message = this.translateService.instant("Desc_Invalid_Channels")
      })
    }
    if (this.promotionType != PromotionTypes.DynamicTargetPromotion && this.promotionType != PromotionTypes.TargetPromotion) {
      this.promotionEntryForm.get('channelsList').setValue(addedChannels.filter(channel => this.allChannelsList.map(x => x.channelSubChannelIds).includes(channel.channelSubChannelIds)));
    }
  }

  validateImportedExcludeCustomersData(itemsList: any[]) {
    var promotionLevel = -1;
    this.invalidCustomers = [];
    var allExcludeCustomers = itemsList.filter(x => x.customerId >= 0);
    if (this.promotionType == PromotionTypes.DynamicTargetPromotion || this.promotionType == PromotionTypes.TargetPromotion || (this.isRelatedToTarget && (this.promotionType == PromotionTypes.StepsValues || this.promotionType == PromotionTypes.RangeValues))) {
      if (this.promotionLevelControl.value == PromotionLevel.CustomerLevel.valueOf()) {
        var addedExcludeCustomers = itemsList.filter(x => x.customerId >= 0 && x.outletId == -1);
        promotionLevel = PromotionLevel.CustomerLevel.valueOf();
      } else {
        promotionLevel = PromotionLevel.OutletLevel.valueOf();
        var addedExcludeCustomers = itemsList.filter(x => x.customerId >= 0 && x.outletId >= 0);
      }
    } else {
      promotionLevel = PromotionLevel.OutletLevel.valueOf();
      var addedExcludeCustomers = itemsList.filter(x => x.customerId >= 0 && x.outletId >= 0);
    }

    if (addedExcludeCustomers && addedExcludeCustomers.length > 0) {
      this.excludedCustomersList = addedExcludeCustomers;
      if (this.ForceCustomerOrganizationSelection) {
        var promotionOrganizationIds = this.organizationControl.value ? this.organizationControl.value.map(org => org.organizationId) : [];
        this.excludedCustomersList = this.excludedCustomersList.filter(customer => customer.customerId > 0 &&
          customer.organizationIdsList.some(id => promotionOrganizationIds.includes(id)) && customer.inactive === 0 &&
          !this.addedCustomersList.find(c => c.customerId === customer.customerId && c.outletId === customer.outletId));

        var outOfOrgAccessCustomers = addedExcludeCustomers.filter(customer => customer.customerId > 0 &&
          (!customer.organizationIdsList || customer.organizationIdsList.length == 0 || !customer.organizationIdsList.some(id => promotionOrganizationIds.includes(id))) &&
          (!customer.message || customer.message.trim() === ""));
        outOfOrgAccessCustomers.forEach(x => {
          x.codeName = promotionLevel === PromotionLevel.CustomerLevel.valueOf() ? x.customerCodeName : x.outletCodeName
          x.message = this.translateService.instant("Desc_Customer_Is_Out_Of_Promotion_Org_Access")
        });
        this.invalidExcludeCustomers = this.invalidExcludeCustomers.concat(outOfOrgAccessCustomers);
      } else {
        this.excludedCustomersList = this.excludedCustomersList.filter(customer => customer.customerId > 0 && customer.inactive === 0);
      }

      var nonExistentCustomers = addedExcludeCustomers.filter(customer => customer.customerId === 0);
      nonExistentCustomers.forEach(x => {
        x.codeName = x.customerCodeName
        x.message = this.translateService.instant("Desc_Invalid_Customers")
      });
      this.invalidExcludeCustomers = this.invalidExcludeCustomers.concat(nonExistentCustomers);


      var inactiveCustomers = addedExcludeCustomers.filter(customer => customer.inactive === 1 && customer.customerId > 0 && (!customer.message || customer.message.trim() === ""));
      inactiveCustomers.forEach(x => {
        x.codeName = promotionLevel === PromotionLevel.CustomerLevel.valueOf() ? x.customerCodeName : x.outletCodeName
        x.message = this.translateService.instant("Desc_Inactive_Customer")
      });
      this.invalidExcludeCustomers = this.invalidExcludeCustomers.concat(inactiveCustomers);
      if (!this.isEditTargetPromotion)
        this.fillExcludedCustomersList();
    }

    var invalidLevelCustomers = allExcludeCustomers.filter(cust =>
      !addedExcludeCustomers.find(c => c.customerId === cust.customerId && c.outletId === cust.outletId));
    invalidLevelCustomers.forEach(x => {
      x.codeName = promotionLevel === PromotionLevel.CustomerLevel.valueOf() ? x.outletCodeName : x.customerCodeName
      x.message = this.translateService.instant("Desc_Invalid_Customer_Level")
    });
    this.invalidExcludeCustomers = this.invalidExcludeCustomers.concat(invalidLevelCustomers);
    var previouslyAddedCustomers = allExcludeCustomers.filter(customer =>
      this.addedCustomersList.find(c => c.customerId === customer.customerId && c.outletId === customer.outletId) && (!customer.message || customer.message.trim() === ""));
    if (this.isEditTargetPromotion) {
      this.excludedCustomersList = this.excludedCustomersList.concat(previouslyAddedCustomers);
    } else {
      previouslyAddedCustomers.forEach(x => {
        x.codeName = promotionLevel === PromotionLevel.CustomerLevel.valueOf() ? x.customerCodeName : x.outletCodeName
        x.message = this.translateService.instant("Desc_Customer_Is_Added_To_Promotion")
      });
      this.invalidExcludeCustomers = this.invalidExcludeCustomers.concat(previouslyAddedCustomers);
    }
  }

  afterImportCustomers(event: any) {
    if (event && event.itemsList.length > 0) {
      if (this.showApplyToData) {
        this.clearPromotionAppliedToData();
        this.validateImportedCustomersData(event.itemsList);
        this.validateImportedGroupsData(event.itemsList);
        this.valdiateImportedChannelsData(event.itemsList);

        let invalidErrorList = this.invalidCustomers.concat(this.invalidGroups.concat(this.invalidChannels));
        if (invalidErrorList && invalidErrorList.length > 0) {
          this.excelDataSource = {
            totalItems: invalidErrorList.length,
            data: invalidErrorList
          };
          this.invImportedCount = invalidErrorList.length;



          if (this.invImportedCount > 0) {
            event.importedRecordsCount = event.importedRecordsCount - this.invImportedCount;
            event.notImportedRecordsCount = this.invImportedCount;
            this.import.closeDialog();
            this.showInvalidImportedModal();
            this.importedRecordsCount = this.translateService.instant(ConstantMessages.Desc_Imported_Records_Count).replace('{0}', event.importedRecordsCount);
            this.notImportedRecordsCount = this.translateService.instant(ConstantMessages.Desc_Not_Imported_Records_Count).replace('{0}', event.notImportedRecordsCount);
          }
        }
      }
      if (this.showExcludeCustomersData) {
        this.clearPromotionExcludeData();
        this.validateImportedExcludeCustomersData(event.itemsList);
        if (this.isEditTargetPromotion) {
          this.validateBenfitsCustomers(this.excludedCustomersList, event);
        } else {
          this.fillErrorListAndCountingRecord(event);
        }

      }
      if (this.showImportSuccessMsg(this.showApplyToData) && !this.isEditTargetPromotion)
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.Desc_Imported_Successfully));
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption)
        , this.translateService.instant(ConstantMessages.MsgNoItemsFound));
    }
  }
  fillErrorListAndCountingRecord(event: any) {
    let invalidErrorList = this.invalidExcludeCustomers;
    if (invalidErrorList && invalidErrorList.length > 0) {
      this.excelDataSource = {
        totalItems: invalidErrorList.length,
        data: invalidErrorList
      };
      this.invImportedCount = invalidErrorList.length;
      if (this.invImportedCount > 0) {
        event.importedRecordsCount = event.importedRecordsCount - this.invImportedCount;
        event.notImportedRecordsCount = this.invImportedCount;
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.Desc_Imported_Successfully));
        this.import.closeDialog();
        this.showInvalidImportedModal();

        this.importedRecordsCount = this.translateService.instant(ConstantMessages.Desc_Imported_Records_Count).replace('{0}', event.importedRecordsCount);
        this.notImportedRecordsCount = this.translateService.instant(ConstantMessages.Desc_Not_Imported_Records_Count).replace('{0}', event.notImportedRecordsCount);
      }
    }
  }
  validateBenfitsCustomers(excludedCustomersList: any[], event: any) {
    let customerNames = [];
    if (this.achievementCustomerList != null && this.achievementCustomerList.length > 0) {
      if (this.promotionLevel === PromotionLevel.CustomerLevel) {
        var promoExclusionCustomers = excludedCustomersList.filter(x => this.achievementCustomerList.find(c => c.customerId == x.customerId))
      }
      else if (this.promotionLevel === PromotionLevel.OutletLevel) {
        var promoExclusionCustomers = excludedCustomersList.filter(x => this.achievementCustomerList.find(c => c.customerId == x.customerId && c.outletId == x.outletId))
      }
      if (promoExclusionCustomers != null && promoExclusionCustomers.length > 0) {
        promoExclusionCustomers.forEach(x => {
          this.promotionLevel === PromotionLevel.CustomerLevel ? customerNames.push(x.customerCodeName) : customerNames.push(x.outletCodeName);
        });
        this.customerCodeNames = customerNames.join(',');
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(this.promotionLevel === PromotionLevel.CustomerLevel ? ConstantMessages.MsgConfirmationExcludeCustomers : ConstantMessages.MsgConfirmationExcludeOutlets).replace('{0}', this.customerCodeNames)
          , DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
            (result: DialogResult) => {
              if (result === DialogResult.Yes) {
                this.fillExcludedCustomersList();
                this.fillErrorListAndCountingRecord(event)
              } else {
                let newInvalidList = []
                newInvalidList = this.invalidExcludeCustomers.filter(x => promoExclusionCustomers.find(c => c.customerId == x.customerId && c.outletId == x.outletId))
                if (newInvalidList.length == 0) {
                  promoExclusionCustomers.forEach(x => {
                    x.codeName = this.promotionLevel === PromotionLevel.CustomerLevel ? x.customerCodeName : x.outletCodeName;
                    x.message = this.translateService.instant("Desc_Customer_Have_Achievement")
                  })
                  this.invalidExcludeCustomers = this.invalidExcludeCustomers.concat(promoExclusionCustomers);
                  this.excludedCustomersList = this.promotionLevel === PromotionLevel.CustomerLevel ? this.excludedCustomersList.filter(c => !this.invalidExcludeCustomers.find(ic => ic.customerId === c.customerId)) : this.excludedCustomersList.filter(c => !this.invalidExcludeCustomers.find(ic => ic.customerId === c.customerId && ic.outletId == c.outletId))
                }
                this.fillExcludedCustomersList();
                this.fillErrorListAndCountingRecord(event)
              }
            });
      } else {
        this.fillExcludedCustomersList();
        this.fillErrorListAndCountingRecord(event)
      }
    } else {
      this.fillExcludedCustomersList();
      this.fillErrorListAndCountingRecord(event)
    }
  }
  checkConatinsCustomers() {
    if ((this.showApplyToData && this.addedCustomersList && this.addedCustomersList.length > 0) || (this.showExcludeCustomersData && this.excludedCustomersList && this.excludedCustomersList.length > 0)) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (result: DialogResult) => {
          if (result === DialogResult.Yes) {
            if (this.showApplyToData)
              this.resetImportCustomersData();
            else
              this.resetImportExcludeCustomerData();

            this.showImportDialog();
          }
        });
    }
    else {
      this.showImportDialog();
    }
  }
  resetImportCustomersData() {
    this.invalidCustomers = [];
    this.invalidGroups = [];
    this.invalidChannels = [];
    this.excelDataSource = {
      totalItems: 0,
      data: []
    };
  }
  resetImportExcludeCustomerData() {
    this.invalidExcludeCustomers = [];
    this.excelDataSource = {
      totalItems: 0,
      data: []
    };
  }
  afterFillCustomerDetails(customer) {
    if (customer) {
      this.allCustomersList = customer.data;
    }
  }
  showInvalidImportedModal() {
    this.templateEntry.Show(true).then(
      (res) => {
      }
    );
  }
  onSaveExcludeCustomersClicked(data) {
    this.afterSaveExcludeCustomersDialog(data)
  }
  forceOrganizationFilterForCustomerGroups() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true"
  }

  restrictApprovalCycleToOrganizationLevel(operationId: number): boolean {
    return this.restrictApprovalCycleToOrganizationLevelString.includes(operationId.toString());
  }
  showNoSalesPeriodDate(form){
    this.noSalesPeriodForm = new FormGroup({
      fromToDate: new FormControl({value : [new Date(String(form.get('dateRange').value[0])), new Date(String(form.get('dateRange').value[1]))], disabled : true})
    });
    this.modalService.open(this.NoSalesPeriodDialog, { centered: true, size : "sm" }).result.then(
      (result) => { });
  }

}
