import { OfferAppliedOptions } from './../../../../../shared/models/enums/offer-applied-options.enum';
import { Component, Input, OnInit, ViewChild } from '@angular/core';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { Subject } from 'rxjs';
import { FormGroup, FormControl } from '@angular/forms';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { CoreSession } from '../../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { PricesAndOffersService } from '../../prices-and-offers.service';
import { DateTimeModel } from '../../../../../shared/models/dateTimeModel/date-time.model';
import { IDateTimePickerProperties } from '../../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { PromotionTypes } from '../../../../../shared/models/enums/promotion-types.enum';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { ApprovalCycleOperations } from '../../../../../shared/models/enums/approval-cycle-operations-enum';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { PromotionService } from '../../../../../shared/services/data-definition/prices-and-offers/promotion.service';
import { LoyaltyProgramsModesDialogComponent } from '../../loyalty-programs/loyalty-programs-modes-dialog/loyalty-programs-modes-dialog.component';
import { LoyaltyProgramsService } from '../../../../../shared/services/data-definition/prices-and-offers/loyalty-programs.service';
import { CustomerService } from '../../../../../shared/services/data-definition/customer/customers.service';
import { PackGroupFilter } from '../../../../../shared/components/filters/pack-group-filter/pack-group-filter-interface';
import { PackGroupService } from '../../../../../shared/services/data-definition/product/pack-group.service';
import { NavBarService } from '../../../../../core/sidebar/sidebar.service';
import { SharedDialogComponent } from '../../../../../shared/components/shared-dialog/shared-dialog.component';

@Component({
  selector: 'app-promotion-list',
  templateUrl: './promotion-list.component.html',
  styleUrls: ['./promotion-list.component.css']
})
export class PromotionListComponent implements OnInit {
  @ViewChild('PromotionEntryDialog', { static: true }) PromotionEntryDialog: SharedDialogComponent;
  @Input() isBundle: boolean = false;
  @Input() isLoyalty: boolean = false;
  isFromDelete: boolean = false;
  isFromActivate: boolean = false;
  isFromDeactivate: boolean = false;
  promotionModeId = -1;
  sessionTitle = 'Promotion';
  selectedMenuUrl = ConstantURLs.promotionsURL;
  showPromotionEntrySlider = false;
  saveSubject: Subject<void> = new Subject<void>();
  promotionFilterForm: FormGroup;
  currentFormControlName = 'benefitItemId';
  prerequisitesFormControlName = 'prerequisiteItemId';
  isEditTargetPromotion: boolean = false;
  achievementCustomerList: any[] = [];
  inputPackGroupFilter: PackGroupFilter = {
    currentFormControlName: 'benefitGroupId',
    getGroupsHavingSamePackQuantity: true
  }
  outputPackGroupFilter: PackGroupFilter = {
    currentFormControlName: 'prerequisiteGroupId',
    getGroupsHavingSamePackQuantity: true
  }
  isEditMode = false;
  isCloneMode = false;
  isViewMode = false;
  isSpecificDate: boolean = false;
  promotionObject: any = null;
  promotionTypesList: any[] = [];
  allChannelsList: any[] = [];
  packGroupsDataSource: any[];
  showStatusColumn = false;
  TabelData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    isOnline: true,
    showSearch: true,
    showSearchBtn: true,
    showNewBtn: false,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Description', key: 'promotionName', isSortable: true, width: '20%' },
      { title: 'Desc_Code', key: 'promotionCode', isSortable: true, width: '20%' },
      { title: 'Desc_Start_Date', key: 'startDate', isSortable: true, width: '15%', isExpiryDate: true },
      { title: 'Desc_End_Date', key: 'endDate', isSortable: true, width: '15%', isExpiryDate: true },
      { title: 'Desc_Vendor', key: 'organizationCodeName', isSortable: true, width: '15%' },
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  promotionFilter: any = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    promotionTypeId: -1,
    organizationId: -1,
    customerId: -1,
    outletId: -1,
    customerGroupId: -1,
    customerClassId: -1,
    benefitItemId: -1,
    benefitGroupId: -1,
    prerequisiteItemId: -1,
    prerequisiteGroupId: -1,
    channelSubChannelIds: "",
    includeInactive: false,
    isGiftVoucher: false,
    isBundle: false,
    isLoyaltyPromotion: false,
    fromDate: null,
    toDate: null,
    specificDate: false
  };
  toDate: DateTimeModel = null;
  fromDate: DateTimeModel = null;

  fromDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Start_Date',
    formControlName: 'fromDate',
    isCalendarOnly: true,
    labelHidden: false,
  };

  toDateProperties: IDateTimePickerProperties = {
    label: 'Desc_End_Date',
    formControlName: 'toDate',
    isCalendarOnly: true,
    labelHidden: false,
  };
  @ViewChild("loyaltyModesDialog", { static: true }) loyaltyModesDialog: LoyaltyProgramsModesDialogComponent;

  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private pricesAndOffersService: PricesAndOffersService,
    private promotionService: PromotionService,
    private sessionData: SessionDataProvider,
    private loyaltyProgramsService: LoyaltyProgramsService,
    private customerService: CustomerService,
    private packGroupService: PackGroupService,
    private navService:NavBarService) {
  }
  showSharedTable: boolean = false;

  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus;
    });
    this.showSharedTable = this.navService.tourStatus;

    if (this.isBundle) {
      this.sessionTitle = "Bundles";
      this.selectedMenuUrl = ConstantURLs.bundlesURL;
    } else if (this.isLoyalty) {
      this.sessionTitle = "Loyalty Programs";
      this.selectedMenuUrl = ConstantURLs.loyaltyProgramsURL;
      this.TabelData.columns.push({ title: 'Desc_Mode', key: 'loyaltyModeDescription', isSortable: true, width: '20%' });

    }
    else {
      this.TabelData.columns.push({ title: 'Desc_Promotion_Type', key: 'promotionTypeName', isSortable: true, width: '20%' });
      this.showStatusColumn = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("1");
      if (this.showStatusColumn)
        this.TabelData.columns.push({ title: 'Desc_Status', key: 'promotionStatusName', isSortable: true, width: '15%' });
    }
    this.coreSession.SetTitle(this.sessionTitle);
    this.TabelData.showNewBtn = this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.Add);
    this.addDeleteAction();
    this.addEditAction();
    this.addCloneAction();
    this.addApproveAction();
    this.addViewAction();
    this.addSendNotificationAction();
    this.fillPromotionTypes();
    this.fillChannelsSubChannelsList();
    this.fillPackGroup();
    this.initFilterForm();
    this.populatePromotionsList();
  }
  addDeleteAction() {
    if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.Delete)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.delete,
          title: 'Desc_Delete',
          icon: 'fa-solid fa-trash',
          color: '#f1685e',
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: "showDeleteBtn"
        });
    }
  }
  openPromotionEntryDialog() {
    this.PromotionEntryDialog.Show(true).then((res) => { });
  }
  addApproveAction() {
    if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.Approve)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.approve,
          title: 'Desc_Order_Approve',
          icon: "fa-solid fa-check",
          color: "#02b875",
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: 'isPending'
        });
    }
  }
  addViewAction() {
    if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.View)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.View,
          title: 'Desc_View',
          icon: 'fa-regular fa-eye',
          color: '#12344d'
        });
    }
  }
  addEditAction() {
    if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.Edit)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.edit,
          title: "Desc_Edit",
          icon: "fa-regular fa-pen-to-square",
          color: "#12344d"
        },
        {
          operation: RowOperation.Deactivate,
          title: 'Desc_Deactivate',
          icon: 'fa-solid fa-ban',
          color: '#f1685e',
          showWhenKeyValueFalse: true,
          showHideOptionPerLine: true,
          controlKeyName: 'inactive'
        },
        {
          operation: RowOperation.Activate,
          title: "Desc_Reactivate",
          icon: "fa fa-toggle-on",
          color: '#02b875',
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: 'inactive'
        });
    }
  }
  addCloneAction() {
    if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.Clone)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.Clone,
          title: 'Desc_Clone',
          icon: 'fa fa-clone',
          color: '#12344d',
        });
    }
  }
  addSendNotificationAction() {
    if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.SendNotification)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.sendNotification,
          title: 'Desc_Send_Notification',
          icon: 'fa fa-bell',
          color: '#12344d',
        });
    }
  }
  fillPromotionTypes() {
    this.promotionTypesList = [];
    this.promotionTypesList.push(
      { 'promotionType': PromotionTypes.FixedValues, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Fixed_Promotion_Type) },
      { 'promotionType': PromotionTypes.RangeValues, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Ranges_Promotion_Type) },
      { 'promotionType': PromotionTypes.StepsValues, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Steps_Promotion_Type) },
      { 'promotionType': PromotionTypes.TargetPromotion, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Monthly_Target_Promotion_Type) },
      { 'promotionType': PromotionTypes.DynamicTargetPromotion, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Dynamic_Target_Promotion_Type) },
      { 'promotionType': PromotionTypes.SurveyPromotion, 'promotionTypeName': this.translateService.instant(ConstantMessages.Desc_Survey_Promotion_Type) }
    );
  }
  fillChannelsSubChannelsList() {
    this.customerService.GetAllCustomerChannels(null).subscribe(result => {
      this.allChannelsList = result;
    });
  }
  fillPackGroup() {
    this.coreSession.ModalLoading.Show();
    var filter = {
      getGroupsHavingSamePackQuantity: false,
      selectedOraganizationIds: ''
    }
    this.packGroupService.getPackGroups(filter).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.packGroupsDataSource = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  populatePromotionsList() {
    this.promotionFilter.organizationId = this.promotionFilterForm.get('organizationId').value == null ? -1 : this.promotionFilterForm.get('organizationId').value;
    this.promotionFilter.promotionTypeId = this.promotionFilterForm.get('promotionTypeId').value == null ? -1 : this.promotionFilterForm.get('promotionTypeId').value;
    this.promotionFilter.customerId = this.promotionFilterForm.get('customerId').value == null ? -1 : this.promotionFilterForm.get('customerId').value;
    this.promotionFilter.outletId = this.promotionFilterForm.get('outletId').value == null ? -1 : this.promotionFilterForm.get('outletId').value;
    this.promotionFilter.customerGroupId = this.promotionFilterForm.get('organizationId').value == null ? -1 : this.promotionFilterForm.get('organizationId').value;
    this.promotionFilter.benefitItemId = this.promotionFilterForm.get('benefitItemId').value == null ? -1 : this.promotionFilterForm.get('benefitItemId').value;
    this.promotionFilter.benefitGroupId = this.promotionFilterForm.get('benefitGroupId').value == null ? -1 : this.promotionFilterForm.get('benefitGroupId').value;
    this.promotionFilter.prerequisiteItemId = this.promotionFilterForm.get('prerequisiteItemId').value == null ? -1 : this.promotionFilterForm.get('prerequisiteItemId').value;
    this.promotionFilter.prerequisiteGroupId = this.promotionFilterForm.get('prerequisiteGroupId').value == null ? -1 : this.promotionFilterForm.get('prerequisiteGroupId').value;
    this.promotionFilter.customerClassId = this.promotionFilterForm.get('customerClassId').value == null ? -1 : this.promotionFilterForm.get('customerClassId').value;
    this.promotionFilter.toDate = this.toDate == null ? null : this.toDate;
    this.promotionFilter.fromDate = this.fromDate == null ? null : this.fromDate;
    this.promotionFilter.toDate = this.toDate == null ? null : this.toDate;
    this.promotionFilter.customerGroupId = this.promotionFilterForm.get('customerGroupId').value == null ? -1 : this.promotionFilterForm.get('customerGroupId').value;
    this.promotionFilter.includeInactive = this.promotionFilterForm.get('includeInactive').value == null ? false : this.promotionFilterForm.get('includeInactive').value;
    this.promotionFilter.specificDate = this.promotionFilterForm.get('specificDate').value == null ? false : this.promotionFilterForm.get('specificDate').value;
    this.promotionFilter.isBundle = this.isBundle;
    this.promotionFilter.isLoyaltyPromotion = this.isLoyalty;
    this.promotionFilter.channelSubChannelIds = this.promotionFilterForm.get('channelSubChannelId').value == null ? "" : this.promotionFilterForm.get('channelSubChannelId').value;

    this.promotionService.getPromotionsListSharedTable(this.promotionFilter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.dataSource = {
          totalItems: response.data.totalItems,
          data: response.data.data,
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }
  initFilterForm() {
    this.promotionFilterForm = new FormGroup({
      promotionTypeId: new FormControl(),
      organizationId: new FormControl(),

      customerId: new FormControl(),
      outletId: new FormControl(),
      channelSubChannelId: new FormControl(),
      customerGroupId: new FormControl(),
      customerClassId: new FormControl(),

      fromDate: new FormControl(null),
      toDate: new FormControl(null),
      benefitItemId: new FormControl(),
      benefitGroupId: new FormControl(),
      prerequisiteItemId: new FormControl(),
      prerequisiteGroupId: new FormControl(),

      includeInactive: new FormControl(),
      specificDate: new FormControl(),
    })
  }
  onTableFilterChanged(query: any) {
    this.promotionFilter.customListFilter = query;
    this.populatePromotionsList();
  }
  onRowOperation(event: any) {
    this.isFromDelete = false;
    this.isFromActivate = false;
    this.isFromDeactivate = false;

    switch (event.operation) {
      case RowOperation.delete: {
        if (event.object.promotionType === PromotionTypes.SurveyPromotion && event.object.isStartedTargetPromotion) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_Cannot_Delete_Started_Promotion));
        } else {
          this.deletePromotion(event.object);
        }
        break;
      }
      case RowOperation.View:
        if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.View)) {
          this.getPromotionData(event.object.promotionId, false, true, true);
        }
        break;
      case RowOperation.edit:
        this.checkAllowEditPromotionByOrgAccess(event);
        break;
      case RowOperation.Clone:
        if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.Clone)) {
          this.getPromotionData(event.object.promotionId, true, false, false);
        }
        break;
      case RowOperation.Deactivate: {
        this.checkAllowEditPromotionByOrgAccess(event);
        break;
      }
      case RowOperation.Activate: {
        this.checkAllowEditPromotionByOrgAccess(event);
        break;
      }
      case RowOperation.approve: {
        this.IsValidToApprove(event.object);
        break;
      }
      case RowOperation.sendNotification: {
        if (this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes("1")) {
          if (event.object.status == -1) {
            this.sendPromotionNotification(event.object);
          } else {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgSendNotificationBeforeApprove));
            return;
          }
        } else {
          this.sendPromotionNotification(event.object);
        }
        break;
      }
    }
  }

  checkAllowEditPromotionByOrgAccess(event) {
    if (this.sessionData.getConfigurationValue(ConstantConfigurations.AllowEditPromotionByOrgAccess).toLowerCase() === ("true")) {
      this.promotionService.checkAllowEditPromotionByOrgAccess(event.object.createdBy).subscribe(
        response => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            if (!response.data) {
              // if AllowEditPromotionByOrgAccess is true and validation is false convert from edit mode to view mode
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgCantEditPromotionOrganization));
              if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.View)) {
                this.getPromotionData(event.object.promotionId, false, true, true);
              }
            } else {

              switch (event.operation) {
                case RowOperation.edit:
                  this.editPromotion(event);
                  break;
                case RowOperation.Deactivate:
                  this.deactivatePromotion(event.object);
                  break;
                case RowOperation.Activate:
                  this.activatePromotion(event.object);
                  break;
              }

            }
          }
          else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        });
    } else {
      switch (event.operation) {
        case RowOperation.edit:
          this.editPromotion(event);
          break;
        case RowOperation.Deactivate:
          this.deactivatePromotion(event.object);
          break;
        case RowOperation.Activate:
          this.activatePromotion(event.object);
          break;
      }

    }
  }

  editPromotion(event) {
    if (event.object.promotionType === PromotionTypes.TargetPromotion || event.object.promotionType === PromotionTypes.DynamicTargetPromotion || event.object.relatedToTarget) {
      this.isValidToEditTargetPromotion(event.object.promotionId, event.object.relatedToTarget);
    } else {
      this.isEditTargetPromotion = false;
      this.getPromotionData(event.object.promotionId, false, true, false);
    }
  }

  deactivatePromotion(promotion) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeactivateConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.SendNotification)) {
            this.isFromDeactivate = true;
            this.SendNotificationToFoOrEcho(promotion, this.isFromDelete, this.isFromActivate, this.isFromDeactivate);
          } else {
            this.continueDeactivatePromotion(promotion);
          }
        }
      });
  }
  continueDeactivatePromotion(promotion) {
    this.coreSession.ModalLoading.Show();
    if (this.isLoyalty) {
      this.loyaltyProgramsService.deactivateLoyalty(promotion).subscribe(response => {
        this.onDeactivatePromotionSuccess(response);
      },
        (error: HttpErrorResponse) => {
          this.onDeactivatePromotionError(error);
        }
      );
    } else {
      this.promotionService.deactivatePromotion(promotion).subscribe(response => {
        this.onDeactivatePromotionSuccess(response);
      },
        (error: HttpErrorResponse) => {
          this.onDeactivatePromotionError(error);
        }
      );
    }
  }

  onDeactivatePromotionSuccess(response) {
    this.coreSession.ModalLoading.Hide();
    if (response.status != null && response.status >= 0) {
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
      this.populatePromotionsList();
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }
  onDeactivatePromotionError(error) {
    this.coreSession.ModalLoading.Hide();
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
  }
  activatePromotion(promotion) {
    if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.SendNotification)) {
      this.isFromActivate = true;
      this.SendNotificationToFoOrEcho(promotion, this.isFromDelete, this.isFromActivate, this.isFromDeactivate);
    } else {
      this.continueActivatePromotion(promotion);
    }
  }
  continueActivatePromotion(promotion) {
    this.coreSession.ModalLoading.Show();
    this.promotionService.activatePromotion(promotion).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
        this.populatePromotionsList();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  deletePromotion(promotion) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          if (this.coreSession.checkActivitiesAvailability(this.selectedMenuUrl, MenuActions.SendNotification)) {
            this.isFromDelete = true;
            this.SendNotificationToFoOrEcho(promotion, this.isFromDelete, this.isFromActivate, this.isFromDeactivate);
          } else {
            this.continueDeletePromotion(promotion)
          }
        }
      });
  }
  continueDeletePromotion(promotion) {
    this.coreSession.ModalLoading.Show();
    if (this.isLoyalty) {
      this.loyaltyProgramsService.deleteLoyalty(promotion).subscribe(response => {
        this.onDeletePromotionSuccess(response);
      },
        (error: HttpErrorResponse) => {
          this.onDeletePromotionError(error);
        }
      );
    } else {
      this.promotionService.deletePromotion(promotion).subscribe(response => {
        this.onDeletePromotionSuccess(response);
      },
        (error: HttpErrorResponse) => {
          this.onDeletePromotionError(error);
        }
      );
    }
  }
  SendNotificationToFoOrEcho(promotion, isFromDelete, isFromActivate, isFromDeactivate) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgPromotionNotification), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.coreSession.ModalLoading.Show();
          if (promotion.offerAppliedOptions.includes(OfferAppliedOptions.Sonic.valueOf().toString()) || promotion.offerAppliedOptions.includes(OfferAppliedOptions.NearExpiry.valueOf().toString()))
            promotion.sendNotificationToFO = true;
          if (promotion.offerAppliedOptions.includes(OfferAppliedOptions.CustomerApp.valueOf().toString()))
            promotion.sendNotification = true;

          promotion.resend = true; // to cach apply to data
        }
        else {
          promotion.sendNotificationToFO = false;
        }
        if (isFromDelete) {
          this.continueDeletePromotion(promotion);
        }
        if (isFromActivate) {
          this.continueActivatePromotion(promotion);
        }
        if (isFromDeactivate) {
          this.continueDeactivatePromotion(promotion)
        }
      });
  }
  onDeletePromotionSuccess(response) {
    this.coreSession.ModalLoading.Hide();
    if (response.status != null && response.status >= 0) {
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
      this.populatePromotionsList();
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }

  onDeletePromotionError(error) {
    this.coreSession.ModalLoading.Hide();
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
  }

  IsValidToApprove(promotion) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.ApproveConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.coreSession.ModalLoading.Show();
          this.pricesAndOffersService.isValidToApprove(promotion.status, ApprovalCycleOperations.Promotions.valueOf(), promotion.promotionId).subscribe(response => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              if (response.data) {
                // valid to approve
                this.approvePromotion(promotion);
              }
              else {
                this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgNotValidToApprove));

              }
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
            }
          },
            (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            }
          );
        }
      });
  }
  approvePromotion(promotion) {
    this.pricesAndOffersService.approveOperation(promotion.promotionId, promotion.status, ApprovalCycleOperations.Promotions.valueOf()).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.SuccessCaption));
        this.populatePromotionsList();
        if (response.data.newStatus != -1)
          this.sendEmail(promotion.promotionId, promotion.promotionCode, promotion.status);
        if (response.data.newStatus == -1) {
          // promotion.sendNotificationToFO = true;
          this.sendPromotionNotification(promotion);
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  sendPromotionNotification(promotion) {
    if (promotion.offerAppliedOptions.includes(OfferAppliedOptions.CustomerApp.valueOf().toString()))
      promotion.sendNotification = true;
    if (promotion.offerAppliedOptions.includes(OfferAppliedOptions.Sonic.valueOf().toString()) || promotion.offerAppliedOptions.includes(OfferAppliedOptions.NearExpiry.valueOf().toString()))
      promotion.sendNotificationToFO = true;
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgPromotionNotification), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          promotion.resend = true;
          this.coreSession.ModalLoading.Show();
          this.pricesAndOffersService.sendNotification(promotion).subscribe(response => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
            }
          },
            (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            }
          );
        }
      });
  }
  sendEmail(promotionId, promotionCode, currentStatusId) {
    this.pricesAndOffersService.sendOperationEmail(promotionId, currentStatusId, ApprovalCycleOperations.Promotions.valueOf(), promotionCode, true).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.EmailCaption));
        this.populatePromotionsList();
      } else {
        if (response.message != this.translateService.instant(ConstantMessages.Desc_No_Email_Template_Found_For_Document_Type))
          this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.EmailFailedCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onToDateSelected(date: any) {
    this.isSpecificDate = this.promotionFilterForm.get('specificDate').value;
    if (this.isSpecificDate) {
      this.toDate = null;
      this.toDate = date;
    } else {
      this.fromDate = null;
      this.fromDate = date;
    }
  }
  onFromDateSelected(date: any) {
    this.isSpecificDate = this.promotionFilterForm.get('specificDate').value;
    if (this.isSpecificDate) {
      this.fromDate = null;
      this.fromDate = date;
    } else {
      this.toDate = null;
      this.toDate = date;
    }
  }
  onSpecificDateChange() {
    let startDate = this.toDate;
    let endDate = this.fromDate;

    this.fromDate = startDate;
    this.toDate = endDate;
  }
  onFindButtonClicked() {
    this.promotionFilter.customListFilter.page = 0;
    this.populatePromotionsList();
  }
  onReset() {
    this.fromDate = null;
    this.toDate = null;
    this.promotionFilterForm.reset();
  }
  addNewPromotion() {
    if (this.isLoyalty) {
      this.openLoyaltyModesDialog();
    } else {
      this.isEditMode = false;
      this.isCloneMode = false;
      this.promotionObject = null;
      this.showPromotionEntrySlider = true;
      this.showSharedTable =false
      this.openPromotionEntryDialog()
    }

  }
  isValidToEditTargetPromotion(promotionId, isRelatedToTarget) {
    this.coreSession.ModalLoading.Show();
    this.promotionService.isValidToEditTargetPromotion(promotionId, isRelatedToTarget).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.achievementCustomerList = response.data.achievementCustomerList;
          if (response.data.isValidToEditOrDelete) {
            this.isEditTargetPromotion = false;
            this.getPromotionData(promotionId, false, true, false);
          } else {
            this.isEditTargetPromotion = true;
            this.coreSession.showWarrningWithTimeOutDelay(this.translateService.instant(ConstantMessages.WarningCaption), response.message, 12000);
            this.getPromotionData(promotionId, false, true, false);
          }
        }
        else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getPromotionData(promotionId, isClone, isEdit, isView) {
    this.coreSession.ModalLoading.Show();
    let filter = {
      promotionId: promotionId,
      isClone: isClone
    };
    this.promotionService.getPromotionData(filter).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data) {
            this.promotionObject = response.data;
            this.isEditMode = isEdit;
            this.isCloneMode = isClone;
            this.isViewMode = isView;
            this.showPromotionEntrySlider = true;
            this.promotionModeId = this.promotionObject.promotionModeId;
            if (!this.isViewMode && this.isEditMode && this.promotionObject.isStartedTargetPromotion && !this.isEditTargetPromotion) {
              this.isEditTargetPromotion = true;
              this.coreSession.showWarrningWithTimeOutDelay(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgStartedTargetPromotion), 12000);
            }
            this.openPromotionEntryDialog()
          }
        }
        else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });

  }
  closePromotionEntrySlider() {
    this.promotionObject = null;
    this.showPromotionEntrySlider = false;
    this.isEditMode = false;
    this.isCloneMode = false;
    this.isViewMode = false;
    this.coreSession.SetTitle(this.sessionTitle);
    this.showSharedTable =true
    this.PromotionEntryDialog.Close()
  }
  onSavePromotionClick() {
    this.saveSubject.next()
  }
  afterSavePromotion() {
    this.closePromotionEntrySlider();
    this.populatePromotionsList();
    this.showSharedTable =true
  }
  openLoyaltyModesDialog() {
    this.loyaltyModesDialog.showDialog().then(
      (result) => {
        if (result != -1) {
          this.promotionModeId = result;
          this.isEditMode = false;
          this.isCloneMode = false;
          this.promotionObject = null;
          this.showPromotionEntrySlider = true;
          this.openPromotionEntryDialog()
        } else {

        }
      });
  }
}

