import { Component, OnInit, Input, Output, EventEmitter, ViewChild, ElementRef, Renderer2 } from '@angular/core';
import { Observable, Subject } from 'rxjs';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { IDateTimePickerProperties } from '../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { DatePipe } from '@angular/common';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { CoreSession } from '../../../../core/core.session';
import { SurveyService } from '../../survey-managment/survey.service';
import { HttpErrorResponse } from '@angular/common/http';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { WarehouseTransactionOperation } from '../../../../shared/models/enums/warehouse-transaction-operation.enum';
import { CalculationService } from '../../../../shared/services/calculations.service';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { QualityControlReadingService } from '../../survey-managment/quality-control-reading.service';

@Component({
  selector: 'app-quality-control-reading-entry',
  templateUrl: './quality-control-reading-entry.component.html',
  styleUrls: ['./quality-control-reading-entry.component.css'],
  providers: [DatePipe]
})
export class QualityControlReadingEntryComponent implements OnInit {
  @ViewChild("actionsConfirmationDialog", { static: true }) actionsConfirmationDialog: NgbModal;
  OkResult: DialogResult = DialogResult.Ok;
  applyOnAllItems: boolean = false;
  @Input() surveyObject: any;
  @Input() isViewMode: boolean = false;
  @Input() events: Observable<void>;
  @Output() onSaveCompleted = new EventEmitter();
  saveSubject: Subject<void> = new Subject<void>();
  numberOfQuestions: number = 0;
  formQuestions: FormGroup;
  saveBtnSubscription: any;
  @Input() dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  dynamicCheckListDropdownSettings = {
    singleSelection: false,
    idField: 'lovOptionID',
    textField: 'lovOptionName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 1
  };
  dropdownItemsSettings = {
    singleSelection: false,
    idField: 'itemId',
    textField: 'itemCodeName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 1
  };
  dynamicDateTimeProperties: IDateTimePickerProperties[] = [];
  dynamicDateTimeValues: any[];
  todayDate: Date = new Date();
  pageIndex = 0;
  pageNumber = 1;
  fieldAnswer: any = {};
  allFieldsAnswers: any[] = [];
  surveyReadingModel: any = {};
  validFromDate: any = [];
  validToDate: any = [];
  dependancyOnQuestionsList: any[] = [];
  dependencyOnQuestionObject: any = {};
  actions: any[] = [];
  continue: boolean = true;
  isDamagedWarehouse: boolean = false;
  isOffload: boolean = false;
  confirmAction: boolean = false;
  //actionReasonList: any[] = [];
  resultList: any[] = [];
  minValue = '';
  maxValue = '';
  specificValue = '';
  acceptableValueNote = '';
  answerAsString = '';
  allItems: boolean = false;
  lat: any = null;
  lng: any = null;
  warehouseVehicleLabel = '';
  constructor(public sessionData: SessionDataProvider,
    private translateService: TranslateService,
    private qualityControlReadingService: QualityControlReadingService,
    private calculationService: CalculationService,
    public coreSession: CoreSession,
    public datePipe: DatePipe,
    private modalService: NgbModal) {

  }
  ngOnInit() {
    this.subscribeSaveClick();
    this.dynamicDateTimeProperties = [];
    this.dynamicDateTimeValues = [];
    this.dynamicCheckListDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dynamicCheckListDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.dropdownItemsSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropdownItemsSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.dropdownItemsSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.initForm();
    this.initDynamicArray();
    this.surveyReadingModel.startDateModel = this.coreSession.GetCurrentDateTimeAsModel();
    if (this.isViewMode) {
      this.coreSession.SetTitle('View QC Form');
      this.formQuestions.disable();
      this.todayDate = this.surveyObject.readingDate;
    }
    else {
      this.coreSession.SetTitle('Fill QC Form');
    }
    this.warehouseVehicleLabel = this.surveyObject.warehouse;
  }

  initForm() {
    this.formQuestions = new FormGroup({
      formName: new FormControl({ value: this.surveyObject.surveyName, disabled: true }, Validators.nullValidator),
      currentDate: new FormControl({ value: (this.isViewMode ? this.datePipe.transform(this.surveyObject.readingDate, this.sessionData.DateTimeFormat) : this.datePipe.transform(this.todayDate, this.sessionData.DateTimeFormat)), disabled: true }),
      itemsControl: new FormControl({ value: (this.isViewMode ? this.surveyObject.appliedItems : null), disabled: this.isViewMode }, Validators.required),
    });
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  public markFormGroupTouched(formGroup: FormGroup) {
    (<any>Object).values(formGroup.controls).forEach(control => {
      control.markAsTouched();

      if (control.controls) {
        this.markFormGroupTouched(control);
      }
    });
  }
  isDivisionLevel() {
    return (this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true")
  }
  onAnswerQuestion(question: any, answer: any) {
    let dependancyList = this.dependancyOnQuestionsList.filter(a => a.dependentQuestion == question.fieldId);
    dependancyList.forEach(q => {
      if (q.dependentAnswer == answer) {
        q.show = true;
        if (question.isMandatory) {
          this.getDynamicFieldControl(q.fieldId).setValidators(Validators.required);
          this.getDynamicFieldControl(q.fieldId).updateValueAndValidity()
        }

      }
      else {
        q.show = false;
        if (question.isMandatory) {
          this.getDynamicFieldControl(q.fieldId).setValidators(Validators.nullValidator);
          this.getDynamicFieldControl(q.fieldId).updateValueAndValidity()
        }
        //this.formQuestions.removeControl(question.fieldId.toString());
      }
    });

    // this.formQuestions.removeControl(question.fieldId.toString());

  }
  showQuestion(fieldId: number) {
    if (this.dependancyOnQuestionsList && this.dependancyOnQuestionsList.length > 0) {
      var index = -1;
      index = this.dependancyOnQuestionsList.findIndex(x => x.fieldId == fieldId);
      if (index > -1 && this.dependancyOnQuestionsList[index].show) {
        return true;
      }
      else
        return false;
    }
  }
  onSaveClicked() {


  }
  initDynamicArray() {
    if (this.surveyObject.pageGroupQuestions && this.surveyObject.pageGroupQuestions.length > 0) {
      this.surveyObject.pageGroupQuestions.forEach(page => {
        if (page.questions && page.questions.length > 0) {
          page.questions.forEach(field => {
            var dateValue = null;
            var dateProb = null;
            var answerValueAsString = "";
            if (field.dependentQuestion != -1 && field.dependentAnswer != -1) {
              this.dependencyOnQuestionObject = {};
              this.dependencyOnQuestionObject.fieldId = field.fieldId;
              this.dependencyOnQuestionObject.dependentQuestion = field.dependentQuestion;
              this.dependencyOnQuestionObject.dependentAnswer = field.dependentAnswer;
              this.dependencyOnQuestionObject.fieldTypeID = field.fieldTypeID;
              this.dependencyOnQuestionObject.show = false;
              this.dependancyOnQuestionsList.push(this.dependencyOnQuestionObject);
            }
            var fieldIndex = this.surveyObject.surveyReadingModel.fieldsAnswers.findIndex(x => x.fieldId == field.fieldId);
            if (fieldIndex > -1) {
              answerValueAsString = this.surveyObject.surveyReadingModel.fieldsAnswers[fieldIndex].fieldValue;
              if (answerValueAsString != "") {
                switch (field.fieldTypeID) {
                  case 4:
                    field.fieldValue = answerValueAsString == '1' ? this.translateService.instant(ConstantMessages.Desc_Yes) : this.translateService.instant(ConstantMessages.Desc_No);
                    break;
                  case 5:
                    var optionId: number = +answerValueAsString;
                    var lovOptionIdIndex = field.questionOptions.findIndex(x => x.lovOptionID === optionId)
                    if (lovOptionIdIndex != -1) {
                      field.fieldValue = field.questionOptions[lovOptionIdIndex].lovOptionName;
                    }
                    break;
                  case 6:
                    if (answerValueAsString.includes(",")) {
                      var multiSelectionValues = answerValueAsString.split(",");
                      for (let i = 0; i < multiSelectionValues.length; i++) {
                        var optionId: number = +multiSelectionValues[i];
                        var lovOptionIdIndex = field.questionOptions.findIndex(x => x.lovOptionID === optionId)
                        if (lovOptionIdIndex != -1) {
                          field.fieldValue += field.questionOptions[lovOptionIdIndex].lovOptionName + ',';
                        }

                      }
                      if (field.fieldValue != "")
                        field.fieldValue = field.fieldValue.replace(/,\s*$/, "");

                    }
                    else {
                      var optionId: number = +answerValueAsString;
                      var lovOptionIdIndex = field.questionOptions.findIndex(x => x.lovOptionID === optionId)
                      if (lovOptionIdIndex != -1) {
                        field.fieldValue = field.questionOptions[lovOptionIdIndex].lovOptionName;
                      }
                    }
                    break;
                  default:
                    field.fieldValue = answerValueAsString;

                    break;
                }
              }
            }
            if (!this.isViewMode) {
              if (field.fieldTypeID == 3) {
                dateProb = {
                  label: field.questionName,
                  formControlName: field.fieldId.toString(),
                  isCalendarOnly: true,
                  labelHidden: true
                };
                if (this.isViewMode) {
                  // if (fieldIndex > -1) {
                  //   answerValueAsString = this.surveyObject.surveyReadingModel.fieldsAnswers[fieldIndex].fieldValue;
                  //   let dateFormat = this.sessionData.getConfigurationValue(ConstantConfigurations.SerialTemplateDateFormat);
                  //   let date = this.coreSession.validatedate(answerValueAsString, dateFormat);
                  //   if (date != null)
                  //     dateValue = this.coreSession.getDateTimeModel(date);
                  // }

                }
                this.dynamicDateTimeProperties.push(dateProb);
                this.dynamicDateTimeValues.push(dateValue);
              }
              else if (field.fieldTypeID == 7) {
                dateProb = {
                  label: field.questionName,
                  formControlName: field.fieldId.toString(),
                  isTimerOnly: true,
                  labelHidden: true
                };
                this.dynamicDateTimeProperties.push(dateProb);
                this.dynamicDateTimeValues.push(dateValue);
              }
              this.formQuestions.addControl(field.fieldId.toString(), new FormControl(null, (field.isMandatory ? Validators.required : null)));
            }
          });
        }
      });
    }
  }
  getDynamicDateProperties(fieldId: number) {
    if (this.dynamicDateTimeProperties && this.dynamicDateTimeProperties.length > 0) {
      return this.dynamicDateTimeProperties.find(dataProb => dataProb.formControlName === fieldId.toString())
    }
  }
  onDynamicValueDateChange(date, index) {
    this.dynamicDateTimeValues[index] = date;
  }
  onApplyAllItems() {
    this.applyOnAllItems = this.formQuestions.get('allItems').value;
    if (this.applyOnAllItems) {
      this.formQuestions.get('itemsControl').setValue(null);
      this.formQuestions.get('itemsControl').disable();
    }
    else {
      this.formQuestions.get('itemsControl').enable();
    }
  }
  onPreviousClicked() {

    this.pageIndex = this.pageIndex - 1;
    this.pageNumber = this.pageNumber - 1;
  }
  onNextClicked() {
    this.continue = true;
    if (!this.isViewMode && this.surveyObject.pageGroupQuestions[this.pageIndex] && this.surveyObject.pageGroupQuestions[this.pageIndex].questions.length > 0) {
      this.surveyObject.pageGroupQuestions[this.pageIndex].questions.forEach(field => {
        if ((!this.getDynamicFieldControl(field.fieldId) || this.getDynamicFieldControl(field.fieldId).value == null) && field.isMandatory && this.continue) {
          this.getDynamicFieldControl(field.fieldId).markAsTouched();
          this.continue = false;
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
          return false;
        }
      });
    }
    if (this.continue) {
      this.pageIndex = this.pageIndex + 1;
      this.pageNumber = this.pageNumber + 1;
    }
  }
  onChangeYesNO(Id: number, fieldId: number) {
    // if (Id == 1) {
    //   this.getDynamicFieldControl(fieldId).setValue(null);
    //   this.discountPackGroupIdControl.disable();
    //   this.discountPackIdControl.setValue(null);
    //   this.discountPackIdControl.disable();
    //   this.discountDivisionIdControl.enable();
    // }
  }
  onSaveAndNew() {
    this.coreSession.markFormGroupTouched(this.formQuestions);
    if (this.formQuestions.valid) {
      this.fillSurveyReadingOject();
      if (this.actions && this.actions.length > 0) {
        this.showActionConfirmationDialog(false);
      }
      else {
        this.saveQualityControlReading(false);
      }


    }
    else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
  }
  onSaveAndClose() {
    this.coreSession.markFormGroupTouched(this.formQuestions);
    if (this.formQuestions.valid) {
      this.fillSurveyReadingOject();
      if (this.actions && this.actions.length > 0) {
        this.showActionConfirmationDialog(true);

      }
      else {
        this.saveQualityControlReading(true);
      }
    }
    else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
  }
  onSelectAllItems() {
    this.allItems = true;
  }
  onDeSelectAllItems() {
    this.allItems = false;
  }
  clearControls() {

    if (this.surveyObject.pageGroupQuestions && this.surveyObject.pageGroupQuestions.length > 0) {
      this.surveyObject.pageGroupQuestions.forEach(page => {
        page.questions.forEach((field) => {
          this.getDynamicFieldControl(field.fieldId).setValue(null);
          this.getDynamicFieldControl(field.fieldId).updateValueAndValidity();
          this.getDynamicFieldControl(field.fieldId).reset();
        });
      });
    }
    this.formQuestions.get('itemsControl').setValue([]);
    this.formQuestions.get('itemsControl').updateValueAndValidity();
    this.formQuestions.get('itemsControl').reset();
    this.continue = true;
    this.pageIndex = 0;
    this.pageNumber = 1;
  }
  getDynamicFieldControl(fieldId: number) {
    return this.formQuestions.get(fieldId.toString());
  }
  fillSurveyReadingOject() {
    this.actions = [];
    this.confirmAction = false;
    this.allFieldsAnswers = [];
    this.fieldAnswer = {};

    //this.actionReasonList = [];
    this.resultList = [];
    this.answerAsString = '';

    this.surveyReadingModel.surveyId = this.surveyObject.surveyId;
    this.surveyReadingModel.surveyName = this.surveyObject.surveyName;
    this.surveyReadingModel.surveyPeriodTypeId = this.surveyObject.surveyPeriodTypeId;
    if (this.surveyObject.warehouseTypeId == 1) {
      this.surveyReadingModel.warehouseId = this.surveyObject.warehouseId;
      this.isDamagedWarehouse = false;
      this.isOffload = false;
      this.surveyReadingModel.warehouseTransactionOperationId = WarehouseTransactionOperation.TransferOut.valueOf();
    }
    else if (this.surveyObject.warehouseTypeId == 2) {
      this.surveyReadingModel.vehicleId = this.surveyObject.warehouseId;
      this.isDamagedWarehouse = false;
      this.isOffload = true;
      this.surveyReadingModel.warehouseTransactionOperationId = WarehouseTransactionOperation.Offload.valueOf();
    }
    else if (this.surveyObject.warehouseTypeId == 4) {
      this.surveyReadingModel.damagedWarehouseId = this.surveyObject.warehouseId;
      this.isDamagedWarehouse = true;
      this.isOffload = false;
      this.surveyReadingModel.warehouseTransactionOperationId = WarehouseTransactionOperation.TransferOut.valueOf();
    }
    this.surveyReadingModel.surveyId = this.surveyObject.surveyId;
    this.surveyReadingModel.endDateModel = this.coreSession.GetCurrentDateTimeAsModel();
    this.surveyReadingModel.allItems = this.allItems;
    this.surveyReadingModel.appliedItems = this.formQuestions.get('itemsControl').value ? this.formQuestions.get('itemsControl').value : [];
    if (this.surveyReadingModel.allItems || (this.surveyObject.appliedItems.length == this.surveyReadingModel.appliedItems.length)) {
      this.surveyReadingModel.isCompletelyFilled = true;
    }
    //Dynamic Fields
    if (this.surveyObject.pageGroupQuestions && this.surveyObject.pageGroupQuestions.length > 0) {
      this.surveyObject.pageGroupQuestions.forEach(page => {
        page.questions.forEach((field, index) => {
          this.minValue = '';
          this.maxValue = '';
          this.specificValue = '';
          this.acceptableValueNote = '';
          this.answerAsString = '';
          this.fieldAnswer = {};
          this.fieldAnswer.surveyId = this.surveyObject.surveyId;
          this.fieldAnswer.fieldId = field.fieldId;
          this.fieldAnswer.fieldTypeId = field.fieldTypeID;
          this.fieldAnswer.appliedItems = this.formQuestions.get('itemsControl').value ? this.formQuestions.get('itemsControl').value : [];
          if (this.isDivisionLevel()) {
            this.fieldAnswer.appliedItems.forEach(item => {
              var itemIndex = this.surveyObject.appliedItems.findIndex(x => x.itemId === item.itemId)
              if (itemIndex > -1)
                item.divisionId = this.surveyObject.appliedItems[itemIndex].divisionId;
            });
          }
          this.fieldAnswer.lOVId = field.lovid;
          this.fieldAnswer.fieldValue = '';
          this.fieldAnswer.dateValueModel = null;
          let show = true;
          if (this.dependancyOnQuestionsList != null && this.dependancyOnQuestionsList.length > 0) {
            let dependentQuestionIndex = this.dependancyOnQuestionsList.findIndex(x => x.fieldId == field.fieldId);
            if (dependentQuestionIndex != -1)
              show = this.dependancyOnQuestionsList[dependentQuestionIndex].show;
          }
          if (show) {
            switch (field.fieldTypeID) {
              case 1:
                {
                  this.fieldAnswer.fieldValue = this.getDynamicFieldControl(field.fieldId).value !== null ? this.getDynamicFieldControl(field.fieldId).value.toString() : '';
                  if (this.fieldAnswer.fieldValue != '') {
                    if ((field.minValue > 0 || field.maxValue > 0)) {
                      //if (field.actionTypeIdString.includes('3') && (field.minValue > 0 || field.maxValue > 0)) {

                      if (
                        this.getDynamicFieldControl(field.fieldId) && this.getDynamicFieldControl(field.fieldId).value !== null &&

                        (this.getDynamicFieldControl(field.fieldId).value < field.minValue || this.getDynamicFieldControl(field.fieldId).value > field.maxValue)) {
                        if (field.actionTypeIdString.includes('3'))
                          this.confirmAction = true;
                        this.minValue = this.calculationService.getNumberOnDigitFormat(field.minValue).toString();
                        this.maxValue = this.calculationService.getNumberOnDigitFormat(field.maxValue).toString();
                        this.acceptableValueNote = this.translateService.instant(ConstantMessages.Desc_Acceptable_Value_Min_Max).replace('{0}', this.minValue).replace('{1}', this.maxValue);
                      }
                    }
                    this.answerAsString = this.fieldAnswer.fieldValue;
                  }
                }
                break;
              case 3:
              case 7:
                {
                  //get Value As Date
                  this.fieldAnswer.dateValueModel = this.dynamicDateTimeValues && this.dynamicDateTimeValues.length > 0 ? this.dynamicDateTimeValues[index] : null;
                  if (this.fieldAnswer.dateValueModel) {
                    // if (field.fieldTypeID == 3 && field.actionTypeIdString.includes('3') && ((field.minDateModel && field.minDateModel.date) || (field.maxDateModel && field.maxDateModel.date))) {
                    if (field.fieldTypeID == 3 && ((field.minDateModel && field.minDateModel.date) || (field.maxDateModel && field.maxDateModel.date))) {

                      if ((field.minDateModel == null && field.maxDateModel && this.fieldAnswer.dateValueModel && this.fieldAnswer.dateValueModel.date > field.maxDateModel.date) ||
                        (field.maxDateModel == null && field.minDateModel && this.fieldAnswer.dateValueModel && this.fieldAnswer.dateValueModel.date < field.minDateModel.date) ||
                        (field.minDateModel && field.maxDateModel && (this.fieldAnswer.dateValueModel.date < field.minDateModel.date || this.fieldAnswer.dateValueModel.date > field.maxDateModel.date))) {
                        if (field.actionTypeIdString.includes('3'))
                          this.confirmAction = true;
                        this.minValue = field.minDateModel != null ? this.datePipe.transform(field.minDateModel.date, this.sessionData.DateFormat).toString() : "---";
                        this.maxValue = field.maxDateModel != null ? this.datePipe.transform(field.maxDateModel.date, this.sessionData.DateFormat).toString() : "---";
                        this.acceptableValueNote = this.translateService.instant(ConstantMessages.Desc_Acceptable_Value_Min_Max).replace('{0}', this.minValue).replace('{1}', this.maxValue);
                      }
                    }
                    if (field.fieldTypeID == 3)
                      this.answerAsString = this.datePipe.transform(this.fieldAnswer.dateValueModel.date, this.sessionData.DateTimeFormat).toString();
                    else
                      this.answerAsString = this.datePipe.transform(this.fieldAnswer.dateValueModel.date, this.sessionData.TimeFormat).toString();
                  }
                }
                break;
              case 4:
                {
                  this.fieldAnswer.fieldValue = this.getDynamicFieldControl(field.fieldId).value ? this.getDynamicFieldControl(field.fieldId).value.toString() : '';
                  if (this.fieldAnswer.fieldValue != '') {
                    //  if (field.actionTypeIdString.includes('3') && this.getDynamicFieldControl(field.fieldId).value && ((this.getDynamicFieldControl(field.fieldId).value.toString() == '1' && field.yesNo) || (this.getDynamicFieldControl(field.fieldId).value.toString() == '0' && !field.yesNo))) {
                    if (this.getDynamicFieldControl(field.fieldId).value && ((this.getDynamicFieldControl(field.fieldId).value.toString() == '1' && field.yesNo) || (this.getDynamicFieldControl(field.fieldId).value.toString() == '0' && !field.yesNo))) {
                      if (field.actionTypeIdString.includes('3'))
                        this.confirmAction = true;
                      this.acceptableValueNote = this.fieldAnswer.fieldValue == '1' ? this.translateService.instant(ConstantMessages.Desc_No) : this.translateService.instant(ConstantMessages.Desc_Yes);
                    }
                    this.answerAsString = this.fieldAnswer.fieldValue == '1' ? this.translateService.instant(ConstantMessages.Desc_Yes) : this.translateService.instant(ConstantMessages.Desc_No);
                  }
                }
                break;
              case 5:
                {
                  this.fieldAnswer.fieldValue = this.getDynamicFieldControl(field.fieldId).value != null ? this.getDynamicFieldControl(field.fieldId).value.lovOptionID.toString() : '';
                  if (this.fieldAnswer.fieldValue != '') {
                    var lovOptionIdIndex = field.questionOptions.findIndex(x => x.lovOptionID === this.getDynamicFieldControl(field.fieldId).value.lovOptionID)
                    if (lovOptionIdIndex != -1) {
                      this.answerAsString = field.questionOptions[lovOptionIdIndex].lovOptionName;
                    }
                    // if (field.actionTypeIdString.includes('3') && ((this.getDynamicFieldControl(field.fieldId).value.lovOptionID == field.lovOptionID) && (this.getDynamicFieldControl(field.fieldId).value.lovid == field.lovid))) {
                    if (((this.getDynamicFieldControl(field.fieldId).value.lovOptionID == field.lovOptionID) && (this.getDynamicFieldControl(field.fieldId).value.lovid == field.lovid))) {
                      if (field.actionTypeIdString.includes('3'))
                        this.confirmAction = true;
                      this.acceptableValueNote = this.translateService.instant(ConstantMessages.Desc_Acceptable_Value_Certain).replace('{0}', this.answerAsString);

                    }
                  }
                }
                break;
              case 6:
                {
                  if (this.getDynamicFieldControl(field.fieldId).value != null) {
                    this.getDynamicFieldControl(field.fieldId).value.forEach(option => {
                      if (this.fieldAnswer.fieldValue == '') {
                        this.fieldAnswer.fieldValue = option.lovOptionID.toString();
                        this.answerAsString = option.lovOptionName;
                      }
                      else {
                        this.fieldAnswer.fieldValue = this.fieldAnswer.fieldValue + ',' + option.lovOptionID.toString();
                        this.answerAsString = this.answerAsString + ',' + option.lovOptionName;
                      }
                    });
                  }
                }
                break;
              default:
                {
                  this.fieldAnswer.fieldValue = this.getDynamicFieldControl(field.fieldId) && this.getDynamicFieldControl(field.fieldId).value !== null ? this.getDynamicFieldControl(field.fieldId).value.toString() : '';
                  this.answerAsString = this.fieldAnswer.fieldValue;
                }
                break;
            }
            this.allFieldsAnswers.push(this.fieldAnswer);
            this.resultList.push({
              field: field.questionName,
              answer: this.answerAsString,
              acceptableValueNote: this.acceptableValueNote
            });
          }
        });
      });
    }
    if (this.confirmAction) {
      this.actions.push(
        {
          operationHeader: this.isOffload ? this.translateService.instant(ConstantMessages.Desc_Offloading_Vehicles) : this.translateService.instant(ConstantMessages.Desc_Offloading_Warehouses),
          appliedItems: this.fieldAnswer.appliedItems,
          warehouseTransactionOperationId: this.surveyReadingModel.warehouseTransactionOperationId,
          isCollapsed: true
        }
      );
    }
    this.surveyReadingModel.fieldsAnswers = this.allFieldsAnswers;
    this.surveyReadingModel.actions = this.actions;
    //this.surveyReadingModel.actionReasons = this.actionReasonList;
    this.surveyReadingModel.resultList = this.resultList;
  }
  // saveReading() {

  // }
  saveQualityControlReading(close: boolean) {
    this.coreSession.ModalLoading.Show();
    this.qualityControlReadingService.saveQualityControlReading(this.surveyReadingModel).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          // this.onSaveCompleted.emit();
          if (this.formQuestions.get('itemsControl').value && this.surveyObject.appliedItems != null && this.surveyObject.appliedItems.length > 0) {
            this.formQuestions.get('itemsControl').value.forEach(element => {
              var itemIndex = this.surveyObject.appliedItems.findIndex(x => x.itemId === element.itemId)
              if (itemIndex > -1)
                this.surveyObject.appliedItems.splice(itemIndex, 1);
              this.surveyObject.appliedItems = this.surveyObject.appliedItems.slice();
            });
          }
          if (close)
            this.onSaveCompleted.emit();
          else
            this.clearControls();

        } else {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  // prepareRecallApproveConfirmation(recallId) {
  //   // 1. show dialog with data
  //   // 2. Process with save process
  //   this.showActionConfirmationDialog(response.data, recallId);

  // }
  showActionConfirmationDialog(close: boolean) {
    // 1. show dialog with data
    // 2. Process with save process
    var MWList = [];
    var vehiclesList = [];
    var customersList = [];
    //this.actions = [];
    // operationsToApprove containes the following properties :
    // recallOperation
    // caption
    // isCollapsed
    // partyList

    // MWList = this.actions.filter(x => x.recallOperation === RecallInternalOperationTypes.TransferOut);
    // vehiclesList = this.actions.filter(x => x.recallOperation === RecallInternalOperationTypes.VehicleOffload);
    // customersList = actionsList.filter(x => x.recallOperation === RecallInternalOperationTypes.ReturnOrder);

    if (MWList && MWList.length > 0) {
      // this.actions.push({ recallOperation: RecallInternalOperationTypes.TransferOut, caption: 'Desc_Offloading_Warehouses', isCollapsed: true, partyList: MWList });
    }
    if (vehiclesList && vehiclesList.length > 0) {
      //this.actions.push({ recallOperation: RecallInternalOperationTypes.VehicleOffload, caption: 'Desc_Offloading_Vehicles', isCollapsed: true, partyList: vehiclesList });
    }
    if (customersList && customersList.length > 0) {
      //this.actions.push({ recallOperation: RecallInternalOperationTypes.ReturnOrder, caption: 'Desc_Return_From_Customers', isCollapsed: true, partyList: customersList });
    }

    this.modalService.open(this.actionsConfirmationDialog, { centered: true }).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          this.saveQualityControlReading(close);
        }
      });
  }
  onGetUserLocation(fieldId: number) {
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(position => {
        this.lat = position.coords.latitude;
        this.lng = position.coords.longitude;
        this.getDynamicFieldControl(fieldId).setValue(this.lat + " ," + this.lng);
      });
    } else {

    }
  }
}
