import { Component, OnInit } from '@angular/core';
import { FormGroup, FormControl } from '@angular/forms';
import { Subject } from 'rxjs';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { IDateTimePickerProperties } from '../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { SurveyService } from '../../survey-managment/survey.service';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { HttpErrorResponse } from '@angular/common/http';
import { QualityControlReadingService } from '../../survey-managment/quality-control-reading.service';

@Component({
  selector: 'app-quality-control-reading-list',
  templateUrl: './quality-control-reading-list.component.html',
  styleUrls: ['./quality-control-reading-list.component.css']
})
export class QualityControlReadingListComponent implements OnInit {

  surveyFilterForm: FormGroup;
  surveyFilter = {
    customListFilter: {
      searchFilter: "",
      page: 0,
      pageSize: 15
    },
    surveyName: "",
    includeInactive: false
  };

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  saveSubject: Subject<void> = new Subject<void>();
  TabelData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: true,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Form_Name",
        key: "surveyName",
        isSortable: true,
        width: "18%"
      },
      {
        title: "Desc_Warehouse_Vehicle_Code_Name",
        key: "warehouse",
        isSortable: true,
        width: "18%"
      },
      {
        title: "Desc_Filling_Date",
        key: "readingDate",
        isSortable: false,
        width: "17%",
        isDate: true
      },
      {
        title: "Desc_Valid_To",
        key: "readingValidTo",
        isSortable: false,
        width: "17%",
        isDate: true
      }
      ,
      {
        title: "Desc_Vendor",
        key: "organizationCodeName",
        isSortable: false,
        width: "20%"
      }
      ,
      {
        title: "Desc_Status",
        key: "status",
        isSortable: false,
        width: "10%"
      }
    ]
  };

  addedQuestions: any[] = [];
  query: any = {

  };
  selectedItemId = -1;
  isMinimized = false;
  showSlider = false;
  isFilterOpend = false;
  surveyObject: any;
  validToDate: any;
  isViewMode = false;

  constructor(private coreSession: CoreSession,
    private qualityControlReadingService: QualityControlReadingService,
    private translateService: TranslateService) { }

  ngOnInit() {
    this.coreSession.SetTitle('Quality Control Reading');
    this.getInspectorSurveys();
    this.addActions();
    this.initForm();
  }

  getInspectorSurveys() {
    this.coreSession.ModalLoading.Show();
    this.qualityControlReadingService.getInspectorSurveys(this.query).subscribe(
      response => {
        (response.data, "Surveys");
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = {
            data: response.data,
            totalItems: response.data.length
          }
        } else {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(ConstantMessages.ErrorCaption, response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  initForm() {
    this.surveyFilterForm = new FormGroup({
      surveyName: new FormControl(""),
      includeInactive: new FormControl(false),
      toDate: new FormControl(),
    });
  }
  getSurveyQuestions(dcfid: any) {
    this.coreSession.ModalLoading.Show();
    this.qualityControlReadingService.getSurveyQuestions(dcfid).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          (response.data, "questions");
          this.addedQuestions = response.data;
          this.dataSource = {
            data: response.data,
            totalItems: response.data.length
          }
          this.surveyObject.numberOfQuestions = this.dataSource.totalItems;
          this.surveyObject.questions = this.addedQuestions;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  getSurveyData(survey: any, isClone: boolean) {
    this.coreSession.ModalLoading.Show();
    this.qualityControlReadingService.getSurveyData(survey.surveyId, survey.dcfid, survey.warehouseId, survey.readingId, survey.organizationID, isClone).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data) {
            this.surveyObject = response.data;
            this.surveyObject.surveyName = survey.surveyName;
            this.surveyObject.inActive = survey.inActive;
            this.surveyObject.numberOfQuestions = survey.numberOfQuestions;
            this.surveyObject.timeToFill = survey.timeToFill;
            this.surveyObject.surveyPeriodTypeId = survey.surveyPeriodTypeId;
            this.surveyObject.warehouse = survey.warehouse;
            this.surveyObject.warehouseTypeId = survey.warehouseTypeId;
            this.surveyObject.isFilled = survey.isFilled;
            this.surveyObject.isCompletelyFilled = survey.isCompletelyFilled;
            this.surveyObject.readingId = survey.readingId;
            this.surveyObject.readingDate = survey.readingDate;
            this.showSlider = true;
            if (survey.readingId == -1)
              this.isViewMode = false;
            else
              this.isViewMode = true;
          }
        }
        else {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  addActions() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.qcReadingURL, MenuActions.Add)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.edit,
          title: 'Desc_Edit',
          icon: 'fa-regular fa-pen-to-square',
          color: "#12344d",
          showWhenKeyValueFalse: true,
          showHideOptionPerLine: true,
          controlKeyName: 'isFilled'
        });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.qcReadingURL, MenuActions.View)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.View,
          title: 'Desc_View',
          icon: 'fa-regular fa-eye',
          color: "#12344d",
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: 'isFilled'
        });
    }
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
      case RowOperation.View:
        this.getSurveyData(event.object, false);
        break;
    }
  }
  onToDateSelected(date) {
    this.validToDate = date;
  }
  onMinimized() {
    this.isMinimized = !this.isMinimized;
  }
  closeSlider() {
    this.showSlider = false;
    this.getInspectorSurveys();
  }
  openFilter() {
    this.isFilterOpend = !this.isFilterOpend;
    this.isMinimized = true;
  }
  openEditItem(object: any) {
    this.surveyObject = object;
    this.showSlider = true;
  }
  onSaveClick() {
    this.saveSubject.next();
  }
  onSurveySaved() {
    this.closeSlider();
  }
  onTableFilterChanged(query: any) {
    this.query.customListFilter = query;
    this.getInspectorSurveys();
  }
  ValidToDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Valid_To',
    formControlName: 'toDate',
    isCalendarOnly: true
  };
  ApplySerachFilterOnFind() {
    (this.query.surveyName =
      this.surveyFilterForm.get("surveyName").value == null
        ? ""
        : this.surveyFilterForm.get("surveyName").value),
      (this.query.validTo =
        this.validToDate == null || this.validToDate == undefined
          ? null
          : this.validToDate.date),
      (this.query.active =
        this.surveyFilterForm.get("includeInactive").value == null ||
          this.surveyFilterForm.get("includeInactive").value == undefined
          ? false
          : this.surveyFilterForm.get("includeInactive").value);

    (this.query, "query");
    this.getInspectorSurveys();
  }
  onReset() {
    this.surveyFilterForm.get("surveyName").reset();
    this.surveyFilterForm.get("includeInactive").reset();
    this.surveyFilterForm.get("toDate").reset();
    this.validToDate = null;
  }
}
