import { Component, OnInit, EventEmitter, Input, Output, OnDestroy, ViewChild } from "@angular/core";
import { FormGroup, FormControl, Validators } from "@angular/forms";
import { ITableProperties } from "../../../../../shared/models/shared-table/table-properties.interface";
import { SharedTableResult } from "../../../../../shared/models/shared-table/shared-table-result.interface";
import { SurveyService } from "../../survey.service";
import { CoreSession } from "../../../../../core/core.session";
import { TranslateService } from "@ngx-translate/core";
import { ConstantMessages } from "../../../../../shared/models/constants/constant-message";
import { CustomerService } from "../../../../../shared/services/data-definition/customer/customers.service";
import { Observable, Subject, forkJoin } from "rxjs";
import { IDateTimePickerProperties } from "../../../../../shared/models/dateTimeModel/date-time-properties.interface";
import { ITextInput } from "../../../../../shared/models/shared-table/custom-list.interface";
import { MultiSelectionOperation, RowOperation } from "../../../../../shared/models/enums/shared-table-operation.enum";
import { DialogMode } from "../../../../../shared/models/enums/dialog-mode.enum";
import { DialogResult } from "../../../../../shared/models/enums/dialog-result.enum";
import { WarehouseService } from '../../../../../shared/services/data-definition/warehouse-and-vehicle/warehouse.service';
import { WarehouseTypes } from '../../../../../shared/models/enums/warehouse-types.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { SurveyTypes } from '../../../../../shared/models/enums/survey-types.enum';
import { SurveyActionsTypes } from '../../../../../shared/models/enums/survey-actions-types.enum';
import { EmployeeService } from '../../../../employee/employee.service';
import { ConstantConfigurations } from "../../../../../shared/models/constants/constant-configuration";
import { SessionDataProvider } from "../../../../../core/session-data-provider.service";
import { NgbModal } from "@ng-bootstrap/ng-bootstrap";
import * as cloneDeep from 'lodash/cloneDeep';
import { SelectItemsComponent } from "../../../../../shared/components/items/select-items/select-items.component";
import { CustomerGroupModel } from "../../../../../shared/models/customer/customer.group.model";
import { CommonButtonStyles } from "../../../../../shared/models/enums/common-button-styles.enum";
import { SelectCustomersComponent } from "../../../../../shared/components/customers/select-customers/select-customers.component";
import { SharedDialogComponent } from "../../../../../shared/components/shared-dialog/shared-dialog.component";
import { SurveyPeriod } from "../../../../../shared/models/survey/surveyPeriod";
import { SurveyPeriodTypes } from "../../../../../shared/models/enums/survey-period-types.enum";
import { DateTimeModel } from "../../../../../shared/models/dateTimeModel/date-time.model";
import { templateJitUrl } from "@angular/compiler";
import { SelectDisplayUnitComponent } from "../../../../../shared/components/display-unit/select-display-unit/select-display-unit.component";
import { VehicleService } from "../../../../../shared/services/data-definition/warehouse-and-vehicle/vehicle.service";
import { EmployeeSurveyService } from "../../../../../shared/services/data-definition/dynamic-form/employee-survey.service";
import { CustomerSurveyService } from "../../../../../shared/services/data-definition/dynamic-form/customer-survey.service";
import { CustomerAppSurveyService } from "../../../../../shared/services/data-definition/dynamic-form/customer-app-survey.service";
import { ConstantURLs } from "../../../../../shared/models/constants/constant-URL";
import { MenuActions } from "../../../../../shared/models/enums/menu-actions-enum";
import { ListOfValueService } from "../../../../../shared/services/data-definition/dynamic-form/list-of-value.service";


@Component({
  selector: "app-customer-survey-entry",
  templateUrl: "./customer-survey-entry.component.html",
  styleUrls: ["./customer-survey-entry.component.css"]
})
export class CustomerSurveyEntryComponent implements OnInit, OnDestroy {

  constructor(
    private surveyService: SurveyService,
    private employeeSurveyService: EmployeeSurveyService,
    private customerSurveyService: CustomerSurveyService,
    private customerAppSurveyService: CustomerAppSurveyService,
    public coreSession: CoreSession,
    private translateService: TranslateService,
    private customerService: CustomerService,
    private warehouseService: WarehouseService,
    private vehicleService: VehicleService,
    private employeeservice: EmployeeService,
    private sessionData: SessionDataProvider,
    private modalService: NgbModal,

    private listOfValueService: ListOfValueService
  ) { }

  //#region Declaration
  //#region Quality Control Declaration
  @Input() surveyTypeId: number;
  @Input() openedFromPromotionEntry = false;
  @Input() isCloneMode: boolean = false;
  //General
  @ViewChild("templateEntry", { static: true }) newPackGroup: SharedDialogComponent;
  lastSelectedOrganizationList: any[] = [];
  isSurveyPeriodTypesLoading: boolean = false;
  surveyPeriodTypesList: any[] = [];
  selectedSurveyPeriodTypeId: number = -1;
  //Fields
  isActionTypeLoading: boolean = false;
  actionTypesList: any[] = [];
  actionTypesDropdownSettings = {
    singleSelection: false,
    idField: 'actionTypeId',
    textField: 'actionTypeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 1
  };

  minDate: any = [];
  maxDate: any = [];
  isDisplayUnitSurvey = false;
  minDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Min',
    formControlName: 'minDate',
    isCalendarOnly: true
  };
  maxDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Max',
    formControlName: 'maxDate',
    isCalendarOnly: true
  };
  isYesNoLoading: boolean = false;
  yesNoList: any[] = [];
  selectedYesNoId: number = -1;

  isListValuesLoading: boolean = false;
  listValues: any[] = [];
  selectedLOVOptionId: number = -1;

  listOfLOVOptions: any[] = [];

  isQuestionDependentLoading: boolean = false;
  questionDependentList: any[] = [];
  selectedDependentQuestionId: number = null;

  isAnswerDependentLoading: boolean = false;
  answerDependentList: any[] = [];
  selectedDependentAnswerId: number = -1;

  disableActions: boolean = false;
  numberOfDigits = 0;
  //Apply To
  isInspectorsLoading: boolean = false;
  inspectorsList: any[] = [];
  inspectorDropdownSettings = {
    singleSelection: false,
    idField: 'employeeId',
    textField: 'employeeCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };
  allEmployeesList: any[] = [];
  availableEmployees: any[] = [];
  employeeDropdownSettings = {
    singleSelection: false,
    idField: 'employeeId',
    textField: 'employeeCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };
  //#region Display Unit Apply To

  displayUnitList: any[] = [];
  appliedDisplayUnit: any[] = [];

  displayUnitDropdownSettings = {
    singleSelection: false,
    idField: 'displayUnitID',
    textField: 'displayUnitName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 4
  };

  displayUnitTypeList: any[] = [];
  appliedDisplayUnitType: any[] = [];

  displayUnitTypeDropdownSettings = {
    singleSelection: false,
    idField: 'displayUnitTypeID',
    textField: 'displayUnitTypeName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 4
  };

  //#endregionDisplay Unit Apply To
  isWarehousesLoading: boolean = false;
  warehousesList: any[] = [];
  warehouseDropdownSettings = {
    singleSelection: false,
    idField: 'warehouseId',
    textField: 'warehouseNameCode',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };

  isLoadingVehiclesLoading: boolean = false;
  vehiclesList: any[] = [];
  vehicleDropdownSettings = {
    singleSelection: false,
    idField: 'vehicleId',
    textField: 'vehicleNameCode',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };
  vehiclesFilter: any = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    includeInactive: false,
    employeeId: -1,
    organizationIds: '',
    organizationId: -1
  };

  isDamagedWarehousesLoading: boolean = false;
  damagedWarehousesList: any[] = [];
  damagedWarehousesDropdownSettings = {
    singleSelection: false,
    idField: 'warehouseId',
    textField: 'warehouseNameCode',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };

  appliedInspectors: any[] = [];
  appliedWarehouses: any[] = [];
  appliedVehicles: any[] = [];
  appliedDamagedWarehouses: any[] = [];
  appliedItems: any[] = [];
  appliedEmployeesList: any[] = [];
  applyOnAllItems: boolean = false;
  //#endregion
  navLinks: any[];
  navBarSelectedIndex: number = 0;
  @Input() surveyObject: any;
  @Input() events: Observable<void>;
  @Output() onSaveCompleted = new EventEmitter();
  saveSubject: Subject<void> = new Subject<void>();
  saveLOVSubject: Subject<void> = new Subject<void>();
  afterNewLOVSaved: boolean = false;
  selectedNewLOV = null;
  formGeneral: FormGroup;
  surveyFullObject: any;
  formQuestions: FormGroup;
  formApplyTo: FormGroup;
  mustFillPeriodForm: FormGroup
  tabGroupIndex = -1;
  selectedTypeId: any;
  selectedGroupId: any;
  organizationId: number;
  numberofAddedQuestions: number = 0;
  editQuestionIndex: number = -1;
  selectedChannelId: any;
  selectedSecurityGroupId: any;
  validFromDate: any = [];
  validToDate: any = [];
  buttonText = "Desc_Add";
  releaseTypeDataSource: any[] = [];
  deletedQuestionList: any[] = [];
  organizationsList: any[] = [];
  allSecurityGroupList: any[] = [];
  availableSecurityGroups: any[] = [];
  addedSecurityGroups: any[] = [];
  addedGroups: any[] = [];
  isEditMode: boolean = false;
  addNewGroup: boolean = false;
  addNewLOV: boolean = false;
  isCustomPeriod: boolean = false;
  listOfPeriodsViewTable: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  listOfPeriods: any[] = [];;
  fromDatePeriod: DateTimeModel;
  toDatePeriod: DateTimeModel;
  allowSelectSecurityGroup: boolean = false;
  allSecurityGroups: boolean = false;
  isCustomerGroupLoading: boolean = false;
  isOrganizationLoading: boolean = false;
  isChannelLoading: boolean = false;
  resetValues: EventEmitter<boolean> = new EventEmitter();
  selectedCustomerOutletName = "";
  selectedGroupName = "";
  selectedChannelSubChannelName = "";
  selectedSecurityGroupName = "";
  customerId: number;
  outletId: number;
  addedQuestions: any[] = [];
  questionTypeList: any[] = [];
  questionSubTypeList: any[] = [];
  forceFillingModeList: any[] = [];
  appliedSubTypeList: any[] = [];
  questionValuesList: any[] = [];
  xList: any[] = [];
  yList: any[] = [];
  groupList: any[] = [];
  saveBtnSubscription: any;
  surveyNameOtherLanguages: any[] = [];
  questionNameOtherLanguages: any[] = [];
  editQuestionNameLanguages: any[] = [];
  questionBodyOtherLanguages: any[] = [];
  editQuestionBodyLanguages: any[] = [];
  periodeDateListTableProperties: ITableProperties = {
    pageSize: 25,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      }
    ],
    multiSelectionOperations: [],
    columns: [{
      title: "Desc_From",
      key: "fromDate",
      isSortable: false,
      width: "50%",
      // isDate: true,
      isExpiryDate: true
    }
      ,
    {
      title: "Desc_To",
      key: "toDate",
      isSortable: false,
      width: "50%",
      // isDate: true,
      isExpiryDate: true
    }
    ]
  }
  surveyNameInput: ITextInput = {
    formControlName: "surveyName",
    placeHolder: "Desc_Form_Name",
    label: "Desc_Form_Name",
    isRequierd: true
  };
  letterHeadOtherLanguages: any[] = [];
  letterHeadInput: ITextInput = {
    formControlName: "letterHead",
    placeHolder: "Desc_Letter_Head",
    label: "Desc_Letter_Head",
    isTextArea: true,
    isRequierd: false
  };
  questionNameInput: ITextInput = {
    formControlName: "questionName",
    placeHolder: "Desc_Question",
    label: "Desc_Question",
    isRequierd: true
  };

  questionBodyInput: ITextInput = {
    formControlName: "questionBody",
    placeHolder: "Desc_Question_Body",
    isTextArea: true,
    label: "Desc_Question_Body",
    isRequierd: true
  };
  dropDownSettings = {
    singleSelection: false,
    idField: 'securityGroupId',
    textField: 'securityGroupName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    itemsShowLimit: 6,
    maxHeight: 150
  };
  appliedToList: any[] = [];
  AppliedToTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: false,
    isOnline: false,
    showEditButton: false,
    showSearchBtn: false,
    showNewBtn: false,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      }
    ],
    multiSelectionOperations: [],
    columns: [{
      title: "Desc_Customer",
      key: "customerOutletName",
      isSortable: false,
      width: "33.3%"
    },
    {
      title: "Desc_Groups",
      key: "groupName",
      isSortable: false,
      width: "33.3%"
    },
    {
      title: "Desc_Channel",
      key: "channelName",
      isSortable: false,
      width: "33.3%"
    }
    ]
  };
  TableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    rowOperations: [
      {
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      }, {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      }
      ,
      {//arrow UP
        operation: RowOperation.approve,
        title: "Desc_Up",
        icon: "fa fa-arrow-up",
        color: "#12344d"
      }
      ,
      {//arrow Down
        operation: RowOperation.invoiceOrder,
        title: "Desc_Down",
        icon: "fa fa-arrow-down",
        color: "#12344d"
      }
    ],
    multiSelectionOperations: [],
    columns: [{
      title: "Desc_Name",
      key: "questionName",
      isSortable: false,
      width: "33.3%"
    }
      ,
    {
      title: "Desc_Type",
      key: "questionTypeName",
      isSortable: false,
      width: "33.3%"
    }
      ,
    {
      title: "Desc_Is_Barcode",
      key: "isBarcode",
      isSortable: false,
      width: "33.3%"
    }
    ]
  };
  //#region[Must Fill]
  MustFillFromDateProperties: IDateTimePickerProperties = {
    label: 'Desc_From',
    formControlName: 'fromDate',
    isCalendarOnly: true,
    min: new Date(),
    max: new Date()
  };
  MustFillToDateProperties: IDateTimePickerProperties = {
    label: 'Desc_To',
    formControlName: 'toDate',
    isCalendarOnly: true,
    min: new Date(),
    max: new Date()
  };
  //#endregion

  ValidFromDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Valid_From',
    formControlName: 'fromDate',
    isCalendarOnly: true
  };
  ValidToDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Valid_To',
    formControlName: 'toDate',
    isCalendarOnly: true
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  appliedToDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  selectedType: any = [];
  maxFieldIdForAdd = -1;
  allCustomers: boolean = false;
  // forceFillingSurvey: boolean = false;
  allEmployees: boolean = false;
  isConfigShowAsMainMenu: boolean = false;
  showAsMainMenu: boolean = false;
  imagesNames: any[] = [];
  imagesPaths: { imageName: string, path: string, isChecked: boolean }[];
  selectedIconName: string = '';
  @ViewChild("surveyIconDialog", { static: true }) surveyIconDialog: NgbModal;
  OkResult: DialogResult = DialogResult.Ok;
  organizationDropdownSettings = {
    singleSelection: false,
    idField: 'organizationId',
    textField: 'organizationCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 2,
  };
  periodDropdownSettings = {
    singleSelection: true,
    idField: 'periodTypeId',
    textField: 'periodTypeName',
    selectAllText: 'Desc_Select_All',
    unSelectAllText: 'Desc_UnSelect_All',
    searchPlaceholderText: this.translateService.instant(ConstantMessages.SearchCaption),
    allowSearchFilter: true,
    itemsShowLimit: 4,
  };
  organizationIdsString: string = "";
  disableSaveDialog: boolean = true;
  customPeriodClass = 'custom-period-btn';

  //#region Items Modal
  addedItemsList: any[] = [];
  addedDisplayUnitList: any[] = [];
  copyOfAddedItems: any[] = [];
  copyOfAddeDisplayUnit: any[] = [];
  @ViewChild("selectItemsDialog", { static: true }) selectItemsDialog: SelectItemsComponent;
  @ViewChild("selectDisplayUnitDialog", { static: true }) selectDisplayUnitDialog: SelectDisplayUnitComponent;
  itemsDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };
  displayUnitDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };

  itemsSharedTabel: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showEditButton: false,
    showNewBtn: true,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Items', key: 'itemCodeName', isSortable: true, width: '100%' }
    ]
  };
  //#endregion

  //#region customers modal
  @ViewChild("selectCustomerDialog", { static: true }) selectCustomerDialog: SelectCustomersComponent;
  allGroupsList: CustomerGroupModel[] = [];
  availableGroups: any[] = [];
  allChannelsList: any[] = [];
  groupSelected: any[];
  addedCustomersList: any[] = [];
  copyOfAddedCustomers: any[] = [];
  showSelectCustomersDialog = false;
  ddlGroupSettings = {
    singleSelection: false,
    idField: 'groupId',
    textField: 'groupName',
    selectAllText: this.translateService.instant(ConstantMessages.SelectAllCaption),
    unSelectAllText: this.translateService.instant(ConstantMessages.UnSelectAllCaption),
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: this.translateService.instant(ConstantMessages.SearchCaption),
    itemsShowLimit: 1
  };
  ddlChannelSettings = {
    singleSelection: false,
    idField: 'channelSubChannelIds',
    textField: 'channelSubChannelDescriptions',
    selectAllText: this.translateService.instant(ConstantMessages.SelectAllCaption),
    unSelectAllText: this.translateService.instant(ConstantMessages.UnSelectAllCaption),
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: this.translateService.instant(ConstantMessages.SearchCaption),
    itemsShowLimit: 1
  };
  customersDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };
  customersSharedTabel: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: true,
    showNewBtn: true,
    showEditButton: false,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
    ],
    multiSelectionOperations: [{
      operation: MultiSelectionOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e',
      style: CommonButtonStyles.Negative.valueOf()
    }],
    columns: [
      { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' }
    ]
  };

  hidePageGroup = false;
  //#endregion
  isLinkedToPromotion = false;
  isYesNoQuestion = false;
  isBarcode = false;
  ListValueMandatoryError = false;
  AnswerMandatoryError = false;
  allSubTypesList: any[] = [];
  showAddNewPageGroup = false;
  showAddNewLov = false;
  //#endregion

  showSelectDisplayUnitDialog = false;
  displayUnitSharedTabel: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showEditButton: false,
    showNewBtn: true,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Display_Unit', key: 'displayUnitName', isSortable: true, width: '50%' },
      { title: 'Desc_Serial_Number', key: 'serialNumber', isSortable: true, width: '50%' },
    ]
  };

  hideMatrixSection: boolean = false;
  hideListOfValues: boolean = false;
  allowDefineDynamicParameter: boolean = false;
  selectedParameter: string = '';
  isSelectedParameterUsedInLOV: boolean = false;
  selectedDependentQuestion: any;
  selectedFieldType: any;
  selectedLOVId: any;
  isQuestionEditMode: boolean = false;
  editedQuestionLOVId: any;
  editedQuestionLOV: any;
  editedQuestion: any;
  originalQuestionValuesList: any[] = [];
  EnableMenuByRouteStatus: boolean;

  attachmentFieldLabel: string = '';
  //#region Methods
  ngOnInit() {

    this.EnableMenuByRouteStatus =
     this.sessionData.getConfigurationValue(ConstantConfigurations.EnableMenuByRouteStatus).toLowerCase() === "true";

    if (this.isCloneMode) {
      this.surveyObject = cloneDeep(this.surveyObject);
      this.surveyObject.surveyName = "Clone of " + (this.surveyObject.surveyName && this.surveyObject.surveyName.trim() != "" ? this.surveyObject.surveyName : "");
    }
    this.showAddNewLov = this.coreSession.checkActivitiesAvailability(ConstantURLs.listOfValues, MenuActions.Add);
    if (this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()) {
      this.showAddNewPageGroup = this.coreSession.checkActivitiesAvailability(ConstantURLs.dynamicFormsURL, MenuActions.Add);
    }
    else if (this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf()) {
      this.showAddNewPageGroup = this.coreSession.checkActivitiesAvailability(ConstantURLs.customerAppSurveysURL, MenuActions.Add);
    }
    else if (this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf()) {
      this.showAddNewPageGroup = this.coreSession.checkActivitiesAvailability(ConstantURLs.employeeFormsURL, MenuActions.Add);
    }
    else if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf()) {
      this.showAddNewPageGroup = this.coreSession.checkActivitiesAvailability(ConstantURLs.qcReadingURL, MenuActions.Add);
    }
    else if (this.surveyTypeId == SurveyTypes.POSSurvey.valueOf()) {
      this.showAddNewPageGroup = this.coreSession.checkActivitiesAvailability(ConstantURLs.displayUnitSurveyURL, MenuActions.Add);
    }
    this.surveyObject
    if (this.surveyObject) {
      this.isEditMode = !this.isCloneMode;
    } else {
      this.surveyObject = [];
    }
    if (this.surveyTypeId != 3) {
      this.hidePageGroup = true;
    } else if (this.surveyTypeId != 3) {
      this.hidePageGroup = true;
    }




    this.subscribeSaveClick();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
    this.initForm();
    this.FillUI();
    this.fillYesNoList();
    this.getLOVOptions(-1);
    this.dropDownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropDownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.organizationDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.organizationDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.organizationDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.fillSurveyPeriodTypesList();
    if (this.coreSession.selectedLanguageId === 2) {
      this.customPeriodClass = 'custom-period-btn-ltr';
    }

    if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf()) {
      this.fillActionsTypesList();
      //this.fillInspectorsList();
      //this.fillLoadingWarehousesList();
      //this.fillVehiclesList();
      //this.fillDamagedWarehousesList();
      this.warehouseDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
      this.warehouseDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
      this.warehouseDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

      this.inspectorDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
      this.inspectorDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
      this.inspectorDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

      this.vehicleDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
      this.vehicleDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
      this.vehicleDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

      this.damagedWarehousesDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
      this.damagedWarehousesDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
      this.damagedWarehousesDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

      this.actionTypesDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
      this.actionTypesDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
      this.actionTypesDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    }
    else if (this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf()) {
      //this.fillEmployeesList();
      this.employeeDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
      this.employeeDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
      this.employeeDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    }
    else if (this.surveyTypeId == SurveyTypes.POSSurvey.valueOf()
      || this.surveyTypeId == SurveyTypes.POSStockCounting.valueOf()) {
      this.isDisplayUnitSurvey = true;
      this.populateDisplayUnitList();
      this.displayUnitDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
      this.displayUnitDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
      this.displayUnitDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

      this.populateDisplayUnitTypeList();
      this.displayUnitTypeDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
      this.displayUnitTypeDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
      this.displayUnitTypeDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    }

    if (this.surveyTypeId == SurveyTypes.CustomerSurvey || this.surveyTypeId == SurveyTypes.EmployeeSurvey) {
      this.isConfigShowAsMainMenu = this.sessionData.getConfigurationValue(ConstantConfigurations.ShowSurveyAsMenu).toLowerCase() === "true";
    }

    //#region  EditMode
    if (this.isEditMode || this.isCloneMode) {
      if (this.surveyObject.allCustomers && (this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf() || this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf())) {
        this.onAllCustomersChange();
        //this.navLinks[2].disable = true;
      }
      if (this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf() && this.surveyObject.allOrganizationEmployees) {
        this.onAllEmployeesChange();
        //this.navLinks[2].disable = true;
      }
      if ((this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf() || this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf())) {
        if (this.surveyObject.allSecurityGroups)
          this.onAllSecurityGroupsChange();
        if (this.surveyObject.isMainMenu)
          this.onShowAsMainMenuChange();
        //this.navLinks[2].disable = true;
      }
      if (this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf() || this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf()) {
        this.getAppliedList(this.surveyObject.surveyId);
      }
      else if (this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf()) {
        this.getEmployeeAppliedList(this.surveyObject.surveyId);
      }
      // else if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf()) {
      //   this.getQualityControlAppliedList(this.surveyObject.surveyId);
      // }
      else if (this.surveyTypeId == SurveyTypes.POSSurvey.valueOf()
        || this.surveyTypeId == SurveyTypes.POSStockCounting.valueOf()) {
        this.getDisplayUnitAppliedList(this.surveyObject.surveyId);

      }
      this.getSurveyQuestions(this.surveyObject.dcfid);
      this.organizationsListControl.setValue(this.surveyObject.organizationsList);
      this.getSelectedOrganizationIdsAsString(this.surveyObject.organizationsList);
      this.onChangeOrganization(false);

    }

    //#endregion EditMode

    this.EnableDisableListValues(-1);
    this.onQuestionTypeChange(-1);
    this.onMatrixChange();
    this.onApplyAllSecurity();
    this.populateChannelsSubChannelsList();
    this.populateGroupsList();
    //this.onApplyAllItems();

    // If Survey entry from promotion screen then the flag linked to promotion should be true;
    if (this.openedFromPromotionEntry) {
      this.formGeneral.get('linkedToProm').setValue(true);
      this.onChangeLinkedToPromotionFlag();
    }
    if ((this.isEditMode || this.isCloneMode) && this.forceOrganizationFilterForCustomerGroups()) {
      this.getSelectedOrganizationIdsAsString(this.surveyObject.organizationsList);
      this.populateGroupsList();
    }
  }
  initForm() {
    let organizationId = -1;
    let forceFill = 0;
    let applyForNewCustomers = false;
    let linkedToProm = false
    let inActive = false;
    let timeToFill = 0;
    let surveySequence = null;
    let routeHistoryStatusId = null;
    let numberOfQus = -1;
    let toDate = "";
    let fromDate = "";
    let letterHead = "";
    let surveyName = "";
    let organizationCode = "";
    let allSecurityGroups = "";
    let allCustomers = false;
    let allEmployees = false;
    let isMainMenu = false;
    let organizationsList = [];
    //Quality  Control
    let periodTypeId = -1;
    //Echo
    let points = 0;

    if (this.isEditMode || this.isCloneMode) {
      organizationId = this.surveyObject.organizationID;
      forceFill = this.surveyObject.forceFillingMode;//hazem
      applyForNewCustomers = this.surveyObject.applyForNewCustomers;
      linkedToProm = this.surveyObject.linkedToProm;
      this.isLinkedToPromotion = linkedToProm;
      if (this.isLinkedToPromotion) {
        this.navLinks[2].hidden = true;
      }
      inActive = this.surveyObject.inActive;
      timeToFill = this.surveyObject.timeToFill;
      surveySequence = this.surveyObject.surveySequence;
      routeHistoryStatusId = this.surveyObject.routeHistoryStatusId;
      numberOfQus = this.surveyObject.numberOfQuestions;
      toDate = this.surveyObject.validTo;
      fromDate = this.surveyObject.validFrom;
      this.validFromDate = this.surveyObject.validFromModel;
      this.validToDate = this.surveyObject.validToModel;
      letterHead = this.surveyObject.letterHead;
      surveyName = this.surveyObject.surveyName;
      organizationCode = "";
      periodTypeId = this.surveyObject.surveyPeriodTypeId;
      points = this.surveyObject.points;
      allCustomers = this.surveyObject.allCustomers;
      allEmployees = this.surveyObject.allOrganizationEmployees;
      allSecurityGroups = this.surveyObject.allSecurityGroups;
      isMainMenu = this.surveyObject.isMainMenu;
      organizationsList = this.surveyObject.organizationsList;
      if (!this.isLinkedToPromotion && this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()) {//..hazem && this.surveyObject.forceFillingMode > 0
        this.navLinks[3].hidden = false;
        if (this.surveyObject.forceFillingMode == 0)
          this.navLinks[3].disable = true
        else
          this.navLinks[3].disable = false
      }
      else {
        this.navLinks[3].hidden = true;
        this.navLinks[3].disable = true
        this.ValidToDateProperties.min = new Date(fromDate);
      }
      this.setMustFillMinDates(new Date(fromDate));
      this.setMustFilMaxDates(new Date(toDate));
    } else {
      if (!this.isLinkedToPromotion && this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()) {
        if (this.surveyObject.forceFillingMode > 0) {
          this.navLinks[3].disable = false
        } else {
          this.navLinks[3].disable = true
        }
      }
      else {
        this.navLinks[3].hidden = true;
      }
    }
    this.formGeneral = new FormGroup({
      organizationsList: new FormControl(organizationsList, Validators.required),
      forceFill: new FormControl({ modeId: forceFill, modeDescription: this.getForceFillingModeDescription(forceFill) }, Validators.required),
      applyForNewCustomers: new FormControl(applyForNewCustomers),
      linkedToProm: new FormControl({ value: linkedToProm, disabled: (((this.isEditMode || this.isCloneMode) && this.isLinkedToPromotion) || this.openedFromPromotionEntry ? true : false) }),
      inActive: new FormControl(inActive),
      timeToFill: new FormControl(
        timeToFill === -1 ? null : timeToFill,
        Validators.required
      ),
      surveySequence: new FormControl(surveySequence === null ? null : surveySequence),
      routeHistoryStatusId : new FormControl(routeHistoryStatusId === -1 ? null : routeHistoryStatusId),
      numberOfQus: new FormControl(numberOfQus == -1 ? undefined : numberOfQus),
      toDate: new FormControl(toDate, !linkedToProm ? Validators.required : Validators.nullValidator),
      fromDate: new FormControl(fromDate, !linkedToProm ? Validators.required : Validators.nullValidator),
      letterHead: new FormControl(letterHead),
      surveyName: new FormControl(surveyName, Validators.required),
      organizationCode: new FormControl(organizationCode),
      periodTypeId: new FormControl(
        periodTypeId === -1 ? null : periodTypeId,
        this.surveyTypeId != SurveyTypes.QualityControl.valueOf() ? null : Validators.required
      ),
      points: new FormControl(
        points,
        this.surveyTypeId != SurveyTypes.CustomerAppSurvey.valueOf() ? null : Validators.required
      ),
      assignToAllCustomers: new FormControl(allCustomers),
      assignToAllEmployees: new FormControl(allEmployees),
      assignToAllSecurityGroups: new FormControl(allSecurityGroups),
      mainMenu: new FormControl(isMainMenu)
    });
    //Question Tab
    this.formQuestions = new FormGroup({
      fieldGroupId: new FormControl(undefined),
      questionName: new FormControl("", Validators.required),
      questionBody: new FormControl("", Validators.required),
      fieldSubTypeID: new FormControl(undefined, Validators.required),
      yesScore: new FormControl(undefined, (this.isLinkedToPromotion && this.isYesNoQuestion) ? Validators.required : Validators.nullValidator),
      isBarcode: new FormControl(false),
      lovid: new FormControl(undefined),
      dependentQuestion: new FormControl(undefined),
      dependentAnswer: new FormControl(undefined),
      xlovid: new FormControl(undefined),
      ylovid: new FormControl(undefined),
      isMatrix: new FormControl(undefined),
      isMandatory: new FormControl(undefined),
      photoRequired: new FormControl(undefined),
      actionTypeId: new FormControl({ value: null, disabled: this.disableActions }),
      min: new FormControl(null),
      max: new FormControl(null),
      minDate: new FormControl(null),
      maxDate: new FormControl(null),
      yesNoId: new FormControl(null),
      lovOptionId: new FormControl(null),
      attachmentQuestionDetailValue: new FormControl(null),
      questionDetailValue: new FormControl(null),
      parameterName: new FormControl(null),
      isValidateDateData: new FormControl(null)
    });
    this.mustFillPeriodForm = new FormGroup({
      periodTypeId: new FormControl(),
      fromDate: new FormControl(),
      toDate: new FormControl()
    });
    this.mustFillPeriodForm.get('fromDate').disable()
    this.mustFillPeriodForm.get('toDate').disable()
    if (this.isEditMode || this.isCloneMode) {
      this.ValidToDateProperties.min = new Date()
      this.ValidToDateProperties.min.setDate((new Date(fromDate)).getDate());
      this.ValidToDateProperties.min.setMonth((new Date(fromDate)).getMonth());
      this.ValidToDateProperties.min.setFullYear((new Date(fromDate)).getFullYear());
      this.ValidToDateProperties.min.setHours(0);
      this.ValidToDateProperties.min.setMinutes(0);
      this.ValidToDateProperties.min.setSeconds(0);
    }

    //ApplyTo Tab
    this.formApplyTo = new FormGroup({
      code: new FormControl(Validators.required),
      typeId: new FormControl(Validators.required),
      value: new FormControl(),
      fromToDate: new FormControl(Validators.required),
      groupId: new FormControl(this.selectedGroupId),
      channelSubChannel: new FormControl(this.selectedChannelId),
      securityGroups: new FormControl(this.addedSecurityGroups, Validators.required),
      customerId: new FormControl(this.addedCustomersList),
      outletId: new FormControl(this.outletId),
      notes: new FormControl(),
      inspector: new FormControl(this.appliedInspectors),
      warehouse: new FormControl(this.appliedWarehouses),
      vehicle: new FormControl(this.appliedVehicles),
      damagedWarehouses: new FormControl(this.appliedDamagedWarehouses),
      itemsControl: new FormControl(this.addedItemsList),
      allItems: new FormControl(this.isEditMode || this.isCloneMode ? this.applyOnAllItems : false),
      employeeId: new FormControl(this.appliedEmployeesList),
      displayUnitControl: new FormControl(this.appliedDisplayUnit),
      displayUnitTypeControl: new FormControl(this.appliedDisplayUnitType),
    });
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_General',
        index: 0,
        isActive: false,
        hidden: false,
        disable: false
      },
      {
        label: 'Desc_Questions',
        index: 1,
        isActive: false,
        hidden: false,
        disable: false
      }
      ,
      {
        label: 'Desc_Applied_to',
        index: 2,
        isActive: false,
        hidden: this.isLinkedToPromotion,
        disable: false
      },
      {
        label: 'Desc_Must_Fill_Period',
        index: 3,
        isActive: false,
        hidden: false,
        disable: false
      }
    ];
  }
  ChangeDataView(index: number) {
    if (index > 0) {
      this.organizationsListControl.markAsTouched();
      if (this.organizationsListControl.invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
    }
    this.navLinks.forEach(a => a.isActive = false);
    this.navBarSelectedIndex = index;
    this.navLinks[index].isActive = true;
  }
  markasTouched() {
    this.formGeneral.get('toDate').markAsTouched();
    this.formGeneral.get('fromDate').markAsTouched();
    this.formGeneral.get('surveyName').markAsTouched();
    this.formGeneral.get('timeToFill').markAsTouched();
    this.formGeneral.get('surveySequence').markAsTouched();
    this.formGeneral.get('routeHistoryStatusId').markAsTouched();
    if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf())
      this.formGeneral.get('periodTypeId').markAsTouched();
    if (this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf())
      this.formGeneral.get('points').markAsTouched();
    this.organizationsListControl.markAsTouched();
    this.formGeneral.get('numberOfQus').markAsTouched();
    this.formGeneral.get('linkedToProm').markAsTouched();
    this.formQuestions.get('questionName').markAsTouched();
    this.formQuestions.get('questionBody').markAsTouched();
    this.formQuestions.get('fieldSubTypeID').markAsTouched();
    this.formApplyTo.get('code').markAsTouched();
    this.formApplyTo.get('typeId').markAsTouched();
    this.formApplyTo.get('fromToDate').markAsTouched();
    this.formApplyTo.get('securityGroups').markAsTouched();
  }
  //#region Quality Control
  onActionTypeChange($event) {
    //this.selectedTypeId = this.formQuestions.get("actionTypeId").value;
    if (!this.formQuestions.get("actionTypeId") || (this.formQuestions.get("actionTypeId").value && this.formQuestions.get("actionTypeId").value.length == 0)) {
      this.formQuestions.get('min').reset();
      this.formQuestions.get('max').reset();
      this.formQuestions.get('minDate').reset();
      this.formQuestions.get('maxDate').reset();
      this.formQuestions.get('yesNoId').reset();
      this.formQuestions.get('lovOptionId').reset();
    }
  }
  onYesNoChange($event) {
    this.selectedYesNoId = this.formQuestions.get("yesNoId").value;
  }
  deleteLOV(lovId: number) {

    let idx = this.questionValuesList.findIndex(lov => lov.id === lovId && lov.dynamicField && lov.dynamicField.trim() != '');

    if (idx > -1 && (!this.isQuestionEditMode || (this.isQuestionEditMode && lovId !== this.editedQuestionLOVId))) {
      this.listOfValueService.deleteLOV(lovId).subscribe(response => {
      }, (error: HttpErrorResponse) => {
        // note ==>  error
      });
    }

    if (idx > -1) {
      this.questionValuesList.splice(idx, 1);
      let temp = cloneDeep(this.questionValuesList);
      this.questionValuesList = [];
      this.questionValuesList = temp;
    }
  }


  onQuestionDependentChange($event) {
    if (this.allowDefineDynamicParameter && this.isSelectedParameterUsedInLOV) {
      this.formQuestions.get('dependentQuestion').markAsTouched();
      this.coreSession.ModalDialog.ShowMessage(
        this.translateService.instant(ConstantMessages.MsgChangeQuestionInfoConfirmation),
        DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)
      ).then((result: DialogResult) => {
        if (result === DialogResult.Yes) {
          this.deleteLOV(this.formQuestions.get('lovid').value);
          this.formQuestions.get('lovid').setValue(null);
          this.afterQuestionDependentChange($event);
        } else if (result === DialogResult.No) {
          this.formQuestions.get("dependentQuestion").setValue(this.selectedDependentQuestion);
        }
      });
    } else {
      this.afterQuestionDependentChange($event);
    }
  }
  afterQuestionDependentChange($event) {
    if(this.formQuestions.get("dependentQuestion").value){
      this.AnswerMandatoryError = true;
    } else {
      this.AnswerMandatoryError = false;
    }
    this.resetParameterData();
    this.formQuestions.get("dependentAnswer").setValue(null);
    this.selectedDependentQuestion = this.formQuestions.get("dependentQuestion") && this.formQuestions.get("dependentQuestion").value ? this.formQuestions.get("dependentQuestion").value : null;
    this.selectedDependentQuestionId = (this.formQuestions.get("dependentQuestion") && this.formQuestions.get("dependentQuestion").value ? this.formQuestions.get("dependentQuestion").value.dependentQuestion : null);
    if (this.selectedDependentQuestionId != null /*&& this.selectedDependentQuestionId > -1*/ && $event.fieldTypeId == 5) { // NOTE
      var questionIndex = this.dataSource.data.findIndex(x => x.fieldId == this.selectedDependentQuestionId)
      if (questionIndex > -1) {
        if (this.dataSource.data[questionIndex].questionOptions && this.dataSource.data[questionIndex].questionOptions.length > 0) {
          this.listOfLOVOptions = this.dataSource.data[questionIndex].questionOptions;

        }
      }
    }
    this.setAllowDefineDynamicParameter($event);
    this.fillDependentAnswers($event && $event != undefined ? $event.fieldTypeId : -1);
  }

  resetParameterData() {
    this.formQuestions.get("parameterName").setValue(null);
    this.formQuestions.get("parameterName").enable();
    this.isSelectedParameterUsedInLOV = false;
    this.selectedParameter = '';
  }
  onAnswerDependentChange($event) {
    this.selectedDependentAnswerId = this.formQuestions.get("dependentAnswer").value;
  }
  onMinDateSelected(date) {
    this.minDate = date;
  }
  onMaxDateSelected(date) {
    this.maxDate = date;
  }
  onApplyAllItems() {
    this.applyOnAllItems = this.formApplyTo.get('allItems').value;
    if (this.applyOnAllItems) {
      this.addedItemsList = [];
      this.formApplyTo.get("itemsControl").setValue([]);
    }
  }
  //#endregion
  onAppliedCustomersRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        let index = this.appliedToDataSource.data.findIndex(a => a === event.object);
        this.appliedToList.splice(index, 1);
        this.appliedToDataSource = {
          data: this.appliedToList,
          totalItems: this.appliedToList.length
        }
        this.resetAddCustomerValues();
        break;
    }
  }
  EnableDisableListValues(fieldTypeID: any) {
    this.hideMatrixSection = false;
    this.hideListOfValues = false;
    this.formGeneral.get('numberOfQus').disable();
    if (fieldTypeID == 5 || fieldTypeID == 6)
      this.formQuestions.get('lovid').enable();
    else
      this.formQuestions.get('lovid').disable();

    if (fieldTypeID == 8 || fieldTypeID == 6)
      this.formQuestions.get('isMatrix').disable();
    else
      this.formQuestions.get('isMatrix').enable();

    if (fieldTypeID === 11) {
      this.formQuestions.get('xlovid').reset();
      this.formQuestions.get('ylovid').reset();
      this.formQuestions.get('isMatrix').setValue(false);
      this.formQuestions.get('xlovid').disable();
      this.formQuestions.get('ylovid').disable();
      this.formQuestions.get('isMatrix').disable();
      this.hideMatrixSection = true;
      this.hideListOfValues = true;
    }
    if (fieldTypeID === 3 || fieldTypeID === 8) {
      this.hideListOfValues = true;
    }
  }
  onChangeOutlet($event) {
    this.selectedCustomerOutletName += " - " + $event.outletName;
  }
  onChangeGroup($event) {
    this.selectedGroupName = $event.groupCodeName;
    this.selectedGroupId = $event.groupId;
  }
  onChangeChannel($event) {
    this.selectedChannelSubChannelName = $event.channelSubChannelDescriptions;
    this.selectedChannelId = $event.channelSubChannelIds;
  }
  onSecurityGroups($event) {

    if ($event != undefined) {
      this.selectedSecurityGroupName = $event.securityGroupName;
      this.selectedSecurityGroupId = $event.securityGroupId;
    }
  }
  onCustomerChange($event) {
    this.selectedCustomerOutletName = $event.customerName;
  }
  onAdd() {
    if (this.selectedCustomerOutletName == "" && this.selectedGroupName == "" && this.selectedChannelSubChannelName == "") {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgSelectOneOfCustomerFilters))
      return;
    }
    var found = false;
    if (this.selectedCustomerOutletName != "") {
      found = this.appliedToList.some(el =>
        el.customerId === +this.formApplyTo.controls["customerId"].value &&
        el.outletId === +this.formApplyTo.controls["outletId"].value
      );
      if (!found) {
        this.appliedToList.push({
          customerId: +this.formApplyTo.controls["customerId"].value,
          outletId: +this.formApplyTo.controls["outletId"].value,
          groupId: -1,
          channelId: -1,
          subChannelId: -1,
          customerOutletName: this.selectedCustomerOutletName,
          groupName: "-----",
          channelName: "-----",
          securityGroupId: -1,
          securityGroupName: "-----"
        });
      }
    }
    if (this.selectedGroupName != "") {
      found = this.appliedToList.some(
        el => el.groupId === +this.selectedGroupId
      );
      if (!found) {
        this.appliedToList.push({
          customerId: -1,
          outletId: -1,
          groupId: +this.selectedGroupId,
          channelId: -1,
          subChannelId: -1,
          customerOutletName: "-----",
          groupName: this.selectedGroupName,
          channelName: "-----",
          securityGroupId: -1,
          securityGroupName: "-----"
        });
      }
    }

    if (this.selectedSecurityGroupName != "") {

      found = this.appliedToList.some(
        el => el.groupId === this.selectedSecurityGroupId
      );
      if (!found) {
        this.appliedToList.push({
          customerId: -1,
          outletId: -1,
          groupId: -1,
          channelId: -1,
          subChannelId: -1,
          customerOutletName: "-----",
          groupName: "-----",
          channelName: "-----",
          securityGroupId: +this.selectedSecurityGroupId,
          securityGroupName: this.selectedSecurityGroupName
        });
      }
    }
    if (this.selectedChannelSubChannelName != "") {
      var channelId = +this.selectedChannelId.split("-")[0];
      var subChannelId = +this.selectedChannelId.split("-")[1];
      found = this.appliedToList.some(el => el.subChannelId === subChannelId);
      if (!found) {
        this.appliedToList.push({
          customerId: -1,
          outletId: -1,
          groupId: -1,
          channelId: channelId,
          subChannelId: subChannelId,
          customerOutletName: "-----",
          groupName: "-----",
          channelName: this.selectedChannelSubChannelName,
          securityGroupId: -1,
          securityGroupName: "-----"
        });
      }
    }
    this.appliedToDataSource = {
      data: this.appliedToList,
      totalItems: this.appliedToList.length
    }
    this.resetAddCustomerValues();
    (this.appliedToList, "applied");
  }
  resetAddCustomerValues() {
    this.selectedCustomerOutletName = "";
    this.selectedGroupName = "";
    this.selectedChannelSubChannelName = "";
    this.selectedSecurityGroupName = "";
    this.resetValues.emit(true);
    this.formApplyTo.get("groupId").reset();
    this.formApplyTo.get("channelSubChannel").reset();
    this.formApplyTo.get("customerId").reset();
    this.formApplyTo.get("outletId").reset();
  }
  resetAddEmployeeValues() {
    this.resetValues.emit(true);
    this.formApplyTo.get("employeeId").reset();
  }
  resetAddSecurityGroupValues() {
    this.resetValues.emit(true);
    this.formApplyTo.get("securityGroups").reset();
  }
  onSelectDeSelectAllOrganization(selectAll, event: any) {
    var list: any[] = [];
    this.filterSecurityData();
    this.filterEmployeeData();
  // this.filterGroupsData();
    if (selectAll) {
      list = cloneDeep(this.organizationsList); //
    } else {
      this.clearAllAppliedToData();
    }
    this.getSelectedOrganizationIdsAsString(list);
    if (this.forceOrganizationFilterForCustomerGroups()) {
      this.populateGroupsList();
    }
  }
  clearMustFillPeriodDate() {
    this.mustFillPeriodForm.get('fromDate').reset();
    this.mustFillPeriodForm.get('toDate').reset();
  }
  onAddMustFillPeriodDate() {
    if (this.mustFillPeriodForm.get('fromDate').value != null && this.mustFillPeriodForm.get('toDate').value != null) {
      let temp = {
        'fromDateModel': this.fromDatePeriod,
        'toDateModel': this.toDatePeriod,
        'fromDate': new Date(this.fromDatePeriod.date),
        'toDate': new Date(this.toDatePeriod.date)
      };
      let foundObject = this.listOfPeriods.find(x => (x.fromDateModel.year == temp.fromDateModel.year && x.fromDateModel.month == temp.fromDateModel.month && x.fromDateModel.day == temp.fromDateModel.day) && (x.toDateModel.year == temp.toDateModel.year && x.toDateModel.month == temp.toDateModel.month && x.toDateModel.day == temp.toDateModel.day))
      if (foundObject != null || foundObject != undefined) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant('Desc_duplicate_period')
        );
        return;
      }
      this.listOfPeriods.push(temp);
      this.listOfPeriodsViewTable =
      {
        data: this.listOfPeriods,
        totalItems: this.listOfPeriods.length
      }
      // this.listOfPeriodsViewTable.data = this.listOfPeriods;
      // this.listOfPeriodsViewTable.totalItems = this.listOfPeriods.length
      this.mustFillPeriodForm.get('fromDate').reset();
      this.mustFillPeriodForm.get('toDate').reset();
      if (this.isEditMode || this.isCloneMode) {
        let date = new Date(this.surveyObject.validFrom)
        this.MustFillToDateProperties.min.setDate(date.getDate());
      } else {
        this.MustFillToDateProperties.min.setDate(this.validFromDate.date.getDate());
      }
      this.MustFillToDateProperties.min.setHours(0);
      this.MustFillToDateProperties.min.setMinutes(0);
      this.MustFillToDateProperties.min.setSeconds(0);
    }
    else {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant('Desc_Fill_Both_Dates')
      );
    }

  }
  onPeriodDeSelect() {
    this.isCustomPeriod = false
  }
  onPeriodSelect(selectedPeriod) {
    if (selectedPeriod.periodTypeId === SurveyPeriodTypes.Custom)
      this.isCustomPeriod = true
    else
      this.isCustomPeriod = false
    if ((this.isEditMode || this.isCloneMode) || (selectedPeriod.periodTypeId === SurveyPeriodTypes.Custom && this.validFromDate.length != 0) && this.validToDate.length != 0) {
      this.mustFillPeriodForm.get('fromDate').enable()
      this.mustFillPeriodForm.get('toDate').enable()
    }
    else {
      this.mustFillPeriodForm.get('fromDate').disable()
      this.mustFillPeriodForm.get('toDate').disable()
    }

  }

  forceOrganizationFilterForCustomerGroups() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true"
  }

  forceCustomerOrganizationSelection() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceCustomerOrganizationSelection).toLowerCase() === "true"
  }
  clearAllAppliedToData() {
    if ((this.formApplyTo.get('securityGroups').value && this.formApplyTo.get('securityGroups').value.length > 0) || (this.formApplyTo.get("employeeId").value && this.formApplyTo.get("employeeId").value.length > 0) || (this.formApplyTo.get('groupId').value && this.formApplyTo.get('groupId').value.length > 0) || (this.addedCustomersList != null && this.addedCustomersList.length > 0) || (this.addedDisplayUnitList != null && this.addedDisplayUnitList.length > 0))
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgChangeOrganizationRemoveApplyData));
    this.addedSecurityGroups = [];
    this.formApplyTo.get("securityGroups").setValue([]);
    this.appliedEmployeesList = [];
    this.formApplyTo.get("employeeId").setValue([]);
    this.addedGroups = [];
    this.formApplyTo.get('groupId').setValue([]);
    this.addedCustomersList = [];
    this.fillCustomersList();
    this.addedDisplayUnitList = [];
    this.fillDisplayUnitList();
  }

  clearAppliedToOrganizationRelatedData(fromUI) { // delete customer data for certain organization(s).
    if (fromUI)
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgChangeOrganizationRemoveApplyDataForOrg));

    var selectedOrganizationIds: any[] = this.organizationsListControl && this.organizationsListControl.value ? this.organizationsListControl.value.map(org => org.organizationId) : [];

    if (this.forceCustomerOrganizationSelection() && (this.customersDataSource.totalItems > 0)) {
      var allAddedCustomers = [];
      selectedOrganizationIds.forEach(organizationId => {
        var appliedToCustomers = this.addedCustomersList.filter(customer =>
          customer.organizationIdsList.includes(organizationId) // customer included in selected organizations.
          && allAddedCustomers.findIndex(addedCust => addedCust.customerId === customer.customerId && addedCust.outletId === customer.outletId) === -1 // customer not already added to [applied to] customers
        );
        allAddedCustomers = allAddedCustomers.concat(appliedToCustomers);
      });
      this.addedCustomersList = allAddedCustomers;
      this.fillCustomersList();
    }
    //display unit
    var availableDisplayUnit = this.addedDisplayUnitList.filter(x => selectedOrganizationIds.includes(x.organizationId));
    this.addedDisplayUnitList = availableDisplayUnit;
    this.fillDisplayUnitList();
    // for applied to security groups:
    var secGroupss = this.formApplyTo.get("securityGroups").value ? this.formApplyTo.get("securityGroups").value.filter(x => this.availableSecurityGroups.find(c => c.securityGroupId == x.securityGroupId)) : [];
    this.formApplyTo.get("securityGroups").setValue(secGroupss);
    // employees
    var emplpoyees = this.formApplyTo.get("employeeId").value ? this.formApplyTo.get("employeeId").value.filter(x => this.availableEmployees.find(c => c.employeeId == x.employeeId)) : [];
    this.formApplyTo.get("employeeId").setValue(emplpoyees);
    // groups
    if (this.forceOrganizationFilterForCustomerGroups()) {
      var groups = this.formApplyTo.get('groupId').value ? this.formApplyTo.get('groupId').value.filter(x => this.availableGroups.find(c => c.groupId == x.groupId)) : [];
      this.formApplyTo.get('groupId').setValue(groups);
    }
  }
  filterSecurityData() {
    var selectedOrganizationIds: any[] = this.organizationsListControl && this.organizationsListControl.value ? this.organizationsListControl.value.map(org => org.organizationId) : [];
    this.availableSecurityGroups = this.allSecurityGroupList.filter(x => selectedOrganizationIds.includes(x.organizationId));
  }
  filterEmployeeData() {
    var selectedOrganizationIds: any[] = this.organizationsListControl && this.organizationsListControl.value ? this.organizationsListControl.value.map(org => org.organizationId) : [];
    this.availableEmployees = this.allEmployeesList.filter(x => selectedOrganizationIds.includes(x.organizationId));
  }
  filterGroupsData() {
    if (this.forceOrganizationFilterForCustomerGroups()) {
      var selectedOrganizationIds: any[] = this.organizationsListControl && this.organizationsListControl.value ? this.organizationsListControl.value.map(org => org.organizationId) : [];
      this.availableGroups = this.allGroupsList.filter(x => selectedOrganizationIds.includes(x.organizationId));
    } else {
      this.availableGroups = this.allGroupsList;
    }
  }
  onChangeOrganization(fromUI, onselect?) {
    this.warehousesList = [];
    this.formApplyTo.get('warehouse').setValue(undefined);
    this.vehiclesList = [];
    this.formApplyTo.get('vehicle').setValue(undefined);
    this.damagedWarehousesList = [];
    this.formApplyTo.get('damagedWarehouses').setValue(undefined);
    this.inspectorsList = [];
    this.formApplyTo.get('inspector').setValue(undefined);
    var list = this.organizationsListControl.value;
    this.getSelectedOrganizationIdsAsString(list);
    this.filterSecurityData();
    this.filterEmployeeData();
    this.filterGroupsData();
    if (!onselect) {
      this.clearAppliedToOrganizationRelatedData(fromUI);
    }
  }
  onChangeListValue($event) {

    this.refillQuestionValuesList(-1);
    this.resetParameterData();
    if (this.isSelectedParameterUsedInLOV) {
      this.resetDependsOnData();
      this.deleteLOV(this.selectedLOVId);
      // this.refillQuestionValuesList(-1);
    }
    this.selectedLOVId = $event && $event != undefined ? $event.id : -1;
    this.getLOVOptions($event != undefined && $event ? $event.id : -1);
  }

  resetDateFieldRelatedData() {
    this.formQuestions.get('isValidateDateData').reset();
    this.formQuestions.get('questionDetailValue').reset();
    this.formQuestions.get('questionDetailValue').setValidators(null);
    this.formQuestions.get('questionDetailValue').updateValueAndValidity();
  }

  afterQuestionTypeChange(questionType: any) {
    this.hideMatrixSection = false;
    this.hideListOfValues = false;
    this.resetDateFieldRelatedData();
    // this.refillQuestionValuesList(-1);
    this.resetParameterData();
    this.formQuestions.get('attachmentQuestionDetailValue').reset();
    this.resetDependsOnData();
    this.isYesNoQuestion = false;
    this.isBarcode = false;
    this.ListValueMandatoryError = false;
    this.AnswerMandatoryError = false;
    if (questionType != undefined && questionType != -1) {
      this.selectedFieldType = questionType;
      this.appliedSubTypeList = this.questionSubTypeList.filter(a => a.fieldTypeId === questionType.fieldTypeId);
      this.EnableDisableListValues(questionType.fieldTypeId);
      this.selectedType = questionType;
      if (questionType.fieldTypeId != 1 && questionType.fieldTypeId != 3
        && questionType.fieldTypeId != 4 && questionType.fieldTypeId != 5) {
        this.formQuestions.get('actionTypeId').setValue([]);
        this.disableActions = true;
      }
      else {
        this.formQuestions.get('actionTypeId').enable();
        this.disableActions = false;
      }
      if (questionType.fieldTypeId == 1) {
        if (questionType.fieldSubTypeId == 1)
          this.numberOfDigits = 0;
        else if (questionType.fieldSubTypeId == 2)
          this.numberOfDigits = + this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfDigits);
      }
      if (questionType.fieldTypeId == 4) {
        this.isYesNoQuestion = true;
      }
      if (questionType.fieldTypeId == 2) {
        this.isBarcode = true;
      }
      if (questionType.fieldTypeId == 5 || questionType.fieldTypeId == 6) {
        this.ListValueMandatoryError = true;
      }
    }
    else {
      this.selectedFieldType = null;
      this.selectedType = [];
      this.appliedSubTypeList = [];
    }
    if (questionType !== null && questionType !== undefined)
    this.fillDependentQuestions(this.editQuestionIndex >= 0 ? this.dataSource.data[this.editQuestionIndex].sequence : -1, (this.editQuestionIndex >= 0 ? true : false));
  }
  onQuestionTypeChange(questionType: any) {
    this.answerDependentList = [];
    this.questionDependentList = [];
    this.AnswerMandatoryError = false;
    if (this.allowDefineDynamicParameter && this.isSelectedParameterUsedInLOV) {
      this.formQuestions.get("fieldSubTypeID").markAsTouched();
      this.coreSession.ModalDialog.ShowMessage(
        this.translateService.instant(ConstantMessages.MsgChangeQuestionInfoConfirmation),
        DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)
      ).then((result: DialogResult) => {
        if (result === DialogResult.Yes) {
          this.deleteLOV(this.formQuestions.get('lovid').value);
          this.formQuestions.get('lovid').setValue(null);

          this.afterQuestionTypeChange(questionType);
        } else if (result === DialogResult.No) {
          this.formQuestions.get("fieldSubTypeID").setValue(this.selectedFieldType);
        }
      });
    } else {
      this.afterQuestionTypeChange(questionType);
    }
  }
  resetDependsOnData() {
    this.formQuestions.get('dependentQuestion').setValue(null);
    this.formQuestions.get('dependentAnswer').setValue(null);
    this.formQuestions.get('parameterName').setValue(null);
    this.allowDefineDynamicParameter = false;
  }
  onAddQuestion(event: any) {
    if (this.formQuestions.invalid) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
      return;
    }
    if ((this.selectedType.fieldTypeId == 5 || this.selectedType.fieldTypeId == 6)
      && (!this.formQuestions.get("lovid") || !this.formQuestions.get("lovid").value)) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
      return;
    }
    if (this.formQuestions.get('dependentQuestion').value && this.formQuestions.get('dependentAnswer').value === null) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
      return;
    }
    if (this.formQuestions.get('isValidateDateData').value &&
      this.formQuestions.get('questionDetailValue').value === null) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
      return;
    }

    if (this.allowDefineDynamicParameter) {
      if (!this.formQuestions.get('parameterName').value || this.formQuestions.get('parameterName').value.trim() == '') {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgDefineParameter)
        );
        return;
      }
      var lovIdx = this.questionValuesList.findIndex(val => val.id === this.formQuestions.get('lovid').value);
      if (!this.questionValuesList[lovIdx].dynamicField || this.questionValuesList[lovIdx].dynamicField !== this.formQuestions.get('parameterName').value) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgLOVNotRelatedToDynamicField)
        );
        return;
      }
    }

    if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf() && this.formQuestions.get("actionTypeId") && this.formQuestions.get("actionTypeId").value && this.formQuestions.get("actionTypeId").value.length > 0) {
      switch (this.selectedType.fieldTypeId) {
        case 1:
          if ((!this.formQuestions.get("min") || !this.formQuestions.get("min").value) && (!this.formQuestions.get("max") || !this.formQuestions.get("max").value)) {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              this.translateService.instant(ConstantMessages.MsgFillMaxOMinValue)
            );
            return;
          }
          else if (this.formQuestions.get("min").value && this.formQuestions.get("max").value
            && this.formQuestions.get("min").value > this.formQuestions.get("max").value) {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              this.translateService.instant(ConstantMessages.MsgMinExceedsMax)
            );
            return;
          }
          break;

        case 3:
          if (this.minDate == null && this.maxDate == null) {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              this.translateService.instant(ConstantMessages.MsgFillMaxOMinDateValue)
            );
            return;
          }
          else if ((this.minDate && this.maxDate) && this.minDate.date > this.maxDate.date) {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              this.translateService.instant(ConstantMessages.MsgMinExceedsMax)
            );
            return;
          }
          break;

        case 4:
          if (!this.formQuestions.get("yesNoId") || (this.formQuestions.get("yesNoId") && !this.formQuestions.get("yesNoId").value)) {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              this.translateService.instant(ConstantMessages.MsgSelectYesOrNoValue)
            );
            return;
          }
          break;

        case 5:
          if (!this.formQuestions.get("lovOptionId") || (this.formQuestions.get("lovOptionId") && !this.formQuestions.get("lovOptionId").value)) {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              this.translateService.instant(ConstantMessages.MsgSelectLOVOptionValue)
            );
            return;
          }
          break;
      }
    }
    (this.formQuestions, "QuestionsForm");

    let selectedFieldId = -1
    let dCFID = -1
    let sequence = -1
    let original = this.dataSource.data.slice();
    if (!this.isEditMode || (this.isEditMode && this.editQuestionIndex < 0)) {
      selectedFieldId = this.maxFieldIdForAdd - 1;
    }
    if (this.editQuestionIndex >= 0) {
      selectedFieldId = this.dataSource.data[this.editQuestionIndex].fieldId;
      if (this.isEditMode && this.surveyObject.isUsed && selectedFieldId >= 0) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant('Desc_Cannot_Edit_Used_Survey')
        );
        return;
      }
      dCFID = this.dataSource.data[this.editQuestionIndex].dcfid;
      sequence = this.dataSource.data[this.editQuestionIndex].sequence;
      this.dataSource.data.splice(this.editQuestionIndex, 1);
      this.dataSource.totalItems = this.dataSource.totalItems - 1;
      // this.editQuestionId = -1;
    }
    (this.selectedType, "this.selectedType");
    let question: any = new Object();
    question.fieldId = selectedFieldId;
    question.dCFID = dCFID;
    question.sequence = +(this.editQuestionIndex >= 0 ? sequence : this.dataSource.totalItems + 1);
    question.fieldGroupId = +((this.formQuestions.value.fieldGroupId === undefined || this.formQuestions.value.fieldGroupId === null) ? -1 : this.formQuestions.value.fieldGroupId);
    question.questionName = this.formQuestions.value.questionName;
    question.questionBody = this.formQuestions.value.questionBody;
    question.fieldTypeID = +this.selectedType.fieldTypeId;
    question.questionTypeName = this.selectedType.fieldSubTypeName;
    question.fieldSubTypeID = +this.selectedType.fieldSubTypeId;
    question.yesScore = +((this.isLinkedToPromotion && this.isYesNoQuestion) ? this.formQuestions.value.yesScore : -1);
    question.isBarcode =  this.isBarcode ? (this.formQuestions.value.isBarcode === null ? false : this.formQuestions.value.isBarcode) : false;
    question.lovid = +(this.formQuestions.value.lovid === undefined || this.formQuestions.value.lovid === null ? -1 : this.formQuestions.value.lovid);
    question.xlovid = + (this.formQuestions.value.xlovid === undefined || this.formQuestions.value.xlovid === null ? -1 : this.formQuestions.value.xlovid);
    question.ylovid = +(this.formQuestions.value.ylovid === undefined || this.formQuestions.value.ylovid === null ? -1 : this.formQuestions.value.ylovid);
    this.selectedDependentQuestionId = this.formQuestions.get("dependentQuestion") && this.formQuestions.get("dependentQuestion").value ? this.formQuestions.get("dependentQuestion").value.dependentQuestion : null;
    question.dependentQuestion = + (this.selectedDependentQuestionId ? this.selectedDependentQuestionId : -1); // +(this.formQuestions.value.dependentQuestion === undefined || this.formQuestions.value.dependentQuestion === null ? -1 : this.formQuestions.value.dependentQuestion);
    question.dependentAnswer = +(this.formQuestions.value.dependentAnswer === undefined || this.formQuestions.value.dependentAnswer === null ? -1 : this.formQuestions.value.dependentAnswer.answerDependentId);
    question.isMandatory = this.formQuestions.value.isMandatory === undefined || this.formQuestions.value.isMandatory === null ? false : this.formQuestions.value.isMandatory;
    question.photoRequired = this.formQuestions.value.photoRequired === undefined || this.formQuestions.value.photoRequired === null ? false : this.formQuestions.value.photoRequired;
    question.isMatrix = this.formQuestions.value.isMatrix === undefined || this.formQuestions.value.isMatrix === null ? false : this.formQuestions.value.isMatrix;
    question.questionNameDescriptionLanguages = [];
    question.questionBodyDescriptionLanguages = [];
    question.numberOfAttachments = this.formQuestions.value.attachmentQuestionDetailValue !== undefined && this.formQuestions.value.attachmentQuestionDetailValue && this.formQuestions.value.attachmentQuestionDetailValue > 0 && (question.fieldSubTypeID === 11 || question.fieldSubTypeID === 8) ? this.formQuestions.value.attachmentQuestionDetailValue : 0;
    question.afterNumberOfDays = this.formQuestions.value.questionDetailValue !== undefined && this.formQuestions.value.questionDetailValue != null && this.formQuestions.value.questionDetailValue >= 0 && question.fieldSubTypeID === 1 && question.fieldTypeID === 3 ? this.formQuestions.value.questionDetailValue : -1;
    question.dynamicField = this.isSelectedParameterUsedInLOV && this.formQuestions.get('parameterName') && this.formQuestions.get('parameterName').value ? this.formQuestions.get('parameterName').value : null;

    let descriptions = cloneDeep(this.questionNameOtherLanguages);
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.formQuestions.value.questionName
      });
    }
    question.questionNameDescriptionLanguages = cloneDeep(descriptions);

    let bodyDescriptions = cloneDeep(this.questionBodyOtherLanguages);
    if (bodyDescriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      bodyDescriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.formQuestions.value.questionBody
      });
    }
    question.questionBodyDescriptionLanguages = cloneDeep(bodyDescriptions);

    if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf()) {
      question.actionTypeId = (!this.formQuestions.get("actionTypeId") || !this.formQuestions.get("actionTypeId").value) ? [] : this.formQuestions.get("actionTypeId").value;
      question.minValue = +((!this.formQuestions.get("min") || !this.formQuestions.get("min").value) ? 0 : this.formQuestions.get("min").value);
      question.maxValue = +((!this.formQuestions.get("max") || !this.formQuestions.get("max").value) ? 0 : this.formQuestions.get("max").value);
      question.minDateModel = (question.fieldTypeID == 3 && this.formQuestions.get("actionTypeId") && this.formQuestions.get("actionTypeId").value && this.formQuestions.get("actionTypeId").value.length > 0 ? this.minDate : null);
      question.maxDateModel = (question.fieldTypeID == 3 && this.formQuestions.get("actionTypeId") && this.formQuestions.get("actionTypeId").value && this.formQuestions.get("actionTypeId").value.length > 0 ? this.maxDate : null);
      question.yesNo = (!this.formQuestions.get("yesNoId") || !this.formQuestions.get("yesNoId").value) ? false : (this.formQuestions.get("yesNoId").value.valueId == 1 ? true : false);
      question.lovOptionID = + (!this.formQuestions.get("lovOptionId") ? null : (!this.formQuestions.get("lovOptionId").value ? -1 : this.formQuestions.get("lovOptionId").value.lovOptionID));
    }
    if (question.lovid != -1) {
      if (this.listValues)
        question.questionOptions = this.listValues.filter(x => x.lovid == question.lovid);
    }

    (this.formQuestions.value.questionName, "questionName");
    if (this.editQuestionIndex != -1) {
      let array: any[] = [];
      for (let i = 0; i < original.length; i++) {
        if (i == this.editQuestionIndex)
          array.push(question);
        else
          array.push(original[i]);
      }
      this.dataSource.data = array;
    } else
      this.dataSource.data.push(question);
    this.maxFieldIdForAdd = selectedFieldId;
    (this.addedQuestions, "addedQuestions");
    if (this.dataSource != null || this.dataSource != undefined) {
      this.addedQuestions = this.dataSource.data.slice();
      this.dataSource = {
        data: this.dataSource.data.slice(),
        totalItems: this.dataSource.totalItems + 1
      }
      this.formGeneral.get("numberOfQus").setValue(this.dataSource.totalItems);
    }
    this.resetQuestionsValue();
    this.fillDependentQuestions(question.sequence, true);
    this.isQuestionEditMode = false;
    this.AnswerMandatoryError = false;
    this.editedQuestion = null;
    this.editedQuestionLOV = null;
    this.editedQuestionLOVId = -1;
    this.answerDependentList = [];
    this.questionDependentList = [];
  }
  resetQuestionsValue(fromResetBtn: boolean = false) {
    if (fromResetBtn) this.refillQuestionValuesList(-1);
    if (this.isQuestionEditMode && fromResetBtn && this.editedQuestion && this.editedQuestion.dynamicField && this.editedQuestion.dynamicField.trim() != '' && this.editedQuestionLOV) {
      let temp = cloneDeep(this.questionValuesList);
      this.questionValuesList = [];
      this.questionValuesList = temp;
      this.questionValuesList.push(this.editedQuestionLOV);
    }
    this.isQuestionEditMode = false;
    this.AnswerMandatoryError = false;
    this.formQuestions.get('questionName').reset();
    this.formQuestions.get('questionBody').reset();
    this.formQuestions.get('fieldSubTypeID').reset();
    this.formQuestions.get('yesScore').reset();
    this.formQuestions.get('isBarcode').reset();
    this.formQuestions.get('lovid').reset();
    this.formQuestions.get('xlovid').reset();
    this.formQuestions.get('ylovid').reset();
    this.formQuestions.get('fieldGroupId').reset();
    this.formQuestions.get('isMatrix').reset();
    this.formQuestions.get('dependentQuestion').reset();
    this.formQuestions.get('dependentAnswer').reset();
    if (!this.isLinkedToPromotion)
      this.formQuestions.get('isMandatory').reset();
    this.formQuestions.get('photoRequired').reset();
    this.formQuestions.get('actionTypeId').reset();
    this.formQuestions.get('min').reset();
    this.formQuestions.get('max').reset();
    this.formQuestions.get('minDate').reset();
    this.formQuestions.get('maxDate').reset();
    this.formQuestions.get('yesNoId').reset();
    this.formQuestions.get('lovOptionId').reset();
    this.formQuestions.get('parameterName').reset();
    this.formQuestions.get('questionDetailValue').reset();
    this.formQuestions.get('attachmentQuestionDetailValue').reset();
    this.formQuestions.get('isValidateDateData').setValue(false);
    this.formQuestions.get('questionDetailValue').setValidators(null);
    this.formQuestions.get('questionDetailValue').updateValueAndValidity();
    this.allowDefineDynamicParameter = false;
    this.editQuestionIndex = -1;
    this.buttonText = "Desc_Add";
    this.editQuestionNameLanguages = [];
    this.questionNameOtherLanguages = [];

    this.selectedDependentQuestionId = null;
    this.selectedParameter = '';
    this.onMatrixChange();
    this.EnableDisableListValues(this.formQuestions.get('lovid').value);
    this.fillDependentQuestions(-1, false);
    this.editedQuestion = null;
    this.editedQuestionLOV = null;
    this.editedQuestionLOVId = -1;
    this.selectedLOVId = -1;
    this.isSelectedParameterUsedInLOV = false;
  }
  onMatrixChange() {
    if (this.formQuestions.value.isMatrix) {
      this.formQuestions.get("xlovid").enable();
      this.formQuestions.get("ylovid").enable();
    }
    else {
      this.formQuestions.get("xlovid").disable();
      this.formQuestions.get("ylovid").disable();
    }
  }
  setMustFillMinDates(date: Date) {
    this.MustFillToDateProperties.min.setDate(date.getDate());
    this.MustFillToDateProperties.min.setMonth(date.getMonth());
    this.MustFillToDateProperties.min.setFullYear(date.getFullYear());
    this.MustFillToDateProperties.min.setHours(0);
    this.MustFillToDateProperties.min.setMinutes(0);
    this.MustFillToDateProperties.min.setSeconds(0);

    this.MustFillFromDateProperties.min.setDate(date.getDate());
    this.MustFillFromDateProperties.min.setMonth(date.getMonth());
    this.MustFillFromDateProperties.min.setFullYear(date.getFullYear());
    this.MustFillFromDateProperties.min.setHours(0);
    this.MustFillFromDateProperties.min.setMinutes(0);
    this.MustFillFromDateProperties.min.setSeconds(0);
  }
  setMustFilMaxDates(date: Date) {
    this.MustFillToDateProperties.max.setDate(date.getDate());
    this.MustFillToDateProperties.max.setMonth(date.getMonth());
    this.MustFillToDateProperties.max.setFullYear(date.getFullYear());
    this.MustFillToDateProperties.max.setHours(0);
    this.MustFillToDateProperties.max.setMinutes(0);
    this.MustFillToDateProperties.max.setSeconds(0);

    this.MustFillFromDateProperties.max.setDate(date.getDate());
    this.MustFillFromDateProperties.max.setMonth(date.getMonth());
    this.MustFillFromDateProperties.max.setFullYear(date.getFullYear());
    this.MustFillFromDateProperties.max.setHours(0);
    this.MustFillFromDateProperties.max.setMinutes(0);
    this.MustFillFromDateProperties.max.setSeconds(0);
  }
  CheckValidDate() {
    if (this.validFromDate.length == 0 || this.validToDate.length == 0) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant('Desc_Cannot_Add_Date_Before_Filling_Survey_Date')
      );
    }

  }
  onMustFillFromDateSelected(date) {
    this.mustFillPeriodForm.get('toDate').reset();
    this.MustFillToDateProperties.min.setDate(date.date.getDate() + 1);
    this.MustFillToDateProperties.min.setHours(0);
    this.MustFillToDateProperties.min.setMinutes(0);
    this.MustFillToDateProperties.min.setSeconds(0);
    this.fromDatePeriod = date;
  }
  onMustFillToDateSelected(date) {
    this.toDatePeriod = date;
  }
  onFromDateSelected(date) {
    if ((this.formGeneral.value.forceFill !== undefined || this.formGeneral.value.forceFill !== null) && this.formGeneral.value.forceFill.modeId > 0 && (this.mustFillPeriodForm.get('periodTypeId').value !== null && this.mustFillPeriodForm.get('periodTypeId').value[0].periodTypeId === 5 && this.listOfPeriodsViewTable.data.length !== 0)) {//hazem check that > 0 is right
      this.coreSession.ModalDialog.ShowMessage(
        this.translateService.instant(ConstantMessages.MsgResetSurveyPeriodList),
        DialogMode.YesNo,
        this.translateService.instant(ConstantMessages.SurveyPeriodListReset)
      ).then((result: DialogResult) => {
        if (result === DialogResult.Yes) {
          this.listOfPeriodsViewTable = {
            data: [],
            totalItems: 0
          }
          this.listOfPeriods = []
          this.validFromDate = date;
          if (this.validToDate !== null && new Date(this.validToDate.date) < new Date(date.date)) {
            this.formGeneral.get('toDate').reset()
            this.ValidToDateProperties.min = new Date()
            this.ValidToDateProperties.min.setDate(date.date.getDate());
            this.ValidToDateProperties.min.setMonth(date.date.getMonth());
            this.ValidToDateProperties.min.setFullYear(date.date.getFullYear());
            this.ValidToDateProperties.min.setHours(0);
            this.ValidToDateProperties.min.setMinutes(0);
            this.ValidToDateProperties.min.setSeconds(0);
          }
        } else if (result === DialogResult.No) {
          this.formGeneral.get('fromDate').setValue(this.validFromDate.date)
          return;
        }
      });
    } else {

      if (this.validToDate !== null && new Date(this.validToDate.date) < new Date(date.date)) {
        this.formGeneral.get('toDate').reset()
        this.ValidToDateProperties.min = new Date()
        this.ValidToDateProperties.min.setDate(date.date.getDate());
        this.ValidToDateProperties.min.setMonth(date.date.getMonth());
        this.ValidToDateProperties.min.setFullYear(date.date.getFullYear());
        this.ValidToDateProperties.min.setHours(0);
        this.ValidToDateProperties.min.setMinutes(0);
        this.ValidToDateProperties.min.setSeconds(0);
      } else if ((this.validToDate !== null || this.validToDate !== undefined) && (this.validFromDate !== null || this.validFromDate !== undefined)) {
        this.ValidToDateProperties.min = new Date()
        this.ValidToDateProperties.min.setDate(date.date.getDate());
        this.ValidToDateProperties.min.setMonth(date.date.getMonth());
        this.ValidToDateProperties.min.setFullYear(date.date.getFullYear());
        this.ValidToDateProperties.min.setHours(0);
        this.ValidToDateProperties.min.setMinutes(0);
        this.ValidToDateProperties.min.setSeconds(0);
      }
      this.validFromDate = date;
    }
    if (this.validFromDate.length == 0 || this.validToDate.length == 0) {
      this.mustFillPeriodForm.get('fromDate').disable()
      this.mustFillPeriodForm.get('toDate').disable()
    }
    else {
      this.mustFillPeriodForm.get('fromDate').enable()
      this.mustFillPeriodForm.get('toDate').enable()
    }
    this.setMustFillMinDates(date.date)
    // this.MustFillToDateProperties.min.setDate(date.date.getDate()) ;
    // this.MustFillToDateProperties.min.setMonth(date.date.getMonth());
    // this.MustFillToDateProperties.min.setFullYear(date.date.getFullYear());
    // this.MustFillToDateProperties.min.setHours(0) ;
    // this.MustFillToDateProperties.min.setMinutes(0) ;
    // this.MustFillToDateProperties.min.setSeconds(0) ;

    // this.MustFillFromDateProperties.min.setDate(date.date.getDate()) ;
    // this.MustFillFromDateProperties.min.setMonth(date.date.getMonth());
    // this.MustFillFromDateProperties.min.setFullYear(date.date.getFullYear());
    // this.MustFillFromDateProperties.min.setHours(0) ;
    // this.MustFillFromDateProperties.min.setMinutes(0) ;
    // this.MustFillFromDateProperties.min.setSeconds(0) ;



  }
  onToDateSelected(date) {
    this.validToDate = date;
    if (this.validFromDate.length == 0 || this.validToDate.length == 0) {
      this.mustFillPeriodForm.get('fromDate').disable()
      this.mustFillPeriodForm.get('toDate').disable()
    }
    else {
      this.mustFillPeriodForm.get('fromDate').enable()
      this.mustFillPeriodForm.get('toDate').enable()

      this.MustFillToDateProperties.max.setMonth(date.date.getMonth());
      this.MustFillToDateProperties.max.setFullYear(date.date.getFullYear());
      this.MustFillToDateProperties.max.setHours(0);
      this.MustFillToDateProperties.max.setMinutes(0);
      this.MustFillToDateProperties.max.setSeconds(0);
      this.MustFillToDateProperties.max.setDate(date.date.getDate());

      this.MustFillFromDateProperties.max.setMonth(date.date.getMonth());
      this.MustFillFromDateProperties.max.setFullYear(date.date.getFullYear());
      this.MustFillFromDateProperties.max.setHours(0);
      this.MustFillFromDateProperties.max.setMinutes(0);
      this.MustFillFromDateProperties.max.setSeconds(0);
      this.MustFillFromDateProperties.max.setDate(date.date.getDate());
    }
  }
  onSurveyNameOtherLanguagesTextSubmitted(event) {
    this.surveyNameOtherLanguages = event;
  }
  onLetterHeadOtherLanguagesTextSubmitted(event) {
    this.letterHeadOtherLanguages = event;
  }
  onQuestionNameOtherLanguagesTextSubmitted(event) {
    this.questionNameOtherLanguages = event;
  }
  onQuestionBodyOtherLanguagesTextSubmitted(event) {
    this.questionBodyOtherLanguages = event;
  }
  onAddGroup() {
    this.addNewGroup = true;
  }
  openLOVSlider() {
    this.selectedParameter = '';
    let regex = new RegExp("^@[a-zA-Z]+$");
    if (this.allowDefineDynamicParameter) {
      if (regex.test(this.formQuestions.get('parameterName').value) === false) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgInvalidParameter)
        );
        return;
      }
      this.selectedParameter = this.formQuestions.get('parameterName').value;
    }
    this.addNewLOV = true;
  }
  closeLOVSlider() {
    this.addNewLOV = false;
  }
  onLOVSaveClick() {
    this.saveLOVSubject.next();
  }
  onAfterLOVSaved(lovId) {
    if (this.allowDefineDynamicParameter) {
      this.formQuestions.get('parameterName').disable();
      this.isSelectedParameterUsedInLOV = true;
    }
    this.closeLOVSlider();
    this.afterNewLOVSaved = true;
    this.FillUI(lovId);
  }
  onSaveAddGroup() {
    this.saveSubject.next();
  }
  onCloseAddGroup() {
    this.newPackGroup.Close();
  }
  onAddingNewGroup(event: any) {
    if (event == "") {
      return;
    }
    this.getFieldGroups();
    this.onCloseAddGroup();
  }
  onPeriodRowOperation(event: any) {

    switch (event.operation) {
      case RowOperation.delete:
        this.listOfPeriods.splice(event.index, 1);
        this.listOfPeriodsViewTable.data = this.listOfPeriods;
        this.listOfPeriodsViewTable.totalItems = this.listOfPeriods.length
        break;

    }
  }
  showPackGroupModal() {
    this.newPackGroup.Show(true).then(
      (res) => {
      }
    );
  }
  onDialogResult(event) {
    if (event && event.saveCLicked) {
      this.onSaveAddGroup();
    }
  }

  onAllCustomersChange() {
    this.allCustomers = this.formGeneral.get('assignToAllCustomers').value;
    if (this.allCustomers) {
      this.resetAddCustomerValues();
      this.appliedToList = [];
      this.appliedToDataSource = {
        data: this.appliedToList,
        totalItems: this.appliedToList.length
      }
      //this.navLinks[2].disable = true;
      this.formApplyTo.get("groupId").setValue(undefined);
      this.formApplyTo.get("groupId").disable();

      this.formApplyTo.get("channelSubChannel").setValue(undefined);
      this.formApplyTo.get("channelSubChannel").disable();

      this.formApplyTo.get("customerId").setValue(undefined);
      this.formApplyTo.get("customerId").disable();

      this.formApplyTo.get("outletId").setValue(undefined);
      this.formApplyTo.get("outletId").disable();
    }
    else {
      this.formApplyTo.get("groupId").enable();
      this.formApplyTo.get("channelSubChannel").enable();
      this.formApplyTo.get("customerId").enable();
      this.formApplyTo.get("outletId").enable();
    }
    this.disableApplyToTab();
  }
  onAllEmployeesChange() {
    this.allEmployees = this.formGeneral.get('assignToAllEmployees').value;
    if (this.allEmployees) {
      this.resetAddEmployeeValues();
      this.appliedEmployeesList = [];
      this.formApplyTo.get("employeeId").setValue(undefined);
      this.formApplyTo.get("employeeId").disable();
      // this.navLinks[2].disable = true;
    }
    else {
      this.formApplyTo.get("employeeId").enable();
      //this.navLinks[2].disable = false;
    }
    this.disableApplyToTab();
  }
  onAllSecurityGroupsChange() {
    this.allSecurityGroups = this.formGeneral.get('assignToAllSecurityGroups').value;
    if (this.allSecurityGroups) {
      this.resetAddSecurityGroupValues();
      this.addedSecurityGroups = [];
      this.formApplyTo.get("securityGroups").setValue(null);
      this.formApplyTo.get("securityGroups").disable();
      //this.navLinks[2].disable = true;
    }
    else {
      this.formApplyTo.get("securityGroups").enable();
      //this.navLinks[2].disable = false;
    }
    this.disableApplyToTab();
  }
  onShowAsMainMenuChange() {
    this.showAsMainMenu = this.formGeneral.get('mainMenu').value;
    if (!this.showAsMainMenu)
      this.selectedIconName = '';
  }
  onSelectAllEmployees() {
    this.allEmployees = true;
    this.resetAddEmployeeValues();
    this.appliedEmployeesList = [];
  }
  onSelectAllSecurityGroups() {
    this.allSecurityGroups = true;
    this.resetAddSecurityGroupValues();
    this.addedSecurityGroups = [];
  }
  onDeSelectAllEmployees() {
    this.allEmployees = false;
  }
  onDeSelectAllSecurityGroups() {
    this.allSecurityGroups = false;
  }
  onApplyAllSecurity() {
    if (this.formApplyTo.value.applyForAllSecurityGroups) {
      this.formApplyTo.get("securityGroups").setValue(undefined);
      this.formApplyTo.get("securityGroups").disable();
      if (this.appliedToList != undefined && this.appliedToList.length > 0) {
        let array: any[] = [];
        for (let i = 0; i < this.appliedToList.length; i++) {
          if (this.appliedToList[i].securityGroupId == -1)
            array.push(this.appliedToList[i]);
        }
        this.appliedToList = array;
      }
    }
    else {
      this.formApplyTo.get("securityGroups").enable();
    }
  }
  refillQuestionValuesList(lovId: number) {
    // this.questionValuesList = cloneDeep(this.originalQuestionValuesList.filter(val => !val.dynamicField || (val.fieldId === fieldId && fieldId != -1)  ));
    this.questionValuesList = cloneDeep(this.originalQuestionValuesList.filter(val => !val.dynamicField || val.id === lovId));

  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        if (this.checkIfQuestionHasDependencies(event.object)) {
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgCannotPerformOperationDueToDependency) // "Cannot delete question due to dependencies"
          );
          return;
        }
        this.allowDefineDynamicParameter = false;
        this.resetParameterData();
        this.isQuestionEditMode = true;
        this.isYesNoQuestion = false;
        this.isBarcode = false;
        this.refillQuestionValuesList(event.object.lovid);
        this.fillDependentQuestions(event.object.sequence, true);
        this.fillActionsTypesList();
        this.formQuestions.get('fieldGroupId').setValue(event.object.fieldGroupId == -1 ? undefined : event.object.fieldGroupId);
        this.formQuestions.get('questionName').setValue(event.object.questionName);
        this.formQuestions.get('questionBody').setValue(event.object.questionBody);
        this.appliedSubTypeList = this.questionSubTypeList.filter(a => a.fieldTypeId === event.object.fieldTypeID);
        this.formQuestions.get('fieldSubTypeID').setValue(this.questionSubTypeList.filter(a => a.fieldTypeId === event.object.fieldTypeID && a.fieldSubTypeId == event.object.fieldSubTypeID)[0]);
        if (this.formQuestions.get('fieldSubTypeID').value.fieldTypeId === 11 || this.formQuestions.get('fieldSubTypeID').value.fieldTypeId === 8) {
          this.formQuestions.get('attachmentQuestionDetailValue').setValue(event.object.numberOfAttachments > -1 ? event.object.numberOfAttachments : null);
        }
        if (this.formQuestions.get('fieldSubTypeID').value.fieldTypeId === 3) {
          this.formQuestions.get('isValidateDateData').setValue(event.object.afterNumberOfDays > -1);
          this.formQuestions.get('questionDetailValue').setValue(event.object.afterNumberOfDays > -1 ? event.object.afterNumberOfDays : null);
        } else {
          this.formQuestions.get('isValidateDateData').setValue(false);
        }
        if (event.object.fieldTypeID == 1) {
          if (event.object.fieldSubTypeID == 1)
            this.numberOfDigits = 0;
          else if (event.object.fieldSubTypeID == 2)
            this.numberOfDigits = + this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfDigits);
        }
        this.formQuestions.get('lovid').setValue(event.object.lovid == -1 ? undefined : event.object.lovid);
        this.selectedLOVId = this.formQuestions.get('lovid').value;
        var dependentQuestionSequenceIndex = this.questionDependentList && event.object.dependentQuestion != -1 ? this.questionDependentList.findIndex(x => x.dependentQuestion == event.object.dependentQuestion) : -1;
        this.formQuestions.get('dependentQuestion').setValue(dependentQuestionSequenceIndex > -1 ? this.questionDependentList[dependentQuestionSequenceIndex] : null);
        // this.formQuestions.get('dependentQuestion').setValue(event.object.dependentQuestion == -1 ? undefined : event.object.dependentQuestion);
        if (this.questionDependentList && this.questionDependentList.length > 0 && dependentQuestionSequenceIndex > -1) {
          if (this.dataSource.data && this.dataSource.data.length > 0) {
            var questionIndex = this.dataSource.data.findIndex(x => x.fieldId == event.object.dependentQuestion)
            if (questionIndex > -1) {
              if (this.dataSource.data[questionIndex].questionOptions && this.dataSource.data[questionIndex].questionOptions.length > 0) {
                this.listOfLOVOptions = this.dataSource.data[questionIndex].questionOptions;
                //this.listOfLOVOptions = this.listValues.filter(x=> x.lovid ==$event.id )
              }
              else {
                //this.getLOVOptions(this.dataSource.data[questionIndex].lovid);
              }
            }
          }
          this.fillDependentAnswers(this.questionDependentList[dependentQuestionSequenceIndex].fieldTypeId);
          this.setAllowDefineDynamicParameter(this.questionDependentList[dependentQuestionSequenceIndex]);

          this.editedQuestionLOVId = this.formQuestions.get('lovid').value;
          let idx = this.questionValuesList.findIndex(lov => lov.id === this.editedQuestionLOVId);
          if (idx > -1) this.editedQuestionLOV = this.questionValuesList[idx];
          if (this.allowDefineDynamicParameter) {
            this.formQuestions.get('parameterName').setValue(event.object.dynamicField);
            this.formQuestions.get('parameterName').disable();
            this.isSelectedParameterUsedInLOV = this.editedQuestionLOV && this.editedQuestionLOV.dynamicField && this.editedQuestionLOV.dynamicField === event.object.dynamicField
              ? true : false;
            this.selectedFieldType = this.formQuestions.get('fieldSubTypeID').value;
            this.selectedDependentQuestion = this.formQuestions.get('dependentQuestion').value;
          }
          this.editedQuestion = event.object;
        }
        var dependentAnswerId = this.answerDependentList ? this.answerDependentList.findIndex(x => x.answerDependentId == event.object.dependentAnswer) : -1;
        this.formQuestions.get('dependentAnswer').setValue(dependentAnswerId > -1 ? this.answerDependentList[dependentAnswerId] : null);
        //this.formQuestions.get('dependentAnswer').setValue(event.object.dependentAnswer == -1 ? undefined : event.object.dependentAnswer);
        this.formQuestions.get('xlovid').setValue(event.object.xlovid == -1 ? undefined : event.object.xlovid);
        this.formQuestions.get('ylovid').setValue(event.object.xlovid == -1 ? undefined : event.object.ylovid);
        this.formQuestions.get('isMatrix').setValue(event.object.isMatrix);
        this.formQuestions.get('isMandatory').setValue(event.object.isMandatory);
        this.formQuestions.get('photoRequired').setValue(event.object.photoRequired);
        this.formQuestions.get('yesScore').setValue(event.object.yesScore);
        this.formQuestions.get('isBarcode').setValue(event.object.isBarcode);
        if (event.object.fieldTypeID == 4) {
          this.isYesNoQuestion = true;
        }
        if (event.object.fieldTypeID == 2) {
          this.isBarcode = true;
        }
        if(event.object.fieldTypeID == 5 || event.object.fieldTypeID == 6){
          this.ListValueMandatoryError = true;
        }
        if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf()) {
          this.formQuestions.get('actionTypeId').setValue(event.object.actionTypeId ? event.object.actionTypeId : null);
          this.formQuestions.get('actionTypeId').updateValueAndValidity();
          this.formQuestions.get('min').setValue(event.object.minValue);
          this.formQuestions.get('max').setValue(event.object.maxValue);
          this.formQuestions.get('minDate').setValue(!event.object.minDateModel ? null : event.object.minDateModel.date);
          this.minDate = !event.object.minDateModel ? null : event.object.minDateModel;
          this.formQuestions.get('maxDate').setValue(!event.object.maxDateModel ? null : event.object.maxDateModel.date);
          this.maxDate = !event.object.maxDateModel ? null : event.object.maxDateModel;
          this.formQuestions.get('yesNoId').setValue(event.object.yesNo ? this.yesNoList[0] : this.yesNoList[1]);
          if (event.object.lovid > -1) {
            this.listOfLOVOptions = this.listValues.filter(x => x.lovid == event.object.lovid)
          }
          var lovOptionId = this.listValues ? this.listValues.findIndex(x => x.lovOptionID == event.object.lovOptionID) : -1;
          this.formQuestions.get('lovOptionId').setValue(lovOptionId > -1 ? this.listValues[lovOptionId] : null);
        }
        if (this.dataSource != null || this.dataSource != undefined)
          this.addedQuestions = this.dataSource.data;
        var x = this.addedQuestions.findIndex(a => a === event.object);
        this.editQuestionIndex = x;
        this.selectedType = {
          fieldTypeId: event.object.fieldTypeID,
          fieldSubTypeId: event.object.fieldSubTypeID,
          fieldSubTypeName: event.object.questionTypeName,
        }
        this.questionNameOtherLanguages = null;
        this.questionNameOtherLanguages = event.object.questionNameDescriptionLanguages;
        this.editQuestionNameLanguages = null;
        this.editQuestionNameLanguages = event.object.questionNameDescriptionLanguages;

        this.questionBodyOtherLanguages = null
        this.questionBodyOtherLanguages = event.object.questionBodyDescriptionLanguages;
        this.editQuestionBodyLanguages = null;
        this.editQuestionBodyLanguages = event.object.questionBodyDescriptionLanguages;

        if (this.editQuestionIndex >= 0)
          this.buttonText = 'Desc_Edit';
        this.EnableDisableListValues(event.object.fieldTypeID);
        this.onMatrixChange();
        break;
      case RowOperation.delete:
        if (this.checkIfQuestionHasDependencies(event.object)) {
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgCannotPerformOperationDueToDependency) // "Cannot delete question due to dependencies"
          );
          return;
        }
        this.coreSession.ModalDialog.ShowMessage(
          this.translateService.instant(ConstantMessages.MsgDeleteConfirmation),
          DialogMode.YesNo,
          this.translateService.instant(ConstantMessages.Delete)
        ).then((result: DialogResult) => {
          if (result === DialogResult.Yes) {
            this.AllowDeleteQuestion(event);
          }
        });
        break;
      case RowOperation.approve:
        //UP
        if (this.buttonText == 'Desc_Edit') {
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgQuestionReordering)
          );
          return;
        }
        if (event.index > 0) {
          if (this.editQuestionIndex > 0) {
            this.editQuestionIndex = event.index - 1;
          }
          if (this.dataSource.data[event.index].dependentQuestion != -1) {
            var questionIndex = this.dataSource.data.findIndex(x => x.fieldId == this.dataSource.data[event.index].dependentQuestion)
            if (questionIndex != -1 && this.dataSource.data[questionIndex].sequence >= (event.index)) {
              this.coreSession.showWarrning(
                this.translateService.instant(ConstantMessages.WarningCaption),
                this.translateService.instant(ConstantMessages.MsgQuestionDependency)
              );
              return;
            }
          }
          let arrayUp: any[] = [];
          for (let i = 0; i < this.dataSource.totalItems; i++) {
            ((event.index - 1), "(event.index - 1)");
            if (i === (event.index - 1)) {
              this.dataSource.data[event.index].sequence = i + 1;
              arrayUp.push(this.dataSource.data[event.index]);
            }
            else if (i === event.index) {
              this.dataSource.data[event.index - 1].sequence = i + 1;
              arrayUp.push(this.dataSource.data[event.index - 1]);
            }
            else {
              this.dataSource.data[i].sequence = i + 1;
              arrayUp.push(this.dataSource.data[i]);
            }
          }
          this.dataSource = {
            data: [],
            totalItems: 0
          }
          this.dataSource = {
            data: arrayUp,
            totalItems: arrayUp.length
          }
        }
        break;
      case RowOperation.invoiceOrder:
        //Down
        if (this.buttonText == 'Desc_Edit') {
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgQuestionReordering)
          );
          return;
        }
        if (event.index != this.dataSource.totalItems - 1) {
          if (this.editQuestionIndex > 0) {
            this.editQuestionIndex = event.index + 1;
          }
          if (this.dataSource.data[event.index + 1].dependentQuestion != -1) {
            var questionIndex = this.dataSource.data.findIndex(x => x.fieldId == this.dataSource.data[event.index + 1].dependentQuestion)
            if (questionIndex != -1 && this.dataSource.data[questionIndex].sequence >= (event.index + 1)) {
              this.coreSession.showWarrning(
                this.translateService.instant(ConstantMessages.WarningCaption),
                this.translateService.instant(ConstantMessages.MsgQuestionDependency)
              );
              return;
            }
          }
          let arrayDown: any[] = [];
          for (let i = 0; i < this.dataSource.totalItems; i++) {
            if (i === event.index) {
              this.dataSource.data[event.index + 1].sequence = i + 1;
              arrayDown.push(this.dataSource.data[event.index + 1]);

            }
            else if (i === event.index + 1) {
              this.dataSource.data[event.index].sequence = i + 1;
              arrayDown.push(this.dataSource.data[event.index]);
            }
            else {
              this.dataSource.data[i].sequence = i + 1;
              arrayDown.push(this.dataSource.data[i]);
            }
          }
          this.dataSource = {
            data: [],
            totalItems: 0
          }
          this.dataSource = {
            data: arrayDown,
            totalItems: arrayDown.length
          }
        }
        break;
    }
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  checkIfQuestionHasDependencies(question): boolean {
    let hasDependencies: boolean = false;
    var dependentQuestions = this.dataSource.data.filter(addedQuestion =>
      question.fieldId === addedQuestion.dependentQuestion &&
      question.sequence < addedQuestion.sequence &&
      addedQuestion.dynamicField != null && addedQuestion.dynamicField.trim() != '');
    if (dependentQuestions && dependentQuestions.length > 0) {
      hasDependencies = true;
    }
    return hasDependencies;
  }
  onChange(image, index) {
    let unCheckedCount = 0;
    if (this.imagesPaths && this.imagesPaths.length > 0) {
      this.imagesPaths.forEach((path, i) => {
        if (i != index)
          path.isChecked = false;
      });
      image.isChecked = !image.isChecked;
      unCheckedCount = this.imagesPaths.filter(x => !x.isChecked).length
      if (unCheckedCount == this.imagesPaths.length)
        this.disableSaveDialog = true;
      else
        this.disableSaveDialog = false;

    }
  }
  afterChangingLinkedToPromotionFlag(selectedValue) {
    this.formGeneral.get('linkedToProm').setValue(selectedValue);
    if (this.formGeneral.get('linkedToProm').value) {
      this.isLinkedToPromotion = true;
      this.questionSubTypeList = this.questionSubTypeList.filter(x => x.fieldTypeId == 4 || x.fieldTypeId == 5 || x.fieldTypeId == 6)
      this.navLinks[2].hidden = true;
      this.navLinks[3].hidden = true;
      this.formQuestions.get('isMandatory').setValue(true);
      this.formQuestions.get('isMandatory').updateValueAndValidity();
      this.formGeneral.get('fromDate').setValidators(Validators.nullValidator);
      this.formGeneral.get('fromDate').updateValueAndValidity();
      this.formGeneral.get('toDate').setValidators(Validators.nullValidator);
      this.formGeneral.get('toDate').updateValueAndValidity();
      if (this.isYesNoLoading == true) {
        this.formQuestions.get('yesScore').setValidators(Validators.required);
        this.formQuestions.get('yesScore').updateValueAndValidity();
      }
      else {
        this.formQuestions.get('yesScore').setValidators(Validators.nullValidator);
        this.formQuestions.get('yesScore').updateValueAndValidity();
      }
    } else {
      this.isLinkedToPromotion = false;
      this.questionSubTypeList = this.allSubTypesList.slice();
      this.navLinks[2].hidden = false;
      this.navLinks[3].hidden = false;
      this.formQuestions.get('isMandatory').setValue(false);
      this.formQuestions.get('isMandatory').updateValueAndValidity();
      this.formGeneral.get('fromDate').setValidators(Validators.required);
      this.formGeneral.get('fromDate').updateValueAndValidity();
      this.formGeneral.get('toDate').setValidators(Validators.required);
      this.formGeneral.get('toDate').updateValueAndValidity();
      this.formQuestions.get('yesScore').setValidators(Validators.nullValidator);
      this.formQuestions.get('yesScore').updateValueAndValidity();
    }
  }
  onChangeLinkedToPromotionFlag() {
    var selectedValue = this.formGeneral.get('linkedToProm').value;
    this.formGeneral.get('linkedToProm').setValue(this.isLinkedToPromotion);
    if (this.dataSource != null && this.dataSource.data != null && this.dataSource.data.length > 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.dataSource = {
              data: [],
              totalItems: 0
            }
            this.afterChangingLinkedToPromotionFlag(selectedValue);
          }
        });
    }
    else {
      this.afterChangingLinkedToPromotionFlag(selectedValue);
    }
  }
  showSurveyMenuIconDialog() {
    this.getSurveyMenusImages();
  }
  onSaveClicked() {
    this.markasTouched();
    if (this.formGeneral.invalid
    ) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
      if (this.formGeneral.invalid) {
        this.navBarSelectedIndex = 0;
      } else
        if (this.formQuestions.invalid) {
          this.navBarSelectedIndex = 1;
        } else
          if (this.formApplyTo.invalid) {
            this.navBarSelectedIndex = 2;
          } else
            if (this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf() && this.surveyObject.forceFillingMode > 0 && this.mustFillPeriodForm.invalid) {
              this.navBarSelectedIndex = 3;
            }
      this.navLinks[this.navBarSelectedIndex].isActive = true;
      this.ChangeDataView(this.navBarSelectedIndex);
      return;
    }
    if ((this.validFromDate && this.validToDate) && this.validFromDate.date > this.validToDate.date) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFromDateLessThanToDate)
      );
      return;
    }
    if (this.dataSource.totalItems <= 0) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant("Desc_Must_Add_Question")
      );
      this.navBarSelectedIndex = 1;
      this.navLinks[1].isActive = true;
      this.ChangeDataView(1);
      return;
    }
    if (this.mustFillPeriodForm.get('periodTypeId').value != null && this.mustFillPeriodForm.get('periodTypeId').value[0].periodTypeId === SurveyPeriodTypes.Custom && this.listOfPeriodsViewTable.data.length == 0) {

      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant("Desc_You_Should_Fill_At_Least_One_Period")
      );
      this.navBarSelectedIndex = 3;
      this.navLinks[3].isActive = true;
      this.ChangeDataView(3);
      return;
    }

    let groupIds = this.formApplyTo.get('groupId').value;
    let channelIds = this.formApplyTo.get('channelSubChannel').value;
    let customerIds = this.addedCustomersList;
    this.formApplyTo.get('customerId').setValue(this.addedCustomersList);
    // Customer Security Group Validation
    if (!this.isLinkedToPromotion && this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()) {
      this.addedSecurityGroups = this.formApplyTo.get('securityGroups').value;
      if (!this.allSecurityGroups && (!this.addedSecurityGroups || (this.addedSecurityGroups && this.addedSecurityGroups.length <= 0))) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant("Desc_Must_Add_Security_Group")
        );
        this.navBarSelectedIndex = 2;
        this.navLinks[2].isActive = true;
        this.ChangeDataView(2);
        return;
      }
    }

    // Customer Validation
    if (!this.isLinkedToPromotion && (this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf() || this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()) && !this.allCustomers && !this.formGeneral.value.applyForNewCustomers) {
      if ((!groupIds || (groupIds && groupIds.length < 1)) && (!channelIds || (channelIds && channelIds.length < 1)) && (!customerIds || (customerIds && customerIds.length < 1))) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant("Desc_Must_Add_Apply_To")
        );
        this.navBarSelectedIndex = 2;
        this.navLinks[2].isActive = true;
        this.ChangeDataView(2);
        return;
      }
    }

    // Quality Control Validation
    if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf()) {
      if ((!this.formApplyTo.get("warehouse") || !this.formApplyTo.get("warehouse").value || this.formApplyTo.get("warehouse").value.length == 0)
        &&
        (!this.formApplyTo.get("vehicle") || !this.formApplyTo.get("vehicle").value || this.formApplyTo.get("vehicle").value.length == 0)
        &&
        (!this.formApplyTo.get("damagedWarehouses") || !this.formApplyTo.get("damagedWarehouses").value || this.formApplyTo.get("damagedWarehouses").value.length == 0)) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgSelectWarehouseVehicleOrDamagedWarehouse)
        );
        this.navBarSelectedIndex = 2;
        this.navLinks[2].isActive = true;
        this.ChangeDataView(2);
        return;
      }
      if (!this.formApplyTo.get("inspector") || !this.formApplyTo.get("inspector").value || this.formApplyTo.get("inspector").value.length == 0) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgFillMandatory)
        );
        this.navBarSelectedIndex = 2;
        this.navLinks[2].isActive = true;
        this.ChangeDataView(2);
        return;
      }
      this.formApplyTo.get("itemsControl").setValue(this.addedItemsList);
      if (!this.formApplyTo.get("allItems").value && (!this.formApplyTo.get("itemsControl") || (this.formApplyTo.get("itemsControl") && this.formApplyTo.get("itemsControl").value.length == 0))) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgFillMandatory)
        );
        this.navBarSelectedIndex = 2;
        this.navLinks[2].isActive = true;
        this.ChangeDataView(2);
        return;
      }
    }
    // Employee Survey Validation on At least one employee or one security group
    if ((this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf())) {
      this.appliedEmployeesList = this.formApplyTo.get('employeeId').value;
      this.addedSecurityGroups = this.formApplyTo.get('securityGroups').value;
      if (!this.allEmployees && (!this.appliedEmployeesList || (this.appliedEmployeesList && this.appliedEmployeesList.length <= 0)) &&
        (!this.allSecurityGroups && (!this.addedSecurityGroups || (this.addedSecurityGroups && this.addedSecurityGroups.length <= 0)))) {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.Desc_Apply_Employee_Or_Security_Group)
        );
        this.navBarSelectedIndex = 2;
        this.navLinks[2].isActive = true;
        this.ChangeDataView(2);
        return;
      }
    }
    this.FillSurveyObject();

    (this.formGeneral, "formGeneral");
    (this.surveyFullObject, "this.surveyFullObject");
    if (this.surveyFullObject.appliedDisplayUnit.length <= 0 && this.surveyFullObject.appliedDisplayUnitType.length <= 0 && this.surveyTypeId == 3) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgConfirmationAppliedToSurvey),
        DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              if (this.isEditMode)
                this.UpdateCustomerSurvey();
              else
                this.SaveCustomerSurvey();
            } else {
              return;
            }
          });
    } else {
      if (this.isEditMode)
        this.UpdateCustomerSurvey();
      else
        this.SaveCustomerSurvey();
    }
  }
  FillSurveyObject() {
    this.surveyFullObject = new Object();
    /// General Tab
    if (this.isEditMode) {
      this.surveyFullObject.surveyId = this.surveyObject.surveyId;
      this.surveyFullObject.dcfid = this.surveyObject.dcfid;
      // this.surveyFullObject.validFromModel = this.formGeneral.value.fromDate;
      // this.surveyFullObject.validToModel = this.formGeneral.value.toDate;
    }
    else {
      this.surveyFullObject.surveyId = -1;
      this.surveyFullObject.dcfid = -1;

    }
    this.surveyFullObject.surveyTypeId = this.surveyTypeId;
    this.surveyFullObject.validFromModel = this.isLinkedToPromotion ? this.coreSession.GetCurrentDateAsModel() : this.validFromDate;
    this.surveyFullObject.validToModel = this.isLinkedToPromotion ? this.coreSession.GetCurrentDateAsModel() : this.validToDate;
    this.surveyFullObject.deletedQuestion = this.deletedQuestionList;
    this.surveyFullObject.surveyName = this.formGeneral.value.surveyName;
    this.surveyFullObject.letterHead = this.formGeneral.value.letterHead;
    this.surveyFullObject.timeToFill = this.formGeneral.value.timeToFill;
    this.surveyFullObject.routeHistoryStatusId = this.formGeneral.value.routeHistoryStatusId === null ? -1 : this.formGeneral.value.routeHistoryStatusId;
    this.surveyFullObject.surveySequence = this.formGeneral.value.surveySequence === null || this.formGeneral.value.routeHistoryStatusId === null? undefined : this.formGeneral.value.surveySequence;
    this.surveyFullObject.AppliedCustomers = this.addedCustomersList;
    this.surveyFullObject.AppliedGroups = this.formApplyTo.get('groupId').value;
    this.surveyFullObject.AppliedChannels = this.formApplyTo.get('channelSubChannel').value;

    if (this.formGeneral.value.numberOfQus === undefined || this.formGeneral.value.numberOfQus === null)
      this.surveyFullObject.numberOfQuestions = this.dataSource.totalItems;
    else
      this.surveyFullObject.numberOfQuestions = this.formGeneral.value.numberOfQus;
    if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf())
      this.surveyFullObject.surveyPeriodTypeId = !this.formGeneral.get('periodTypeId') ? -1 : this.formGeneral.value.periodTypeId;
    else {
      if (this.mustFillPeriodForm.get('periodTypeId').value === null)
        this.surveyFullObject.SurveyPeriodTypeId = -1;
      else {
        this.surveyFullObject.SurveyPeriodTypeId = this.mustFillPeriodForm.get('periodTypeId').value[0].periodTypeId
        //let surveyDates: SurveyPeriod[] = []
        // if (this.surveyFullObject.SurveyPeriodTypeId === SurveyPeriodTypes.Custom) {
        //   this.listOfPeriodsViewTable.data.forEach(x => {
        //     let surveyDate: SurveyPeriod = new SurveyPeriod();
        //     surveyDate.fromDateModel = this.surveyObject.validFromModel
        //     surveyDate.fromDateModel.date = (x.fromDate.getDate());
        //     surveyDate.fromDateModel.Month = (x.fromDate.getMonth());
        //     surveyDate.fromDateModel.FullYear = (x.fromDate.getFullYear());
        //     // surveyDate.fromDate =new Date(x.fromDate)
        //     // surveyDate.toDate =new Date(x.toDate)
        //     surveyDate.toDateModel = this.surveyObject.validToModel
        //     surveyDate.toDateModel.date = (x.toDate.getDate());
        //     surveyDate.toDateModel.Month = (x.toDate.getMonth());
        //     surveyDate.toDateModel.FullYear = (x.toDate.getFullYear());
        //     surveyDates.push(surveyDate);
        //   })
        // }
        this.surveyFullObject.ListOfPeriods = this.listOfPeriods;
      }

    }
    if (this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf())
      this.surveyFullObject.points = !this.formGeneral.get('points') ? 0 : this.formGeneral.value.points;
    else
      this.surveyFullObject.points = 0;
    if (this.formGeneral.value.inActive === undefined || this.formGeneral.value.inActive === null)
      this.surveyFullObject.inActive = false;
    else
      this.surveyFullObject.inActive = this.formGeneral.value.inActive;

    if (this.formGeneral.value.applyForNewCustomers === undefined || this.formGeneral.value.applyForNewCustomers === null)
      this.surveyFullObject.applyForNewCustomers = false;
    else
      this.surveyFullObject.applyForNewCustomers = this.formGeneral.value.applyForNewCustomers;

    if (this.formGeneral.get('linkedToProm') === undefined || this.formGeneral.get('linkedToProm') === null)
      this.surveyFullObject.linkedToProm = false;
    else
      this.surveyFullObject.linkedToProm = this.formGeneral.get('linkedToProm').value;

    if (this.formGeneral.value.forceFill === undefined || this.formGeneral.value.forceFill === null)
      this.surveyFullObject.forceFillingMode = 0;
    else
      this.surveyFullObject.forceFillingMode = this.formGeneral.value.forceFill.modeId;


    let descriptions = this.surveyNameOtherLanguages;
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.formGeneral.value.surveyName
      });
    }
    this.surveyFullObject.surveyNameDescriptionLanguages = descriptions;

    descriptions = this.letterHeadOtherLanguages;
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.formGeneral.value.letterHead
      });
    }
    this.surveyFullObject.letterHeadDescriptionLanguages = descriptions;
    this.surveyFullObject.isMainMenu = this.showAsMainMenu;
    /// Questions Tab
    this.surveyFullObject.questions = this.dataSource.data;

    /// Apply To Tab
    this.surveyFullObject.allCustomers = this.formGeneral.get('assignToAllCustomers') && this.formGeneral.get('assignToAllCustomers').value ? this.formGeneral.get('assignToAllCustomers').value : false;
    this.surveyFullObject.allOrganizationEmployees = this.formGeneral.get('assignToAllEmployees') && this.formGeneral.get('assignToAllEmployees').value ? this.formGeneral.get('assignToAllEmployees').value : false;
    this.surveyFullObject.applyTo = this.appliedToList;
    this.surveyFullObject.appliedEmployees = this.appliedEmployeesList;
    this.surveyFullObject.securityGroups = this.addedSecurityGroups;

    // this.surveyFullObject.appliedDisplayUnit =
    // this.surveyFullObject.appliedDisplayUnitType =

    if (this.formGeneral.value.assignToAllSecurityGroups === undefined
      || this.formGeneral.value.assignToAllSecurityGroups === null
      || this.formGeneral.value.assignToAllSecurityGroups === "") {
      this.surveyFullObject.allSecurityGroups = false;
    }
    else {
      this.surveyFullObject.allSecurityGroups = this.formGeneral.value.assignToAllSecurityGroups;
    }

    this.surveyFullObject.appliedWarehouses = this.formApplyTo.get('warehouse').value ? this.formApplyTo.get('warehouse').value : [];
    this.surveyFullObject.appliedVehicles = this.formApplyTo.get('vehicle').value ? this.formApplyTo.get('vehicle').value : [];
    this.surveyFullObject.appliedDamagedWarehouses = this.formApplyTo.get('damagedWarehouses').value ? this.formApplyTo.get('damagedWarehouses').value : [];
    this.surveyFullObject.appliedInspectors = this.formApplyTo.get('inspector').value ? this.formApplyTo.get('inspector').value : [];
    this.surveyFullObject.appliedEmployees = this.formApplyTo.get('employeeId').value ? this.formApplyTo.get('employeeId').value : [];


    this.surveyFullObject.appliedDisplayUnit = this.addedDisplayUnitList//  this.formApplyTo.get('displayUnitControl').value ? this.formApplyTo.get('displayUnitControl').value : [];
    this.surveyFullObject.appliedDisplayUnitType = this.formApplyTo.get('displayUnitTypeControl').value ? this.formApplyTo.get('displayUnitTypeControl').value : [];

    this.surveyFullObject.appliedItems = this.formApplyTo.get('itemsControl').value ? this.formApplyTo.get('itemsControl').value : [];
    this.surveyFullObject.allItems = this.formApplyTo.get('allItems').value === null ? false : this.formApplyTo.get('allItems').value;
    this.surveyFullObject.isMainMenu = this.showAsMainMenu;
    this.surveyFullObject.imageId = this.showAsMainMenu ? this.selectedIconName : '';
    // this.surveyFullObject.organizationsList=this.organizationsList;
    this.surveyFullObject.organizationsList = [];
    this.surveyFullObject.organizationId = -1;
    // this.mustFillPeriod.get('toDate').enable()
    if (this.organizationsListControl.value) {
      this.surveyFullObject.organizationsList = this.organizationsListControl.value;
      if (this.organizationsListControl.value.length === 1) {
        this.surveyFullObject.organizationId = this.organizationsListControl.value[0].organizationId;
      }
    }
  }
  get organizationsListControl() {
    return this.formGeneral.get('organizationsList');
  }
  //#endregion

  //#region API
  //#region Quality Control
  getSurveyPeriods(surveyId: number) {
    this.coreSession.ModalLoading.Show();
    this.surveyService.getSurveyPeriods(surveyId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          response.data.forEach(period => {
            this.listOfPeriods.push({
              'fromDateModel': period.fromDateModel,
              'toDateModel': period.toDateModel,
              'fromDate': period.fromDateModel.date,
              'toDate': period.toDateModel.date
            })
          });
          this.listOfPeriodsViewTable = {
            data: this.listOfPeriods,
            totalItems: this.listOfPeriods.length
          }
          this.mustFillPeriodForm.get('fromDate').enable()
          this.mustFillPeriodForm.get('toDate').enable()
          this.isCustomPeriod = true;
          // this.listOfPeriods = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getLOVOptions(lOVId: number) {
    this.coreSession.ModalLoading.Show();
    this.surveyService.getLOVOptions(lOVId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          (response.data);
          this.listValues = response.data;
          if (lOVId > -1)
            this.listOfLOVOptions = this.listValues.filter(x => x.lovid == lOVId)
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getQualityControlAppliedList(surveyId: any) {
    this.coreSession.ModalLoading.Show();
    this.surveyService.getQualityControlAppliedList(surveyId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.appliedInspectors = response.data.appliedInspectors;
          this.appliedWarehouses = response.data.appliedWarehouses;
          this.appliedVehicles = response.data.appliedVehicles;
          this.appliedDamagedWarehouses = response.data.appliedDamagedWarehouses;
          this.appliedItems = response.data.appliedItems;
          this.applyOnAllItems = response.data.applyOnAllItems;
          this.formApplyTo.get('warehouse').setValue(this.appliedWarehouses);
          this.formApplyTo.get('vehicle').setValue(this.appliedVehicles);
          this.formApplyTo.get('damagedWarehouses').setValue(this.appliedDamagedWarehouses);
          this.formApplyTo.get('inspector').setValue(this.appliedInspectors);
          this.formApplyTo.get('allItems').setValue(this.applyOnAllItems);
          if (!this.applyOnAllItems) {
            this.formApplyTo.get('itemsControl').setValue(this.appliedItems);
            this.addedItemsList = this.appliedItems;
            this.itemsDataSource = { data: this.appliedItems, totalItems: this.appliedItems.length };
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getSelectedOrganizationIdsAsString(list) {
    this.organizationIdsString = '';
    if (list && list.length > 0) {
      this.organizationIdsString = list.map(({ organizationId }) => organizationId).join(',');
    }
    else {
      this.organizationIdsString = '-1';
    }
    if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf()) {
      if (this.isEditMode || this.isCloneMode) {
        this.coreSession.ModalLoading.Show();
        let warehouseFilter = {
          vehicleId: -1,
          organizationIds: this.organizationIdsString
        }
        var warehouseDataResponse = this.warehouseService.getWarehouses(warehouseFilter);
        this.vehiclesFilter = {
          employeeId: -1,
          organizationId: -1,
          organizationIds: this.organizationIdsString,
          getFree: false
        };
        var vehicleDataResponse = this.vehicleService.getAllVehicles(this.vehiclesFilter)
        let damagedWarehousesFilter = {
          divisionId: -1,
          organizationIds: this.organizationIdsString,
          warehouseTypeId: WarehouseTypes.DealerWarehouse.valueOf(),
          employeeId: -1
        }
        var damagedWarehouseResponse = this.vehicleService.getVehicleAvailableWarehousesToAdd(damagedWarehousesFilter);
        var inspectorResponse = this.employeeservice.getAllInspectors(this.organizationIdsString);
        forkJoin(warehouseDataResponse, vehicleDataResponse, damagedWarehouseResponse, inspectorResponse).subscribe(response => {
          this.coreSession.ModalLoading.Hide();
          if (response[0] != null) {
            this.warehousesList = response[0];
          }
          if (response[1] != null) {
            this.vehiclesList = response[1];
          }
          if (response[2] != null) {
            this.damagedWarehousesList = response[2];
          }
          if (response[3].status != null && response[3].status >= 0) {
            this.inspectorsList = response[3].data;
          }
          if ((response[0] != null)
            && (response[1] != null)
            && (response[2] != null)
            && (response[3].status != null && response[3].status >= 0)) {
            this.getQualityControlAppliedList(this.surveyObject.surveyId);
          }
        },
          (error: HttpErrorResponse) => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
          }
        );
      }
      else {
        this.fillLoadingWarehousesList();
        this.fillVehiclesList();
        this.fillDamagedWarehousesList();
        this.fillInspectorsList();
      }
    }
    if (this.surveyTypeId == SurveyTypes.EmployeeSurvey) {
      this.fillEmployeesList();
    }
    if (this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf() || this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf()) {
      this.fillSecurityGroupsList();
    }
  }
  fillInspectorsList() {
    this.isInspectorsLoading = true;
    this.employeeservice.getAllInspectors(this.organizationIdsString).subscribe(
      (result) => {
        this.inspectorsList = result.data;
        this.isInspectorsLoading = false;
      });
  }
  populateDisplayUnitList() {
  }

  populateDisplayUnitTypeList() {

  }


  fillEmployeesList() {
    this.employeeservice.getAllSurveyEmployees('').subscribe(
      (result) => {
        this.allEmployeesList = result.data;
        this.filterEmployeeData();
      });
  }
  fillSecurityGroupsList() {
    this.employeeservice.getAllSecurityGroupsList().subscribe(
      (result) => {
        this.allSecurityGroupList = result.data;
        this.filterSecurityData()
      });
  }
  fillLoadingWarehousesList() {
    let warehouseFilter = {
      vehicleId: -1,
      organizationIds: this.organizationIdsString
    }
    this.isWarehousesLoading = true;
    this.warehouseService.getWarehouses(warehouseFilter).subscribe(result => {
      this.warehousesList = result;
      this.isWarehousesLoading = false;
    });
  }
  fillVehiclesList() {
    this.vehiclesFilter = {
      employeeId: -1,
      organizationId: -1,
      organizationIds: this.organizationIdsString,
      getFree: false
    };
    this.isLoadingVehiclesLoading = true;
    this.vehiclesList = [];
    this.coreSession.ModalLoading.Show();
    this.vehicleService.getAllVehicles(this.vehiclesFilter).subscribe(result => {
      this.coreSession.ModalLoading.Hide();
      this.vehiclesList = result;
      this.isLoadingVehiclesLoading = false;
    }
      , (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  fillDamagedWarehousesList() {
    this.isDamagedWarehousesLoading = true;
    let damagedWarehousesFilter = {
      divisionId: -1,
      organizationIds: this.organizationIdsString,
      warehouseTypeId: WarehouseTypes.DealerWarehouse.valueOf(),
      employeeId: -1
    }
    this.vehicleService.getVehicleAvailableWarehousesToAdd(damagedWarehousesFilter).subscribe(
      (result) => {
        this.damagedWarehousesList = result;
        this.isDamagedWarehousesLoading = false;
      });
  }
  fillActionsTypesList() {
    this.isActionTypeLoading = true;
    this.actionTypesList = [];
    this.actionTypesList.push({ actionTypeId: SurveyActionsTypes.SendEmail.valueOf(), actionTypeName: this.translateService.instant(ConstantMessages.Desc_Send_Email) });
    this.actionTypesList.push({ actionTypeId: SurveyActionsTypes.SendSystemNotification.valueOf(), actionTypeName: this.translateService.instant(ConstantMessages.Desc_Send_System_Notification) });
    this.actionTypesList.push({ actionTypeId: SurveyActionsTypes.MoveItemToGoodOrDamagedWarehouse.valueOf(), actionTypeName: this.translateService.instant(ConstantMessages.Desc_Move_Item_To_Good_Or_Damaged_Warehouse) });
    this.isActionTypeLoading = false;
  }
  fillYesNoList() {
    this.isYesNoLoading = true;
    this.yesNoList = [];
    this.yesNoList.push({ valueId: 1, valueName: this.translateService.instant(ConstantMessages.Desc_Yes) });
    this.yesNoList.push({ valueId: 0, valueName: this.translateService.instant(ConstantMessages.Desc_No) });
    this.isYesNoLoading = false;
  }
  fillListValues() {
    this.isListValuesLoading = true;
    this.listValues = [];
    //getLOVOptions(LOVId)
    this.isListValuesLoading = false;
  }
  fillDependentQuestions(sequence: number, checkSequence: boolean) {
    this.isQuestionDependentLoading = true;
    this.questionDependentList = [];
    if (this.dataSource.data != null && this.dataSource.data.length > 0) {
      this.dataSource.data.forEach(question => {
        //if ((question.fieldTypeID == 4 || question.fieldTypeID == 5) && (!checkMaxFieldId || (checkMaxFieldId && (!this.isEditMode && (question.fieldId > selectedFieldId)) || (this.isEditMode && (question.fieldId != -1 && question.fieldId < selectedFieldId))))) {
        if ((question.fieldTypeID == 4 || question.fieldTypeID == 5) && (!checkSequence || (checkSequence && (question.sequence < sequence)))) {

          this.questionDependentList.push(
            {
              dependentQuestion: question.fieldId,
              name: question.questionName,
              fieldTypeId: question.fieldTypeID,
              sequence: question.sequence
            }
          )
          if (question.fieldTypeID == 5)
            this.fillDependentAnswers(question.lovid);
        }
      });
    }
  }
  fillDependentAnswers(fieldTypeId: number) {
    this.isAnswerDependentLoading = true;
    this.answerDependentList = [];
    if (fieldTypeId == 4) {
      this.yesNoList.forEach(value => {
        this.answerDependentList.push(
          {
            answerDependentId: value.valueId,
            answerName: value.valueName,
          }
        )
      });
    }
    else if (fieldTypeId == 5) {
      this.listOfLOVOptions.forEach(value => {
        this.answerDependentList.push(
          {
            answerDependentId: value.lovOptionID,
            answerName: value.lovOptionName,
          }
        )
      });
    }
  }
  fillSurveyPeriodTypesList() {
    this.isSurveyPeriodTypesLoading = true;
    this.coreSession.ModalLoading.Show();
    this.surveyService.getSurveyPeriodTypes(this.surveyTypeId).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.surveyPeriodTypesList = response.data;
        this.isSurveyPeriodTypesLoading = false;
        if ((this.surveyObject.surveyPeriodTypeId !== null && this.surveyObject.surveyPeriodTypeId !== undefined) && this.surveyObject.surveyPeriodTypeId != -1) {
          let period = this.surveyPeriodTypesList.filter(x => x.periodTypeId == this.surveyObject.surveyPeriodTypeId)

          this.mustFillPeriodForm.get('periodTypeId').setValue([{
            periodTypeId: period[0].periodTypeId,
            periodTypeName: period[0].periodTypeName
          }])
          if (this.surveyObject.surveyPeriodTypeId === SurveyPeriodTypes.Custom)
            this.getSurveyPeriods(this.surveyObject.surveyId);
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });

  }
  //#endregion
  FillUI(savedLovId: number = -1) {
    this.coreSession.ModalLoading.Show();
    this.surveyService.FillUI(this.surveyTypeId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.questionTypeList = response.data.questionTypeList;
          this.forceFillingModeList = [{ modeId: 0, modeDescription: this.getForceFillingModeDescription(0) }, { modeId: 1, modeDescription: this.getForceFillingModeDescription(1) }, { modeId: 2, modeDescription: this.getForceFillingModeDescription(2) }]
          this.questionSubTypeList = response.data.questionSubTypeList;
          this.allSubTypesList = this.questionSubTypeList.slice();
          if (this.isLinkedToPromotion)
            this.questionSubTypeList = this.questionSubTypeList.filter(x => x.fieldTypeId == 4 || x.fieldTypeId == 5 || x.fieldTypeId == 6)

          if (savedLovId == -1) {
            this.questionValuesList = response.data.questionValuesList.filter(val => !val.dynamicField || val.dynamicField == '');
          } else {
            this.questionValuesList = response.data.questionValuesList.filter(val => !val.dynamicField || val.dynamicField == '' || val.id === savedLovId);
          }
          this.originalQuestionValuesList = response.data.questionValuesList;


          this.xList = response.data.xList;
          this.yList = response.data.yList;
          this.groupList = response.data.fieldGroups;
          this.organizationsList = response.data.organizationList;
          this.addedSecurityGroups = response.data.addedSecurityGroups;
          if (this.organizationsList && this.organizationsList.length == 1) {
            this.organizationsListControl.setValue(this.organizationsList);
            this.onChangeOrganization(false);
          }
          if (this.afterNewLOVSaved) {
            this.selectedNewLOV = this.questionValuesList[this.questionValuesList.length - 1].id
            this.getLOVOptions(this.selectedNewLOV);
            this.afterNewLOVSaved = false;

            let idx = this.questionValuesList.findIndex(q => q.id === this.editedQuestionLOVId);
            if (idx > -1 && this.isQuestionEditMode && this.allowDefineDynamicParameter) {
              this.questionValuesList.splice(idx, 1);
              let temp = cloneDeep(this.questionValuesList);
              this.questionValuesList = [];
              this.questionValuesList = temp;
            }
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  AllowDeleteQuestion(event: any) {
    this.coreSession.ModalLoading.Show();
    this.surveyService.AllowDeleteQuestion(event.object.fieldId, this.surveyObject.surveyTypeId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (!response.data) {
            var x = this.dataSource.data.findIndex(a => a === event.object);
            this.dataSource.data.splice(x, 1);
            this.dataSource.data = this.dataSource.data.slice();
            this.dataSource.totalItems = this.dataSource.totalItems - 1;

            if (this.dataSource && this.dataSource.data) {
              let temp = cloneDeep(this.dataSource.data);
              this.dataSource = {
                data: temp,
                totalItems: temp.length
              };
            }
            if (this.dataSource != null || this.dataSource != undefined)
              this.addedQuestions = this.dataSource.data;
            if (this.dataSource.totalItems == 0)
              this.dataSource = {
                data: [],
                totalItems: 0
              }
            this.formGeneral.get("numberOfQus").setValue(this.dataSource.totalItems);
            this.resetQuestionsValue();
            if (this.isEditMode)
              this.deletedQuestionList.push(event.object.fieldId);
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant('Desc_Question_Has_Answers')
            );
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getFieldGroups() {
    this.surveyService.getFieldGroups().subscribe(result => {
      this.groupList = result.data;
      this.formQuestions.get("fieldGroupId").setValue(this.groupList[this.groupList.length - 1].id);
    });
  }
  getAppliedList(surveyId: any) {
    this.coreSession.ModalLoading.Show();
    this.surveyService.getAppliedList(surveyId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          (response.data, "questions");
          this.appliedToList = response.data.creditReleaseAssignments;
          this.addedSecurityGroups = response.data.securityGroupsList;
          this.formApplyTo.get('securityGroups').setValue(this.addedSecurityGroups);
          this.addedGroups = response.data.groups;
          this.formApplyTo.get('groupId').setValue(response.data.groups);
          this.formApplyTo.get('channelSubChannel').setValue(response.data.channels);
          this.addedCustomersList = response.data.customers;

          this.customersDataSource = {
            data: this.addedCustomersList,
            totalItems: this.addedCustomersList.length
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getEmployeeAppliedList(surveyId: any) {
    this.coreSession.ModalLoading.Show();
    this.surveyService.getEmployeeAppliedList(surveyId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.appliedEmployeesList = response.data.appliedEmployee;
          this.addedSecurityGroups = response.data.securityGroups;
          this.formApplyTo.get('employeeId').setValue(this.appliedEmployeesList);
          this.formApplyTo.get('securityGroups').setValue(this.addedSecurityGroups);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getDisplayUnitAppliedList(surveyId: any) {
    this.coreSession.ModalLoading.Show();
    this.surveyService.getDisplayUnitAppliedList(surveyId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {

          var sharedTableData = {
            data: response.data.appliedDisplayUnit,
            totalItems: response.data.appliedDisplayUnit.length
          };

          this.addedDisplayUnitList = sharedTableData.data;
          this.displayUnitDataSource = {
            totalItems: this.addedDisplayUnitList.length,
            data: this.addedDisplayUnitList
          };
          this.appliedDisplayUnitType = response.data.appliedDisplayUnitType;

          this.formApplyTo.get('displayUnitControl').setValue(this.appliedDisplayUnit);
          this.formApplyTo.get('displayUnitTypeControl').setValue(this.appliedDisplayUnitType);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getSurveyQuestions(dcfid: any) {
    this.coreSession.ModalLoading.Show();
    this.surveyService.getSurveyQuestions(dcfid).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          (response.data, "questions");
          if (this.isCloneMode) {
            this.surveyObject.surveyId = -1;
            this.surveyObject.dcfid = -1;
            var questionValuesMap = new Map<number, number>();
            response.data.forEach(question => {
              var depQuestionId = questionValuesMap.get(question.dependentQuestion);
              questionValuesMap.set(question.fieldId, -1 * question.sequence - 1);
              question.fieldId = -1 * question.sequence - 1;
              question.dcfid = -1;
              question.dependentQuestion = depQuestionId ? depQuestionId : -1
              this.maxFieldIdForAdd = -1 * question.sequence - 1;
            });
          }
          this.addedQuestions = response.data;
          this.dataSource = {
            data: response.data,
            totalItems: response.data.length
          }
          this.formGeneral.get("numberOfQus").setValue(this.dataSource.totalItems);
          if (this.surveyTypeId != SurveyTypes.CustomerAppSurvey.valueOf())
            this.fillDependentQuestions(-1, false);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  onUpdateSurveySuccess(response: any) {
    this.coreSession.ModalLoading.Hide();
    if (response.status != null && response.status >= 0) {
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
        this.translateService.instant(response.message)
      );
      this.onSaveCompleted.emit();
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }

  onUpdateSurveyFailure(error: HttpErrorResponse) {
    this.coreSession.ModalLoading.Hide();
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
  }

  UpdateCustomerSurvey() {
    this.coreSession.ModalLoading.Show();
    if (this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf()) {
      this.employeeSurveyService.UpdateCustomerSurvey(this.surveyFullObject).subscribe(
        response => {
          this.onUpdateSurveySuccess(response);
        }, (error: HttpErrorResponse) => {
          this.onUpdateSurveyFailure(error);
        });
    } else if (this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()) {
      this.customerSurveyService.UpdateCustomerSurvey(this.surveyFullObject).subscribe(
        response => {
          this.onUpdateSurveySuccess(response);
        }, (error: HttpErrorResponse) => {
          this.onUpdateSurveyFailure(error);
        });
    } else if (this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf()) {
      this.customerAppSurveyService.UpdateCustomerSurvey(this.surveyFullObject).subscribe(
        response => {
          this.onUpdateSurveySuccess(response);
        }, (error: HttpErrorResponse) => {
          this.onUpdateSurveyFailure(error);
        });
    } else {
      this.surveyService.UpdateCustomerSurvey(this.surveyFullObject).subscribe(
        response => {
          this.onUpdateSurveySuccess(response);
        }, (error: HttpErrorResponse) => {
          this.onUpdateSurveyFailure(error);
        });
    }
  }

  onSaveSurveySuccess(response: any) {
    this.coreSession.ModalLoading.Hide();
    if (response.status != null && response.status >= 0) {
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
        this.translateService.instant(response.message),
      );
      this.onSaveCompleted.emit(response.data);
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }

  onSaveSurveyFailure(error: HttpErrorResponse) {
    this.coreSession.ModalLoading.Hide();
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
  }

  SaveCustomerSurvey() {
    this.coreSession.ModalLoading.Show();
    if (this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf()) {
      this.employeeSurveyService.SaveCustomerSurvey(this.surveyFullObject).subscribe(
        response => {
          this.onSaveSurveySuccess(response);
        }, (error: HttpErrorResponse) => {
          this.onSaveSurveyFailure(error);
        });
    } else if (this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()) {
      this.customerSurveyService.SaveCustomerSurvey(this.surveyFullObject).subscribe(
        response => {
          this.onSaveSurveySuccess(response);
        }, (error: HttpErrorResponse) => {
          this.onSaveSurveyFailure(error);
        });
    } else if (this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf()) {
      this.customerAppSurveyService.SaveCustomerSurvey(this.surveyFullObject).subscribe(
        response => {
          this.onSaveSurveySuccess(response);
        }, (error: HttpErrorResponse) => {
          this.onSaveSurveyFailure(error);
        });
    } else {
      this.surveyService.SaveCustomerSurvey(this.surveyFullObject).subscribe(
        response => {
          this.onSaveSurveySuccess(response);
        }, (error: HttpErrorResponse) => {
          this.onSaveSurveyFailure(error);
        });
    }
  }
  getSurveyMenusImages() {
    if (!this.imagesNames || (this.imagesNames && this.imagesNames.length == 0)) {
      this.coreSession.ModalLoading.Show();
      this.surveyService.getSurveyMenusImages().subscribe(
        response => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.imagesNames = response.data;
            this.imagesPaths = Array.from(this.imagesNames);
            if (this.imagesPaths && this.imagesPaths.length > 0) {
              this.imagesPaths.forEach((image, index) => {
                var currentPath = document.getElementsByTagName("base")[0].href + "Resources/survey-menus-img/" + image.path;
                this.imagesPaths[index].path = currentPath;
                this.imagesPaths[index].isChecked = false;
              });
            }
            if (this.isEditMode) {
              this.selectedIconName = this.surveyObject.imageId;
              if (this.selectedIconName != '')
                this.disableSaveDialog = false;
            }
            this.openDialog();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    }
    else {
      this.openDialog();
    }

  }
  saveSurveyMenuIcon() {
    this.selectedIconName = '';
    if (this.imagesPaths && this.imagesPaths.length > 0) {
      this.imagesPaths.forEach((image, i) => {
        if (image.isChecked)
          this.selectedIconName = this.imagesNames[i].imageName;
      });
    }
  }
  openDialog() {
    if (this.imagesPaths && this.imagesPaths.length > 0) {
      this.imagesPaths.forEach((image, index) => {
        image.isChecked = false;
      });
    }
    if (this.imagesNames && this.imagesNames.length > 0) {
      let index = -1;
      index = this.imagesNames.findIndex(image => image.imageName == this.selectedIconName);
      if (index != -1) {
        this.imagesPaths[index].isChecked = true;
      }
    }
    this.modalService.open(this.surveyIconDialog, { centered: true }).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          this.saveSurveyMenuIcon();
        }
      });
  }
  disableApplyToTab() {
    if (
      (this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf() && this.allCustomers && this.allSecurityGroups)
      || (this.surveyTypeId == SurveyTypes.CustomerAppSurvey && this.allCustomers)
      || (this.surveyTypeId == SurveyTypes.EmployeeSurvey && this.allEmployees && this.allSecurityGroups)
    )
      this.navLinks[2].disable = true;
    else
      this.navLinks[2].disable = false;
  }
  disableMustFillPeriod() {
    // if(this.forceFillingSurvey).
    if (this.formGeneral.value.forceFill === undefined || this.formGeneral.value.forceFill === null || this.formGeneral.value.forceFill.modeId == 0)
      this.navLinks[3].disable = true;
    else
      this.navLinks[3].disable = false;
  }
  onRowOperationForItems(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.onDeleteAppliedItems(event.object);
        break;
    }
  }

  onDeleteAppliedItems(deletedItem: any) {
    var index = this.addedItemsList.findIndex(x => x.itemId === deletedItem.itemId);
    if (index >= 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.addedItemsList.splice(index, 1);
            this.fillItemsList();
          }
        });
    }
  }

  fillItemsList() {
    this.itemsDataSource = {
      totalItems: this.addedItemsList.length,
      data: this.addedItemsList
    };
  }

  openSelectItemsDialog() {
    this.copyOfAddedItems = null;
    this.copyOfAddedItems = cloneDeep(this.addedItemsList);
    this.selectItemsDialog.showDialog(null).then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedItems(result)
        } else {
          this.closeSelectItemsDialog();
        }
      });
  }

  afterAddingSelectedItems(selectedItems) {

    this.addedItemsList = selectedItems;
    this.fillItemsList();
    this.closeSelectItemsDialog();
  }

  closeSelectItemsDialog() {
    if (this.isEditMode) {
      this.coreSession.SetTitle('Edit Item List');
    } else {
      this.coreSession.SetTitle('Add Item List');
    }
  }

  populateGroupsList() {

    this.allGroupsList = [];
    if (this.forceOrganizationFilterForCustomerGroups()) {
      if (this.organizationIdsString != null && this.organizationIdsString.trim() != "" && this.organizationIdsString.trim() != "-1") {
        this.customerService.getAllCustomerGroups('').subscribe(result => {
          this.allGroupsList = result.data;
          this.filterGroupsData();
        });
      }
    } else {
      this.customerService.getAllCustomerGroups('').subscribe(result => {
        this.allGroupsList = result.data;
        this.availableGroups = result.data;
      });
    }
  }


  populateChannelsSubChannelsList() {
    this.customerService.GetAllCustomerChannels(null).subscribe(result => {
      this.allChannelsList = result;
    });
  }


  fillCustomersList() {
    this.customersDataSource = {
      totalItems: this.addedCustomersList.length,
      data: this.addedCustomersList
    };
  }

  openSelectCustomersDialog() {
    this.formGeneral.get("organizationsList").markAsTouched();
    if (this.organizationsListControl.value <= 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.SelectOrganization));
      return;
    }

    this.copyOfAddedCustomers = null;
    this.copyOfAddedCustomers = cloneDeep(this.addedCustomersList);
    this.showSelectCustomersDialog = true;
    this.selectCustomerDialog.showDialog(this.organizationIdsString).then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedCustomers(result)
        } else {
          this.closeSelectCustomersDialog();
        }
      });
  }

  afterAddingSelectedCustomers(selectedCustomers) {
    this.addedCustomersList = selectedCustomers;
    this.fillCustomersList();
    this.closeSelectCustomersDialog();
  }

  closeSelectCustomersDialog() {
    this.showSelectCustomersDialog = false;
    if (this.isEditMode) {
      this.coreSession.SetTitle('Edit Item List');
    } else {
      this.coreSession.SetTitle('Add Item List');
    }
  }

  onMultiSelectionOperationForCustomers(event: any) {

    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        this.onDeleteSelectedAddedCustomers(event.object);
        break;
      }
    }
  }

  onDeleteSelectedAddedCustomers(selectedCustomersList) {

    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          selectedCustomersList.forEach(customer => {
            var index = this.addedCustomersList.findIndex(x => x.customerId === customer.customerId && x.outletId === customer.outletId);
            if (index >= 0) {
              this.addedCustomersList.splice(index, 1);
            }
          });
        }
        this.fillCustomersList();
      });
  }

  //#endregion

  //#region  Display Unit Dialog
  openDisplayUnitDialog() {
    this.copyOfAddeDisplayUnit = null;
    this.copyOfAddeDisplayUnit = cloneDeep(this.addedDisplayUnitList);
    this.showSelectDisplayUnitDialog = true;
    this.selectDisplayUnitDialog.showDisplayUnitDialog(null, this.organizationIdsString).then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedDisplayUnit(result)
        } else {
          this.closeSelectDisplayUnitDialog();
        }
      });
  }

  afterAddingSelectedDisplayUnit(selectedDisplayUnit) {
    this.addedDisplayUnitList = selectedDisplayUnit;
    this.fillDisplayUnitList();
    this.closeSelectDisplayUnitDialog();
  }

  closeSelectDisplayUnitDialog() {
    this.showSelectDisplayUnitDialog = false;
  }

  onRowOperationForDisplayUnit(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.onDeleteAppliedDisplayUnit(event.object);
        break;
    }
  }

  onDeleteAppliedDisplayUnit(deletedDisplayUnit: any) {
    var index = this.addedDisplayUnitList.findIndex(addedDisplayUnit => addedDisplayUnit.displayUnitID === deletedDisplayUnit.displayUnitID
      && addedDisplayUnit.serialNumber === deletedDisplayUnit.serialNumber);
    if (index >= 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.addedDisplayUnitList.splice(index, 1);
            this.fillDisplayUnitList();
          }
        });
    }
  }

  fillDisplayUnitList() {
    this.displayUnitDataSource = {
      totalItems: this.addedDisplayUnitList.length,
      data: this.addedDisplayUnitList
    };
  }


  //#endregion
  getForceFillingModeDescription(modeId: number) {
    switch (modeId) {
      case 0:
        return this.translateService.instant(ConstantMessages.LblNone);
      case 1:
        return this.translateService.instant(ConstantMessages.BeforVisit);

      case 2:
        return this.translateService.instant(ConstantMessages.AfterVisit);

    }
  }

  showQuestionDetail(fieldType): boolean {
    let result = false;
    if (fieldType && (fieldType.fieldSubTypeId === 11 || fieldType.fieldSubTypeId === 8)) {
      result = true;
      this.attachmentFieldLabel = fieldType.fieldSubTypeId === 11 ? 'Desc_Max_Number_Of_Attachments' : 'Desc_Max_Number_Of_Images';
    } else {
      this.attachmentFieldLabel = "";
    }
    return result;
  }

  showValidateDateToggle(fieldType): boolean {
    let result = false;
    if (fieldType && fieldType.fieldTypeId === 3 && fieldType.fieldSubTypeId === 1) {
      result = true;
    }
    return result;
  }

  setAllowDefineDynamicParameter(dependentQuestion): void {
    this.allowDefineDynamicParameter = false;
    if (dependentQuestion && dependentQuestion != undefined) {
      let isQuestionLOVQuery = false;
      let questionLOVId = -1;
      let questionObj = this.dataSource.data.find(addedQuestion => addedQuestion.fieldTypeID === dependentQuestion.fieldTypeId &&
        addedQuestion.questionName === dependentQuestion.name);

      if (questionObj) questionLOVId = questionObj.lovid;

      let lovObj = this.originalQuestionValuesList.find(value => value.id === questionLOVId);
      isQuestionLOVQuery = lovObj ? lovObj.isQuery : false;

      if (isQuestionLOVQuery &&
        (dependentQuestion.fieldTypeId === 5 || dependentQuestion.fieldTypeId === 6) &&
        this.formQuestions.get('fieldSubTypeID').value && this.formQuestions.get('fieldSubTypeID').value !== undefined &&
        (this.formQuestions.get('fieldSubTypeID').value.fieldTypeId === 5 || this.formQuestions.get('fieldSubTypeID').value.fieldTypeId === 6)) {
        this.allowDefineDynamicParameter = true;
      }
    }
  }

  onValidateDateDataChange() {
    this.formQuestions.get('questionDetailValue').setValue(null);
    this.formQuestions.get('questionDetailValue').setValidators(null);
    if (this.formQuestions.get('isValidateDateData').value) {
      this.formQuestions.get('questionDetailValue').setValidators(Validators.required);
    }
    this.formQuestions.get('questionDetailValue').updateValueAndValidity();
  }
}
