import { Component, OnInit, OnDestroy, Input, Output, EventEmitter } from '@angular/core';
import { Observable } from 'rxjs';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { SurveyService } from '../survey.service';

@Component({
  selector: 'app-field-group-entry',
  templateUrl: './field-group-entry.component.html',
  styleUrls: ['./field-group-entry.component.css']
})
export class FieldGroupEntryComponent implements OnInit, OnDestroy {
  @Input() saveEvent: Observable<void>;
  @Output() onAddingNewGroup = new EventEmitter();
  saveBtnSubscription: any;
  form: FormGroup;
  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private surveyService: SurveyService
  ) { }

  ngOnInit() {
    this.subscribeSaveClick();
    let group = "";
    this.form = new FormGroup({
      group: new FormControl(group, Validators.required)
    });
  }

  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.onSaveClicked();
    });
  }

  onSaveClicked() {
    let group = this.form.get("group").value;
    if (group != '') {
      this.coreSession.ModalLoading.Show();
      this.surveyService.saveGroup(group).subscribe(
        response => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
              this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
          this.onAddingNewGroup.emit(group);
        },
        error => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    } else {
      if (this.form.invalid) {
        this.form.get("group").markAsTouched();
      }
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
    }
  }

  ngOnDestroy(): void {
    this.saveBtnSubscription.unsubscribe();
  }
}
