import { query } from '@angular/animations';
import { HttpErrorResponse } from '@angular/common/http';
import { OnDestroy } from '@angular/core';
import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { stringify } from 'querystring';
import { Observable, Subject } from 'rxjs';
import { CoreSession } from '../../../../../core/core.session';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { GlobalErrors } from '../../../../../shared/models/enums/globalErrors';
import { RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { ITextInput } from '../../../../../shared/models/shared-table/custom-list.interface';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { CustomeMobileViewService } from '../../../custome-mobile-view/custome-mobile-view.service';
import { SurveyService } from '../../survey.service';
import { NgbModal, NgbModalConfig, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { TextLanguage } from '../../../../../shared/models/general/textLanguage.model';
import { ListOfValueService } from '../../../../../shared/services/data-definition/dynamic-form/list-of-value.service';


@Component({
  selector: 'app-list-of-values-entry',
  templateUrl: './list-of-values-entry.component.html',
  styleUrls: ['./list-of-values-entry.component.css']
})
export class ListOfValuesEntryComponent implements OnInit, OnDestroy {
  @Input() additionalParameter: string;

  formLOV: FormGroup;
  LOVNameInput: ITextInput = {
    formControlName: "LOVName",
    placeHolder: "Desc_LOV_Name",
    label: "Desc_LOV_Name",
    isRequierd: true
  };
  LOVDescriptionInput: ITextInput = {
    formControlName: "LOVDescription",
    placeHolder: "Desc_LOV_Description",
    label: "Desc_LOV_Description"
  };
  LOVOptionName: ITextInput = {
    formControlName: "LOVOptionName",
    placeHolder: "Desc_Option_Name",
    label: "Desc_Option_Name",
    isRequierd: true
  };
  LOVNameList: TextLanguage[] = []
  LOVDescriptionList: TextLanguage[] = []
  optionNameList: TextLanguage[] = []
  LOVOptionsTableProperties: ITableProperties = {
    pageSize: 25,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [{
      title: "Desc_Option_Name",
      key: "optionName",
      isSortable: true,
      width: "50%"
    }
      ,
    {
      title: "Desc_Option_Score",
      key: "optionScore",
      isSortable: false,
      width: "50%"
    }
    ]
  }
  LOVOptionList: any[] = [];
  LOVOptionDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  selectedOptionIndex: number = -1;
  LOVObject = {

    lovid: -1,
    lovName: [],
    lovDescription: [],
    lovQuery: '',
    lovOptionList: [],
    isDynamic: '',
    dynamicField: '',

  };
  @Output() onSaveCompleted = new EventEmitter();
  @Input() events: Observable<void>;

  @Input() LOVID: number = -1;
  @Input() ViewMode: boolean = false;
  saveBtnSubscription: any;
  addEditButton = 'Desc_Add'
  menu = document.querySelector('.menu') as HTMLElement;
  parametersList: any;
  forceQuery: boolean = false;
  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private customeMobileViewService: CustomeMobileViewService,
    private listOfValueService: ListOfValueService) { }

  ngOnInit() {
    if(this.additionalParameter && this.additionalParameter.trim() !== '') {
      this.forceQuery = true;
    }
    this.initForm();
    this.subscribeSaveClick();
    this.fillForm();
    this.getParametersList();
    this.addActions();
  }
  onOtherLanguagesTextSubmitted(event, textFrom: number = -1) {
    if (textFrom == 1)//LOV Name
    {
      this.LOVNameList = this.LOVNameList.filter(name => name.languageId !== event[0].languageId)
      this.LOVNameList.push({ description: event[0].description, languageId: event[0].languageId });
      return;
    }
    if (textFrom == 2)//LOV Description
    {
      this.LOVDescriptionList = this.LOVDescriptionList.filter(description => description.languageId !== event[0].languageId)
      this.LOVDescriptionList.push({ description: event[0].description, languageId: event[0].languageId });
      return;
    }
    if (textFrom == 3)//Option Name
    {
      this.optionNameList = this.optionNameList.filter(optionName => optionName.languageId !== event[0].languageId)
      this.optionNameList.push({ description: event[0].description, languageId: event[0].languageId });
      return;
    }
  }
  PrepareLOVOptionsListTableDataSource() {

    let optionNameByLanguageId: TextLanguage = new TextLanguage();
    let optionsData = []
    if (!this.LOVObject.lovOptionList || this.LOVObject.lovOptionList.length == 0)
      this.LOVObject.lovOptionList = this.LOVOptionList;
    for (let i = 0; i < this.LOVObject.lovOptionList.length; i++) {
      optionNameByLanguageId = this.LOVObject.lovOptionList[i].optionName.find(name => name.languageId == this.coreSession.selectedLanguageId);
      if (optionNameByLanguageId != undefined)//&& optionsFilterdByLanguageId.length > 0
        optionsData.push({
          optionName: optionNameByLanguageId.description,
          optionScore: this.LOVObject.lovOptionList[i].optionScore
        })
      else
        optionsData.push({
          optionName: '',
          optionScore: this.LOVObject.lovOptionList[i].optionScore
        })

    }

    this.LOVOptionDataSource = {
      totalItems: optionsData.length,
      data: optionsData
    };

  }
  fillForm() {

    if(this.forceQuery) {
      this.formLOV.get('isDynamic').setValue(true);
      this.formLOV.get('isDynamic').disable();
    }
    if (this.LOVID == -1) {
      return;
    }

    this.coreSession.ModalLoading.Show();
    //fill LOVObject from API with LOVID

    this.listOfValueService.getLOVByID(this.LOVID).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.additionalParameter = response && response.data && response.data.dynamicField && response.data.dynamicField.trim() != '' ?  response.data.dynamicField : '';
          if(this.additionalParameter != '') {
            this.getParametersList();
          }
          this.LOVObject = response.data;
          let LOVNameByLanguageId: TextLanguage = new TextLanguage();
          LOVNameByLanguageId = this.LOVObject.lovName.find(name => name.languageId == this.coreSession.selectedLanguageId)
          let LOVDescriptionByLanguageId: TextLanguage = new TextLanguage();
          LOVDescriptionByLanguageId = this.LOVObject.lovDescription.find(description => description.languageId == this.coreSession.selectedLanguageId)

          this.LOVDescriptionList = this.LOVObject.lovDescription//old values to language part
          this.LOVNameList = this.LOVObject.lovName//old values to language part
          if (LOVNameByLanguageId != undefined)//&& LOVNamesFilterdByLanguageId.length > 0
            this.formLOV.get('LOVName').setValue(LOVNameByLanguageId.description);
          if (LOVDescriptionByLanguageId != undefined)//&& LOVDescriptionsFilterdByLanguageId.length > 0
            this.formLOV.get('LOVDescription').setValue(LOVDescriptionByLanguageId.description);
          if (this.LOVObject.lovOptionList != null && this.LOVObject.lovOptionList.length > 0) {
            this.LOVOptionList = this.LOVObject.lovOptionList;
            this.PrepareLOVOptionsListTableDataSource();
          }

          this.formLOV.get('query').setValue(this.LOVObject.lovQuery);//if not empty
          this.formLOV.get('isDynamic').setValue(this.LOVObject.isDynamic);
          this.coreSession.ModalLoading.Hide();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );

    if (this.ViewMode)
      this.formLOV.disable()

  }
  addActions() {
    if (!this.ViewMode)
      this.LOVOptionsTableProperties.rowOperations.push(
        {
          operation: RowOperation.edit,
          title: "Desc_Edit",
          icon: "fa-regular fa-pen-to-square",
          color: "#12344d"
        }, {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      }
      )
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  onSaveClicked() {
    let query: String = this.formLOV.get('query').value;
    if (this.formLOV.get('LOVName').invalid) {
      this.formLOV.get('LOVName').markAsTouched();
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;

    }
    if (this.formLOV.get('isDynamic').value) {
      if (query == null || query == "") {
        this.formLOV.get('query').markAsTouched();
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
      this.coreSession.ModalLoading.Show();
      this.customeMobileViewService.testQuery(this.formLOV.get('query').value, 2, this.additionalParameter).subscribe(result => {

        if (result.data == GlobalErrors.Error) {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(result.message));

        } else if (result.data == GlobalErrors.NotInitialized) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(result.message));
        } else if (result.data == GlobalErrors.Success) {
          this.SaveLOV();
        }
        this.coreSession.ModalLoading.Hide();
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
    }
    else {
      if (this.LOVOptionList == null || this.LOVOptionList.length == 0) {
        this.formLOV.get('LOVOptionName').reset();
        this.formLOV.get('LOVOptionScore').reset();
        this.formLOV.get('LOVOptionName').markAsTouched();
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
      this.SaveLOV();
    }

  }
  SaveLOV() {
    this.LOVNameList = this.LOVNameList.filter(name => name.languageId !== this.coreSession.selectedLanguageId)
    this.LOVNameList.push({ description: this.formLOV.get('LOVName').value, languageId: this.coreSession.selectedLanguageId });
    this.LOVDescriptionList = this.LOVDescriptionList.filter(description => description.languageId !== this.coreSession.selectedLanguageId)
    this.LOVDescriptionList.push({ description: this.formLOV.get('LOVDescription').value, languageId: this.coreSession.selectedLanguageId });
    this.LOVObject.lovOptionList = []
    this.LOVObject =
    {
      lovid: this.LOVID,
      lovName: this.LOVNameList,
      lovDescription: this.LOVDescriptionList,
      lovQuery: this.formLOV.get('query').value,
      lovOptionList: this.LOVOptionList,
      isDynamic: this.formLOV.get('isDynamic').value,
      dynamicField: this.additionalParameter
    }
    this.coreSession.ModalLoading.Show();
    if (this.LOVObject.isDynamic)
      this.LOVObject.lovOptionList = [];
    else {
      this.LOVObject.lovQuery = ""
      this.LOVObject.lovOptionList.forEach(option => {
        if (option.optionScore == null)
          option.optionScore = 0
      });
    }

    this.listOfValueService.saveLOV(this.LOVObject, (this.LOVObject.lovid > -1)).subscribe(//in API check if LOVID == -1 then its new LOV (Add mode) else (Edit mode)
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          let savedLovId = -1;
          if(this.LOVObject.lovid > -1) {
            savedLovId = this.LOVObject.lovid
          } else {
            savedLovId = response.data;
          }
          this.coreSession.showSuccess(
            this.translateService.instant(response.message),
            ""
          );
          this.onSaveCompleted.emit(savedLovId);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });

  }
  initForm() {
    this.formLOV = new FormGroup({
      LOVName: new FormControl(null, Validators.required),
      LOVDescription: new FormControl(null),
      query: new FormControl(null, Validators.required),
      isDynamic: new FormControl(null),
      LOVOptionName: new FormControl(null, Validators.required),
      LOVOptionScore: new FormControl(null),
    });
    this.formLOV.get('isDynamic').setValue(false);
  }

  onRowOperation(event: any) {

    switch (event.operation) {
      case RowOperation.edit:
        this.formLOV.get('LOVOptionName').reset();
        this.formLOV.get('LOVOptionScore').reset();
        this.selectedOptionIndex = event.index;
        //  this.selectedOptionIndex = this.LOVOptionList.indexOf(event.object);
        this.formLOV.get('LOVOptionName').setValue(event.object.optionName);
        this.formLOV.get('LOVOptionScore').setValue(event.object.optionScore);
        //change add button text to edit
        this.addEditButton = 'Edit'

        this.optionNameList = this.LOVOptionList[this.selectedOptionIndex].optionName
        break;
      case RowOperation.delete:
        this.LOVOptionList.splice(event.index, 1);
        // this.LOVOptionList = this.LOVOptionList.filter(obj => obj !== event.object);
        this.PrepareLOVOptionsListTableDataSource();
        break;

    }
  }
  /*
  this.coreSession.markFormGroupTouched(this.formLOV as FormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
       */
  onAddEditOption() {
    if (this.formLOV.invalid) {
      if (this.formLOV.get('LOVOptionName').invalid) {
        this.formLOV.get('LOVOptionName').markAsTouched();
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
    }
    this.optionNameList = this.optionNameList.filter(name => name.languageId !== this.coreSession.selectedLanguageId)
    this.optionNameList.push(
      {
        description: this.formLOV.get('LOVOptionName').value,
        languageId: this.coreSession.selectedLanguageId
      }
    )

    if (this.selectedOptionIndex == -1) {
      this.LOVOptionList.push({
        id: -1,
        optionName: [],
        optionScore: this.formLOV.get('LOVOptionScore').value
      });
      for (let i = 0; i < this.optionNameList.length; i++) {
        this.LOVOptionList[this.LOVOptionList.length - 1].optionName.push(this.optionNameList[i])
      }
    }
    else {
      this.LOVOptionList[this.selectedOptionIndex].optionScore = this.formLOV.get('LOVOptionScore').value
      this.LOVOptionList[this.selectedOptionIndex].optionName = this.optionNameList

    }
    this.PrepareLOVOptionsListTableDataSource();
    this.formLOV.get('LOVOptionName').reset();
    this.formLOV.get('LOVOptionScore').reset();

    this.selectedOptionIndex = -1;
    this.addEditButton = 'Desc_Add'
    this.optionNameList = []
  }
  clear() {
    this.formLOV.get('LOVOptionName').reset();
    this.formLOV.get('LOVOptionScore').reset();
    this.selectedOptionIndex = -1;
    this.addEditButton = 'Desc_Add'
    this.optionNameList = []
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }

  onQueryRightClick(e: MouseEvent) {
    this.menu = document.querySelector('.menu') as HTMLElement;
    this.menu.style.visibility = "";
    const target = e.target as HTMLTextAreaElement;
    let container = target.getBoundingClientRect();
    let X = e.clientX - container.left;
    let Y = e.clientY - container.top;

    this.drawMenu(X, Y);

    e.preventDefault();
  }
  // Draw Menu
  drawMenu(mouseX, mouseY) {
    let menu = document.querySelector('.menu') as HTMLElement;
    this.menu = menu;
    menu.style.top = mouseY.toString() + 'px';
    menu.style.left = mouseX.toString() + 'px';
    menu.style.visibility = "visible";
  };
  getParametersList() {
    this.parametersList = []
    this.parametersList.push("@LanguageID")
    this.parametersList.push("@CustomerID")
    this.parametersList.push("@OutletID")
    this.parametersList.push("@CurrentDateTime")
    this.parametersList.push("@RouteHistoryID")
    this.parametersList.push("@NumberOfDigits")
    this.parametersList.push("@NumberOfStockDigits")
    this.parametersList.push("@EmployeeID")
    if(this.additionalParameter && this.additionalParameter.trim() != '')
      this.parametersList.push(this.additionalParameter)
    // this.customeMobileViewService.getParametersList().subscribe(
    //   response => {
    //     this.parametersList = response;
    //     this.parametersList=this.parametersList.filter((parameter:string)=>{parameter=="@LanguageID"})
    //   },
    //   (error: HttpErrorResponse) => {
    //     this.coreSession.ModalLoading.Hide();
    //     this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    //   });
  }
  onSelectItem(str: string) {
    let query = this.formLOV.get('query').value;
    if (query == '' || query == undefined) {
      query = str;
      this.formLOV.get('query').setValue(query);
    } else {
      let selectionStart = ((document.querySelector('.rightClickTextArea') as HTMLInputElement).selectionStart);
      let selectionEnd = ((document.querySelector('.rightClickTextArea') as HTMLInputElement).selectionEnd);
      let q = this.formLOV.get('query').value.slice(0, selectionStart) + str + this.formLOV.get('query').value.slice(selectionEnd);
      this.formLOV.get('query').setValue(q);
    }

    this.hideMenu();
  }
  hideMenu() {
    if((this.menu as HTMLElement))
      (this.menu as HTMLElement).style.visibility = "";
  };

}
