import { HttpErrorResponse } from '@angular/common/http';
import { Output } from '@angular/core';
import { Component, OnInit } from '@angular/core';
import { Validators } from '@angular/forms';
import { FormControl } from '@angular/forms';
import { FormGroup } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { Subject } from 'rxjs';
import { CoreSession } from '../../../../core/core.session';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { ITextInput } from '../../../../shared/models/shared-table/custom-list.interface';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { ListOfValueService } from '../../../../shared/services/data-definition/dynamic-form/list-of-value.service';
import { SurveyService } from '../survey.service';

@Component({
  selector: 'app-list-of-values-list',
  templateUrl: './list-of-values-list.component.html',
  styleUrls: ['./list-of-values-list.component.css']
})
export class ListOfValuesListComponent implements OnInit {

  LOVTableData: ITableProperties = {
    pageSize: 25,
    showPaginator: false,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: true,
    rowOperations: [
      {
        operation: RowOperation.View,
        title: 'Desc_View',
        icon: 'fa-regular fa-eye',
        color: "#12344d"
      }, {
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d",
        showWhenKeyValueTrue: true,
        showHideOptionPerLine: true,
        controlKeyName: 'AllowEdit'
      }, {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e",
        showWhenKeyValueTrue: true,
        showHideOptionPerLine: true,
        controlKeyName: 'AllowDelete'
      }

    ],
    multiSelectionOperations: [],
    columns: [{
      title: "Desc_LOV_Name",
      key: "name",
      isSortable: true,
      width: "30%"
    }
      ,
    {
      title: "Desc_LOV_Description",
      key: "description",
      isSortable: false,
      width: "70%"
    }
    ]
  }
  LOVDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  LOVs: any[] = [];
  showSlider: boolean = false;
  @Output() ViewMode = false;
  saveSubject: Subject<void> = new Subject<void>();
  @Output() LOVID = -1;
  headerString = 'Desc_Add_List_of_values'

  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private listOfValueService: ListOfValueService) { }

  ngOnInit() {
    this.coreSession.SetTitle('Desc_List_of_values');
    this.isAddAvailable();
    this.FillLOVs();
  }
  onAfterLOVSaved() {
    this.closeSlider();
    this.FillLOVs();
  }
  FillLOVs() {
    this.coreSession.ModalLoading.Show();
    this.listOfValueService.getLOVs().subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.LOVs = response.data;

          this.LOVDataSource = {
            data: response.data,
            totalItems: response.data.length
          }
          this.LOVDataSource.data.forEach((datum) => {
            if (datum.isUsed == 1) {
              datum.AllowEdit = false;
              datum.AllowDelete = false;
            }
            else {
              datum.AllowEdit = true;
              datum.AllowDelete = true;
            }
            if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.listOfValues, MenuActions.Delete))
              datum.AllowDelete = false;

            if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.listOfValues, MenuActions.Edit))
              datum.AllowEdit = false;
          })

        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  isAddAvailable() {
    this.LOVTableData.showNewBtn = this.coreSession.checkActivitiesAvailability(ConstantURLs.listOfValues, MenuActions.Add);
  }
  onNewBtnClicked() {
    this.LOVID = -1;
    this.ViewMode = false;
    this.showSlider = true;
  }
  closeSlider() {
    this.showSlider = false;
  }
  onSaveClick() {
    this.saveSubject.next();
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        this.headerString = 'Desc_Edit_List_of_values'
        this.LOVID = event.object.id;
        this.showSlider = true;
        this.ViewMode = false;
        break;
      case RowOperation.delete:
        this.coreSession.ModalLoading.Show();
        this.listOfValueService.deleteLOV(event.object.id).subscribe(
          response => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
              this.FillLOVs();
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            }
          },
          error => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
          }
        );
        break;
      case RowOperation.View:
        this.headerString = 'Desc_List_of_values'
        this.LOVID = event.object.id;
        this.showSlider = true;
        this.ViewMode = true;
        break;
    }
  }

}
