import { CoreSession } from "./../../../core/core.session";
import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Subject } from "rxjs";
import { map } from "rxjs/operators";
import { ResponseModel } from "../../../shared/models/api-models/api-models";
@Injectable({
  providedIn: 'root'
})
export class QualityControlReadingService {


  private url = "";
  constructor(private http: HttpClient, @Inject("BASE_URL") baseUrl: string) {
    this.url = baseUrl + "QualityControlReading";
  }

  getInspectorSurveys(filterModel: any) {
    const urlValue: string = this.url + "/GetInspectorSurveys";
    return this.http.post<ResponseModel>(urlValue, filterModel).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }

  getSurveyData(surveyId: number, dcfid: number, warehouseId: number, readingId: number, organizationId: number, isClone: boolean) {
    let filter = {
      surveyId: surveyId,
      dcfid: dcfid,
      warehouseId: warehouseId,
      readingId: readingId,
      organizationId: organizationId,
      isClone: isClone
    }
    const urlValue: string = this.url + '/GetSurveyData';
    return this.http.post<ResponseModel>(urlValue, filter)
      .map(
        (response) => {
          return response;
        }
      );
  }
  getSurveyQuestions(dCFID: number) {
    const urlValue: string = this.url + "/getSurveyQuestions";
    return this.http.post<ResponseModel>(urlValue, dCFID).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }

  saveQualityControlReading(surveyReadingModel: any) {
    const urlValue: string = this.url + "/InsertQualityControlReading";
    return this.http.post<ResponseModel>(urlValue, surveyReadingModel).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }
}
