import { Routes, RouterModule } from "@angular/router";
import { AuthGuard } from "../../../core/auth/auth.gurad";
import { NgModule } from "@angular/core";
import { ConstantURLs } from "../../../shared/models/constants/constant-URL";
import { CustomerSurveyListComponent } from "./customer-survey-list/customer-survey-list.component";
import { QualityControlListComponent } from "../quality-control-management/quality-control-list/quality-control-list.component";
import { CustomerAppSurveyListComponent } from "../../../echo/shared/components/customer-app-survey-list/customer-app-survey-list.component";
import { SurveyMainComponent } from "./survey-main/survey-main.component";
import { EmployeeSurveyListComponent } from "./employee-survey-list/employee-survey-list.component";
import { ListOfValuesListComponent } from "./list-of-values-list/list-of-values-list.component";

const SurveyManagmentRouting: Routes = [
    {
        path: "",
        canActivate: [AuthGuard],
        component: SurveyMainComponent,
        children: [
            {
                path: ConstantURLs.dynamicFormsURL,
                canActivate: [AuthGuard],
                component: CustomerSurveyListComponent,
            },
            {
                path: ConstantURLs.customerAppSurveysURL,
                canActivate: [AuthGuard],
                component: CustomerAppSurveyListComponent,
            },
            {
                path: ConstantURLs.employeeFormsURL,
                canActivate: [AuthGuard],
                component: EmployeeSurveyListComponent,
            },
            {
                path: ConstantURLs.listOfValues,
                canActivate: [AuthGuard],
                component: ListOfValuesListComponent,
            },
            {
                path: '',
                canActivate: [AuthGuard],
                redirectTo: '/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.dynamicFormMainURL + '/' + ConstantURLs.dynamicFormsURL,
                pathMatch: 'full'
            }
        ]
    }
];
@NgModule({
    imports: [RouterModule.forChild(SurveyManagmentRouting)],
    exports: [RouterModule]
})
export class SurveyManagmentRoutingModule {
}
