import { NgModule } from "@angular/core";
import { SharedModule } from "../../../shared/shared.module";
import { TranslateModule } from "@ngx-translate/core";
import { FormsModule, ReactiveFormsModule } from "@angular/forms";
import { CommonModule } from "@angular/common";
import { NgSelectModule } from "@ng-select/ng-select";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { SurveyMainComponent } from "./survey-main/survey-main.component";
import { CustomerSurveyListComponent } from "./customer-survey-list/customer-survey-list.component";
import { CustomerAppSurveyListComponent } from "../../../echo/shared/components/customer-app-survey-list/customer-app-survey-list.component";
import { QualityControlListComponent } from "../quality-control-management/quality-control-list/quality-control-list.component";
import { SurveyManagmentRoutingModule } from "./survey-managment-routing.module";
import { CustomerSurveyEntryComponent } from "./customer-survey/customer-survey-entry/customer-survey-entry.component";
import { SurveyModeListComponent } from "../survey-mode-list/survey-mode-list.component";
import { FieldGroupEntryComponent } from "./field-group-entry/field-group-entry.component";
import { EmployeeSurveyListComponent } from "./employee-survey-list/employee-survey-list.component";
import { ListOfValuesListComponent } from "./list-of-values-list/list-of-values-list.component";
import { ListOfValuesEntryComponent } from "./list-of-values-list/list-of-values-entry/list-of-values-entry.component";
import { NgbModalModule, NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";

@NgModule({
  declarations: [
    SurveyMainComponent,
    CustomerSurveyListComponent,
    QualityControlListComponent,
    EmployeeSurveyListComponent,
    CustomerAppSurveyListComponent,
    CustomerSurveyEntryComponent,
    SurveyModeListComponent,
    FieldGroupEntryComponent,
    ListOfValuesListComponent,
    ListOfValuesEntryComponent,
  ],
  imports: [
    NgSelectModule,
    CommonModule,
    SurveyManagmentRoutingModule,
    SharedModule,
    FormsModule,
    ReactiveFormsModule,
    NgMultiSelectDropDownModule,
    TranslateModule.forChild(),
    NgbModalModule,
    NgbModule,
    NgOptionHighlightModule,
  ],
  exports: [
    CustomerSurveyListComponent,
    CustomerSurveyEntryComponent,
    QualityControlListComponent,
    EmployeeSurveyListComponent,
    SurveyModeListComponent,
  ],
})
export class SurveyManagmentModule {}
