import { Component, OnInit, Input } from '@angular/core';
import { FormGroup, FormControl } from '@angular/forms';
import { Subject } from 'rxjs';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ItemPackModel } from '../../../shared/models/Item/item.model';
import { SurveyService } from '../survey-managment/survey.service';
import { CoreSession } from '../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { RowOperation } from '../../../shared/models/enums/shared-table-operation.enum';
import { MenuActions } from '../../../shared/models/enums/menu-actions-enum';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { IDateTimePickerProperties } from '../../../shared/models/dateTimeModel/date-time-properties.interface';
import { SurveyTypes } from '../../../shared/models/enums/survey-types.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { EmployeeSurveyService } from '../../../shared/services/data-definition/dynamic-form/employee-survey.service';
import { CustomerSurveyService } from '../../../shared/services/data-definition/dynamic-form/customer-survey.service';
import { CustomerAppSurveyService } from '../../../shared/services/data-definition/dynamic-form/customer-app-survey.service';

@Component({
  selector: 'app-survey-mode-list',
  templateUrl: './survey-mode-list.component.html',
  styleUrls: ['./survey-mode-list.component.css']
})
export class SurveyModeListComponent implements OnInit {

  surveyFilterForm: FormGroup;
  surveyFilter = {
    customListFilter: {
      searchFilter: "",
      page: 0,
      pageSize: 15
    },
    surveyName: "",
    includeInactive: false
  };

  saveSubject: Subject<void> = new Subject<void>();
  TabelData: ITableProperties = {
    pageSize: 16,
    showPaginator: false,
    showSearch: true,
    isOnline: false,
    showSearchBtn: true,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Form_Name",
        key: "surveyName",
        isSortable: true,
        width: "20%"
      },
      {
        title: "Desc_Valid_From",
        key: "validFrom",
        isSortable: false,
        width: "20%",
        // isDate: true,
        isExpiryDate: true
      },
      {
        title: "Desc_Valid_To",
        key: "validTo",
        isSortable: false,
        width: "20%",
        // isDate: true,
        isExpiryDate: true
      },
      {
        title: "Desc_Survey_Sequence",
        key: "surveySequence",
        isSortable: true,
        width: "20%"
      },
      {
        title: "Desc_Vendor",
        key: "organizationCodeName",
        isSortable: false,
        width: "20%"
      }
    ]
  };

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  query: any = {

  };
  selectedItemId = -1;
  isMinimized = false;
  showSlider = false;
  isFilterOpend = false;
  surveyObject: ItemPackModel;
  validToDate: any;
  menuURL: string = '';

  @Input() surveyTypeId: number;
  isClone: boolean = false;
  constructor(
    private surveyService: SurveyService,
    private employeeSurveyService: EmployeeSurveyService,
    private customerSurveyService: CustomerSurveyService,
    private customerAppSurveyService: CustomerAppSurveyService,
    private coreSession: CoreSession,
    private translateService: TranslateService
  ) { }

  ngOnInit() {
    (this.query.surveyTypeId =
      this.surveyTypeId),
      (this.query, "query");
    if (this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()) {
      this.menuURL = ConstantURLs.dynamicFormsURL;
      //this.coreSession.SetTitle('Dynamic Form');
    } else if (this.surveyTypeId == SurveyTypes.QualityControl.valueOf()) {
      this.menuURL = ConstantURLs.qcDefinitionURL;
      //this.coreSession.SetTitle('Quality Control');
    }
    else if (this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf()) {
      this.menuURL = ConstantURLs.customerAppSurveysURL;
      //this.coreSession.SetTitle('Dynamic Form');
    }
    else if (this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf()) {
      this.menuURL = ConstantURLs.employeeFormsURL;
      //this.coreSession.SetTitle('Employee Form');
    }
    else if (this.surveyTypeId == SurveyTypes.POSSurvey.valueOf()) {
      this.menuURL = ConstantURLs.displayUnitSurveyURL;
      //this.coreSession.SetTitle('Display Unit Survey');
    }
    else if (this.surveyTypeId == SurveyTypes.POSStockCounting.valueOf()) {
      this.menuURL = ConstantURLs.displayUnitSurveyStockCountingURL;
      //this.coreSession.SetTitle('Display Unit Survey Stock Counting');
    }
    this.getAllCustomerSurveys();
    this.addActions();
    this.isAddAvailable();
    this.initForm();
  }

  initForm() {
    this.surveyFilterForm = new FormGroup({
      surveyName: new FormControl(""),
      includeInactive: new FormControl(false),
      toDate: new FormControl(),
    });
  }
  addActions() {
    if (this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.Delete)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.delete,
          title: "Desc_Delete",
          icon: "fa-solid fa-trash",
          color: "#f1685e"
        });
    }
    if (this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.Edit)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      });
    }
    if (this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.Clone)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.Clone,
        title: 'Desc_Clone',
        icon: 'fa fa-clone',
        color: '#12344d'
      });
    }
  }
  isAddAvailable() {
    this.TabelData.showNewBtn = this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.Add);
  }

  getAllCustomerSurveys() {
    ("getSurvey");
    this.coreSession.ModalLoading.Show();
    this.surveyService.getAllCustomerSurveys(this.query).subscribe(
      response => {
        (response.data, "Surveys");
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = {
            data: response.data,
            totalItems: response.data.length
          }
          if (this.isClone) {
            var maxSurveyId = Math.max.apply(Math, this.dataSource.data.map(function (o) { return o.surveyId; }));
            if (maxSurveyId != -1 && this.dataSource.data != null && this.dataSource.data.length > 0) {
              let indexId = this.dataSource.data.findIndex(x => x.surveyId == maxSurveyId);
              this.surveyObject = this.dataSource.data[indexId];
              this.showSlider = true;
              this.isClone = false;
            }
          }
        } else {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }
      , (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        if (this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.Edit)) {
          if (event.object.assignedToPromotion && event.object.startedPromotion) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Cannot_Edit_Used_Survey'));
            return;
          }
          else {
            this.showSlider = true;
            this.selectedItemId = event.object.itemId;
            this.surveyObject = event.object;
          }
        }
        break;
      case RowOperation.delete:
        if (event.object.assignedToPromotion) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Cannot_Delete_Used_Survey'));
          return;
        }
        else {
          this.AllowToDeleteSurvey(event.object);
        }
        break;
      case RowOperation.Clone:
        this.cloneSurvey(event.object);
        break;
    }
  }

  onDeleteSuccess(response: any){
    this.coreSession.ModalLoading.Hide();
    if (response.status != null && response.status >= 0) {
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
        this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
      this.getAllCustomerSurveys();
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }

  onDeleteFailure(error: any){
    this.coreSession.ModalLoading.Hide();
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),
      this.translateService.instant(ConstantMessages.ErrorHappened));
  }

  AllowToDeleteSurvey(survey: any) {
    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(ConstantMessages.MsgDeleteConfirmation),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.Delete)
    ).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {
        this.coreSession.ModalLoading.Show();
        if(this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf()){
          this.employeeSurveyService.DeleteSurvey(survey.surveyId, survey.dcfid, survey.surveyTypeId, survey.linkedToProm).subscribe(
            response => {
              this.onDeleteSuccess(response);
            },
            error => {
              this.onDeleteFailure(error);
            }
          );
        }else if(this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()){
          this.customerSurveyService.DeleteSurvey(survey.surveyId, survey.dcfid, survey.surveyTypeId, survey.linkedToProm).subscribe(
            response => {
              this.onDeleteSuccess(response);
            },
            error => {
              this.onDeleteFailure(error);
            }
          );
        }else if(this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf()){
          this.customerAppSurveyService.DeleteSurvey(survey.surveyId, survey.dcfid, survey.surveyTypeId, survey.linkedToProm).subscribe(
            response => {
              this.onDeleteSuccess(response);
            },
            error => {
              this.onDeleteFailure(error);
            }
          );
        }else{
          this.surveyService.DeleteSurvey(survey.surveyId, survey.dcfid, survey.surveyTypeId, survey.linkedToProm).subscribe(
            response => {
              this.onDeleteSuccess(response);
            },
            error => {
              this.onDeleteFailure(error);
            }
          );
        }
      }
    });
  }

  onExecuteCloneSurveyProcedureSuccess(response: any){
    this.coreSession.ModalLoading.Hide();
    if (response.status != null && response.status >= 0) {
      this.isClone = true;
      this.getAllCustomerSurveys();
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }

  onExecuteCloneSurveyProcedureFailure(error: any){
    this.coreSession.ModalLoading.Hide();
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
  }

  cloneSurvey(survey: any) {
    this.isClone = true;
    this.showSlider = true;
    this.selectedItemId = survey.itemId;
    this.surveyObject = survey;
  }
  // cloneSurvey(surveyId: number) {
  //   this.isClone = false;
  //   this.coreSession.ModalLoading.Show();
  //   if(this.surveyTypeId == SurveyTypes.EmployeeSurvey.valueOf()){
  //     this.employeeSurveyService.executeCloneSurveyProcedure(surveyId).subscribe(
  //       response => {
  //         this.onExecuteCloneSurveyProcedureSuccess(response);
  //       },
  //       error => {
  //         this.onExecuteCloneSurveyProcedureFailure(error);
  //       }
  //     );
  //   }else if(this.surveyTypeId == SurveyTypes.CustomerSurvey.valueOf()){
  //     this.customerSurveyService.executeCloneSurveyProcedure(surveyId).subscribe(
  //       response => {
  //         this.onExecuteCloneSurveyProcedureSuccess(response);
  //       },
  //       error => {
  //         this.onExecuteCloneSurveyProcedureFailure(error);
  //       }
  //     );
  //   }else if(this.surveyTypeId == SurveyTypes.CustomerAppSurvey.valueOf()){
  //     this.customerAppSurveyService.executeCloneSurveyProcedure(surveyId).subscribe(
  //       response => {
  //         this.onExecuteCloneSurveyProcedureSuccess(response);
  //       },
  //       error => {
  //         this.onExecuteCloneSurveyProcedureFailure(error);
  //       }
  //     );
  //   }else{
  //     this.surveyService.executeCloneSurveyProcedure(surveyId).subscribe(
  //       response => {
  //         this.onExecuteCloneSurveyProcedureSuccess(response);
  //       },
  //       error => {
  //         this.onExecuteCloneSurveyProcedureFailure(error);
  //       }
  //     );
  //   }
  // }
  onMinimized() {
    this.isMinimized = !this.isMinimized;
  }

  onNewBtnClicked() {
    this.surveyObject = undefined;
    this.selectedItemId = -1;
    this.showSlider = true;
  }

  closeSlider() {
    this.showSlider = false;
    this.isClone = false;
  }

  openFilter() {
    this.isFilterOpend = !this.isFilterOpend;
    this.isMinimized = true;
  }

  openEditItem(object: any) {
    this.surveyObject = object;
    this.showSlider = true;
  }

  onSaveClick() {
    this.saveSubject.next();
  }

  onSurveySaved() {
    this.closeSlider();
    this.getAllCustomerSurveys();
  }

  onTableFilterChanged(query: any) {
    this.query.customListFilter = query;
    this.getAllCustomerSurveys();
  }

  ValidToDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Valid_To',
    formControlName: 'toDate',
    isCalendarOnly: true
  };

  onToDateSelected(date) {
    this.validToDate = date;
  }

  ApplySerachFilterOnFind() {

    (this.query.surveyName =
      this.surveyFilterForm.get("surveyName").value == null
        ? ""
        : this.surveyFilterForm.get("surveyName").value),
      (this.query.validTo =
        this.validToDate == null || this.validToDate == undefined
          ? null
          : this.validToDate.date),
      (this.query.active =
        this.surveyFilterForm.get("includeInactive").value == null ||
          this.surveyFilterForm.get("includeInactive").value == undefined
          ? false
          : this.surveyFilterForm.get("includeInactive").value);
    (this.query.surveyTypeId =
      this.surveyTypeId),
      (this.query, "query");
    this.getAllCustomerSurveys();
  }

  onReset() {
    this.surveyFilterForm.get("surveyName").reset();
    this.surveyFilterForm.get("includeInactive").reset();
    this.surveyFilterForm.get("toDate").reset();
    this.validToDate = null;
  }

}
