import { GeolocationService } from './../../../../shared/services/geolocation.service';
import { Component, OnInit, OnChanges, Input, Output, EventEmitter, OnDestroy } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { CoreSession } from '../../../../core/core.session';
import { MasterDataService } from '../../master-data.service';
import { DateTimeModel } from '../../../../shared/models/dateTimeModel/date-time.model';
import { IDateTimePickerProperties } from '../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { WarehouseTypes } from '../../../../shared/models/enums/warehouse-types.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { Observable } from 'rxjs';
import { TranslateService } from '@ngx-translate/core';
import { ITextInput } from '../../../../shared/models/shared-table/custom-list.interface';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { VehicleService } from '../../../../shared/services/data-definition/warehouse-and-vehicle/vehicle.service';

@Component({
  selector: 'app-vehicle-entry',
  templateUrl: './vehicle-entry.component.html',
  styleUrls: ['./vehicle-entry.component.css']
})
export class VehicleEntryComponent implements OnInit, OnDestroy {

  saveBtnSubscription: any;
  @Input() saveEvent: Observable<void>;
  @Input() isEditMode: boolean = false;
  @Output() onAddingVehicleEvent = new EventEmitter();

  navLinks: any[];
  showBasicData: boolean = false;
  showWarehousesData: boolean = false;
  showVehicleAccount: boolean = false;
  selectedCurrencyId: number = -1;

  @Input() openedFromEmployeeScreen: boolean = false;

  vehicleId: number = -1;
  @Input() vehicleObject: any = null;

  @Input() organizationId: number;
  isOrganizationLoading: boolean = false;
  organizationsList: any[] = [];
  streetsList: any[] = [];

  // employeeId : number;
  // isEmployeeLoading : boolean = false;
  // employeesList : any [] = [];

  isVehicleTypesLoading: boolean = false;
  isStreetLoading:boolean=false;
  vehicleTypesList: any[] = [];

  otherWarehouseLanguages: any[] = [];
  otherVehicleAccountLanguages: any[] = [];
  vehicleNameInput: ITextInput = {
    formControlName: 'vehicleName',
    placeHolder: 'Desc_Vehicle_Name',
    label: 'Desc_Vehicle_Name',
    isRequierd: true
  };


  isLoadingWarehousesLoading: boolean = false;
  allLoadingWarehousesList: any[] = [];
  loadingWarehousesDropdownSettings = {
    singleSelection: false,
    idField: 'warehouseId',
    textField: 'warehouseNameCode',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };

  isDamagedWarehousesLoading: boolean = false;
  allDamagedWarehousesList: any[] = [];
  damagedWarehousesDropdownSettings = {
    singleSelection: false,
    idField: 'warehouseId',
    textField: 'warehouseNameCode',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };

  isOffloadWarehousesLoading: boolean = false;
  allOffloadWarehousesList: any[] = [];
  OffloadWarehousesDropdownSettings = {
    singleSelection: false,
    idField: 'warehouseId',
    textField: 'warehouseNameCode',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };

  licenseExpiryDate: DateTimeModel = new DateTimeModel();
  licenseExpiryDateProperties: IDateTimePickerProperties = {
    label: 'Desc_License_Expiry_Date',
    formControlName: 'licenseExpiryDate',
    isCalendarOnly: true,
  };

  warrantyExpiryDate: DateTimeModel = new DateTimeModel();
  warrantyExpiryDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Warranty_Expiry_Date',
    formControlName: 'warrantyExpiryDate',
    isCalendarOnly: true,
  };
  showBarcodeTemplateData: boolean = false;
  vehicleDetailsForm: FormGroup;

  constructor(
    private coreSession: CoreSession,
    private masterDataService: MasterDataService,
    private vehicleService: VehicleService,
    private translateService: TranslateService,
    private sessionData: SessionDataProvider,
    private locationService: GeolocationService) {
  }

  ngOnInit() {
    this.loadingWarehousesDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.loadingWarehousesDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.loadingWarehousesDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.OffloadWarehousesDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.OffloadWarehousesDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.OffloadWarehousesDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.damagedWarehousesDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.damagedWarehousesDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.damagedWarehousesDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.subscribeSaveClick();
    this.prepareNavigation();
    if (!this.isEditMode) {
      this.coreSession.SetTitle('Add Vehicle');
      this.fillVehicleObjectInAddMode();

    } else {
      this.coreSession.SetTitle('Edit Vehicle');
      this.vehicleId = this.vehicleObject.vehicleId;
      this.organizationId = this.vehicleObject.organizationId;
    }
    this.showBarcodeTemplateData = (this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyGS1TrackAndTraceTemplate).toLowerCase() === "true");
    this.initForm();
    // this.fillEmployeesList();
    this.fillVehicleTypesList();
    this.fillStreetList();
    // in this cases org id willl filled so we can get the warehouses
    if (this.isEditMode || this.openedFromEmployeeScreen) {
      this.fillLoadingWarehousesList();
      this.fillDamagedWarehousesList();
      this.fillOffloadWarehousesList();
    }
    this.navLinks[0].isActive = true;
    this.showBasicData = true;

    if (this.linkVehicleToAccount() && this.isEditMode) {
      this.vehicleDetailsForm.get('creditLimit').setValue(this.vehicleObject.creditLimit > 0 ? this.vehicleObject.creditLimit : 0);
      //this.vehicleDetailsForm.get('balance').setValue(this.vehicleObject.balance > 0 ? this.vehicleObject.balance : 0);
      this.vehicleDetailsForm.get('currencyId').setValue(this.vehicleObject.currencyId);

    }
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }

  fillVehicleObjectInAddMode() {
    this.vehicleObject = {
      vehicleId: -1,
      warehouseId: -1,
      vehicleTypeId: null,
      organizationId: null,
      vehicleName: null,
      vehicleCode: null,
      plateNo: null,
      loadMinQty: null,
      odometer: null,
      capacityAmount: null,
      capacityVolume: null,
      capacityQuantity: null,
      barcode: null,
      trailerNumber: null,
      isNew: !this.isEditMode,
      inactive: false,
      employeeId: -1,
      accountId: -1,
      // warrantyExpiry : this.warrantyExpiryDate,
      // licenseExpiry : this.licenseExpiryDate,
      descriptionLanguages: [],
      loadingWarehouses: [],
      damagedWarehouses: [],
      offloadWarehouses: [],
      defaultLoadingWarehouseId: null,
      defaultOffloadingWarehouseId: null,
      gln: null,
      streetId: null,
    }
    if (this.openedFromEmployeeScreen) {
      this.vehicleObject.organizationId = this.organizationId;
    }
  }
  initForm() {
    this.vehicleDetailsForm = new FormGroup({
      vehicleName: new FormControl(this.vehicleObject.vehicleName, Validators.required),
      vehicleCode: new FormControl(this.vehicleObject.vehicleCode, Validators.required),
      plateNo: new FormControl(this.vehicleObject.plateNo, Validators.required),
      barcode: new FormControl(this.vehicleObject.barcode),
      vehicleTypeId: new FormControl(this.vehicleObject.vehicleTypeId, Validators.required),
      organizationId: new FormControl({ value: this.openedFromEmployeeScreen ? this.organizationId : this.vehicleObject.organizationId, disabled: this.openedFromEmployeeScreen }, Validators.required),
      trailerNumber: new FormControl(this.vehicleObject.trailerNumber),
      odometer: new FormControl(this.vehicleObject.odometer),
      capacityQuantity: new FormControl(this.vehicleObject.capacityQuantity),
      capacityAmount: new FormControl(this.vehicleObject.capacityAmount),
      capacityVolume: new FormControl(this.vehicleObject.capacityVolume),
      loadMinQty: new FormControl(this.vehicleObject.loadMinQty),
      loadingWarehouses: new FormControl(this.vehicleObject.loadingWarehouses),
      damagedWarehouses: new FormControl(this.vehicleObject.damagedWarehouses),
      offloadWarehouses: new FormControl(this.vehicleObject.offloadWarehouses),
      giai: new FormControl(this.vehicleObject.gln),
      defaultLoadingWarehouseId: new FormControl(this.vehicleObject.defaultLoadingWarehouseId === -1 ? null : this.vehicleObject.defaultLoadingWarehouseId),
      defaultOffloadingWarehouseId: new FormControl(this.vehicleObject.defaultOffloadingWarehouseId === -1 ? null : this.vehicleObject.defaultOffloadingWarehouseId),
      inactive: new FormControl(this.vehicleObject.inactive),
      currencyId: new FormControl(null, this.linkVehicleToAccount() ? Validators.required : null),
      creditLimit: new FormControl(0, this.linkVehicleToAccount() ? Validators.required : null),
      streetId: new FormControl(this.vehicleObject.streetId === -1 ? null : this.vehicleObject.streetId)
      //balance : new FormControl({ value: 0, disabled: true },),
      // warrantyExpiryDate: new FormControl(this.vehicleObject.warrantyExpiryDate),
      // licenseExpiryDate: new FormControl(this.vehicleObject.licenseExpiryDate),
      // employeeId :new FormControl(this.employeeId),
    })
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Vehicle_Definition',
        icon: 'fa fa-shopping-cart',
        index: 0,
        isActive: false
      },
      {
        label: 'Desc_Warehouses',
        icon: 'fa fa-address-card',
        index: 1,
        isActive: false
      }
    ];

    if (this.linkVehicleToAccount())
      this.navLinks.push({ label: this.translateService.instant(ConstantMessages.Account), icon: 'fa fa-address-card', index: 2, isActive: false });
  }
  showEntrySection(selectedIndex: number) {
    if (selectedIndex > 0) {
      this.vehicleDetailsForm.get('organizationId').markAsTouched();
      if (this.vehicleDetailsForm.get('organizationId').invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
    }
    this.clearSelection();
    if (selectedIndex == 0) {
      this.showBasicData = true;
    } else if (selectedIndex == 1) {
      this.showWarehousesData = true;
    } else if (selectedIndex == 2) {
      this.showVehicleAccount = true;
    }
    this.navLinks[selectedIndex].isActive = true;
  }
  clearSelection() {
    this.showBasicData = false;
    this.showWarehousesData = false;
    this.showVehicleAccount = false;
    this.navLinks.forEach(a => a.isActive = false);
  }
  fillLoadingWarehousesList() {
    this.isLoadingWarehousesLoading = true;
    let loadingWarehousesFilter = {
      divisionId: -1,
      organizationId: this.vehicleDetailsForm.controls.organizationId ? this.vehicleDetailsForm.controls.organizationId.value : -1,
      warehouseTypeId: WarehouseTypes.Warehouse.valueOf(),
      employeeId: -1
    }
    this.allLoadingWarehousesList = [];
    this.vehicleService.getVehicleAvailableWarehousesToAdd(loadingWarehousesFilter).subscribe(
      (result) => {
        this.allLoadingWarehousesList = result;
        this.isLoadingWarehousesLoading = false;
      });
  }
  fillDamagedWarehousesList() {
    this.isDamagedWarehousesLoading = true;
    let damagedWarehousesFilter = {
      divisionId: -1,
      organizationId: this.vehicleDetailsForm.controls.organizationId ? this.vehicleDetailsForm.controls.organizationId.value : -1,
      warehouseTypeId: WarehouseTypes.DealerWarehouse.valueOf(),
      employeeId: -1
    }
    this.allDamagedWarehousesList = [];
    this.vehicleService.getVehicleAvailableWarehousesToAdd(damagedWarehousesFilter).subscribe(
      (result) => {
        this.allDamagedWarehousesList = result;
        this.isDamagedWarehousesLoading = false;
      });
  }
  fillOffloadWarehousesList() {
    this.isOffloadWarehousesLoading = true;
    let offloadWarehousesFilter = {
      divisionId: -1,
      organizationId: this.vehicleDetailsForm.controls.organizationId ? this.vehicleDetailsForm.controls.organizationId.value : -1,
      warehouseTypeId: WarehouseTypes.Warehouse.valueOf(),
      employeeId: -1
    }
    this.allOffloadWarehousesList = [];
    this.vehicleService.getVehicleAvailableWarehousesToAdd(offloadWarehousesFilter).subscribe(
      (result) => {
        this.allOffloadWarehousesList = result;
        this.isOffloadWarehousesLoading = false;
      });
  }
  // fillEmployeesList(){
  //   if(!this.openedFromEmployeeScreen){
  //     this.employeesList = [];
  //     this.isEmployeeLoading = true;
  //     this.employeeService.getALLEmployee().subscribe(result => {
  //       this.employeesList = result;
  //       this.isEmployeeLoading = false;
  //     });
  //   }
  // }
  fillVehicleTypesList() {
    this.vehicleTypesList = [];
    this.isVehicleTypesLoading = true;
    this.vehicleService.getVehicleTypes().subscribe(result => {
      this.vehicleTypesList = result;
      this.isVehicleTypesLoading = false;
    });
  }

  fillStreetList(removeSelected: boolean = false) {
    this.coreSession.ModalLoading.Show();
    this.locationService.GetStreets(-1,-1,-1,-1).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.streetsList = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  onDeSelectAllLoadingWarehouses() {
    this.vehicleDetailsForm.get('defaultLoadingWarehouseId').reset();
  }
  onDeSelectOneLoadingWarehouse(selectedWarehouse) {
    if (selectedWarehouse && this.vehicleDetailsForm.value.defaultLoadingWarehouseId && this.vehicleDetailsForm.value.defaultLoadingWarehouseId === selectedWarehouse.warehouseId) {
      this.vehicleDetailsForm.get('defaultLoadingWarehouseId').reset();
    }
  }
  onDeSelectAllOffloadingWarehouses() {
    this.vehicleDetailsForm.get('defaultOffloadingWarehouseId').reset();
  }
  onDeSelectOneOffloadingWarehouse(selectedWarehouse) {
    if (selectedWarehouse && this.vehicleDetailsForm.value.defaultOffloadingWarehouseId && this.vehicleDetailsForm.value.defaultOffloadingWarehouseId === selectedWarehouse.warehouseId) {
      this.vehicleDetailsForm.get('defaultOffloadingWarehouseId').reset();
    }
  }
  onOtherLanguagesTextSubmitted(event) {
    this.otherWarehouseLanguages = event;
  }

  onChangeOrganization(selectedOrganization) {
    this.allLoadingWarehousesList = [];
    this.allOffloadWarehousesList = [];
    this.allDamagedWarehousesList = [];
    this.vehicleDetailsForm.get('defaultLoadingWarehouseId').reset();
    this.vehicleDetailsForm.get('defaultOffloadingWarehouseId').reset();
    this.vehicleDetailsForm.get('loadingWarehouses').reset();
    this.vehicleDetailsForm.get('offloadWarehouses').reset();
    this.vehicleDetailsForm.get('damagedWarehouses').reset();
    if (this.linkVehicleToAccount()) {
      this.vehicleDetailsForm.get('currencyId').setValue(null);
    }

    if (selectedOrganization && selectedOrganization.organizationId) {
      this.fillLoadingWarehousesList();
      this.fillOffloadWarehousesList();
      this.fillDamagedWarehousesList();
    }
  }
  fillVehicleObject() {
    if (!this.isEditMode) {
      this.vehicleObject.vehicleId = -1;
      this.vehicleObject.warehouseId = -1;
    } else {
      this.vehicleObject.warehouseId = this.vehicleObject.vehicleId;
    }
    this.vehicleObject.vehicleName = this.vehicleDetailsForm.get('vehicleName').value;
    this.vehicleObject.vehicleCode = this.vehicleDetailsForm.get('vehicleCode').value;
    this.vehicleObject.vehicleTypeId = this.vehicleDetailsForm.get('vehicleTypeId').value;
    this.vehicleObject.barcode = this.vehicleDetailsForm.get('barcode').value ? this.vehicleDetailsForm.get('barcode').value : '';
    this.vehicleObject.plateNo = this.vehicleDetailsForm.get('plateNo').value;
    if (!this.openedFromEmployeeScreen) {
      this.vehicleObject.organizationId = this.vehicleDetailsForm.get('organizationId').value;
    } else {
      this.vehicleObject.organizationId = this.organizationId;
    }
    this.vehicleObject.loadMinQty = this.vehicleDetailsForm.get('loadMinQty').value ? +this.vehicleDetailsForm.get('loadMinQty').value : 0;
    this.vehicleObject.odometer = this.vehicleDetailsForm.get('odometer').value ? +this.vehicleDetailsForm.get('odometer').value : 0;
    this.vehicleObject.capacityAmount = this.vehicleDetailsForm.get('capacityAmount').value ? +this.vehicleDetailsForm.get('capacityAmount').value : 0;
    this.vehicleObject.capacityVolume = this.vehicleDetailsForm.get('capacityVolume').value ? +this.vehicleDetailsForm.get('capacityVolume').value : 0;
    this.vehicleObject.capacityQuantity = this.vehicleDetailsForm.get('capacityQuantity').value ? +this.vehicleDetailsForm.get('capacityQuantity').value : 0;
    this.vehicleObject.trailerNumber = this.vehicleDetailsForm.get('trailerNumber').value ? this.vehicleDetailsForm.get('trailerNumber').value : '';
    this.vehicleObject.defaultLoadingWarehouseId = this.vehicleDetailsForm.get('defaultLoadingWarehouseId').value ? this.vehicleDetailsForm.get('defaultLoadingWarehouseId').value : -1;
    this.vehicleObject.defaultOffloadingWarehouseId = this.vehicleDetailsForm.get('defaultOffloadingWarehouseId').value ? this.vehicleDetailsForm.get('defaultOffloadingWarehouseId').value : -1;
    this.vehicleObject.loadingWarehouses = this.vehicleDetailsForm.get('loadingWarehouses').value ? this.vehicleDetailsForm.get('loadingWarehouses').value : [];
    this.vehicleObject.offloadWarehouses = this.vehicleDetailsForm.get('offloadWarehouses').value ? this.vehicleDetailsForm.get('offloadWarehouses').value : [];
    this.vehicleObject.damagedWarehouses = this.vehicleDetailsForm.get('damagedWarehouses').value ? this.vehicleDetailsForm.get('damagedWarehouses').value : [];
    this.vehicleObject.isNew = !this.isEditMode;
    this.vehicleObject.inactive = this.vehicleDetailsForm.get('inactive').value ? this.vehicleDetailsForm.get('inactive').value : false;
    this.vehicleObject.gln = this.vehicleDetailsForm.get('giai').value ? this.vehicleDetailsForm.get('giai').value : '';
    this.vehicleObject.streetId = this.vehicleDetailsForm.get('streetId') && this.vehicleDetailsForm.get('streetId').value ? this.vehicleDetailsForm.get('streetId').value : -1;
    let descriptions = this.otherWarehouseLanguages;
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.vehicleDetailsForm.get('vehicleName').value
      });
    }
    this.vehicleObject.descriptionLanguages = descriptions;
    //Account
    if (this.linkVehicleToAccount()) {
      this.vehicleObject.currencyId = this.vehicleDetailsForm.get('currencyId').value != null ? this.vehicleDetailsForm.get('currencyId').value : -1;
      this.vehicleObject.creditLimit = this.vehicleDetailsForm.get('creditLimit').value != '' ? +this.vehicleDetailsForm.get('creditLimit').value : 0;
      //this.vehicleObject.balance = this.vehicleDetailsForm.get('balance').value != '' ? +this.vehicleDetailsForm.get('balance').value : 0;
    } else {
      this.vehicleObject.currencyId = -1;
      this.vehicleObject.creditLimit = 0;
      //this.vehicleObject.balance = 0;
    }



    // this.employeeId = this.vehicleDetailsForm.get('employeeId').value;
    // this.accountId = this.vehicleDetailsForm.get('accountId').value;
    // this.vehicleObject.warrantyExpiryDate = this.vehicleDetailsForm.get('warrantyExpiryDate').value;
    // this.vehicleObject.licenseExpiryDate = this.vehicleDetailsForm.get('licenseExpiryDate').value;
  }
  onAddEditVehicle() {
    this.coreSession.markFormGroupTouched(this.vehicleDetailsForm);
    if (this.vehicleDetailsForm.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    // Validate Code
    let codeFilter = {
      tableName: 'Warehouse',
      columnName: 'WarehouseCode',
      insertedValue: this.vehicleDetailsForm.value.vehicleCode,
      excludedString: ' And WarehouseId != ' + this.vehicleObject.vehicleId,
    }
    this.coreSession.ModalLoading.Show();
    this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if (!response.data) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
        }
        else {
          this.fillVehicleObject();
          this.saveVehicleDB();
        }
      }
      else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }
  saveVehicleDB() {
    this.coreSession.ModalLoading.Show();
    this.vehicleService.saveVehicle(this.vehicleObject, this.isEditMode).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
        this.vehicleId = response.data;
        this.vehicleObject.vehicleId = this.vehicleId;
        var result = {
          vehicleId: this.vehicleId,
          inactive: this.vehicleObject.inactive
        };
        this.onAddingVehicleEvent.emit(result);
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.onAddEditVehicle();
    });
  }


  linkVehicleToAccount() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.LinkVehicleToAccount).toLowerCase() === "true";
  }

  applyCurrencyPerOrganization() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyCurrencyPerOrganization).toLowerCase() === "true";
  }
}
