import { Component, OnInit, OnChanges, Input, Output, EventEmitter, OnDestroy } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { CoreSession } from '../../../../core/core.session';
import { MasterDataService } from '../../master-data.service';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { Observable } from 'rxjs';
import { TranslateService } from '@ngx-translate/core';
import { WarehouseService } from '../../../../shared/services/data-definition/warehouse-and-vehicle/warehouse.service';
import { ITextInput } from '../../../../shared/models/shared-table/custom-list.interface';
import { ItemService } from '../../../../shared/services/data-definition/product/item.service';
import { WarehouseTypes } from '../../../../shared/models/enums/warehouse-types.enum';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { EmployeeService } from '../../../employee/employee.service';
import { EmployeeTypes } from '../../../../shared/models/enums/employee-types.enum';
import { ItemCategoryService } from '../../../../shared/services/data-definition/product/item-category.service';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { MultiSelectionOperation, RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { CommonButtonStyles } from '../../../../shared/models/enums/common-button-styles.enum';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
@Component({
  selector: 'app-warehouse-entry',
  templateUrl: './warehouse-entry.component.html',
  styleUrls: ['./warehouse-entry.component.css']
})
export class WarehouseEntryComponent implements OnInit, OnDestroy {

  @Input() saveEvent: Observable<void>;
  @Input() isEditMode: boolean = false;
  @Input() warehouseObject: any = null;
  @Input() addedWarehouseAlternatives: any[] = []; 
  @Input() availableWarehouseAlternatives: any[] = [];
  @Output() onAddingWarehouseEvent = new EventEmitter();
  isTruckTypeSelected: boolean = false;
  warehouses: any[] = null;
  storeKeepers: any[] = null;
  employeeTypes: EmployeeTypes[] = [EmployeeTypes.StoreKeeper];
  employeeFilter = {
    employeeTypes: EmployeeTypes.Employee,//must be store keeper
    hasTerritories: false,
    hasVehicles: false,
    routeId: -1,
    regionId: -1,
    channelId: -1,
    filterOnRoute: false,
    isAllEmployeesFieldAvailable: false,
    customerId: -1,
    outletId: -1
  }; warehouseFilter: any = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    warehouseTypeId: -1,
    organizationId: -1
  };

  warehouseId: number = -1;
  warehouseEntryForm: FormGroup;
  saveBtnSubscription: any;
  selectedStreet = -1;
  selectedArea = -1;
  selectedCity = -1;
  selectedCountry = -1;
  selectedState = -1;

  otherWarehouseLanguages: any[] = [];
  warehouseNameInput: ITextInput = {
    formControlName: 'warehouseName',
    placeHolder: 'Desc_Warehouse_Name',
    label: 'Desc_Warehouse_Name'
  };
  otherAddressLanguages: any[] = [];
  addressInput: ITextInput = {
    formControlName: 'address',
    placeHolder: 'Desc_Address',
    label: 'Desc_Address'
  };
  categoryList: any[] = [];
  categoryDropdownSettings = {
    singleSelection: false,
    idField: 'itemCategoryId',
    textField: 'categoryNameCode',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4,
  };
  destinationDropdownSettings = {
    singleSelection: false,
    idField: 'warehouseId',
    textField: 'warehouseNameCode',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 1,
  };
  storeKeeperDropdownSettings = {
    singleSelection: false,
    idField: 'employeeId',
    textField: 'employeeCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 2,
  };
  disableType = false;
  disableOrg= false;
  excludeTrucks = false;
  showBarcodeTemplateData: boolean = false;

  navLinks: any[] = [];
  navBarSelectedIndex: number = -1;

  //#region [Warehouse Alternatives]
  allowSelectAlternativeWarehouseInFO: boolean = false;
  availableWarehousesDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  addedWarehousesDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  availableWarehousesTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: true,
    rowOperations: [
      {
        operation: RowOperation.add,
        title: "Desc_Add",
        icon: "fa fa-arrow-right",
        color: "#66bb6d",
      }
    ],
    multiSelectionOperations: [
      // {
      //   operation: MultiSelectionOperation.add,
      //   title: "Desc_Add",
      //   icon: "fa fa-plus-square-o",
      //   color: "#66bb6d",
      // }
    ],
    columns: [
      {
        title: "Desc_Warehouse",
        key: "warehouseNameCode",
        isSortable: false,
        width: "100%"
      }
    ]
  };

  addedWarehousesTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: true,
    isAllowDragDrop: true,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa fa-trash-o',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [
      // {
      //   operation: MultiSelectionOperation.delete,
      //   title: 'Desc_Delete',
      //   icon: 'fa fa-close',
      //   color: '#f1685e',
      //   style: CommonButtonStyles.Negative.valueOf()
      // }
    ],
    columns: [
      {
        title: "Desc_Warehouse",
        key: "warehouseNameCode",
        isSortable: false,
        width: "50%"
      },
      {
        title: "Desc_Sequence",
        key: "sequenceNumber",
        isSortable: false,
        width: "50%"
      }
    ]
  };

  selectedOrganizationId: number = -1;
  selectedWarehouseTypeId: number = -1;
  //#endregion
  constructor(
    private coreSession: CoreSession,
    private warehouseService: WarehouseService,
    private translateService: TranslateService,
    private masterDataService: MasterDataService,
    private itemService: ItemService,
    private itemCategoryService: ItemCategoryService,
    private sessionData: SessionDataProvider) {
  }
  ngOnInit() {
    this.allowSelectAlternativeWarehouseInFO = 
      this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSelectAlternativeWarehouseInFO).toLowerCase() === "true";

    this.getWarhouses();
    if (!this.isEditMode) {
      this.coreSession.SetTitle('Add Warehouse');
      this.warehouseObject = {
        warehouseId: -1,
        destinations: null,
        sources: null,
        warehouseName: null,
        warehouseCode: null,
        barcode: null,
        gLN: null,
        warehouseTypeId: null,
        organizationId: null,
        phone: null,
        fax: null,
        gpsLatitude: null,
        gpsLongitude: null,
        itemCategories: [],
        descriptionLanguages: [],
        addressLanguages: [],
        isNew: !this.isEditMode,
        validToChangeToTruck: true,
        validToChangeFromTruck: true,
        inactive: false,
        areaId: null,
        cityId: null,
        stateId: null,
        countryId: null,
        streetId: null,
        zipCode: null,
        address: null,
        companyPrefix: null
      };
    } else {
      this.warehouseId = this.warehouseObject.warehouseId;
      this.coreSession.SetTitle('Edit Warehouse');

      if (this.isEditMode && !this.warehouseObject.allowEditOrganization) {
        this.disableOrg = true;
      }

      if (this.isEditMode && this.warehouseObject.warehouseTypeId === WarehouseTypes.TruckWarehouse && !this.warehouseObject.validToChangeFromTruck) {
        this.disableType = true;

      }
      if(this.warehouseObject.warehouseTypeId === WarehouseTypes.TruckWarehouse.valueOf()){
        this.isTruckTypeSelected = true;
      }else{
        this.isTruckTypeSelected = false;
      }
      this.otherAddressLanguages = this.warehouseObject.addressLanguages;
      this.otherWarehouseLanguages = this.warehouseObject.descriptionLanguages;

      this.selectedOrganizationId = this.warehouseObject.organizationId;
      this.selectedWarehouseTypeId = this.warehouseObject.warehouseTypeId;
    }

    this.subscribeSaveClick();
    this.fillItemCategory();
    this.categoryDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.categoryDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.categoryDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.destinationDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.destinationDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.destinationDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);

    this.showBarcodeTemplateData = (this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyGS1TrackAndTraceTemplate).toLowerCase() === "true");
    this.initForm();
    this.prepareNavigation();
    if(this.isEditMode && this.allowSelectAlternativeWarehouseInFO) {
      this.addedWarehousesDataSource = {
        data: this.addedWarehouseAlternatives,
        totalItems: this.addedWarehouseAlternatives.length
      };
      this.availableWarehousesDataSource = {
        data: this.availableWarehouseAlternatives,
        totalItems: this.availableWarehouseAlternatives.length
      };
    }

  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  excludeTruckType() {
    if (this.isEditMode && this.warehouseObject.warehouseTypeId != WarehouseTypes.TruckWarehouse.valueOf() && !this.warehouseObject.validToChangeToTruck) {
      return true;
    } else {
      return false;
    }
  }
  isWarehouseType() {
    if (this.warehouseEntryForm.value.warehouseTypeId && this.warehouseEntryForm.value.warehouseTypeId === WarehouseTypes.VirualWarehouse.valueOf()) {
      return false;
    } else {
      return true;
    }
  }
  showCategories() {
    var showCategory = this.sessionData.getConfigurationValue(ConstantConfigurations.LinkItemsToWarehouse).toLowerCase() === "true";
    if (this.isWarehouseType() && showCategory) {
      return true;
    } else {
      return false;
    }
  }

  getWarhouses() {
    this.warehouseFilter.vehicleId = -1;

    this.warehouseService.getWarehouses(this.warehouseFilter).subscribe(response => {



      this.warehouses = response;
      if (this.isEditMode && response != null) {
        this.warehouses = this.warehouses.filter(obj => obj.warehouseId !== this.warehouseObject.warehouseId);


      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });


  }
  initForm() {
    this.warehouseEntryForm = new FormGroup({
      warehouseName: new FormControl(this.warehouseObject.warehouseName, Validators.required),
      warehouseCode: new FormControl(this.warehouseObject.warehouseCode, Validators.required),
      barcode: new FormControl(this.warehouseObject.barcode),
      gln: new FormControl(this.warehouseObject.gln),
      zipCode: new FormControl(this.warehouseObject.zipCode),
      address: new FormControl(this.warehouseObject.address),
      warehouseTypeId: new FormControl({ value: this.warehouseObject.warehouseTypeId, disabled: this.disableType }, Validators.required),
      organizationId: new FormControl({value: this.warehouseObject.organizationId, disabled: this.disableOrg}, Validators.required),
      phone: new FormControl(this.warehouseObject.phone),
      fax: new FormControl(this.warehouseObject.fax),
      gpsLatitude: new FormControl(this.warehouseObject.gpsLatitude),
      gpsLongitude: new FormControl(this.warehouseObject.gpsLongitude),
      itemCategories: new FormControl(this.warehouseObject.itemCategories),
      country: new FormControl(this.warehouseObject.countryId === -1 ? null : this.warehouseObject.countryId),
      state: new FormControl(this.warehouseObject.stateId === -1 ? null : this.warehouseObject.stateId),
      city: new FormControl(this.warehouseObject.cityId === -1 ? null : this.warehouseObject.cityId),
      area: new FormControl(this.warehouseObject.areaId === -1 ? null : this.warehouseObject.areaId),
      street: new FormControl(this.warehouseObject.streetId === -1 ? null : this.warehouseObject.streetId)
      , destinations: new FormControl(this.warehouseObject.destinations)
      , sources: new FormControl(this.warehouseObject.sources)
      , employeeControl: new FormControl(this.warehouseObject.storeKeepers),
      companyPrefix: new FormControl(this.warehouseObject.companyPrefix >= 0 ? this.warehouseObject.companyPrefix : null)
    })
  }
  onOtherLanguagesTextSubmitted(event) {
    this.otherWarehouseLanguages = event;
  }
  onOtherAddressLanguagesTextSubmitted(event) {
    this.otherAddressLanguages = event;
  }

  fillItemCategory() {
    this.itemCategoryService.getAllCategories(-1).subscribe(result => {
      this.categoryList = result.data;
    });
  }
  //  fillDriversList() {
  //   this.isDriverLoading = true;
  //   this.driversList = [];
  //   let driverFilter = {
  //     employeeId : this.employeeId,
  //     organizationId : this.organizationId,
  //     employeeType : EmployeeTypes.Driver
  //   }
  //   this.employeeService.getNotConnectedHelpersOrDrivers(driverFilter).subscribe(result => {
  //   this.driversList = result;
  //   this.isDriverLoading = false;
  // });
  // }
  onAddEditWarehouse() {
    this.coreSession.markFormGroupTouched(this.warehouseEntryForm);
    if (this.warehouseEntryForm.invalid) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    let codeFilter = {
      tableName: 'Warehouse',
      columnName: 'WarehouseCode',
      insertedValue: this.warehouseEntryForm.value.warehouseCode,
      excludedString: ' And WarehouseId != ' + this.warehouseId,
    }
    // Validate Code
    this.coreSession.ModalLoading.Show();
    this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if (!response.data) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
        }
        else {
          this.fillWarehouseObject();
          this.saveWarehouseToDB();
        }
      }
      else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  fillWarehouseObject() {
    if (!this.isEditMode) {
      this.warehouseId = -1;
    }
    this.warehouseObject.warehouseId = this.warehouseId,
      this.warehouseObject.warehouseName = this.warehouseEntryForm.value.warehouseName;
    this.warehouseObject.warehouseCode = this.warehouseEntryForm.value.warehouseCode;
    if (!this.disableType) {
      this.warehouseObject.warehouseTypeId = this.warehouseEntryForm.value.warehouseTypeId;
    }
    this.warehouseObject.organizationId = this.warehouseEntryForm.value.organizationId;
    this.warehouseObject.barcode = this.warehouseEntryForm.value.barcode ? this.warehouseEntryForm.value.barcode : '';
    this.warehouseObject.address = this.warehouseEntryForm.value.address ? this.warehouseEntryForm.value.address : '';
    this.warehouseObject.zipCode = this.warehouseEntryForm.value.zipCode ? this.warehouseEntryForm.value.zipCode : '';
    this.warehouseObject.gLN = this.warehouseEntryForm.value.gln ? this.warehouseEntryForm.value.gln : '';
    this.warehouseObject.phone = this.warehouseEntryForm.value.phone ? this.warehouseEntryForm.value.phone : '';
    this.warehouseObject.fax = this.warehouseEntryForm.value.fax ? this.warehouseEntryForm.value.fax : '';
    this.warehouseObject.gpsLatitude = this.warehouseEntryForm.value.gpsLatitude ? this.warehouseEntryForm.value.gpsLatitude : 0;
    this.warehouseObject.gpsLongitude = this.warehouseEntryForm.value.gpsLongitude ? this.warehouseEntryForm.value.gpsLongitude : 0;
    this.warehouseObject.itemCategories = this.warehouseEntryForm.value.itemCategories ? this.warehouseEntryForm.value.itemCategories : [];
    this.warehouseObject.destinations = this.warehouseEntryForm.value.destinations ? this.warehouseEntryForm.value.destinations : [];
    this.warehouseObject.sources = this.warehouseEntryForm.value.sources ? this.warehouseEntryForm.value.sources : [];
    this.warehouseObject.storeKeepers = this.warehouseEntryForm.value.employeeControl ? this.warehouseEntryForm.value.employeeControl : [];

    this.warehouseObject.isNew = !this.isEditMode;

    let descriptions = this.otherWarehouseLanguages;
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.warehouseEntryForm.value.warehouseName
      });
    }

    let addressDescriptions = this.otherAddressLanguages;
    if (addressDescriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      addressDescriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.warehouseEntryForm.value.address
      });


      this.warehouseObject.addressLanguages = addressDescriptions;
      this.warehouseObject.descriptionLanguages = descriptions;
      this.warehouseObject.areaId = this.selectedArea != null ? this.selectedArea : -1;
      this.warehouseObject.cityId = this.selectedCity != null ? this.selectedCity : -1;
      this.warehouseObject.stateId = this.selectedState != null ? this.selectedState : -1;
      this.warehouseObject.countryId = this.selectedCountry != null ? this.selectedCountry : -1;
      this.warehouseObject.streetId = this.selectedStreet != null ? this.selectedStreet : -1;
    }

    if(this.allowSelectAlternativeWarehouseInFO && this.isMainWarehouse()) {
      this.warehouseObject.warehouseAlternatives = this.addedWarehousesDataSource && this.addedWarehousesDataSource.data ? this.addedWarehousesDataSource.data : [];
    }
    this.warehouseObject.companyPrefix = this.warehouseEntryForm.value.companyPrefix != null && this.warehouseEntryForm.value.companyPrefix != "" ? +this.warehouseEntryForm.value.companyPrefix  : -1 ; 
  }

  saveWarehouseToDB() {

    this.coreSession.ModalLoading.Show();
    this.warehouseService.saveWarehouse(this.warehouseObject, this.isEditMode).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
        this.onAddingWarehouseEvent.emit();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.onAddEditWarehouse();
    });
  }
  getGeoLocation(data: any) {
    this.selectedArea = data.areaID;
    this.selectedCity = data.cityID;
    this.selectedState = data.stateID;
    this.selectedCountry = data.countryID;
    this.selectedStreet = data.streetID;
  }

  onWarehouseTypeSelected(event: any) {
    if(this.allowSelectAlternativeWarehouseInFO && this.isMainWarehouse() && this.isThereAddedAlternativeWHs()) {
      this.warehouseEntryForm.get("warehouseTypeId").markAsTouched();
      this.coreSession.ModalDialog.ShowMessage(
        this.translateService.instant(ConstantMessages.MsgChangeWarehouseTypeWithAlternativeWarehouses),
         DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
         .then((res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.clearAvailableWarehouses();
            this.clearAddedWarehouses();
            this.afterChangeWarehouseType(event);
          } else {
            this.warehouseEntryForm.get("warehouseTypeId").setValue(this.selectedWarehouseTypeId);
          }
        });
    } else {
      this.afterChangeWarehouseType(event);
    }
  }

  afterChangeWarehouseType(event) {
    this.selectedWarehouseTypeId = event && event.warehouseTypeId && event.warehouseTypeId > -1 ? event.warehouseTypeId : -1;
    this.navLinks[1].hidden = !(event && event.warehouseTypeId && event.warehouseTypeId > -1 && event.warehouseTypeId === WarehouseTypes.Warehouse.valueOf() && this.allowSelectAlternativeWarehouseInFO);

    if(event && event != undefined && this.isMainWarehouse() && this.allowSelectAlternativeWarehouseInFO && this.selectedOrganizationId > 0) {
      this.getAvailableAlternativeWarehouses(-1);
    }
    if(event && event.warehouseTypeId && event.warehouseTypeId > -1 && event.warehouseTypeId === WarehouseTypes.TruckWarehouse.valueOf()){
      this.isTruckTypeSelected = true;
    }else{
      this.isTruckTypeSelected = false;
    }
  }
  
  prepareNavigation() {
    this.navLinks = [
      {
        label: this.isEditMode ? 'Desc_Edit_Warehouse' : 'Desc_Add_Warehouse',
        index: 0,
        isActive: false,
        hidden: false
      },
      {
        label: 'Desc_Warehouse_Alternatives',
        index: 1,
        isActive: false,
        hidden: this.warehouseObject.warehouseTypeId !== WarehouseTypes.Warehouse.valueOf(),
      },
    ];
    this.navBarSelectedIndex = 0;
    this.navLinks[0].isActive = true;
  }

  onChangeDataView(index: number) {
    if(this.allowSelectAlternativeWarehouseInFO && index === 1 &&
      (!this.warehouseEntryForm.get('organizationId').value || this.warehouseEntryForm.get('organizationId').value < 0)) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
    }

    this.navLinks.forEach(a => a.isActive = false);
    this.navBarSelectedIndex = index;
    this.navLinks[index].isActive = true;
  }

  onSelectOrganization(organization: any) {
    if(this.allowSelectAlternativeWarehouseInFO && this.isMainWarehouse() && this.isThereAddedAlternativeWHs()) {
      this.warehouseEntryForm.get("organizationId").markAsTouched();
      this.coreSession.ModalDialog.ShowMessage(
        this.translateService.instant(ConstantMessages.MsgChangeWarehouseTypeWithAlternativeWarehouses),
         DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
         .then((res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.clearAvailableWarehouses();
            this.clearAddedWarehouses();
            this.afterChangeOrganization(organization);
          } else {
            this.warehouseEntryForm.get("organizationId").setValue(this.selectedOrganizationId);
          }
        });
    } else {
      this.afterChangeOrganization(organization);
    }
  }

  afterChangeOrganization(organization: any) {
    this.selectedOrganizationId = -1;
    if(organization && organization != undefined) {
      this.selectedOrganizationId = organization.organizationId;
      if(this.allowSelectAlternativeWarehouseInFO) {
        this.getAvailableAlternativeWarehouses(-1);
      }
    }
  }

  isMainWarehouse() {
    return this.selectedWarehouseTypeId === WarehouseTypes.Warehouse.valueOf();
  }

  //#region [Alternative warehouses]

  isThereAddedAlternativeWHs() {
    return this.addedWarehousesDataSource && this.addedWarehousesDataSource.data && this.addedWarehousesDataSource.data.length > 0;
  }

  getAvailableAlternativeWarehouses(warehouseId: number = this.isEditMode ? this.warehouseObject.warehouseId : -1) {
    var warehouseFilter = {
      warehouseId: warehouseId,
      excludedWarehouseId: this.isEditMode ? this.warehouseObject.warehouseId : -1,
      organizationId: this.warehouseEntryForm.get('organizationId').value ? this.warehouseEntryForm.get('organizationId').value : -1,
    };
    this.warehouseService.getAvailableAlternativeWarehouses(warehouseFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if(response && response.status != null && response.status >= 0) {
        if(response.data) {
          this.availableWarehousesDataSource = {
            data: response.data,
            totalItems: response.data.length
          };
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }

  getAddedAlternativeWarehouses() {
    var warehouseFilter = {
      warehouseId: this.isEditMode ? this.warehouseObject.warehouseId : -1,
      organizationId: this.warehouseEntryForm.get('organizationId').value ? this.warehouseEntryForm.get('organizationId').value : -1,
    };
    this.warehouseService.getAddedAlternativeWarehouses(warehouseFilter).subscribe(response => {
      if(response && response.status != null && response.status >= 0) {
        if(response.data) {
          this.addedWarehousesDataSource = {
            data: response.data,
            totalItems: response.data.length
          };
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }

  addWarehouseToAlternatives(warehouse: any) {
    warehouse.isChecked = false
    var maxSequence = this.addedWarehousesDataSource.data ?  
      this.addedWarehousesDataSource.data.length + 1 : 1;
    
    warehouse.sequenceNumber = maxSequence;

    var data = this.addedWarehousesDataSource.data;
    data.push(warehouse);
    this.addedWarehousesDataSource = {
      data: data,
      totalItems: data.length
    };
  }

  removeWarehouseFromAvailableList(warehouse: any) {
    var idx = this.availableWarehousesDataSource.data.findIndex(wh => wh.warehouseId === warehouse.warehouseId);
    if(idx !== -1) {
      var data = this.availableWarehousesDataSource.data;
      data.splice(idx,1);
      this.availableWarehousesDataSource = {
        data: data,
        totalItems: data.length,
      };
    }
  }

  addWarehousesToAlternatives(warehouses:any[]) {
    var maxSequence = this.addedWarehousesDataSource.data ?  
      this.addedWarehousesDataSource.data.length + 1 : 1;

    warehouses.forEach(wh => {
      wh.sequenceNumber = maxSequence++;
      wh.isChecked = false;
    });

    var addedWarehouses = this.addedWarehousesDataSource.data;
    addedWarehouses = addedWarehouses.concat(warehouses);

    this.addedWarehousesDataSource = {
      data: addedWarehouses,
      totalItems: addedWarehouses.length
    };
  }

  removeWarehousesFromAvailableList(warehouses:any[]) {
    var avlWarehouses = this.availableWarehousesDataSource.data;
    avlWarehouses = avlWarehouses.filter(wh => !warehouses.map(el => el.warehouseId).includes(wh.warehouseId));
    this.availableWarehousesDataSource = {
      data: avlWarehouses,
      totalItems: avlWarehouses.length
    };
  }

  removeWarehouseFromAlternatives(warehouse: any) {
    var addedWarehouses = this.addedWarehousesDataSource.data;
    var idx = addedWarehouses.findIndex(addedWh => addedWh.warehouseId === warehouse.warehouseId);
    if(idx > -1) {
      addedWarehouses.splice(idx,1);
      for(var i = idx; i < addedWarehouses.length; i++) {
        addedWarehouses[i].sequenceNumber = i + 1;
      }

      this.addedWarehousesDataSource = {
        data: addedWarehouses,
        totalItems: addedWarehouses.length
      };
    }
    warehouse.sequenceNumber = -1;
  }

  removeWarehousesFromAlternatives(warehouses: any[]) {
    var whWithMinimumSequence = warehouses.reduce(function(prev, current) {
      return (prev.sequenceNumber > current.sequenceNumber) ? current : prev});
    
    var addedWarehouses = this.addedWarehousesDataSource.data;
    var idx = addedWarehouses.findIndex(wh => wh.warehouseId === whWithMinimumSequence.warehouseId);
    
    var toBeDeletedWHIds = warehouses.map(el => el.warehouseId);
    addedWarehouses = addedWarehouses.filter(addedWh => !toBeDeletedWHIds.includes(addedWh.warehouseId));

    for(var i = idx; i < addedWarehouses.length; i++) {
      addedWarehouses[i].sequenceNumber = i + 1;
    }

    this.addedWarehousesDataSource = {
      data: addedWarehouses,
      totalItems: addedWarehouses.length
    };
  }

  addWarehousesToAvailableWarehouseList(warehouses:any[]) {
    warehouses.forEach(wh => {
      wh.isChecked = false;
      wh.sequenceNumber = -1;
    });

    var availableWarehouses = this.availableWarehousesDataSource.data;
    availableWarehouses = availableWarehouses.concat(warehouses);
    this.availableWarehousesDataSource = {
      data: availableWarehouses,
      totalItems: availableWarehouses.length
    };
  }

  addWarehouseToAvailableWarehouseList(warehouse: any) {
    warehouse.isChecked = false;
    var availableWarehouses = this.availableWarehousesDataSource.data;
    availableWarehouses.push(warehouse);
    this.availableWarehousesDataSource = {
      data: availableWarehouses,
      totalItems: availableWarehouses.length
    };
  }

  onAvailableWarehousesRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.add:
        if(event && event.object) {
          var warehouse = event.object;
          // remove from available warehouse alternatives
          this.removeWarehouseFromAvailableList(warehouse);
          // add to added warehouse alternatives
          this.addWarehouseToAlternatives(warehouse);
        }
        break;
    }
  }

  onAddedWarehousesRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        // remove warehouse from added alternative warehouses.
        this.removeWarehouseFromAlternatives(event.object);
        // add warehouse to available alternative warehouses.
        this.addWarehouseToAvailableWarehouseList(event.object);
        break;
    }
  }

  onDropRow(event) {
    var addedWarehouses = this.addedWarehousesDataSource.data;
    for(var i = 0; i < addedWarehouses.length; i++) {
      addedWarehouses[i].sequenceNumber = i + 1;
    }
    this.addedWarehousesDataSource = {
      data: addedWarehouses,
      totalItems: addedWarehouses.length
    };
  }

  clearAvailableWarehouses() {
    this.availableWarehousesDataSource = {
      data: [],
      totalItems: 0
    };
  }

  clearAddedWarehouses() {
    this.addedWarehousesDataSource = {
      data: [],
      totalItems: 0
    };
  }

  onAddClick() {
    let checkedRows = this.getCheckedAvailableWarehouses();
    if(checkedRows && checkedRows.length > 0) {
      // remove warehouses list from available warehouse alternatives
      this.removeWarehousesFromAvailableList(checkedRows);
      // add warehouses list to added warehouse alternatives
      this.addWarehousesToAlternatives(checkedRows);
    } else {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgNoRowSelected)
      );
    }
  }

  getCheckedAvailableWarehouses(): any[] {
    return this.availableWarehousesDataSource && this.availableWarehousesDataSource.data ?
     this.availableWarehousesDataSource.data.filter(x => x.isChecked) : [];
  }

  getCheckedAddedWarehouses(): any[] {
    return this.addedWarehousesDataSource && this.addedWarehousesDataSource.data ? 
    this.addedWarehousesDataSource.data.filter(x => x.isChecked) : [];
  }

  onDeleteClick() {
    let checkedRows = this.getCheckedAddedWarehouses();
    if(checkedRows && checkedRows.length > 0) {
      // remove warehouses from added alternative warehouses.
      this.removeWarehousesFromAlternatives(checkedRows);
      // add warehouses to available alternative warehouses.
      this.addWarehousesToAvailableWarehouseList(checkedRows);  
    } else {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgNoRowSelected)
      );
    }
  }
  //#region 
}
