import { Component, OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { NavigationData } from '../../../../shared/models/navigation-data/navigation-data.model';

@Component({
  selector: 'app-warehouse-managment-main',
  templateUrl: './warehouse-managment-main.component.html',
  styleUrls: ['./warehouse-managment-main.component.css']
})
export class WarehouseManagmentMainComponent implements OnInit, OnDestroy {

  navLinks: any[];
  indexCounter: number = -1;

  constructor(
    private sessionDataProvider: SessionDataProvider,
    private navService:NavBarService) {
  }

  ngOnInit() {
    this.prepareNavigation();
    var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
    if (index == -1) index = 0;
    this.navLinks[index].isActive = true;
    this.setNavigation(this.navLinks[index]);
  }
  prepareNavigation() {
    this.navLinks = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable) {
      if (menu.menuId.includes('100-007-')) {
        this.indexCounter = this.indexCounter + 1
        let newName = {
          label: menu.menuName,
          link: menu.url,
          isActive: false,
          index: this.indexCounter
        };
        this.navLinks.push(newName);
      }
    }
  }
  ngOnDestroy() {
    this.navService.setNavigation([]);
  }
  onChangeSeletedTab(tab) {
    this.setNavigation(tab);
  }
  setNavigation(tab) {
    let navigationList: NavigationData[] = [];
    navigationList.push(
      {
        Name: 'Desc_Data_Definition',
        URL: ConstantURLs.dataDefinitionURL
      },
      {
        Name: 'Desc_Warehouses_And_Vehicles',
        URL: undefined
      },
      {
        Name: tab.label,
        URL: undefined
      }
    );
    this.navService.setNavigation(navigationList);
  }
}
