import { Routes, RouterModule } from '@angular/router';
import { AuthGuard } from '../../../core/auth/auth.gurad';
import { WarehouseManagmentMainComponent } from './warehouse-managment-main/warehouse-managment-main.component';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { WarehouseListComponent } from './warehouse-list/warehouse-list.component';
import { VehicleListComponent } from './vehicle-list/vehicle-list.component';
import { NgModule } from '@angular/core';

const WarehouseManagmentRouting: Routes = [
  {
    path: "",
    canActivate: [AuthGuard],
    component: WarehouseManagmentMainComponent,
    children: [
      {
        path: '',
        canActivate: [AuthGuard],
        redirectTo: ConstantURLs.warehousesURL,
        pathMatch: 'full'
      },
      {
        path: ConstantURLs.warehousesURL,
        canActivate: [AuthGuard],
        component: WarehouseListComponent
      },
      {
        path: ConstantURLs.vehiclesURL,
        canActivate: [AuthGuard],
        component: VehicleListComponent
      },
     
    ]
  }

];
@NgModule({
  imports: [RouterModule.forChild(WarehouseManagmentRouting)],
  exports: [RouterModule]
})
export class WarehouseManagmentRoutingModule {
}
