import { NgModule } from "@angular/core";
import { WarehouseManagmentMainComponent } from "./warehouse-managment-main/warehouse-managment-main.component";
import { VehicleListComponent } from "./vehicle-list/vehicle-list.component";
import { VehicleEntryComponent } from "./vehicle-entry/vehicle-entry.component";
import { WarehouseEntryComponent } from "./warehouse-entry/warehouse-entry.component";
import { WarehouseListComponent } from "./warehouse-list/warehouse-list.component";
import { NgSelectModule } from "@ng-select/ng-select";
import { CommonModule } from "@angular/common";
import { WarehouseManagmentRoutingModule } from "./warehouse-managment-routing.module";
import { SharedModule } from "../../../shared/shared.module";
import { FormsModule, ReactiveFormsModule } from "@angular/forms";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { TranslateModule } from "@ngx-translate/core";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";

@NgModule({
  declarations: [
    WarehouseManagmentMainComponent,
    WarehouseListComponent,
    WarehouseEntryComponent,
    VehicleListComponent,
    VehicleEntryComponent,
  ],
  imports: [
    NgSelectModule,
    CommonModule,
    WarehouseManagmentRoutingModule,
    SharedModule,
    FormsModule,
    ReactiveFormsModule,
    NgMultiSelectDropDownModule,
    TranslateModule.forChild(),
    NgOptionHighlightModule,
    NgbModule
  ],
  exports: [VehicleEntryComponent],
})
export class WarehouseManagmentModule {}
