import { PromotionTypes } from './../../../shared/models/enums/promotion-types.enum';
import { Component, OnInit, ViewChild } from "@angular/core";
import { ITableProperties } from "../../../shared/models/shared-table/table-properties.interface";
import { SharedTableResult } from "../../../shared/models/shared-table/shared-table-result.interface";
import { OrderListFilter } from "../../../shared/models/shared-table/custom-list.interface";
import { OrderStatus } from "../../../shared/models/enums/order-status.enum";
import { CoreSession } from "../../../core/core.session";
import { OrderService } from "../order.service";
import { OrderOperation } from "../../../shared/models/enums/order-operation .enum";
import { DialogMode } from "../../../shared/models/enums/dialog-mode.enum";
import { HttpErrorResponse } from "@angular/common/http";
import { ConstantMessages } from "../../../shared/models/constants/constant-message";
import { RowOperation } from "../../../shared/models/enums/shared-table-operation.enum";
import { DialogResult } from "../../../shared/models/enums/dialog-result.enum";
import { TranslateService } from "@ngx-translate/core";
import { ConstantURLs } from "../../../shared/models/constants/constant-URL";
import { IOperationSummary } from "../../../shared/models/operation-summary/operation-summary-interface";
import { FormProcessMode } from "../../../shared/models/enums/form-process-mode.enum";
import * as cloneDeep from "lodash/cloneDeep";
import { FormGroup, FormControl, Validators } from "@angular/forms";
import { IDateTimePickerProperties } from "../../../shared/models/dateTimeModel/date-time-properties.interface";
import { SessionDataProvider } from "../../../core/session-data-provider.service";
import { ConstantConfigurations } from "../../../shared/models/constants/constant-configuration";
import { DateTimeModel } from '../../../shared/models/dateTimeModel/date-time.model';
import { MenuActions } from '../../../shared/models/enums/menu-actions-enum';
import { DeliveryModes } from '../../../shared/models/enums/delivery-modes.enum';
import { Subject } from 'rxjs';
import { SSCCGenerationService } from '../../../shared/components/ssccGeneration/sscc-generation.service';
import { ResponseModel } from '../../../shared/models/api-models/api-models';
import { NgbModal, NgbModalConfig, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { ReportMode } from "../../../shared/models/enums/report-mode.enum";
import { WarehouseService } from "../../../shared/services/data-definition/warehouse-and-vehicle/warehouse.service";
import { TransationCommonData } from "../../../shared/models/transaction/transaction-common-data";
import { ValidationService } from "../../../shared/services/validation.service";
import { OrderTypes } from '../../../shared/models/enums/order-types.enum';
import { ItemService } from '../../../shared/services/data-definition/product/item.service';
import { OrderApprovedService } from '../../../shared/services/order/order-approved.service';
import { PdfCreatorService } from '../../../shared/services/pdf-creator.service';
import { CalculationService } from '../../../shared/services/calculations.service';
import { NavBarService } from '../../../core/sidebar/sidebar.service';

@Component({
  selector: "app-approved-order",
  templateUrl: "./approved-order.component.html",
  styleUrls: ["./approved-order.component.css"]
})
export class ApprovedOrderComponent implements OnInit {
  selectedOrder: any;
  selectedDriver: any = {
    vehicleId: -1
  };
  warehouseForm: FormGroup;
  @ViewChild("warehouseSelection", { static: true })
  warehouseSelection: NgbModal;
  showViewSummarySlider = false;
  boInvoiceFODelivery = false;
  allowInvoiceBeforeAssign = false;
  affectMainWarehouseUponOrderBOInvoicing = false;
  boInvoiceBODelivery = false;
  enableGeneratingSSCC = false;
  affectVanStockInDeliveryInFO = false;
  AllowBatchSelectionInDelivery = false;
  transactionCommonData: TransationCommonData;
  customerPromotions: any[] = [];
  isThereAnyWholeSalePromotion = false;
  isThereDynamicSalesAmount = false;
  isThereTargetPromotion = false;
  isPromotionSelectionForEcho = false;
  hasLoyalityPromotion = false;
  hasNoSalesCertainPeriod = false;
  isSSCCMode = false;
  isInvoice = true;
  modalRef: NgbModalRef;
  orderStatusFromUI: OrderStatus = OrderStatus.Approved;
  operationSummaryData: IOperationSummary = {
    operationData: {},
    formProcessMode: FormProcessMode.Orders,
    formTitle: "Desc_Order_Summary"
  };

  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: false,
    rowOperations: [],
    specificActionWhenCheckRow: true,
    specificActionWhenCheckAll: true,
    isMultiSelection: false,
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Order_ID",
        key: "orderId",
        isSortable: true,
      },
      {
        title: "Desc_Customer",
        key: "customerCodeName",
        isSortable: false,
      },
      {
        title: "Desc_Outlet",
        key: "outletCodeName",
        isSortable: false,
      },
      {
        title: "Desc_Employee",
        key: "employeeName",
        isSortable: false,
      },
      {
        title: "Desc_Order_Date",
        key: "orderDate",
        isSortable: true,
        isDate: true
      },
      {
        title: "Desc_Delivery_Date",
        key: "desiredDeliveryDate",
        isSortable: true,
        isDate: true
      }
    ]
  };

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  query: OrderListFilter = {
    customListFilter: {
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    orderOperation: OrderOperation.GetApproved,
    orderStatus: OrderStatus.Approved,
    customerId: -1,
    outletId: -1,
    employeeId: -1,
    driverId: -1,
    orderTypeId: -1,
    isBundle: false,
    warehouseId: -1
  };

  schduleDateProperties: IDateTimePickerProperties = {
    label: "Desc_Schedule_Date",
    formControlName: "schduleDate",
    min: new Date()
  };
  orderDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Order_Date',
    formControlName: 'orderDate',
    isCalendarOnly: true,
    isRange: true
  };
  desiredDeliveryDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Delivery_Date',
    formControlName: 'desiredDeliveryDate',
    isCalendarOnly: true,
    isRange: true
  };
  orderId = "";
  orderSignature = "";

  assignOrdersForm: FormGroup;

  showAssignSection = false;
  forceLoadRequestForOrders = false;
  deliveryUsingInvan = false;
  enablePushOrderNotification = false;
  onlyFOInvoicingAndDeliveryMode = false;
  fOInvoicingAndDeliveryModeIncluded = false;
  showOrderSlider = false;
  isEditMode = false;
  isKeepDefualtMode = true;

  selectedOrders = [];
  warehouseDataSource: any[];
  selectedSchdualeDateModel: DateTimeModel;
  selectedOrderDateRange: DateTimeModel[];
  selectedDesiredDeliveryDateRange: DateTimeModel[];
  allowDispatch = false;
  territoryId = 0;
  clearCustomerSubject: Subject<void> = new Subject<void>();
  isDelivery = false;
  selectedOrderTypeId: number = 1;
  allowDispatchForReturnOrder: boolean = false;
  orderTypeDS = [];
  restrictReturnFromInvoices: boolean = false;
  isReturnMode = false;
  getEmployeesHavingOrdersFromApproved: boolean = false;
  AllowWarehouseSelectionInPendingOrders = false;
  constructor(
    private orderService: OrderService,
    private warehouseService: WarehouseService,
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private sessionData: SessionDataProvider,
    private config: NgbModalConfig,
    private modalService: NgbModal,
    private ssccGeneratingService: SSCCGenerationService,
    private pdfCreatorService: PdfCreatorService,
    private validationService: ValidationService,
    private itemService: ItemService,
    private calculationService: CalculationService,
    private orderApprovedService: OrderApprovedService,
    private navService: NavBarService

  ) { }

  showSharedTable: boolean = false

  ngOnInit() {

    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus
    }
    )

    this.showSharedTable = this.navService.tourStatus;

    this.coreSession.SetTitle("Approved Orders");
    this.transactionCommonData = new TransationCommonData();
    this.initAsssignForm();
    this.boInvoiceFODelivery = this.sessionData
      .getConfigurationValue(ConstantConfigurations.DeliveryMode)
      .toLowerCase().includes(DeliveryModes.BOInvoicingFODelivery.valueOf() + "");
    this.affectMainWarehouseUponOrderBOInvoicing =
      this.sessionData.getConfigurationValue(ConstantConfigurations.AffectMainWarehouseUponOrderBOInvoicing).toLowerCase() === "true";
    this.boInvoiceBODelivery = this.sessionData
      .getConfigurationValue(ConstantConfigurations.DeliveryMode).toLowerCase().includes(DeliveryModes.BOInvoicingAndDelivery.valueOf() + "");
    this.enableGeneratingSSCC = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableGeneratingSSCC).toLowerCase() === 'true';
    this.affectVanStockInDeliveryInFO =
      this.sessionData.getConfigurationValue(ConstantConfigurations.AffectVanStockInDeliveryInFO).toLowerCase() === "true";
    this.allowInvoiceBeforeAssign = JSON.parse(this.sessionData.getConfigurationValue('AllowInvoiceOrderBeforeAssignOrder').toString().toLowerCase());

    this.restrictReturnFromInvoices =
      this.sessionData.getConfigurationValue(ConstantConfigurations.RestrictReturnFromInvoices).toLowerCase() === "true";

    if (this.allowInvoiceBeforeAssign) {
      this.tableData.showSearchBtn = true;
    } else {
      // this.initAsssignForm();
      this.fillOrderTypeDataSource();
    }
    if (this.isDivisionLevel())
      this.tableData.columns.push({ title: "Desc_Division", key: "division", isSortable: true });
    this.allowInvoiceBeforeAssign ? this.query.orderTypeId = OrderTypes.Sales.valueOf() : -1;
    this.populateApprovedOrderList();
    this.addAction();
    this.initConfigurations();
    this.getEmployeesHavingOrdersFromApproved = (!this.allowInvoiceBeforeAssign || this.allowDispatchForReturnOrder) && this.allowDispatch
  }
  isDivisionLevel() {
    return (this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true")
  }
  initAsssignForm() {
    let employeeId: number;
    let warehouseId: number;
    let customerId: number;
    let outletId: number;
    this.assignOrdersForm = new FormGroup({
      employeeId: new FormControl(employeeId, [Validators.required]),
      schduleDate: new FormControl({ value: "", disabled: true }),
      warehouseId: new FormControl(warehouseId, [Validators.required]),
      customerId: new FormControl(customerId, null),
      outletId: new FormControl(outletId, null),
      orderDate: new FormControl({ value: [] }),
      desiredDeliveryDate: new FormControl({ value: [] }),
      orderTypeId: new FormControl(null),
      isBundle: new FormControl(false)
    });

    if (!this.forceLoadRequestForOrders) {
      this.warehouseId.setValidators(null);
      this.warehouseId.updateValueAndValidity();
    }
  }

  initConfigurations() {
    this.AllowWarehouseSelectionInPendingOrders = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowWarehouseSelectionInPendingOrders).toLowerCase() === "true";
    this.forceLoadRequestForOrders =
      this.sessionData
        .getConfigurationValue(ConstantConfigurations.ForceLoadRequestForOrders)
        .toLowerCase() === "true" && (
        (
          this.sessionData
            .getConfigurationValue(ConstantConfigurations.AffectVanStockInDeliveryInFO)
            .toLowerCase() === "true" && this.sessionData
              .getConfigurationValue(ConstantConfigurations.DeliveryMode)
              .toLowerCase().includes(DeliveryModes.BOInvoicingFODelivery.valueOf() + "")
        )
        || this.sessionData
          .getConfigurationValue(ConstantConfigurations.DeliveryMode)
          .toLowerCase().includes(DeliveryModes.FOInvoicingAndDelivery.valueOf() + "")
      );

    this.deliveryUsingInvan =
      this.sessionData
        .getConfigurationValue(ConstantConfigurations.DeliveryMode)
        .toLowerCase().includes(DeliveryModes.BOInvoicingFODelivery.valueOf() + "") || this.sessionData
          .getConfigurationValue(ConstantConfigurations.DeliveryMode)
          .toLowerCase().includes(DeliveryModes.FOInvoicingAndDelivery.valueOf() + "");

    this.onlyFOInvoicingAndDeliveryMode = !this.sessionData
      .getConfigurationValue(ConstantConfigurations.DeliveryMode)
      .toLowerCase().includes(DeliveryModes.BOInvoicingFODelivery.valueOf() + "") && !this.sessionData
        .getConfigurationValue(ConstantConfigurations.DeliveryMode)
        .toLowerCase().includes(DeliveryModes.BOInvoicingAndDelivery.valueOf() + "") && this.sessionData
          .getConfigurationValue(ConstantConfigurations.DeliveryMode)
          .toLowerCase().includes(DeliveryModes.FOInvoicingAndDelivery.valueOf() + "");
    this.fOInvoicingAndDeliveryModeIncluded = this.sessionData
      .getConfigurationValue(ConstantConfigurations.DeliveryMode)
      .toLowerCase().includes(DeliveryModes.FOInvoicingAndDelivery.valueOf() + "");
    this.enablePushOrderNotification = this.sessionData.getConfigurationValue(ConstantConfigurations.EnablePushOrderNotification).toLowerCase() === "true";
    this.AllowBatchSelectionInDelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowBatchSelectionInDelivery).toLowerCase() === 'true';
    this.initWarehouseForm();

  }

  initWarehouseForm() {
    let warehouseId: number;
    this.warehouseForm = new FormGroup({
      warehouseId: new FormControl(warehouseId, Validators.required)
    });
  }

  addAction() {
    this.allowDispatch = this.coreSession.checkActivitiesAvailability(ConstantURLs.approvedOrdersURL, MenuActions.Dispatch);
    if (this.allowDispatch && !this.allowInvoiceBeforeAssign) {
      this.tableData.isMultiSelection = true;
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvedOrdersURL, MenuActions.Disapprove)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.delete,
        title: "Desc_Order_Disapprove",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      });
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvedOrdersURL, MenuActions.Edit)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvedOrdersURL, MenuActions.View)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.View,
        title: 'Desc_View',
        icon: 'fa-regular fa-eye',
        color: '#12344d'
      });
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvedOrdersURL, MenuActions.Print)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.Print,
        title: 'Desc_Print',
        icon: 'fa-solid fa-print',
        color: '#12344d'
      });
    }

    // if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvedOrdersURL, MenuActions.InvoiceOrder)) {
    //   if (this.boInvoiceFODelivery && this.allowInvoiceBeforeAssign) {
    //     this.tableData.rowOperations.push({
    //       operation: RowOperation.invoiceOrder,
    //       title: "Desc_Order_Invoice",
    //       icon: "fa fa-money",
    //       color: "#12344d",
    //       showWhenKeyValueTrue: true,
    //       showHideOptionPerLine: true,
    //       controlKeyName: "showInvoiceBtn"
    //     });
    //   }
    // }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvedOrdersURL, MenuActions.Delivery)) {
      if (this.boInvoiceBODelivery) {
        this.tableData.rowOperations.push({
          operation: RowOperation.delivery,
          title: "Desc_Delivery",
          icon: "fa-solid fa-truck",
          color: "#12344d",
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: "showDeliveryBtn"
        });
      }
    }

    // if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvedOrdersURL, MenuActions.Process)) {
    //   this.tableData.rowOperations.push({
    //     operation: RowOperation.Process,
    //     title: 'Desc_Process',
    //     icon: 'fa fa-retweet',
    //     color: '#02b875',
    //     showWhenKeyValueTrue: true,
    //     showHideOptionPerLine: true,
    //     controlKeyName: "showReturnBtn"
    //   });
    // }
  }

  InvoiceOrderClicked(order: any) {
    this.selectedOrder = order;
    this.orderId = order.orderId;
    this.orderSignature = order.orderSignature;
    this.selectedOrder.orderOperation = OrderOperation.Invoicing;
    this.getOrderDetails();
  }




  onWarehouseSelected() {

    if (this.warehouseForm.invalid) {
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.SelectWarehouse)
      );
      return;
    }
    this.selectedOrder.warehouseId = this.warehouseForm.get(
      "warehouseId"
    ).value;
    this.onCloseWarehouseModal();
    this.isOrderValidToInvoice();
  }


  onCloseWarehouseModal() {
    this.modalRef.dismiss();
    this.warehouseForm.reset();
  }



  checkIfWhTransactionHasAddedSSCC(order) {
    this.coreSession.ModalLoading.Show();
    this.ssccGeneratingService.CheckIfTransactionOrOrderHasAddedSSCC('', order.orderId)
      .subscribe((response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data.ssccCount > 0) {
            this.isSSCCMode = true;
            this.showOrderSlider = true;
            this.selectedOrder.warehouseId = response.data.warehouseId;
          } else {
            this.askIfUserWantToGenerateSSCC(order);
          }
        } else {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);

        }
      },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );

  }

  selectMainWarehouse() {
    let warehouseFilter = {
      vehicleId: -1,
      organizationId: -1,
      currentStockMode: false,
      includeDamaged: false,

    }
    this.coreSession.ModalLoading.Show();
    this.warehouseService.getWarehouses(warehouseFilter).subscribe(result => {
      this.warehouseDataSource = result;
      if (this.warehouseDataSource) {
        if (this.warehouseDataSource.length == 1) {
          this.selectedOrder.warehouseId = this.warehouseDataSource[0].warehouseId;
          this.isOrderValidToInvoice();
        } else if (this.warehouseDataSource.length > 1) {
          this.config.backdrop = "static";
          this.modalRef = this.modalService.open(this.warehouseSelection, {
            centered: true
          });
          this.config.backdrop = true;
        }
      } else {

      }

      this.coreSession.ModalLoading.Hide();
    });

  }

  isOrderValidToInvoice() {
    this.selectedOrder.orderStatusFromUI = OrderStatus.Approved;
    this.coreSession.ModalLoading.Show();
    this.orderApprovedService.isOrderValidToInvoice(this.selectedOrder).subscribe(
      response => {

        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.selectedOrder = response.data;
          if (this.isInvoice) {
            this.InvoiceOrder();
          }
          //          else if(this.isSSCCMode){
          // this.showOrderSlider()
          //           }
          else if (this.isSSCCMode || this.selectedOrder.orderHasSerialItems || this.AllowBatchSelectionInDelivery || ((this.customerPromotions && this.customerPromotions.length > 0 && this.isThereTargetPromotion) || this.isThereAnyWholeSalePromotion || this.isThereDynamicSalesAmount || this.isPromotionSelectionForEcho || this.hasLoyalityPromotion || this.hasNoSalesCertainPeriod)) {
            // this.coreSession.showWarrning(
            //   this.translateService.instant(ConstantMessages.WarningCaption),
            //   this.translateService.instant(ConstantMessages.Desc_Serials_Must_Entered)
            // );
            this.showOrderSlider = true;
          }
          else {
            if (this.isDelivery) {
              this.checkForContractedFOC();
            } else {
              this.InvoiceOrder();
            }
          }
        } else {
          this.isDelivery = false;
          this.selectedOrder = {};
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  checkForContractedFOC() {
    this.transactionCommonData;
    this.coreSession.ModalLoading.Show();
    this.validationService.checkForContractedFOC(this.transactionCommonData).subscribe(response => {

      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if (response.data && response.data.length > 0) {
          this.showOrderSlider = true;
        } else {
          this.InvoiceOrder();
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
    });
  }

  InvoiceOrder() {
    this.coreSession.ModalLoading.Show();
    let successMessage = ConstantMessages.OrderInvoiced;
    if (!this.isInvoice) {
      successMessage = ConstantMessages.OrderDelivered;
      this.orderApprovedService.deliveryOrder(this.selectedOrder).subscribe(
        response => {
          this.onInvoiceOrderSuccess(response, successMessage);
        },
        (error: HttpErrorResponse) => {
          this.onInvoiceOrderError(error);
        }
      );
    } else {
      this.orderApprovedService.invoiceOrder(this.selectedOrder).subscribe(
        response => {
          this.onInvoiceOrderSuccess(response, successMessage);
        },
        (error: HttpErrorResponse) => {
          this.onInvoiceOrderError(error);
        }
      );
    }
  }

  onInvoiceOrderSuccess(response, successMessage) {
    this.selectedOrder = {};
    this.coreSession.ModalLoading.Hide();
    if (response.status != null && response.status >= 0) {
      this.coreSession.showSuccess(
        this.translateService.instant(ConstantMessages.SuccessCaption),
        this.translateService.instant(successMessage)
      );
      this.populateApprovedOrderList();

    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }
  onInvoiceOrderError(error) {
    this.selectedOrder = {};
    this.coreSession.ModalLoading.Hide();
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));

  }

  askIfUserWantToGenerateSSCC(order) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.Desc_Do_You_Want_To_Generate_SSCC), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (result: DialogResult) => {
        if (result === DialogResult.Yes) {
          this.isSSCCMode = true;
          //  this.showOrderSlider=true;
        }//else{
        // if (
        //   (this.isInvoice && !this.affectVanStockInDeliveryInFO && this.boInvoiceFODelivery && this.affectMainWarehouseUponOrderBOInvoicing)||
        //   (!this.isInvoice&& this.affectMainWarehouseUponOrderBOInvoicing && this.boInvoiceBODelivery)
        //  ) {
        this.selectMainWarehouse();
        // }
        //   else {
        //    this.isOrderValidToInvoice();
        //  }
        // if(order.orderHasSerialItems || this.AllowBatchSelectionInDelivery){
        // //    this.coreSession.showWarrning(
        // //   this.translateService.instant(ConstantMessages.WarningCaption),
        // //   this.translateService.instant(ConstantMessages.Desc_Serials_Must_Entered)
        // // );
        // this.isSSCCMode=false;
        // this.showOrderSlider=true;
        // }else{
        //   this.InvoiceOrder();
        // }

        //}
      }
    );
  }

  populateApprovedOrderList() {
    this.isSSCCMode = false;
    this.coreSession.ModalLoading.Show();
    this.orderApprovedService.getOrders(this.query).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = <SharedTableResult>response.data;
          this.showMultiSelection();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  showMultiSelection() {
    if (this.allowInvoiceBeforeAssign && this.allowDispatch) {
      if (this.query.orderTypeId && this.query.orderTypeId === OrderTypes.Return.valueOf()) {
        this.allowDispatchForReturnOrder = true;
        this.tableData.isMultiSelection = true;
      } else {
        this.allowDispatchForReturnOrder = false;
        this.tableData.isMultiSelection = false;
      }
    }

  }
  onDeleteClicked(order: any) {
    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(ConstantMessages.DisapproveConfirmation),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.OrderDisapproved)
    ).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {
        this.DisApprovedOrder(order);
      }
    });
  }

  onRowOperation(event: any) {
    this.isDelivery = false;
    this.isReturnMode = false;
    switch (event.operation) {
      case RowOperation.View:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvedOrdersURL, MenuActions.View)) {
          this.viewTransaction(event.object.orderSignature);
        }
        break;
      case RowOperation.edit:
        this.isValidToEdit(event.object);
        break;
      case RowOperation.delete:
        this.onDeleteClicked(event.object);
        break;
      case RowOperation.invoiceOrder:
        this.isInvoice = true;
        this.InvoiceOrderClicked(event.object);
        break;
      case RowOperation.Print:
        this.exportOrderReport(event);
        break;
      case RowOperation.delivery:
        this.isInvoice = false;
        this.isSSCCMode = false;
        this.InvoiceOrderClicked(event.object);
        break;
      case RowOperation.Process:
        this.isReturnMode = true;
        this.checkOrderStatusBeforeAnyAction(event);
        break;
    }
  }
  exportOrderReport(event: any) {
    let trans = {
      divisionId: event.object.divisionId ? event.object.divisionId : -1,
      transactionId: event.object.orderId,
      customerId: event.object.customerId,
      outletId: event.object.outletId,
      reportMode: ReportMode.SalesOrder,
      isReprintReport: true
    }
    this.pdfCreatorService.ExportReport(trans);
  }

  onTableFilterChanged(query: any) {

    this.query.customListFilter = query;
    this.populateApprovedOrderList();
  }

  DisApprovedOrder(order: any) {
    order.orderOperation = OrderOperation.DisApprove;
    order.orderStatus = OrderStatus.New;
    order.orderStatusId = OrderStatus.New.valueOf();
    order.orderStatusFromUI = OrderStatus.Approved;
    this.coreSession.ModalLoading.Show();
    this.orderApprovedService.disapproveOrder(order).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.OrderDisapproved)
          );
          this.populateApprovedOrderList();
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  onFindButtonClicked() {

    this.selectedOrders = [];
    this.query.customListFilter.page = 0;
    if (this.isDivisionLevel())
      this.query.divisionId = this.assignOrdersForm.value.divisionId;
    else
      this.query.divisionId = -1;
    this.query.customerId = (this.assignOrdersForm.value.customerId ? this.assignOrdersForm.value.customerId : -1);
    this.query.outletId = (this.assignOrdersForm.value.outletId ? this.assignOrdersForm.value.outletId : -1);

    this.query.isBundle = (this.assignOrdersForm.value.isBundle ? this.assignOrdersForm.value.isBundle : false);

    this.query.orderDateRange = this.selectedOrderDateRange;
    this.query.warehouseId = this.assignOrdersForm.value.warehouseId != null ? this.assignOrdersForm.value.warehouseId : -1;
    this.query.desiredDeliveryDateRange = this.selectedDesiredDeliveryDateRange;
    if (!this.allowDispatchForReturnOrder)
      this.query.orderTypeId = (this.assignOrdersForm.value.orderTypeId ? this.assignOrdersForm.value.orderTypeId : -1);

    this.populateApprovedOrderList();
  }

  onFindButtonClickedInInvoicedMode(result) {
    this.query.customListFilter.page = 0;
    if (this.isDivisionLevel())
      this.query.divisionId = result.divisionId;
    else
      this.query.divisionId = -1;
    this.query.customerId = result.customerId;
    this.query.outletId = result.outletId;
    this.query.employeeId = result.employeeId;
    this.query.orderDateRange = result.transactionDate;
    this.query.desiredDeliveryDateRange = result.secondDate;
    this.query.driverId = result.driverId;
    this.query.orderTypeId = result.orderTypeId && result.orderTypeId > 0 ? result.orderTypeId : 1;
    this.selectedOrderTypeId = this.query.orderTypeId;
    this.query.warehouseId = result.warehouseId;
    this.query.isBundle = result.isBundle;
    this.populateApprovedOrderList();
  }


  closeViewSummarySlider() {
    this.selectedOrder = null;
    this.operationSummaryData = null;
    this.showViewSummarySlider = false;
  }

  viewTransaction(signature: string) {
    this.coreSession.ModalLoading.Show();
    let query: OrderListFilter = {};
    query.orderSignature = signature;
    query.isViewMode = true;
    this.orderApprovedService.getOrder(query).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.selectedOrder = response.data;
          this.operationSummaryData = {
            operationData: this.selectedOrder,
            formProcessMode: FormProcessMode.Orders,
            formTitle: "Desc_Order_Summary"
          };
          if (this.selectedOrder.orderTypeId === OrderTypes.Return.valueOf() &&
            this.restrictReturnFromInvoices && this.selectedOrder.isRestrictedFromOldInvoices) {
            this.operationSummaryData.operationData.allowBatchesInItems = true;
          }
          this.showViewSummarySlider = true;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  closeOrderSlider() {
    this.orderId = "";
    this.orderSignature = null;
    this.isEditMode = false;
    this.showOrderSlider = false;
    this.isDelivery = false;
    this.isSSCCMode = false;
  }

  onSaveComplete() {
    this.closeOrderSlider();
    this.populateApprovedOrderList();
  }

  isValidToEdit(order: any) {
    order.orderOperation = OrderOperation.EditValues;
    this.coreSession.ModalLoading.Show();
    order.orderStatusFromUI = OrderStatus.Approved;
    this.orderApprovedService.isValidOperation(order).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data.isValidOperation) {
            this.onEditSelectedOrder(order);
          } else {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              response.data.message
            );
          }
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  onEditSelectedOrder(order) {
    if (order.orderTypeId === OrderTypes.Return.valueOf() && this.restrictReturnFromInvoices && order.isRestrictedFromOldInvoices) {
      this.checkForPostedCustomerTransactions(order);
    } else {
      this.orderId = order.orderId;
      this.orderSignature = order.orderSignature;
      this.isEditMode = true;
      this.showOrderSlider = true;
    }
  }

  checkForPostedCustomerTransactions(order) {
    this.coreSession.ModalLoading.Show();
    this.orderApprovedService.checkForPostedCustomerTransactions(order).subscribe((response) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if (response.data === true) {
          // ALERT USER.
          this.coreSession.showInfo(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgCalculatingBatches));
          // UPDATE BATCHES...
          this.updateCustomerReturnBatches(order);
        } else {
          if (!this.isReturnMode) {
            this.orderId = order.orderId;
            this.orderSignature = order.orderSignature;
            this.isEditMode = true;
          }
          this.showOrderSlider = true;
        }
      } else {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  updateCustomerReturnBatches(order) {
    this.coreSession.ModalLoading.Show();
    this.itemService.updateCustomerReturnBatches(order).subscribe((response) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if (!this.isReturnMode) {
          this.orderId = order.orderId;
          this.orderSignature = order.orderSignature;
          this.isEditMode = true;
        }
        this.showOrderSlider = true;
      } else {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.ErrorHappened)
      );
    }
    );
  }

  onAssignOrderClicked() {

    this.tableData.isMultiSelection = !this.tableData.isMultiSelection;
    this.tableData = cloneDeep(this.tableData);
    this.showAssignSection = !this.showAssignSection;
  }
  onChangeCustomer(event) {

  }
  onChangeOutlet(event) {

  }
  onEmployeeDataChanged(event) {

    if (event) {
      this.selectedDriver = event;
      this.query.driverId = this.selectedDriver.employeeId;
      this.territoryId = this.selectedDriver.territoryId;
    } else {
      this.selectedDriver = {};
      this.query.driverId = -1;
      this.territoryId = -1;
    }
    this.onFindButtonClicked();
    this.warehouseId.setValue(null);
    this.warehouseId.updateValueAndValidity();
  }

  onKeepDefualtClick() {
    this.isKeepDefualtMode = true;
    this.schduleDate.disable();
    this.schduleDate.setValue(null);
    this.schduleDate.clearValidators();
    this.schduleDate.updateValueAndValidity();
  }

  onRescheduleClick() {
    this.isKeepDefualtMode = false;
    this.schduleDate.enable();
    this.schduleDate.setValidators([Validators.required]);
    this.schduleDate.updateValueAndValidity();
  }


  onCheckAllOperation(checkAll: boolean) {
    if (checkAll) {
      this.selectedOrders = this.dataSource.data.slice();
    } else {
      this.selectedOrders = [];
    }
  }

  onCheckRowOperation(object: any) {
    if (object.isChecked) {
      this.selectedOrders.push({ ...object });
    } else {
      let index = this.selectedOrders.findIndex(
        a => a.orderId == object.orderId
      );
      this.selectedOrders.splice(index, 1);
    }
  }
  checkIfOrderWillBeSentToFO() {
    let today = new Date();
    if (this.onlyFOInvoicingAndDeliveryMode) {
      this.selectedOrders.forEach(order => {
        if (order.scheduleDateModel.year === today.getFullYear() && order.scheduleDateModel.month === today.getMonth() + 1
          && order.scheduleDateModel.day === today.getDate()) {
          order.enableSendNotification = true;
        }
      });
      this.assignOrderToDriver();
    } else if (this.fOInvoicingAndDeliveryModeIncluded) {
      let showMsg = false;
      this.selectedOrders.forEach(order => {

        if (order.scheduleDateModel.year === today.getFullYear() && order.scheduleDateModel.month === today.getMonth() + 1
          && order.scheduleDateModel.day === today.getDate()) {
          showMsg = true;
        }
      });
      if (showMsg) {
        this.coreSession.ModalDialog.ShowMessage(
          this.translateService.instant(
            ConstantMessages.Desc_Confirm_Send_Notification_To_Driver
          ),
          DialogMode.YesNo,
          this.translateService.instant(ConstantMessages.WarningCaption)
        ).then((result: DialogResult) => {
          if (result === DialogResult.Yes) {
            this.selectedOrders.forEach(order => {

              if (order.scheduleDateModel.year === today.getFullYear() && order.scheduleDateModel.month === today.getMonth() + 1
                && order.scheduleDateModel.day === today.getDate()) {
                order.enableSendNotification = true;
              }
            });
          }
          this.assignOrderToDriver();
        });
      } else {
        this.assignOrderToDriver();
      }

    } else {
      this.assignOrderToDriver();
    }

  }
  onAssignClicked() {
    this.markFormAsTouched();
    if (this.assignOrdersForm.invalid) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant('Desc_Fill_Field_To_Dispatch')
      );
      return;
    }

    if (this.selectedOrders.length === 0) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant('Desc_Please_select_an_order')
      );
      return;
    }

    for (let order of this.selectedOrders) {
      if (this.isKeepDefualtMode) {
        let today = new Date();
        if (order.desiredDeliveryDateModel.date < today) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.DeliveryDateCantBeLessThanAssignment));
          return;
        }
        order.scheduleDateModel = order.desiredDeliveryDateModel;
      } else {
        order.scheduleDateModel = this.selectedSchdualeDateModel;
      }
      if (this.forceLoadRequestForOrders && order.orderTypeId !== OrderTypes.Return.valueOf()) {
        if (!this.warehouseId || this.warehouseId.value == null) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgWarehouseNotAssignedToVehicle));
          return;
        }
        else
          order.referenceWarehouseId = this.warehouseId.value;
      }
      order.driverId = this.selectedDriver.employeeId;
      order.vehicleId = this.selectedDriver.vehicleId;
    }
    if (this.enablePushOrderNotification && !this.forceLoadRequestForOrders) {
      this.checkIfOrderWillBeSentToFO();
    } else {
      this.assignOrderToDriver();
    }

  }

  onResetAssignForm() {
    this.assignOrdersForm.reset();
    this.territoryId = 0;
    this.selectedDesiredDeliveryDateRange = [];
    this.selectedOrderDateRange = [];
    this.query.driverId = -1;
    this.clearCustomerSubject.next();
    this.onFindButtonClicked();
  }

  assignOrderToDriver() {
    this.selectedOrders.filter(x => x.orderStatusFromUI = OrderStatus.Approved);
    this.coreSession.ModalLoading.Show();
    this.orderApprovedService.assignOrderToDriver(this.selectedOrders).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.OrderDispatched)
          );

          this.query.driverId = -1;
          this.showAssignSection = false;
          this.assignOrdersForm.reset();
          this.onFindButtonClicked();
          this.onEmployeeDataChanged(undefined)
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  getOrderDetails() {
    let query: OrderListFilter = {};
    query.isViewMode = true;
    if (!this.isInvoice) {
      this.isDelivery = true;

    }
    if (this.isDelivery) {
      query.orderOperation = OrderOperation.FullDelivery;
    } else {
      query.orderOperation = OrderOperation.GetAssigned;
    }

    query.orderId = this.selectedOrder.orderId;
    this.orderApprovedService.getOrder(query).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.selectedOrder = response.data;
          if (this.isInvoice) {
            this.selectedOrder.orderOperation = OrderOperation.Invoicing;
          }
          this.fillTransactionCommonData();
          this.checkForAchievementPromotions();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  fillTransactionCommonData() {
    this.transactionCommonData.customerId = this.selectedOrder.customerId;
    this.transactionCommonData.outletId = this.selectedOrder.outletId;
    this.transactionCommonData.divisionId = this.selectedOrder.divisionId;
    this.transactionCommonData.employeeId = this.selectedOrder.employeeId;
    this.transactionCommonData.orderId = this.selectedOrder.orderId;
    this.transactionCommonData.itemFormProcessMode = FormProcessMode.Delivery;
    this.transactionCommonData.soldItems = this.selectedOrder.soldItems;
    this.transactionCommonData.promotedItems = this.selectedOrder.promotedItems;
    this.transactionCommonData.grossTotal = this.selectedOrder.grossTotal;
    this.transactionCommonData.orderStatus = this.selectedOrder.orderStatus;
    this.transactionCommonData.tax = this.selectedOrder.tax;
    this.transactionCommonData.areDetailsFilled = false;
    this.transactionCommonData.netTotal = this.selectedOrder.netTotal;

    if (this.isInvoice || this.isDelivery) {
      //The order net-total maybe saved as rounded so we need to calculate net-total again.
      let netTotalWithoutRounding = this.calculationService.subtractTwoNumbers(this.calculationService.sumTwoNumbers(this.calculationService.getNumberOnDigitFormat(this.selectedOrder.grossTotal)
        , this.calculationService.getNumberOnDigitFormat(this.selectedOrder.tax))
        , this.calculationService.getNumberOnDigitFormat(this.selectedOrder.discount));

      this.transactionCommonData.netTotal = this.calculationService.getDecimalTotalsRoundedBasedOnMode(netTotalWithoutRounding, this.isDelivery ? FormProcessMode.Delivery : FormProcessMode.Sales);
      this.transactionCommonData.roundingDifference = netTotalWithoutRounding - this.selectedOrder.netTotal;
      this.selectedOrder.roundingDifference = this.transactionCommonData.roundingDifference;
    }
  }
  checkForAchievementPromotions() {
    this.coreSession.ModalLoading.Show();
    this.transactionCommonData.dontCheckLastInvoice = true;
    this.transactionCommonData.dontCheckLoyalty = true;
    this.validationService.checkOutPromotions(this.transactionCommonData).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data) {
            if (response.data.customerPromotions.length > 0) {
              this.customerPromotions = response.data.customerPromotions;
              this.isThereTargetPromotion = this.customerPromotions.filter(x => x.promotionType == PromotionTypes.TargetPromotion || x.promotionType == PromotionTypes.DynamicTargetPromotion || x.relatedToTarget) != null && this.customerPromotions.filter(x => x.promotionType == PromotionTypes.TargetPromotion || x.promotionType == PromotionTypes.DynamicTargetPromotion || x.relatedToTarget).length > 0;
            } else {
              this.customerPromotions = [];
            }
            this.isThereAnyWholeSalePromotion = response.data.hasWholeSalesTargetPromo;
            this.isThereDynamicSalesAmount = response.data.hasDynamicTargetSalesAmountPromo;
            this.isPromotionSelectionForEcho = response.data.isPromotionSelectionForEcho;
            this.hasLoyalityPromotion = response.data.hasLoyalityPromotion;
            this.hasNoSalesCertainPeriod = response.data.hasNoSalesCertainPeriod;
          }
          let confMessage = ConstantMessages.InvoiceConfirmation;
          let message = ConstantMessages.Invoicing;
          if (!this.isInvoice) {
            this.isDelivery = true;
            this.selectedOrder.orderOperation = OrderOperation.FullDelivery;
            confMessage = ConstantMessages.DeliveryConfirmation;
            message = ConstantMessages.Delivery;
          }
          if (!this.isInvoice && this.affectMainWarehouseUponOrderBOInvoicing && this.boInvoiceBODelivery && this.enableGeneratingSSCC)
            this.checkIfWhTransactionHasAddedSSCC(this.selectedOrder);
          else {
            this.coreSession.ModalDialog.ShowMessage(
              this.translateService.instant(confMessage),
              DialogMode.YesNo,
              this.translateService.instant(message)
            ).then((result: DialogResult) => {
              if (result === DialogResult.Yes) {

                if (
                  (this.isInvoice && !this.affectVanStockInDeliveryInFO && this.boInvoiceFODelivery && this.affectMainWarehouseUponOrderBOInvoicing) ||
                  (!this.isInvoice && this.affectMainWarehouseUponOrderBOInvoicing && this.boInvoiceBODelivery)
                ) {
                  if (!this.AllowWarehouseSelectionInPendingOrders || this.selectedOrder.warehouseId == -1 || this.selectedOrder.warehouseId == 0) {
                    this.selectMainWarehouse();
                  }
                  else {
                    if (this.selectedOrder.warehouseId > 0) {
                      this.isOrderValidToInvoice();
                    }
                  }
                }
                else {
                  this.isOrderValidToInvoice();
                }
              } else {
                this.isDelivery = false;
              }
            });
          }

        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
      }
    );
  }

  onSchduleDateSelected(event: any) {
    this.selectedSchdualeDateModel = event;
  }
  onOrderDateSelected(event: any) {
    if (event.length == 2) {
      this.selectedOrderDateRange = event;
      this.onFindButtonClicked();
    }
  }
  onDesiredDeliveryDateSelected(event: any) {

    if (event && event.length == 2) {
      this.selectedDesiredDeliveryDateRange = event;

    } else {
      this.selectedDesiredDeliveryDateRange = [];
    }
    this.onFindButtonClicked();
  }
  markFormAsTouched() {
    this.employeeId.markAsTouched();
    this.warehouseId.markAsTouched();
    this.schduleDate.markAsTouched();
  }

  fillOrderTypeDataSource() {
    var filter = [];
    filter.push(OrderTypes.Sales.valueOf());
    filter.push(OrderTypes.Return.valueOf());

    this.orderService.getOrderTypes(filter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.orderTypeDS = response.data;
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }

  checkOrderStatusBeforeAnyAction(event) {
    this.coreSession.ModalLoading.Show();
    this.selectedOrder = event.object;
    this.selectedOrder.orderStatusFromUI = this.selectedOrder.orderStatus;
    this.orderSignature = this.selectedOrder.orderSignature;

    this.orderApprovedService.checkOrderStatusBeforeAnyAction(this.selectedOrder).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data) {
            if (event.operation == RowOperation.Process) {
              if (this.restrictReturnFromInvoices && this.selectedOrder.isRestrictedFromOldInvoices) {
                this.checkForPostedCustomerTransactions(this.selectedOrder);
              } else {
                this.showOrderSlider = true;
              }
            }
          }
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  get schduleDate() {
    return this.assignOrdersForm.get("schduleDate");
  }

  get employeeId() {
    return this.assignOrdersForm.get("employeeId");
  }

  get warehouseId() {
    return this.assignOrdersForm.get("warehouseId");
  }
}
