import { Component, ElementRef, OnInit, ViewChild } from "@angular/core";
import { ITableProperties } from "../../../shared/models/shared-table/table-properties.interface";
import { RowOperation, MultiSelectionOperation } from "../../../shared/models/enums/shared-table-operation.enum";
import { SharedTableResult } from "../../../shared/models/shared-table/shared-table-result.interface";
import { OrderListFilter } from "../../../shared/models/shared-table/custom-list.interface";
import { OrderOperation } from "../../../shared/models/enums/order-operation .enum";
import { OrderService } from "../order.service";
import { CoreSession } from "../../../core/core.session";
import { HttpErrorResponse } from "@angular/common/http";
import { ConstantMessages } from "../../../shared/models/constants/constant-message";
import { DialogMode } from "../../../shared/models/enums/dialog-mode.enum";
import { NgbModal, NgbModalRef } from "@ng-bootstrap/ng-bootstrap";
import { FormGroup, FormControl, Validators } from "@angular/forms";
import { DialogResult } from "../../../shared/models/enums/dialog-result.enum";
import { TranslateService } from "@ngx-translate/core";
import { ConstantURLs } from "../../../shared/models/constants/constant-URL";
import { SessionDataProvider } from "../../../core/session-data-provider.service";
import { OrderStatus } from '../../../shared/models/enums/order-status.enum';
import { MenuActions } from '../../../shared/models/enums/menu-actions-enum';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { IOperationSummary } from '../../../shared/models/operation-summary/operation-summary-interface';
import { FormProcessMode } from '../../../shared/models/enums/form-process-mode.enum';
import { TransactionCreationReason } from '../../../shared/models/enums/transaction-creation-reason.enum';
import { DateTimeModel } from '../../../shared/models/dateTimeModel/date-time.model';
import { Subject } from 'rxjs';
import { DeliveryModes } from '../../../shared/models/enums/delivery-modes.enum';
import { IDateTimePickerProperties } from '../../../shared/models/dateTimeModel/date-time-properties.interface';
import { ReportMode } from '../../../shared/models/enums/report-mode.enum';
// import { OrderPendingService } from "../../../shared/services/order/order-pending.service";
import { PdfCreatorService } from "../../../shared/services/pdf-creator.service";
import { OrderInvoicedService } from "../../../shared/services/order/Order-Invoiced.service";
import { NavBarService } from "../../../core/sidebar/sidebar.service";

@Component({
  selector: "app-invoice-order",
  templateUrl: "./invoice-order.component.html",
  styleUrls: ["./invoice-order.component.css"]
})
export class InvoiceOrderComponent implements OnInit {

  @ViewChild("ReassignModel", { static: true }) ReassignModel: NgbModal;
  selectedDriver: any = {
    vehicleId: -1
  };
  allowInvoiceBeforeAssign = false;
  allowDispatch = false;
  checked: boolean = true;
  sharedTablesColumns = [];
  selectedOrders = [];
  territoryId = 0;
  orderDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Order_Date',
    formControlName: 'orderDate',
    isCalendarOnly: true,
    isRange: true
  };
  desiredDeliveryDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Desired_Delivery_Date',
    formControlName: 'desiredDeliveryDate',
    isCalendarOnly: true,
    isRange: true
  };
  orderLabel = this.translateService.instant('Desc_Order_Number') + ' / ' + this.translateService.instant('Desc_invoice_number');
  driverLabel = this.translateService.instant('Desc_Driver') + ' / ' + this.translateService.instant('Desc_Van_Barcode');
  selectedOrderDateRange: DateTimeModel[];
  selectedDesiredDeliveryDateRange: DateTimeModel[];
  clearCustomerSubject: Subject<void> = new Subject<void>();
  deliveryUsingInvan = false;
  isKeepDefualtMode = true;
  selectedSchdualeDateModel: DateTimeModel;
  forceLoadRequestForOrders = false;
  getEmployeesHavingOrdersFromInvoicedOrders = false;
  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: true,
    openFilterDirectly : false,
    rowOperations: [],
    isMultiSelection: false,
    specificActionWhenCheckRow: true,
    specificActionWhenCheckAll: true,
    multiSelectionOperations: [],
    columns: []
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  query: OrderListFilter = {
    customListFilter: {
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    orderOperation: OrderOperation.GetInvoiced,
    orderStatus: OrderStatus.Invoiced
  };
  allowPartialDelivery = false;
  AllowBatchSelectionInDelivery = false;
  affectMainWarehouseUponOrderBOInvoicing: boolean = false;
  affectVanStockInDeliveryInFO: boolean = false;
  foInvoiceFODelivery = false;
  boInvoiceBODelivery = false;
  boInvoiceFODelivery = false;
  assignOrdersForm: FormGroup;
  driverControl: any;
  scanByOrderOrInvoice = false;
  scanByDriverOrVan = false;
  allowViewAction = false;
  showOrderSlider = false;
  isBarcodeScan = false;
  isInvoiceOrderMode = true;
  // foInvoiceFODelivery=false;
  // boInvoiceBODelivery=false;
  // boInvoiceFODelivery=false;
  boInvoiceThirdPartyDelivery = false;
  //isPartialDelivery=false;
  deliverySliderTitle = 'Desc_Partial_Delivery';
  //isDelivery=false;
  //allowPartial=true;

  operationSummaryData: IOperationSummary = {
    operationData: {},
    formProcessMode: FormProcessMode.Orders,
    formTitle: "Desc_Order_Summary"
  };
  schduleDateProperties: IDateTimePickerProperties = {
    label: "Desc_Schedule_Date",
    formControlName: "schduleDate",
    min: new Date()
  };

  showViewSummarySlider = false;
  warehouseFilter: FormGroup;
  selectedOrder: any;
  modalRef: NgbModalRef;
  viewDriverFilter = false;
  @ViewChild("confirmDeliveryDate", { static: true }) confirmDeliveryDateModal: NgbModal;
  confirmDeliveryDateForm: FormGroup;
  selectedDeliveryDateModel: DateTimeModel;

  deliveryDateProperties: IDateTimePickerProperties = {
    label: "Desc_Delivery_Date",
    formControlName: "deliveryDate"
  };

  totalAssignedOrders = 0;
  totalNotAssignedOrders = 0;
  assignedOrdersDesc = this.translateService.instant('Desc_Total_Assigned_Orders');
  notAssignedOrdersDesc = this.translateService.instant('Desc_Total_Not_Assigned_Orders');
  assignedOrdersList = [];
  notAssignedOrdersList = [];
  showAssignedOrders = false;
  showNotAssignedOrders = false;
  assignOrder = false;
  loadingOrdes = true;
  invalidOrdersList = [];
  scannedTransIdOrderId = '';
  scannedNotTransIdOrderId = '';
  AllowReAssignInovicedOrders: boolean = false;
  ReassignForm: FormGroup;
  isFromReassignButton : boolean = false;
  isMultiReassign : boolean = false;

 /* @ViewChild('pdfFrame', { static: true }) pdfFrame: ElementRef;*/

  constructor(
    private coreSession: CoreSession,
    private modalService: NgbModal,
    private translateService: TranslateService,
    private sessionData: SessionDataProvider,
    private pdfCreatorService: PdfCreatorService,
    private orderInvoicedService: OrderInvoicedService,
    private navService : NavBarService
  ) { }

  showSharedTable: boolean = false

  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus}
    )

      this.showSharedTable = this.navService.tourStatus;

    this.coreSession.SetTitle("Invoicing");
    this.allowInvoiceBeforeAssign = JSON.parse(this.sessionData.getConfigurationValue('AllowInvoiceOrderBeforeAssignOrder').toString().toLowerCase())
      && this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicedOrdersURL, MenuActions.Dispatch);
    this.AllowReAssignInovicedOrders = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowReAssignInovicedOrders).toLowerCase() === "true";
    if (this.allowInvoiceBeforeAssign) {
      this.tableData.showSearchBtn = false;
      this.tableData.columns.push(
        { title: "Desc_Order_ID", key: "orderId", isSortable: true, width: "15%" },
        { title: "Desc_Customer", key: "customerCodeName", isSortable: false, width: "15%" },
        { title: "Desc_Outlet", key: "outletCodeName", isSortable: false, width: "25%" },
        { title: "Desc_Employee_Name", key: "employeeName", isSortable: false, width: "15%" },
        { title: "Desc_Order_Date", key: "orderDate", isSortable: true, width: "15%", isDate: true },
        { title: "Desc_Status", key: "orderStatusDescription", isSortable: false, width: "10%" })
    } else {
      this.tableData.columns.push(
        { title: "Desc_Order_ID", key: "orderId", isSortable: true, width: "15%" },
        { title: "Desc_Customer", key: "customerCodeName", isSortable: false, width: "15%" },
        { title: "Desc_Outlet", key: "outletCodeName", isSortable: false, width: "15%" },
        { title: "Desc_Employee_Name", key: "employeeName", isSortable: false, width: "15%" },
        { title: "Desc_Order_Date", key: "orderDate", isSortable: true, width: "15%", isDate: true },
        { title: "Desc_Schedule_Date", key: "scheduleDate", isSortable: true, width: "15%", isDate: true },
        { title: "Desc_Status", key: "orderStatusDescription", isSortable: false, width: "10%" })
    }
    this.initAsssignForm();

    if(this.AllowReAssignInovicedOrders)
     this.initReassignForm();

    this.deliveryUsingInvan =
      this.sessionData
        .getConfigurationValue(ConstantConfigurations.DeliveryMode)
        .toLowerCase().includes(DeliveryModes.BOInvoicingFODelivery.valueOf() + "") || this.sessionData
          .getConfigurationValue(ConstantConfigurations.DeliveryMode)
          .toLowerCase().includes(DeliveryModes.FOInvoicingAndDelivery.valueOf() + "");

    this.forceLoadRequestForOrders =
      this.sessionData
        .getConfigurationValue(ConstantConfigurations.ForceLoadRequestForOrders)
        .toLowerCase() === "true" && (
        (
          this.sessionData
            .getConfigurationValue(ConstantConfigurations.AffectVanStockInDeliveryInFO)
            .toLowerCase() === "true" && this.sessionData
              .getConfigurationValue(ConstantConfigurations.DeliveryMode)
              .toLowerCase().includes(DeliveryModes.BOInvoicingFODelivery.valueOf() + "")
        )
        || this.sessionData
          .getConfigurationValue(ConstantConfigurations.DeliveryMode)
          .toLowerCase().includes(DeliveryModes.FOInvoicingAndDelivery.valueOf() + "")
      );

    this.checked = this.allowInvoiceBeforeAssign;
    if (!this.allowInvoiceBeforeAssign)
      this.populateInvoicedOrderList();
    this.initConfigurations();
    this.initDeliveryForm();
    this.addActions();
    this.viewDriverFilter = JSON.parse(this.sessionData.getConfigurationValue('AllowInvoiceOrderBeforeAssignOrder').toString().toLowerCase());
    if(this.AllowReAssignInovicedOrders)
    this.viewDriverFilter = false;
    this.getEmployeesHavingOrdersFromInvoicedOrders = this.allowDispatch && this.allowInvoiceBeforeAssign;
  }

  focusOnDriver() {
    document.getElementById("orderInput").focus();
  }

  initAsssignForm() {
    let employeeId: number;
    let warehouseId: number;
    let customerId: number;
    let outletId: number;
    this.assignOrdersForm = new FormGroup({
      employeeId: new FormControl(employeeId, [Validators.required]),
      schduleDate: new FormControl({ value: "", disabled: true }),
      warehouseId: new FormControl(warehouseId, [Validators.required]),
      customerId: new FormControl(customerId, null),
      outletId: new FormControl(outletId, null),
      orderDate: new FormControl({ value: [] }),
      orderId: new FormControl(''),
      Driver: new FormControl(''),
      desiredDeliveryDate: new FormControl({ value: [] }),
    });

    if (!this.forceLoadRequestForOrders) {
      this.warehouseId.setValidators(null);
      this.warehouseId.updateValueAndValidity();
    }
  }
  initReassignForm() {
    this.ReassignForm = new FormGroup({
      employeeId: new FormControl(null, Validators.required)
    });
  }

  onResetAssignForm(evt) {
    this.assignOrdersForm.reset();
    this.territoryId = 0;
    this.selectedDesiredDeliveryDateRange = [];
    this.selectedOrderDateRange = [];
    this.query.driverId = -1;
    this.clearCustomerSubject.next();
    this.onFindButtonClicked(evt, '');
  }

  onEmployeeDataChanged(event) {

    if (event) {
      this.selectedDriver = event;
      this.query.driverId = this.selectedDriver.employeeId;
      this.territoryId = this.selectedDriver.territoryId;
    } else {
      this.selectedDriver = {};
      this.query.driverId = -1;
      this.territoryId = 0;
    }
    this.selectedOrders = [];
    this.onFindButtonClicked(event, '');
    this.warehouseId.setValue(null);
    this.warehouseId.updateValueAndValidity();
  }

  isDivisionLevel() {
    return (this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true")
  }
  initConfigurations() {
    this.allowPartialDelivery = this.sessionData
      .getConfigurationValue(ConstantConfigurations.AllowPartialDelivery)
      .toLowerCase() === 'true';
    this.AllowBatchSelectionInDelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowBatchSelectionInDelivery).toLowerCase() === "true";
    this.allowPartialDelivery = this.sessionData
      .getConfigurationValue(ConstantConfigurations.AllowPartialDelivery)
      .toLowerCase() === 'true';
    this.AllowBatchSelectionInDelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowBatchSelectionInDelivery).toLowerCase() === "true";
    this.boInvoiceThirdPartyDelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.DeliveryMode).includes(DeliveryModes.BOInvoicingThirdPartyDelivery.valueOf() + "");
  }
  initDeliveryForm() {
    this.confirmDeliveryDateForm = new FormGroup({
      deliveryDate: new FormControl(new Date(), Validators.required)
    });
  }
  onDeliveryDateSelected(event: any) {
    this.selectedDeliveryDateModel = event;

  }

  onCloseConfirmDeliveryDateModal() {
    this.modalRef.dismiss();

  }
  onConfirmDeliveryDateClicked() {
    let currenctDate = new Date();
    this.selectedDeliveryDateModel = new DateTimeModel();
    this.selectedDeliveryDateModel.year = currenctDate.getFullYear();
    this.selectedDeliveryDateModel.month = currenctDate.getMonth() + 1;
    this.selectedDeliveryDateModel.day = currenctDate.getDate();
    this.selectedDeliveryDateModel.hour = currenctDate.getHours();
    this.selectedDeliveryDateModel.minute = currenctDate.getMinutes();
    // this.coreSession.showError(
    //   this.0translateService.instant(ConstantMessages.ErrorCaption),
    //   this.translateService.instant(ConstantMessages.MsgSelectDate)
    // );
    //return;
    this.modalRef.dismiss();
    this.selectedOrder.desiredDeliveryDateModel = this.selectedDeliveryDateModel;
    this.InvoiceOrderClicked();
  }
  openConfirmDeliveryDateModal() {
    this.modalRef = this.modalService.open(this.confirmDeliveryDateModal, {
      centered: true
    });
  }
  InvoiceOrderClicked() {
    this.selectedOrder.orderOperation = OrderOperation.FullDelivery;
    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(ConstantMessages.DeliveryConfirmation),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.Delivery)
    ).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {

        this.isOrderValidToInvoice();

      }
    });


  }
  isOrderValidToInvoice() {
    this.selectedOrder.orderStatusFromUI = this.selectedOrder.orderStatus;
    this.coreSession.ModalLoading.Show();
    this.orderInvoicedService.isOrderValidToInvoice(this.selectedOrder).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.selectedOrder = response.data;

          this.InvoiceOrder();

        } else {
          this.selectedOrder = {};
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  InvoiceOrder() {

    this.coreSession.ModalLoading.Show();
    this.orderInvoicedService.deliveryOrder(this.selectedOrder).subscribe(
      response => {
        this.selectedOrder = {};
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.OrderDelivered)
          );
          this.populateInvoicedOrderList();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.selectedOrder = {};
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onFindButtonClicked(result, determineDate: string) {
    this.query.customListFilter.page = 0;
    if (this.isDivisionLevel())
      this.query.divisionId = result && result != undefined && result.divisionId ? result.divisionId : -1;
    else
      this.query.divisionId = -1;

    if (this.allowInvoiceBeforeAssign) {
      if (determineDate == '') {
        this.query.customerId = result != undefined && result.customerId ? result.customerId : -1;
        this.query.outletId = result != undefined && result.outletId ? result.outletId : -1;
      }
      if (result && result.length == 2 && determineDate == 'orderDate') {
        this.query.orderDateRange = result;
      } else if (result == undefined && determineDate == 'orderDate') {
        this.query.orderDateRange = [];
      }
      if (result && result.length == 2 && determineDate == 'desiredDelivery') {
        this.query.desiredDeliveryDateRange = result;
      } else if (result == undefined && determineDate == 'desiredDelivery') {
        this.query.desiredDeliveryDateRange = [];
      }


    } else {
      this.query.customerId = result != undefined && result.customerId ? result.customerId : -1;
      this.query.outletId = result != undefined && result.outletId ? result.outletId : -1;
      this.query.orderDateRange = result != undefined && result.transactionDate != undefined ? result.transactionDate : [];
      this.query.desiredDeliveryDateRange = result != undefined && result.secondDate != undefined ? result.secondDate : [];
    }

    if(this.AllowReAssignInovicedOrders){
      this.query.areaId = result.areaId;
      this.query.streetId = result.streetId;
      this.query.driverId = result.driverId;
      this.query.isFromReassignButton = this.isFromReassignButton;
    }

    if (!this.checked) {
      this.query.employeeId = !this.allowInvoiceBeforeAssign ? result.employeeId : -1;
    } else {
      this.query.employeeId = this.assignOrdersForm.get('employeeId').value != null ? this.assignOrdersForm.get('employeeId').value : -1;
    }

    if (this.query.driverId == -1)
      this.query.driverId = result != undefined ? !this.checked && this.allowInvoiceBeforeAssign ? result.employeeId : result.driverId : -1;
    this.populateInvoicedOrderList();
  }

  getOrdersByOrderIdOrInvoiceId(result) {
    this.scanByOrderOrInvoice = true;
    this.query.scanByOrderId = result.trim();
    this.assignOrder = true;
    this.isBarcodeScan = true;
    //this.invalidOrdersList.push(this.query.scanByOrderId);
    if (this.assignedOrdersList && this.assignedOrdersList.length > 0 && this.assignedOrdersList.includes(this.query.scanByOrderId)) {
      this.assignOrdersForm.get('orderId').setValue(null);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgOrderScanned)); return;
    } else {
      this.populateInvoicedOrderList();
    }
  }
  getOrdersByDriverOrVan(result) {
    this.scanByDriverOrVan = true;
    this.query.employeeCode = result.trim();
    this.totalAssignedOrders = 0;
    this.totalNotAssignedOrders = 0;
    this.assignedOrdersList = [];
    this.notAssignedOrdersList = [];
    this.assignOrder = false;
    this.isBarcodeScan = true;
    this.populateInvoicedOrderList();
  }


  populateInvoicedOrderList() {
    let scannedTransId = this.query.scanByOrderId;
    if (!this.allowInvoiceBeforeAssign || (this.allowInvoiceBeforeAssign && ((!this.isBarcodeScan && !this.checked) || (this.isBarcodeScan && this.assignOrdersForm.get('orderId').value != null && this.assignOrdersForm.get('orderId').value !== '' && this.assignOrdersForm.get('Driver').value != null && this.assignOrdersForm.get('Driver').value != '')))) {
      // if (!this.isBarcodeScan) {
      this.coreSession.ModalLoading.Show();
      //}
      if (this.assignOrdersForm.get('orderId').value != null && this.assignOrdersForm.get('orderId').value !== '') {
        document.getElementById("orderInput").blur();
      }
      if (this.assignOrder) {
        this.query.employeeCode = this.assignOrdersForm.get('Driver').value;
      }
      this.assignOrdersForm.get('orderId').setValue(null);
      if (this.allowInvoiceBeforeAssign) {
        document.getElementById("orderInput").focus();
      }
      this.orderInvoicedService.getOrders(this.query).subscribe(
        response => {
          this.coreSession.ModalLoading.Hide();
          if (this.assignOrdersForm.get('orderId').value != null && this.assignOrdersForm.get('orderId').value !== '' && this.allowInvoiceBeforeAssign)
            document.getElementById("orderInput").focus();
          if (response.status != null && response.status >= 0) {
            this.dataSource = <SharedTableResult>response.data;
            if (this.dataSource.data.length == 1) {
              this.assignOrder = false;
              let isDeliverdOrder = this.dataSource.data.find(x => x.orderStatusId == OrderStatus.Delivered.valueOf());
              let isOrderContainDriver = this.dataSource.data.find(x => x.driverId != -1 && x.driverId != 0);
              if (this.allowInvoiceBeforeAssign && this.isBarcodeScan) {
                if (isDeliverdOrder == undefined) {
                  if (isOrderContainDriver != undefined) {
                    this.scannedTransIdOrderId = scannedTransId;
                    this.assignOrdersWhenClickEnter();
                  }
                  else {
                    this.scannedNotTransIdOrderId = scannedTransId
                    this.assignOrdersWhenClickEnter();
                    this.coreSession.showWarrning(
                      this.translateService.instant(ConstantMessages.WarningCaption),
                      this.translateService.instant(ConstantMessages.MsgNoAssignedDriver)
                    );
                    return;
                  }
                } else {
                  this.assignOrdersForm.get('orderId').setValue(null);
                  this.scannedNotTransIdOrderId = scannedTransId
                  this.assignOrdersWhenClickEnter();
                  this.coreSession.showWarrning(
                    this.translateService.instant(ConstantMessages.WarningCaption),
                    this.translateService.instant('Desc_Cannot_Assign_Delivered_Orders')
                  );
                  return;
                }
              }
            } else {
              if (this.assignOrder) {

                if (this.isBarcodeScan) {
                  this.scannedNotTransIdOrderId = scannedTransId
                  this.assignOrdersWhenClickEnter();
                  this.coreSession.ModalDialog.ShowMessage(
                    this.translateService.instant('Desc_This_Transaction_Not_Found') + ' : ' + scannedTransId,
                    DialogMode.Ok, this.translateService.instant(ConstantMessages.WarningCaption)).then(
                      (result: DialogResult) => {
                        if (result === DialogResult.Ok) {
                        }
                      });
                } else {
                  this.scannedNotTransIdOrderId = scannedTransId
                  this.assignOrdersWhenClickEnter();
                }
                this.assignOrder = false;
              }
            }
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    }
  }
  addActions() {
    this.allowDispatch = this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicedOrdersURL, MenuActions.Dispatch);
    if (this.allowDispatch) {
      this.tableData.isMultiSelection = true;
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicedOrdersURL, MenuActions.Print)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.Print,
        title: 'Desc_Print',
        icon: 'fa-solid fa-print',
        color: '#12344d'
      });

      this.tableData.rowOperations.push({
        operation: RowOperation.downLoad,
        title: 'Desc_Download',
        icon: 'fa fa-download',
        color: '#12344d'
      });
    }


    this.allowViewAction = this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicedOrdersURL, MenuActions.View);
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicedOrdersURL, MenuActions.Void)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.delete,
        title: "Desc_Void",
        icon: "fa-solid fa-trash",
        color: "#f1685e",
        showWhenKeyValueTrue: true,
        showHideOptionPerLine: true,
        controlKeyName: "showVoidBtn"

      });
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicedOrdersURL, MenuActions.View)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.View,
        title: 'Desc_View',
        icon: 'fa-regular fa-eye',
        color: '#12344d'
      });

    }
    // if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicedOrdersURL, MenuActions.Delivery)) {
    //   if (this.allowPartialDelivery) {
    //     this.tableData.rowOperations.push({
    //       operation: RowOperation.partialDelivery,
    //       title: "Desc_Partial_Delivery",
    //       icon: "fa fa-truck",
    //       color: "#12344d",
    //       showWhenKeyValueTrue: true,
    //       showHideOptionPerLine: true,
    //       controlKeyName: "showPartialDeliveryBtn"
    //     });
    //   }
    // }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicedOrdersURL, MenuActions.Delivery)) {
      // if (this.boInvoiceThirdPartyDelivery) {
      // this.tableData.rowOperations.push({
      //   operation: RowOperation.delivery,
      //   title: "Desc_Confirm_Delivery",
      //   icon: "fa fa-calendar-check-o",
      //   color: "#12344d",
      //   showWhenKeyValueTrue: true,
      //   showHideOptionPerLine: true,
      //   controlKeyName: "showDeliveryBtn"
      // });
      // }
    }
    // if(this.AllowReAssignInovicedOrders){
    //   if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicedOrdersURL, MenuActions.Reassign)) {
    //     this.isFromReassignButton = true;
    //     this.tableData.rowOperations.push({
    //       operation: RowOperation.Reassign,
    //       title: 'Desc_Reassign',
    //       icon: 'fa fa-refresh',
    //       color: '#12344d',
    //       showWhenKeyValueTrue: true,
    //       showHideOptionPerLine: true,
    //       controlKeyName: "showReassignBtn"
    //     });

    //     this.tableData.multiSelectionOperations.push({
    //       operation: MultiSelectionOperation.Reassign,
    //       title: "Desc_Reassign",
    //       icon: "fa fa-refresh"
    //     });

    //     this.tableData.isMultiSelection = true;
    //   }
    // }

  }

  onTableFilterChanged(query: any) {
    if (this.loadingOrdes) {
      this.scanByOrderOrInvoice = false;
      this.scanByDriverOrVan = false;
      this.query.customListFilter = query;
      if (!this.isBarcodeScan)
        this.populateInvoicedOrderList();
      this.isBarcodeScan = false;
    }
  }


  onMultiSelectionOperation(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.Reassign:
        if (event.object.some(order => order.orderStatus !== OrderStatus.Invoiced)) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgCantReassignNotinvoicedorders));
          return;
        }
        this.openReassignModal(event.object , true);
        break;
    }
  }


  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.Print:
        this.exportReport(event, this.isInvoiceOrderMode);
        break;
      case RowOperation.downLoad:
        this.exportReport(event, this.isInvoiceOrderMode);
       // this.printPdf();
        break;
      case RowOperation.View:
        if (this.allowViewAction) {
          this.viewTransaction(event.object.orderSignature);
        }
        break;
      case RowOperation.approve:
        break;
      case RowOperation.delete:
        this.selectedOrder = event.object;
        this.coreSession.ModalDialog.ShowMessage(
          this.translateService.instant(ConstantMessages.MsgVoidConfirmation),
          DialogMode.YesNo,
          this.translateService.instant(ConstantMessages.WarningCaption)
        ).then((result: DialogResult) => {
          if (result === DialogResult.Yes) {
            this.isValidToVoidInvoice(event.operation);
          }

        }
        );
        break;
      case RowOperation.partialDelivery:
        this.coreSession.ModalDialog.ShowMessage(
          this.translateService.instant(ConstantMessages.DeliveryConfirmation),
          DialogMode.YesNo,
          this.translateService.instant(ConstantMessages.Delivery)
        ).then((result: DialogResult) => {
          if (result === DialogResult.Yes) {
            this.checkOrderStatusBeforeAnyAction(event);
          }
        }
        );
        break;
      case RowOperation.delivery:
        this.deliverySliderTitle = 'Desc_Delivery';
        this.selectedOrder = event.object;
        this.openConfirmDeliveryDateModal();
        break;
      case RowOperation.Reassign:
        var orders = []
        orders.push(event.object);
        this.selectedOrder = event.object;
        this.openReassignModal(orders , false);
        break;
    }

  }


  checkOrderStatusBeforeAnyAction(event) {
    this.coreSession.ModalLoading.Show();
    this.selectedOrder = event.object;
    this.selectedOrder.orderStatusFromUI = this.selectedOrder.orderStatus;
    this.orderInvoicedService.checkOrderStatusBeforeAnyAction(this.selectedOrder).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data) {
            if (event.operation == RowOperation.partialDelivery) {
              this.deliverySliderTitle = 'Desc_Partial_Delivery';
              this.selectedOrder = event.object;
              this.selectedOrder.orderStatusFromUI = this.selectedOrder.orderStatus;
              this.showOrderSlider = true;
            }
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),
              response.message
            );
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message

          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  //printPdf(): void {
  //  debugger;
  //  this.pdfCreatorService.generatePdf().subscribe((pdfBlob: Blob) => {
  //    const url = URL.createObjectURL(pdfBlob);
  //    this.pdfFrame.nativeElement.src = url;

  //    // Trigger the printing process
  //    this.pdfFrame.nativeElement.contentWindow.print();

  //    // Clean up the object URL after printing
  //    URL.revokeObjectURL(url);
  //  });
  //}
  exportReport(event: any, isInvoiceOrderMode) {
    var reportMode = ReportMode.Invoiced;
    if (event.object.orderStatus == OrderStatus.Invoiced) {
      reportMode = ReportMode.Invoiced;
    }
    if (event.object.orderStatus == OrderStatus.Delivered) {
      reportMode = ReportMode.Delivered;
    }
    let trans = {
      divisionId: event.object.divisionId ? event.object.divisionId : -1,
      transactionId: event.object.orderId,
      customerId: event.object.customerId,
      outletId: event.object.outletId,
      reportMode: reportMode,
      isReprintReport: true
    }
    this.pdfCreatorService.ExportReport(trans, event.operation, isInvoiceOrderMode, true, false);
  }

  assignOrderToDriver() {

    if (!this.isBarcodeScan) {
      this.coreSession.ModalLoading.Show();
    }
    this.loadingOrdes = false;
    this.orderInvoicedService.assignOrderToDriver(this.selectedOrders).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.OrderDispatched)
          );
          this.scanByDriverOrVan = false;
          this.assignOrdersForm.get('orderId').reset();
          if (this.allowInvoiceBeforeAssign)
            document.getElementById("orderInput").focus();
          this.query.scanByOrderId = null;
          this.dataSource = { totalItems: 0, data: [] };
          this.loadingOrdes = true;
          if (this.scanByOrderOrInvoice && this.scanByOrderOrInvoice) {
            this.query.scanByOrderId = '';
            this.query.employeeCode = '';
          }
        } else {
          if (this.isBarcodeScan && this.allowInvoiceBeforeAssign) {
            this.coreSession.ModalDialog.ShowMessage(
              this.translateService.instant('Desc_This_Transaction_Not_Found') + ' : ' + this.query.scanByOrderId,
              DialogMode.Ok, this.translateService.instant(ConstantMessages.WarningCaption)).then(
                (result: DialogResult) => {
                  if (result === DialogResult.Ok) { }
                });
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }

        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  viewTransaction(signature: string) {
    this.coreSession.ModalLoading.Show();
    let query: OrderListFilter = {};
    query.orderSignature = signature;
    query.isViewMode = true;
    query.orderOperation = OrderOperation.ViewInvoiced;
    this.orderInvoicedService.getInvoicedOrderForView(query).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.operationSummaryData = {
            operationData: response.data,
            formProcessMode: FormProcessMode.InvoiceOrder,
            formTitle: "Desc_Order_Summary"
          };
          var creationReason = this.operationSummaryData.operationData.creationReason;
          this.operationSummaryData.operationData.allowBatchesInItems = this.AllowBatchSelectionInDelivery && (creationReason === TransactionCreationReason.OrderManualDeliveryBOInvoice || creationReason === TransactionCreationReason.PartialDeliveryInBO);
          this.showViewSummarySlider = true;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  isValidToVoidInvoice(operation: RowOperation) {
    this.selectedOrder.orderStatusFromUI = this.selectedOrder.orderStatus;
    this.coreSession.ModalLoading.Show();
    this.orderInvoicedService.isValidToVoidInvoice(this.selectedOrder).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (operation != RowOperation.partialDelivery)
            this.VoidInvoice();
          else
            this.showOrderSlider = true;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message

          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  VoidInvoice() {
    this.coreSession.ModalLoading.Show();
    this.orderInvoicedService.voidOrderInvoice(this.selectedOrder).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.MsgVoidedSuccessfully)
          );
          this.populateInvoicedOrderList();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message

          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  assignOrdersWhenClickEnter() {
    this.selectedOrders = this.dataSource.data;
    if (this.selectedOrders.length === 0) {
      this.notAssignedOrdersList.push(this.scannedNotTransIdOrderId);
      this.totalNotAssignedOrders = this.notAssignedOrdersList.length;
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant('Desc_You_do_not_have_any_order')
      );
      return;
    }
    for (let order of this.selectedOrders) {
      order.orderStatusFromUI = order.orderStatus;
      if (this.isKeepDefualtMode) {
        let today = new Date();
        if (order.desiredDeliveryDateModel.date < today) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.DeliveryDateCantBeLessThanAssignment));
          return;
        }
        order.scheduleDateModel = order.desiredDeliveryDateModel;
      } else {
        order.scheduleDateModel = this.selectedSchdualeDateModel;
      }
      if (this.forceLoadRequestForOrders) {
        order.referenceWarehouseId = this.warehouseId.value == null ? -1 : this.warehouseId.value;
      }
    }
    for (let order of this.selectedOrders) {
      if (order.driverId != -1 && order.driverId) {
        this.assignOrderToDriver();
        this.scannedNotTransIdOrderId = '';
      }
    }
    this.dataSource.data = [];
    if (this.scannedTransIdOrderId != "") {
      this.assignedOrdersList.push(this.scannedTransIdOrderId);
      this.totalAssignedOrders = this.assignedOrdersList.length;
    }
    if (this.scannedNotTransIdOrderId != "") {
      this.notAssignedOrdersList.push(this.scannedNotTransIdOrderId);
      this.totalNotAssignedOrders = this.notAssignedOrdersList.length;
    }
    this.selectedOrders = [];
  }

  onCheckAllOperation(checkAll: boolean) {

    if (checkAll) {
      this.selectedOrders = this.dataSource.data.slice();
    } else {
      this.selectedOrders = [];
    }
  }

  onCheckRowOperation(object: any) {

    if (object.isChecked) {
      let orderChecked = this.selectedOrders.findIndex(a => a.orderId == object.orderId)
      if (orderChecked == -1) {
        this.selectedOrders.push({ ...object });
      }
    } else {
      let index = this.selectedOrders.findIndex(a => a.orderId == object.orderId);
      this.selectedOrders.splice(index, 1);
    }
  }

  assignOrders() {
    if (this.assignOrdersForm.get('Driver').value == '') {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant('Desc_Select_Driver')
      );
      return;
    }
    if (this.selectedOrders.length === 0) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant('Desc_Please_select_an_order')
      );
      return;
    }
    let validationToAssign = this.selectedOrders.find(x => x.orderStatusId == 9);
    if (!validationToAssign) {
      if (this.query.driverId != -1) {

        for (let order of this.selectedOrders) {
          order.orderStatusFromUI = order.orderStatus;
          if (this.isKeepDefualtMode) {
            let today = new Date();
            if (order.desiredDeliveryDateModel.date < today) {
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
                this.translateService.instant(ConstantMessages.DeliveryDateCantBeLessThanAssignment));
              return;
            }
            order.scheduleDateModel = order.desiredDeliveryDateModel;
          } else {
            order.scheduleDateModel = this.selectedSchdualeDateModel;
          }
          if (this.forceLoadRequestForOrders) {
            order.referenceWarehouseId = this.warehouseId.value == null ? -1 : this.warehouseId.value;
          }
          order.driverId = this.query.driverId
        }
        this.assignOrderToDriver();
        this.selectedOrders = [];
      } else {
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant('Desc_Select_Driver')
        );
        return;
      }
    } else {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant('Desc_Cannot_Assign_Delivered_Orders')
      );
      return;
    }

  }

  onFilterByBarcodeOrFilters(check: boolean) {
    this.checked = check;
    if (this.allowInvoiceBeforeAssign) {
      this.dataSource = { totalItems: 0, data: [] };
      if (!this.checked) {
        this.assignOrdersForm.get('Driver').setValue(null);
        this.assignOrdersForm.get('orderId').setValue(null);
        this.query.scanByOrderId = null;
        this.query.employeeCode = null;
        this.isBarcodeScan = false;
        this.populateInvoicedOrderList();
      }
    }
    document.getElementById('btn-clear').click();
  }

  onKeepDefualtClick() {

    this.isKeepDefualtMode = true;
    this.schduleDate.disable();
    this.schduleDate.setValue(null);
    this.schduleDate.clearValidators();
    this.schduleDate.updateValueAndValidity();
  }

  onRescheduleClick() {

    this.isKeepDefualtMode = false;
    this.schduleDate.enable();
    this.schduleDate.setValidators([Validators.required]);
    this.schduleDate.updateValueAndValidity();
  }
  onSchduleDateSelected(event: any) {
    this.selectedSchdualeDateModel = event;
  }



  closeOrderSlider() {
    this.showOrderSlider = false;
  }

  onSaveComplete() {
    this.closeOrderSlider();
    this.populateInvoicedOrderList();
  }
  closeViewSummarySlider() {
    this.operationSummaryData = null;
    this.showViewSummarySlider = false;
  }

  onOrderDateSelected(event: any) {
    if (event && event.length == 2) {
      this.selectedOrderDateRange = event;
    } else {
      this.selectedOrderDateRange = [];
    }
    this.onFindButtonClicked(event, 'orderDate');
  }

  onDesiredDeliveryDateSelected(event: any) {
    if (event && event.length == 2) {
      this.selectedDesiredDeliveryDateRange = event;
    } else {
      this.selectedDesiredDeliveryDateRange = [];
    }
    this.onFindButtonClicked(event, 'desiredDelivery');
  }

  showAssignOrders() {
    if (!this.showAssignedOrders) {
      if (this.totalAssignedOrders > 0) {
        this.showAssignedOrders = true;
      }
    } else {
      this.showAssignedOrders = false;
    }
  }

  showNotAssignOrders() {
    if (!this.showNotAssignedOrders) {
      if (this.totalNotAssignedOrders > 0) {
        this.showNotAssignedOrders = true;
      }
    } else {
      this.showNotAssignedOrders = false;
    }
  }

  openReassignModal(orders , isMultiReassign) {
    this.selectedOrders = [];
    this.selectedOrders = orders;
    this.isMultiReassign = isMultiReassign;
    this.modalRef = this.modalService.open(this.ReassignModel, {
      centered: true
    });
  }
  onCloseReassignModal() {
    this.modalRef.dismiss();
    this.ReassignForm.reset();
    this.selectedOrders = [];
    this.selectedOrder = [];
  }
  onSaveReassignClicked() {
    if (!this.ReassignForm.valid) {
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.SelectEmployee)
      );
      return;
    }
    this.reassignOrders();
  }

  reassignOrders(){
    if(this.selectedOrder){
      if(this.selectedOrder.driverId === this.ReassignForm.get('employeeId').value){
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgCantReassign));
        this.onCloseReassignModal();
        return;
      }
    }
    if(this.selectedOrders){
      if(this.isMultiReassign){
        let proceed = true;
        this.selectedOrders.forEach(order => {
          if(order.driverId === this.ReassignForm.get('employeeId').value){
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgCantReassign));
            this.onCloseReassignModal();
            proceed = false;
            return;
          }
        })
         if(!proceed)
         return;
      }
    }
    this.selectedOrders.forEach(order => {
      order.driverId = this.ReassignForm.get('employeeId').value != null ? this.ReassignForm.get('employeeId').value : -1;
      order.orderStatusFromUI = order.orderStatus;
    });
    this.coreSession.ModalLoading.Show();
    this.orderInvoicedService.reassignOrders(this.selectedOrders).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
           response.data.messageResult);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption),
           response.data.messageResult);
        }
        this.onCloseReassignModal();
        this.populateInvoicedOrderList();
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  get warehouseId() {
    return this.assignOrdersForm.get("warehouseId");
  }
  get schduleDate() {
    return this.assignOrdersForm.get("schduleDate");
  }




}
