import { EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { Component, OnInit } from '@angular/core';
import { FormControl } from '@angular/forms';
import { FormGroup } from '@angular/forms';
import { NgbModal, NgbModalConfig, NgbModalOptions } from '@ng-bootstrap/ng-bootstrap';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';

@Component({
  selector: 'app-last-invoice-dialog',
  templateUrl: './last-invoice-dialog.component.html',
  styleUrls: ['./last-invoice-dialog.component.css']
})
export class LastInvoiceDialogComponent implements OnInit {
  @ViewChild('lastInvoiceDialog', { static: true }) lastInvoiceDialog: any;
  @Input() lastInvoicePromotions: any[] = [];
  @Input() hideCloseButton: boolean = false;
  OkResult: DialogResult = DialogResult.Ok;
  CancelResult: DialogResult = DialogResult.Cancel;
  lastInvoiceForm: FormGroup;
  dropdownPromotionsSettings = {
    singleSelection: false,
    idField: 'promotionId',
    textField: 'promotionName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 2
  };
  ngbModalOptions: NgbModalOptions = {
    backdrop: 'static',
    keyboard: false
  };
  constructor(private modalService: NgbModal, private translateService: TranslateService) { }

  ngOnInit() {
    this.lastInvoiceForm = new FormGroup({
      selectedLastInvList: new FormControl()
    }
    );
    this.dropdownPromotionsSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropdownPromotionsSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);

  }
  public showDialog() {
    this.lastInvoiceForm.get('selectedLastInvList').setValue(null);
    return this.modalService.open(this.lastInvoiceDialog, { centered: true, backdrop: 'static' }).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          this.hideCloseButton = true;
          return this.lastInvoiceForm.get('selectedLastInvList').value;
        }
        if (result === DialogResult.Cancel) {
          this.hideCloseButton = false;
          //this.modalService.dismissAll();
          return -1; //;this.lastInvoiceForm.get('selectedLastInvList').value;
        }
        else {
          return -1;
        }
      });
  }
}
