import { Component, Input, OnInit, ViewChild } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { NgbModal, NgbModalOptions } from '@ng-bootstrap/ng-bootstrap';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';

@Component({
  selector: 'app-loyalty-dialog',
  templateUrl: './loyalty-dialog.component.html',
  styleUrls: ['./loyalty-dialog.component.css']
})
export class LoyaltyDialogComponent implements OnInit {

  @ViewChild('loyaltyDialog', { static: true }) loyaltyDialog: any;
  @Input() loyaltyPromotions: any[] = [];
  OkResult: DialogResult = DialogResult.Ok;
  CancelResult: DialogResult = DialogResult.Cancel;
  loyaltyForm: FormGroup;
  dropdownPromotionsSettings = {
    singleSelection: false,
    idField: 'promotionId',
    textField: 'promotionName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 2
  };
  ngbModalOptions: NgbModalOptions = {
    backdrop: 'static',
    keyboard: false
  };
  constructor(private modalService: NgbModal, private translateService: TranslateService) { }

  ngOnInit() {
    this.loyaltyForm = new FormGroup({
      selectloyaltyPromotions: new FormControl()
    }
    );
    this.dropdownPromotionsSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropdownPromotionsSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);

  }
  public showDialog() {
    return this.modalService.open(this.loyaltyDialog, { centered: true, backdrop: 'static' }).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          return this.loyaltyForm.get('selectloyaltyPromotions').value;
        }
        if (result === DialogResult.Cancel) {
          return -1; 
        }
        else {
          return -1;
        }
      });
  }
}
