import { Component, OnInit, ViewChild, Input, Output, EventEmitter, OnDestroy } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../core/core.session';
import { OrderService } from '../order.service';
import { IDateTimePickerProperties } from '../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../shared/models/dateTimeModel/date-time.model';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { TotalsModel } from '../../../shared/models/Item/totals.model';
import { HttpErrorResponse } from '@angular/common/http';
import { TakePromotionComponent } from '../../../shared/components/promotion/take-promotion/take-promotion.component';
import { ValidationService } from '../../../shared/services/validation.service';
import { TransationCommonData } from '../../../shared/models/transaction/transaction-common-data';
import { FormProcessMode } from '../../../shared/models/enums/form-process-mode.enum';
import { CalculationService } from '../../../shared/services/calculations.service';
import { OrderListFilter } from '../../../shared/models/shared-table/custom-list.interface';
import { OrderOperation } from '../../../shared/models/enums/order-operation .enum';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { NgbModal, NgbModalConfig, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { EmployeeService } from '../../employee/employee.service';
import { RecurringOrderComponent } from '../recurring-order/recurring-order.component';
import { DeliveryModes } from '../../../shared/models/enums/delivery-modes.enum';
import { OrderStatus } from '../../../shared/models/enums/order-status.enum';
import { ItemService } from '../../../shared/services/data-definition/product/item.service';
import { SalesRestrictionFilters } from '../../../shared/models/salesRestriction/sales-restriction-filter.model';
import { SalesRestrictionStockModel } from '../../../shared/models/salesRestriction/sales-restriction-stock.model';
import { SalesRestrictionModes } from '../../../shared/models/enums/sales-restrictions.enum';
import { InvalidSerialsComponent } from '../../../shared/components/Serials/invalid-serials/invalid-serials.component';
import { ImportDialogComponent } from '../../../shared/components/import-dialog/import-dialog.component';
import { SerialsPropertiesInterface } from '../../../shared/components/Serials/serials-properties.interface';
import { Subject, Subscription } from 'rxjs';
import { ReportMode } from '../../../shared/models/enums/report-mode.enum';
import { DocumentTypes } from '../../../shared/models/enums/document-types.enum';
import { LastInvoiceDialogComponent } from '../last-invoice-dialog/last-invoice-dialog.component';
import { OrderTypes } from '../../../shared/models/enums/order-types.enum';
import { ItemPackModel } from '../../../shared/models/Item/item.model';
import * as cloneDeep from 'lodash/cloneDeep';
import { LoyaltyDialogComponent } from '../loyalty-dialog/loyalty-dialog.component';
import { SalesItemRestrictionService } from '../../../shared/services/data-definition/product/sales-item-restriction.service';
import { OrderPendingService } from '../../../shared/services/order/order-pending.service';
import { OrderApprovedService } from '../../../shared/services/order/order-approved.service';
// import { OrderAssignedService } from '../../../shared/services/order/order-assigned.service';
import { ReturnAgainstInvoicesModel } from '../../../shared/models/ReturnFromInvoices/returnAgainstInvoices.model';
import { PromotionOutputDetailTypes } from '../../../shared/models/enums/promotion-output-detail-types.enum';
import { SharedDialogComponent } from '../../../shared/components/shared-dialog/shared-dialog.component';
import { SalesTransactionTypes } from '../../../shared/models/enums/sales-transaction-types';
import { PaymentModel } from '../../../shared/models/payment/payment.model';
import { TransactionModel } from '../../../shared/models/transaction/transaction.model';
import { PaymentTypes } from '../../../shared/models/enums/payment-types.enum';
import { ReturnBenefitCalculationMode } from '../../../shared/models/enums/benefitCalculationMode.enum';
import { PdfCreatorService } from '../../../shared/services/pdf-creator.service';
import { CustomerTypes } from '../../../shared/models/enums/customer-types.enum';
import { CustomerService } from '../../../shared/services/data-definition/customer/customers.service';
import { HeaderDiscountOperations } from '../../../shared/models/enums/header-discount-operations.enum';
import { DiscountValueTypes } from '../../../shared/models/enums/discount-value-types.enum';
import { EmailFileModel } from '../../../shared/models/email/email.model';
import { CollectionMethod } from '../../../shared/models/enums/collection-method-enum';
import { SalesModes } from '../../../shared/models/enums/sales.modes.enum';
import { ShepherdService } from 'angular-shepherd';
import { Router } from '@angular/router';
import { TourService } from '../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../shared/shepherd-config/trackTour.service';
@Component({
  selector: 'app-order-entry',
  templateUrl: './order-entry.component.html',
  styleUrls: ['./order-entry.component.css']
})
export class OrderEntryComponent implements OnInit , OnDestroy {

  //#region [DECLARATIONS]
  @Input("orderId") orderId = '';
  @Input('orderSignature') orderSignature = '';
  @Input('isEdit') isEdit: Boolean = false;
  @Input('isDelivery') isDelivery: Boolean = false;
  @Input('isNewOrder') isNewOrder: Boolean = false;
  @Input('isPartialDelivery') isPartialDelivery: Boolean = false;
  @Input('allowPartialOnDelivery') allowPartialOnDelivery: Boolean = false;
  @Input('deliveryFromApproved') deliveryFromApproved = false;
  @Input("orderStatusFromUI") orderStatusFromUI = OrderStatus.New;
  @Input('warehouseId') warehouseId = -1;
  @Input('showSSCC') showSSCC: boolean = false;
  @Output('onSaveComplete') onSaveComplete = new EventEmitter();
  @ViewChild('takePromotions', { static: true }) takePromotions: TakePromotionComponent;
  @ViewChild("warehouseSelection", { static: true }) warehouseSelection: NgbModal;
  @ViewChild("requiredPayment", { static: true }) requiredPayment: NgbModal;
  @ViewChild('import') import: ImportDialogComponent;
  @ViewChild("lastInvoiceDialog", { static: true }) lastInvoiceDialog: LastInvoiceDialogComponent;
  @ViewChild("loyaltyDialog", { static: true }) loyaltyDialog: LoyaltyDialogComponent;
  @ViewChild("promotionsAfterReturnDialog", { static: true }) promotionsAfterReturnDialog: SharedDialogComponent;
  @ViewChild("salesModeSelection", { static: true }) salesModeSelectionDialog: SharedDialogComponent;
  @ViewChild("ContractedFOCDialog", { static: true }) contractedFOCDialog: SharedDialogComponent;
  @ViewChild("HeaderDiscountDialog", { static: true }) headerDiscountDialog: SharedDialogComponent;
  @Input('isThereAnyWholeSalePromotion') isThereAnyWholeSalePromotion = false;
  @Input('isThereDynamicSalesAmount') isThereDynamicSalesAmount = false;
  @Input('achievementPromotions') achievementPromotions: any[] = [];
  @Input('order') order: any = {};
  @Input('isProcessReturn') isProcessReturn: Boolean = false;
  @Input('isAddBundle') isAddBundle: boolean = false;
  warehouseForm: FormGroup;
  oldTransactionId = '';
  blockedCustomerItems: any[] = [];
  blockedCustomerItemsGroup: any[] = [];
  blockedEmployeeItems: any[] = [];
  blockedEmployeeItemsGroup: any[] = [];
  salesRestrictionEmployeeLimit: number = 0;
  salesRestrictionCustomerLimit: number = 0;
  isEmployeeExceedsLimit: boolean = false;
  isCustomerExceedsLimit: boolean = false;
  modalRef: NgbModalRef;
  isLoading = true;
  hideBackButton = false;
  showBatches = false;
  isHideLoadingInItems: boolean = true;
  showSummary: boolean = false;
  showItems: boolean = false;
  showItemsSection: boolean = false;
  showTakePromotions: boolean = false;
  disableHeader = false;
  itemProcessMode = FormProcessMode.Orders;
  hasLoyalityPromotion = false;
  isBundle: boolean = false;
  attachedFiles: EmailFileModel[];
  customerPromotions: any[] = [];
  copyCustomerPromotions: any[] = [];
  orderBundles: any[] = [];
  promotionGroupLevels: any[] = [];
  relatedToTargetPromotions: any[] = [];
  lastInvoicePromotions: any[] = [];
  loyaltyPromotions: any[] = [];
  numOfAllDynamicPromotions = 0;
  unSatisfiedTargetPromotions: any[] = [];
  unSatisfiedDynamicAmountPromotions: any[] = [];
  transactionCommonData: TransationCommonData;
  salesRestrictionFilter: SalesRestrictionFilters;
  salesRestrictionStockData: SalesRestrictionStockModel;
  salesRestrictionStockDataGroup: SalesRestrictionStockModel;
  orderForm: FormGroup;
  desiredDeliveryDate: DateTimeModel;
  hideCloseButton = false;
  paymentForm: FormGroup;


  totals: TotalsModel = new TotalsModel();
  desiredDeliveryDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Desired_Delivery_Date',
    formControlName: 'desiredDeliveryDate',
  };

  affectMainWarehouseUponOrderBOInvoicing: boolean = false;
  affectVanStockInDeliveryInFO: boolean = false;

  isSalesRestrictionSalesOrderIncluded: boolean = false;
  isSalesRestrictionFOCTransactionsIncluded: boolean = false;

  boInvoiceBODelivery = false;
  boInvoiceFODelivery = false;
  foInvoiceFODelivery = false;
  createComplementaryOrder = false;
  recalculatePromotionInDelivery = false;
  considerCurrentPromotionsInDelivery = false;
  promotionCalculationSequence = 0;
  allowCustomerRefMode = -1;
  enableSelectEmployeeForOrderInBO: any;
  checkEmployeeCustomersInOrders: any;
  DeductPendingOrdersFromAvailableCredit: any;
  allowTax: any;
  allowRetailTaxOnItems = false;
  preventContinueWhenPaymentTermsExceededOnOrders: any;
  preventContinueWhenCreditLimitExceededOnOrders: any;
  showCustomerRouteEmployees = false;
  applyLPONumber = false;
  AllowWarehouseSelectionInPendingOrders = false;
  CustomerRouteEmployeesDataSource: any[];
  isEmployeeLoading = false;
  employeeFilter = {
    employeeTypes: [],
    customerId: -1,
    outletId: -1
  };
  isOddWeek = false;
  //Recurring Declaration
  recurringObj: any;
  enableRecurring = false;
  @ViewChild('RecuringOrder') RecuringOrder: RecurringOrderComponent;
  invalidSerials = [];
  @ViewChild("invalidSerialsDialog", { static: true }) invalidSerialsDialog: InvalidSerialsComponent;
  isCreditLimitExceededOnCreate = false;
  showTax = false;
  showRetailTax = false;
  noteWidth: number = 9;
  noteString: string;

  serialsProperties: SerialsPropertiesInterface;
  addedSerialsForAllPacks = [];
  promotionSerialItems = [];
  saveSerialsSubjectBySerialNo: Subject<void> = new Subject<void>();
  showAddItemsBySerial = false;
  showPromotionSerials = false;

  employeeSalesRestrictionItemGroup: any = [];
  totalItemsForEmployeeSalesRestrictionForItemGroup: any = [];
  customerSalesRestrictionItemGroup: any = [];
  totalItemsForCustomerSalesRestrictionForItemGroup: any = [];
  totalItemsInItemGroupEmployeeSalesRestriction: any = [];
  totalItemsInItemGroupCustomerSalesRestriction: any = [];
  promotionsNames: string = '';
  showOrderId = false;
  lastPromotion: boolean = false;
  currentLevelId = 1;
  nextLevelId = 1;
  nextSubject: Subject<void> = new Subject<void>();

  salesOrderTypesDataSource: any[] = [];
  isOrderTypeLoading: boolean = false;
  returnOrderItems: ItemPackModel[] = [];
  selectedOrderTypeId: number = OrderTypes.Sales.valueOf();
  returnReasonDescriptions: any[] = [];
  allowBatchSelectionInDelivery: boolean = false;
  originalOrderPromotedItems: any[] = [];
  restrictReturnFromInvoices: boolean = false;
  restrictReturnQtyFromInvoices: boolean = false;
  forceReturnWithSoldPrice: boolean = false;
  pack: ItemPackModel;
  showTaxInReturn: boolean = false;
  calculateTaxBeforeDiscount: boolean = false;
  promotionsAfterReturnList: any[] = [];
  saveAfterReturnPromotionsSubj: Subject<string> = new Subject<string>();
  // customerBatchesList: any[] = []; // will not be used anymore.
  customerItemBatchesList: any[] = [];
  transactionsIncludedInBenefit: any[] = [];
  copyOfTransactionsIncludedInBenefit: any[] = [];
  forcedToReturnItems: any[] = [];
  recalculateBenefitOnReturn: boolean = false;
  forcedToReturnPackLevel: any[] = [];
  itemPackReturnDiscount: any[] = [];
  totalRequiredPaymentFromAllItems: number = 0;
  allPromotionRanges: any[] = [];
  trueNetTotal: number = 0;
  payment: PaymentModel;
  debitTransaction: TransactionModel;
  returnBenefitMode: ReturnBenefitCalculationMode = ReturnBenefitCalculationMode.None;
  returnedBenefitModes: ReturnBenefitCalculationMode[] = [];
  isAffectedByProductDiscount: boolean = false;
  allReturnOrderItems: any[] = [];
  productDiscountPromotions: any[] = [];
  forcedToReturnPackLevel1: any[] = []; // from Product discount promotions of qty benefit
  forcedToReturnPackLevel2: any[] = []; // from Product discount promotions of disc or qty benefit
  productDiscountItemsList: any[] = [];
  tempForcedToReturnPack: any[] = [];
  allBenefitsDiscounts: any[] = [];
  allItemsReturnedAsDisc: any[] = [];
  rangesList: any[] = [];
  allowConversion: boolean = false;
  allowTaxOverFreeItems: boolean = false;
  includeTaxInProductDiscount: boolean = false;
  applyRoundingPerLine: boolean = false;
  productDiscountCalculationMode: number = -1;
  cachedOrderItems: any[] = [];
  returnProdDiscBenefitHistory: any[] = [];
  showOrderSourceSelection: boolean = false;
  orderSourcesDataSource: any[] = [];
  isOrderSourceLoading: boolean = false;
  selectedOrderSourceId = -1;
  allowOptionalReturnFromInvoices: boolean = false;
  selectedCustomerTypeId: number = -1;
  selectedSalesMode: number = -1;
  allowSalesModeSelectionInOrder: boolean = false;
  enableSalesDistributionChannel: boolean = false;
  selectedCustomerSDCs: any[] = []; // Sales Distribution Channels
  showSDCSelection: boolean = false; // if enableSalesDistributionChannel AND customer is linked to multiple SDCs
  isSDCLoading: boolean = false;

  //#region [Contacted FOC]
  contractedFOCSaveCaption: string = this.translateService.instant("Desc_Yes");
  contractedFOCNOCaption: string = this.translateService.instant("Desc_No");
  showTakeContractedFOC: boolean = false;
  eligibleContractedFOCs: any[] = [];
  //#endregion

  applyHeaderDiscountOnSalesOrders: boolean = false;
  applyHeaderDiscountOnSales: boolean = false;
  headerDiscountList: any[] = [];
  allowEditHeaderDiscount: boolean = false;
  headerDiscountTypeId: number = DiscountValueTypes.Percentage.valueOf();
  headerDiscountPercentage: number = 0;
  headerDiscountForm: FormGroup;
  isHeaderDiscountValueChanged: boolean = false;
  employeeId: number = -1;
  resetValues: EventEmitter<number> = new EventEmitter();
  allowCollectionMethodSelection: boolean = false;
  isCollectionMethodLoading: boolean = false;
  collectionMethodList: any[];
  showCollectionMethodSelection: boolean = false;
  showCollectionMethodSelectionInSalesModeSelection: boolean = false;
  selectedCollectionMethodId: number = CollectionMethod.None.valueOf();
  itemsList: ItemPackModel[] = [];
  showAccountInfoInTotal: boolean = false;
  creditLimit: number = 0;
  usedCredit: number = 0;
  orginalBalance: number = 0;
  //#endregion

  //#region [Initialization]
  constructor(
    public coreSession: CoreSession,
    private orderService: OrderService,
    private translateService: TranslateService,
    private validationService: ValidationService,
    private calculationService: CalculationService,
    private sessionData: SessionDataProvider,
    private config: NgbModalConfig,
    private modalService: NgbModal,
    private employeeService: EmployeeService,
    private itemService: ItemService,
    private pdfCreatorService: PdfCreatorService,
    private salesItemRestrictionService: SalesItemRestrictionService,
    private orderPendingService: OrderPendingService,
    private orderApprovedService: OrderApprovedService,
    // private orderAssignedService: OrderAssignedService,
    private customerService: CustomerService,
    private router:Router,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) {
    this.transactionCommonData = new TransationCommonData();
    this.totals = new TotalsModel();
  }
  ngOnDestroy(): void {
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
     }
     this.componentVisitService.markComponentVisited('order-entry');

    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }

  }

startTour(forceTour?){
  this.tourStartTimeout =  setTimeout((data=>{

    if(!forceTour)
    if (this.tourService.isTourCompletedForComponent('order-entry')) {
      return;
}

if(this.tourService.isFirstTour() || forceTour){
  const elementSelectors = ['#orderId-def','#customer-def',
    ,'#order-date-def','#LPO-def','#Notes-def','#Submit-def'
    ]; // Target each column by its unique ID
    const titles = [];
    const texts = [];
    for (let index = 0; index < elementSelectors.length; index++) {
      const { title, text } = this.getTitleAndText(index);
      titles.push(title);
      texts.push(text);
    }
    const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
    this.tourService.defaultStepOptions.scrollTo=false;
    this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
    this.shepherdService.modal = true;
    this.shepherdService.addSteps(steps);
    this.shepherdService.start();
  }
  }),1000)

}
  private tourStartTimeout: any;
  ngAfterViewInit() {
    this.startTour()

  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Desc_Order";
        text = 'Desc_Order_ID';
        break;
      case 1:
        title = "Desc_Customer";
        text = "Desc_Select_Customer";
        break;
        case 2:
          title = "Desc_Outlet";
          text = "Desc_Select_Outlet";
          break;
          case 3:
        title = "Desc_Desired_Delivery_Date";
        text = "Desc_Select_Desired_Delivery_Date";
        break;
      case 4:
        title = "Desc_LPO";
        text = "Desc_Enter_LPO";
        break;
        case 5:
          title = "Desc_Note";
        text = "Desc_content_Note";
        break;
        case 6:
          title = "Desc_Submit";
          text = "Desc_Submit";
          break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
      }

    return { title, text };
  }
  private tourSubscription: Subscription;
  ngOnInit() {

    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
      this.startTour(true);
    });
    this.fillOrderTypeDataSource();
    // customize default values of modals used by this component tree
    //  this.config.backdrop = "static";
    //  this.config.keyboard = false;
    if (this.isEdit) {
      // this.getReturnReasonDescriptions();
      if (this.isProcessReturn) {
        var processDescription = this.translateService.instant('Desc_Process_Return');
        this.coreSession.SetTitle(processDescription);
      } else {
        this.coreSession.SetTitle('Edit Order');
      }
    } else {
      this.coreSession.SetTitle('Add New Order');
      this.desiredDeliveryDateProperties.min = new Date();
    }
    if (this.isDelivery) {
      this.itemProcessMode = FormProcessMode.Delivery;
      //  this.initWarehouseForm();

    }
    if (this.isPartialDelivery) {
      this.itemProcessMode = FormProcessMode.PartialDelivery;
      //this.initWarehouseForm();
    }
    if (this.isProcessReturn) {
      this.itemProcessMode = FormProcessMode.ProcessReturn;
      this.initWarehouseForm();
    }
    this.initConfigurationsValue();
    this.fillOrderSourceDataSource();
    if (this.allowCollectionMethodSelection)
      this.fillCollectionMethod();
    if (this.isEdit) {
      // this.fillOrderPropertiesInAddMode();
      // this.initForm();
      this.isLoading = false;
      //  this.coreSession.ModalLoading.Hide();

      if (this.isDelivery && this.order) {
        this.isLoading = false;
        if (this.order.isBundle) {
          this.isBundle = true;
        }
        this.fillUIDataFromOrder();
      } else {
        this.fillOrderDataInEditMode();
      }
      this.enableRecurring = true;
    }
    else {
      this.fillOrderPropertiesInAddMode();
      this.isLoading = false;

      this.enableRecurring = true;
      this.initForm();
    }

    if (this.enableSelectEmployeeForOrderInBO)
      this.noteWidth = this.noteWidth - 3;
    if (this.isDivisionLevel())
      this.noteWidth = 3;
    if (this.allowCustomerRefMode != 0)//hhere to check isCustomerRefExist
      this.noteWidth = this.noteWidth - 3;
    if (!this.isDivisionLevel())
      this.noteWidth = 6
    if (this.applyDivisionsOnDocumentSequence())
      this.noteWidth = 6


    this.noteString = "col-md-" + this.noteWidth + '';

    if (!this.applyDivisionsOnDocumentSequence())
      this.showOrderId = true;
    if (this.order && this.order.promotedItems && this.isDelivery && !this.isPartialDelivery)
      this.originalOrderPromotedItems = this.order.promotedItems;
  }

  initForm() {
    this.orderForm = new FormGroup({
      desiredDeliveryDate: new FormControl({ value: this.desiredDeliveryDate ? this.desiredDeliveryDate.date : null, disabled: false }, Validators.required),
      remarks: new FormControl(this.order.remarks),
      orderNumber: new FormControl({ value: this.order.orderId, disabled: true }),
      customerId: new FormControl({ value: this.order.customerId, disabled: this.isEdit }, this.isEdit ? null : Validators.required),
      outletId: new FormControl({ value: this.order.outletId, disabled: this.isEdit }, this.isEdit ? null : Validators.required),
      employeeId: new FormControl({ value: this.order.employeeId, disabled: this.isEdit }, (this.isEdit || !this.enableSelectEmployeeForOrderInBO) ? null : Validators.required),
      divisionId: new FormControl({ value: this.order.divisionId, disabled: this.isEdit }, (!this.isEdit && this.isDivisionLevel()) ? Validators.required : null),
      lpo: new FormControl({ value: this.order.lpo, disabled: this.isEdit }, (!this.isEdit && this.applyLPONumber) ? Validators.required : null),
      paymentTermId: new FormControl({ value: this.order.paymentTermId, disabled: true }),
      customerRef: new FormControl({ value: this.order.customerRef, disabled: this.isEdit }, (!this.isEdit && this.allowCustomerRefMode == 2) ? Validators.required : null),
      orderTypeId: new FormControl({ value: this.order && this.order.orderTypeId > -1 ? this.order.orderTypeId : OrderTypes.Sales.valueOf(), disabled: this.isEdit }, Validators.required),
      orderSourceId: new FormControl({ value: this.order && this.order.orderSourceId > -1 ? this.order.orderSourceId : null, disabled: this.isEdit }, this.showOrderSourceSelection ? Validators.required : null),
      salesMode: new FormControl({}),
      sdcId: new FormControl({ value: this.enableSalesDistributionChannel && this.order && this.order.sdcId > 0 ? this.order.sdcId : null }, null),
      collectionMethodId: new FormControl({ value: this.order && this.order.collectionMethod && this.order.collectionMethod > 0 ? this.order.collectionMethod : null, disabled: this.isEdit }, (this.showCollectionMethodSelection || this.showCollectionMethodSelectionInSalesModeSelection) ? Validators.required : null),
      warehouseId: new FormControl({ value: this.order.warehouseId, disabled: this.isEdit }, (this.AllowWarehouseSelectionInPendingOrders && ((this.order && this.order.orderTypeId > -1) ? this.order.orderTypeId : OrderTypes.Sales.valueOf()) == OrderTypes.Sales.valueOf()) ? Validators.required : null),
    });
  }

  initConfigurationsValue() {
    this.AllowWarehouseSelectionInPendingOrders = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowWarehouseSelectionInPendingOrders).toLowerCase() === "true";
    this.applyRoundingPerLine = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyRoundingOnCalculations).toLowerCase() === "true";
    this.allowTaxOverFreeItems = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowTaxOverFreeItems).toLowerCase() === 'true';
    this.enableSelectEmployeeForOrderInBO = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSelectEmployeeForOrderInBO).toLowerCase() === 'true';
    this.checkEmployeeCustomersInOrders = this.sessionData.getConfigurationValue(ConstantConfigurations.CheckEmployeeCustomersInOrders).toLowerCase() === 'true';
    this.DeductPendingOrdersFromAvailableCredit = this.sessionData.getConfigurationValue(ConstantConfigurations.DeductPendingOrdersFromAvailableCredit).toLowerCase() === 'true';
    this.createComplementaryOrder = this.sessionData.getConfigurationValue(ConstantConfigurations.CreateComplementaryOrder).toLowerCase() === 'true';
    this.allowTax = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowTax).toLowerCase();
    this.allowRetailTaxOnItems = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowRetailTaxOnItems).toLowerCase() == 'true';
    this.preventContinueWhenPaymentTermsExceededOnOrders = this.sessionData.getConfigurationValue(ConstantConfigurations.PreventContinueWhenPaymentTermsExceededOnOrders).toLowerCase();
    this.preventContinueWhenCreditLimitExceededOnOrders = this.sessionData.getConfigurationValue(ConstantConfigurations.PreventContinueWhenCreditLimitExceededOnOrders).toLowerCase();
    this.recalculatePromotionInDelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.RecalculatePromotionInDelivery).toLowerCase() === 'true';
    this.promotionCalculationSequence = +this.sessionData.getConfigurationValue(ConstantConfigurations.PromotionCalculationSequence);
    this.considerCurrentPromotionsInDelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.ConsiderCurrentPromotionsInDelivery).toLowerCase() === 'true';
    this.applyLPONumber = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyLPONumber).toLowerCase() == 'true';
    this.isSalesRestrictionSalesOrderIncluded = this.sessionData.getConfigurationValue(ConstantConfigurations.SaleRestrictionCalculationMode).toLowerCase().includes(SalesRestrictionModes.SalesOrders.valueOf() + "");
    this.isSalesRestrictionFOCTransactionsIncluded = this.sessionData.getConfigurationValue(ConstantConfigurations.SaleRestrictionCalculationMode).toLowerCase().includes(SalesRestrictionModes.FOCTransactions.valueOf() + "");
    this.allowCustomerRefMode = Number(this.sessionData.getConfigurationValue(ConstantConfigurations.AllowCustomerRefMode));
    this.boInvoiceBODelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.DeliveryMode).toLowerCase().includes(DeliveryModes.BOInvoicingAndDelivery.valueOf() + "");
    this.boInvoiceFODelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.DeliveryMode).toLowerCase().includes(DeliveryModes.BOInvoicingFODelivery.valueOf() + "");
    this.foInvoiceFODelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.DeliveryMode).toLowerCase().includes(DeliveryModes.FOInvoicingAndDelivery.valueOf() + "");
    this.calculateTaxBeforeDiscount = this.sessionData.getConfigurationValue(ConstantConfigurations.CalculateTaxBeforeDiscounts).toLowerCase() === "true";
    this.allowConversion = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowConversionInPromotion).toLowerCase() === "true";
    this.includeTaxInProductDiscount = this.sessionData.getConfigurationValue(ConstantConfigurations.IncludeTaxInProductDiscount).toLowerCase() === "true";
    if ((this.boInvoiceFODelivery || this.foInvoiceFODelivery)
      && this.sessionData.getConfigurationValue(ConstantConfigurations.AutoDispatchOrder).toLowerCase() === 'true') {
      this.showCustomerRouteEmployees = true;
    }

    this.affectVanStockInDeliveryInFO = this.sessionData.getConfigurationValue(ConstantConfigurations.AffectVanStockInDeliveryInFO).toLowerCase() === "true";
    this.affectMainWarehouseUponOrderBOInvoicing = this.sessionData.getConfigurationValue(ConstantConfigurations.AffectMainWarehouseUponOrderBOInvoicing).toLowerCase() === "true";
    this.allowBatchSelectionInDelivery =
      this.sessionData
        .getConfigurationValue(
          ConstantConfigurations.AllowBatchSelectionInDelivery
        )
        .toLowerCase() === "true";
    this.restrictReturnFromInvoices =
      this.sessionData.getConfigurationValue(ConstantConfigurations.RestrictReturnFromInvoices).toLowerCase() === "true";
    this.restrictReturnQtyFromInvoices =
      this.sessionData.getConfigurationValue(ConstantConfigurations.RestrictReturnQtyFromInvoices).toLowerCase() === "true";

    this.forceReturnWithSoldPrice =
      this.sessionData
        .getConfigurationValue(
          ConstantConfigurations.ForceReturnWithSoldPrice
        )
        .toLowerCase() === "true";
    this.recalculateBenefitOnReturn = this.sessionData.getConfigurationValue(ConstantConfigurations.RecalculateBenefitOnReturn).toLowerCase() === "true";
    this.productDiscountCalculationMode = parseInt(this.sessionData.getConfigurationValue(ConstantConfigurations.ProductDiscountCalculationMode));
    this.showOrderSourceSelection = this.sessionData.getConfigurationValue(ConstantConfigurations.ShowOrderSourceSelectionInOrderCreation).toLowerCase() === "true";
    this.allowOptionalReturnFromInvoices = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowOptionalReturnFromInvoices).toLowerCase() === "true";
    this.allowSalesModeSelectionInOrder = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSalesModeSelectionInOrder).toLowerCase() === "true";
    this.enableSalesDistributionChannel = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSalesDistributionChannel).toLowerCase() === "true";
    var headerDiscountOperations = this.sessionData.getConfigurationValue(ConstantConfigurations.HeaderDiscountOperations);
    if (headerDiscountOperations) {
      this.applyHeaderDiscountOnSalesOrders = headerDiscountOperations.split(',').map(x => parseInt(x)).includes(HeaderDiscountOperations.SalesOrders.valueOf());
      this.applyHeaderDiscountOnSales = headerDiscountOperations.split(',').map(x => parseInt(x)).includes(HeaderDiscountOperations.Sales.valueOf());
    }
    this.allowEditHeaderDiscount = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowEditHeaderDiscount).toLowerCase() === "true";
    this.allowCollectionMethodSelection = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowCollectionMethodSelection).toLowerCase() === "true";
  }

  onNextClick() {
    this.nextSubject.next()
  }
  fillCollectionMethod() {
    this.isCollectionMethodLoading = true;
    this.collectionMethodList = [
      { collectionMethodId: CollectionMethod.DeliveryPerson, collectionMethod: this.translateService.instant("Desc_Delivery_Person") },
      { collectionMethodId: CollectionMethod.SalesPerson, collectionMethod: this.translateService.instant("Desc_Sales_Person") },
    ]
    this.isCollectionMethodLoading = false;
  }
  fillOrderDataInEditMode() {
    // this.coreSession.ModalLoading.Show();
    let query: OrderListFilter = {};
    query.orderSignature = this.orderSignature;
    if (this.isDelivery || this.isPartialDelivery) {
      if (this.order.warehouseTransactionId) {

        this.desiredDeliveryDateProperties.label = 'Desc_Delivery_Date';
      }
      if (this.deliveryFromApproved || this.isDelivery)
        query.orderOperation = OrderOperation.FullDelivery;
      else if (this.isPartialDelivery)
        query.orderOperation = OrderOperation.PartialDelivery;
      else
        query.orderOperation = OrderOperation.GetAssigned;
    }
    this.orderPendingService.getOrder(query).subscribe(
      response => {

        if (response.status != null && response.status >= 0) {
          this.order = response.data;
          this.isBundle = response.data.isBundle;
          this.fillUIDataFromOrder();
          this.isLoading = false;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );

  }
  fillUIDataFromOrder() {
    if (!this.order.isRestrictedFromOldInvoices) {
      this.restrictReturnFromInvoices = false;
      this.restrictReturnQtyFromInvoices = false;
      this.recalculateBenefitOnReturn = false;
    }
    this.order.isTaxeableOutlet = this.order.outlet.taxable;
    this.order.orderSignature = this.orderSignature;
    this.oldTransactionId = this.order.transactionId;
    if (this.order.isTaxeableOutlet && this.allowTax === "true") {
      this.showTax = true;
      if (this.allowRetailTaxOnItems) {
        this.showRetailTax = true;
      }
      if (this.order && this.order.oderTypeId == OrderTypes.Return.valueOf() && this.restrictReturnFromInvoices) {
        this.showTaxInReturn = true;
      }
    }
    this.desiredDeliveryDate = this.order.desiredDeliveryDateModel;
    this.desiredDeliveryDateProperties.dateValue = this.desiredDeliveryDate;
    this.order.isEditMode = true;
    this.order.orderOperation = OrderOperation.EditValues;
    if (this.checkEmployeeCustomersInOrders)
      this.employeeId = this.order.employeeId;
    if (this.isDelivery) {
      this.order.warehouseId = this.warehouseId;
    }
    this.initForm();
    if (this.allowCollectionMethodSelection && this.selectedOrderTypeId != OrderTypes.Return.valueOf() && this.order.outlet.customerTypeId == CustomerTypes.CashCustomer.valueOf()) {
      this.showCollectionMethodSelection = true;
      this.collectionMethodIdControl.setValidators(Validators.required)
      this.collectionMethodIdControl.updateValueAndValidity();
    }
    if (this.enableSalesDistributionChannel && this.order) {
      var data = {
        customerId: this.order.customerId ? this.order.customerId : -1,
        outletId: this.order.outletId ? this.order.outletId : -1
      };
      this.getSelectedCustomerSDCs(data, true);
    }

    if (this.showSSCC) {
      this.disableHeaderData();
    } else {
      if (this.isBundle) {
        this.showBundlesAndDisableHeaderData();
      } else {
        this.showItemsAndDisableHeaderData();
      }
    }

    this.transactionCommonData = new TransationCommonData();
    this.transactionCommonData.outlet = this.order.outlet;
    this.fillTransactionCommonData();
    this.isCreditLimitExceededOnCreate = false;
    this.isOddWeek = this.order.isOddWeekNo;
    this.recurringObj = new Object();
    this.recurringObj.typeId = this.order.recurringTypeId;
    this.recurringObj.recurringValues = this.order.recurringValue;
    this.recurringObj.statusId = this.order.recurringStatusId;
    this.recurringObj.changedReasonId = this.order.recurringChangedReasonId;
    this.recurringObj.recurringComment = this.order.recurringComment;
    if (this.order.resumeDateModel)
      this.recurringObj.resumeDate = this.order.resumeDateModel;
    else
      this.recurringObj.resumeDate = null;
    this.enableRecurring = true;
    if (!this.isDelivery && !this.isPartialDelivery)
      this.getSalesRestrictionPacks();
    this.selectedCustomerTypeId = this.order.outlet.customerTypeId;
    this.selectedSalesMode = this.order.salesMode;
    if (!this.checkEmployeeCustomersInOrders && this.showCustomerRouteEmployees)
      this.getCustomerRouteEmployees();

    this.showAccountInfoInTotal = this.isNewOrder && (this.transactionCommonData.salesMode == SalesModes.CreditSales || this.transactionCommonData.outlet.customerTypeId == CustomerTypes.CreditCustomer || this.transactionCommonData.outlet.customerTypeId == CustomerTypes.BillToBillCustomer);
    if (this.showAccountInfoInTotal) {
      this.paymentTermIdControl.setValue(this.order.outlet.paymentTermId);
      this.orginalBalance = this.order.outlet.account.balance;
      this.creditLimit = this.order.outlet.account.creditLimit;
      if (this.DeductPendingOrdersFromAvailableCredit) {
        this.usedCredit = this.orginalBalance + this.order.outlet.account.pendingOrdersTotal;
        this.totals.OrginalBalance = this.orginalBalance + this.order.outlet.account.pendingOrdersTotal;
      } else {
        this.usedCredit = this.orginalBalance;
        this.totals.OrginalBalance = this.orginalBalance;
      }
    }
  }
  fillOrderPropertiesInAddMode() {
    this.order = {
      orderId: this.orderId,
      customerId: null,
      outletId: null,
      employeeId: null,
      divisionId: null,
      allItems: [],
      soldItems: [],
      promotedItems: [],
      netTotal: 0,
      grossTotal: 0,
      calculatedRetailTax: 0,
      tax: 0,
      includedTaxAmount: 0,
      warehouseId: null
    }
    this.enableRecurring = true;
  }

  //#endregion

  //#region [METHODS]
  updateCustomerReturnBatches() {
    this.itemService.updateCustomerReturnBatches(this.order).subscribe((response) => {
      if (response.status != null && response.status >= 0) {
        this.isHideLoadingInItems = true;
        this.showItemsAndDisableHeaderData();
      } else {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.ErrorHappened)
      );
    }
    );
  }

  checkForPostedCustomerTransactions(order) {
    this.orderPendingService.checkForPostedCustomerTransactions(order).subscribe((response) => {
      if (response.status != null && response.status >= 0) {
        if (response.data === true) {
          // ALERT USER.
          this.coreSession.showInfo(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgCalculatingBatches));
          // UPDATE BATCHES...
          this.updateCustomerReturnBatches();
        } else {
          this.isHideLoadingInItems = true;
          this.showItemsAndDisableHeaderData();
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  isValidToAddOrUpdate() {
    this.order.orderOperation = OrderOperation.Add;
    this.order.orderStatusFromUI = this.orderStatusFromUI
    this.orderService.isValidOperation(this.order).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          if (this.restrictReturnFromInvoices && this.order.orderTypeId === OrderTypes.Return.valueOf() &&
            (response.data.isValidOperation || response.data.onlyShowWarning)) {
            var showPaymentDialog = false;
            this.order.allItems = this.order.allItems.filter(i =>
              i.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn ||
              (i.salesTransactionTypeId === SalesTransactionTypes.FreeReturn && this.allowTaxOverFreeItems && i.returnFromInvoiceAvailableBatchList.filter(x => x.baseTaxPercentage > 0).length > 0)
            );
            this.order.allItems = this.order.allItems.filter(i => !i.isFromProductDiscount);
            showPaymentDialog = this.prepareOrderPacksPerBatchForSaving(this.order);
            if (showPaymentDialog) {
              this.initPaymentForm();
              this.openRequiredPaymentModal();
            } else {
              this.saveOrderToDB();
            }
          }
          else if (response.data.isValidOperation) {
            this.saveOrderToDB();
          } else if (response.data.onlyShowWarning) {
            this.coreSession.ModalDialog.ShowMessage(
              this.translateService.instant(response.data.message + ' ,' + this.translateService.instant(ConstantMessages.Desc_Do_You_Want_To_Continue)),
              DialogMode.YesNo,
              this.translateService.instant(ConstantMessages.WarningCaption)
            ).then((result: DialogResult) => {
              if (result === DialogResult.Yes) {
                this.saveOrderToDB();
              }
            });
          } else {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              response.data.message
            );
          }
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  resetOrderTotals(order: any) {
    if (this.isProcessReturn &&
      this.recalculateBenefitOnReturn &&
      this.restrictReturnFromInvoices &&
      this.rangesList && this.rangesList.length > 0
    ) {
      order.netTotal = 0;
      order.discount = 0;
      order.tax = 0;
      order.grossTotal = 0;
    }
  }
  prepareOrderPacksPerBatchForSaving(order) {
    if (!this.cachedOrderItems || this.cachedOrderItems.length == 0) this.cachedOrderItems = cloneDeep(order.allItems);
    this.trueNetTotal = 0;
    this.resetOrderTotals(order);
    var showPaymentDialog = false;
    var allItems = [];
    var returnsFromInvoices = [];
    var totalRequiredPaymentFromAllItems = 0;
    order.allItems = cloneDeep(this.cachedOrderItems);
    order.allItems = order.allItems.concat(this.tempForcedToReturnPack);
    order.allItems.forEach((pack) => {

      if (pack.returnFromInvoiceAvailableBatchList && pack.returnFromInvoiceAvailableBatchList.length > 0) {
        var selectedFromInvoiceBatches = pack.returnFromInvoiceAvailableBatchList.filter(batchObj => batchObj.requiredQuantity > 0);
        selectedFromInvoiceBatches.forEach(invBatch => {
          if (invBatch.requiredPaymentAmount && invBatch.requiredPaymentAmount > 0) {
            totalRequiredPaymentFromAllItems += invBatch.requiredPaymentAmount;
          }
          invBatch.discountPercentage = invBatch.discountPercentage > 100 ? 100 : invBatch.discountPercentage;
          if ((!pack.isFromProductDiscount || this.isProcessReturn) &&
            pack.salesTransactionTypeId !== SalesTransactionTypes.FreeReturnAsDiscount &&
            (pack.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn || (pack.salesTransactionTypeId === SalesTransactionTypes.FreeReturn && this.isProcessReturn))
          ) {
            this.addToReturnsFromInvoices(pack, invBatch, returnsFromInvoices);
          }
          var grossTotal = pack.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn ? invBatch.basePrice * invBatch.requiredQuantity * pack.piecesInPack : 0;
          var calculatedDiscountTotal = grossTotal * invBatch.discountPercentage / 100;
          var calculatedReturnDiscount = invBatch.returnDiscountPercentage ? grossTotal * invBatch.returnDiscountPercentage / 100 : 0;
          var calculatedExciseTaxAmount = pack.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn ? invBatch.baseExciseTax * invBatch.requiredQuantity * pack.piecesInPack : 0;
          var calculatedTaxTotal = 0;
          var totalDisc = this.isProcessReturn ?
            calculatedDiscountTotal + calculatedReturnDiscount > grossTotal ? grossTotal : calculatedDiscountTotal + calculatedReturnDiscount
            : calculatedDiscountTotal;

          var discountTotalWithReturn = calculatedReturnDiscount + calculatedDiscountTotal > grossTotal ? grossTotal : calculatedDiscountTotal + calculatedReturnDiscount;
          if (this.calculateTaxBeforeDiscount) {
            calculatedTaxTotal = (grossTotal + calculatedExciseTaxAmount) * invBatch.baseTaxPercentage / 100;
            var calculatedTaxWithReturn = calculatedTaxTotal;
          } else {
            calculatedTaxTotal = (grossTotal - (totalDisc) + calculatedExciseTaxAmount) * invBatch.baseTaxPercentage / 100; // Will be different in process and orders
            var calculatedTaxWithReturn = (grossTotal - (discountTotalWithReturn) + calculatedExciseTaxAmount) * invBatch.baseTaxPercentage / 100; // same in process and orders.
          }
          if (pack.salesTransactionTypeId === SalesTransactionTypes.FreeReturn && this.allowTaxOverFreeItems) {
            calculatedTaxTotal = (invBatch.basePrice * invBatch.requiredQuantity * pack.piecesInPack) * invBatch.baseTaxPercentage / 100;;
          }
          var netTotal = grossTotal - (totalDisc) + calculatedTaxTotal + calculatedExciseTaxAmount;
          if (pack.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn || this.isProcessReturn) {
            this.addToOrderItems(
              allItems,
              pack,
              invBatch,
              grossTotal,
              totalDisc,
              calculatedDiscountTotal,
              calculatedReturnDiscount,
              calculatedTaxTotal,
              calculatedExciseTaxAmount,
              netTotal);
            this.calculateNewTotals(pack, order, totalDisc, calculatedTaxTotal, netTotal, grossTotal, discountTotalWithReturn, calculatedTaxWithReturn, calculatedExciseTaxAmount);
          } else {
            this.calculateNewTotals(pack, order, 0, calculatedTaxTotal, 0, 0, 0, calculatedTaxTotal, 0);
          }

        });
      }
    });
    this.preparePriceAndTaxPackLevel(allItems);

    order.allItems = allItems;
    // order.soldItems = allItems;
    if (!this.isProcessReturn) {
      order.allItems = cloneDeep(order.soldItems);
    }
    order.returnsFromInvoices = returnsFromInvoices;

    if (this.recalculateBenefitOnReturn) {
      if (totalRequiredPaymentFromAllItems > 0) {
        this.totalRequiredPaymentFromAllItems = totalRequiredPaymentFromAllItems;
        showPaymentDialog = true;
      }
    }
    return showPaymentDialog;
  }

  preparePriceAndTaxPackLevel(allItems: any[]) {
    allItems.forEach(packobj => {
      packobj.price = packobj.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn
        ? packobj.grossTotal / packobj.requiredQty : 0;
      packobj.basePrice = packobj.grossTotal / packobj.requiredQty;
      packobj.discount = packobj.grossTotal > 0 ? (packobj.calculatedDiscountTotal / packobj.grossTotal) * 100 : 0;
      packobj.tax = packobj.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn ?
        (packobj.grossTotal - (packobj.calculatedDiscountTotal) + packobj.calculatedRetailTax) > 0
          ? !this.calculateTaxBeforeDiscount ?
            (packobj.calculatedTax / (packobj.grossTotal - (packobj.calculatedDiscountTotal) + packobj.calculatedRetailTax)) * 100 : (packobj.calculatedTax / (packobj.grossTotal + packobj.calculatedRetailTax)) * 100
          : 0
        : 0;
      if (packobj.salesTransactionTypeId === SalesTransactionTypes.FreeReturn && this.allowTaxOverFreeItems) {
        packobj.tax = packobj.calculatedTax;
      }
      if (packobj.salesTransactionTypeId === SalesTransactionTypes.FreeReturn ||
        packobj.salesTransactionTypeId === SalesTransactionTypes.FreeReturnAsDiscount) {
        packobj.grossTotal = packobj.salesTransactionTypeId === SalesTransactionTypes.FreeReturn ? 0 : packobj.grossTotal;
        packobj.netTotal = 0;
      }
      this.calculatePackReturnDiscount(packobj);
    });
  }

  calculatePackReturnDiscount(packobj: any) {
    var packDiscountAmount = 0;
    var packGrossTotal = 0;
    var returnDiscountAmount = 0;
    var returnDiscountPercentage = 0;
    if (this.recalculateBenefitOnReturn && this.restrictReturnFromInvoices && this.itemPackReturnDiscount && this.itemPackReturnDiscount.length > 0) {
      var i = this.itemPackReturnDiscount.findIndex(i => i.itemId === packobj.itemId && i.packId === packobj.packId && packobj.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn);
      if (i > -1) {
        packDiscountAmount = this.itemPackReturnDiscount[i].discountAmount;
        packGrossTotal = this.itemPackReturnDiscount[i].packGrossTotal;
        if (packGrossTotal > 0 && packDiscountAmount > 0) {
          returnDiscountAmount = (packobj.grossTotal / packGrossTotal) * packDiscountAmount;
          returnDiscountPercentage = packobj.grossTotal > 0 ? (returnDiscountAmount / packobj.grossTotal) * 100 : 0;
          packobj.returnDiscountPercentage = returnDiscountPercentage;
        }
      }
    }
  }

  addToOrderItems(allItems: any[], pack: any, invBatch: any, grossTotal: number, totalDisc: number, calculatedDiscountTotal: number, calculatedReturnDiscount: number, calculatedTaxTotal: number, calculatedExciseTaxAmount: number, netTotal: number) {
    var idx = allItems.findIndex(item =>
      item.batchNo === invBatch.batchNo &&
      item.packId === pack.packId &&
      item.itemId === pack.itemId &&
      // item.salesTransactionTypeId === pack.salesTransactionTypeId
      item.salesTransactionTypeId === invBatch.salesTransactionTypeId
    );
    if (idx > -1) {
      allItems[idx].requiredQty += invBatch.requiredQuantity;
      allItems[idx].grossTotal += grossTotal;
      allItems[idx].calculatedDiscountTotal += this.isProcessReturn && this.recalculateBenefitOnReturn && this.restrictReturnFromInvoices
        ? totalDisc : calculatedDiscountTotal;
      allItems[idx].returnDiscountAmount += calculatedReturnDiscount;
      allItems[idx].calculatedTax += calculatedTaxTotal;
      allItems[idx].calculatedRetailTax += calculatedExciseTaxAmount;
      allItems[idx].netTotal += netTotal;
      allItems[idx].returnFromInvoiceAvailableBatchList.push(cloneDeep(invBatch));
    } else {
      this.pack = new ItemPackModel();
      this.pack.batchNo = invBatch.batchNo;
      this.pack.expiryDateModel = invBatch.expiryDateModel;
      this.pack.requiredQty = invBatch.requiredQuantity;
      this.pack.itemName = pack.itemName;
      this.pack.itemCode = pack.itemCode;
      this.pack.packId = pack.packId;
      this.pack.itemId = pack.itemId;
      this.pack.uom = pack.uom;
      this.pack.netTotal = netTotal;
      this.pack.grossTotal = grossTotal;
      this.pack.calculatedDiscountTotal = this.isProcessReturn && this.recalculateBenefitOnReturn && this.restrictReturnFromInvoices
        ? totalDisc : calculatedDiscountTotal;
      this.pack.calculatedTax = calculatedTaxTotal;
      // this.pack.returnFromInvoiceAvailableBatchList = pack.returnFromInvoiceAvailableBatchList;
      this.pack.returnFromInvoiceAvailableBatchList = [];
      this.pack.returnFromInvoiceAvailableBatchList.push(cloneDeep(invBatch)); this.pack.returnReasonId = pack.returnReasonId;
      this.pack.packStatusId = pack.packStatusId;
      this.pack.batchNo = invBatch.batchNo;
      this.pack.piecesInPack = pack.piecesInPack;
      this.pack.calculatedRetailTax = calculatedExciseTaxAmount;
      this.pack.returnDiscountAmount = calculatedReturnDiscount;
      // this.pack.salesTransactionTypeId = pack.salesTransactionTypeId;
      this.pack.salesTransactionTypeId = invBatch.salesTransactionTypeId;
      this.pack.isFromProductDiscount = pack.isFromProductDiscount;
      allItems.push(this.pack);
    }
  }
  calculateNewTotals(pack: any, order: any, totalDisc: number, calculatedTaxTotal: number, netTotal: number, grossTotal: number, discountTotalWithReturn: number, calculatedTaxWithReturn: number, calculatedExciseTaxAmount: number) {
    if (
      (pack.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn || (pack.salesTransactionTypeId === SalesTransactionTypes.FreeReturn && this.allowTaxOverFreeItems && calculatedTaxTotal > 0)) &&
      pack.salesTransactionTypeId !== SalesTransactionTypes.FreeReturnAsDiscount &&
      this.recalculateBenefitOnReturn &&
      this.restrictReturnFromInvoices &&
      this.rangesList && this.rangesList.length > 0
      // (
      //   (this.itemPackReturnDiscount &&
      //     this.itemPackReturnDiscount.length > 0)
      //   ||
      //   this.allowTaxOverFreeItems
      // )
    ) {
      if (this.isProcessReturn) {
        order.discount += totalDisc;
        order.tax += calculatedTaxTotal;
        order.netTotal += netTotal;
        order.grossTotal += grossTotal;
      } else {
        this.trueNetTotal += grossTotal - discountTotalWithReturn + calculatedTaxWithReturn + calculatedExciseTaxAmount;
      }
    }
  }
  addToReturnsFromInvoices(pack: any, invBatch, returnsFromInvoices: any[]) {
    var i = returnsFromInvoices.findIndex(ret =>
      ret.batchNo === invBatch.batchNo &&
      ret.packId === pack.packId &&
      ret.itemId === pack.itemId &&
      ret.transactionId === invBatch.transactionId &&
      ret.expiryDateModel.day === invBatch.expiryDateModel.day &&
      ret.expiryDateModel.month === invBatch.expiryDateModel.month &&
      ret.expiryDateModel.year === invBatch.expiryDateModel.year &&
      ret.expiryDateModel.date === invBatch.expiryDateModel.date &&
      ret.salesTransactionTypeId === invBatch.salesTransactionTypeId
      // ret.salesTransactionTypeId === (pack.salesTransactionTypeId == SalesTransactionTypes.FreeReturn || !invBatch.salesTransactionTypeId ) ? pack.salesTransactionTypeId : invBatch.salesTransactionTypeId
    );
    if (i === -1) {
      invBatch.packId = pack.packId;
      invBatch.itemId = pack.itemId;
      invBatch.expiryDate = invBatch.expiryDateModel.date;
      // invBatch.salesTransactionTypeId = (pack.salesTransactionTypeId == SalesTransactionTypes.FreeReturn || !invBatch.salesTransactionTypeId ) ? pack.salesTransactionTypeId : invBatch.salesTransactionTypeId
      returnsFromInvoices.push(invBatch);
    } else {
      returnsFromInvoices[i].requiredQuantity += invBatch.requiredQuantity;
    }
  }

  saveOrderToDB() {
    if (this.isEdit) {
      this.order.OrderOperation = OrderOperation.EditValues;
      if (this.order.orderStatusId == OrderStatus.New) {
        this.orderPendingService.updateOrder(this.order).subscribe(
          (response) => {
            this.onUpdateOrderSuccess(response);
          }, (error: HttpErrorResponse) => {
            this.onUpdateOrderError(error);
          }
        );
      } else if (this.order.orderStatusId == OrderStatus.Approved) {
        this.orderApprovedService.updateOrder(this.order).subscribe(
          (response) => {
            this.onUpdateOrderSuccess(response);
          }, (error: HttpErrorResponse) => {
            this.onUpdateOrderError(error);
          }
        );
      } else {
        this.orderPendingService.updateOrder(this.order).subscribe(
          (response) => {
            this.onUpdateOrderSuccess(response);
          }, (error: HttpErrorResponse) => {
            this.onUpdateOrderError(error);
          }
        );
      }

    }
    else {
      // save just to pending order
      this.orderPendingService.insertOrder(this.order).subscribe(
        (response) => {
          if (response.status != null && response.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));

            let trans = {
              divisionId: this.order.divisionId ? this.order.divisionId : -1,
              transactionId: response.data.orderId,
              customerId: this.order.customerId,
              outletId: this.order.outletId,
              reportMode: ReportMode.SalesOrder,
              isReprintReport: false
            }
            this.pdfCreatorService.ExportReport(trans);
            if (response.data.orderStatus === OrderStatus.NewWebOrder) {
              this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
                this.translateService.instant(ConstantMessages.Desc_Order_Needs_Approval_From_FO)
                  .replace('{0}', response.data.orderId)
                  .replace('{1}', response.data.employeeCodeName)
              );
            }
            this.onSaveComplete.emit();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }, (error: HttpErrorResponse) => {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    }
  }

  onUpdateOrderSuccess(response) {
    if (response.status != null && response.status >= 0) {

      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
      let trans = {
        divisionId: this.order.divisionId ? this.order.divisionId : -1,
        transactionId: this.order.orderId,
        customerId: this.order.customerId,
        outletId: this.order.outletId,
        reportMode: ReportMode.SalesOrder,
        // reportMode: this.order.orderTypeId === OrderTypes.Return.valueOf()? ReportMode.ReturnOrder : ReportMode.SalesOrder,
        isReprintReport: false
      }
      this.pdfCreatorService.ExportReport(trans);
      this.onSaveComplete.emit();


    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }

  onUpdateOrderError(error) {
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
  }


  disableHeaderData() {
    this.customer.disable({ onlySelf: true, emitEvent: false });
    this.customer.updateValueAndValidity();

    this.outlet.disable({ onlySelf: true, emitEvent: false });
    this.outlet.updateValueAndValidity();

    this.division.disable({ onlySelf: true, emitEvent: false });
    this.division.updateValueAndValidity();

    this.employee.disable({ onlySelf: true, emitEvent: false });
    this.employee.updateValueAndValidity();
    this.warehouseIdControl.disable({ onlySelf: true, emitEvent: false });
    if ((this.isDelivery || this.isPartialDelivery) && !this.order.warehouseTransactionId) {
      this.deliveryDateControl.disable({ onlySelf: true, emitEvent: false });
      this.deliveryDateControl.updateValueAndValidity();
    } else if (this.order.orderTypeId == OrderTypes.Return.valueOf()) {
      this.desiredDeliveryDateProperties.label = 'Desc_Process_Date';
    } else {
      this.desiredDeliveryDateProperties.label = 'Desc_Desired_Delivery_Date';
    }

    this.LPOControl.disable({ onlySelf: true, emitEvent: false });
    this.LPOControl.updateValueAndValidity();
    this.customerRef.disable({ onlySelf: true, emitEvent: false });
    this.customerRef.updateValueAndValidity();
    this.orderTypeIdControl.disable({ onlySelf: true, emitEvent: false });
    this.orderTypeIdControl.updateValueAndValidity();
    if (this.showOrderSourceSelection) {
      this.orderSourceIdControl.disable({ onlySelf: true, emitEvent: false });
      this.orderSourceIdControl.updateValueAndValidity();
    }

    if (this.enableSalesDistributionChannel) {
      this.orderForm.get("sdcId").disable({ onlySelf: true, emitEvent: false });
      this.orderForm.get("sdcId").updateValueAndValidity();
    }
    if (this.showCollectionMethodSelection) {
      this.collectionMethodIdControl.disable({ onlySelf: true, emitEvent: false });
      this.collectionMethodIdControl.updateValueAndValidity();
    }
    this.disableHeader = true;
    // this.noteWidth = this.noteWidth + 2;
    //if(!this.isDivisionLevel())

    this.noteString = "col-md-" + (!this.isDivisionLevel() ? 9 : 6) + '';

  }

  validateOrderDataToAdd() {
    this.validationService.checkHeaderData(this.transactionCommonData).subscribe(
      (response) => {
        if (response.status != null && response.status >= 0) {
          this.order.outlet = response.data.outlet;
          if (!this.allowSalesModeSelectionForCustomer()) {
            if (this.order.outlet.customerTypeId === 1) {
              this.order.salesMode = 1;
            } else {
              this.order.salesMode = 2;
            }
          } else {
            this.order.salesMode = this.selectedSalesMode;
          }

          this.transactionCommonData.outlet = response.data.outlet;
          this.showAccountInfoInTotal = this.isNewOrder && (this.transactionCommonData.salesMode == SalesModes.CreditSales || this.transactionCommonData.outlet.customerTypeId == CustomerTypes.CreditCustomer || this.transactionCommonData.outlet.customerTypeId == CustomerTypes.BillToBillCustomer);
          if (this.showAccountInfoInTotal) {
            this.paymentTermIdControl.setValue(response.data.outlet.paymentTermId);
            this.creditLimit = this.order.outlet.account.creditLimit;
            this.orginalBalance = this.order.outlet.account.balance;
            if (this.DeductPendingOrdersFromAvailableCredit) {
              this.usedCredit = this.orginalBalance + this.order.outlet.account.pendingOrdersTotal;
              this.totals.OrginalBalance = this.orginalBalance + this.order.outlet.account.pendingOrdersTotal;
            } else {
              this.usedCredit = this.orginalBalance;
              this.totals.OrginalBalance = this.orginalBalance;
            }
          }
          if (this.order.outlet.taxable && this.allowTax === "true") {
            this.showTax = true;
            if (this.allowRetailTaxOnItems) {
              this.showRetailTax = true;
            }
          }
          this.checkAccountAndDocumentSequence();
        } else {
          if (!response.data) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
          }
          else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgNoDocumentSequence));
      }
    );
  }

  validateOrderDataToSave() {
    this.transactionCommonData.soldItems.forEach(i => i.availableQtyInPcs = 0)
    if (this.order.orderTypeId == OrderTypes.Return.valueOf() && this.restrictReturnFromInvoices) {
      this.transactionCommonData.soldItems = [];
      this.order.allItems = this.order.allItems.filter(i =>
        i.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn ||
        (i.salesTransactionTypeId === SalesTransactionTypes.FreeReturn && this.allowTaxOverFreeItems && i.returnFromInvoiceAvailableBatchList.filter(x => x.baseTaxPercentage > 0).length > 0)
      );
    }
    this.validationService.checkHeaderData(this.transactionCommonData).subscribe(
      (response) => {
        if (response.status != null && response.status >= 0) {
          this.order.outlet = response.data.outlet;
          if (this.order.orderTypeId === OrderTypes.Return.valueOf()) {
            this.isValidToAddOrUpdate();
          } else {
            this.checkCreditLimit(true); // check credit limit after adding current order total
          }
        } else {
          if (!response.data) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
          }
          else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgNoDocumentSequence));
      }
    );
  }

  checkAccountAndDocumentSequence() {

    let documentSequenceFilter = {
      divisionId: this.division && this.division.value ? this.division.value : -1,
      employeeId: this.coreSession.CurrentOperator.employeeId,
      documentType: this.order.orderTypeId = DocumentTypes.Order
    };
    // check for document sequence and account
    this.validationService.checkAccountAndDocumentSequence(documentSequenceFilter).subscribe(
      (response) => {
        if (response.status != null && response.status >= 0) {
          this.validateNewOrder();
          this.showOrderId = true;
        } else {
          return this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        return this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  validateNewOrder(): boolean {

    if (this.transactionCommonData.noDocumentSequance === true) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgNoDocumentSequence));
      return;
    }
    // if (this.order.outlet.customerValidations.noAccount === true) {
    //   this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgNoCustomerAccount));
    //   return;
    // }
    if (this.order.outlet.customerValidations.isOnHold === true) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgOnHoldCustomer));
      return;
    }
    // if payment term checked then check credit limit if all valid then show items and disable header data
    if (this.orderTypeIdControl && this.orderTypeIdControl.value === OrderTypes.Return.valueOf()) {
      if (this.restrictReturnFromInvoices) {
        // CALL API TO UPDATE CUSTOMER BATCHESLIST.
        this.checkForPostedCustomerTransactions(this.order);
        // this.updateCustomerReturnBatches();
      } else {
        this.showItemsAndDisableHeaderData();
      }
    } else {
      this.checkPaymentTerm();
    }
  }

  checkPaymentTerm() {
    if (this.order.outlet.customerValidations.isViolatePaymentTerms === true) {
      if (this.preventContinueWhenPaymentTermsExceededOnOrders === "true") {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgCustomerViolatePaymentTerms));
        return;
      } else {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgExceedPaymentTermConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              this.checkCreditLimit(false);
            } else {
              return;
            }
          });
      }
    } else {
      this.checkCreditLimit(false);
    }
  }

  checkCreditLimit(valiateToSave: boolean) {
    if (this.order.outlet.customerValidations.isExceedsCustomerLimit === true) {
      if (!valiateToSave) {
        this.isCreditLimitExceededOnCreate = true;
      }
      if (this.preventContinueWhenCreditLimitExceededOnOrders === "true") {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgCustomerExceedsCreditLimit));
        return;
      } else {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgExceedCreditLimitConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              if (valiateToSave) {
                if (!this.isDelivery && !this.isPartialDelivery) {
                  this.getSalesRestrictionPacks(true);
                } else {
                  this.isValidToAddOrUpdate();
                }
                // this.saveOrderToDB();
              } else { // if validate to create :
                if (!this.isDelivery && !this.isPartialDelivery) {
                  this.getSalesRestrictionPacks();
                }
                if (this.isAddBundle) {
                  this.showBundlesAndDisableHeaderData();
                } else {
                  this.showItemsAndDisableHeaderData();
                }
                return;
              }
            } else {
              return;
            }
          });
      }
    } else {
      if (valiateToSave) {
        //this.saveOrderToDB();
        if (this.orderTypeIdControl.value && this.orderTypeIdControl.value === OrderTypes.Return.valueOf()) {
          this.isValidToAddOrUpdate();
        }
        else if (!this.isDelivery && !this.isPartialDelivery)
          this.getSalesRestrictionPacks(true);
      } else { // if validate to create :
        if (!this.isDelivery && !this.isPartialDelivery && (!this.orderTypeIdControl || this.orderTypeIdControl.value !== OrderTypes.Return.valueOf()))
          this.getSalesRestrictionPacks();
        this.isCreditLimitExceededOnCreate = false;
        if (this.isAddBundle) {
          this.showBundlesAndDisableHeaderData();
        } else {
          this.showItemsAndDisableHeaderData();
        }
      }
    }
  }

  showItemsAndDisableHeaderData() {
    this.showItemsSection = true;
    this.showItems = true;
    this.isBundle = false;
    this.disableHeaderData();
  }

  showBundlesAndDisableHeaderData() {
    this.showItemsSection = false;
    this.showItems = false;
    this.isBundle = true;
    this.disableHeaderData();
  }
  modifyOrderItemsFromTransactionCommonData() {
    this.transactionCommonData.soldItems.forEach(i => {
      i.priceString = this.calculationService.getNumberOnDigitFormat(i.price).toString();
    });
    this.transactionCommonData.promotedItems.forEach(i => {
      i.priceString = this.translateService.instant(ConstantMessages.CaptionPromo);
    });

    this.order.soldItems = this.transactionCommonData.soldItems;
    this.order.promotedItems = this.transactionCommonData.promotedItems;

    this.originalOrderPromotedItems.forEach(item => {
      let index = this.order.promotedItems.findIndex(x => x.packId == item.packId);
      if (index > -1)
        this.order.promotedItems[index].requiredQty += item.requiredQty;
      else
        this.order.promotedItems.push(item);
    });

    // for promotions that not need user selection, set taken promotions in Back end to order promotion
    this.order.customerPromotions = this.transactionCommonData.customerPromotions;
    this.order.promotionsForAllLevels = this.transactionCommonData.promotionsForAllLevels;
    this.order.allItems = [];
    this.order.allItems = this.order.allItems.concat(this.order.soldItems);
    this.order.allItems = this.order.allItems.concat(this.order.promotedItems);
  }
  showSummaryUI() {
    this.modifyOrderItemsFromTransactionCommonData();
    if (this.order.orderTypeId === OrderTypes.Return.valueOf() && this.restrictReturnFromInvoices && this.restrictReturnQtyFromInvoices) {
      var resetTotals = false;
      if (this.forcedToReturnPackLevel && this.forcedToReturnPackLevel.length > 0) {
        this.order.allItems = this.order.allItems.concat(this.forcedToReturnPackLevel);
        resetTotals = true;
      }
      if (this.forcedToReturnPackLevel1 && this.forcedToReturnPackLevel1.length > 0) {
        var items = this.forcedToReturnPackLevel1.filter(i => !i.isReturnedAsDiscount);
        this.order.allItems = this.order.allItems.concat(items);
        resetTotals = true;
      } if (this.forcedToReturnPackLevel2 && this.forcedToReturnPackLevel2.length > 0) {
        var items = this.forcedToReturnPackLevel2.filter(i => !i.isReturnedAsDiscount);
        this.order.allItems = this.order.allItems.concat(items);
        resetTotals = true;
      }

      this.recalculateReturnOrderItemsWithBenefit(resetTotals);

    } else {

      this.order.isPromotionTaken = true;
      if ((this.promotionCalculationSequence != 3 && !this.transactionCommonData.isThereAnyProductDiscountDefined) || (this.promotionCalculationSequence == 3 && (this.lastPromotion || this.customerPromotions.length == 0)) || (this.transactionCommonData.isThereAnyProductDiscountDefined && (this.lastPromotion || this.customerPromotions.length == 0))) {
        if (this.transactionCommonData.isThereAnyProductDiscountDefined) {
          this.validationService.recalculateAfterProductDiscountPromotions(this.transactionCommonData).subscribe(
            (response) => {
              if (response.status != null && response.status >= 0) {
                this.transactionCommonData = response.data;
                this.modifyOrderItemsFromTransactionCommonData();
                this.calculateTotalAfterPromotions();
                if (this.isDelivery && this.order && this.order.orderTypeId === OrderTypes.Sales.valueOf()) {
                  this.checkForContractedFOC();
                } else if (this.isEligibleForHeaderDiscount()) {
                  this.checkForHeaderDiscount();
                } else {
                  this.showSummary = true;
                  this.showItemsSection = false;
                  this.showTakePromotions = false;
                }
              }
            }, (error: HttpErrorResponse) => {
              this.coreSession.showError('', this.translateService.instant(ConstantMessages.ErrorHappened));
            }
          );
        }
        else {
          this.calculateTotalAfterPromotions();
          if (this.isDelivery && this.order && this.order.orderTypeId === OrderTypes.Sales.valueOf()) {
            this.checkForContractedFOC();
          } else if (this.isEligibleForHeaderDiscount()) {
            this.checkForHeaderDiscount();
          } else {
            this.showSummary = true;
            this.showItemsSection = false;
            this.showTakePromotions = false;
          }
        }
      }
      else {
        this.calculateTotalAfterPromotions();
        this.fillTransactionCommonData();
        if (this.orderTypeIdControl.value !== OrderTypes.Return.valueOf()) {
          this.checkPromotions(false, false);
        }
      }
    }
  }

  calculateTotalAfterPromotions() {
    // reset totals
    var accountinfo = this.totals;
    this.totals = new TotalsModel;
    // set Account info
    if (this.DeductPendingOrdersFromAvailableCredit) {
      this.totals.OrginalBalance = accountinfo.OrginalBalance;
      this.totals.balanceAfter = accountinfo.balanceAfter;
    } else {
      this.totals.OrginalBalance = accountinfo.OrginalBalance;
    }
    // calculate items totals after take benefits
    this.calculationService.calculateTotalAfterPromotions(this.totals, this.order.allItems);

    // set transaction Totals
    this.order.netTotal = this.totals.netTotal;
    this.order.grossTotal = this.totals.grossTotal;
    this.order.tax = this.totals.taxTotal;
    this.order.calculatedRetailTax = this.totals.retailTaxTotal;
    this.order.discount = this.totals.discountTotal;
    this.order.promotedDiscount = this.totals.promotedDiscountTotal;
    this.order.includedTaxAmount = this.totals.includedTaxAmount;
    // this.order.headerDiscount = this.totals.headerDiscountTotal; // as amount
    this.order.headerDiscount = this.headerDiscountPercentage; // as percentage
  }

  fillTransactionCommonData() {
    this.transactionCommonData.draftTransactionId = this.order.orderId;
    this.transactionCommonData.customerId = this.order.customerId;
    this.transactionCommonData.customerRef = this.order.customerRef;
    this.transactionCommonData.outletId = this.order.outletId;
    this.transactionCommonData.divisionId = this.order.divisionId;
    this.transactionCommonData.employeeId = this.order.employeeId;
    this.transactionCommonData.areAllItemDiscountsAdded = false;
    if (this.isDelivery) {
      this.transactionCommonData.itemFormProcessMode = FormProcessMode.Delivery;
      this.transactionCommonData.orderId = this.order.orderId;
    } else if (this.isPartialDelivery) {
      this.transactionCommonData.itemFormProcessMode = FormProcessMode.PartialDelivery;
      this.transactionCommonData.orderId = this.order.orderId;
    }
    else {
      this.transactionCommonData.itemFormProcessMode = FormProcessMode.Orders;
      this.transactionCommonData.orderTypeId = this.orderTypeIdControl.value;
    }
    if (this.isBundle) {
      this.transactionCommonData.orderId = this.order.orderId;
      this.transactionCommonData.isBundle = true;
      this.transactionCommonData.orderItems = this.order.allItems;
      this.transactionCommonData.warehouseId =this.order.warehouseId
      this.showItemsSection = false;
      this.checkBundles();
    }
    this.transactionCommonData.soldItems = this.order.soldItems;
    this.transactionCommonData.promotedItems = this.order.promotedItems;
    this.transactionCommonData.netTotal = this.order.netTotal;
    this.transactionCommonData.grossTotal = this.order.grossTotal;
    this.transactionCommonData.calculatedRetailTax = this.order.calculatedRetailTax;
    this.transactionCommonData.tax = this.order.tax;
    this.transactionCommonData.salesMode = this.allowSalesModeSelectionForCustomer() ? this.selectedSalesMode : this.selectedCustomerTypeId;
  }

  cancelPromotions() {
    this.showItemsSection = true;
    this.showSummary = false;
    this.showTakePromotions = false;
    this.order.isPromotionTaken = false;
    this.hideCloseButton = false;
    this.customerPromotions = [];
    this.copyCustomerPromotions = [];
    this.loyaltyPromotions = [];
    this.promotionGroupLevels = [];
    this.currentLevelId = 1;
    this.nextLevelId = 1;
    this.lastPromotion = false;
    this.lastInvoicePromotions = [];
    if (this.transactionCommonData != null) {
      this.transactionCommonData.promotionLevelId = 1;
      this.transactionCommonData.onlyProductDiscount = true;
      this.transactionCommonData.isThereAnyProductDiscountDefined = false;
      this.transactionCommonData.isSecondLevelProductDiscountTaken = false;
      this.transactionCommonData.quanityProductDiscountCount = 0;
      this.transactionCommonData.discountOrFreeItemsProductDiscountCount = 0;
      this.transactionCommonData.promotionsForAllLevels = [];
      this.transactionCommonData.notSelectedFirstLevelLastInvoice = [];
      this.transactionCommonData.productPromotionLevelId = 1;
      this.transactionCommonData.lastInvoicePromotionsList = [];
      this.transactionCommonData.areAllItemDiscountsAdded = false;
      this.transactionCommonData.promotionsGroupPriorities = [];
      this.lastInvoicePromotions = [];
      if ((this.transactionCommonData.productDiscountFirstLevelList != null && this.transactionCommonData.productDiscountFirstLevelList.length > 0)
        || (this.transactionCommonData.productDiscountSecondLevelList != null && this.transactionCommonData.productDiscountSecondLevelList.length > 0)) {
        this.transactionCommonData.soldItems.forEach((pack, index) => {
          if (pack.totalProductDiscountQuantity > 0) {
            if (pack.totalProductDiscountQuantity == pack.requiredQty)
              this.transactionCommonData.soldItems.splice(index, 1);
            else if (pack.requiredQty > pack.totalProductDiscountQuantity)
              this.transactionCommonData.soldItems[index].requiredQty = this.transactionCommonData.soldItems[index].requiredQty - pack.totalProductDiscountQuantity;
          }
          pack.totalProductDiscountQuantity = 0;
        });
        this.order.soldItems = this.transactionCommonData.soldItems;
        this.transactionCommonData.productDiscountFirstLevelList = [];
        this.transactionCommonData.productDiscountSecondLevelList = [];
      }
    }
    this.order.headerDiscount = 0;
    this.headerDiscountPercentage = 0;
    this.order.soldItems.forEach(i => {
      if (!this.isDelivery) {
        i.promotedDiscount = 0;
        i.calculatedPromotedDiscount = 0;
        i.itemPromotedDiscount = 0;
      }
      i.headerDiscount = 0;
      //to retrieve original value when change price by fixed price promotion
      // i.price = i.basePrice;
      i.price = i.originalPrice;
    });
    this.order.promotedItems.forEach(promoPack => {
      this.addedSerialsForAllPacks = this.addedSerialsForAllPacks.filter(serial => (serial.itemId !== promoPack.itemId || serial.packId !== promoPack.packId || serial.salesTransactionTypeId != promoPack.salesTransactionTypeId));
    });
    // reset totals
    var accountinfo = this.totals;
    this.totals = new TotalsModel();

    if (this.DeductPendingOrdersFromAvailableCredit) {
      this.totals.OrginalBalance = accountinfo.OrginalBalance;
      this.totals.balanceAfter = accountinfo.balanceAfter;
    } else {
      this.totals.OrginalBalance = accountinfo.OrginalBalance;
    }

    if (!(this.order.orderTypeId === OrderTypes.Return.valueOf() && this.restrictReturnFromInvoices)) {
      if (!this.isDelivery) {
        this.calculationService.calculateTotalAfterCancelPromotions(this.totals, this.order.soldItems);
      } else {
        this.calculationService.calculateTotalAfterCancelPromotionsForDelivery(this.totals, this.order.soldItems);
      }
    }
  }

  checkPromotions(onCheckout, isLastInvoiceDialog) {
    this.customerPromotions = [];
    this.copyCustomerPromotions = [];
    if (!isLastInvoiceDialog) {
      if (onCheckout) {
        this.promotionGroupLevels = [];
        this.transactionCommonData.promotionsGroupPriorities = [];
        this.transactionCommonData.promotionsForAllLevels = [];
        this.transactionCommonData.promotionLevelId = 1;
        this.transactionCommonData.onlyProductDiscount = true;
        this.transactionCommonData.isThereAnyProductDiscountDefined = false;
        this.transactionCommonData.isSecondLevelProductDiscountTaken = false;
        this.transactionCommonData.quanityProductDiscountCount = 0;
        this.transactionCommonData.discountOrFreeItemsProductDiscountCount = 0;
        this.transactionCommonData.notSelectedFirstLevelLastInvoice = [];
        this.transactionCommonData.productPromotionLevelId = 1;
        this.transactionCommonData.productDiscountFirstLevelList = [];
        this.transactionCommonData.productDiscountSecondLevelList = [];
        this.transactionCommonData.lastInvoicePromotionsList = [];
        this.transactionCommonData.sdcId = this.order.sdcId;
      }
      else {
        if (this.transactionCommonData.isThereAnyProductDiscountDefined)
          this.promotionGroupLevels = [];
      }
    }
    this.relatedToTargetPromotions = [];
    this.transactionCommonData.areDetailsFilled = true;
    this.validationService.checkOutPromotions(this.transactionCommonData).subscribe(
      (response) => {
        if (response.status != null && response.status >= 0) {
          this.isThereAnyWholeSalePromotion = response.data.hasWholeSalesTargetPromo;
          this.isThereDynamicSalesAmount = response.data.hasDynamicTargetSalesAmountPromo;
          this.unSatisfiedTargetPromotions = response.data.unSatisfiedTargetPromotions;
          this.unSatisfiedDynamicAmountPromotions = response.data.unSatisfiedDynamicAmountPromotions;
          this.hasLoyalityPromotion = response.data.hasLoyalityPromotion;
          this.transactionCommonData.isThereAnyProductDiscountDefined = response.data.transCommonData.isThereAnyProductDiscountDefined;
          this.transactionCommonData.productPromotionLevelId = response.data.transCommonData.productPromotionLevelId;
          this.transactionCommonData.quanityProductDiscountCount = response.data.transCommonData.quanityProductDiscountCount;
          this.transactionCommonData.discountOrFreeItemsProductDiscountCount = response.data.transCommonData.discountOrFreeItemsProductDiscountCount;
          this.transactionCommonData.isSecondLevelProductDiscountTaken = response.data.transCommonData.isSecondLevelProductDiscountTaken;
          this.transactionCommonData.onlyProductDiscount = response.data.transCommonData.onlyProductDiscount;
          if (this.transactionCommonData.isThereAnyProductDiscountDefined) {
            this.transactionCommonData.soldItems = response.data.transCommonData.soldItems;
            if (onCheckout) {
              this.calculationService.cancelItemAndAllItemsPromotions(this.totals, this.transactionCommonData.soldItems);
            }
          }
          if (response.data.customerPromotions && response.data.customerPromotions.length > 0) {
            this.customerPromotions = response.data.customerPromotions;
            this.copyCustomerPromotions = this.customerPromotions.slice();
            if (onCheckout) {
              this.promotionGroupLevels = response.data.promotionGroupLevels;
              this.transactionCommonData.promotionGroupLevels = this.promotionGroupLevels;
              this.transactionCommonData.promotionsGroupPriorities = response.data.transCommonData.promotionsGroupPriorities
            }
            this.relatedToTargetPromotions = this.customerPromotions.filter(x => x.relatedToTarget && (x.targetMode == 2 || x.targetMode == 3));
            if (this.customerPromotions && this.customerPromotions.length > 0 &&
              (this.isThereAnyWholeSalePromotion || this.isThereDynamicSalesAmount ||
                (this.relatedToTargetPromotions && this.relatedToTargetPromotions.length > 0) ||
                (this.loyaltyPromotions.length == 0 || !this.loyaltyPromotions)) &&
              (this.lastInvoicePromotions.length == 0 || !this.lastInvoicePromotions)) {
              this.numOfAllDynamicPromotions = 0;
              this.customerPromotions.forEach(promotion => {
                if ((promotion.isWholeSaleContract || (promotion.relatedToTarget && (promotion.targetMode == 2 || promotion.targetMode == 3))) && this.lastInvoicePromotions.filter(x => x.promotionId == promotion.promotionId).length <= 0) {
                  this.lastInvoicePromotions.push(promotion);
                }
                if (promotion.isDynamicSalesAmount && promotion.benefitValue == 0 && this.lastInvoicePromotions.filter(x => x.promotionId == promotion.promotionId).length <= 0) {
                  this.lastInvoicePromotions.push(promotion);
                  this.numOfAllDynamicPromotions++;
                }
                if (promotion.isLoyaltyPromotion) {
                  this.loyaltyPromotions.push(promotion);
                }
              });
              if (this.hasLoyalityPromotion && this.loyaltyPromotions.length > 0) {
                this.openLoyaltyDialog();
              }
              else if (this.lastInvoicePromotions && this.lastInvoicePromotions.length > 0) {
                this.openLastInvoiceDialog();
              }
              else {
                this.openTakePromotions();

              }
            }
            else if ((this.unSatisfiedTargetPromotions && this.unSatisfiedTargetPromotions.length > 0) || (this.unSatisfiedDynamicAmountPromotions && this.unSatisfiedDynamicAmountPromotions.length > 0)) {
              this.checkForUnsatisfiedTargets(false);
            } else
              this.openTakePromotions();
          }
          else if ((this.unSatisfiedTargetPromotions && this.unSatisfiedTargetPromotions.length > 0) || (this.unSatisfiedDynamicAmountPromotions && this.unSatisfiedDynamicAmountPromotions.length > 0)) {
            this.checkForUnsatisfiedTargets(true);
          }
          else {
            //Go to Summary
            if (this.transactionCommonData.isThereAnyProductDiscountDefined) {
              this.transactionCommonData.soldItems = response.data.transCommonData.soldItems;
            }
            this.showSummaryUI();
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
      }
    );
  }
  checkBundles() {
    this.orderBundles = [];
    this.relatedToTargetPromotions = [];
    this.transactionCommonData.areDetailsFilled = true;
    this.validationService.checkOutBundles(this.transactionCommonData).subscribe(
      (response) => {
        if (response.status != null && response.status >= 0) {
          if (response.data.orderBundles && response.data.orderBundles.length > 0) {
            this.orderBundles = response.data.orderBundles;
          }
          else if(response.data.orderBundles.length == 0){
            this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.NoBundlesToShow),DialogMode.None)
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
      }
    );
  }
  checkForUnsatisfiedTargets(showSammary: boolean) {
    if ((this.unSatisfiedTargetPromotions && this.unSatisfiedTargetPromotions.length > 0 && (!this.unSatisfiedDynamicAmountPromotions || this.unSatisfiedDynamicAmountPromotions.length <= 0))) {
      this.coreSession.ModalDialog.ShowMessage(
        this.translateService.instant(ConstantMessages.MessageNoTargetsAchievedYet),
        DialogMode.YesNo,
        ''
      ).then((result: DialogResult) => {
        if (result === DialogResult.Yes) {
          if (showSammary) {
            this.showSummaryUI();
          }
          else
            this.openTakePromotions();
        }
      });
    }
    else if ((this.unSatisfiedDynamicAmountPromotions && this.unSatisfiedDynamicAmountPromotions.length > 0 && (!this.unSatisfiedTargetPromotions || this.unSatisfiedTargetPromotions.length <= 0))) {
      if (this.numOfAllDynamicPromotions == this.unSatisfiedDynamicAmountPromotions.length) {
        this.coreSession.ModalDialog.ShowMessage(
          this.translateService.instant(ConstantMessages.MessageNoDynamicTargetsAchievedYet),
          DialogMode.YesNo,
          ''
        ).then((result: DialogResult) => {
          if (result === DialogResult.Yes) {
            if (showSammary)
              this.showSummaryUI();
            else
              this.openTakePromotions();
          }
        });
      } else if (this.numOfAllDynamicPromotions > this.unSatisfiedDynamicAmountPromotions.length) { // some of dynamic promotions are not satisfied
        this.promotionsNames = '';
        this.lastInvoicePromotions.forEach(element => {
          if (this.unSatisfiedDynamicAmountPromotions.includes(element.promotionId)) {
            this.promotionsNames = this.promotionsNames + "\n" + "*  " + element.promotionName;
          }
        });
        this.coreSession.ModalDialog.ShowMessage(
          this.translateService.instant(ConstantMessages.MessageSomeOfDynamicTargetsNotAchievedYet) + "\n" + this.promotionsNames,
          DialogMode.YesNo,
          ''
        ).then((result: DialogResult) => {
          if (result === DialogResult.Yes) {
            if (showSammary)
              this.showSummaryUI();
            else
              this.openTakePromotions();
          }
        });
      }
    }
    else if ((this.unSatisfiedDynamicAmountPromotions && this.unSatisfiedDynamicAmountPromotions.length > 0 && this.unSatisfiedTargetPromotions && this.unSatisfiedTargetPromotions.length > 0)) {
      this.promotionsNames = '';
      this.lastInvoicePromotions.forEach(element => {
        if (this.unSatisfiedDynamicAmountPromotions.includes(element.promotionId)) {
          this.promotionsNames = this.promotionsNames + "\n" + "*  " + element.promotionName;
        }
      });
      this.coreSession.ModalDialog.ShowMessage(
        this.translateService.instant(ConstantMessages.MessageNotAchievedDynamicAndWholesales) + "\n" + this.promotionsNames,
        DialogMode.YesNo,
        ''
      ).then((result: DialogResult) => {
        if (result === DialogResult.Yes) {
          if (showSammary)
            this.showSummaryUI();
          else
            this.openTakePromotions();
        }
      });
    }
  }
  openLastInvoiceDialog() {
    this.transactionCommonData.lastInvoicePromotionsList = [];
    if (!this.transactionCommonData.onlyProductDiscount)
      this.transactionCommonData.notSelectedFirstLevelLastInvoice = [];
    //this.isLastInvoiceSelected = false;
    this.transactionCommonData.dontCheckLastInvoice = false;
    this.lastInvoiceDialog.showDialog().then(
      (result) => {
        if (result != -1) {
          if (result && result.length > 0) {
            result.forEach(element => {
              // this.customerPromotions.filter(x => x.promotionId == element.promotionId).forEach(c => c.isAppliedOnLastInvoice = true);
              this.transactionCommonData.lastInvoicePromotionsList.push(element.promotionId);
            });
          }
          else {
            if (result == null) {
              if (this.transactionCommonData.isThereAnyProductDiscountDefined) {
                // this.transactionCommonData.dontCheckLastInvoice = true;
                this.lastInvoicePromotions.forEach(promotion => {
                  this.transactionCommonData.notSelectedFirstLevelLastInvoice.push(promotion.promotionId)
                });
                this.lastInvoicePromotions = [];
              }
            }
          }
          this.checkPromotions(false, true);
        } else {

          this.lastInvoicePromotions = [];
          if (this.transactionCommonData.productPromotionLevelId == 2 && this.hideCloseButton)
            this.checkPromotions(false, true);
        }
      });
  }


  openLoyaltyDialog() {
    this.transactionCommonData.loyaltyPromotionsList = [];
    this.transactionCommonData.dontCheckLoyalty = false;
    this.loyaltyDialog.showDialog().then(
      (result) => {
        if (result != -1) {
          if (result && result.length > 0) {
            result.forEach(element => {
              this.transactionCommonData.loyaltyPromotionsList.push(element.promotionId);
            });
            if (this.lastInvoicePromotions && this.lastInvoicePromotions.length > 0)
              this.openLastInvoiceDialog();
            else {
              this.openTakePromotions();
            }
          }
          else {
            this.transactionCommonData.loyaltyPromotionsList = [];
            if (this.lastInvoicePromotions && this.lastInvoicePromotions.length > 0)
              this.openLastInvoiceDialog();
            else {
              this.checkPromotions(false, false);
            }
          }
          // this.checkPromotions(false);
        } else {
          this.transactionCommonData.loyaltyPromotionsList = [];
          this.loyaltyPromotions = [];
          if (this.lastInvoicePromotions && this.lastInvoicePromotions.length > 0)
            this.openLastInvoiceDialog();
          else
            this.checkPromotions(false, false);
        }
      });
  }

  openTakePromotions() {
    this.showTakePromotions = true;
    this.showSummary = false;
    this.showItemsSection = false;
    if (this.promotionCalculationSequence == 3 && !(this.lastPromotion || this.customerPromotions.length == 0))
      this.onNextClick();
  }

  takeSelectedPromotions() {
    this.validationService.takePromotions(this.transactionCommonData).subscribe(
      (response) => {
        if (response.status != null && response.status >= 0) {
          this.transactionCommonData = response.data;
          if (this.transactionCommonData.lastInvoicePromotionsList == null || (this.transactionCommonData.lastInvoicePromotionsList != null && this.transactionCommonData.lastInvoicePromotionsList.length == 0)) {
            this.lastInvoicePromotions = [];
            this.numOfAllDynamicPromotions = 0;
          }
          if (this.itemProcessMode === FormProcessMode.PartialDelivery || this.itemProcessMode === FormProcessMode.Delivery) {
            if (this.transactionCommonData.promotedItems && this.transactionCommonData.promotedItems.length > 0 &&
              this.transactionCommonData.promotedItems.findIndex(promoPack => promoPack.hasSerialNumber) !== -1) {
              this.promotionSerialItems = this.transactionCommonData.promotedItems.filter(promoPack => promoPack.hasSerialNumber);
              let serialSoldPacks = this.transactionCommonData.soldItems.filter(pack => pack.hasSerialNumber);
              if (serialSoldPacks && serialSoldPacks.length > 0) {
                serialSoldPacks.forEach(pack => {
                  pack.addedSerials.forEach(serial => {
                    this.addedSerialsForAllPacks.push(serial);
                  });
                });
              }
              this.showItemsSection = false;
              this.showTakePromotions = false;
              this.showPromotionSerials = true;
            } else {
              this.showSummaryUI();
            }
          } else {
            this.showSummaryUI();
          }

        } else {
          this.coreSession.showError('', this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError('', this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onSaveSerialsForPromotion() {
    this.showSummaryUI();
  }
  getCustomerRouteEmployees() {
    this.isEmployeeLoading = true;
    this.employeeFilter.customerId = this.customer.value;
    this.employeeFilter.outletId = this.outlet.value;
    this.employeeService
      .getCustomerRouteEmployees(this.employeeFilter)
      .subscribe(result => {
        this.CustomerRouteEmployeesDataSource = result;
        this.isEmployeeLoading = false;
      });
  }
  isDivisionLevel() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true";
  }
  applyDivisionsOnDocumentSequence() {
    return (this.isDivisionLevel() && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyDivisionsOnDocumentSequence).toLowerCase() === "true")
  }

  // calculateAvailabelItemsInItemGroupForSalesRestriction(availableQty: number, restrictionValue: number) {
  //   let total = restrictionValue -= availableQty;
  //   if (total < 0) {
  //     total = 0;
  //   }
  //   return total;
  // }

  calculateAvailabelItemsInItemGroupForSalesRestriction(availableQty: number, restrictionValue: number, piecesInPack: number) {
    let originalPack = (restrictionValue / piecesInPack);
    let total = originalPack -= availableQty;
    if (total < 0) {
      total = 0;
    }

    return total;
  }
  calculateRemainingItemsInItemGroupForSalesRestriction(item: any, mode: string, itemGroupID: number) {
    let totalItem = [];
    switch (mode) {
      case "Employee":
        if (item) {
          if (this.employeeSalesRestrictionItemGroup && this.employeeSalesRestrictionItemGroup.length > 0) {
            let indexItems = this.employeeSalesRestrictionItemGroup.findIndex(x => x.itemId === item.itemId && x.packTypeID === item.packTypeId);
            if (indexItems != -1) {
              //this.employeeSalesRestrictionItemGroup.splice(indexItems, 1);
            }
          }
          let containIndexItem = this.salesRestrictionStockData.employeesHasSalesRestriction.filter(x => x.itemId === item.itemId && x.itemGroupID > 0 && x.packID === item.packId);
          if (containIndexItem && containIndexItem.length) {
            containIndexItem.forEach(x => {

              let indexDuplicate = this.employeeSalesRestrictionItemGroup.findIndex(y => y.itemId === x.itemId && y.itemGroupID === x.itemGroupID && y.packId === item.packId)
              if (indexDuplicate >= 0)
                this.employeeSalesRestrictionItemGroup.splice(indexDuplicate, 1);

              this.employeeSalesRestrictionItemGroup.push({ itemId: item.itemId, packTypeID: item.packTypeId, requiredQty: (item.requiredQty * item.piecesInPack), itemGroupID: x.itemGroupID, packId: x.packID });
            })
          }
        }
        this.totalItemsInItemGroupEmployeeSalesRestriction = [];
        this.employeeSalesRestrictionItemGroup.forEach(x => {
          let index = this.totalItemsInItemGroupEmployeeSalesRestriction.findIndex(y => y.itemGroupID === x.itemGroupID);
          if (index >= 0) {
            this.totalItemsInItemGroupEmployeeSalesRestriction[index].requiredQty += x.requiredQty;
          } else {
            this.totalItemsInItemGroupEmployeeSalesRestriction.push({ itemGroupID: x.itemGroupID, requiredQty: x.requiredQty, packID: x.packId });
          }

        })
        this.totalItemsForEmployeeSalesRestrictionForItemGroup = totalItem;
        break;
      case "Customer":
        if (item) {
          if (this.customerSalesRestrictionItemGroup && this.customerSalesRestrictionItemGroup.length > 0) {
            let indexItes = this.customerSalesRestrictionItemGroup.findIndex(x => x.itemId === item.itemId && x.packTypeID === item.packTypeId);
            if (indexItes != -1) {
              //  this.customerSalesRestrictionItemGroup.splice(indexItes, 1);
            }
          }
          let containIndexItem = this.salesRestrictionStockData.customersHasSalesRestriction.filter(x => x.itemId === item.itemId && x.itemGroupID > 0 && x.packID === item.packId);
          if (containIndexItem && containIndexItem.length) {
            containIndexItem.forEach(x => {

              let indexDuplicate = this.customerSalesRestrictionItemGroup.findIndex(y => y.itemId === x.itemId && y.itemGroupID === x.itemGroupID && y.packId === item.packId)
              if (indexDuplicate >= 0)
                this.customerSalesRestrictionItemGroup.splice(indexDuplicate, 1);
              this.customerSalesRestrictionItemGroup.push({ itemId: item.itemId, packTypeID: item.packTypeId, requiredQty: (item.requiredQty * item.piecesInPack), itemGroupID: itemGroupID, packId: x.packID });
            })
          }
        }
        this.totalItemsInItemGroupCustomerSalesRestriction = [];
        this.customerSalesRestrictionItemGroup.forEach(x => {
          let index = this.totalItemsInItemGroupCustomerSalesRestriction.findIndex(y => y.itemGroupID === x.itemGroupID);
          if (index >= 0) {
            this.totalItemsInItemGroupCustomerSalesRestriction[index].requiredQty += x.requiredQty;
          } else {
            this.totalItemsInItemGroupCustomerSalesRestriction.push({ itemGroupID: x.itemGroupID, requiredQty: x.requiredQty, packID: x.packId });
          }

        })
        this.totalItemsForCustomerSalesRestrictionForItemGroup = totalItem;
        break;
    }
    return totalItem;
  }
  //#endregion

  //#region [EVENTS]

  onRecurringOrderClicked() {
    this.RecuringOrder.ShowDialog(this.recurringObj).then(res => {
      if (res)
        this.recurringObj = res;
      else {
        this.recurringObj = new Object();
      }
    });
  }

  // onRecuringSaved($event) {
  //   this.order.recurringTypeId = $event.typeId;
  //   this.order.recurringValue = $event.recurringValues;
  //   this.order.isRecurringActive = $event.isActive;
  // }
  employeePromotionSalesRestrictionCheck(promotedItems: any[], soldItems: any[]) {
    this.isEmployeeExceedsLimit = false;
    this.salesRestrictionEmployeeLimit = 0;
    if (this.salesRestrictionStockData
      && this.salesRestrictionStockData.employeesHasSalesRestriction
      && this.salesRestrictionStockData.employeesHasSalesRestriction.length > 0) {
      for (let i = 0; i < promotedItems.length; i++) {
        let index = this.salesRestrictionStockData.employeesHasSalesRestriction.findIndex(x => x.itemId === promotedItems[i].itemId && x.itemGroupID <= 0);
        let soldItemsIndex = soldItems.findIndex(x => x.itemId === promotedItems[i].itemId);
        if (index >= 0) {
          let newTotal = this.salesRestrictionStockData.employeesHasSalesRestriction[index].availableQuantity + (promotedItems[i].requiredQty * promotedItems[i].piecesInPack);
          let blockedItemIndex = this.blockedEmployeeItems.findIndex(x => x === promotedItems[i].itemId);
          if (soldItemsIndex >= 0)
            newTotal = newTotal + (soldItems[soldItemsIndex].requiredQty * soldItems[soldItemsIndex].piecesInPack);
          if (newTotal > this.salesRestrictionStockData.employeesHasSalesRestriction[index].quantity) {
            if (blockedItemIndex < 0) {
              this.blockedEmployeeItems.push(promotedItems[i].itemId);
            }
            this.isEmployeeExceedsLimit = true;
          } else {
            if (blockedItemIndex >= 0) {
              this.blockedEmployeeItems.splice(blockedItemIndex, 1);
            }
            this.isEmployeeExceedsLimit = false;
          }
        }
      }
    }

    // for item group level
    if (this.salesRestrictionStockData
      && this.salesRestrictionStockData.employeesHasSalesRestriction
      && this.salesRestrictionStockData.employeesHasSalesRestriction.length > 0) {
      for (let i = 0; i < promotedItems.length; i++) {
        let index = this.salesRestrictionStockData.employeesHasSalesRestriction.findIndex(x => x.itemId === promotedItems[i].itemId);
        let soldItemsIndex = soldItems.findIndex(x => x.itemId === promotedItems[i].itemId);
        if (index >= 0) {
          let newTotal = this.salesRestrictionStockData.employeesHasSalesRestriction[index].availableQuantity + (promotedItems[i].requiredQty * promotedItems[i].piecesInPack);
          let blockedItemIndex = this.blockedEmployeeItems.findIndex(x => x === promotedItems[i].itemId);
          if (soldItemsIndex >= 0)
            newTotal = newTotal + (soldItems[soldItemsIndex].requiredQty * soldItems[soldItemsIndex].piecesInPack);

          let totalInItemsBasedOnItemGroup = this.totalItemsInItemGroupEmployeeSalesRestriction.find(x => x.itemGroupID === this.salesRestrictionStockData.employeesHasSalesRestriction[index].itemGroupID);
          let totalItemsInItemGroupWithPromotedItems = (totalInItemsBasedOnItemGroup ? totalInItemsBasedOnItemGroup.requiredQty : 0) + promotedItems[i].requiredQty;
          if (newTotal > (this.salesRestrictionStockData.employeesHasSalesRestriction[index].quantity) || (totalItemsInItemGroupWithPromotedItems > this.calculateAvailabelItemsInItemGroupForSalesRestriction(this.salesRestrictionStockData.employeesHasSalesRestriction[index].availableQuantity, this.salesRestrictionStockData.employeesHasSalesRestriction[index].quantity, promotedItems[i].piecesInPack))) {
            if (blockedItemIndex < 0) {
              this.blockedEmployeeItems.push(promotedItems[i].itemId);
            }
            this.isEmployeeExceedsLimit = true;
          } else {
            if (blockedItemIndex >= 0) {
              this.blockedEmployeeItems.splice(blockedItemIndex, 1);
            }
            this.isEmployeeExceedsLimit = false;
          }
        }
      }
    }
    return this.isEmployeeExceedsLimit;
  }

  customerPromotionSalesRestrictionCheck(promotedItems: any[], soldItems: any[]) {
    this.isCustomerExceedsLimit = false;
    this.salesRestrictionCustomerLimit = 0;
    if (this.salesRestrictionStockData
      && this.salesRestrictionStockData.customersHasSalesRestriction
      && this.salesRestrictionStockData.customersHasSalesRestriction.length > 0) {
      for (let i = 0; i < promotedItems.length; i++) {
        let index = this.salesRestrictionStockData.customersHasSalesRestriction.findIndex(x => x.itemId === promotedItems[i].itemId && x.itemGroupID <= 0);
        let soldItemsIndex = soldItems.findIndex(x => x.itemId === promotedItems[i].itemId);

        if (index >= 0) {

          let newTotal = this.salesRestrictionStockData.customersHasSalesRestriction[index].availableQuantity + (promotedItems[i].requiredQty * promotedItems[i].piecesInPack);
          let blockedItemIndex = this.blockedCustomerItems.findIndex(x => x === promotedItems[i].itemId);
          if (soldItemsIndex >= 0)
            newTotal = newTotal + (soldItems[soldItemsIndex].requiredQty * soldItems[soldItemsIndex].piecesInPack);
          if (newTotal > this.salesRestrictionStockData.customersHasSalesRestriction[index].quantity) {
            if (blockedItemIndex < 0) {
              this.blockedCustomerItems.push(promotedItems[i].itemId);
            }
            this.isCustomerExceedsLimit = true;
          } else {
            if (blockedItemIndex >= 0) {
              this.blockedCustomerItems.splice(blockedItemIndex, 1);
            }
            this.isCustomerExceedsLimit = false;
          }
        }
      }
    }

    // for item group level
    if (this.salesRestrictionStockData && this.salesRestrictionStockData.customersHasSalesRestriction && this.salesRestrictionStockData.customersHasSalesRestriction.length > 0) {
      for (let i = 0; i < promotedItems.length; i++) {
        let index = this.salesRestrictionStockData.customersHasSalesRestriction.findIndex(x => x.itemId === promotedItems[i].itemId);
        let soldItemsIndex = soldItems.findIndex(x => x.itemId === promotedItems[i].itemId);
        if (index >= 0) {
          let newTotal = this.salesRestrictionStockData.customersHasSalesRestriction[index].availableQuantity + (promotedItems[i].requiredQty * promotedItems[i].piecesInPack);
          let blockedItemIndex = this.blockedCustomerItems.findIndex(x => x === promotedItems[i].itemId);
          if (soldItemsIndex >= 0)
            newTotal = newTotal + (soldItems[soldItemsIndex].requiredQty * soldItems[soldItemsIndex].piecesInPack);
          let totalInItemsBasedOnItemGroup = this.totalItemsForEmployeeSalesRestrictionForItemGroup.find(x => x.itemGroupID === this.salesRestrictionStockData.customersHasSalesRestriction[index].itemGroupID);
          let totalItemsInItemGroupWithPromotedItems = (totalInItemsBasedOnItemGroup ? totalInItemsBasedOnItemGroup.requiredQty : 0) + promotedItems[i].requiredQty;
          if (newTotal > (this.salesRestrictionStockData.customersHasSalesRestriction[index].quantity) || (totalItemsInItemGroupWithPromotedItems > this.calculateAvailabelItemsInItemGroupForSalesRestriction(this.salesRestrictionStockData.customersHasSalesRestriction[index].availableQuantity, this.salesRestrictionStockData.customersHasSalesRestriction[index].quantity, promotedItems[i].piecesInPack))) {
            if (blockedItemIndex < 0) {
              this.blockedCustomerItems.push(promotedItems[i].itemId);
            }
            this.isCustomerExceedsLimit = true;
          } else {
            if (blockedItemIndex >= 0) {
              this.blockedCustomerItems.splice(blockedItemIndex, 1);
            }
            this.isCustomerExceedsLimit = false;
          }
        }
      }
    }
    return this.isCustomerExceedsLimit;
  }
  onSaveClicked() {

    if (this.order && this.order.promotedItems && this.order.promotedItems.length > 0 && this.isSalesRestrictionFOCTransactionsIncluded) {
      this.employeePromotionSalesRestrictionCheck(this.order.promotedItems, this.order.soldItems);
      this.customerPromotionSalesRestrictionCheck(this.order.promotedItems, this.order.soldItems);
    }

    if (!this.order.soldItems || this.order.soldItems.length <= 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgSelectItem));
      return;
    }

    if (this.blockedEmployeeItems && this.blockedEmployeeItems.length > 0) {
      let itemIndex = this.salesRestrictionStockData.employeesHasSalesRestriction.findIndex(x => x.itemId === this.blockedEmployeeItems[0]);
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgEmployeeExceedsSalesRestrictionWithParameters).replace('{0}', this.salesRestrictionStockData.employeesHasSalesRestriction[itemIndex].itemCode).replace('{1}', this.calculationService.getNumberOnStockDigitFormat(this.salesRestrictionStockData.employeesHasSalesRestriction[itemIndex].quantity - this.salesRestrictionStockData.employeesHasSalesRestriction[itemIndex].availableQuantity)));
      return;
    }
    if (this.blockedCustomerItems && this.blockedCustomerItems.length > 0) {
      let itemIndex = this.salesRestrictionStockData.customersHasSalesRestriction.findIndex(x => x.itemId === this.blockedCustomerItems[0]);
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgCustomerExceedsSalesRestrictionWithParameters).replace('{0}', this.salesRestrictionStockData.customersHasSalesRestriction[itemIndex].itemCode).replace('{1}', this.calculationService.getNumberOnStockDigitFormat(this.salesRestrictionStockData.customersHasSalesRestriction[itemIndex].quantity - this.salesRestrictionStockData.customersHasSalesRestriction[itemIndex].availableQuantity)));
      return;
    }

    this.order.desiredDeliveryDateModel = this.desiredDeliveryDate;
    this.order.remarks = this.remarksControl.value;
    this.fillTransactionCommonData();
    // Fill Recuring Details
    if (this.recurringObj && this.recurringObj.typeId > 0) {
      this.order.recurringTypeId = this.recurringObj.typeId;
      this.order.recurringValue = this.recurringObj.recurringValues;
      this.order.recurringStatusId = this.recurringObj.statusId;
      this.order.recurringChangedReasonId = this.recurringObj.changedReasonId;
      this.order.resumeDateModel = this.recurringObj.resumeDate;
      this.order.recurringComment = this.recurringObj.recurringComment;
      // this.order.isRecurringActive = this.recurringObj.isActive;
    }
    if (this.isDelivery || this.isPartialDelivery) {
      this.InvoiceOrderClicked();
    } else if (this.isProcessReturn) {
      this.isReturnOrderValidToProcess();
    } else {
      if (this.isCreditLimitExceededOnCreate) { // outlet already exceed credit limit and user approved on that, no need to re-check it again
        // this.saveOrderToDB();
        this.isValidToAddOrUpdate();
      } else {
        this.validateOrderDataToSave(); // check if outlet limit, then save order
      }
    }

  }
  onBackClicked() {
    this.blockedCustomerItems = [];
    this.blockedEmployeeItems = [];
    if (this.order.orderTypeId === OrderTypes.Return.valueOf() && this.recalculateBenefitOnReturn && this.restrictReturnFromInvoices) {
      // Not used anymore (CHECK) ->
      this.order.allItems = this.order.allItems.filter(i => i.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn && i.salesTransactionTypeId !== SalesTransactionTypes.FOCReturn);
      this.order.allItems = [];
      this.order.allItems = cloneDeep(this.cachedOrderItems);
      this.allReturnOrderItems = [];
    }
    this.cancelPromotions();
  }

  onDesiredDeliveryDateSelected(date) {
    this.desiredDeliveryDate = date;
  }

  employeeSalesRestrictionCheck(soldItems: any) {
    this.isEmployeeExceedsLimit = false;
    this.salesRestrictionEmployeeLimit = 0;
    if (this.salesRestrictionStockData && this.salesRestrictionStockData.employeesHasSalesRestriction
      && this.salesRestrictionStockData.employeesHasSalesRestriction.length > 0) {
      let index = this.salesRestrictionStockData.employeesHasSalesRestriction.findIndex(x => x.itemId === soldItems.itemId && x.itemGroupID <= 0);
      if (index >= 0) {
        let newTotal = this.salesRestrictionStockData.employeesHasSalesRestriction[index].availableQuantity + (soldItems.requiredQty * soldItems.piecesInPack);
        let blockedItemIndex = this.blockedEmployeeItems.findIndex(x => x === soldItems.itemId);
        if (newTotal > this.salesRestrictionStockData.employeesHasSalesRestriction[index].quantity) {
          if (blockedItemIndex < 0) {
            this.blockedEmployeeItems.push(soldItems.itemId);
          }
          this.isEmployeeExceedsLimit = true;
          this.salesRestrictionEmployeeLimit = (this.salesRestrictionStockData.employeesHasSalesRestriction[index].quantity / soldItems.piecesInPack) - (this.salesRestrictionStockData.employeesHasSalesRestriction[index].availableQuantity / soldItems.piecesInPack);
        } else {
          if (blockedItemIndex >= 0) {
            this.blockedEmployeeItems.splice(blockedItemIndex, 1);
          }
          this.isEmployeeExceedsLimit = false;
          this.salesRestrictionEmployeeLimit = 0;
        }
      }
    }
    return this.isEmployeeExceedsLimit;

  }
  employeeSalesRestrictionCheckItemGroup(soldItems: any) {

    // for item group level
    if (this.salesRestrictionStockData
      && this.salesRestrictionStockData.employeesHasSalesRestriction
      && this.salesRestrictionStockData.employeesHasSalesRestriction.length > 0
      && !this.isEmployeeExceedsLimit) {
      let index = this.salesRestrictionStockData.employeesHasSalesRestriction.findIndex(x => x.itemId === soldItems.itemId && x.itemGroupID > 0 && x.packID === soldItems.packId);
      if (index != -1) {
        let blockedItemIndex = this.blockedEmployeeItemsGroup.findIndex(x => x === soldItems.itemId);
        if (index >= 0) {
          let newTotal = this.salesRestrictionStockData.employeesHasSalesRestriction[index].availableQuantity + (soldItems.requiredQty * soldItems.piecesInPack);
          this.calculateRemainingItemsInItemGroupForSalesRestriction(soldItems, "Employee", this.salesRestrictionStockData.employeesHasSalesRestriction[index].itemGroupID);

          let indexItems = this.totalItemsInItemGroupEmployeeSalesRestriction.findIndex(x => x.itemGroupID === this.salesRestrictionStockData.employeesHasSalesRestriction[index].itemGroupID);
          let totalItem = 0;
          if (indexItems >= 0)
            totalItem = this.totalItemsInItemGroupEmployeeSalesRestriction[indexItems].requiredQty;
          let totalAvailable = this.calculateAvailabelItemsInItemGroupForSalesRestriction(this.salesRestrictionStockData.employeesHasSalesRestriction[index].availableQuantity, this.salesRestrictionStockData.employeesHasSalesRestriction[index].quantity, soldItems.piecesInPack);
          if (newTotal > this.salesRestrictionStockData.employeesHasSalesRestriction[index].quantity || (totalItem > (totalAvailable))) {
            if (blockedItemIndex < 0) {
              this.blockedEmployeeItemsGroup.push(soldItems.itemId);
            }
            this.isEmployeeExceedsLimit = true;
            this.salesRestrictionEmployeeLimit = totalAvailable;;
          } else {
            if (blockedItemIndex >= 0) {
              this.blockedEmployeeItemsGroup.splice(blockedItemIndex, 1);
            } else {
              this.blockedEmployeeItemsGroup = [];
            }
            this.isEmployeeExceedsLimit = false;
            this.salesRestrictionEmployeeLimit = 0;
          }
        }
      }
    }

    return this.isEmployeeExceedsLimit;
  }




  customerSalesRestrictionCheck(soldItems: any) {

    this.isCustomerExceedsLimit = false;
    this.salesRestrictionCustomerLimit = 0;
    if (this.salesRestrictionStockData
      && this.salesRestrictionStockData.customersHasSalesRestriction
      && this.salesRestrictionStockData.customersHasSalesRestriction.length > 0) {
      let index = this.salesRestrictionStockData.customersHasSalesRestriction.findIndex(x => x.itemId === soldItems.itemId && x.itemGroupID <= 0);
      let blockedItemIndex = this.blockedCustomerItems.findIndex(x => x === soldItems.itemId);
      if (index >= 0) {
        let newTotal = this.salesRestrictionStockData.customersHasSalesRestriction[index].availableQuantity + (soldItems.requiredQty * soldItems.piecesInPack);
        if (newTotal > this.salesRestrictionStockData.customersHasSalesRestriction[index].quantity) {
          if (blockedItemIndex < 0) {
            this.blockedCustomerItems.push(soldItems.itemId);
          }
          this.isCustomerExceedsLimit = true;
          this.salesRestrictionCustomerLimit = (this.salesRestrictionStockData.customersHasSalesRestriction[index].quantity / soldItems.piecesInPack) - (this.salesRestrictionStockData.customersHasSalesRestriction[index].availableQuantity / soldItems.piecesInPack);
        } else {
          if (blockedItemIndex >= 0) {
            this.blockedCustomerItems.splice(blockedItemIndex, 1);
          }
          this.isCustomerExceedsLimit = false;
          this.salesRestrictionCustomerLimit = 0;
        }
      }
    }
    return this.isCustomerExceedsLimit;
  }
  customerSalesRestrictionCheckItemGroup(soldItems: any) {

    // for item group level
    if (this.salesRestrictionStockData
      && this.salesRestrictionStockData.customersHasSalesRestriction
      && this.salesRestrictionStockData.customersHasSalesRestriction.length > 0
      && !this.isCustomerExceedsLimit) {
      let index = this.salesRestrictionStockData.customersHasSalesRestriction.findIndex(x => x.itemId === soldItems.itemId && x.itemGroupID > 0 && x.packID === soldItems.packId);
      if (index != -1) {
        let blockedItemIndex = this.blockedCustomerItemsGroup.findIndex(x => x === soldItems.itemId);
        if (index >= 0) {
          let newTotal = this.salesRestrictionStockData.customersHasSalesRestriction[index].availableQuantity + (soldItems.requiredQty * soldItems.piecesInPack);
          this.calculateRemainingItemsInItemGroupForSalesRestriction(soldItems, "Customer", this.salesRestrictionStockData.customersHasSalesRestriction[index].itemGroupID);
          let indexItems = this.totalItemsInItemGroupCustomerSalesRestriction.findIndex(x => x.itemGroupID === this.salesRestrictionStockData.customersHasSalesRestriction[index].itemGroupID);
          let totalItem = 0;
          if (indexItems >= 0)
            totalItem = this.totalItemsInItemGroupCustomerSalesRestriction[indexItems].requiredQty;
          let totalAvailable = this.calculateAvailabelItemsInItemGroupForSalesRestriction(this.salesRestrictionStockData.customersHasSalesRestriction[index].availableQuantity, this.salesRestrictionStockData.customersHasSalesRestriction[index].quantity, soldItems.piecesInPack);
          if (newTotal > this.salesRestrictionStockData.customersHasSalesRestriction[index].quantity || (totalItem > totalAvailable)) {
            if (blockedItemIndex < 0) {
              this.blockedCustomerItemsGroup.push(soldItems.itemId);
            }
            this.isCustomerExceedsLimit = true;
            this.salesRestrictionCustomerLimit = totalAvailable != 0 ? totalAvailable : totalAvailable / soldItems.piecesInPack;
          } else {
            if (blockedItemIndex >= 0) {
              this.blockedCustomerItemsGroup.splice(blockedItemIndex, 1);
            } else {
              this.blockedCustomerItemsGroup = [];
            }
            this.isCustomerExceedsLimit = false;
            this.salesRestrictionCustomerLimit = 0;
          }
        }
      }
    }



    return this.isCustomerExceedsLimit;
  }
  onItemQtyChanged(item: any) {

    let checkEmployeeItemLevel = this.employeeSalesRestrictionCheck(item);
    let checkEmployeeItemGroupLevel = this.employeeSalesRestrictionCheckItemGroup(item);
    let checkCustomerItemLevel = this.customerSalesRestrictionCheck(item);
    let checkCustomerItemGroupLevel = this.customerSalesRestrictionCheckItemGroup(item);
    if (!this.isDelivery && !this.isPartialDelivery && this.isSalesRestrictionSalesOrderIncluded && checkEmployeeItemLevel || checkEmployeeItemGroupLevel) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgQtyExceedsAllowedEmployeeLimit) + this.calculationService.getNumberOnStockDigitFormat(this.salesRestrictionEmployeeLimit));
    }
    if (!this.isDelivery && !this.isPartialDelivery && this.isSalesRestrictionSalesOrderIncluded && checkCustomerItemLevel || checkCustomerItemGroupLevel) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgQtyExceedsAllowedCustomerLimit) + this.calculationService.getNumberOnStockDigitFormat(this.salesRestrictionCustomerLimit));
    }
  }
  onItemListFilled(items: any) {
    this.itemsList = items;
  }
  onCheckOutClicked(itemsData) {
    if (this.blockedEmployeeItems && this.blockedEmployeeItems.length > 0 || this.blockedEmployeeItemsGroup && this.blockedEmployeeItemsGroup.length > 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgEmployeeExceedsSalesRestriction));
      return;
    }
    if (this.blockedCustomerItems && this.blockedCustomerItems.length > 0 || this.blockedCustomerItemsGroup && this.blockedCustomerItemsGroup.length > 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgCustomerExceedsSalesRestriction));
      return;
    }
    this.order.soldItems = itemsData.itemsList;
    this.order.soldItems.forEach((i) => {
      i.originalPrice = i.price;//last edited one
    });
    this.totals = itemsData.totals;
    this.showBatches = itemsData.showBatches; // this will used in show batches in summary screen
    if ((this.isPartialDelivery && this.recalculatePromotionInDelivery || (this.promotionCalculationSequence == 3)) && this.order.orderTypeId !== OrderTypes.Return.valueOf()) {
      // this.totals.netTotal = this.totals.netTotal + this.totals.promotedDiscountTotal ;
      // this.totals.promotedDiscountTotal = 0;
      this.calculationService.cancelItemAndAllItemsPromotions(this.totals, this.order.soldItems);
    }
    this.order.promotedItems = [];
    this.order.netTotal = this.totals.netTotal;
    this.order.grossTotal = this.totals.grossTotal;
    this.order.tax = this.totals.taxTotal;
    this.order.calculatedRetailTax = this.totals.retailTaxTotal;
    this.order.discount = this.totals.discountTotal; //
    this.order.promotedDiscount = this.totals.promotedDiscountTotal;
    this.order.includedTaxAmount = this.totals.includedTaxAmount;
    this.fillTransactionCommonData();
    this.lastInvoicePromotions = []; // promotions which will be shown in last invoice dialog list
    this.resetReturnPromotionBenefitVariables();
    if (this.order.orderTypeId === OrderTypes.Return.valueOf() && this.recalculateBenefitOnReturn && this.restrictReturnFromInvoices) {
      this.order.allItems = this.order.allItems.filter(i => i.salesTransactionTypeId !== SalesTransactionTypes.FreeReturn);
    }
    if (this.isDelivery)
      this.hideBackButton = true;
    this.transactionCommonData.dontCheckLoyalty = true;
    // need to test when this.recalculatePromotionInDelivery is false
    if ((!this.isPartialDelivery) || ((this.isPartialDelivery && this.recalculatePromotionInDelivery) || (this.promotionCalculationSequence == 3 || (this.transactionCommonData.isThereAnyProductDiscountDefined)))) {
      this.transactionCommonData.dontCheckLastInvoice = true;
      if (this.order.orderTypeId !== OrderTypes.Return.valueOf()) {
        this.transactionCommonData.dontCheckLastInvoice = true;
        this.checkPromotions(true, false);
      } else {
        if (!this.restrictReturnFromInvoices || !this.recalculateBenefitOnReturn) {
          this.showSummaryUI();
        } else {
          // Recalculate new promotion benefit after return.
          var copyOfOrderItems = cloneDeep(itemsData.itemsList);
          this.recalculatePromotionBenefitForReturns(copyOfOrderItems, ReturnBenefitCalculationMode.None);
        }
      }
    }
    else {
      //Go to Summary
      this.showSummaryUI();
    }

  }

  resetReturnPromotionBenefitVariables() {
    this.allPromotionRanges = [];
    this.returnedBenefitModes = [];
    this.productDiscountPromotions = [];
    this.forcedToReturnPackLevel1 = [];
    this.forcedToReturnPackLevel2 = [];
    this.forcedToReturnPackLevel = [];
    this.productDiscountItemsList = [];
    this.tempForcedToReturnPack = [];
    this.allItemsReturnedAsDisc = [];
    this.rangesList = [];
    this.itemPackReturnDiscount = [];
    this.order.forcedDiscountItemBatches = [];
    this.order.forcedToReturnPacks = [];
    this.isAffectedByProductDiscount = false;
    this.cachedOrderItems = [];
    this.returnProdDiscBenefitHistory = [];
  }

  onSubmitHeaderDataClicked() {

    this.coreSession.markFormGroupTouched(this.orderForm);
    if (this.orderForm.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return false;
    }
    this.isCreditLimitExceededOnCreate = false;
    this.order.customerId = this.customer.value;
    this.order.customerRef = this.customerRef.value;
    this.order.outletId = this.outlet.value;
    this.order.warehouseId = this.warehouseIdControl.value != null ? this.warehouseIdControl.value : -1;

    if (this.orderTypeIdControl && this.orderTypeIdControl.value) {
      this.order.orderTypeId = this.orderTypeIdControl.value;
    }
    if (this.showOrderSourceSelection) {
      this.order.orderSourceID = this.selectedOrderSourceId;
    }
    if (this.allowCollectionMethodSelection && this.showCollectionMethodSelection) {
      this.order.collectionMethod = this.selectedCollectionMethodId;
    }
    if (this.enableSelectEmployeeForOrderInBO) {
      this.order.employeeId = this.employee.value;
    } else {
      this.order.employeeId = this.coreSession.CurrentOperator.employeeId;
    }
    if (this.isAddBundle) {
      this.isBundle = true;
      this.order.isBundle = true;
    }
    this.order.remarks = this.remarksControl.value;
    this.order.lpo = this.LPOControl.value;
    this.order.sdcId = this.enableSalesDistributionChannel && this.orderForm.get('sdcId').value ? this.orderForm.get('sdcId').value : -1;
    if (this.isDivisionLevel())
      this.order.divisionId = this.division.value;
    else
      this.order.divisionId = -1;
    this.transactionCommonData = new TransationCommonData();
    if (this.allowSalesModeSelectionForCustomer()) {
      this.showSalesModeSelectionDialog();
    } else {
      this.afterSubmitHeaderDataClicked();
    }

  }

  afterSubmitHeaderDataClicked() {
    if (this.applyDivisionsOnDocumentSequence()) {
      this.getMaxDocumentSequence()
    } else {
      this.fillTransactionCommonData();
      this.validateOrderDataToAdd();
    }
  }

  showSalesModeSelectionDialog() {
    this.orderForm.get('salesMode').setValue(
      this.selectedCustomerTypeId !== CustomerTypes.BillToBillCustomer.valueOf() ? this.selectedCustomerTypeId : 1);
    this.salesModeSelectionDialog.Show(true).then((res) => { });
  }

  getMaxDocumentSequence(dontProceed?: boolean) {
    let documentSequenceFilter = {
      divisionId: this.division.value ? this.division.value : -1,
      employeeId: this.coreSession.CurrentOperator.employeeId,
      documentType: this.selectedOrderTypeId = DocumentTypes.Order
    };
    this.validationService
      .getMaxDocumentSequence(documentSequenceFilter)
      .subscribe(
        response => {
          if (response.status != null && response.status >= 0) {
            this.orderForm.get('orderNumber').setValue(response.data);
            this.orderId = response.data;
            if (!dontProceed) {
              this.order.orderId = this.orderId,
                this.fillTransactionCommonData();
              this.validateOrderDataToAdd();
            } else {
              this.order.orderId = this.orderId;
            }

          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              response.message
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }

  getSalesRestrictionPacks(checkIsValidToAddOrUpdate: boolean = false) {
    this.isHideLoadingInItems = false;
    this.salesRestrictionFilter = new SalesRestrictionFilters();
    this.salesRestrictionFilter.customerId = this.transactionCommonData.customerId;
    this.salesRestrictionFilter.outletId = this.transactionCommonData.outletId;
    this.salesRestrictionFilter.orderId = this.order.orderId;

    if (this.isEdit) {
      this.order.allItems.forEach(element => {
        this.onItemQtyChanged(element);
      });
    }
    if (checkIsValidToAddOrUpdate) {
      this.isValidToAddOrUpdate();
    }
    // this.salesItemRestrictionService.getSaleRestrictionPacks(this.salesRestrictionFilter).subscribe(
    //   response => {
    //     this.coreSession.ModalLoading.Hide();
    //     this.salesRestrictionStockData = new SalesRestrictionStockModel();
    //     if (response.status != null && response.status >= 0) {
    //       this.salesRestrictionStockData = response.data;

    //     } else {
    //       this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    //     }
    //   },
    //   (error: HttpErrorResponse) => {
    //     this.coreSession.ModalLoading.Hide();
    //     this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    //   }
    // );
  }

  onPromotionTaken(selectedBenefits) {
    if (this.promotionCalculationSequence == 3) {
      this.lastPromotion = selectedBenefits.lastPromotion;
      this.currentLevelId = selectedBenefits.currentLevelId;
      this.nextLevelId = selectedBenefits.nextLevelId;
    }
    else if (this.transactionCommonData.isThereAnyProductDiscountDefined) {
      this.lastPromotion = selectedBenefits.lastPromotion;
      this.currentLevelId = 1;
      this.nextLevelId = 1;
    }
    else {
      this.lastPromotion = true;
      this.currentLevelId = 1;
      this.nextLevelId = 1;
    }
    if (selectedBenefits.promotions) {
      this.transactionCommonData.customerPromotions = selectedBenefits.promotions;
      this.transactionCommonData.promotionLevelId = this.promotionCalculationSequence == 3 ? this.nextLevelId : 1;
      if (this.isBundle) {
        this.order.soldItems = [];
        this.transactionCommonData.customerPromotions = selectedBenefits.promotions.filter(x => x.originalRepeatCount > 0);
        this.transactionCommonData.customerPromotions.forEach(promo => {
          promo.bundleItems.forEach(item => {
            var idx = this.order.soldItems.findIndex(x => x.packId == item.packId)
            if (idx < 0) {
              var bItem = promo.bundleItems.filter(x => x.packId == item.packId)[0];
              bItem.requiredQty = bItem.quantity * promo.originalRepeatCount;
              this.order.soldItems.push(bItem);
            }
            else
              this.order.soldItems[idx].requiredQty += item.quantity * promo.originalRepeatCount;
          });
        });
        this.transactionCommonData.soldItems = this.order.soldItems;
      }
      this.takeSelectedPromotions();
    }
  }
  onPromtionCanceled() {
    this.showTakePromotions = false;
    this.showSummary = false;
    this.showItemsSection = true;
    this.customerPromotions = [];
    this.copyCustomerPromotions = [];
    this.loyaltyPromotions = [];
    this.currentLevelId = 1;
    this.nextLevelId = 1;
    this.lastPromotion = false;
    this.hideCloseButton = false;
    if (this.transactionCommonData != null) {
      this.transactionCommonData.promotionLevelId = 1;
      this.transactionCommonData.productPromotionLevelId = 1;
      this.transactionCommonData.onlyProductDiscount = true;
      this.transactionCommonData.isThereAnyProductDiscountDefined = false;
      this.transactionCommonData.isSecondLevelProductDiscountTaken = false;
      this.transactionCommonData.quanityProductDiscountCount = 0;
      this.transactionCommonData.discountOrFreeItemsProductDiscountCount = 0;
      this.transactionCommonData.promotionsForAllLevels = [];
      this.transactionCommonData.notSelectedFirstLevelLastInvoice = [];
      this.transactionCommonData.lastInvoicePromotionsList = [];
      this.lastInvoicePromotions = [];
      if ((this.transactionCommonData.productDiscountFirstLevelList != null && this.transactionCommonData.productDiscountFirstLevelList.length > 0)
        || (this.transactionCommonData.productDiscountSecondLevelList != null && this.transactionCommonData.productDiscountSecondLevelList.length > 0)) {
        this.transactionCommonData.soldItems.forEach((pack, index) => {
          if (pack.totalProductDiscountQuantity > 0) {
            if (pack.totalProductDiscountQuantity == pack.requiredQty)
              this.transactionCommonData.soldItems.splice(index, 1);
            else if (pack.requiredQty > pack.totalProductDiscountQuantity)
              this.transactionCommonData.soldItems[index].requiredQty = this.transactionCommonData.soldItems[index].requiredQty - pack.totalProductDiscountQuantity;
          }
          pack.totalProductDiscountQuantity = 0;
        });
        this.order.soldItems = this.transactionCommonData.soldItems;
        this.transactionCommonData.productDiscountFirstLevelList = [];
        this.transactionCommonData.productDiscountSecondLevelList = [];
      }
    }
  }

  onCustomerDataChanged(data) {
    this.resetSDCData();
    if (this.showCustomerRouteEmployees && !data && !this.isEdit) {
      this.CustomerRouteEmployeesDataSource = [];
      this.employee.reset();
    }

  }

  onOutletDataChanged(data) {
    this.showCollectionMethodSelection = false;
    if (this.allowCollectionMethodSelection) {
      this.collectionMethodIdControl.setValidators(Validators.nullValidator)
      this.collectionMethodIdControl.updateValueAndValidity();
    }
    this.resetSDCData();
    this.selectedCustomerTypeId = data && data != undefined ? data.customerTypeId : -1;
    if (this.allowCollectionMethodSelection && this.selectedOrderTypeId != OrderTypes.Return.valueOf() && this.selectedCustomerTypeId == CustomerTypes.CashCustomer.valueOf()) {
      this.showCollectionMethodSelection = true;
      this.collectionMethodIdControl.setValidators(Validators.required)
      this.collectionMethodIdControl.updateValueAndValidity();
    }
    if (this.showCustomerRouteEmployees && !this.isEdit) {
      if (data) {
        this.getCustomerRouteEmployees();
      } else {
        this.CustomerRouteEmployeesDataSource = [];
        this.employee.reset();
      }
    }
    if (this.enableSalesDistributionChannel && data && data != undefined && this.orderTypeIdControl.value == OrderTypes.Sales) {
      this.getSelectedCustomerSDCs(data);
    }
  }

  getSelectedCustomerSDCs(data, isEditMode: boolean = false) { // Sales Distribution Channels
    this.isSDCLoading = true;
    var filter = {
      organizationIds: null,
      customerId: data.customerId,
      outletId: data.outletId
    }
    this.customerService.getAllSalesDistributionChannels(filter).subscribe(response => {
      this.isSDCLoading = false;
      if (response.status != null && response.status >= 0) {

        this.selectedCustomerSDCs = response.data;
        if (this.selectedCustomerSDCs.length > 0) {
          if (isEditMode && this.order && this.order.sdcId > 0) {
            this.showSDCSelection = true;
            this.orderForm.get('sdcId').setValidators(Validators.required);
            this.orderForm.get('sdcId').setValue(this.order.sdcId);
            this.orderForm.get('sdcId').disable();
            this.orderForm.get('sdcId').updateValueAndValidity();
          } else if (!isEditMode) {
            this.showSDCSelection = true;
            this.orderForm.get('sdcId').setValidators(Validators.required);
            if (this.selectedCustomerSDCs.length === 1) {
              // selected by default
              this.orderForm.get('sdcId').setValue(this.selectedCustomerSDCs[0].sdcId);
              this.orderForm.get('sdcId').disable();
            } else {
              this.orderForm.get('sdcId').enable();
            }
            this.orderForm.get('sdcId').updateValueAndValidity();
          }
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.isSDCLoading = false;
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });

  }

  resetSDCData() {
    this.showSDCSelection = false;
    this.selectedCustomerSDCs = [];
    this.orderForm.get('sdcId').setValue(null);
    this.orderForm.get('sdcId').setValidators(null);
    this.orderForm.get('sdcId').updateValueAndValidity();
  }
  //#endregion

  //#region [Delivery]
  InvoiceOrderClicked() {
    if (this.isPartialDelivery) {//must be changed to handle serials
      this.order.orderStatusFromUI = this.order.orderStatus;
      this.order.isThereAnyProductDiscountDefined = this.transactionCommonData.isThereAnyProductDiscountDefined;
      this.isOrderValidToInvoice();
    } else {
      this.InvoiceOrder();
    }
  }
  selectMainWarehouse() {
    this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.warehouseSelection, {
      centered: true
    });
    this.config.backdrop = true;
  }

  isOrderValidToInvoice() {
    this.order.orderStatus = OrderStatus.Delivered;
    this.order.orderOperation = OrderOperation.PartialDelivery;
    this.orderService.isOrderValidToInvoice(this.order).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.order = response.data;
          this.handlePartialDelivery();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  isReturnOrderValidToProcess() {
    this.order.orderStatusFromUI = this.order.orderStatus;

    if (this.itemProcessMode === FormProcessMode.ProcessReturn && this.restrictReturnFromInvoices) {
      var copyOfAllItems = cloneDeep(this.order.allItems);
      var copyOfSoldItems = cloneDeep(this.order.soldItems);
      this.order.allItems = [];
      this.order.soldItems = [];
    }

    this.orderService.isReturnOrderValidToProcess(this.order).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          if (this.itemProcessMode === FormProcessMode.ProcessReturn && this.restrictReturnFromInvoices) {
            this.order.allItems = copyOfAllItems;
            this.order.soldItems = copyOfSoldItems;
          }
          this.returnOrderConfirmation(this.order);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  handlePartialDelivery() {
    this.orderService.handlePartialDelivery(this.order).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.OrderDelivered)
          );
          this.onSaveComplete.emit();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  InvoiceOrder() {
    const filesArray = Array.from(this.attachedFiles || []);
    // foc
    var formData: FormData = new FormData();
    let sequence = 0;
    for (let i = 0; i < this.order.contractedFOCs.length; i++) {
      const contractedFOC = this.order.contractedFOCs[i];
      contractedFOC.FOCimagesSequence = [];
      for (let j = 0; j < filesArray.length; j++) {
        const file = filesArray[j];
        if (file.fOCId === contractedFOC.contractId) {
          contractedFOC.FOCimagesSequence.push(sequence);
          if (file.file) {
            formData.append("attachedFiles", file.file, file.name);
            sequence++;
          }
        }
      }
    }
    this.order.orderOperation = OrderOperation.FullDelivery;
    this.order.orderStatusFromUI = this.order.orderStatus;
    formData.append('orderModel', JSON.stringify(this.order));
    this.orderService.InvoiceOrder(formData).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          if (response.data && response.data.invalidZATCATransaction) {
            this.coreSession.showWarrningWithTimeOutDelay(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(response.data.message), 10000);
          } else {
            this.coreSession.showSuccess(
              this.translateService.instant(ConstantMessages.SuccessCaption),
              this.translateService.instant(ConstantMessages.OrderDelivered)
            );
            let trans = {
              divisionId: this.order.divisionId ? this.order.divisionId : -1,
              transactionId: this.order.orderId,
              customerId: this.order.customerId,
              outletId: this.order.outletId,
              reportMode: ReportMode.Delivered,
              isReprintReport: false
            }
            this.pdfCreatorService.ExportReport(trans);
          }
          this.onSaveComplete.emit();
        } else {
          if (response.data != null && response.data.length > 0) {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
            this.invalidSerials = response.data;
            this.invalidSerialsDialog.showDialog(0, 0).then(
              (result) => {

              });
          } else
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  initWarehouseForm() {
    let warehouseId: number;
    this.warehouseForm = new FormGroup({
      warehouseId: new FormControl(warehouseId, Validators.required)
    });
  }
  onCloseWarehouseModal() {
    this.modalRef.dismiss();
    this.warehouseForm.reset();
  }

  onWarehouseSelected() {
    if (this.warehouseForm.invalid) {

      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.SelectWarehouse)
      );
      return;
    }
    this.order.warehouseId = this.warehouseForm.get(
      "warehouseId"
    ).value;
    this.onCloseWarehouseModal();
    if (this.order.orderTypeId !== OrderTypes.Return.valueOf()) {
      this.isOrderValidToInvoice();
    } else {
      this.processRetunOrder();
    }
  }

  processRetunOrder() {
    var showPaymentDialog = false;
    if (this.restrictReturnFromInvoices) {
      showPaymentDialog = this.prepareOrderPacksPerBatchForSaving(this.order);
      if (showPaymentDialog) {
        this.initPaymentForm();
        this.openRequiredPaymentModal();
      } else {
        this.saveReturnOrderTransaction();
      }
    } else {
      this.saveReturnOrderTransaction();
    }
  }


  saveReturnOrderTransaction() {
    var data = {
      order: this.order,
      // orderNewBenefits: this.allPromotionRanges,
      orderNewBenefits: this.rangesList,
      payment: this.payment,
      debitTransaction: this.debitTransaction,
      returnedProdDiscBenefits: this.returnProdDiscBenefitHistory,
    }
    this.orderService.processRetunOrder(data).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgProcessedSuccessfully));
          this.onSaveComplete.emit();
          // this.isReturnMode = false;
          // this.populateAssignedOrderList();
          // let trans = {
          //   divisionId: this.order.divisionId ? this.order.divisionId : -1,
          //   transactionId: this.order.orderId,
          //   customerId: this.order.customerId,
          //   outletId: this.order.outletId,
          //   reportMode: ReportMode.SalesOrder,
          //   isReprintReport: false
          // }
          // this.pdfCreatorService.ExportReport(trans, true);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onSaveAfterSSCCCompleted() {
    // this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
    this.onSaveComplete.emit();
  }
  onSaveSerialsBySerialNoClick() {
    this.saveSerialsSubjectBySerialNo.next();
  }
  onAfterAddingItemsBySerial(savedPack) {
    // var originalPack;
    // if(this.filterOnSalesType)
    //  originalPack = this.originalItemsList.find(x => x.itemId === savedPack.itemId && x.packId === savedPack.packId && x.salesTransactionTypeId===savedPack.salesTransactionTypeId);
    //  else
    //  originalPack = this.originalItemsList.find(x => x.itemId === savedPack.itemId && x.packId === savedPack.packId);

    // if (originalPack) {
    //   if(this.filterOnSalesType)
    //   this.addedSerialsForAllPacks = this.addedSerialsForAllPacks.filter(serial => serial.itemId !== savedPack.itemId && serial.packId !== savedPack.packId && serial.salesTransactionTypeId !=savedPack.salesTransactionTypeId);
    //   else
    //   this.addedSerialsForAllPacks = this.addedSerialsForAllPacks.filter(serial => serial.itemId !== savedPack.itemId && serial.packId !== savedPack.packId);

    //   if (!this.addedSerialsForAllPacks) this.addedSerialsForAllPacks = [];

    //   if (savedPack.addedSerials && savedPack.addedSerials.length > 0) {
    //     savedPack.addedSerials.forEach(serial => {
    //       this.addedSerialsForAllPacks.push(serial);
    //     });
    //   }
    //   originalPack.addedSerials = savedPack.addedSerials;
    //   originalPack.requiredQty = savedPack.requiredQty;
    //   originalPack.expiryDateModel.date = this.coreSession.DefaultBatchNumber;
    //   originalPack.expiryDateModel.day = this.coreSession.DefaultExpiryDate().getDay();
    //   originalPack.expiryDateModel.month = this.coreSession.DefaultExpiryDate().getMonth() + 1;
    //   originalPack.expiryDateModel.year = this.coreSession.DefaultExpiryDate().getFullYear();
    //   originalPack.batchNo = this.coreSession.DefaultBatchNumber;
    // } else {
    //   return;
    // }
    // if(!this.allAddedPackObjects){
    //   this.allAddedPackObjects = [];
    // }
    // if(!isFromAddItemBySerial){
    //  this.fillAddedSerialsInAllAddedPackObjects(savedPack);

    // }
    // this.onAddEditItemClicked(originalPack);
    this.showAddItemsBySerial = false;
  }
  closeSerialsSlider() {
    this.showAddItemsBySerial = false;
  }

  fillOrderTypeDataSource() {
    var filter = [];
    filter.push(OrderTypes.Sales.valueOf());
    // if (!this.isAddBundle)
    //   filter.push(OrderTypes.Return.valueOf());

    this.orderService.getOrderTypes(filter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.salesOrderTypesDataSource = response.data;
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  fillOrderSourceDataSource() {
    this.isOrderSourceLoading = true;
    this.orderService.getOrderSources().subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.orderSourcesDataSource = response.data;
        this.isOrderSourceLoading = false;
      }
    }, (error: HttpErrorResponse) => {
      this.isOrderSourceLoading = false;
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }

  getReturnReasonDescriptions() {
    this.returnReasonDescriptions = [];
    this.itemService.getReturnReasons(-1).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data && response.data.length > 0) {

          this.returnReasonDescriptions = response.data;
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }

  onOrderTypeSelected(order) {
    this.resetSDCData();
    this.restrictReturnFromInvoices = this.sessionData.getConfigurationValue(ConstantConfigurations.RestrictReturnFromInvoices).toLowerCase() === "true";
    this.restrictReturnQtyFromInvoices = this.sessionData.getConfigurationValue(ConstantConfigurations.RestrictReturnQtyFromInvoices).toLowerCase() === "true";
    this.selectedOrderTypeId = -1;
    this.desiredDeliveryDateProperties.label = 'Desc_Desired_Delivery_Date';
    if (order && order != undefined) {
      if (order.orderTypeId === OrderTypes.Return.valueOf()) {
        this.warehouseIdControl.clearValidators()
        this.warehouseIdControl.updateValueAndValidity()
        this.desiredDeliveryDateProperties.label = 'Desc_Process_Date';
        if (!this.returnReasonDescriptions || this.returnReasonDescriptions.length > 0) {
          this.getReturnReasonDescriptions();
        }
        if (this.restrictReturnFromInvoices && this.restrictReturnQtyFromInvoices && this.allowOptionalReturnFromInvoices) {
          this.coreSession.ModalDialog.ShowMessage(
            this.translateService.instant(ConstantMessages.DescRestrictReturnFromOldInvoicesConfirmation),
            DialogMode.YesNo,
            this.translateService.instant(ConstantMessages.WarningCaption)
          ).then((result: DialogResult) => {
            if (result === DialogResult.No || result == DialogResult.None) {
              this.restrictReturnFromInvoices = false;
              this.restrictReturnQtyFromInvoices = false;
            }
          });
        }
      }
      else if(order.orderTypeId === OrderTypes.Sales.valueOf()){
        this.warehouseIdControl.setValidators(Validators.required)
        this.warehouseIdControl.updateValueAndValidity()
      }
      this.selectedOrderTypeId = order.orderTypeId;
      if (this.allowCollectionMethodSelection) {
        if (this.selectedOrderTypeId == OrderTypes.Return.valueOf()) {
          this.showCollectionMethodSelection = false;
          this.showCollectionMethodSelectionInSalesModeSelection = false;
          this.collectionMethodIdControl.setValidators(Validators.nullValidator)
          this.collectionMethodIdControl.updateValueAndValidity();
        }
      }
      this.getMaxDocumentSequence(true);
    }
  }
  onOrderSourceSelected(order) {
    this.selectedOrderSourceId = order.sourceId;
  }
  onCollectionMethodSelected(collectionMethod) {
    this.selectedCollectionMethodId = collectionMethod.collectionMethodId;
  }

  returnOrderConfirmation(order: any) {
    var orderItemsPackStatuses = order.allItems.map(i => i.packStatusId);
    //check id order contain any resellable items.
    this.orderService.checkResellableItems(orderItemsPackStatuses).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {

          if (response.data) {
            this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.ReturnProcessConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
              (result: DialogResult) => {
                if (result === DialogResult.Yes) {
                  this.selectMainWarehouse();
                }
              });
          } else {
            this.processRetunOrder();
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  recalculatePromotionBenefitForReturns(selectedItems, lastCalculationMode: ReturnBenefitCalculationMode) {
    var returnCommonData = new ReturnAgainstInvoicesModel();
    returnCommonData.returnedPacks = [];
    returnCommonData.returnedPacks.push(...selectedItems);
    returnCommonData.customerId = this.order.customerId;
    returnCommonData.outletId = this.order.outletId;
    returnCommonData.calculationMode = lastCalculationMode;
    this.orderService.recalculateBenefitInReturn(returnCommonData).subscribe((response) => {
      if (response.status != null && response.status >= 0) {
        if (response.data && response.data.length > 0) {

          this.returnBenefitMode = response.data[0].benefitMode;
          if (this.returnedBenefitModes.findIndex(b => b === response.data[0].benefitMode) === -1) {
            this.returnedBenefitModes.push(response.data[0].benefitMode);
          }
          // response.data is on promotion range level.
          this.allPromotionRanges = this.allPromotionRanges.concat(response.data);
          this.addToProductDiscountPromotions(this.allPromotionRanges);
          this.validateQuantityForRanges(response.data, selectedItems);
        } else {
          // No Benefits to return, continue saving..
          this.showSummaryUI();
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), ConstantMessages.ErrorHappened);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
    }
    );
  }
  addToProductDiscountPromotions(promotions: any[]) {
    promotions.map(promotion => {
      if (promotion.benefitMode === ReturnBenefitCalculationMode.ProductDiscountQuantityBenefit ||
        promotion.benefitMode === ReturnBenefitCalculationMode.ProductDiscountQuantityOrDiscountBenefit) {
        var i = this.productDiscountPromotions.findIndex(p =>
          p.promotionId === promotion.promotionId &&
          p.startDate.day === promotion.startDate.day &&
          p.startDate.month === promotion.startDate.month &&
          p.startDate.year === promotion.startDate.year &&
          p.startDate.date === promotion.startDate.date &&
          p.endDate.day === promotion.startDate.day &&
          p.endDate.month === promotion.endDate.month &&
          p.endDate.year === promotion.endDate.year &&
          p.endDate.date === promotion.endDate.date &&
          p.benefitMode === promotion.benefitMode
        );
        if (i === -1) this.productDiscountPromotions.push(promotion);
      }
    });
  }
  validateQuantityForRanges(promotionRanges: any[], selectedOrderItems: any[]) {
    var quantityBasedPromotionRanges = promotionRanges.filter(p =>
      (p.benefitsToReturn[0].packId > -1 && p.benefitsToReturn[0].benefitOptionDetailTypeId === PromotionOutputDetailTypes.ItemQuantity.valueOf()) ||
      (p.benefitsToReturn[0].packGroupId > -1 &&
        (
          p.benefitsToReturn[0].benefitOptionDetailTypeId === PromotionOutputDetailTypes.SummationOverGroup.valueOf() ||
          (p.benefitsToReturn[0].benefitOptionDetailTypeId === PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount.valueOf() && p.benefitsToReturn[0].allowedPacksFromPackGroup && p.benefitsToReturn[0].allowedPacksFromPackGroup.length > 0)
        )
      )
    );
    var discountBasedPromotions = promotionRanges.filter(p =>
      (p.benefitsToReturn[0].packId === -1 && p.benefitsToReturn[0].packGroupId === -1 && p.benefitsToReturn[0].benefitOptionDetailTypeId === PromotionOutputDetailTypes.AllItemDiscountPercentage.valueOf())
      || (p.benefitsToReturn[0].packId > -1 && p.benefitsToReturn[0].benefitOptionDetailTypeId === PromotionOutputDetailTypes.DiscountPercentageForItem.valueOf())
      || (p.benefitsToReturn[0].packGroupId > -1 &&
        (
          p.benefitsToReturn[0].benefitOptionDetailTypeId === PromotionOutputDetailTypes.DiscountPercentageForGroupItems.valueOf() ||
          (p.benefitsToReturn[0].benefitOptionDetailTypeId === PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount.valueOf() && (!p.benefitsToReturn[0].allowedPacksFromPackGroup || p.benefitsToReturn[0].allowedPacksFromPackGroup.length == 0))
        )
      )
    );

    if ((quantityBasedPromotionRanges && quantityBasedPromotionRanges.length > 0) ||
      (discountBasedPromotions && discountBasedPromotions.length > 0)
    ) {
      // Check that availability and requested are updated with PD items..
      var ranges = quantityBasedPromotionRanges.concat(discountBasedPromotions);
      var result = this.getAllBenefitsItemIdsAndTransactionIds(ranges);
      var allBenefitItems = result.allBenefitItems;
      var allTransactionIds = result.allTransactionIds;

      var allItems = [];
      var orderItemIds = selectedOrderItems.map(i => i.itemId);
      allItems.push(...orderItemIds);
      allItems.push(...allBenefitItems);
      if (allItems && allItems.length > 0) {
        this.fillBatchesListForBenefitAndOrderItems(allItems, allBenefitItems, allTransactionIds, quantityBasedPromotionRanges, discountBasedPromotions, selectedOrderItems);
      }
    }
  }

  getUniqueItemIds(allItems): any[] {
    var items = []
    const unique = (value, index, self) => {
      return self.indexOf(value) === index
    }
    items = allItems.filter(unique);
    return items ? items : [];
  }

  fillBatchesListForBenefitAndOrderItems(allItems: any[], allBenefitItems: any[], allTransactionIds: any[], quantityBasedPromotionRanges: any[], discountPromotionRanges: any[], selectedOrderItems: any[]) {
    var filter = {
      itemIdsList: allItems,
      customerId: this.order.customerId,
      outletId: this.order.outletId
    }
    this.itemService.fillCustomerBatchesForBenefitItems(filter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data && response.data.length > 0) {
          this.customerItemBatchesList = response.data;
          // TEST !
          this.transactionsIncludedInBenefit = [];
          this.copyOfTransactionsIncludedInBenefit = [];
          // ??? allItems 1 or 2
          var itemIdsList = this.getUniqueItemIds(allItems);
          // this.fillAvailableQtyForAllBenefitPacks(allBenefitItems, allTransactionIds, selectedOrderItems);
          this.fillAvailableQtyForAllBenefitPacks(itemIdsList, allTransactionIds, selectedOrderItems);
          // TEST !
          this.copyOfTransactionsIncludedInBenefit = cloneDeep(this.transactionsIncludedInBenefit);
          // if response.data is empty.. validation will continue but avl qty from all items will be 0,
          // so, all promotions benefit will be applied as discount.
          // this.transactionsIncludedInBenefit = [];
          quantityBasedPromotionRanges.forEach(range => {
            if (range.benefitsToReturn[0].packId > -1) {
              this.validateQtyForPackLevelBenefit(range, selectedOrderItems);
            } else if (range.benefitsToReturn[0].packGroupId > -1) {
              this.validateQtyForPackGroupLevelBenefit(range, selectedOrderItems)
            }
          });
          // after looping through all benefits, check all non-discount qty promotions.
          this.promotionsAfterReturnList = quantityBasedPromotionRanges;
          if (discountPromotionRanges && discountPromotionRanges.length > 0) {
            discountPromotionRanges.forEach(r => { r.isDiscount = true });
          }
          this.promotionsAfterReturnList.push(...discountPromotionRanges);
          this.openAfterReturnPromotionsDialog();
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), ConstantMessages.ErrorHappened);
        return;
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
    });
  }

  fillAvailableQtyForAllBenefitPacks(allBenefitItems: any[], allTransactionIds: any[], selectedOrderItems) {
    allBenefitItems.forEach(i => {
      this.getOriginalAvlQtyForPackFromTransactions2(i, allTransactionIds);
      if (this.transactionsIncludedInBenefit && this.transactionsIncludedInBenefit.length > 0) {
        // If product discount.. you have to send selectedOrderItems = selectedOrderItems + PD items.
        this.getPackTotalAddedQtyFromTransactions2(i, allTransactionIds, selectedOrderItems);
      }
    });
  }

  getAllBenefitsItemIdsAndTransactionIds(quantityBasedPromotionRanges: any[]) {
    const unique = (value, index, self) => {
      return self.indexOf(value) === index
    }
    var allTransactionIds = [];
    quantityBasedPromotionRanges.map(range => allTransactionIds.push(...range.rangeTransactionIds));
    // quantityBasedPromotionRanges.filter(range => allTransactionIds.push(...range.rangeTransactionIds));

    allTransactionIds = allTransactionIds.filter(unique);

    var allBenefitItems = [];
    var packsBenefits = quantityBasedPromotionRanges.filter(p => p.benefitsToReturn[0].packId > -1);
    var packGroupBenefits = quantityBasedPromotionRanges.filter(p => p.benefitsToReturn[0].packGroupId > -1);
    if (packsBenefits && packsBenefits.length > 0) {
      var listOfPacks = [];
      packsBenefits.map(pb => listOfPacks.push(...pb.benefitsToReturn));
      allBenefitItems.push(...listOfPacks.map(p => p.itemId));
    }
    if (packGroupBenefits && packGroupBenefits.length > 0) {
      var listOfPackGroups = [];
      packGroupBenefits.map(pgb => {
        listOfPackGroups.push(...pgb.benefitsToReturn);
      });
      listOfPackGroups.map(pg => {
        allBenefitItems.push(...pg.allowedPacksFromPackGroup.map(p => p.itemId));
      });
    }
    allBenefitItems = allBenefitItems.filter(unique);
    var data = {
      allBenefitItems: allBenefitItems,
      allTransactionIds: allTransactionIds
    }
    return data;
  }

  validateQtyForPackLevelBenefit(range: any, selectedOrderItems: any[]) {
    range.benefitsToReturn.forEach(benefit => {
      var originalTotalRequiredReturnQtyInPcs = benefit.returnValue * benefit.piecesInPack;
      var totalRequiredReturnQtyInPcs = benefit.returnValue * benefit.piecesInPack;
      range.rangeTransactionIds.forEach(transactionId => {
        var allItemBatchesPerTrans = cloneDeep(this.transactionsIncludedInBenefit.filter(
          b => b.transactionId === transactionId && b.itemId === benefit.itemId));
        while (allItemBatchesPerTrans.length > 0 && totalRequiredReturnQtyInPcs > 0) {
          var txObj = this.getItemBatchWithMaxQty(allItemBatchesPerTrans);
          if (txObj.availableQtyInPcs > 0) {
            if (totalRequiredReturnQtyInPcs <= txObj.availableQtyInPcs) {
              txObj.availableQtyInPcs -= totalRequiredReturnQtyInPcs;
              totalRequiredReturnQtyInPcs = 0;
            } else {
              totalRequiredReturnQtyInPcs -= txObj.availableQtyInPcs;
              txObj.availableQtyInPcs = 0;
            }
          }
        }
      }); // forEach => rangeTransactionIds
      if (totalRequiredReturnQtyInPcs > 0) {
        // if there is still qty to return, promotion range transactions do not have enough quantity for return,
        // force benefit as discount.
        // apply promotin range as discount.
        range.isDiscount = true;
        range.forceDiscount = true;
      }
    });
  }

  getItemBatchWithMaxQty(allItemBatchesPerTrans: any[]) {
    var itemBatchWithMaxQty = allItemBatchesPerTrans.reduce(function (prev, current) {
      return (prev.availableQtyInPcs > current.availableQtyInPcs) ? prev : current
    });

    var id = allItemBatchesPerTrans.findIndex(tx =>
      tx.transactionId === itemBatchWithMaxQty.transactionId &&
      tx.itemId === itemBatchWithMaxQty.itemId &&
      tx.batchNo === itemBatchWithMaxQty.batchNo &&
      tx.expiryDateModel.day === itemBatchWithMaxQty.expiryDateModel.day &&
      tx.expiryDateModel.month === itemBatchWithMaxQty.expiryDateModel.month &&
      tx.expiryDateModel.year === itemBatchWithMaxQty.expiryDateModel.year &&
      tx.expiryDateModel.date === itemBatchWithMaxQty.expiryDateModel.date);

    var txObj = allItemBatchesPerTrans[id];
    allItemBatchesPerTrans.splice(id, 1);

    return txObj;
  }

  validateQtyForPackGroupLevelBenefit(range: any, selectedOrderItems: any[]) {
    range.benefitsToReturn.forEach(benefit => { // each benefit is on a different PackGroup
      var calculatedItems = [];
      var totalAvlForPackGroup = 0;
      var totalReturnValueForPackGroup = benefit.returnValue;
      var totalAvlAsBenefit = 0;

      benefit.allowedPacksFromPackGroup.forEach(pack => {
        if (this.transactionsIncludedInBenefit && this.transactionsIncludedInBenefit.length > 0) {
          var totalAvlInPcs = 0;
          var validTxs = this.transactionsIncludedInBenefit.filter(
            t => range.rangeTransactionIds.includes(t.transactionId) &&
              t.itemId === pack.itemId
          );
          validTxs.map(tx => totalAvlInPcs += this.calculationService.getNumberOnStockDigitFormat(tx.availableQtyInPcs));
          pack.availableQtyInPcs = totalAvlInPcs;
          if (calculatedItems.findIndex(i => i === pack.itemId) === -1) {
            totalAvlForPackGroup += (totalAvlInPcs / pack.packGroupPiecesInPack);
            calculatedItems.push(pack.itemId);
          }
        }
        totalAvlAsBenefit +=
          ((pack.availableQtyToReturn * pack.piecesInPack) / pack.packGroupPiecesInPack) < pack.availableQtyInPcs / pack.packGroupPiecesInPack ?
            ((pack.availableQtyToReturn * pack.piecesInPack) / pack.packGroupPiecesInPack) :
            pack.availableQtyInPcs / pack.packGroupPiecesInPack;
      });
      if (
        (this.calculationService.getNumberOnStockDigitFormat(totalReturnValueForPackGroup) > this.calculationService.getNumberOnStockDigitFormat(totalAvlForPackGroup)) ||
        (totalAvlAsBenefit < this.calculationService.getNumberOnStockDigitFormat(totalReturnValueForPackGroup))
      ) {
        range.isDiscount = true;
        range.forceDiscount = true;
      }
    });
  }

  getTransctionTotalOriginalAvlQty(benefit: any, transactionId: any) {
    // get total sold qty of benefit pack for transaction.
    // if total sold qty = 0, skip this transaction, as it does not contain the required item
    var totalOriginalAvlQty = 0;
    var itemBatchesList = this.customerItemBatchesList.filter(b => b.itemId === benefit.itemId);
    itemBatchesList.map(tx => {
      if (tx.transactionId === transactionId) {
        totalOriginalAvlQty += tx.originalAvailableQtyFromInvoice;
        // Per Tx-Item (if item has multi batches per tx add batches qty
      }
    });

    return totalOriginalAvlQty;
  }

  getTransctionTotalAddedQty(benefit: any, transactionId: any, selectedOrderItems: any[]) {
    var totalAddedQty = 0;
    // all item packs for item [benefit item]
    var allItemPacks = selectedOrderItems.filter(i => i.itemId === benefit.itemId);

    allItemPacks.map(i => {
      var addedTransactions = i.returnFromInvoiceAvailableBatchList.filter(tx => tx.transactionId === transactionId && tx.requiredQuantity > 0);
      addedTransactions.map(tx => {
        totalAddedQty += tx.requiredQuantity * i.piecesInPack;
      });
    });

    return totalAddedQty;
  }

  getOriginalAvlQtyForPackFromTransactions2(itemId: number, transactionIds: any[]) {
    var totalOriginalAvlQty = 0;
    var itemBatchesList = this.customerItemBatchesList.filter(b =>
      b.itemId === itemId && transactionIds.includes(b.transactionId));
    // var idx = this.customerBatchesList
    //   .findIndex(i => i.itemId === pack.itemId && i.packId === pack.packId);
    if (itemBatchesList && itemBatchesList.length > 0) {
      itemBatchesList.map(tx => {
        if (transactionIds.includes(tx.transactionId)) {
          var i = this.transactionsIncludedInBenefit.findIndex(o =>
            o.itemId === itemId &&
            o.transactionId === tx.transactionId &&
            o.batchNo === tx.batchNo &&
            o.expiryDateModel.day === tx.expiryDateModel.day &&
            o.expiryDateModel.month === tx.expiryDateModel.month &&
            o.expiryDateModel.year === tx.expiryDateModel.year &&
            o.expiryDateModel.date === tx.expiryDateModel.date); // hour,minute,second ?
          if (i === -1) {
            var txObj = {
              itemId: itemId,
              transactionId: tx.transactionId,
              originalAvailableQtyInPcs: tx.originalAvailableQtyFromInvoice,
              availableQtyInPcs: tx.originalAvailableQtyFromInvoice,
              totalRequiredQtyInPcs: 0,
              totalRequiredReturnQtyInPcs: 0,
              batchNo: tx.batchNo,
              expiryDateModel: tx.expiryDateModel,
              baseExciseTax: tx.baseExciseTax,
              basePrice: tx.basePrice,
              baseTaxPercentage: tx.baseTaxPercentage,
              discountPercentage: tx.discountPercentage,
              netPrice: tx.netPrice
            };
            this.transactionsIncludedInBenefit.push(txObj);
          }
        }
      });
    }
  }

  getPackTotalAddedQtyFromTransactions2(itemId: number, transactionIds: any[], selectedOrderItems) {
    var allItemPacks = selectedOrderItems.filter(i => i.itemId === itemId);

    allItemPacks.map(i => {
      var addedTransactions = i.returnFromInvoiceAvailableBatchList.filter(tx => transactionIds.includes(tx.transactionId) && tx.requiredQuantity > 0);
      addedTransactions.map(tx => {
        var idx = this.transactionsIncludedInBenefit.findIndex(o =>
          o.itemId === itemId &&
          o.transactionId === tx.transactionId &&
          o.batchNo === tx.batchNo &&
          o.expiryDateModel.day === tx.expiryDateModel.day &&
          o.expiryDateModel.month === tx.expiryDateModel.month &&
          o.expiryDateModel.year === tx.expiryDateModel.year &&
          o.expiryDateModel.date === tx.expiryDateModel.date);
        if (idx > -1) {
          this.transactionsIncludedInBenefit[idx].totalRequiredQtyInPcs += (tx.requiredQuantity * i.piecesInPack);
          this.transactionsIncludedInBenefit[idx].availableQtyInPcs -= tx.requiredQuantity * i.piecesInPack;
        }
      });
    });
  }
  openAfterReturnPromotionsDialog() {
    this.promotionsAfterReturnDialog.Show(true).then((res) => { });
  }

  // Dialog Results [promotionsAfterReturnDialog]
  onReturnPromotionDialogSave(event) {
    if (event && event.saveCLicked) {
      this.saveAfterReturnPromotionsSubj.next('save');
    }
  }
  onReturnPromotionDialogCancel() {
    this.saveAfterReturnPromotionsSubj.next("cancel");
  }
  // End of Dialog Results

  afterTakeReturnPromotionBenefit(result) {
    this.afterSaveReturnPromotionsResult(result);
    this.continueBasedOnReturnedBenefitMode(this.returnBenefitMode);
  }

  afterSaveReturnPromotionsResult(result: any) {
    this.rangesList = this.rangesList.concat(result.rangesList);
    this.allBenefitsDiscounts = [];
    var resetValues = true;
    if (this.returnedBenefitModes && this.returnedBenefitModes.length > 1) {
      resetValues = false;
    }
    if (resetValues) { this.itemPackReturnDiscount = []; }
    this.promotionsAfterReturnDialog.Close();
    if (result.forcedToReturnItemBatches && result.forcedToReturnItemBatches.length > 0) {
      if (resetValues) {
        this.order.forcedToReturnPacks = result.forcedToReturnItemBatches; // transaction-batch level. [For saving]
      }
      else {
        this.addToForcedToReturnForMultiLevelBenefit(result.forcedToReturnItemBatches);
      }
    }
    if (result.forcedToReturnPackLevel && result.forcedToReturnPackLevel.length > 0) {
      if (resetValues) {
        this.forcedToReturnPackLevel = [];
        this.forcedToReturnPackLevel1 = [];
        this.forcedToReturnPackLevel2 = [];
      }
      if (result.benefitMode === ReturnBenefitCalculationMode.ProductDiscountQuantityBenefit) {
        this.forcedToReturnPackLevel1.push(...result.forcedToReturnPackLevel);
      } else if (result.benefitMode === ReturnBenefitCalculationMode.ProductDiscountQuantityOrDiscountBenefit) {
        this.forcedToReturnPackLevel2.push(...result.forcedToReturnPackLevel);
      } else if (result.benefitMode === ReturnBenefitCalculationMode.RelatedToTargetBenefit) {
        this.forcedToReturnPackLevel.push(...result.forcedToReturnPackLevel); // item-pack level [For display in summary]
      }
    }
    if (result.forcedDiscountItemBatches && result.forcedDiscountItemBatches.length > 0 && this.isProcessReturn) {
      this.order.forcedDiscountItemBatches = result.forcedDiscountItemBatches;
    }
    if (result.allDiscountFromBenefits && result.allDiscountFromBenefits.length > 0) {
      this.allBenefitsDiscounts = result.allDiscountFromBenefits;
      result.allDiscountFromBenefits.forEach(discountItem => {
        if (!discountItem.isReturnedAsDiscount) {
          // If item is returned as discount. The discount calculated on this item will be not be regarded.
          // as this only occurs with product discount promotions. so the discount of this item
          // will be applied over the product discount item instead [later in recalculateItemsWithProductDiscount].
          var idx = this.itemPackReturnDiscount.findIndex(i =>
            i.itemId === discountItem.itemId &&
            i.packId === discountItem.packId &&
            i.isFromProductDiscount === discountItem.isFromProductDiscount
          );
          if (idx === -1) {
            this.applyDiscountToOrderSoldItems(discountItem); // searches for item for discount in order sold items.
            this.applyDiscountToProductDiscountItems(discountItem); // searches for item for discount in forcedToReturnPackLevel1.
          } else {
            this.itemPackReturnDiscount[idx].discountAmount += discountItem.discountAmount;
          }
        }
      });
    }
    if (result.prodDiscountItemsList && result.prodDiscountItemsList.length > 0) {
      this.productDiscountItemsList = this.productDiscountItemsList.concat(result.prodDiscountItemsList);
    }
    // items - [on pack level], returned as discount.
    if (result.tempForcedToReturnPack && result.tempForcedToReturnPack.length > 0) {
      result.tempForcedToReturnPack.forEach(i => {
        i.isReturnedAsDiscount = true;
      });
      this.tempForcedToReturnPack = this.tempForcedToReturnPack.concat(result.tempForcedToReturnPack);
    }
    // returned product discount benefit quantity per promotion,return transaction,item,pack
    if (result.returnProdDiscBenefitHistory && result.returnProdDiscBenefitHistory.length > 0) {
      this.returnProdDiscBenefitHistory = this.returnProdDiscBenefitHistory.concat(result.returnProdDiscBenefitHistory);
    }
  }

  sortProductDiscountPromotionsLevels(productDiscountPromotions): any[] { // not used delete this method
    var sortedList = [];
    var secondLevelPromotions = productDiscountPromotions.filter(p => p.benefitOptionDetailTypeId === PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount.valueOf());
    var firstLevelPromotions = productDiscountPromotions.filter(p => p.benefitOptionDetailTypeId === PromotionOutputDetailTypes.SummationOverGroup.valueOf());
    var remainingLevels = productDiscountPromotions.filter(p =>
      p.benefitOptionDetailTypeId !== PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount.valueOf() &&
      p.benefitOptionDetailTypeId !== PromotionOutputDetailTypes.SummationOverGroup.valueOf()
    );
    if (secondLevelPromotions != null) sortedList = sortedList.concat(secondLevelPromotions);
    if (firstLevelPromotions != null) sortedList = sortedList.concat(firstLevelPromotions);
    if (remainingLevels != null) sortedList = sortedList.concat(remainingLevels);
    return sortedList;
  }


  recalculateReturnOrderItemsWithBenefit(resetTotals: boolean) {
    var returnCommonData = new ReturnAgainstInvoicesModel();
    returnCommonData.returnedPacks = [];
    returnCommonData.returnedPacks.push(...this.order.allItems);
    returnCommonData.customerId = this.order.customerId;
    returnCommonData.outletId = this.order.outletId;
    returnCommonData.productDiscountBenefits = this.productDiscountItemsList;
    returnCommonData.allItems = this.order.allItems;
    returnCommonData.appliedDiscountAmountList = this.itemPackReturnDiscount;
    this.orderService.recalculateReturnOrderItemsWithBenefit(returnCommonData).subscribe(response => {
      if (response && response.data && response.data.length > 0) {

        this.order.allItems = response.data;
        this.order.allItems = this.order.allItems.concat(this.forcedToReturnPackLevel); // FreeReturnItems salesTransactionTypeId = 8
        if (resetTotals) {
          this.totals = new TotalsModel();
          this.calculationService.recalculateTotalRetrunsFromInvoice(this.totals, this.order.allItems);
        }
        this.showSummary = true;
        this.showItemsSection = false;
        this.showTakePromotions = false;
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), ConstantMessages.ErrorHappened);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), ConstantMessages.ErrorHappened);
    });
  }

  recalculateItemsWithProductDiscount_old() {
    if (this.order.allItems && this.order.allItems.length > 0) {
      // filter order items that are included in any product discount promotion.
      var items = this.order.allItems.filter(i => !i.isFromProductDiscount &&
        i.salesTransactionTypeId != SalesTransactionTypes.FOCReturn &&
        this.productDiscountItemsList.filter(x =>
          x.satisfiedPrerequisitesDetails.map(d => d.packId).includes(i.packId) // packId is included in PD benefit prerequisite packIds.
          || (this.allowConversion && x.satisfiedPrerequisitesDetails.map(d => d.itemId).includes(i.itemId)) // itemId is included in PD benefit prerequisite itemIds.
        ).length > 0);

      items.forEach(i => {
        if (!i.isFromProductDiscount) { // only applied to original order items.
          // filter product discount benefits that current order item is a prerequisite for.
          var validPdBenefitsForItem = this.productDiscountItemsList.filter(x =>
            (x.satisfiedPrerequisitesDetails.map(d => d.packId).includes(i.packId) || (this.allowConversion && x.satisfiedPrerequisitesDetails.map(d => d.itemId).includes(i.itemId)))
          );
          if (validPdBenefitsForItem && validPdBenefitsForItem.length > 0) {
            validPdBenefitsForItem.forEach(benefit => {
              var productDiscountQuantityRatio = 1;
              var productDiscountGrossRatio = 1;
              var allBenefitPrereqsQty = 0; // Quantity of all prerequisites for benefit in the UOM of the promotion Target
              var currentPrereqQty = 0; // Quantity of current item in the UOM of the promotion Target
              var prerequisitesGross = 0; // total gross of benefit prerequisites.
              // var discountTakenPerBenefitPack = benefit.productDiscountDetails[0].discountTakenPerBenefitPack; // per 1 pack, from database [original sales invoice].
              var discountTakenPerBenefitPack = benefit.productDiscountDetails[0].discountAppliedOverOriginalBenefitQty;
              var uomConversionRatio = (benefit.productDiscountQty) / (benefit.productDiscountDetails[0].originalBenefitPackQuantity * benefit.productDiscountDetails[0].benefitPiecesInPack)
              var discountToApplyOverBenefitTotal = discountTakenPerBenefitPack * uomConversionRatio;
              var itemObj = i;
              if (itemObj && itemObj != undefined) {
                // get target UOM quantity for current prerequisite item.
                var prereqDetailObj = benefit.satisfiedPrerequisitesDetails.find(detail => detail.itemId === itemObj.itemId);
                if (prereqDetailObj) {
                  var targetUOMQty = prereqDetailObj.prereqUOMQuantity;
                }
                // calculate total quantity of prerequisite items for current benefit (in the UOM of promotion target).
                var benefitPreReqIds = benefit.satisfiedPrerequisitesDetails.map(d => d.itemId);
                var preReqItems = items.filter(a => benefitPreReqIds.includes(a.itemId));
                preReqItems.map(aa => {
                  var reqQtyInUOM = 0;
                  aa.returnFromInvoiceAvailableBatchList.map(inv => reqQtyInUOM += inv.salesTransactionTypeId != SalesTransactionTypes.FOCReturn ? inv.requiredQuantity : 0);
                  // get sum of current benefit prerequisites qty.
                  allBenefitPrereqsQty += reqQtyInUOM * aa.piecesInPack /
                    (benefit.satisfiedPrerequisitesDetails.find(detail => detail.itemId === aa.itemId).prereqUOMQuantity);
                  // get sum of current benefit prerequisites gross.
                  aa.returnFromInvoiceAvailableBatchList.map(aaBatch =>
                    prerequisitesGross += aaBatch.salesTransactionTypeId != SalesTransactionTypes.FOCReturn ? aaBatch.requiredQuantity * aa.piecesInPack * aaBatch.basePrice : 0);
                });

                var remainingDiscount = 0;
                var oldAmtToDeduct = 0
                var discAmt = 0;
                var itemGross = 0;
                var isAllAmountReturned = allBenefitPrereqsQty * itemObj.piecesInPack === benefit.productDiscountDetails[0].prerequisiteQuantityInPcs;
                // calculate current item's gross.
                // calculate current item's total required quantity in benefit prerequisite UOM.
                itemObj.returnFromInvoiceAvailableBatchList.map(x => {
                  itemGross += x.salesTransactionTypeId != SalesTransactionTypes.FOCReturn ? x.requiredQuantity * i.piecesInPack * x.basePrice : 0;
                  currentPrereqQty += x.salesTransactionTypeId != SalesTransactionTypes.FOCReturn ? x.requiredQuantity * i.piecesInPack : 0
                });
                currentPrereqQty = currentPrereqQty / targetUOMQty;
                // calculate product discount ratio (quantity ratio.)
                productDiscountQuantityRatio = currentPrereqQty / allBenefitPrereqsQty;
                // calculate product discount ratio (gross ratio.)
                productDiscountGrossRatio = itemGross / prerequisitesGross;
                // calculate PD benefit gross total
                // calculate PD benefit tax.
                var gross = benefit.basePrice * benefit.productDiscountQty;
                var calculatedTax = (gross - benefit.discountAmount) * benefit.taxPercentage / 100;
                // calculate PD benefit tax with original prices [only in case prices changed in customer batches list].
                // as => (discountToApplyOverBenefitTotal) value is fetched from database [original sales invoice]
                var calculatedTaxWithCurrentPrice = (gross - discountToApplyOverBenefitTotal) * benefit.taxPercentage / 100;
                if (this.includeTaxInProductDiscount || benefit.benefitType === 2) {
                  // calculate PD beenfit total based on [includeTaxInProductDiscount] configuration.
                  var net = this.includeTaxInProductDiscount ? gross - benefit.discountAmount + calculatedTax : gross - benefit.discountAmount;
                  var originalNetWithCurrentPrice = this.includeTaxInProductDiscount ? gross - discountToApplyOverBenefitTotal + calculatedTaxWithCurrentPrice : gross - discountToApplyOverBenefitTotal;
                } else {
                  var net = gross - benefit.discountAmount;
                  var originalNetWithCurrentPrice = gross - discountToApplyOverBenefitTotal;
                }
                if (benefit.benefitType === 1) { // benefit returned as quantity
                } else if (benefit.benefitType === 2) { // benefit returned as discount
                  // if (benefit.discountAmount !== discountToApplyOverBenefitTotal) remainingDiscount = originalNetWithCurrentPrice - net;
                  // if (remainingDiscount < 0) remainingDiscount = 0;
                  var calculatedTaxWithoutDisc = gross * benefit.taxPercentage / 100;
                  oldAmtToDeduct = gross + calculatedTaxWithoutDisc; // => item's NetTotal [without discount] is already
                  // applied on prerequisite item (user selected to apply discount as benefit). the new applied discount
                  // on preprequisite should include the discount. so calculate old total without discount and deduct it
                  // from item's total discount, and calculate new discount, and add it to item's total discount.
                  oldAmtToDeduct = this.productDiscountCalculationMode == 1 ? productDiscountQuantityRatio * oldAmtToDeduct
                    : productDiscountGrossRatio * oldAmtToDeduct; // BASED ON CONFIGURATION.
                }
                // if (isAllAmountReturned) net = originalNetWithCurrentPrice;
                // discAmt = net;
                discAmt = originalNetWithCurrentPrice; // Not correct...
                if (this.productDiscountCalculationMode == 1) { // REPLACE WITH PDCONFIGURATIONVALUE
                  discAmt = discAmt * productDiscountQuantityRatio;
                } else {
                  discAmt = discAmt * productDiscountGrossRatio;
                }
                var item = {
                  itemId: i.itemId,
                  packId: i.packId,
                  discountAmount: discAmt - oldAmtToDeduct + remainingDiscount,
                  packGrossTotal: itemGross,
                  isFromProductDiscount: i.isFromProductDiscount
                }
                var idx = this.itemPackReturnDiscount.findIndex(t => t.itemId === i.itemId && t.packId === i.packId);
                if (idx === -1) {
                  // if(item.discountAmount > 0) this.itemPackReturnDiscount.push(item);
                  this.itemPackReturnDiscount.push(item);
                } else {
                  this.itemPackReturnDiscount[idx].discountAmount += item.discountAmount;
                  if (this.itemPackReturnDiscount[idx].discountAmount <= 0) this.itemPackReturnDiscount.splice(idx, 1);
                }
              }
            });
          }
        }
      });
    }
  }

  applyDiscountToOrderSoldItems(discountItem: any) {
    var itemObj = this.order.soldItems.filter(i =>
      i.salesTransactionTypeId === SalesTransactionTypes.None &&
      i.packId === discountItem.packId && i.itemId === discountItem.itemId &&
      discountItem.isFromProductDiscount === i.isFromProductDiscount
    )[0];

    var grossTotal = itemObj ? itemObj.grossTotal : 0;
    if (itemObj) {
      var item = {
        itemId: discountItem.itemId,
        packId: discountItem.packId,
        discountAmount: discountItem.discountAmount,
        packGrossTotal: grossTotal,
        discountPercentage: grossTotal > 0 ? discountItem.discountAmount / grossTotal : 0,
        isFromProductDiscount: discountItem.isFromProductDiscount
      }
      this.itemPackReturnDiscount.push(item);
      discountItem.applied = true;
    }
  }

  applyDiscountToProductDiscountItems(discountItem: any) {
    if (!discountItem.applied && !discountItem.isReturnedAsDiscount) {
      if (this.forcedToReturnPackLevel1) {
        var itemObj = this.forcedToReturnPackLevel1.filter(i =>
          i.salesTransactionTypeId === SalesTransactionTypes.None &&
          i.packId === discountItem.packId && i.itemId === discountItem.itemId &&
          discountItem.isFromProductDiscount === i.isFromProductDiscount
        )[0];

        var grossTotal = 0;

        if (itemObj) {
          itemObj.returnFromInvoiceAvailableBatchList.map(tx => grossTotal += (tx.basePrice * tx.requiredQuantity * itemObj.piecesInPack));
          var item = {
            itemId: discountItem.itemId,
            packId: discountItem.packId,
            discountAmount: discountItem.discountAmount,
            packGrossTotal: grossTotal,
            discountPercentage: grossTotal > 0 ? discountItem.discountAmount / grossTotal : 0,
            isFromProductDiscount: discountItem.isFromProductDiscount
          }
          this.itemPackReturnDiscount.push(item);
        }
      }
    }
  }

  addToForcedToReturnForMultiLevelBenefit(forcedToReturnItemBatches) {
    var idx = -1;
    forcedToReturnItemBatches.forEach(forcedItem => {
      if (this.order.forcedToReturnPacks && this.order.forcedToReturnPacks.length > 0) {
        idx = this.order.forcedToReturnPacks.findIndex(orderItem =>
          orderItem.itemId === forcedItem.itemId &&
          orderItem.packId === forcedItem.packId &&
          orderItem.batchNo === forcedItem.batchNo &&
          orderItem.transactionId === forcedItem.transactionId &&
          orderItem.expiryDateModel.day === forcedItem.expiryDateModel.day &&
          orderItem.expiryDateModel.month === forcedItem.expiryDateModel.month &&
          orderItem.expiryDateModel.year === forcedItem.expiryDateModel.year &&
          orderItem.expiryDateModel.date === forcedItem.expiryDateModel.date
        );
      }
      if (idx === -1) {
        this.order.forcedToReturnPacks.push(forcedItem);
      } else {
        this.order.forcedToReturnPacks[idx].requiredQuantity += forcedItem.requiredQuantity;
      }
    });
  }

  continueBasedOnReturnedBenefitMode(returnBenefitMode: ReturnBenefitCalculationMode) {

    if (returnBenefitMode == ReturnBenefitCalculationMode.ProductDiscountQuantityBenefit.valueOf()) {
      this.isAffectedByProductDiscount = true;
      var selectedItems = this.transactionCommonData.soldItems.concat(this.forcedToReturnPackLevel1); // not including [qty benefit] items returned as discount. level 1 => from ProdDiscountQty benefit.
      var selectedItems2 = selectedItems.concat(this.tempForcedToReturnPack); // including [qty benefit] Items returned as discount
      this.allItemsReturnedAsDisc = this.tempForcedToReturnPack;
      this.allReturnOrderItems = selectedItems; // includes original order items + items returned from PD promotions
      this.recalculatePromotionBenefitForReturns(selectedItems2, ReturnBenefitCalculationMode.ProductDiscountQuantityBenefit);
    } else if (returnBenefitMode == ReturnBenefitCalculationMode.ProductDiscountQuantityOrDiscountBenefit.valueOf()) {
      var selectedItems = this.transactionCommonData.soldItems.concat(this.forcedToReturnPackLevel1).concat(this.forcedToReturnPackLevel2); // not including [qty benefit] items returned as discount. level 1 => from ProdDiscountQtyOrDisc benefit.
      var selectedItems2 = selectedItems.concat(this.tempForcedToReturnPack); // including [qty benefit] Items returned as discount
      this.allItemsReturnedAsDisc = this.tempForcedToReturnPack;
      this.allReturnOrderItems = selectedItems; // includes original order items + items returned from PD promotions
      this.recalculatePromotionBenefitForReturns(selectedItems2, ReturnBenefitCalculationMode.ProductDiscountQuantityOrDiscountBenefit);
    }
    else if (returnBenefitMode === ReturnBenefitCalculationMode.RelatedToTargetBenefit.valueOf()) {
      this.showSummaryUI();
    }
  }

  afterCancelReturnPromDialog() {
    this.promotionsAfterReturnDialog.Close();
  }

  openRequiredPaymentModal() {
    this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.requiredPayment, {
      centered: true
    });
    this.config.backdrop = true;
  }

  onRequiredPaymentResult() {
    this.modalRef.dismiss();
    if (!this.isProcessReturn) {
      this.saveOrderToDB();
    } else {

      this.preparePaymentObject();
      this.prepareDebitNoteObject();
      this.saveReturnOrderTransaction();
    }
  }

  onRequiredPaymentCancel() {
    this.modalRef.dismiss();
  }

  getPaymentDescription() {
    var str = "";
    var paymentValue = 0;
    let numberOfDigits = Number(this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfDigits));
    var originalTotal = this.calculationService.formatNumeric((this.isProcessReturn ? this.order.netTotal : this.trueNetTotal), numberOfDigits);
    var newTotal = this.calculationService.formatNumeric(((this.isProcessReturn ? this.order.netTotal : this.trueNetTotal) - this.totalRequiredPaymentFromAllItems), numberOfDigits);
    paymentValue = this.calculationService.formatNumeric(this.totalRequiredPaymentFromAllItems, numberOfDigits);
    str = this.translateService.instant(ConstantMessages.MsgRequiredCustomerPayment).replace('{0}', paymentValue.toString());
    return str;
  }

  initPaymentForm() {
    let numberOfDigits = Number(this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfDigits));
    var paymentValue = this.calculationService.formatNumeric(this.totalRequiredPaymentFromAllItems, numberOfDigits);
    var paymentTypeDescription = this.translateService.instant("Desc_Cash");
    this.paymentForm = new FormGroup({
      customerId: new FormControl(),
      outletId: new FormControl(),
      appliedAmount: new FormControl(paymentValue),
      paymentType: new FormControl(paymentTypeDescription),
      divisionId: new FormControl(),
    });
    this.paymentForm.get('customerId').disable();
    this.paymentForm.get('outletId').disable();
    this.paymentForm.get('appliedAmount').disable();
    this.paymentForm.get('paymentType').disable();
  }
  prepareDebitNoteObject() {
    let numberOfDigits = Number(this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfDigits));
    var paymentValue = this.calculationService.formatNumeric(this.totalRequiredPaymentFromAllItems, numberOfDigits);

    this.debitTransaction = new TransactionModel();
    this.debitTransaction.customerId = this.order.customerId;
    this.debitTransaction.outletId = this.order.outletId;
    this.debitTransaction.divisionId = this.paymentForm.get('divisionId').value && this.paymentForm.get('divisionId').value > 0
      ? this.paymentForm.get('divisionId').value : -1;
    this.debitTransaction.netTotal = paymentValue;
    this.debitTransaction.grossTotal = paymentValue;
    this.debitTransaction.appliedAmount = paymentValue;
    this.debitTransaction.remainingAmount = paymentValue;
  }

  preparePaymentObject() {
    let numberOfDigits = Number(this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfDigits));
    var paymentValue = this.calculationService.formatNumeric(this.totalRequiredPaymentFromAllItems, numberOfDigits);
    // Fill Payment object
    this.payment = new PaymentModel();
    this.payment.customerId = this.order.customerId;
    this.payment.outletId = this.order.outletId;
    this.payment.appliedAmount = paymentValue;
    this.payment.remainingAmount = paymentValue;
    this.payment.paymentTypeId = PaymentTypes.Cash;
    let currentDate = new Date();
    this.payment.paymentDateModel = this.coreSession.getDateTimeModel(currentDate);
    this.payment.divisionId = this.paymentForm.get('divisionId').value && this.paymentForm.get('divisionId').value > 0 ?
      this.paymentForm.get('divisionId').value : -1;
  }
  //#endregion

  allowSalesModeSelectionForCustomer(): boolean {
    if (this.itemProcessMode === FormProcessMode.Orders)
      return this.allowSalesModeSelectionForCustomerInOrders();
    // if(this.itemProcessMode === FormProcessMode.Delivery || this.itemProcessMode === FormProcessMode.PartialDelivery)
    //   return this.allowSalesModeSelectionForCustomerInSales();
  }

  allowSalesModeSelectionForCustomerInOrders(): boolean {
    return (this.allowSalesModeSelectionInOrder && this.selectedCustomerTypeId === CustomerTypes.CreditCustomer.valueOf()
      && this.isSalesOrderProcessMode());
  }

  isSalesOrderProcessMode(): boolean {
    return this.itemProcessMode === FormProcessMode.Orders && this.selectedOrderTypeId === OrderTypes.Sales.valueOf();
  }

  //#region [Sales Mode Selection dialog]
  onSalesModeSelected(result) {
    this.coreSession.markFormGroupTouched(this.orderForm);
    if (this.orderForm.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return false;
    }
    if (this.allowCollectionMethodSelection && this.showCollectionMethodSelectionInSalesModeSelection) {
      this.order.collectionMethod = this.selectedCollectionMethodId;
    }
    else
      this.order.collectionMethod = 0;
    this.salesModeSelectionDialog.Close();
    this.selectedSalesMode = this.orderForm.get('salesMode').value;
    this.afterSubmitHeaderDataClicked();
  }
  onSalesModeCanceled() {
    this.salesModeSelectionDialog.Close();
    // on cancel -> set selected sales mode = customer outlet type id (cash, credit, or bill to bill).
    // this.selectedSalesMode = this.selectedCustomerTypeId;
    // this.afterSubmitHeaderDataClicked();
  }
  onChangeSalesModeSelection() {
    this.showCollectionMethodSelectionInSalesModeSelection = false;
    if (this.allowCollectionMethodSelection) {
      this.collectionMethodIdControl.setValidators(Validators.nullValidator)
      this.collectionMethodIdControl.updateValueAndValidity();
    }
    this.selectedSalesMode = this.orderForm.get('salesMode').value;
    if (this.allowCollectionMethodSelection && this.selectedSalesMode == SalesModes.CashSales.valueOf()) {
      this.showCollectionMethodSelectionInSalesModeSelection = true;
      this.collectionMethodIdControl.setValidators(Validators.required)
      this.collectionMethodIdControl.updateValueAndValidity();
    }
  }
  //#endregion

  //#region [Contracted FOC]

  checkForContractedFOC() {
    this.transactionCommonData.getApplicableContractedFOCsOnly = true;
    this.validationService.checkForContractedFOC(this.transactionCommonData).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data && response.data.length > 0) {
          this.eligibleContractedFOCs = response.data;
          this.openContractedFOCDialog();
        } else {
          this.afterContractedFOC();
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
    });
  }

  openContractedFOCDialog() {
    this.contractedFOCDialog.Show(true).then((res) => { });
  }

  onContractedFOCDialogSave(event) {
    this.showSummary = false;
    this.showItemsSection = false;
    this.showTakePromotions = false;
    this.showTakeContractedFOC = true;

    this.contractedFOCDialog.Close();
  }

  onContractedFOCDialogCancel() {
    this.afterContractedFOC();
  }

  onApplyContractedFOCs(appliedContractedFOCs) {
    this.attachedFiles = appliedContractedFOCs.attachedFiles;
    this.transactionCommonData.contractedFOCs = appliedContractedFOCs.focs;
    this.validationService.applyContractedFOCs(this.transactionCommonData).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.transactionCommonData = response.data;

        this.order.contractedFOCs = this.transactionCommonData.contractedFOCs;
        this.transactionCommonData.soldItems.forEach(i => {
          i.priceString = this.calculationService.getNumberOnDigitFormat(i.price).toString();
        });
        this.order.soldItems = this.transactionCommonData.soldItems;
        this.order.allItems = [];
        this.order.allItems = this.order.allItems.concat(this.order.soldItems);
        this.order.allItems = this.order.allItems.concat(this.order.promotedItems);

        this.calculateTotalAfterPromotions();

        this.afterContractedFOC();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
    });
  }

  afterContractedFOC() {
    this.showSummary = true;
    this.showItemsSection = false;
    this.showTakePromotions = false;
    this.showTakeContractedFOC = false;
  }

  //#endregion

  //#region [Header Discount]
  isEligibleForHeaderDiscount(): boolean {
    var checkForHeaderDiscountForOrder = (this.applyHeaderDiscountOnSalesOrders && !this.isDelivery && this.order && this.order.orderTypeId === OrderTypes.Sales.valueOf());
    // var checkForHeaderDiscountForDelivery = (this.applyHeaderDiscountOnSales && this.isDelivery && this.order && this.order.orderTypeId === OrderTypes.Sales.valueOf());
    return checkForHeaderDiscountForOrder //|| checkForHeaderDiscountForDelivery;
  }

  checkForHeaderDiscount() {
    this.validationService.checkForHeaderDiscount(this.transactionCommonData).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data) {
          this.headerDiscountList = response.data.headerDiscountList ? response.data.headerDiscountList : [];

          var totalHeaderDiscountPercentage = response.data.transactionCommonData && response.data.transactionCommonData.headerDiscount ? response.data.transactionCommonData.headerDiscount : 0;
          if (totalHeaderDiscountPercentage > 0) {
            this.initHeaderDiscountForm();
            this.headerDiscountTypeId = DiscountValueTypes.Percentage.valueOf();
            this.headerDiscountPercentage = totalHeaderDiscountPercentage;
            this.headerDiscountForm.get('headerDiscount').setValue(this.calculationService.getNumberOnDigitFormat(totalHeaderDiscountPercentage));
            this.showHeaderDiscountDialog();
          } else {
            this.afterHeaderDiscount();
          }
        } else {
          this.afterHeaderDiscount();
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
    });
  }

  applyHeaderDiscountOnPacks(totalHeaderDiscountPercentage: number) {
    this.headerDiscountPercentage = totalHeaderDiscountPercentage;
    if (totalHeaderDiscountPercentage > 100) totalHeaderDiscountPercentage = 100;
    this.order.soldItems.forEach(pack => {
      pack.headerDiscount = totalHeaderDiscountPercentage;
    });
    this.calculateTotalAfterPromotions();
  }

  showHeaderDiscountDialog() {
    this.headerDiscountDialog.Show(true).then((res) => { });
  }

  onHeaderDiscountDialogSave(result) {
    // if allowEditHeaderDiscount is true, and value is not the same as the value obtained from backend (note: value was rounded for display in UI).
    var selectedValue = this.allowEditHeaderDiscount && this.isHeaderDiscountValueChanged ? this.headerDiscountForm.get('headerDiscount').value : this.headerDiscountPercentage;
    if (selectedValue <= 0) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption), ConstantMessages.MsgHeaderDiscountLessThanZero
      );
      return;
    }

    var selectedValueAsPercentage = this.headerDiscountTypeId === DiscountValueTypes.Percentage.valueOf() ? selectedValue : this.getHeaderDiscountAmountAsPercentage(selectedValue);
    if (selectedValueAsPercentage > 100) {
      selectedValueAsPercentage = 100;
    }
    this.applyHeaderDiscountOnPacks(selectedValueAsPercentage);

    this.headerDiscountDialog.Close();
    this.afterCloseHeaderDiscountDialog();
  }

  onHeaderDiscountDialogCancel() {
    this.afterCloseHeaderDiscountDialog();
  }

  afterCloseHeaderDiscountDialog() {
    this.afterHeaderDiscount();
  }

  afterHeaderDiscount() {
    this.showSummary = true;
    this.showItemsSection = false;
    this.showTakePromotions = false;
    this.showTakeContractedFOC = false;
  }

  getHeaderDiscountAmountAsPercentage(discountAmount: number): number {
    var discountPercentage: number = 0;
    var grossTotal = 0;
    var totalDiscount = 0;
    this.order.soldItems.forEach(soldPack => {
      grossTotal += soldPack.grossTotal;
      totalDiscount += soldPack.calculatedDiscountTotal;
    });

    var transactionTotal = grossTotal - totalDiscount;

    discountPercentage = (discountAmount / transactionTotal) * 100;

    return discountPercentage;
  }

  initHeaderDiscountForm() {
    if (this.headerDiscountForm) {
      this.headerDiscountForm.reset();
    } else {
      this.headerDiscountForm = new FormGroup({
        headerDiscount: new FormControl(null),
      });
    }

    if (!this.allowEditHeaderDiscount)
      this.headerDiscountForm.get('headerDiscount').disable();
  }

  toggleHeaderDiscountType() {
    if (this.allowEditHeaderDiscount) {
      if (this.headerDiscountTypeId === DiscountValueTypes.Percentage.valueOf())
        this.headerDiscountTypeId = DiscountValueTypes.Amount.valueOf();
      else
        this.headerDiscountTypeId = DiscountValueTypes.Percentage.valueOf();
    }
  }

  onHeaderDiscountChanged() {
    this.isHeaderDiscountValueChanged = true;
  }
  onEmployeeIDSelected(selectedEmployee: any) {
    if (!this.isEdit) {
      this.employeeId = selectedEmployee.id;
      if (this.employeeId && this.employeeId > 0 && !this.isEdit)
        this.resetValues.emit(this.employeeId);
    }
  }
  //#endregion

  //#region [PROPERTIES]

  get customer() {
    return this.orderForm.get('customerId');
  }
  get employee() {
    return this.orderForm.get('employeeId');
  }
  get outlet() {
    return this.orderForm.get('outletId');
  }
  get deliveryDateControl() {
    return this.orderForm.get('desiredDeliveryDate');
  }
  get remarksControl() {
    return this.orderForm.get('remarks');
  }
  get LPOControl() {
    return this.orderForm.get('lpo');
  }
  get orderNumber() {
    return this.orderForm.get('orderNumber');
  }
  get paymentTermIdControl() {
    return this.orderForm.get('paymentTermId');
  }
  get division() {
    return this.orderForm.get('divisionId');
  }
  get customerRef() {
    return this.orderForm.get('customerRef')
  }
  get orderTypeIdControl() {
    return this.orderForm.get('orderTypeId')
  }
  get orderSourceIdControl() {
    return this.orderForm.get('orderSourceId')
  }
  get collectionMethodIdControl() {
    return this.orderForm.get('collectionMethodId');
  }
  get warehouseIdControl() {
    return this.orderForm.get('warehouseId');
  }
  //#endregion
}
