import {
  Component,
  OnInit,
  OnChanges,
  AfterViewChecked,
  AfterViewInit,
  OnDestroy
} from "@angular/core";
import { ConstantURLs } from "../../../shared/models/constants/constant-URL";
import { ActivatedRoute, Router, NavigationEnd } from "@angular/router";
import { CoreSession } from "../../../core/core.session";
import { TranslateService } from "@ngx-translate/core";
import { SessionDataProvider } from "../../../core/session-data-provider.service";
import { ShepherdService } from 'angular-shepherd';
import { TourService} from '../../../shared/shepherd-config/shepherd-config';
import { NavBarService } from "../../../core/sidebar/sidebar.service";
import { ComponentVisitService } from "../../../shared/shepherd-config/trackTour.service";
import { Subscription } from "rxjs";
@Component({
  selector: "app-order-main",
  templateUrl: "./order-main.component.html",
  styleUrls: ["./order-main.component.css"]
})
export class OrderMainComponent implements OnInit,OnDestroy {
  urls;
  tabIndex = 0;
  hideTabs = false;
  navLinks: any[];
  activeLinkIndex = -1;
  isAddOrderAvailable: boolean = false;

  orderDescription: string;
  ordersDescription: string;
  homeDescription: string;
  pendingDescription: string;
  approvedDescription: string;
  dispatchDescription: string;
  assignedDescription: string;
  invoiceDescription: string;
  indexCounter: number = -1;
  translateObject: {};

  constructor(
    private route: ActivatedRoute,
    private router: Router,
    private coreSession: CoreSession,
    private translate: TranslateService,
    private sessionDataProvider: SessionDataProvider,
    private  shepherdService: ShepherdService,
    private navService : NavBarService,
    private translateService : TranslateService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) {
    this.urls = ConstantURLs;

    this.prepareNavigation();

    router.events.subscribe(val => {
      if (val instanceof NavigationEnd) {
        if (
          val.url.includes(ConstantURLs.addPendingOrderURL) ||
          val.url.includes(ConstantURLs.editPendingOrderURL)
        ) {
          this.hideTabs = true;
        } else {
          this.hideTabs = false;
        }
      }
    });

    this.translateObject = {
      value: this.translate.instant("Desc_Orders")
    };
  }
  ngOnDestroy(): void {
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
     }
     if(this.shepherdService.tourObject)
      this.shepherdService.cancel()

     this.navService.tourStatus=false
     this.componentVisitService.markComponentVisited('order-main');
     if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
    }

  private tourStartTimeout: any;
  private endTour = false

  ngAfterViewInit() {
    this.startTour()
  }

  startTour(forceTour?){
    this.tourStartTimeout =  setTimeout((data=>{
      if(!this.tourService.isFirstTour()){
          this.endTour = true;
          this.navService.endtour.next();
      }
      if(!forceTour)
        if (this.tourService.isTourCompletedForComponent('order-main')) {
          this.endTour = true;
          this.navService.endtour.next();
          return;
    }
    if(this.tourService.isFirstTour() || forceTour){

      const elementSelectors = this.navLinks.map((_, i) => `#column-${i}`);
      const titles = [];

      const texts = [];

      this.navLinks.forEach(item=>{
        var title = '';
        var text = '';
        switch(item.label){
          case 'Pending':
            var title = 'Desc_Order_Pending';
              var text = 'Desc_Manage_Pending_Order';
              break
              case 'Approved':
                var title = 'Desc_Approved';
                var text = 'Desc_Manage_Approved_Orders';
                break ;
                case 'Delivered ':
                  var title = 'Desc_Delivered';
                  var text = 'Desc_Manage_Delivered_Orders';
                  break
                  case 'Rejected':
                    var title = 'Desc_Rejected';
                    var text = 'Desc_Manage_Rejected_Orders';
                    break
                    case 'Cancelled':
                      var title = 'Desc_Cancelled';
                      var text = 'Desc_Manage_Canceled_Orders';
                      break
                    }
                    titles.push(title)
                    texts.push( text)
                  }) // Target each column by its unique ID
        const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
        this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
        this.shepherdService.modal = true;
        this.shepherdService.addSteps(steps);
        this.shepherdService.start();
        this.shepherdService.tourObject.on('complete', () => {

          this.endTour=true;
          this.navService.endtour.next();
        });

        this.shepherdService.tourObject.on('cancel', () => {

          this.endTour=true;
          this.navService.endtour.next();
        });

      }

      }),1000)
    }

  private tourSubscription: Subscription;
  ngOnInit() {
    this.tourSubscription = this.tourService.startTourMain$.subscribe(() => {
      this.startTour(true);
    });
    this.coreSession.SetTitle("Order");
  }

  prepareNavigation() {
    if(this.endTour)
      this.navService.endtour.next(true);

    this.navLinks = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable) {
      if (
        menu.menuId.startsWith("300-") &&
        menu.url !== ConstantURLs.addPendingOrderURL
      ) {
        this.indexCounter = this.indexCounter + 1;
        let newName = {
          label: menu.menuName,
          link: menu.url,
          index: this.indexCounter
        };
        this.navLinks.push(newName);
      }
    }

    // this.navLinks.push({
    //   label: "Invoice",
    //   link: ConstantURLs.invoiceOrdersURL
    // });


    //   this.navLinks = [
    //   //   {
    //   //    label: 'Desc_Home',
    //   //    link: this.urls.homeUrl,
    //   //    index: 0
    //   //  },
    //    {
    //      label: 'Desc_Order_Pending',
    //      link: this.urls.pendingOrdersURL,
    //      index: 1
    //    },
    //    {
    //      label: 'Desc_Order_Approved',
    //      link: this.urls.approvedOrdersURL,
    //      index: 2
    //    },
    //    {
    //      label: 'Desc_Order_Dispatch',
    //      link: this.urls.dispatchOrdersURL,
    //      index: 3
    //    },
    //     {
    //      label: 'Desc_Order_Assigned',
    //      link: this.urls.assignedOrdersURL,
    //      index: 4
    //    },
    //     {
    //      label: 'Desc_Order_Invoicing',
    //      link: this.urls.invoiceOrdersURL ,
    //      index: 5
    //    },
    //  ];
  }

  goToNewOrder() {
    this.router.navigate([ConstantURLs.addPendingOrderURL], {
      relativeTo: this.route
    });
  }
}
