import { Component, OnInit, ViewChild, Input, Output, EventEmitter, OnDestroy, OnChanges } from '@angular/core';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { CoreSession } from '../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { NgbModalConfig, NgbModal, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';

@Component({
  selector: 'app-order-note-dialog',
  templateUrl: './order-note-dialog.component.html',
  styleUrls: ['./order-note-dialog.component.css']
})
export class OrderNoteDialogComponent implements OnInit, OnDestroy, OnChanges {

  modalRef: NgbModalRef;
  @ViewChild('orderNoteDialog', { static: true }) orderNoteDialog: any;
  @Input() orderId = null;
  OkResult: DialogResult = DialogResult.Ok;
  orderNote = null;

  constructor(
    private modalService: NgbModal
  ) {
  }

  ngOnInit() {
  }
  ngOnDestroy() {
    this.modalService.dismissAll();
  }
  ngOnChanges() {
    this.orderNote = null;
  }
  isValid(){
    if(this.orderNote && this.orderNote != '' && this.orderNote.trim() && this.orderNote.trim() != ''){
      return true;
    }else{
      return false;
    }
  }
  public showDialog() {
    this.orderNote = '';
    return this.modalService.open(this.orderNoteDialog, { centered: true }).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          return this.orderNote;
        } else {
          return -1;
        }
      });
  }
}

