import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';

import { OrderMainComponent } from './order-main/order-main.component';

import { ConstantURLs } from '../../shared/models/constants/constant-URL';
import { InvoiceOrderComponent } from './invoice-order/invoice-order.component';

import { ApprovedOrderComponent } from './approved-order/approved-order.component';
import { AddOrderComponent } from './add-order/add-order.component';
import { PendingOrderComponent } from './pending-order/pending-order.component';
import { DispatchOrderComponent } from './dispatch-order/dispatch-order.component';
import { OrderDashboardComponent } from './order-dashboard/order-dashboard.component';
import { AuthGuard } from '../../core/auth/auth.gurad';
import { RejectOrderComponent } from './reject-order/reject-order.component';
import { CancelOrderComponent } from './cancel-order/cancel-order.component';


const orderRouting: Routes = [
  {
    path: '',
    canActivate: [AuthGuard],
    component: OrderMainComponent,
    children: [
      {
        path: ConstantURLs.dashboardsURL,
        canActivate: [AuthGuard],
        component: OrderDashboardComponent
      },
      {
        path: ConstantURLs.pendingOrdersURL,
        canActivate: [AuthGuard],
        component: PendingOrderComponent
      },
      {
        path: ConstantURLs.approvedOrdersURL,
        canActivate: [AuthGuard],
        component: ApprovedOrderComponent
      },
      {
        path: ConstantURLs.rejectOrdersURL,
        canActivate: [AuthGuard],
        component: RejectOrderComponent
      },
      {
        path: ConstantURLs.invoicedOrdersURL,
        canActivate: [AuthGuard],
        component: InvoiceOrderComponent
      },
      {
        path: ConstantURLs.dispatchOrdersURL,
        canActivate: [AuthGuard],
        component: DispatchOrderComponent
      },
      {
        path: ConstantURLs.addPendingOrderURL,
        canActivate: [AuthGuard],
        component: AddOrderComponent
      },
      {
        path: ConstantURLs.cancelledOrdersURL,
        canActivate: [AuthGuard],
        component: CancelOrderComponent
      },
      {
        path: ConstantURLs.pendingOrdersURL + '/' + ConstantURLs.editPendingOrderURL + '/' + ':orderSignature',
        canActivate: [AuthGuard],
        component: AddOrderComponent
      },
      { path: '', redirectTo: '/' + ConstantURLs.orderManagementURL + '/' + ConstantURLs.dashboardsURL, pathMatch: 'full' }
    ]
  }
];
@NgModule({
  imports: [RouterModule.forChild(orderRouting)],
  exports: [RouterModule]
})
export class OrderRoutingModule { }
