import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";

import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { SharedModule } from "../../shared/shared.module";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { OwlDateTimeModule, OwlNativeDateTimeModule } from "ng-pick-datetime";
import { DragDropModule } from "@angular/cdk/drag-drop";
import { MatExpansionModule } from "@angular/material/expansion";
import { NgxEchartsModule } from "ngx-echarts";
import { InvoiceOrderComponent } from "./invoice-order/invoice-order.component";

import { OrderMainComponent } from "./order-main/order-main.component";
import { ApprovedOrderComponent } from "./approved-order/approved-order.component";
import { OrderRoutingModule } from "./order-routing.module";
import { AddOrderComponent } from "./add-order/add-order.component";
import { PendingOrderComponent } from "./pending-order/pending-order.component";
import { DispatchOrderComponent } from "./dispatch-order/dispatch-order.component";
import { OrderDashboardComponent } from "./order-dashboard/order-dashboard.component";
import { ReschduleDateComponent } from "./reschdule-date/reschdule-date.component";
import { TranslateModule } from "@ngx-translate/core";
import { RecurringOrderComponent } from "./recurring-order/recurring-order.component";
import { NgSelectModule } from "@ng-select/ng-select";
import { OrderEntryComponent } from "./new-order/order-entry.component";
import { OrderNoteDialogComponent } from "./order-note-dialog/order-note-dialog.component";
import { TabsModule } from "ngx-bootstrap/tabs";
import { RecurringDetailsComponent } from "./recurring-details/recurring-details.component";
import { RejectOrderComponent } from "./reject-order/reject-order.component";
import { LastInvoiceDialogComponent } from "./last-invoice-dialog/last-invoice-dialog.component";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";
import { LoyaltyDialogComponent } from './loyalty-dialog/loyalty-dialog.component';
import { CancelOrderComponent } from './cancel-order/cancel-order.component';

@NgModule({
  declarations: [
    OrderMainComponent,
    PendingOrderComponent,
    ApprovedOrderComponent,
    DispatchOrderComponent,
    InvoiceOrderComponent,
    AddOrderComponent,
    OrderDashboardComponent,
    ReschduleDateComponent,
    RecurringOrderComponent,
    OrderNoteDialogComponent,
    OrderEntryComponent,
    RecurringDetailsComponent,
    RejectOrderComponent,
    LastInvoiceDialogComponent,
    LoyaltyDialogComponent,
    CancelOrderComponent,
  ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    OrderRoutingModule,
    SharedModule,
    OwlDateTimeModule,
    OwlNativeDateTimeModule,
    NgbModule,
    DragDropModule,
    MatExpansionModule,
    TranslateModule.forChild(),
    TabsModule.forRoot(),
    NgSelectModule,
    NgxEchartsModule,
    NgMultiSelectDropDownModule,
    NgOptionHighlightModule,
  ],
  exports: [OrderNoteDialogComponent],
})
export class OrderModule { }
