import { Component, OnInit, ViewChild } from "@angular/core";
import { OrderService } from "../order.service";
import { CoreSession } from "../../../core/core.session";
import { SharedTableResult } from "../../../shared/models/shared-table/shared-table-result.interface";
import { ITextInput, OrderListFilter } from "../../../shared/models/shared-table/custom-list.interface";
import { ITableProperties } from "../../../shared/models/shared-table/table-properties.interface";
import { OrderStatus } from "../../../shared/models/enums/order-status.enum";
import { OrderOperation } from "../../../shared/models/enums/order-operation .enum";
import { DialogMode } from "../../../shared/models/enums/dialog-mode.enum";
import { HttpErrorResponse } from "@angular/common/http";
import { ConstantMessages } from "../../../shared/models/constants/constant-message";
import { RowOperation, MultiSelectionOperation } from "../../../shared/models/enums/shared-table-operation.enum";
import { DialogResult } from "../../../shared/models/enums/dialog-result.enum";
import { TranslateService } from "@ngx-translate/core";
import { ConstantURLs } from "../../../shared/models/constants/constant-URL";
import { DocumentTypes } from "../../../shared/models/enums/document-types.enum";
import { ValidationService } from "../../../shared/services/validation.service";
import { IOperationSummary } from "../../../shared/models/operation-summary/operation-summary-interface";
import { FormProcessMode } from "../../../shared/models/enums/form-process-mode.enum";
import { MenuActions } from '../../../shared/models/enums/menu-actions-enum';
import { OrderNoteDialogComponent } from '../order-note-dialog/order-note-dialog.component';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { CommonButtonStyles } from '../../../shared/models/enums/common-button-styles.enum';
import { ReportMode } from '../../../shared/models/enums/report-mode.enum';
import { OrderTypes } from "../../../shared/models/enums/order-types.enum";
import { ItemService } from "../../../shared/services/data-definition/product/item.service";
import { OrderPendingService } from "../../../shared/services/order/order-pending.service";
import { PdfCreatorService } from "../../../shared/services/pdf-creator.service";
import { ApprovalCycleOperations } from "../../../shared/models/enums/approval-cycle-operations-enum";
import { FormControl, FormGroup, Validators } from "@angular/forms";
import { NgbModal, NgbModalConfig, NgbModalRef } from "@ng-bootstrap/ng-bootstrap";
import { WarehouseService } from "../../../shared/services/data-definition/warehouse-and-vehicle/warehouse.service";
import { NavBarService } from "../../../core/sidebar/sidebar.service";
import { SharedDialogComponent } from "../../../shared/components/shared-dialog/shared-dialog.component";
import { CustomerOutletContactModel } from "../../../shared/models/customer/outlet.model";
import { CustomerService } from "../../../shared/services/data-definition/customer/customers.service";
import { PriceService } from "../../../shared/services/data-definition/prices-and-offers/price.service";
import { ResponseModel } from "../../../shared/models/api-models/api-models";
import { DateTimeModel } from "../../../shared/models/dateTimeModel/date-time.model";
import { GeneralFilter } from "../../../shared/models/general/generalFilter.model";
import { THIS_EXPR } from "@angular/compiler/src/output/output_ast";

@Component({
  selector: "app-pending-order",
  templateUrl: "./pending-order.component.html",
  styleUrls: ["./pending-order.component.css"]
})
export class PendingOrderComponent implements OnInit {
  @ViewChild('ItemEntryDialog', { static: true }) ItemEntryDialog: SharedDialogComponent;
  @ViewChild('ItemSummaryDialog', { static: true }) ItemSummaryDialog: SharedDialogComponent;
  @ViewChild("orderNoteDialog", { static: true }) orderNoteDialog: OrderNoteDialogComponent;

  @ViewChild('PriceEntryDialog', { static: true }) PriceEntryDialog: SharedDialogComponent;
  customerOutletContactModel: CustomerOutletContactModel;

  @ViewChild('ContactEntryDialog', { static: true }) ContactEntryDialog: SharedDialogComponent;

  @ViewChild("warehouseSelection", { static: true })
  warehouseSelection: NgbModal;
  @ViewChild("InvalidOrderReasons", { static: true }) InvalidOrderReasons: NgbModal;
  modalRef: NgbModalRef;
  selectedPendingPriceList: any = {};
  isTouched = false;
  outletForm: FormGroup;
  orderId = "";
  selectedOrder: any;
  warehouseDataSource: any[];
  AllowWarehouseSelectionInPendingOrders = false;
  isAddBundle: boolean = false;
  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: true,
    showNewBtn: false,
    showExport: true,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [],
    openFilterDirectly: false,
    columns: [
      {
        title: "Desc_Order_ID",
        key: "orderId",
        isSortable: true,
        // width: this.isDivisionLevel() ? "16%" : "20%"
      },
      {
        title: "Desc_Customer",
        key: "customerCodeName",
        isSortable: false,
      },
      {
        title: "Desc_Outlet",
        key: "outletCodeName",
        isSortable: false,
      },
      {
        title: "Desc_Name",
        key: "employeeName",
        isSortable: false,
      },
      {
        title: "Desc_Order_Date",
        key: "orderDate",
        isSortable: true,
        isDate: true
      },
      {
        title: "Desc_Delivery_Date",
        key: "desiredDeliveryDate",
        isSortable: true,
        isDate: true
      },
      {
        title: "Desc_Total",
        key: "netTotal",
        numberOfDigits: true,
        isSortable: false,
      },
      {
        title: "Desc_Note",
        key: "note",
        isSortable: false,
      }
    ]
  };

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  dataSourceInvalidOrders: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  tableDataInvalidOrders: ITableProperties = {
    pageSize: 25,
    showPaginator: false,
    showSearch: false,
    isOnline: true,
    rowOperations: [
      {
        operation: RowOperation.View,
        title: 'Desc_Avaliable_Quantity',
        icon: "fa-regular fa-eye",
        color: '#12344d',
        showWhenKeyValueFalse: true,
        showHideOptionPerLine: true,
        controlKeyName: "isNotWarehouseStock",
      }
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Order_ID",
        key: "orderId",
        isSortable: true,
        width: '30%'
      },
      {
        title: 'Desc_Message',
        key: 'validationMessage',
        isSortable: true,
        width: '70%'
      },
    ]
  };

  query: OrderListFilter = {
    customListFilter: {
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    orderOperation: OrderOperation.GetPending,
    orderStatus: OrderStatus.New,
    customerId: -1,
    outletId: -1,
    itemId: -1,
    employeeId: -1,
    isBundle: false,
    hasUnlimitedFOC: false,
    warehouseId: -1
  };

  operationSummaryData: IOperationSummary = {
    operationData: {},
    formProcessMode: FormProcessMode.Orders,
    formTitle: "Desc_Order_Summary"
  };
  showViewSummarySlider = false;

  warehouseForm: FormGroup;
  isEditMode = false;
  showOrderSlider = false;
  orderSignature = "";
  orderTypeDataSource: any[] = [];
  restrictReturnFromInvoices: boolean = false;
  activateApprovalCycleForOrders: boolean = false;
  constructor(
    private config: NgbModalConfig,
    private modalService: NgbModal,
    private warehouseService: WarehouseService,
    private sessionData: SessionDataProvider,
    private validationService: ValidationService,
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private pdfCreatorService: PdfCreatorService,
    private itemService: ItemService,
    private orderPendingService: OrderPendingService,
    private navService : NavBarService,
    private customerService : CustomerService,
    private priceService : PriceService
  ) { }

  showSharedTable: boolean = false
  ngOnInit() {


    this.initFilterForm()

    this.customerForm = new FormGroup({
      customerName: new FormControl(
        { value: "", disabled: false },
        Validators.required
      ),
     })

     this.InitOutletForm();

     this.contactAddBtnDesc = 'Desc_Add';
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus;
    });
    this.showSharedTable = this.navService.tourStatus;

    this.coreSession.SetTitle("Pending Orders");
    this.AllowWarehouseSelectionInPendingOrders = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowWarehouseSelectionInPendingOrders).toLowerCase() === "true";
    if (this.isDivisionLevel())
      this.tableData.columns.push({ title: "Desc_Division", key: "division", isSortable: true });
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pendingOrdersURL, MenuActions.Add)) {
      this.tableData.showNewBtn = true;
      this.tableData.newBtnCaption = "Desc_New_Order"
      // this.tableData.showExtraBtn = true;
      // this.tableData.extraBtnCaption = "Desc_New_Bundle";
      // this.tableData.extraBtnIcon = "fa-solid fa-plus";
    }
    this.query.orderTypeId = -1;
    this.populateNewOrderList();
    this.addActions();
    if (this.tableData.multiSelectionOperations && this.tableData.multiSelectionOperations.length > 0) {
      this.tableData.isMultiSelection = true;
    }
    this.restrictReturnFromInvoices =
      this.sessionData
        .getConfigurationValue(
          ConstantConfigurations.RestrictReturnFromInvoices
        )
        .toLowerCase() === "true";

    this.activateApprovalCycleForOrders = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyApprovalCycleInWeb).includes(ApprovalCycleOperations.Orders.valueOf().toString());

    if(this.activateApprovalCycleForOrders){
      this.tableData.columns.push({ title: "Desc_Approval_Status", key: "orderApprovalStatusName", isSortable: true });
    }
  }
  isDivisionLevel() {
    return (this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true")
  }
  applyDivisionsOnDocumentSequence() {
    return (this.isDivisionLevel() && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyDivisionsOnDocumentSequence).toLowerCase() === "true")
  }
  onAddNewOrder() {
    this.isAddBundle = false;
    if (this.applyDivisionsOnDocumentSequence()) {
      this.isEditMode = false;
      this.showOrderSlider = true;
      this.openItemEntryDialog()
    } else {
      this.getMaxDocumentSequence();
    }
  }
  onAddNewBundle() {
    this.isAddBundle = true;
    if (this.applyDivisionsOnDocumentSequence()) {
      this.isEditMode = false;
      this.showOrderSlider = true;
    } else {
      this.getMaxDocumentSequence();
    }
  }
  openItemEntryDialog() {
    this.ItemEntryDialog.Show(true).then((res) => { });
  }
  openItemSummaryDialog() {
    this.ItemSummaryDialog.Show(true).then((res) => { });
  }
  getMaxDocumentSequence() {
    let documentSequenceFilter = {
      divisionId: -1,
      employeeId: this.coreSession.CurrentOperator.employeeId,
      DocumentType: DocumentTypes.Order
    };
    this.coreSession.ModalLoading.Show();
    this.validationService
      .getMaxDocumentSequence(documentSequenceFilter)
      .subscribe(
        response => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            // this.router.navigate(['/' + ConstantURLs.orderURL, ConstantURLs.addPendingOrderURL]);
            this.orderId = response.data;
            this.orderSignature = null;
            this.isEditMode = false;
            this.showOrderSlider = true;
            this.showSharedTable = false
            this.openItemEntryDialog()

          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              response.message
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }

  onEditSelectedOrder(order) {
    // this.router.navigate([ConstantURLs.editPendingOrderURL, order.orderSignature], {relativeTo: this.route});
    if (order.orderTypeId === OrderTypes.Return.valueOf() && this.restrictReturnFromInvoices && order.isRestrictedFromOldInvoices) {
      this.checkForPostedCustomerTransactions(order);
    } else {
      this.orderId = order.orderId;
      this.orderSignature = order.orderSignature;
      this.isEditMode = true;
      this.showOrderSlider = true;
      this.openItemEntryDialog()
    }
  }
  initWarehouseForm() {
    let warehouseId: number;
    this.warehouseForm = new FormGroup({
      warehouseId: new FormControl(warehouseId, Validators.required)
    });
  }
  onCloseWarehouseModal() {
    this.modalRef.dismiss();
    this.warehouseForm.reset();
  }
  onWarehouseSelected() {
    let selectedWarehouseId = null;
    if (this.warehouseForm.invalid) {
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.SelectWarehouse)
      );
      return;
    }
    selectedWarehouseId = this.warehouseForm.get("warehouseId").value;
    this.selectedOrder.warehouseId = selectedWarehouseId;
    this.orderPendingService.SelectWarehouseOrder(this.selectedOrder).subscribe(result => {
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
    }
    );
    this.onCloseWarehouseModal();
  }
  selectMainWarehouse(selectedOrders: any = []) {
    let warehouseFilter = {
      vehicleId: -1,
      organizationId: -1,
      currentStockMode: false,
      includeDamaged: false,
      employeeId: -1
    }
    if (selectedOrders != null && selectedOrders.length > 0)
      warehouseFilter.employeeId = selectedOrders[0].employeeId;
    this.warehouseService.getWarehouses(warehouseFilter).subscribe(result => {
      if (result.length > 0) {
        var filterWarehouse = result.filter(warehouse => warehouse.warehouseId !== selectedOrders.warehouseId);
        this.coreSession.ModalLoading.Show();
        this.warehouseDataSource = filterWarehouse;
        this.config.backdrop = "static";
        this.modalRef = this.modalService.open(this.warehouseSelection, {
          centered: true
        });
        this.config.backdrop = true;

        this.coreSession.ModalLoading.Hide()
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.NoWarehouseAvailable));
      }

    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    })
  }

  checkForPostedCustomerTransactions(order) {
    this.coreSession.ModalLoading.Show();
    this.orderPendingService.checkForPostedCustomerTransactions(order).subscribe((response) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if (response.data === true) {
          // ALERT USER.
          this.coreSession.showInfo(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgCalculatingBatches));
          // UPDATE BATCHES...
          this.updateCustomerReturnBatches(order);
        } else {
          this.orderId = order.orderId;
          this.orderSignature = order.orderSignature;
          this.isEditMode = true;
          this.showOrderSlider = true;
        }
      } else {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  updateCustomerReturnBatches(order) {
    this.coreSession.ModalLoading.Show();
    this.itemService.updateCustomerReturnBatches(order).subscribe((response) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.orderId = order.orderId;
        this.orderSignature = order.orderSignature;
        this.isEditMode = true;
        this.showOrderSlider = true;
      } else {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.ErrorHappened)
      );
    }
    );
  }

  closeOrderSlider() {
    this.orderId = "";
    this.orderSignature = null;
    this.isEditMode = false;
    this.showOrderSlider = false;
    this.showSharedTable = true
    this.modalService.dismissAll()
  }

  onSaveComplete() {
    debugger
    this.closeOrderSlider();
    this.query.orderTypeId = -1
    this.populateNewOrderList();
    this.showSharedTable = true
  }

  addActions() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pendingOrdersURL, MenuActions.Delete)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.delete,
        title: "Desc_Cancel",
        icon: "fa-solid fa-trash",
        color: "#f1685e",
        showWhenKeyValueFalse: true,
        showHideOptionPerLine: true,
        controlKeyName: "isNewWebOrder",
      });

      this.tableData.multiSelectionOperations.push({
        operation: MultiSelectionOperation.delete,
        title: 'Desc_Cancel',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
        style: CommonButtonStyles.Negative.valueOf()
      })
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pendingOrdersURL, MenuActions.Edit)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d",
        showWhenKeyValueFalse: true,
        showHideOptionPerLine: true,
        controlKeyName: "isNewWebOrder",
      });
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pendingOrdersURL, MenuActions.Approve)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.approve,
        title: "Desc_Order_Approve",
        icon: "fa-solid fa-check",
        color: "#02b875",
        showWhenKeyValueFalse: true,
        showHideOptionPerLine: true,
        controlKeyName: "isNewWebOrder",
      });
      this.tableData.multiSelectionOperations.push({
        style: CommonButtonStyles.Success.valueOf(),
        operation: MultiSelectionOperation.approve,
        title: "Desc_Order_Approve",
        icon: "fa-solid fa-check",
        color: "#02b875"
      });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pendingOrdersURL, MenuActions.View)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.View,
        title: 'Desc_View',
        icon: 'fa-regular fa-eye',
        color: '#12344d'
      });
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pendingOrdersURL, MenuActions.Print)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.Print,
        title: 'Desc_Print',
        icon: 'fa-solid fa-print',
        color: '#12344d'
      });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pendingOrdersURL, MenuActions.EditWarehouse)
      && this.AllowWarehouseSelectionInPendingOrders
    ) {
      this.tableData.rowOperations.push({
        operation: RowOperation.EditWarehouse,
        title: 'Desc_Warehouse',
        icon: 'fa fa-home',
        color: '#12344d'
      });
    }

  }

  populateNewOrderList() {
    this.coreSession.ModalLoading.Show();
    this.orderPendingService.getOrders(this.query).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = <SharedTableResult>response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  // ApproveOrder(order: any) {
  //   order.orderOperation = OrderOperation.Approve;
  //   order.orderStatus = OrderStatus.Approved;
  //   this.coreSession.ModalLoading.Show();
  //   this.orderService.updateOrder(order).subscribe(
  //     response => {
  //       this.coreSession.ModalLoading.Hide();
  //       if (response.status != null && response.status >= 0) {
  //         this.coreSession.showSuccess(
  //           this.translateService.instant(ConstantMessages.SuccessCaption),
  //           this.translateService.instant(ConstantMessages.OrderApproved)
  //         );
  //         this.populateNewOrderList();
  //       } else {
  //         this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),response.message);
  //       }
  //     },
  //     (error: HttpErrorResponse) => {
  //       this.coreSession.ModalLoading.Hide();
  //       this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),this.translateService.instant(ConstantMessages.ErrorHappened));
  //     }
  //   );
  // }

  finalApproveOrders(selectedOrderes: any[], isFromApprovalCycle = false) {
    if (!isFromApprovalCycle) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.ApproveConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then((result: DialogResult) => {
        if (result === DialogResult.Yes) {
          this.approveSelectedOrders(selectedOrderes);
        }
      });
    } else {
      this.approveSelectedOrders(selectedOrderes);
    }
  }

  approveSelectedOrders(selectedOrderes: any[]) {
    selectedOrderes.forEach(x => {
      x.orderOperation = OrderOperation.Approve;
      x.orderStatus = OrderStatus.Approved;
      x.orderStatusId = OrderStatus.Approved.valueOf();
      x.orderStatusFromUI = OrderStatus.New;
      x.orderStatusId = OrderStatus.Approved.valueOf()
    });
    this.coreSession.ModalLoading.Show();
    this.orderPendingService.approveSelectedOrders(selectedOrderes).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
        } else {
          this.coreSession.showWarrningWithTimeOutDelay(this.translateService.instant(ConstantMessages.WarningCaption), response.message, 24000);
        }
        this.query.customListFilter.page = 0;
        this.orderId = '';
        this.populateNewOrderList();
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  cancelSelectedOrder(order: any) {
    order.orderOperation = OrderOperation.Cancel;
    order.orderStatus = OrderStatus.Canceled;
    order.orderStatusId = OrderStatus.Canceled.valueOf();
    order.orderStatusFromUI = OrderStatus.New;
    this.coreSession.ModalLoading.Show();
    this.orderPendingService.isValidOperation(order).subscribe(
      response => {
        if (response.status > -1) {
          if (response.data.isValidOperation) {
            this.orderPendingService.deleteOrder(order).subscribe(
              response => {
                this.coreSession.ModalLoading.Hide();
                if (response.status != null && response.status >= 0) {
                  this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgCanceledSuccessfully));
                  this.query.customListFilter.page = 0;
                  this.orderId = '';
                  this.populateNewOrderList();
                } else {
                  this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
                }
              },
            );
          } else {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              response.message
            );
          }
        } else {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            response.message
          );
        }

      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );

  }

  selectedOrders = [];
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.View:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pendingOrdersURL, MenuActions.View)) {
          this.viewTransaction(event.object.orderSignature);
        }
        break;
      case RowOperation.approve:
        this.selectedOrders = [];
        this.selectedCustomerPriceList = event.object ;
        this.selectedOrders.push(event.object);
        this.CheckCustomerOrganizationIsExist()

        break;
      case RowOperation.delete:
        this.onCancelSelectedOrderClick(event.object);
        break;
      case RowOperation.edit:
        this.isValidToEdit(event.object);
        break;
      case RowOperation.Print:
        this.exportOrderReport(event);
        break;
      case RowOperation.EditWarehouse:
        this.initWarehouseForm();
        this.EditWarehouse(event.object);
        break;
    }
  }
  EditWarehouse(orderselect: any) {
    this.selectedOrder = orderselect;
    this.selectMainWarehouse(this.selectedOrder)
  }

  onApproveOrdersClicked(selectedOrders: any[]) {
    if (this.activateApprovalCycleForOrders) {
      // active orders => orders with approval status == -1.
      var activeOrders = selectedOrders.filter(order => order.approvalStatus === -1);
      // selected orders => orders with approval status > -1.
      selectedOrders = selectedOrders.filter(order => order.approvalStatus > -1);

      if (selectedOrders.length > 0) {
        this.isValidToApproveOrders(selectedOrders, activeOrders);
      } else {
        selectedOrders = activeOrders;
        this.finalApproveOrders(selectedOrders);
      }
    } else {
      this.finalApproveOrders(selectedOrders);
    }
  }

  isCustomerLinktoOrganization : boolean = false;
  CheckCustomerOrganizationIsExist() {
    debugger
    this.coreSession.ModalLoading.Show();
    var filter : GeneralFilter = {
    customerId : this.selectedCustomerPriceList.customerId,
    }
    this.customerService.CheckCustomerOrganizationIsExist(filter).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          debugger
          this.isCustomerLinktoOrganization = response.data;
          if(this.isCustomerLinktoOrganization== true)
            this.onApproveOrdersClicked(this.selectedOrders);
          else{
            this.approvePendinPriceList();
          }
          // this.transactionForm.get('transactionId').setValue(this.transactionId);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  isValidToApproveOrders(selectedOrders: any[], activeOrders: any[]) {
    var ordersToApprove = [];
    this.coreSession.ModalLoading.Show();
    this.orderPendingService.isValidToApprove(selectedOrders).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response != null && response.status > -1) {
        if (response.data) {
          if (response.data.invalidOrdersToApprove && response.data.invalidOrdersToApprove.length > 0) {
            this.dataSourceInvalidOrders = {
              totalItems: response.data,
              data: response.data.invalidOrdersToApprove
            };
            this.showReportScheduleTable();
          }
          if (response.data.validOrdersToApprove && response.data.validOrdersToApprove.length > 0) {
            ordersToApprove = response.data.validOrdersToApprove ? response.data.validOrdersToApprove : [];
          }

          ordersToApprove = ordersToApprove.concat(activeOrders);
          if (ordersToApprove.length > 0)
            this.finalApproveOrders(ordersToApprove, true);
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.ErrorHappened)
      );
    });
  }

  exportOrderReport(event: any) {
    let trans = {
      divisionId: event.object.divisionId ? event.object.divisionId : -1,
      transactionId: event.object.orderId,
      // reportMode: event.object.orderTypeId === OrderTypes.Return.valueOf()? ReportMode.ReturnOrder : ReportMode.SalesOrder,
      reportMode: ReportMode.SalesOrder,
      customerId: event.object.customerId ? event.object.customerId : -1,
      outletId: event.object.outletId ? event.object.outletId : -1,
      isReprintReport: true
    }
    this.pdfCreatorService.ExportReport(trans);
  }

  onCancelSelectedOrderClick(order: any) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgCancelConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {
        this.orderId = order.orderId;
        this.orderNoteDialog.showDialog().then(
          (result) => {
            if (result != -1) {
              order.Remarks = result;
              this.cancelSelectedOrder(order);
            }
          });
      }
    });
  }

  // onApproveClicked(order: any) {
  //   this.coreSession.ModalDialog.ShowMessage(
  //     this.translateService.instant(ConstantMessages.ApproveConfirmation),
  //     DialogMode.YesNo,
  //     this.translateService.instant(ConstantMessages.WarningCaption)
  //   ).then((result: DialogResult) => {
  //     if (result === DialogResult.Yes) {
  //       this.ApproveOrder(order);
  //     }
  //   });
  // }
  onMultiSelectionOperation(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        this.onDeleteMultiOrdersClick(event.object);
        break;
      }
      case MultiSelectionOperation.approve: {
        this.onApproveOrdersClicked(event.object);
        // this.approveSelectedOrders(event.object);
        break;
      }
    }
  }
  onDeleteMultiOrdersClick(ordersList) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgCancelConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {
        this.orderNoteDialog.showDialog().then(
          (result) => {
            if (result != -1) {
              ordersList.forEach(order => {
                order.Remarks = result;
                order.orderOperation = OrderOperation.Cancel;
                order.orderStatus = OrderStatus.Canceled;
                order.orderStatusFromUI = OrderStatus.New;
              });
              this.cancelMultiOrders(ordersList);
            }
          });
      }
    });
  }
  cancelMultiOrders(ordersList: any) {
    this.coreSession.ModalLoading.Show();
    this.orderPendingService.deleteMultiOrders(ordersList).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
          this.query.customListFilter.page = 0;
          this.orderId = '';
          this.populateNewOrderList();
        } else {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  isValidToEdit(order: any) {
    order.orderOperation = OrderOperation.EditValues;
    order.orderStatusFromUI = OrderStatus.New;
    this.coreSession.ModalLoading.Show();
    this.orderPendingService.isValidOperation(order).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data.isValidOperation) {
            this.onEditSelectedOrder(order);
          } else {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              response.data.message
            );
          }
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  onTableFilterChanged(query: any) {
    this.query.customListFilter = query;
    this.populateNewOrderList();
  }

  onFindButtonClicked(result) {

    this.query.customListFilter.page = 0;
    this.query.itemId = result.itemId;
    this.query.customerId = result.customerId;
    this.query.outletId = result.outletId;
    this.query.employeeId = result.employeeId;
    this.query.orderDateRange = result.transactionDate;
    this.query.desiredDeliveryDateRange = result.secondDate;
    this.query.orderTypeId = result.orderTypeId;
    this.query.isBundle = result.isBundle;
    this.query.hasUnlimitedFOC = result.hasUnlimitedFOC;
    this.query.warehouseId = result.warehouseId;
    if (this.isDivisionLevel())
      this.query.divisionId = result.divisionId;
    else
      this.query.divisionId = -1;
    this.populateNewOrderList();
  }

  closeViewSummarySlider() {
    this.selectedOrder = null;
    this.operationSummaryData = null;
    this.showViewSummarySlider = false;
    this.ItemSummaryDialog.Close();
  }

  viewTransaction(signature: string) {
    let query: OrderListFilter = {};
    query.orderSignature = signature;
    query.isViewMode = true;
    this.orderPendingService.getOrder(query).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.selectedOrder = response.data;
          this.operationSummaryData = {
            operationData: this.selectedOrder,
            formProcessMode: FormProcessMode.Orders,
            formTitle: 'Desc_Order_Summary'
          };
          if (this.selectedOrder.orderTypeId === OrderTypes.Return.valueOf() &&
            this.restrictReturnFromInvoices &&
            this.selectedOrder.isRestrictedFromOldInvoices) {
            this.operationSummaryData.operationData.allowBatchesInItems = true;
          }
          this.showViewSummarySlider = true;
          this.openItemSummaryDialog()
        } else {
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  showReportScheduleTable() {
    this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.InvalidOrderReasons, {
      centered: true,
      size: 'lg',
    });
    this.config.backdrop = true;
  }

  onClosingInvalidOrderReasons() {
    this.modalRef.dismiss();
  }

  onRowInvalidOrderReasonsClicked(event: any) {
    switch (event.operation) {
      case RowOperation.View:
        let message = "";
        event.object.avaliableItemsQty.forEach((item) => {
          message += `${this.translateService.instant(ConstantMessages.Desc_Item)} : ${item.itemCodeName}  |  ${this.translateService.instant(ConstantMessages.Desc_Avaliable_Quantity)} : ${item.availableQtyInPcs}\n`;
        });
        this.coreSession.ModalDialog.ShowMessage(
          message,
          DialogMode.Ok,
          this.translateService.instant(ConstantMessages.Desc_Avaliable_Quantity))
        break;
    }
  }

  openPriceEntryDialog() {
    this.PriceEntryDialog.Show(true).then((res) => { });
  }

 openOutletContactDialog(){
   this.ContactEntryDialog.Show(true).then((res) => { });
 }
 selectedCustomerPriceList: any = {};

 onPriceListIDSelected(selectedPriceList: any) {
  if(selectedPriceList)
    this.selectedCustomerPriceList.priceListID = selectedPriceList.priceListId
  else{
    this.selectedCustomerPriceList.priceListID  = -1
  }
}
approvePendinPriceList(){
  var PriceListObject = this.selectedCustomerPriceList
  var customerPrice = {
    customerId : PriceListObject.customerId,
    customerName : "",
    outletId : PriceListObject.outletId,
    priceListID :-1,
    descriptionLanguages : [],
    customerOutletContacts:[]
  }
  this.selectedCustomerPriceList = customerPrice;
  this.populatePriceLists();
 }

 onOtherLanguagesTextSubmitted(event) {
  debugger
  this.selectedCustomerPriceList.descriptionLanguages[0] = event[0];
}
customerForm : FormGroup
customerNameInput: ITextInput = {
  formControlName: "customerName",
  placeHolder: "Desc_Customer_Name",
  label: "Desc_Customer_Name",
  isRequierd: true,
};
onSaveClick() {
  this.isTouched = false

  if(this.selectedCustomerPriceList.priceListID != -1 && this.customerForm.valid ){
    var customerlanguage = this.customerForm.get("customerName").value;
    this.selectedCustomerPriceList.customerName = customerlanguage;
    var customerDescriptionlanguage = {
      languageId: this.coreSession.selectedLanguageId,
      description: customerlanguage,
    }

    this.selectedCustomerPriceList.descriptionLanguages.push(customerDescriptionlanguage)
    this.openOutletContactDialog()
    //
  }
  else{
    if(this.selectedCustomerPriceList.priceListID == -1)
    this.isTouched = true

    this.customerForm.markAllAsTouched();

    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
  }
 }
 closeSlider() {
  this.PriceEntryDialog.Close()
  this.isTouched = false
}
onSaveOutletContactClick(){
  this.FillOutletObjData()

 }
 FillOutletObjData() {
  if (this.contactsDataSourceArray && this.contactsDataSourceArray.length > 0) {
    this.selectedCustomerPriceList.customerOutletContacts = this.contactsDataSourceArray;
  }
  this.insertCustomerPriceList();
}
PriceListDate: any[];

PriceListDateLoading = false;

priceFilter: any = {
  customListFilter: {
    searchFilter: '',
    page: 0,
    pageSize: this.coreSession.pageSize
  },
  organizationId: -1,
  priceListTypeId: -1,
  dateModel: null,
  toDate: null,
  customerId: -1,
  outletId: -1
};

priceFilterForm: FormGroup;
toDate: DateTimeModel = null;
fromDate: DateTimeModel = null;

initFilterForm() {
  this.priceFilterForm = new FormGroup({
    organizationId: new FormControl(),
    fromDate: new FormControl(null),
    toDate: new FormControl(null),
    priceListTypeId: new FormControl(),
    customerId: new FormControl(
      { value: null, disabled: false },
    ),
    outletId: new FormControl(
      { value: null, disabled: false },
    ),
  })
}
populatePriceLists() {
  this.priceFilter.organizationId = this.priceFilterForm.get('organizationId').value == null ? -1 : this.priceFilterForm.get('organizationId').value;
  this.priceFilter.priceListTypeId = this.priceFilterForm.get('priceListTypeId').value == null ? -1 : this.priceFilterForm.get('priceListTypeId').value;
  this.priceFilter.customListFilter = this.query.customListFilter;
  this.priceFilter.dateModel = this.fromDate == null ? null : this.fromDate;
  this.priceFilter.toDate = this.toDate == null ? null : this.toDate;
  this.priceFilter.customerId= -1
  this.priceFilter.outletId=   -1
  this.PriceListDateLoading = true
  this.coreSession.ModalLoading.Show();
  this.priceService.getPriceLists(this.priceFilter).subscribe(
    (response: ResponseModel) => {
      this.coreSession.ModalLoading.Hide();
      (response);
      if (response.status != null && response.status >= 0) {
        this.PriceListDate = response.data.data;
        this.PriceListDate = this.PriceListDate.filter(priceList=>priceList.isDefault==false)
        this.openPriceEntryDialog()
      }
      this.selectedPriceListId= null;
      this.PriceListDateLoading = false
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
}

contactsTableProperties: ITableProperties = {
  pageSize: this.coreSession.pageSize,
  showPaginator: true,
  showSearch: true,
  isOnline: false,
  isMultiSelection: false,
  rowOperations: [
    {
      operation: RowOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e'
    }, {
      operation: RowOperation.edit,
      title: "Desc_Edit",
      icon: "fa-regular fa-pen-to-square",
      color: "#12344d"
    }
  ],
  multiSelectionOperations: [],
  columns: [
    {
      title: 'Desc_Contact_Name',
      key: 'contactName',
      isSortable: true,

    },
    // {
    //   title: 'Desc_Address',
    //   key: 'address',
    //   isSortable: true,
    //   width: '14%'
    // },
    // {
    //   title: 'Desc_Mobile',
    //   key: 'mobile',
    //   isSortable: true,
    //   width: '14%'
    // },
    {
      title: 'Desc_Phone',
      key: 'phone',
      isSortable: true,

    },
    // {
    //   title: 'Desc_Fax',
    //   key: 'fax',
    //   isSortable: true,
    //   width: '14%'
    // },
    {
      title: 'Desc_Email',
      key: 'email',
      isSortable: true,

    }
    // ,
    // {
    //   title: 'Desc_Street',
    //   key: 'streetName',
    //   isSortable: true,
    //   width: '10%'
    // }
  ]
};
contactNameInput: ITextInput = {
  formControlName: 'contactName',
  placeHolder: 'Desc_Contact_Name',
  label: 'Desc_Contact_Name',
  isRequierd: false
};
onRowClicked_contacts(event: any) {
  switch (event.operation) {
    case RowOperation.delete:
      this.deleteSelectContact(event.object);
      break;
    case RowOperation.edit:
      this.editSelectedContact(event.object);
      break;
  }
}
clearContactData() {
  this.resetContactFields();

  this.selectedContactIndex = -1;
}
selectedPriceListId:any = {} ;
insertCustomerPriceList(){
  this.priceService.InsertCustomerPriceList(this.selectedCustomerPriceList)
  .subscribe(
    (response: ResponseModel) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
          this.selectedPendingPriceList.statusId = 2;
          this.PriceEntryDialog.Close()
          this.ContactEntryDialog.Close()
          this.onApproveOrdersClicked(this.selectedOrders)
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
    (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
  );
 }

closeOutletDialog(){
  this.ContactEntryDialog.Close()
 }
 setContactDataMarkedAsTouched() {
  this.outletForm.get('contactData').get('email').markAsTouched();
  this.outletForm.get('contactData').get('contactName').markAsTouched();
}
resetContactFields() {
  this.outletForm.get('contactData').get('contactId').reset('');
  this.outletForm.get('contactData').get('contactName').reset('');
  this.outletForm.get('contactData').get('address').reset();
  this.outletForm.get('contactData').get('email').reset('');
  this.outletForm.get('contactData').get('fax').reset('');
  this.outletForm.get('contactData').get('mobile').reset('');
  this.outletForm.get('contactData').get('phone').reset('');
  this.outletForm.get('contactData').get('street').reset('');
  this.outletForm.get('contactData').get('streetName').reset('');
  this.outletForm.get('contactData').get('addressDescriptionLanguages').reset([]);
  this.outletForm.get('contactData').get('contactDescriptionLanguages').reset([]);

  this.contactAddBtnDesc = 'Desc_Add';
}

addContactData() {
  this.outletForm.get('contactData').get('contactName').setValidators([Validators.required]);
  this.outletForm.get('contactData').get('contactName').updateValueAndValidity();
  this.fillContactsObject();
  if ( (this.customerOutletContactModel.email !== ''
    || this.customerOutletContactModel.mobile !== 0
    || this.customerOutletContactModel.phone !== 0
    || this.customerOutletContactModel.fax !== 0)) {
    this.checkCustomerDataOnline(this.customerOutletContactModel);
  } else {
    this.checkIsContactValid(this.customerOutletContactModel);
  }
}
checkCustomerDataOnline(selectedContact: CustomerOutletContactModel) {

  this.customerService.checkIfContactDataExists(selectedContact).subscribe(response => {

    if (response.message && response.message !== '' && response.status == -1) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
    } else {
      this.checkIsContactValid(selectedContact);
    }
  }, (error: HttpErrorResponse) => {
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
  });
}
checkIsContactValid(addedContact: CustomerOutletContactModel) {
  let mobileIndex = this.contactsDataSourceArray.findIndex(x => x.mobile !== 0 && x.mobile === addedContact.mobile);
  let faxIndex = this.contactsDataSourceArray.findIndex(x => x.fax !== 0 && x.fax === addedContact.fax);
  let phoneIndex = this.contactsDataSourceArray.findIndex(x => x.phone !== 0 && x.phone === addedContact.phone);
  let emailIndex = this.contactsDataSourceArray.findIndex(x => x.email != '' && x.email === addedContact.email);
  if (addedContact.mobile === 0 && addedContact.fax === 0 && addedContact.phone === 0 && addedContact.email === '') {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillAtLeastOneOfContactFields));
    return false;
  } else if (mobileIndex != -1 && mobileIndex !== this.selectedContactIndex) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedMobileNumberAlreadyExists));
    return false;
  } else if (faxIndex != -1 && faxIndex !== this.selectedContactIndex) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedFaxNumberAlreadyExists));
    return false;
  } else if (phoneIndex != -1 && phoneIndex !== this.selectedContactIndex) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedPhoneNumberAlreadyExists));
    return false;
  } else if (emailIndex != -1 && emailIndex !== this.selectedContactIndex) {
    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedEmailAlreadyExists));
    return false;
  } else if (this.outletForm.get('contactData').invalid) {
    this.setContactDataMarkedAsTouched();
    if (!this.outletForm.get('contactData').get('contactName') || this.outletForm.get('contactData').get('contactName').value === '') {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return false;
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgInsertValidEmail));
      return false;
    }
  } else {
    this.customerOutletContactModel.streetName = this.outletForm.get('contactData').get('streetName').value != null ? this.outletForm.get('contactData').get('streetName').value : '';
    if (this.selectedContactIndex >= 0) {
      this.contactsDataSourceArray[this.selectedContactIndex] = addedContact;
      this.selectedContactIndex = -1;
    } else {
      this.contactsDataSourceArray.push(addedContact);
    }
    this.contacts_dataSource = {
      data: this.contactsDataSourceArray,
      totalItems: this.contactsDataSourceArray.length
    }
    this.resetContactFields();
    return true;
  }
}
contacts_dataSource: SharedTableResult = {
  totalItems: 0,
  data: []
};

onOtherContactNameLanguagesTextSubmitted(event) {
  this.outletForm.get('contactData').get('contactDescriptionLanguages').setValue(event);
}

InitOutletForm() {
  this.outletForm = new FormGroup({
    contactData: new FormGroup({
      contactId: new FormControl(null),
      contactName: new FormControl(''),
      mobile: new FormControl(null),
      phone: new FormControl(null),
      fax: new FormControl(null),
      street: new FormControl(null),
      streetName: new FormControl(null),
      address: new FormControl(null),
      address2: new FormControl(null),
      email: new FormControl('', [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
      contactDescriptionLanguages: new FormControl([]),
      addressDescriptionLanguages: new FormControl([]),
      address2DescriptionLanguages: new FormControl([]),
      languageId: new FormControl(null)
    }),
  });
}
contactId: number = -1;
fillContactsObject() {
  this.customerOutletContactModel = new CustomerOutletContactModel();
  if (this.selectedContactIndex < 0) {
    this.contactId = +this.contactId + 1;
  } else {
    this.contactId = this.contactsDataSourceArray[this.selectedContactIndex].contactId;
  }
  this.outletForm.get('contactData').get('contactId').setValue(this.contactId);
  this.customerOutletContactModel.contactId = this.outletForm.get('contactData').get('contactId').value;
  this.customerOutletContactModel.contactName = this.outletForm.get('contactData').get('contactName').value;
  this.customerOutletContactModel.address = this.outletForm.get('contactData').get('address').value === '' || this.outletForm.get('contactData').get('address').value == null ? '' : this.outletForm.get('contactData').get('address').value;
  this.customerOutletContactModel.email = this.outletForm.get('contactData').get('email').value;
  this.customerOutletContactModel.fax = (this.outletForm.get('contactData').get('fax').value === '' || this.outletForm.get('contactData').get('fax').value == null ? 0 : this.outletForm.get('contactData').get('fax').value);
  this.customerOutletContactModel.mobile = (this.outletForm.get('contactData').get('mobile').value === '' || this.outletForm.get('contactData').get('mobile').value == null ? 0 : this.outletForm.get('contactData').get('mobile').value);
  this.customerOutletContactModel.phone = (this.outletForm.get('contactData').get('phone').value === '' || this.outletForm.get('contactData').get('phone').value == null ? 0 : this.outletForm.get('contactData').get('phone').value);
  this.customerOutletContactModel.street = this.outletForm.get('contactData').get('street').value === '' || this.outletForm.get('contactData').get('street').value == null ? 0 : this.outletForm.get('contactData').get('street').value;
  this.customerOutletContactModel.addressDescriptionsLanguages = this.outletForm.get('contactData').get('addressDescriptionLanguages').value;
  this.customerOutletContactModel.contactDescriptionsLanguages = this.outletForm.get('contactData').get('contactDescriptionLanguages').value;

  let contactDescriptions = [];
  if (this.customerOutletContactModel.contactDescriptionsLanguages != null) {
    contactDescriptions = this.customerOutletContactModel.contactDescriptionsLanguages;
    let index = contactDescriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
    if (index == -1) {
      contactDescriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.customerOutletContactModel.contactName
      });
      if (contactDescriptions.length === 1) {
        if (this.coreSession.selectedLanguageId === 1) {
          contactDescriptions.push({
            languageId: 2,
            description: ''
          });
        } else {
          contactDescriptions.push({
            languageId: 1,
            description: ''
          });
        }
      }

    } else {
      contactDescriptions[index].description = this.customerOutletContactModel.contactName;
    }
  }

  let addressDescriptions = [];
  if (this.customerOutletContactModel.addressDescriptionsLanguages != null) {
    addressDescriptions = this.customerOutletContactModel.addressDescriptionsLanguages;
    let index = addressDescriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
    if (index == -1) {
      addressDescriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: (!this.customerOutletContactModel.address ? '' : this.customerOutletContactModel.address)
      });
      if (addressDescriptions.length === 1) {
        if (this.coreSession.selectedLanguageId === 1) {
          addressDescriptions.push({
            languageId: 2,
            description: ''
          });
        } else {
          addressDescriptions.push({
            languageId: 1,
            description: ''
          });
        }
      }
    } else {
      addressDescriptions[index].description = this.customerOutletContactModel.address;
    }
  }
}
contactsDataSourceArray: CustomerOutletContactModel[] = [];
selectedContactIndex: number = -1;
contactNameOldDescription: any[] = [];
contactAddressOldDescription: any[] = [];
contactAddBtnDesc: string = '';
editSelectedContact(selectedContact: CustomerOutletContactModel) {
  this.selectedContactIndex = this.contactsDataSourceArray.indexOf(selectedContact);
  this.outletForm.get('contactData').get('contactId').setValue(selectedContact.contactId);
  this.outletForm.get('contactData').get('contactName').setValue(selectedContact.contactName);
  this.outletForm.get('contactData').get('address').setValue(selectedContact.address);
  this.outletForm.get('contactData').get('email').setValue(selectedContact.email);
  this.outletForm.get('contactData').get('fax').setValue((selectedContact.fax === 0) ? '' : selectedContact.fax);
  this.outletForm.get('contactData').get('mobile').setValue((selectedContact.mobile === 0) ? '' : selectedContact.mobile);
  this.outletForm.get('contactData').get('phone').setValue((selectedContact.phone === 0) ? '' : selectedContact.phone);
  this.outletForm.get('contactData').get('street').setValue(selectedContact.street);
  this.outletForm.get('contactData').get('streetName').setValue(selectedContact.streetName);
  this.outletForm.get('contactData').get('addressDescriptionLanguages').setValue(selectedContact.addressDescriptionsLanguages);
  this.outletForm.get('contactData').get('contactDescriptionLanguages').setValue(selectedContact.contactDescriptionsLanguages);

  this.contactNameOldDescription = selectedContact.contactDescriptionsLanguages;
  this.contactAddressOldDescription = selectedContact.addressDescriptionsLanguages;
  this.contactAddBtnDesc = 'Desc_Edit';
}
deleteSelectContact(selectedContact: CustomerOutletContactModel) {

let index = -1;
index = this.contactsDataSourceArray.findIndex(x => x.contactId === selectedContact.contactId);

if (index != -1) {
  this.contactsDataSourceArray.splice(index, 1);
  this.contacts_dataSource = {
    data: this.contactsDataSourceArray,
    totalItems: this.contactsDataSourceArray.length
  }
}
}
}
