import { Component, OnInit, Input, EventEmitter, Output } from "@angular/core";
import { SharedTableResult } from "../../../shared/models/shared-table/shared-table-result.interface";
import { ITableProperties } from "../../../shared/models/shared-table/table-properties.interface";
import { SessionDataProvider } from '../../../core/session-data-provider.service';

@Component({
  selector: "app-recurring-details",
  templateUrl: "./recurring-details.component.html",
  styleUrls: ["./recurring-details.component.css"]
})
export class RecurringDetailsComponent implements OnInit {


  @Input('RecurringData') data: any = {};
  @Output('Close') closeEvent = new EventEmitter();
  recurringObj: any = {};
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  TabelData: ITableProperties = {
    pageSize: 150,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Item_Code",
        key: "itemCode",
        isSortable: true,
        width: "15%"
      },
      {
        title: "Desc_Item_Description",
        key: "itemName",
        isSortable: true,
        width: "28%"
      },
      {
        title: "Desc_UOM",
        key: "uom",
        isSortable: false,
        width: "8%"
      },
      {
        title: "Desc_Quantity",
        key: "requiredQty",
        isSortable: false,
        width: "10%",
        numberOfDigits: true
      },
      {
        title: "Desc_Unit_Price",
        key: "price",
        isSortable: false,
        width: "13%",
        numberOfDigits: true
      },
      {
        title: "Desc_Discount",
        key: "discountString",
        isSortable: false,
        width: "8%",
      },
      {
        title: "Desc_Tax",
        key: "tax",
        isSortable: false,
        width: "8%",
        numberOfDigits: true
      },
      {
        title: "Desc_Total",
        key: "netTotal",
        isSortable: false,
        width: "10%",
        numberOfDigits: true
      }
    ]
  };

  constructor(public sessionData : SessionDataProvider) { }

  ngOnInit() {
    this.recurringObj = this.data.recurringObj;
    var sharedTableData = {
      data: this.data.order.soldItems,
      totalItems: this.data.order.soldItems.length
    };
    this.dataSource = sharedTableData;
  }
}
