import { Component, OnInit, Output, Input, EventEmitter, ViewChild, OnChanges } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { RecurOrderOptionType } from '../../../shared/models/enums/recur-order-option-type.enum';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { CoreSession } from '../../../core/core.session';
import { OrderService } from '../order.service';
import { IDateTimePickerProperties } from '../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../shared/models/dateTimeModel/date-time.model';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { HttpErrorResponse } from '@angular/common/http';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';

@Component({
  selector: 'app-recurring-order',
  templateUrl: './recurring-order.component.html',
  styleUrls: ['./recurring-order.component.css']
})
export class RecurringOrderComponent implements OnInit {

  //#region [DECLARATIONS]

  OkResult: DialogResult = DialogResult.Ok;
  @Input() recurringObj: any;
  @Input() isOddWeek: true;
  @ViewChild('content', { static: true }) content: any;

  form: FormGroup;
  recurringTypeDataSource: any[];
  daysOfMonthDataSource: any[];
  statusList: any[];
  allChangedReasonList: any[];
  changedReasonList: any[];
  isWeekly: boolean;
  every2Weeks: boolean = false;
  showChangedReason: boolean = false;
  onHoldSelected: boolean = false;
  resumeDate: DateTimeModel;
  resumeDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Resume_Date',
    formControlName: 'resumeDate',
    min: new Date(),
    isCalendarOnly: true,
    labelHidden: true
  };

  //#endregion

  //#region [CONSTRUCTOR]

  constructor(private modalService: NgbModal, private coreSession: CoreSession,
    private translateService: TranslateService) { }

  ngOnInit() {
    this.recurringTypeDataSource = [
      { typeId: RecurOrderOptionType.DaysOfWeek, type: this.translateService.instant(ConstantMessages.Desc_Weekly) },
      { typeId: RecurOrderOptionType.DaysOfMonth, type: this.translateService.instant(ConstantMessages.Desc_Monthly) },
      { typeId: RecurOrderOptionType.EveryTwoWeeks, type: this.translateService.instant(ConstantMessages.Desc_Every_Two_Weeks) }
    ];
    this.statusList = [
      { statusId: 1, name: this.translateService.instant(ConstantMessages.Desc_Active) },
      { statusId: 2, name: this.translateService.instant(ConstantMessages.Desc_On_Hold) },
      { statusId: 3, name: this.translateService.instant(ConstantMessages.Desc_Inactive) }
    ];
    this.daysOfMonthDataSource = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31];
    this.isWeekly = true;
    this.every2Weeks = false;
    this.initForm();
    this.fillChangedReasons();
  }

  //#endregion

  //#region [EVENTS]

  onChangeType() {
    if (this.typeId.value) {
      if (this.typeId.value == RecurOrderOptionType.DaysOfWeek) {
        this.every2Weeks = false;
        this.isWeekly = true;
        this.sunday.setValue(false);
        this.monday.setValue(false);
        this.tuesday.setValue(false);
        this.thursday.setValue(false);
        this.wednesday.setValue(false);
        this.friday.setValue(false);
        this.saturday.setValue(false);
      }
      else if (this.typeId.value == RecurOrderOptionType.DaysOfMonth) {
        this.every2Weeks = false;
        this.isWeekly = false;
        this.daysOfMonth.setValue(false);
      } else if (this.typeId.value == RecurOrderOptionType.EveryTwoWeeks) {
        this.isWeekly = false;
        this.every2Weeks = true;
        this.sunday1.setValue(false);
        this.monday1.setValue(false);
        this.tuesday1.setValue(false);
        this.thursday1.setValue(false);
        this.wednesday1.setValue(false);
        this.friday1.setValue(false);
        this.saturday1.setValue(false);
        this.sunday2.setValue(false);
        this.monday2.setValue(false);
        this.tuesday2.setValue(false);
        this.thursday2.setValue(false);
        this.wednesday2.setValue(false);
        this.friday2.setValue(false);
        this.saturday2.setValue(false);
      }
    }
  }

  onSaveClicked(modal) {
    if (this.showChangedReason && (!this.changedReason.value || this.changedReason.value <= 0)) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgSelectChangeReason));
      return;
    }
    if (this.onHoldSelected && !this.resumeDate) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgSelectResumeDate));
      return;
    }
    this.fillItemObject();
    if (this.recurringObj.recurringValues == '') {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgSelectRecurringDetails));
      return;
    }
    if (this.form.invalid) {
      this.coreSession.markFormGroupTouched(this.form as FormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    modal.close(DialogResult.Ok);
  }

  onStatusChanged() {
    if (!this.status.value || this.status.value === 1) {
      this.onHoldSelected = false;
      this.showChangedReason = false;
      this.changedReason.setValue(null);
    }
    else if (this.status.value === 2) {
      this.changedReasonList = this.allChangedReasonList
        .filter(function (obj) {
          return obj.statusId === 2;
        });
      this.changedReason.setValue(null);
      this.showChangedReason = true;
      this.onHoldSelected = true;
    }
    else if (this.status.value === 3) {
      this.changedReasonList = this.allChangedReasonList
        .filter(function (obj) {
          return obj.statusId === 3;
        });
      this.changedReason.setValue(null);
      this.onHoldSelected = false;
      this.showChangedReason = true;
    }
  }

  onResumeDateSelected(date) {
    this.resumeDate = date;
  }

  //#endregion

  //#region [METHODS]

  fillChangedReasons() {
    // this.orderRecurringService.getRecurringChangedReason().subscribe(
    //   response => {
    //     this.coreSession.ModalLoading.Hide();
    //     if (response.status != null && response.status >= 0) {
    //       this.allChangedReasonList = response.data;
    //     }
    //     else {
    //       this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    //     }
    //   },
    //   (error: HttpErrorResponse) => {
    //     this.coreSession.ModalLoading.Hide();
    //     this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    //   });
  }

  markAsTouched() {
    this.typeId.markAsTouched();
    this.status.markAsTouched();
    if (this.showChangedReason)
      this.changedReason.markAsTouched();
  }

  fillItemObject() {
    var values = '';
    this.recurringObj = new Object();
    this.recurringObj.typeId = this.typeId.value;
    if (this.typeId.value == RecurOrderOptionType.DaysOfWeek) {
      if (this.form.value.sunday)
        values = "1,";
      if (this.form.value.monday)
        values = values + "2,";
      if (this.form.value.tuesday)
        values = values + "3,";
      if (this.form.value.wednesday)
        values = values + "4,";
      if (this.form.value.thursday)
        values = values + "5,";
      if (this.form.value.friday)
        values = values + "6,";
      if (this.form.value.saturday)
        values = values + "7,";
    }
    else if (this.typeId.value == RecurOrderOptionType.DaysOfMonth) {
      if (this.daysOfMonth.value) {
        this.daysOfMonth.value.forEach(element => {
          values = values + element + ",";
        });
      }
    }
    else if (this.typeId.value == RecurOrderOptionType.EveryTwoWeeks) {
      if (this.form.value.sunday1)
        values = "1,";
      if (this.form.value.monday1)
        values = values + "2,";
      if (this.form.value.tuesday1)
        values = values + "3,";
      if (this.form.value.wednesday1)
        values = values + "4,";
      if (this.form.value.thursday1)
        values = values + "5,";
      if (this.form.value.friday1)
        values = values + "6,";
      if (this.form.value.saturday1)
        values = values + "7,";
      if (this.form.value.sunday2)
        values = values + "8,";
      if (this.form.value.monday2)
        values = values + "9,";
      if (this.form.value.tuesday2)
        values = values + "10,";
      if (this.form.value.wednesday2)
        values = values + "11,";
      if (this.form.value.thursday2)
        values = values + "12,";
      if (this.form.value.friday2)
        values = values + "13,";
      if (this.form.value.saturday2)
        values = values + "14,";
    }
    this.recurringObj.statusId = this.status.value;
    if (this.showChangedReason) {
      this.recurringObj.changedReasonId = this.changedReason.value;
    }
    else {
      this.recurringObj.changedReasonId = -1;
    }
    if (this.onHoldSelected) {
      this.recurringObj.resumeDate = this.resumeDate;
    }
    else {
      this.recurringObj.resumeDate = null;
    }
    this.recurringObj.recurringComment = this.comment.value;
    this.recurringObj.recurringValues = values.slice(0, -1);
  }

  initForm() {
    this.form = new FormGroup({
      typeId: new FormControl(1, Validators.required),
      inactive: new FormControl(0),
      //Used for Day Of Week Only
      sunday: new FormControl(false),
      monday: new FormControl(false),
      tuesday: new FormControl(false),
      wednesday: new FormControl(false),
      thursday: new FormControl(false),
      friday: new FormControl(false),
      saturday: new FormControl(false),
      //Used for Every Two Weeks
      sunday1: new FormControl(false),
      monday1: new FormControl(false),
      tuesday1: new FormControl(false),
      wednesday1: new FormControl(false),
      thursday1: new FormControl(false),
      friday1: new FormControl(false),
      saturday1: new FormControl(false),
      sunday2: new FormControl(false),
      monday2: new FormControl(false),
      tuesday2: new FormControl(false),
      wednesday2: new FormControl(false),
      thursday2: new FormControl(false),
      friday2: new FormControl(false),
      saturday2: new FormControl(false),

      daysOfMonth: new FormControl(null),
      status: new FormControl(1, Validators.required),
      changedReason: new FormControl(null),
      comment: new FormControl(''),
      resumeDate: new FormControl(''),
    });
  }

  public ShowDialog(rec) {
    //Edit --> Fill Data
    this.recurringObj = rec;
    this.form.reset();
    this.typeId.setValue(RecurOrderOptionType.DaysOfWeek);
    if (this.recurringObj && this.recurringObj.typeId != -1 && this.recurringObj.recurringValues && this.recurringObj.recurringValues != '') {
      this.typeId.setValue(this.recurringObj.typeId);
      this.status.setValue(this.recurringObj.statusId);
      this.onStatusChanged();
      if (this.showChangedReason && this.recurringObj.changedReasonId && this.recurringObj.changedReasonId > 0) {
        this.changedReason.setValue(this.recurringObj.changedReasonId);
      }
      else {
        this.changedReason.setValue(null);
      }
      if (this.onHoldSelected && this.recurringObj.resumeDate) {
        this.resumeDate = this.recurringObj.resumeDate;
        this.resumeDateControl.setValue(this.resumeDate.date);
      }
      this.comment.setValue(this.recurringObj.recurringComment);
      this.isWeekly = false;
      this.every2Weeks = false;
      if (this.recurringObj.typeId == RecurOrderOptionType.DaysOfWeek) {
        this.isWeekly = true;
        if (this.recurringObj.recurringValues.includes(1))
          this.sunday.setValue(true);
        if (this.recurringObj.recurringValues.includes(2))
          this.monday.setValue(true);
        if (this.recurringObj.recurringValues.includes(3))
          this.tuesday.setValue(true);
        if (this.recurringObj.recurringValues.includes(4))
          this.wednesday.setValue(true);
        if (this.recurringObj.recurringValues.includes(5))
          this.thursday.setValue(true);
        if (this.recurringObj.recurringValues.includes(6))
          this.friday.setValue(true);
        if (this.recurringObj.recurringValues.includes(7))
          this.saturday.setValue(true);
      }
      else if (this.recurringObj.typeId == RecurOrderOptionType.DaysOfMonth) {
        this.daysOfMonth.setValue(this.recurringObj.recurringValues.split(",").map(Number));
      } else if (this.recurringObj.typeId == RecurOrderOptionType.EveryTwoWeeks) {
        this.every2Weeks = true;
        var selectedDays = this.recurringObj.recurringValues.split(",").map(Number);
        if (selectedDays && selectedDays.length > 0) {
          if (selectedDays.includes(1))
            this.sunday1.setValue(true);
          if (selectedDays.includes(2))
            this.monday1.setValue(true);
          if (selectedDays.includes(3))
            this.tuesday1.setValue(true);
          if (selectedDays.includes(4))
            this.wednesday1.setValue(true);
          if (selectedDays.includes(5))
            this.thursday1.setValue(true);
          if (selectedDays.includes(6))
            this.friday1.setValue(true);
          if (selectedDays.includes(7))
            this.saturday1.setValue(true);
          if (selectedDays.includes(8))
            this.sunday2.setValue(true);
          if (selectedDays.includes(9))
            this.monday2.setValue(true);
          if (selectedDays.includes(10))
            this.tuesday2.setValue(true);
          if (selectedDays.includes(11))
            this.wednesday2.setValue(true);
          if (selectedDays.includes(12))
            this.thursday2.setValue(true);
          if (selectedDays.includes(13))
            this.friday2.setValue(true);
          if (selectedDays.includes(14))
            this.saturday2.setValue(true);
        }
      }
    }
    return this.modalService.open(this.content, {
      centered: true
    }).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          return this.recurringObj;
        } else {
          return -1;
        }
      }
    );
  }

  //#endregion

  //#region [PROPERTIES]

  get resumeDateControl() {
    return this.form.get('resumeDate');
  }
  get status() {
    return this.form.get('status');
  }
  get comment() {
    return this.form.get('comment');
  }
  get changedReason() {
    return this.form.get('changedReason');
  }
  get typeId() {
    return this.form.get('typeId');
  }
  get saturday() {
    return this.form.get('saturday');
  }
  get sunday() {
    return this.form.get('sunday');
  }
  get monday() {
    return this.form.get('monday');
  }
  get tuesday() {
    return this.form.get('tuesday');
  }
  get wednesday() {
    return this.form.get('wednesday');
  }
  get thursday() {
    return this.form.get('thursday');
  }
  get friday() {
    return this.form.get('friday');
  }
  get daysOfMonth() {
    return this.form.get('daysOfMonth');
  }

  get saturday1() {
    return this.form.get('saturday1');
  }
  get sunday1() {
    return this.form.get('sunday1');
  }
  get monday1() {
    return this.form.get('monday1');
  }
  get tuesday1() {
    return this.form.get('tuesday1');
  }
  get wednesday1() {
    return this.form.get('wednesday1');
  }
  get thursday1() {
    return this.form.get('thursday1');
  }
  get friday1() {
    return this.form.get('friday1');
  }

  get saturday2() {
    return this.form.get('saturday2');
  }
  get sunday2() {
    return this.form.get('sunday2');
  }
  get monday2() {
    return this.form.get('monday2');
  }
  get tuesday2() {
    return this.form.get('tuesday2');
  }
  get wednesday2() {
    return this.form.get('wednesday2');
  }
  get thursday2() {
    return this.form.get('thursday2');
  }
  get friday2() {
    return this.form.get('friday2');
  }

  //#endregion
}
