import { Component, OnInit, ViewChild } from "@angular/core";
import { OrderService } from "../order.service";
import { CoreSession } from "../../../core/core.session";
import { SharedTableResult } from "../../../shared/models/shared-table/shared-table-result.interface";
import { OrderListFilter } from "../../../shared/models/shared-table/custom-list.interface";
import { ITableProperties } from "../../../shared/models/shared-table/table-properties.interface";
import { OrderStatus } from "../../../shared/models/enums/order-status.enum";
import { OrderOperation } from "../../../shared/models/enums/order-operation .enum";
import { DialogMode } from "../../../shared/models/enums/dialog-mode.enum";
import { HttpErrorResponse } from "@angular/common/http";
import { ConstantMessages } from "../../../shared/models/constants/constant-message";
import { RowOperation, MultiSelectionOperation } from "../../../shared/models/enums/shared-table-operation.enum";
import { DialogResult } from "../../../shared/models/enums/dialog-result.enum";
import { TranslateService } from "@ngx-translate/core";
import { ConstantURLs } from "../../../shared/models/constants/constant-URL";
import { DocumentTypes } from "../../../shared/models/enums/document-types.enum";
import { ValidationService } from "../../../shared/services/validation.service";
import { IOperationSummary } from "../../../shared/models/operation-summary/operation-summary-interface";
import { FormProcessMode } from "../../../shared/models/enums/form-process-mode.enum";
import { MenuActions } from '../../../shared/models/enums/menu-actions-enum';
import { OrderNoteDialogComponent } from '../order-note-dialog/order-note-dialog.component';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { CommonButtonStyles } from '../../../shared/models/enums/common-button-styles.enum';
import { OrderTypes } from '../../../shared/models/enums/order-types.enum';
import { OrderRejectedService } from "../../../shared/services/order/order-rejected.service";
import { NavBarService } from "../../../core/sidebar/sidebar.service";

@Component({
  selector: 'app-reject-order',
  templateUrl: './reject-order.component.html',
  styleUrls: ['./reject-order.component.css']
})
export class RejectOrderComponent implements OnInit {

  @ViewChild("orderNoteDialog", { static: true }) orderNoteDialog: OrderNoteDialogComponent;
  orderId = "";
  selectedOrder: any;

  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: true,
    showNewBtn: false,
    showExport: true,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Order_ID",
        key: "orderId",
        isSortable: true,
        width: "12%"
      },
      {
        title: "Desc_Customer",
        key: "customerName",
        isSortable: false,
        width: "12%"
      },
      {
        title: "Desc_Outlet",
        key: "outletName",
        isSortable: false,
        width: "11%"
      },
      {
        title: "Desc_Employee_Name",
        key: "employeeName",
        isSortable: false,
        width: "11%"
      },
      {
        title: "Desc_Order_Date",
        key: "orderDate",
        isSortable: true,
        width: "12%",
        isDate: true
      },
      {
        title: "Desc_Reject_Date",
        key: "rejectDate",
        isSortable: true,
        width: "12%",
        isDate: true
      },
      {
        title: "Desc_Reject_Reason",
        key: "rejectReason",
        isSortable: false,
        width: "11%"
      },

      {
        title: "Desc_Order_Type",
        key: "orderType",
        isSortable: false,
        width: "10%"
      },
    ]
  };
  ControlTransactionDivisionLevel = false;//reema

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  query: OrderListFilter = {
    customListFilter: {
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    orderOperation: OrderOperation.GetRejected, //reema
    orderStatus: OrderStatus.Rejected, //reema
    customerId: -1,
    outletId: -1,
    employeeId: -1
  };




  operationSummaryData: IOperationSummary = {
    operationData: {},
    formProcessMode: FormProcessMode.RejectedOrder,
    formTitle: "Desc_Order_Reject_Summary"
  };
  showViewSummarySlider = false;

  isEditMode = false;
  showOrderSlider = false;
  orderSignature = "";

  constructor(
    private sessionData: SessionDataProvider,
    private validationService: ValidationService,
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private OrderRejectedService: OrderRejectedService,
    private navService : NavBarService
  ) { }
  showSharedTable: boolean = false
  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus}
    )

      this.showSharedTable = this.navService.tourStatus;
    this.coreSession.SetTitle("Rejcted Orders");
    if (this.isDivisionLevel())
      this.tableData.columns.push({ title: "Desc_Division", key: "division", isSortable: true, width: "15%" });

    this.populateNewOrderList();
    this.addActions();
    if (this.tableData.multiSelectionOperations && this.tableData.multiSelectionOperations.length > 0) {
      this.tableData.isMultiSelection = true;
    }
  }
  isDivisionLevel() {
    return (this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true")
  }


  getMaxDocumentSequence() {
    let documentSequenceFilter = {
      divisionId: -1,
      employeeId: this.coreSession.CurrentOperator.employeeId,
      DocumentType: DocumentTypes.Order
    };
    this.coreSession.ModalLoading.Show();
    this.validationService
      .getMaxDocumentSequence(documentSequenceFilter)
      .subscribe(
        response => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            // this.router.navigate(['/' + ConstantURLs.orderURL, ConstantURLs.addPendingOrderURL]);
            this.orderId = response.data;
            this.orderSignature = null;
            this.isEditMode = false;
            this.showOrderSlider = true;
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              response.message
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }

  closeOrderSlider() {
    this.orderId = "";
    this.orderSignature = null;
    this.isEditMode = false;
    this.showOrderSlider = false;
  }

  onSaveComplete() {
    this.closeOrderSlider();
    this.populateNewOrderList();
  }

  addActions() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.rejectOrdersURL, MenuActions.Disapprove)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.Activate,
        title: "Desc_Reactivate",
        icon: "fa-solid fa-check",
        color: "#02b875"
      });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.rejectOrdersURL, MenuActions.View)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.View,
        title: 'Desc_View',
        icon: 'fa-regular fa-eye',
        color: '#12344d'
      });
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.rejectOrdersURL, MenuActions.Approve)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.approve,
        title: "Desc_Approve_Cancelation",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      });
    }



  }

  populateNewOrderList() {
    this.coreSession.ModalLoading.Show();
    this.OrderRejectedService.getOrders(this.query).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = <SharedTableResult>response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  ApproveOrder(order: any) {
    order.orderOperation = OrderOperation.GetRejected;
    order.orderStatus = OrderStatus.Rejected;
    order.orderStatusFromUI = OrderStatus.Rejected;
    this.coreSession.ModalLoading.Show();
    this.OrderRejectedService.approveOrder(order).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.OrderApproved)
          );
          this.populateNewOrderList();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  reactiveSelectedOrder(order: any) {
    order.orderOperation = OrderOperation.DisApprove;
    order.orderStatus = OrderStatus.New;
    order.orderStatusFromUI = OrderStatus.Rejected;
    this.coreSession.ModalLoading.Show();
    this.OrderRejectedService.disapproveOrder(order).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.OrderApproved)
          );
          this.populateNewOrderList();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.View:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.pendingOrdersURL, MenuActions.View)) {
          this.viewTransaction(event.object.orderSignature);
        }
        break;
      case RowOperation.approve:
        this.onApproveClicked(event.object);
        break;
      case RowOperation.Activate:
        this.onReactivateOrderClick(event.object);
        break;



    }
  }

  onReactivateOrderClick(order: any) {

    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(ConstantMessages.MsgReactivateConfirmation),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.WarningCaption)
    ).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {
        this.reactiveSelectedOrder(order);
      }
    });

  }

  onApproveClicked(order: any) {
    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(ConstantMessages.ApproveConfirmation),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.WarningCaption)
    ).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {
        this.ApproveOrder(order);
      }
    });
  }

  onTableFilterChanged(query: any) {
    this.query.customListFilter = query;
    this.populateNewOrderList();
  }

  onFindButtonClicked(result) {
    this.query.customListFilter.page = 0;
    this.query.customerId = result.customerId;
    this.query.outletId = result.outletId;
    this.query.employeeId = result.employeeId;
    this.query.orderDateRange = result.transactionDate;
    this.query.RejectDateRange = result.secondDate;//reema
    if (this.isDivisionLevel())
      this.query.divisionId = result.divisionId;
    else
      this.query.divisionId = -1;
    this.populateNewOrderList();
  }

  closeViewSummarySlider() {
    this.selectedOrder = null;
    this.operationSummaryData = null;
    this.showViewSummarySlider = false;
  }

  viewTransaction(signature: string) {
    this.coreSession.ModalLoading.Show();
    let query: OrderListFilter = {};
    query.orderSignature = signature;
    query.isViewMode = true;
    query.orderStatus = OrderStatus.Rejected;
    query.orderOperation = OrderOperation.GetRejected;
    this.OrderRejectedService.getOrder(query).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.selectedOrder = response.data;
          this.operationSummaryData = {
            operationData: this.selectedOrder,
            formProcessMode: FormProcessMode.RejectedOrder,
            formTitle: "Desc_Order_Reject_Summary"
          };
          this.showViewSummarySlider = true;
        } else {
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

}
