import { RouterModule, Routes } from '@angular/router';
import { NgModule } from '@angular/core';
import { AuthGuard } from '../../core/auth/auth.gurad';
import { ConstantURLs } from '../../shared/models/constants/constant-URL';
import { QualityControlsMainComponent } from './quality-controls-main/quality-controls-main.component';
import { QualityControlListComponent } from '../master-data-definition/quality-control-management/quality-control-list/quality-control-list.component';
import { CustomerSurveyEntryComponent } from '../master-data-definition/survey-managment/customer-survey/customer-survey-entry/customer-survey-entry.component';
import { QualityControlReadingListComponent } from '../master-data-definition/quality-control-management/quality-control-reading-list/quality-control-reading-list.component';
import { QualityControlReadingEntryComponent } from '../master-data-definition/quality-control-management/quality-control-reading-entry/quality-control-reading-entry.component';




const qualityControlRouting: Routes = [
    {
      path: '',
      canActivate: [AuthGuard],
      component: QualityControlsMainComponent,
      children: [
        {
            path: ConstantURLs.qcDefinitionURL,
            canActivate: [AuthGuard],
            component: QualityControlListComponent,
            children: [
              {
                path: ConstantURLs.addQualitycontrolFormURL,
                canActivate: [AuthGuard],
                component: CustomerSurveyEntryComponent
              }
            ]
          },
        {
          path: ConstantURLs.qcReadingURL,
          canActivate: [AuthGuard],
          component: QualityControlReadingListComponent,
          children: [
            {
              path: ConstantURLs.addQualitycontrolFormURL,
              canActivate: [AuthGuard],
              component: QualityControlReadingEntryComponent
            }
          ]
        },
        { path: '', redirectTo: '/' + ConstantURLs.qcMainURL + '/' + ConstantURLs.qcDefinitionURL , pathMatch: 'full' }
      ]
    }
  ];
  @NgModule({
    imports: [RouterModule.forChild(qualityControlRouting)],
    exports: [RouterModule]
  })
  export class QualityControlRoutingModule {}
