import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { QualityControlRoutingModule } from "./quality-control-routing.module";
import { SharedModule } from "../../shared/shared.module";
import { OwlDateTimeModule, OwlNativeDateTimeModule } from "ng-pick-datetime";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { TranslateModule } from "@ngx-translate/core";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { NgSelectModule } from "@ng-select/ng-select";
import { GaugeChartModule } from "angular-gauge-chart";
import { QualityControlsMainComponent } from "./quality-controls-main/quality-controls-main.component";
import { SurveyManagmentModule } from "../master-data-definition/survey-managment/survey.managment.module";
import { QualityControlReadingListComponent } from "../master-data-definition/quality-control-management/quality-control-reading-list/quality-control-reading-list.component";
import { QualityControlReadingEntryComponent } from "../master-data-definition/quality-control-management/quality-control-reading-entry/quality-control-reading-entry.component";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";

@NgModule({
  declarations: [
    QualityControlsMainComponent,
    QualityControlReadingListComponent,
    QualityControlReadingEntryComponent,
  ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    QualityControlRoutingModule,
    SharedModule,
    OwlDateTimeModule,
    OwlNativeDateTimeModule,
    NgbModule,
    TranslateModule.forChild(),
    NgSelectModule,
    NgMultiSelectDropDownModule,
    GaugeChartModule,
    SurveyManagmentModule,
    NgOptionHighlightModule,
  ],
  providers: [],
})
export class QualityControlModule {}
