import { Component, OnInit } from '@angular/core';
import { SessionDataProvider } from '../../../core/session-data-provider.service';

@Component({
  selector: 'app-quality-controls-main',
  templateUrl: './quality-controls-main.component.html',
  styleUrls: ['./quality-controls-main.component.css']
})
export class QualityControlsMainComponent implements OnInit {

  navLinks: any[];
  hideTabs: boolean = false;
  indexCounter: number = -1;

  constructor(private sessionDataProvider: SessionDataProvider) { }

  ngOnInit() {
    this.prepareNavigation();
    this.navLinks[0].isActive = true;

  }
  prepareNavigation() {
    this.navLinks = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable) {
      if (menu.menuId.startsWith('1300-')) {
        this.indexCounter = this.indexCounter + 1
        let newName = {
          label: menu.menuName,
          link: menu.url,
          isActive: false,
          index: this.indexCounter
        };
        this.navLinks.push(newName);
      }
    }
  }
}
