import { Injectable, Inject } from '@angular/core';
import 'rxjs/add/operator/map';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../core/core.session';
import { ResponseModel } from '../../shared/models/api-models/api-models';

@Injectable({
  providedIn: 'root'
})
export class IncidentService {
  private url = '';
  private httpOptions;

  constructor(
    private http: HttpClient,
    private coreSession: CoreSession,
    @Inject("BASE_URL") baseUrl: string
  ) {
    this.url = baseUrl + 'Incident/';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json'
      })
    };
  }

  getIncidentListSharedTable(filter: any) {
    const urlValue: string = this.url + 'GetIncidentListSharedTable';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }

  saveIncident(incidentObj: any) {
    const urlValue: string = this.url + 'InsertIncident';
    return this.http.post(urlValue, JSON.stringify(incidentObj), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }

  getIncidentData(incidentId: any) {
    const urlValue = this.url + 'GetIncidentData';
    return this.http.post<ResponseModel>(urlValue, incidentId).map(response => {
      const res = new ResponseModel();
      res.data = response["data"];
      res.message = response["message"];
      res.status = response["status"];
      return res;
    });
  }

  updateIncidentStatus(incident) {
    const urlValue: string = this.url + 'UpdateIncidentStatus';
    return this.http.post(urlValue, incident).map(
      (response) => {
        let result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
}




